/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.annotation.IntDef;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrintAttributes
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int COLOR_MODE_MONOCHROME = 1;
    public static int COLOR_MODE_COLOR = 2;
    private static int VALID_COLOR_MODES = 3;
    public static int DUPLEX_MODE_NONE = 1;
    public static int DUPLEX_MODE_LONG_EDGE = 2;
    public static int DUPLEX_MODE_SHORT_EDGE = 4;
    private static int VALID_DUPLEX_MODES = 7;
    private MediaSize mMediaSize;
    private Resolution mResolution;
    private Margins mMinMargins;
    private int mColorMode;
    private int mDuplexMode;
    public static Parcelable.Creator<PrintAttributes> CREATOR;

    private void $$robo$$android_print_PrintAttributes$__constructor__() {
    }

    private void $$robo$$android_print_PrintAttributes$__constructor__(Parcel parcel) {
        this.mMediaSize = parcel.readInt() == 1 ? MediaSize.createFromParcel(parcel) : null;
        this.mResolution = parcel.readInt() == 1 ? Resolution.createFromParcel(parcel) : null;
        this.mMinMargins = parcel.readInt() == 1 ? Margins.createFromParcel(parcel) : null;
        this.mColorMode = parcel.readInt();
        if (this.mColorMode != 0) {
            PrintAttributes.enforceValidColorMode(this.mColorMode);
        }
        this.mDuplexMode = parcel.readInt();
        if (this.mDuplexMode != 0) {
            PrintAttributes.enforceValidDuplexMode(this.mDuplexMode);
        }
    }

    private final MediaSize $$robo$$android_print_PrintAttributes$getMediaSize() {
        return this.mMediaSize;
    }

    private final void $$robo$$android_print_PrintAttributes$setMediaSize(MediaSize mediaSize) {
        this.mMediaSize = mediaSize;
    }

    private final Resolution $$robo$$android_print_PrintAttributes$getResolution() {
        return this.mResolution;
    }

    private final void $$robo$$android_print_PrintAttributes$setResolution(Resolution resolution) {
        this.mResolution = resolution;
    }

    private final Margins $$robo$$android_print_PrintAttributes$getMinMargins() {
        return this.mMinMargins;
    }

    private final void $$robo$$android_print_PrintAttributes$setMinMargins(Margins margins) {
        this.mMinMargins = margins;
    }

    private final int $$robo$$android_print_PrintAttributes$getColorMode() {
        return this.mColorMode;
    }

    private final void $$robo$$android_print_PrintAttributes$setColorMode(int colorMode) {
        PrintAttributes.enforceValidColorMode(colorMode);
        this.mColorMode = colorMode;
    }

    private final boolean $$robo$$android_print_PrintAttributes$isPortrait() {
        return this.mMediaSize.isPortrait();
    }

    private final int $$robo$$android_print_PrintAttributes$getDuplexMode() {
        return this.mDuplexMode;
    }

    private final void $$robo$$android_print_PrintAttributes$setDuplexMode(int duplexMode) {
        PrintAttributes.enforceValidDuplexMode(duplexMode);
        this.mDuplexMode = duplexMode;
    }

    private final PrintAttributes $$robo$$android_print_PrintAttributes$asPortrait() {
        if (this.isPortrait()) {
            return this;
        }
        PrintAttributes attributes = new PrintAttributes();
        attributes.setMediaSize(this.getMediaSize().asPortrait());
        Resolution oldResolution = this.getResolution();
        Resolution newResolution = new Resolution(oldResolution.getId(), oldResolution.getLabel(), oldResolution.getVerticalDpi(), oldResolution.getHorizontalDpi());
        attributes.setResolution(newResolution);
        attributes.setMinMargins(this.getMinMargins());
        attributes.setColorMode(this.getColorMode());
        attributes.setDuplexMode(this.getDuplexMode());
        return attributes;
    }

    private final PrintAttributes $$robo$$android_print_PrintAttributes$asLandscape() {
        if (!this.isPortrait()) {
            return this;
        }
        PrintAttributes attributes = new PrintAttributes();
        attributes.setMediaSize(this.getMediaSize().asLandscape());
        Resolution oldResolution = this.getResolution();
        Resolution newResolution = new Resolution(oldResolution.getId(), oldResolution.getLabel(), oldResolution.getVerticalDpi(), oldResolution.getHorizontalDpi());
        attributes.setResolution(newResolution);
        attributes.setMinMargins(this.getMinMargins());
        attributes.setColorMode(this.getColorMode());
        attributes.setDuplexMode(this.getDuplexMode());
        return attributes;
    }

    private final void $$robo$$android_print_PrintAttributes$writeToParcel(Parcel parcel, int flags) {
        if (this.mMediaSize != null) {
            parcel.writeInt(1);
            this.mMediaSize.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mResolution != null) {
            parcel.writeInt(1);
            this.mResolution.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        if (this.mMinMargins != null) {
            parcel.writeInt(1);
            this.mMinMargins.writeToParcel(parcel);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.mColorMode);
        parcel.writeInt(this.mDuplexMode);
    }

    private final int $$robo$$android_print_PrintAttributes$describeContents() {
        return 0;
    }

    private final int $$robo$$android_print_PrintAttributes$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mColorMode;
        result = 31 * result + this.mDuplexMode;
        result = 31 * result + (this.mMinMargins == null ? 0 : this.mMinMargins.hashCode());
        result = 31 * result + (this.mMediaSize == null ? 0 : this.mMediaSize.hashCode());
        result = 31 * result + (this.mResolution == null ? 0 : this.mResolution.hashCode());
        return result;
    }

    private final boolean $$robo$$android_print_PrintAttributes$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintAttributes other = (PrintAttributes)obj;
        if (this.mColorMode != other.mColorMode) {
            return false;
        }
        if (this.mDuplexMode != other.mDuplexMode) {
            return false;
        }
        if (this.mMinMargins == null ? other.mMinMargins != null : !this.mMinMargins.equals(other.mMinMargins)) {
            return false;
        }
        if (this.mMediaSize == null ? other.mMediaSize != null : !this.mMediaSize.equals(other.mMediaSize)) {
            return false;
        }
        return !(this.mResolution == null ? other.mResolution != null : !this.mResolution.equals(other.mResolution));
    }

    private final String $$robo$$android_print_PrintAttributes$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrintAttributes{");
        builder.append("mediaSize: ").append(this.mMediaSize);
        if (this.mMediaSize != null) {
            builder.append(", orientation: ").append(this.mMediaSize.isPortrait() ? "portrait" : "landscape");
        } else {
            builder.append(", orientation: ").append("null");
        }
        builder.append(", resolution: ").append(this.mResolution);
        builder.append(", minMargins: ").append(this.mMinMargins);
        builder.append(", colorMode: ").append(PrintAttributes.colorModeToString(this.mColorMode));
        builder.append(", duplexMode: ").append(PrintAttributes.duplexModeToString(this.mDuplexMode));
        builder.append("}");
        return builder.toString();
    }

    private final void $$robo$$android_print_PrintAttributes$clear() {
        this.mMediaSize = null;
        this.mResolution = null;
        this.mMinMargins = null;
        this.mColorMode = 0;
        this.mDuplexMode = 0;
    }

    private final void $$robo$$android_print_PrintAttributes$copyFrom(PrintAttributes other) {
        this.mMediaSize = other.mMediaSize;
        this.mResolution = other.mResolution;
        this.mMinMargins = other.mMinMargins;
        this.mColorMode = other.mColorMode;
        this.mDuplexMode = other.mDuplexMode;
    }

    private static final String $$robo$$android_print_PrintAttributes$colorModeToString(int colorMode) {
        switch (colorMode) {
            case 1: {
                return "COLOR_MODE_MONOCHROME";
            }
            case 2: {
                return "COLOR_MODE_COLOR";
            }
        }
        return "COLOR_MODE_UNKNOWN";
    }

    private static final String $$robo$$android_print_PrintAttributes$duplexModeToString(int duplexMode) {
        switch (duplexMode) {
            case 1: {
                return "DUPLEX_MODE_NONE";
            }
            case 2: {
                return "DUPLEX_MODE_LONG_EDGE";
            }
            case 4: {
                return "DUPLEX_MODE_SHORT_EDGE";
            }
        }
        return "DUPLEX_MODE_UNKNOWN";
    }

    private static final void $$robo$$android_print_PrintAttributes$enforceValidColorMode(int colorMode) {
        if ((colorMode & 3) == 0 || Integer.bitCount(colorMode) != 1) {
            throw new IllegalArgumentException("invalid color mode: " + colorMode);
        }
    }

    private static final void $$robo$$android_print_PrintAttributes$enforceValidDuplexMode(int duplexMode) {
        if ((duplexMode & 7) == 0 || Integer.bitCount(duplexMode) != 1) {
            throw new IllegalArgumentException("invalid duplex mode: " + duplexMode);
        }
    }

    private /* synthetic */ void $$robo$$android_print_PrintAttributes$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PrintAttributes>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_print_PrintAttributes_1$__constructor__() {
            }

            private final PrintAttributes $$robo$$android_print_PrintAttributes_1$createFromParcel(Parcel parcel) {
                return new PrintAttributes(parcel);
            }

            private final PrintAttributes[] $$robo$$android_print_PrintAttributes_1$newArray(int size) {
                return new PrintAttributes[size];
            }

            private void __constructor__() {
                this.$$robo$$android_print_PrintAttributes_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_1$__constructor__(), 0, this);
            }

            @Override
            public PrintAttributes createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_print_PrintAttributes_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PrintAttributes[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_print_PrintAttributes_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_print_PrintAttributes$__constructor__();
    }

    PrintAttributes() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes$__constructor__(), 0, this);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_print_PrintAttributes$__constructor__(parcel);
    }

    private PrintAttributes(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public MediaSize getMediaSize() {
        return InvokeDynamicSupport.bootstrap("getMediaSize", $$robo$$android_print_PrintAttributes$getMediaSize(), 0, this);
    }

    public void setMediaSize(MediaSize mediaSize) {
        InvokeDynamicSupport.bootstrap("setMediaSize", $$robo$$android_print_PrintAttributes$setMediaSize(android.print.PrintAttributes$MediaSize ), 0, this, mediaSize);
    }

    public Resolution getResolution() {
        return InvokeDynamicSupport.bootstrap("getResolution", $$robo$$android_print_PrintAttributes$getResolution(), 0, this);
    }

    public void setResolution(Resolution resolution) {
        InvokeDynamicSupport.bootstrap("setResolution", $$robo$$android_print_PrintAttributes$setResolution(android.print.PrintAttributes$Resolution ), 0, this, resolution);
    }

    public Margins getMinMargins() {
        return InvokeDynamicSupport.bootstrap("getMinMargins", $$robo$$android_print_PrintAttributes$getMinMargins(), 0, this);
    }

    public void setMinMargins(Margins margins) {
        InvokeDynamicSupport.bootstrap("setMinMargins", $$robo$$android_print_PrintAttributes$setMinMargins(android.print.PrintAttributes$Margins ), 0, this, margins);
    }

    public int getColorMode() {
        return (int)InvokeDynamicSupport.bootstrap("getColorMode", $$robo$$android_print_PrintAttributes$getColorMode(), 0, this);
    }

    public void setColorMode(int n) {
        InvokeDynamicSupport.bootstrap("setColorMode", $$robo$$android_print_PrintAttributes$setColorMode(int ), 0, this, n);
    }

    public boolean isPortrait() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPortrait", $$robo$$android_print_PrintAttributes$isPortrait(), 0, this);
    }

    public int getDuplexMode() {
        return (int)InvokeDynamicSupport.bootstrap("getDuplexMode", $$robo$$android_print_PrintAttributes$getDuplexMode(), 0, this);
    }

    public void setDuplexMode(int n) {
        InvokeDynamicSupport.bootstrap("setDuplexMode", $$robo$$android_print_PrintAttributes$setDuplexMode(int ), 0, this, n);
    }

    public PrintAttributes asPortrait() {
        return InvokeDynamicSupport.bootstrap("asPortrait", $$robo$$android_print_PrintAttributes$asPortrait(), 0, this);
    }

    public PrintAttributes asLandscape() {
        return InvokeDynamicSupport.bootstrap("asLandscape", $$robo$$android_print_PrintAttributes$asLandscape(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrintAttributes$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_print_PrintAttributes$describeContents(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrintAttributes$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrintAttributes$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrintAttributes$toString(), 0, this);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_print_PrintAttributes$clear(), 0, this);
    }

    public void copyFrom(PrintAttributes printAttributes) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_print_PrintAttributes$copyFrom(android.print.PrintAttributes ), 0, this, printAttributes);
    }

    static String colorModeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("colorModeToString", $$robo$$android_print_PrintAttributes$colorModeToString(int ), 0, (int)n);
    }

    static String duplexModeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("duplexModeToString", $$robo$$android_print_PrintAttributes$duplexModeToString(int ), 0, (int)n);
    }

    static void enforceValidColorMode(int n) {
        InvokeDynamicSupport.bootstrapStatic("enforceValidColorMode", $$robo$$android_print_PrintAttributes$enforceValidColorMode(int ), 0, (int)n);
    }

    static void enforceValidDuplexMode(int n) {
        InvokeDynamicSupport.bootstrapStatic("enforceValidDuplexMode", $$robo$$android_print_PrintAttributes$enforceValidDuplexMode(int ), 0, (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_print_PrintAttributes$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PrintAttributes.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintAttributes)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PrintAttributes mAttributes;

        private void $$robo$$android_print_PrintAttributes_Builder$__constructor__() {
            this.mAttributes = new PrintAttributes();
        }

        private final Builder $$robo$$android_print_PrintAttributes_Builder$setMediaSize(MediaSize mediaSize) {
            this.mAttributes.setMediaSize(mediaSize);
            return this;
        }

        private final Builder $$robo$$android_print_PrintAttributes_Builder$setResolution(Resolution resolution) {
            this.mAttributes.setResolution(resolution);
            return this;
        }

        private final Builder $$robo$$android_print_PrintAttributes_Builder$setMinMargins(Margins margins) {
            this.mAttributes.setMinMargins(margins);
            return this;
        }

        private final Builder $$robo$$android_print_PrintAttributes_Builder$setColorMode(int colorMode) {
            this.mAttributes.setColorMode(colorMode);
            return this;
        }

        private final Builder $$robo$$android_print_PrintAttributes_Builder$setDuplexMode(int duplexMode) {
            this.mAttributes.setDuplexMode(duplexMode);
            return this;
        }

        private final PrintAttributes $$robo$$android_print_PrintAttributes_Builder$build() {
            return this.mAttributes;
        }

        private void __constructor__() {
            this.$$robo$$android_print_PrintAttributes_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_Builder$__constructor__(), 0, this);
        }

        public Builder setMediaSize(MediaSize mediaSize) {
            return InvokeDynamicSupport.bootstrap("setMediaSize", $$robo$$android_print_PrintAttributes_Builder$setMediaSize(android.print.PrintAttributes$MediaSize ), 0, this, mediaSize);
        }

        public Builder setResolution(Resolution resolution) {
            return InvokeDynamicSupport.bootstrap("setResolution", $$robo$$android_print_PrintAttributes_Builder$setResolution(android.print.PrintAttributes$Resolution ), 0, this, resolution);
        }

        public Builder setMinMargins(Margins margins) {
            return InvokeDynamicSupport.bootstrap("setMinMargins", $$robo$$android_print_PrintAttributes_Builder$setMinMargins(android.print.PrintAttributes$Margins ), 0, this, margins);
        }

        public Builder setColorMode(int n) {
            return InvokeDynamicSupport.bootstrap("setColorMode", $$robo$$android_print_PrintAttributes_Builder$setColorMode(int ), 0, this, n);
        }

        public Builder setDuplexMode(int n) {
            return InvokeDynamicSupport.bootstrap("setDuplexMode", $$robo$$android_print_PrintAttributes_Builder$setDuplexMode(int ), 0, this, n);
        }

        public PrintAttributes build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_print_PrintAttributes_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Margins
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Margins NO_MARGINS;
        private int mLeftMils;
        private int mTopMils;
        private int mRightMils;
        private int mBottomMils;

        private void $$robo$$android_print_PrintAttributes_Margins$__constructor__(int leftMils, int topMils, int rightMils, int bottomMils) {
            this.mTopMils = topMils;
            this.mLeftMils = leftMils;
            this.mRightMils = rightMils;
            this.mBottomMils = bottomMils;
        }

        private final int $$robo$$android_print_PrintAttributes_Margins$getLeftMils() {
            return this.mLeftMils;
        }

        private final int $$robo$$android_print_PrintAttributes_Margins$getTopMils() {
            return this.mTopMils;
        }

        private final int $$robo$$android_print_PrintAttributes_Margins$getRightMils() {
            return this.mRightMils;
        }

        private final int $$robo$$android_print_PrintAttributes_Margins$getBottomMils() {
            return this.mBottomMils;
        }

        private final void $$robo$$android_print_PrintAttributes_Margins$writeToParcel(Parcel parcel) {
            parcel.writeInt(this.mLeftMils);
            parcel.writeInt(this.mTopMils);
            parcel.writeInt(this.mRightMils);
            parcel.writeInt(this.mBottomMils);
        }

        private static final Margins $$robo$$android_print_PrintAttributes_Margins$createFromParcel(Parcel parcel) {
            return new Margins(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        private final int $$robo$$android_print_PrintAttributes_Margins$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mBottomMils;
            result = 31 * result + this.mLeftMils;
            result = 31 * result + this.mRightMils;
            result = 31 * result + this.mTopMils;
            return result;
        }

        private final boolean $$robo$$android_print_PrintAttributes_Margins$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Margins other = (Margins)obj;
            if (this.mBottomMils != other.mBottomMils) {
                return false;
            }
            if (this.mLeftMils != other.mLeftMils) {
                return false;
            }
            if (this.mRightMils != other.mRightMils) {
                return false;
            }
            return this.mTopMils == other.mTopMils;
        }

        private final String $$robo$$android_print_PrintAttributes_Margins$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Margins{");
            builder.append("leftMils: ").append(this.mLeftMils);
            builder.append(", topMils: ").append(this.mTopMils);
            builder.append(", rightMils: ").append(this.mRightMils);
            builder.append(", bottomMils: ").append(this.mBottomMils);
            builder.append("}");
            return builder.toString();
        }

        static void __staticInitializer__() {
            NO_MARGINS = new Margins(0, 0, 0, 0);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$android_print_PrintAttributes_Margins$__constructor__(n, n2, n3, n4);
        }

        public Margins(int n, int n2, int n3, int n4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_Margins$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        public int getLeftMils() {
            return (int)InvokeDynamicSupport.bootstrap("getLeftMils", $$robo$$android_print_PrintAttributes_Margins$getLeftMils(), 0, this);
        }

        public int getTopMils() {
            return (int)InvokeDynamicSupport.bootstrap("getTopMils", $$robo$$android_print_PrintAttributes_Margins$getTopMils(), 0, this);
        }

        public int getRightMils() {
            return (int)InvokeDynamicSupport.bootstrap("getRightMils", $$robo$$android_print_PrintAttributes_Margins$getRightMils(), 0, this);
        }

        public int getBottomMils() {
            return (int)InvokeDynamicSupport.bootstrap("getBottomMils", $$robo$$android_print_PrintAttributes_Margins$getBottomMils(), 0, this);
        }

        void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrintAttributes_Margins$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        static Margins createFromParcel(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("createFromParcel", $$robo$$android_print_PrintAttributes_Margins$createFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrintAttributes_Margins$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrintAttributes_Margins$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrintAttributes_Margins$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Margins.class);
        }

        public /* synthetic */ Margins() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Margins)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Resolution
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mId;
        private String mLabel;
        private int mHorizontalDpi;
        private int mVerticalDpi;

        private void $$robo$$android_print_PrintAttributes_Resolution$__constructor__(String id2, String label, int horizontalDpi, int verticalDpi) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("id cannot be empty.");
            }
            if (TextUtils.isEmpty(label)) {
                throw new IllegalArgumentException("label cannot be empty.");
            }
            if (horizontalDpi <= 0) {
                throw new IllegalArgumentException("horizontalDpi cannot be less than or equal to zero.");
            }
            if (verticalDpi <= 0) {
                throw new IllegalArgumentException("verticalDpi cannot be less than or equal to zero.");
            }
            this.mId = id2;
            this.mLabel = label;
            this.mHorizontalDpi = horizontalDpi;
            this.mVerticalDpi = verticalDpi;
        }

        private final String $$robo$$android_print_PrintAttributes_Resolution$getId() {
            return this.mId;
        }

        private final String $$robo$$android_print_PrintAttributes_Resolution$getLabel() {
            return this.mLabel;
        }

        private final int $$robo$$android_print_PrintAttributes_Resolution$getHorizontalDpi() {
            return this.mHorizontalDpi;
        }

        private final int $$robo$$android_print_PrintAttributes_Resolution$getVerticalDpi() {
            return this.mVerticalDpi;
        }

        private final void $$robo$$android_print_PrintAttributes_Resolution$writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeInt(this.mHorizontalDpi);
            parcel.writeInt(this.mVerticalDpi);
        }

        private static final Resolution $$robo$$android_print_PrintAttributes_Resolution$createFromParcel(Parcel parcel) {
            return new Resolution(parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt());
        }

        private final int $$robo$$android_print_PrintAttributes_Resolution$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mHorizontalDpi;
            result = 31 * result + this.mVerticalDpi;
            return result;
        }

        private final boolean $$robo$$android_print_PrintAttributes_Resolution$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolution other = (Resolution)obj;
            if (this.mHorizontalDpi != other.mHorizontalDpi) {
                return false;
            }
            return this.mVerticalDpi == other.mVerticalDpi;
        }

        private final String $$robo$$android_print_PrintAttributes_Resolution$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Resolution{");
            builder.append("id: ").append(this.mId);
            builder.append(", label: ").append(this.mLabel);
            builder.append(", horizontalDpi: ").append(this.mHorizontalDpi);
            builder.append(", verticalDpi: ").append(this.mVerticalDpi);
            builder.append("}");
            return builder.toString();
        }

        private void __constructor__(String string2, String string3, int n, int n2) {
            this.$$robo$$android_print_PrintAttributes_Resolution$__constructor__(string2, string3, n, n2);
        }

        public Resolution(String string2, String string3, int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_Resolution$__constructor__(java.lang.String java.lang.String int int ), 0, this, string2, string3, n, n2);
        }

        public String getId() {
            return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_print_PrintAttributes_Resolution$getId(), 0, this);
        }

        public String getLabel() {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_print_PrintAttributes_Resolution$getLabel(), 0, this);
        }

        public int getHorizontalDpi() {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalDpi", $$robo$$android_print_PrintAttributes_Resolution$getHorizontalDpi(), 0, this);
        }

        public int getVerticalDpi() {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalDpi", $$robo$$android_print_PrintAttributes_Resolution$getVerticalDpi(), 0, this);
        }

        void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrintAttributes_Resolution$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        static Resolution createFromParcel(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("createFromParcel", $$robo$$android_print_PrintAttributes_Resolution$createFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrintAttributes_Resolution$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrintAttributes_Resolution$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrintAttributes_Resolution$toString(), 0, this);
        }

        public /* synthetic */ Resolution() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Resolution)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MediaSize
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String LOG_TAG = "MediaSize";
        private static Map<String, MediaSize> sIdToMediaSizeMap;
        public static MediaSize UNKNOWN_PORTRAIT;
        public static MediaSize UNKNOWN_LANDSCAPE;
        public static MediaSize ISO_A0;
        public static MediaSize ISO_A1;
        public static MediaSize ISO_A2;
        public static MediaSize ISO_A3;
        public static MediaSize ISO_A4;
        public static MediaSize ISO_A5;
        public static MediaSize ISO_A6;
        public static MediaSize ISO_A7;
        public static MediaSize ISO_A8;
        public static MediaSize ISO_A9;
        public static MediaSize ISO_A10;
        public static MediaSize ISO_B0;
        public static MediaSize ISO_B1;
        public static MediaSize ISO_B2;
        public static MediaSize ISO_B3;
        public static MediaSize ISO_B4;
        public static MediaSize ISO_B5;
        public static MediaSize ISO_B6;
        public static MediaSize ISO_B7;
        public static MediaSize ISO_B8;
        public static MediaSize ISO_B9;
        public static MediaSize ISO_B10;
        public static MediaSize ISO_C0;
        public static MediaSize ISO_C1;
        public static MediaSize ISO_C2;
        public static MediaSize ISO_C3;
        public static MediaSize ISO_C4;
        public static MediaSize ISO_C5;
        public static MediaSize ISO_C6;
        public static MediaSize ISO_C7;
        public static MediaSize ISO_C8;
        public static MediaSize ISO_C9;
        public static MediaSize ISO_C10;
        public static MediaSize NA_LETTER;
        public static MediaSize NA_GOVT_LETTER;
        public static MediaSize NA_LEGAL;
        public static MediaSize NA_JUNIOR_LEGAL;
        public static MediaSize NA_LEDGER;
        public static MediaSize NA_TABLOID;
        public static MediaSize NA_INDEX_3X5;
        public static MediaSize NA_INDEX_4X6;
        public static MediaSize NA_INDEX_5X8;
        public static MediaSize NA_MONARCH;
        public static MediaSize NA_QUARTO;
        public static MediaSize NA_FOOLSCAP;
        public static MediaSize ROC_8K;
        public static MediaSize ROC_16K;
        public static MediaSize PRC_1;
        public static MediaSize PRC_2;
        public static MediaSize PRC_3;
        public static MediaSize PRC_4;
        public static MediaSize PRC_5;
        public static MediaSize PRC_6;
        public static MediaSize PRC_7;
        public static MediaSize PRC_8;
        public static MediaSize PRC_9;
        public static MediaSize PRC_10;
        public static MediaSize PRC_16K;
        public static MediaSize OM_PA_KAI;
        public static MediaSize OM_DAI_PA_KAI;
        public static MediaSize OM_JUURO_KU_KAI;
        public static MediaSize JIS_B10;
        public static MediaSize JIS_B9;
        public static MediaSize JIS_B8;
        public static MediaSize JIS_B7;
        public static MediaSize JIS_B6;
        public static MediaSize JIS_B5;
        public static MediaSize JIS_B4;
        public static MediaSize JIS_B3;
        public static MediaSize JIS_B2;
        public static MediaSize JIS_B1;
        public static MediaSize JIS_B0;
        public static MediaSize JIS_EXEC;
        public static MediaSize JPN_CHOU4;
        public static MediaSize JPN_CHOU3;
        public static MediaSize JPN_CHOU2;
        public static MediaSize JPN_HAGAKI;
        public static MediaSize JPN_OUFUKU;
        public static MediaSize JPN_KAHU;
        public static MediaSize JPN_KAKU2;
        public static MediaSize JPN_YOU4;
        private String mId;
        public String mLabel;
        public String mPackageName;
        public int mLabelResId;
        private int mWidthMils;
        private int mHeightMils;

        private void $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(String id2, String packageName, int labelResId, int widthMils, int heightMils) {
            sIdToMediaSizeMap.put(this.mId, this);
        }

        private void $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(String id2, String label, int widthMils, int heightMils) {
        }

        private static final ArraySet<MediaSize> $$robo$$android_print_PrintAttributes_MediaSize$getAllPredefinedSizes() {
            ArraySet<MediaSize> definedMediaSizes = new ArraySet<MediaSize>(sIdToMediaSizeMap.values());
            definedMediaSizes.remove(UNKNOWN_PORTRAIT);
            definedMediaSizes.remove(UNKNOWN_LANDSCAPE);
            return definedMediaSizes;
        }

        private void $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(String id2, String label, String packageName, int widthMils, int heightMils, int labelResId) {
            this.mPackageName = packageName;
            this.mId = Preconditions.checkStringNotEmpty(id2, "id cannot be empty.");
            this.mLabelResId = labelResId;
            this.mWidthMils = Preconditions.checkArgumentPositive(widthMils, "widthMils cannot be less than or equal to zero.");
            this.mHeightMils = Preconditions.checkArgumentPositive(heightMils, "heightMils cannot be less than or equal to zero.");
            this.mLabel = label;
            Preconditions.checkArgument(!TextUtils.isEmpty(label) != (!TextUtils.isEmpty(packageName) && labelResId != 0), "label cannot be empty.");
        }

        private final String $$robo$$android_print_PrintAttributes_MediaSize$getId() {
            return this.mId;
        }

        private final String $$robo$$android_print_PrintAttributes_MediaSize$getLabel(PackageManager packageManager) {
            if (!TextUtils.isEmpty(this.mPackageName) && this.mLabelResId > 0) {
                try {
                    return packageManager.getResourcesForApplication(this.mPackageName).getString(this.mLabelResId);
                }
                catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
                    Log.w("MediaSize", "Could not load resouce" + this.mLabelResId + " from package " + this.mPackageName);
                }
            }
            return this.mLabel;
        }

        private final int $$robo$$android_print_PrintAttributes_MediaSize$getWidthMils() {
            return this.mWidthMils;
        }

        private final int $$robo$$android_print_PrintAttributes_MediaSize$getHeightMils() {
            return this.mHeightMils;
        }

        private final boolean $$robo$$android_print_PrintAttributes_MediaSize$isPortrait() {
            return this.mHeightMils >= this.mWidthMils;
        }

        private final MediaSize $$robo$$android_print_PrintAttributes_MediaSize$asPortrait() {
            if (this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.min(this.mWidthMils, this.mHeightMils), Math.max(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        private final MediaSize $$robo$$android_print_PrintAttributes_MediaSize$asLandscape() {
            if (!this.isPortrait()) {
                return this;
            }
            return new MediaSize(this.mId, this.mLabel, this.mPackageName, Math.max(this.mWidthMils, this.mHeightMils), Math.min(this.mWidthMils, this.mHeightMils), this.mLabelResId);
        }

        private final void $$robo$$android_print_PrintAttributes_MediaSize$writeToParcel(Parcel parcel) {
            parcel.writeString(this.mId);
            parcel.writeString(this.mLabel);
            parcel.writeString(this.mPackageName);
            parcel.writeInt(this.mWidthMils);
            parcel.writeInt(this.mHeightMils);
            parcel.writeInt(this.mLabelResId);
        }

        private static final MediaSize $$robo$$android_print_PrintAttributes_MediaSize$createFromParcel(Parcel parcel) {
            return new MediaSize(parcel.readString(), parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        private final int $$robo$$android_print_PrintAttributes_MediaSize$hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.mWidthMils;
            result = 31 * result + this.mHeightMils;
            return result;
        }

        private final boolean $$robo$$android_print_PrintAttributes_MediaSize$equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MediaSize other = (MediaSize)obj;
            if (this.mWidthMils != other.mWidthMils) {
                return false;
            }
            return this.mHeightMils == other.mHeightMils;
        }

        private final String $$robo$$android_print_PrintAttributes_MediaSize$toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MediaSize{");
            builder.append("id: ").append(this.mId);
            builder.append(", label: ").append(this.mLabel);
            builder.append(", packageName: ").append(this.mPackageName);
            builder.append(", heightMils: ").append(this.mHeightMils);
            builder.append(", widthMils: ").append(this.mWidthMils);
            builder.append(", labelResId: ").append(this.mLabelResId);
            builder.append("}");
            return builder.toString();
        }

        private static final MediaSize $$robo$$android_print_PrintAttributes_MediaSize$getStandardMediaSizeById(String id2) {
            return sIdToMediaSizeMap.get(id2);
        }

        static void __staticInitializer__() {
            sIdToMediaSizeMap = new ArrayMap<String, MediaSize>();
            UNKNOWN_PORTRAIT = new MediaSize("UNKNOWN_PORTRAIT", "android", 17040252, 1, Integer.MAX_VALUE);
            UNKNOWN_LANDSCAPE = new MediaSize("UNKNOWN_LANDSCAPE", "android", 17040251, Integer.MAX_VALUE, 1);
            ISO_A0 = new MediaSize("ISO_A0", "android", 17040186, 33110, 46810);
            ISO_A1 = new MediaSize("ISO_A1", "android", 17040187, 23390, 33110);
            ISO_A2 = new MediaSize("ISO_A2", "android", 17040189, 16540, 23390);
            ISO_A3 = new MediaSize("ISO_A3", "android", 17040190, 11690, 16540);
            ISO_A4 = new MediaSize("ISO_A4", "android", 17040191, 8270, 11690);
            ISO_A5 = new MediaSize("ISO_A5", "android", 17040192, 5830, 8270);
            ISO_A6 = new MediaSize("ISO_A6", "android", 17040193, 4130, 5830);
            ISO_A7 = new MediaSize("ISO_A7", "android", 17040194, 2910, 4130);
            ISO_A8 = new MediaSize("ISO_A8", "android", 17040195, 2050, 2910);
            ISO_A9 = new MediaSize("ISO_A9", "android", 17040196, 1460, 2050);
            ISO_A10 = new MediaSize("ISO_A10", "android", 17040188, 1020, 1460);
            ISO_B0 = new MediaSize("ISO_B0", "android", 17040197, 39370, 55670);
            ISO_B1 = new MediaSize("ISO_B1", "android", 17040198, 27830, 39370);
            ISO_B2 = new MediaSize("ISO_B2", "android", 17040200, 19690, 27830);
            ISO_B3 = new MediaSize("ISO_B3", "android", 17040201, 13900, 19690);
            ISO_B4 = new MediaSize("ISO_B4", "android", 17040202, 9840, 13900);
            ISO_B5 = new MediaSize("ISO_B5", "android", 17040203, 6930, 9840);
            ISO_B6 = new MediaSize("ISO_B6", "android", 17040204, 4920, 6930);
            ISO_B7 = new MediaSize("ISO_B7", "android", 17040205, 3460, 4920);
            ISO_B8 = new MediaSize("ISO_B8", "android", 17040206, 2440, 3460);
            ISO_B9 = new MediaSize("ISO_B9", "android", 17040207, 1730, 2440);
            ISO_B10 = new MediaSize("ISO_B10", "android", 17040199, 1220, 1730);
            ISO_C0 = new MediaSize("ISO_C0", "android", 17040208, 36100, 51060);
            ISO_C1 = new MediaSize("ISO_C1", "android", 17040209, 25510, 36100);
            ISO_C2 = new MediaSize("ISO_C2", "android", 17040211, 18030, 25510);
            ISO_C3 = new MediaSize("ISO_C3", "android", 17040212, 12760, 18030);
            ISO_C4 = new MediaSize("ISO_C4", "android", 17040213, 9020, 12760);
            ISO_C5 = new MediaSize("ISO_C5", "android", 17040214, 6380, 9020);
            ISO_C6 = new MediaSize("ISO_C6", "android", 17040215, 4490, 6380);
            ISO_C7 = new MediaSize("ISO_C7", "android", 17040216, 3190, 4490);
            ISO_C8 = new MediaSize("ISO_C8", "android", 17040217, 2240, 3190);
            ISO_C9 = new MediaSize("ISO_C9", "android", 17040218, 1570, 2240);
            ISO_C10 = new MediaSize("ISO_C10", "android", 17040210, 1100, 1570);
            NA_LETTER = new MediaSize("NA_LETTER", "android", 17040247, 8500, 11000);
            NA_GOVT_LETTER = new MediaSize("NA_GOVT_LETTER", "android", 17040240, 8000, 10500);
            NA_LEGAL = new MediaSize("NA_LEGAL", "android", 17040246, 8500, 14000);
            NA_JUNIOR_LEGAL = new MediaSize("NA_JUNIOR_LEGAL", "android", 17040244, 8000, 5000);
            NA_LEDGER = new MediaSize("NA_LEDGER", "android", 17040245, 17000, 11000);
            NA_TABLOID = new MediaSize("NA_TABLOID", "android", 17040250, 11000, 17000);
            NA_INDEX_3X5 = new MediaSize("NA_INDEX_3X5", "android", 17040241, 3000, 5000);
            NA_INDEX_4X6 = new MediaSize("NA_INDEX_4X6", "android", 17040242, 4000, 6000);
            NA_INDEX_5X8 = new MediaSize("NA_INDEX_5X8", "android", 17040243, 5000, 8000);
            NA_MONARCH = new MediaSize("NA_MONARCH", "android", 17040248, 7250, 10500);
            NA_QUARTO = new MediaSize("NA_QUARTO", "android", 17040249, 8000, 10000);
            NA_FOOLSCAP = new MediaSize("NA_FOOLSCAP", "android", 17040239, 8000, 13000);
            ROC_8K = new MediaSize("ROC_8K", "android", 17040185, 10629, 15354);
            ROC_16K = new MediaSize("ROC_16K", "android", 17040184, 7677, 10629);
            PRC_1 = new MediaSize("PRC_1", "android", 17040173, 4015, 6496);
            PRC_2 = new MediaSize("PRC_2", "android", 17040176, 4015, 6929);
            PRC_3 = new MediaSize("PRC_3", "android", 17040177, 4921, 6929);
            PRC_4 = new MediaSize("PRC_4", "android", 17040178, 4330, 8189);
            PRC_5 = new MediaSize("PRC_5", "android", 17040179, 4330, 8661);
            PRC_6 = new MediaSize("PRC_6", "android", 17040180, 4724, 12599);
            PRC_7 = new MediaSize("PRC_7", "android", 17040181, 6299, 9055);
            PRC_8 = new MediaSize("PRC_8", "android", 17040182, 4724, 12165);
            PRC_9 = new MediaSize("PRC_9", "android", 17040183, 9016, 12756);
            PRC_10 = new MediaSize("PRC_10", "android", 17040174, 12756, 18032);
            PRC_16K = new MediaSize("PRC_16K", "android", 17040175, 5749, 8465);
            OM_PA_KAI = new MediaSize("OM_PA_KAI", "android", 17040172, 10512, 15315);
            OM_DAI_PA_KAI = new MediaSize("OM_DAI_PA_KAI", "android", 17040170, 10827, 15551);
            OM_JUURO_KU_KAI = new MediaSize("OM_JUURO_KU_KAI", "android", 17040171, 7796, 10827);
            JIS_B10 = new MediaSize("JIS_B10", "android", 17040225, 1259, 1772);
            JIS_B9 = new MediaSize("JIS_B9", "android", 17040233, 1772, 2520);
            JIS_B8 = new MediaSize("JIS_B8", "android", 17040232, 2520, 3583);
            JIS_B7 = new MediaSize("JIS_B7", "android", 17040231, 3583, 5049);
            JIS_B6 = new MediaSize("JIS_B6", "android", 17040230, 5049, 7165);
            JIS_B5 = new MediaSize("JIS_B5", "android", 17040229, 7165, 10118);
            JIS_B4 = new MediaSize("JIS_B4", "android", 17040228, 10118, 14331);
            JIS_B3 = new MediaSize("JIS_B3", "android", 17040227, 14331, 20276);
            JIS_B2 = new MediaSize("JIS_B2", "android", 17040226, 20276, 28661);
            JIS_B1 = new MediaSize("JIS_B1", "android", 17040224, 28661, 40551);
            JIS_B0 = new MediaSize("JIS_B0", "android", 17040223, 40551, 57323);
            JIS_EXEC = new MediaSize("JIS_EXEC", "android", 17040234, 8504, 12992);
            JPN_CHOU4 = new MediaSize("JPN_CHOU4", "android", 17040221, 3543, 8071);
            JPN_CHOU3 = new MediaSize("JPN_CHOU3", "android", 17040220, 4724, 9252);
            JPN_CHOU2 = new MediaSize("JPN_CHOU2", "android", 17040219, 4374, 5748);
            JPN_HAGAKI = new MediaSize("JPN_HAGAKI", "android", 17040222, 3937, 5827);
            JPN_OUFUKU = new MediaSize("JPN_OUFUKU", "android", 17040237, 5827, 7874);
            JPN_KAHU = new MediaSize("JPN_KAHU", "android", 17040235, 9449, 12681);
            JPN_KAKU2 = new MediaSize("JPN_KAKU2", "android", 17040236, 9449, 13071);
            JPN_YOU4 = new MediaSize("JPN_YOU4", "android", 17040238, 4134, 9252);
        }

        private void __constructor__(String string2, String string3, int n, int n2, int n3) {
            this.$$robo$$android_print_PrintAttributes_MediaSize$__constructor__(string2, string3, n, n2, n3);
        }

        public MediaSize(String string2, String string3, int n, int n2, int n3) {
            this(string2, null, string3, n2, n3, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(java.lang.String java.lang.String int int int ), 0, this, string2, string3, n, n2, n3);
        }

        private void __constructor__(String string2, String string3, int n, int n2) {
            this.$$robo$$android_print_PrintAttributes_MediaSize$__constructor__(string2, string3, n, n2);
        }

        public MediaSize(String string2, String string3, int n, int n2) {
            this(string2, string3, null, n, n2, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(java.lang.String java.lang.String int int ), 0, this, string2, string3, n, n2);
        }

        public static ArraySet<MediaSize> getAllPredefinedSizes() {
            return InvokeDynamicSupport.bootstrapStatic("getAllPredefinedSizes", $$robo$$android_print_PrintAttributes_MediaSize$getAllPredefinedSizes(), 0);
        }

        private void __constructor__(String string2, String string3, String string4, int n, int n2, int n3) {
            this.$$robo$$android_print_PrintAttributes_MediaSize$__constructor__(string2, string3, string4, n, n2, n3);
        }

        public MediaSize(String string2, String string3, String string4, int n, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrintAttributes_MediaSize$__constructor__(java.lang.String java.lang.String java.lang.String int int int ), 0, this, string2, string3, string4, n, n2, n3);
        }

        public String getId() {
            return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_print_PrintAttributes_MediaSize$getId(), 0, this);
        }

        public String getLabel(PackageManager packageManager) {
            return InvokeDynamicSupport.bootstrap("getLabel", $$robo$$android_print_PrintAttributes_MediaSize$getLabel(android.content.pm.PackageManager ), 0, this, packageManager);
        }

        public int getWidthMils() {
            return (int)InvokeDynamicSupport.bootstrap("getWidthMils", $$robo$$android_print_PrintAttributes_MediaSize$getWidthMils(), 0, this);
        }

        public int getHeightMils() {
            return (int)InvokeDynamicSupport.bootstrap("getHeightMils", $$robo$$android_print_PrintAttributes_MediaSize$getHeightMils(), 0, this);
        }

        public boolean isPortrait() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPortrait", $$robo$$android_print_PrintAttributes_MediaSize$isPortrait(), 0, this);
        }

        public MediaSize asPortrait() {
            return InvokeDynamicSupport.bootstrap("asPortrait", $$robo$$android_print_PrintAttributes_MediaSize$asPortrait(), 0, this);
        }

        public MediaSize asLandscape() {
            return InvokeDynamicSupport.bootstrap("asLandscape", $$robo$$android_print_PrintAttributes_MediaSize$asLandscape(), 0, this);
        }

        void writeToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrintAttributes_MediaSize$writeToParcel(android.os.Parcel ), 0, this, parcel);
        }

        static MediaSize createFromParcel(Parcel parcel) {
            return InvokeDynamicSupport.bootstrapStatic("createFromParcel", $$robo$$android_print_PrintAttributes_MediaSize$createFromParcel(android.os.Parcel ), 0, (Parcel)parcel);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrintAttributes_MediaSize$hashCode(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrintAttributes_MediaSize$equals(java.lang.Object ), 0, this, object);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrintAttributes_MediaSize$toString(), 0, this);
        }

        public static MediaSize getStandardMediaSizeById(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getStandardMediaSizeById", $$robo$$android_print_PrintAttributes_MediaSize$getStandardMediaSizeById(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(MediaSize.class);
        }

        public /* synthetic */ MediaSize() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaSize)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L, 4L})
    static @interface DuplexMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    static @interface ColorMode {
    }
}

