/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.content.Context;
import android.os.RemoteException;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintDocument;
import android.printservice.PrintService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrintJob
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrintJob";
    private IPrintServiceClient mPrintServiceClient;
    private PrintDocument mDocument;
    private PrintJobInfo mCachedInfo;
    private Context mContext;

    private void $$robo$$android_printservice_PrintJob$__constructor__(Context context, PrintJobInfo jobInfo, IPrintServiceClient client) {
        this.mContext = context;
        this.mCachedInfo = jobInfo;
        this.mPrintServiceClient = client;
        this.mDocument = new PrintDocument(this.mCachedInfo.getId(), client, jobInfo.getDocumentInfo());
    }

    private final PrintJobId $$robo$$android_printservice_PrintJob$getId() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mCachedInfo.getId();
    }

    private final PrintJobInfo $$robo$$android_printservice_PrintJob$getInfo() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isInImmutableState()) {
            return this.mCachedInfo;
        }
        PrintJobInfo info = null;
        try {
            info = this.mPrintServiceClient.getPrintJobInfo(this.mCachedInfo.getId());
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Couldn't get info for job: " + this.mCachedInfo.getId(), re);
        }
        if (info != null) {
            this.mCachedInfo = info;
        }
        return this.mCachedInfo;
    }

    private final PrintDocument $$robo$$android_printservice_PrintJob$getDocument() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mDocument;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isQueued() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 2;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isStarted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 3;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isBlocked() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 4;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isCompleted() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 5;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isFailed() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 6;
    }

    private final boolean $$robo$$android_printservice_PrintJob$isCancelled() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getState() == 7;
    }

    private final boolean $$robo$$android_printservice_PrintJob$start() {
        PrintService.throwIfNotCalledOnMainThread();
        int state = this.getInfo().getState();
        if (state == 2 || state == 4) {
            return this.setState(3, null);
        }
        return false;
    }

    private final boolean $$robo$$android_printservice_PrintJob$block(String reason) {
        PrintService.throwIfNotCalledOnMainThread();
        PrintJobInfo info = this.getInfo();
        int state = info.getState();
        if (state == 3 || state == 4) {
            return this.setState(4, reason);
        }
        return false;
    }

    private final boolean $$robo$$android_printservice_PrintJob$complete() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isStarted()) {
            return this.setState(5, null);
        }
        return false;
    }

    private final boolean $$robo$$android_printservice_PrintJob$fail(String error) {
        PrintService.throwIfNotCalledOnMainThread();
        if (!this.isInImmutableState()) {
            return this.setState(6, error);
        }
        return false;
    }

    private final boolean $$robo$$android_printservice_PrintJob$cancel() {
        PrintService.throwIfNotCalledOnMainThread();
        if (!this.isInImmutableState()) {
            return this.setState(7, null);
        }
        return false;
    }

    private final void $$robo$$android_printservice_PrintJob$setProgress(float progress) {
        PrintService.throwIfNotCalledOnMainThread();
        try {
            this.mPrintServiceClient.setProgress(this.mCachedInfo.getId(), progress);
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Error setting progress for job: " + this.mCachedInfo.getId(), re);
        }
    }

    private final void $$robo$$android_printservice_PrintJob$setStatus(CharSequence status) {
        PrintService.throwIfNotCalledOnMainThread();
        try {
            this.mPrintServiceClient.setStatus(this.mCachedInfo.getId(), status);
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Error setting status for job: " + this.mCachedInfo.getId(), re);
        }
    }

    private final void $$robo$$android_printservice_PrintJob$setStatus(int statusResId) {
        PrintService.throwIfNotCalledOnMainThread();
        try {
            this.mPrintServiceClient.setStatusRes(this.mCachedInfo.getId(), statusResId, this.mContext.getPackageName());
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Error setting status for job: " + this.mCachedInfo.getId(), re);
        }
    }

    private final boolean $$robo$$android_printservice_PrintJob$setTag(String tag) {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.isInImmutableState()) {
            return false;
        }
        try {
            return this.mPrintServiceClient.setPrintJobTag(this.mCachedInfo.getId(), tag);
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Error setting tag for job: " + this.mCachedInfo.getId(), re);
            return false;
        }
    }

    private final String $$robo$$android_printservice_PrintJob$getTag() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getTag();
    }

    private final String $$robo$$android_printservice_PrintJob$getAdvancedStringOption(String key) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getAdvancedStringOption(key);
    }

    private final boolean $$robo$$android_printservice_PrintJob$hasAdvancedOption(String key) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().hasAdvancedOption(key);
    }

    private final int $$robo$$android_printservice_PrintJob$getAdvancedIntOption(String key) {
        PrintService.throwIfNotCalledOnMainThread();
        return this.getInfo().getAdvancedIntOption(key);
    }

    private final boolean $$robo$$android_printservice_PrintJob$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrintJob other = (PrintJob)obj;
        return this.mCachedInfo.getId().equals(other.mCachedInfo.getId());
    }

    private final int $$robo$$android_printservice_PrintJob$hashCode() {
        return this.mCachedInfo.getId().hashCode();
    }

    private final boolean $$robo$$android_printservice_PrintJob$isInImmutableState() {
        int state = this.mCachedInfo.getState();
        return state == 5 || state == 7 || state == 6;
    }

    private final boolean $$robo$$android_printservice_PrintJob$setState(int state, String error) {
        try {
            if (this.mPrintServiceClient.setPrintJobState(this.mCachedInfo.getId(), state, error)) {
                this.mCachedInfo.setState(state);
                this.mCachedInfo.setStatus(error);
                return true;
            }
        }
        catch (RemoteException re) {
            Log.e("PrintJob", "Error setting the state of job: " + this.mCachedInfo.getId(), re);
        }
        return false;
    }

    private void __constructor__(Context context, PrintJobInfo printJobInfo, IPrintServiceClient iPrintServiceClient) {
        this.$$robo$$android_printservice_PrintJob$__constructor__(context, printJobInfo, iPrintServiceClient);
    }

    PrintJob(Context context, PrintJobInfo printJobInfo, IPrintServiceClient iPrintServiceClient) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrintJob$__constructor__(android.content.Context android.print.PrintJobInfo android.printservice.IPrintServiceClient ), 0, this, context, printJobInfo, iPrintServiceClient);
    }

    public PrintJobId getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_printservice_PrintJob$getId(), 0, this);
    }

    public PrintJobInfo getInfo() {
        return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_printservice_PrintJob$getInfo(), 0, this);
    }

    public PrintDocument getDocument() {
        return InvokeDynamicSupport.bootstrap("getDocument", $$robo$$android_printservice_PrintJob$getDocument(), 0, this);
    }

    public boolean isQueued() {
        return (boolean)InvokeDynamicSupport.bootstrap("isQueued", $$robo$$android_printservice_PrintJob$isQueued(), 0, this);
    }

    public boolean isStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStarted", $$robo$$android_printservice_PrintJob$isStarted(), 0, this);
    }

    public boolean isBlocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isBlocked", $$robo$$android_printservice_PrintJob$isBlocked(), 0, this);
    }

    public boolean isCompleted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCompleted", $$robo$$android_printservice_PrintJob$isCompleted(), 0, this);
    }

    public boolean isFailed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFailed", $$robo$$android_printservice_PrintJob$isFailed(), 0, this);
    }

    public boolean isCancelled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCancelled", $$robo$$android_printservice_PrintJob$isCancelled(), 0, this);
    }

    public boolean start() {
        return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$android_printservice_PrintJob$start(), 0, this);
    }

    public boolean block(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("block", $$robo$$android_printservice_PrintJob$block(java.lang.String ), 0, this, string2);
    }

    public boolean complete() {
        return (boolean)InvokeDynamicSupport.bootstrap("complete", $$robo$$android_printservice_PrintJob$complete(), 0, this);
    }

    public boolean fail(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("fail", $$robo$$android_printservice_PrintJob$fail(java.lang.String ), 0, this, string2);
    }

    public boolean cancel() {
        return (boolean)InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_printservice_PrintJob$cancel(), 0, this);
    }

    public void setProgress(float f) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_printservice_PrintJob$setProgress(float ), 0, this, f);
    }

    public void setStatus(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setStatus", $$robo$$android_printservice_PrintJob$setStatus(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setStatus(int n) {
        InvokeDynamicSupport.bootstrap("setStatus", $$robo$$android_printservice_PrintJob$setStatus(int ), 0, this, n);
    }

    public boolean setTag(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setTag", $$robo$$android_printservice_PrintJob$setTag(java.lang.String ), 0, this, string2);
    }

    public String getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_printservice_PrintJob$getTag(), 0, this);
    }

    public String getAdvancedStringOption(String string2) {
        return InvokeDynamicSupport.bootstrap("getAdvancedStringOption", $$robo$$android_printservice_PrintJob$getAdvancedStringOption(java.lang.String ), 0, this, string2);
    }

    public boolean hasAdvancedOption(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAdvancedOption", $$robo$$android_printservice_PrintJob$hasAdvancedOption(java.lang.String ), 0, this, string2);
    }

    public int getAdvancedIntOption(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getAdvancedIntOption", $$robo$$android_printservice_PrintJob$getAdvancedIntOption(java.lang.String ), 0, this, string2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_printservice_PrintJob$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_printservice_PrintJob$hashCode(), 0, this);
    }

    private boolean isInImmutableState() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInImmutableState", $$robo$$android_printservice_PrintJob$isInImmutableState(), 0, this);
    }

    private boolean setState(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setState", $$robo$$android_printservice_PrintJob$setState(int java.lang.String ), 0, this, n, string2);
    }

    public /* synthetic */ PrintJob() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintJob)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

