/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.KeyStore;
import android.security.keymaster.ExportResult;
import android.security.keymaster.KeyCharacteristics;
import android.security.keystore.AndroidKeyStoreBCWorkaroundProvider;
import android.security.keystore.AndroidKeyStoreECPrivateKey;
import android.security.keystore.AndroidKeyStoreECPublicKey;
import android.security.keystore.AndroidKeyStoreLoadStoreParameter;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStorePublicKey;
import android.security.keystore.AndroidKeyStoreRSAPrivateKey;
import android.security.keystore.AndroidKeyStoreRSAPublicKey;
import android.security.keystore.AndroidKeyStoreSecretKey;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyStoreCryptoOperation;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidKeyStoreProvider
extends Provider
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String PROVIDER_NAME = "AndroidKeyStore";
    private static String PACKAGE_NAME = "android.security.keystore";

    private void $$robo$$android_security_keystore_AndroidKeyStoreProvider$__constructor__() {
        this.put("KeyStore.AndroidKeyStore", "android.security.keystore.AndroidKeyStoreSpi");
        this.put("KeyPairGenerator.EC", "android.security.keystore.AndroidKeyStoreKeyPairGeneratorSpi$EC");
        this.put("KeyPairGenerator.RSA", "android.security.keystore.AndroidKeyStoreKeyPairGeneratorSpi$RSA");
        this.putKeyFactoryImpl("EC");
        this.putKeyFactoryImpl("RSA");
        this.put("KeyGenerator.AES", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$AES");
        this.put("KeyGenerator.HmacSHA1", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$HmacSHA1");
        this.put("KeyGenerator.HmacSHA224", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$HmacSHA224");
        this.put("KeyGenerator.HmacSHA256", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$HmacSHA256");
        this.put("KeyGenerator.HmacSHA384", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$HmacSHA384");
        this.put("KeyGenerator.HmacSHA512", "android.security.keystore.AndroidKeyStoreKeyGeneratorSpi$HmacSHA512");
        this.putSecretKeyFactoryImpl("AES");
        this.putSecretKeyFactoryImpl("HmacSHA1");
        this.putSecretKeyFactoryImpl("HmacSHA224");
        this.putSecretKeyFactoryImpl("HmacSHA256");
        this.putSecretKeyFactoryImpl("HmacSHA384");
        this.putSecretKeyFactoryImpl("HmacSHA512");
    }

    private static final void $$robo$$android_security_keystore_AndroidKeyStoreProvider$install() {
        Provider[] providers = Security.getProviders();
        int bcProviderIndex = -1;
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            if (!"BC".equals(provider.getName())) continue;
            bcProviderIndex = i;
            break;
        }
        Security.addProvider(new AndroidKeyStoreProvider());
        AndroidKeyStoreBCWorkaroundProvider workaroundProvider = new AndroidKeyStoreBCWorkaroundProvider();
        if (bcProviderIndex != -1) {
            Security.insertProviderAt(workaroundProvider, bcProviderIndex + 1);
        } else {
            Security.addProvider(workaroundProvider);
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreProvider$putSecretKeyFactoryImpl(String algorithm) {
        this.put("SecretKeyFactory." + algorithm, "android.security.keystore.AndroidKeyStoreSecretKeyFactorySpi");
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreProvider$putKeyFactoryImpl(String algorithm) {
        this.put("KeyFactory." + algorithm, "android.security.keystore.AndroidKeyStoreKeyFactorySpi");
    }

    private static final long $$robo$$android_security_keystore_AndroidKeyStoreProvider$getKeyStoreOperationHandle(Object cryptoPrimitive) {
        Object spi;
        if (cryptoPrimitive == null) {
            throw new NullPointerException();
        }
        if (cryptoPrimitive instanceof Signature) {
            spi = ((Signature)cryptoPrimitive).getCurrentSpi();
        } else if (cryptoPrimitive instanceof Mac) {
            spi = ((Mac)cryptoPrimitive).getCurrentSpi();
        } else if (cryptoPrimitive instanceof Cipher) {
            spi = ((Cipher)cryptoPrimitive).getCurrentSpi();
        } else {
            throw new IllegalArgumentException("Unsupported crypto primitive: " + cryptoPrimitive + ". Supported: Signature, Mac, Cipher");
        }
        if (spi == null) {
            throw new IllegalStateException("Crypto primitive not initialized");
        }
        if (!(spi instanceof KeyStoreCryptoOperation)) {
            throw new IllegalArgumentException("Crypto primitive not backed by AndroidKeyStore provider: " + cryptoPrimitive + ", spi: " + spi);
        }
        return ((KeyStoreCryptoOperation)spi).getOperationHandle();
    }

    private static final AndroidKeyStorePublicKey $$robo$$android_security_keystore_AndroidKeyStoreProvider$getAndroidKeyStorePublicKey(String alias, int uid, String keyAlgorithm, byte[] x509EncodedForm) {
        PublicKey publicKey;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(x509EncodedForm));
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException("Failed to obtain " + keyAlgorithm + " KeyFactory", e);
        }
        catch (InvalidKeySpecException e) {
            throw new ProviderException("Invalid X.509 encoding of public key", e);
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return new AndroidKeyStoreECPublicKey(alias, uid, (ECPublicKey)publicKey);
        }
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return new AndroidKeyStoreRSAPublicKey(alias, uid, (RSAPublicKey)publicKey);
        }
        throw new ProviderException("Unsupported Android Keystore public key algorithm: " + keyAlgorithm);
    }

    private static final AndroidKeyStorePrivateKey $$robo$$android_security_keystore_AndroidKeyStoreProvider$getAndroidKeyStorePrivateKey(AndroidKeyStorePublicKey publicKey) {
        String keyAlgorithm = publicKey.getAlgorithm();
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return new AndroidKeyStoreECPrivateKey(publicKey.getAlias(), publicKey.getUid(), ((ECKey)((Object)publicKey)).getParams());
        }
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return new AndroidKeyStoreRSAPrivateKey(publicKey.getAlias(), publicKey.getUid(), ((RSAKey)((Object)publicKey)).getModulus());
        }
        throw new ProviderException("Unsupported Android Keystore public key algorithm: " + keyAlgorithm);
    }

    private static final AndroidKeyStorePublicKey $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStorePublicKeyFromKeystore(KeyStore keyStore, String privateKeyAlias, int uid) throws UnrecoverableKeyException {
        String jcaKeyAlgorithm;
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = keyStore.getKeyCharacteristics(privateKeyAlias, null, null, uid, keyCharacteristics);
        if (errorCode != 1) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Failed to obtain information about private key").initCause(KeyStore.getKeyStoreException(errorCode));
        }
        ExportResult exportResult = keyStore.exportKey(privateKeyAlias, 0, null, null, uid);
        if (exportResult.resultCode != 1) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Failed to obtain X.509 form of public key").initCause(KeyStore.getKeyStoreException(exportResult.resultCode));
        }
        byte[] x509EncodedPublicKey = exportResult.exportData;
        Integer keymasterAlgorithm = keyCharacteristics.getEnum(0x10000002);
        if (keymasterAlgorithm == null) {
            throw new UnrecoverableKeyException("Key algorithm unknown");
        }
        try {
            jcaKeyAlgorithm = KeyProperties.KeyAlgorithm.fromKeymasterAsymmetricKeyAlgorithm(keymasterAlgorithm);
        }
        catch (IllegalArgumentException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Failed to load private key").initCause(e);
        }
        return AndroidKeyStoreProvider.getAndroidKeyStorePublicKey(privateKeyAlias, uid, jcaKeyAlgorithm, x509EncodedPublicKey);
    }

    private static final KeyPair $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStoreKeyPairFromKeystore(KeyStore keyStore, String privateKeyAlias, int uid) throws UnrecoverableKeyException {
        AndroidKeyStorePublicKey publicKey = AndroidKeyStoreProvider.loadAndroidKeyStorePublicKeyFromKeystore(keyStore, privateKeyAlias, uid);
        AndroidKeyStorePrivateKey privateKey = AndroidKeyStoreProvider.getAndroidKeyStorePrivateKey(publicKey);
        return new KeyPair(publicKey, privateKey);
    }

    private static final AndroidKeyStorePrivateKey $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStorePrivateKeyFromKeystore(KeyStore keyStore, String privateKeyAlias, int uid) throws UnrecoverableKeyException {
        KeyPair keyPair = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyPairFromKeystore(keyStore, privateKeyAlias, uid);
        return (AndroidKeyStorePrivateKey)keyPair.getPrivate();
    }

    private static final AndroidKeyStoreSecretKey $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStoreSecretKeyFromKeystore(KeyStore keyStore, String secretKeyAlias, int uid) throws UnrecoverableKeyException {
        String keyAlgorithmString;
        KeyCharacteristics keyCharacteristics = new KeyCharacteristics();
        int errorCode = keyStore.getKeyCharacteristics(secretKeyAlias, null, null, uid, keyCharacteristics);
        if (errorCode != 1) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Failed to obtain information about key").initCause(KeyStore.getKeyStoreException(errorCode));
        }
        Integer keymasterAlgorithm = keyCharacteristics.getEnum(0x10000002);
        if (keymasterAlgorithm == null) {
            throw new UnrecoverableKeyException("Key algorithm unknown");
        }
        List<Integer> keymasterDigests = keyCharacteristics.getEnums(0x20000005);
        int keymasterDigest = keymasterDigests.isEmpty() ? -1 : keymasterDigests.get(0);
        try {
            keyAlgorithmString = KeyProperties.KeyAlgorithm.fromKeymasterSecretKeyAlgorithm(keymasterAlgorithm, keymasterDigest);
        }
        catch (IllegalArgumentException e) {
            throw (UnrecoverableKeyException)new UnrecoverableKeyException("Unsupported secret key type").initCause(e);
        }
        return new AndroidKeyStoreSecretKey(secretKeyAlias, uid, keyAlgorithmString);
    }

    private static final java.security.KeyStore $$robo$$android_security_keystore_AndroidKeyStoreProvider$getKeyStoreForUid(int uid) throws KeyStoreException, NoSuchProviderException {
        java.security.KeyStore result = java.security.KeyStore.getInstance("AndroidKeyStore", "AndroidKeyStore");
        try {
            result.load(new AndroidKeyStoreLoadStoreParameter(uid));
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyStoreException("Failed to load AndroidKeyStore KeyStore for UID " + uid, e);
        }
        return result;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AndroidKeyStoreProvider$__constructor__();
    }

    public AndroidKeyStoreProvider() {
        super("AndroidKeyStore", 1.0, "Android KeyStore security provider");
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreProvider$__constructor__(), 0, this);
    }

    public static void install() {
        InvokeDynamicSupport.bootstrapStatic("install", $$robo$$android_security_keystore_AndroidKeyStoreProvider$install(), 0);
    }

    private void putSecretKeyFactoryImpl(String string2) {
        InvokeDynamicSupport.bootstrap("putSecretKeyFactoryImpl", $$robo$$android_security_keystore_AndroidKeyStoreProvider$putSecretKeyFactoryImpl(java.lang.String ), 0, this, string2);
    }

    private void putKeyFactoryImpl(String string2) {
        InvokeDynamicSupport.bootstrap("putKeyFactoryImpl", $$robo$$android_security_keystore_AndroidKeyStoreProvider$putKeyFactoryImpl(java.lang.String ), 0, this, string2);
    }

    public static long getKeyStoreOperationHandle(Object object) {
        return (long)InvokeDynamicSupport.bootstrapStatic("getKeyStoreOperationHandle", $$robo$$android_security_keystore_AndroidKeyStoreProvider$getKeyStoreOperationHandle(java.lang.Object ), 0, (Object)object);
    }

    public static AndroidKeyStorePublicKey getAndroidKeyStorePublicKey(String string2, int n, String string3, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("getAndroidKeyStorePublicKey", $$robo$$android_security_keystore_AndroidKeyStoreProvider$getAndroidKeyStorePublicKey(java.lang.String int java.lang.String byte[] ), 0, (String)string2, (int)n, (String)string3, (byte[])byArray);
    }

    public static AndroidKeyStorePrivateKey getAndroidKeyStorePrivateKey(AndroidKeyStorePublicKey androidKeyStorePublicKey) {
        return InvokeDynamicSupport.bootstrapStatic("getAndroidKeyStorePrivateKey", $$robo$$android_security_keystore_AndroidKeyStoreProvider$getAndroidKeyStorePrivateKey(android.security.keystore.AndroidKeyStorePublicKey ), 0, (AndroidKeyStorePublicKey)androidKeyStorePublicKey);
    }

    public static AndroidKeyStorePublicKey loadAndroidKeyStorePublicKeyFromKeystore(KeyStore keyStore, String string2, int n) throws UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrapStatic("loadAndroidKeyStorePublicKeyFromKeystore", $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStorePublicKeyFromKeystore(android.security.KeyStore java.lang.String int ), 0, (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static KeyPair loadAndroidKeyStoreKeyPairFromKeystore(KeyStore keyStore, String string2, int n) throws UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrapStatic("loadAndroidKeyStoreKeyPairFromKeystore", $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStoreKeyPairFromKeystore(android.security.KeyStore java.lang.String int ), 0, (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static AndroidKeyStorePrivateKey loadAndroidKeyStorePrivateKeyFromKeystore(KeyStore keyStore, String string2, int n) throws UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrapStatic("loadAndroidKeyStorePrivateKeyFromKeystore", $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStorePrivateKeyFromKeystore(android.security.KeyStore java.lang.String int ), 0, (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static AndroidKeyStoreSecretKey loadAndroidKeyStoreSecretKeyFromKeystore(KeyStore keyStore, String string2, int n) throws UnrecoverableKeyException {
        return InvokeDynamicSupport.bootstrapStatic("loadAndroidKeyStoreSecretKeyFromKeystore", $$robo$$android_security_keystore_AndroidKeyStoreProvider$loadAndroidKeyStoreSecretKeyFromKeystore(android.security.KeyStore java.lang.String int ), 0, (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static java.security.KeyStore getKeyStoreForUid(int n) throws KeyStoreException, NoSuchProviderException {
        return InvokeDynamicSupport.bootstrapStatic("getKeyStoreForUid", $$robo$$android_security_keystore_AndroidKeyStoreProvider$getKeyStoreForUid(int ), 0, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreProvider)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

