/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.ApplicationConfig;
import android.security.net.config.NetworkSecurityConfig;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedTrustManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RootTrustManager
extends X509ExtendedTrustManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ApplicationConfig mConfig;

    private void $$robo$$android_security_net_config_RootTrustManager$__constructor__(ApplicationConfig config) {
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.mConfig = config;
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname("");
        config.getTrustManager().checkClientTrusted(chain, authType);
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname("");
        config.getTrustManager().checkClientTrusted(certs, authType, socket);
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname("");
        config.getTrustManager().checkClientTrusted(certs, authType, engine);
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLSession session = sslSocket.getHandshakeSession();
            if (session == null) {
                throw new CertificateException("Not in handshake; no session available");
            }
            String host = session.getPeerHost();
            NetworkSecurityConfig config = this.mConfig.getConfigForHostname(host);
            config.getTrustManager().checkServerTrusted(certs, authType, socket);
        } else {
            this.checkServerTrusted(certs, authType);
        }
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        SSLSession session = engine.getHandshakeSession();
        if (session == null) {
            throw new CertificateException("Not in handshake; no session available");
        }
        String host = session.getPeerHost();
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname(host);
        config.getTrustManager().checkServerTrusted(certs, authType, engine);
    }

    private final void $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        if (this.mConfig.hasPerDomainConfigs()) {
            throw new CertificateException("Domain specific configurations require that hostname aware checkServerTrusted(X509Certificate[], String, String) is used");
        }
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname("");
        config.getTrustManager().checkServerTrusted(certs, authType);
    }

    private final List<X509Certificate> $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, String hostname) throws CertificateException {
        if (hostname == null && this.mConfig.hasPerDomainConfigs()) {
            throw new CertificateException("Domain specific configurations require that the hostname be provided");
        }
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname(hostname);
        return config.getTrustManager().checkServerTrusted(certs, authType, hostname);
    }

    private final X509Certificate[] $$robo$$android_security_net_config_RootTrustManager$getAcceptedIssuers() {
        NetworkSecurityConfig config = this.mConfig.getConfigForHostname("");
        return config.getTrustManager().getAcceptedIssuers();
    }

    private final boolean $$robo$$android_security_net_config_RootTrustManager$isSameTrustConfiguration(String hostname1, String hostname2) {
        return this.mConfig.getConfigForHostname(hostname1).equals(this.mConfig.getConfigForHostname(hostname2));
    }

    private void __constructor__(ApplicationConfig applicationConfig) {
        this.$$robo$$android_security_net_config_RootTrustManager$__constructor__(applicationConfig);
    }

    public RootTrustManager(ApplicationConfig applicationConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_RootTrustManager$__constructor__(android.security.net.config.ApplicationConfig ), 0, this, applicationConfig);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2, Socket socket) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String java.net.Socket ), 0, this, x509CertificateArray, string2, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2, SSLEngine sSLEngine) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_RootTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String javax.net.ssl.SSLEngine ), 0, this, x509CertificateArray, string2, sSLEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, Socket socket) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String java.net.Socket ), 0, this, x509CertificateArray, string2, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, SSLEngine sSLEngine) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String javax.net.ssl.SSLEngine ), 0, this, x509CertificateArray, string2, sSLEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String ), 0, this, x509CertificateArray, string2);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, String string3) throws CertificateException {
        return InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_RootTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String java.lang.String ), 0, this, x509CertificateArray, string2, string3);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return InvokeDynamicSupport.bootstrap("getAcceptedIssuers", $$robo$$android_security_net_config_RootTrustManager$getAcceptedIssuers(), 0, this);
    }

    public boolean isSameTrustConfiguration(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSameTrustConfiguration", $$robo$$android_security_net_config_RootTrustManager$isSameTrustConfiguration(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public /* synthetic */ RootTrustManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RootTrustManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

