/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.Service;
import android.content.Intent;
import android.os.CancellationSignal;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.RemoteException;
import android.service.autofill.FillCallback;
import android.service.autofill.FillEventHistory;
import android.service.autofill.FillRequest;
import android.service.autofill.IAutoFillService;
import android.service.autofill.IFillCallback;
import android.service.autofill.ISaveCallback;
import android.service.autofill.SaveCallback;
import android.service.autofill.SaveRequest;
import android.util.Log;
import android.view.autofill.AutofillManager;
import com.android.internal.os.HandlerCaller;
import com.android.internal.os.SomeArgs;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AutofillService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AutofillService";
    public static String SERVICE_INTERFACE = "android.service.autofill.AutofillService";
    public static String SERVICE_META_DATA = "android.autofill";
    private static int MSG_CONNECT = 1;
    private static int MSG_DISCONNECT = 2;
    private static int MSG_ON_FILL_REQUEST = 3;
    private static int MSG_ON_SAVE_REQUEST = 4;
    private IAutoFillService mInterface;
    private HandlerCaller.Callback mHandlerCallback;
    private HandlerCaller mHandlerCaller;

    private void $$robo$$android_service_autofill_AutofillService$__constructor__() {
        this.mInterface = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AutofillService this$0;

            private void $$robo$$android_service_autofill_AutofillService_1$__constructor__(AutofillService this$0) {
            }

            private final void $$robo$$android_service_autofill_AutofillService_1$onConnectedStateChanged(boolean connected) {
                if (connected) {
                    this.this$0.mHandlerCaller.obtainMessage(1).sendToTarget();
                } else {
                    this.this$0.mHandlerCaller.obtainMessage(2).sendToTarget();
                }
            }

            private final void $$robo$$android_service_autofill_AutofillService_1$onFillRequest(FillRequest request, IFillCallback callback) {
                ICancellationSignal transport = CancellationSignal.createTransport();
                try {
                    callback.onCancellable(transport);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
                this.this$0.mHandlerCaller.obtainMessageOOO(3, request, CancellationSignal.fromTransport(transport), callback).sendToTarget();
            }

            private final void $$robo$$android_service_autofill_AutofillService_1$onSaveRequest(SaveRequest request, ISaveCallback callback) {
                this.this$0.mHandlerCaller.obtainMessageOO(4, request, callback).sendToTarget();
            }

            private void __constructor__(AutofillService autofillService) {
                this.$$robo$$android_service_autofill_AutofillService_1$__constructor__(autofillService);
            }
            {
                this.this$0 = autofillService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillService_1$__constructor__(android.service.autofill.AutofillService ), 0, this, autofillService);
            }

            @Override
            public void onConnectedStateChanged(boolean bl) {
                InvokeDynamicSupport.bootstrap("onConnectedStateChanged", $$robo$$android_service_autofill_AutofillService_1$onConnectedStateChanged(boolean ), 0, this, bl);
            }

            @Override
            public void onFillRequest(FillRequest fillRequest, IFillCallback iFillCallback) {
                InvokeDynamicSupport.bootstrap("onFillRequest", $$robo$$android_service_autofill_AutofillService_1$onFillRequest(android.service.autofill.FillRequest android.service.autofill.IFillCallback ), 0, this, fillRequest, iFillCallback);
            }

            @Override
            public void onSaveRequest(SaveRequest saveRequest, ISaveCallback iSaveCallback) {
                InvokeDynamicSupport.bootstrap("onSaveRequest", $$robo$$android_service_autofill_AutofillService_1$onSaveRequest(android.service.autofill.SaveRequest android.service.autofill.ISaveCallback ), 0, this, saveRequest, iSaveCallback);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandlerCallback = msg -> {
            switch (msg.what) {
                case 1: {
                    this.onConnected();
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    FillRequest request = (FillRequest)args.arg1;
                    CancellationSignal cancellation = (CancellationSignal)args.arg2;
                    IFillCallback callback = (IFillCallback)args.arg3;
                    FillCallback fillCallback = new FillCallback(callback, request.getId());
                    args.recycle();
                    this.onFillRequest(request, cancellation, fillCallback);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    SaveRequest request = (SaveRequest)args.arg1;
                    ISaveCallback callback = (ISaveCallback)args.arg2;
                    SaveCallback saveCallback = new SaveCallback(callback);
                    args.recycle();
                    this.onSaveRequest(request, saveCallback);
                    break;
                }
                case 2: {
                    this.onDisconnected();
                    break;
                }
                default: {
                    Log.w("AutofillService", "MyCallbacks received invalid message type: " + msg);
                }
            }
        };
    }

    private final void $$robo$$android_service_autofill_AutofillService$onCreate() {
        super.onCreate();
        this.mHandlerCaller = new HandlerCaller(null, Looper.getMainLooper(), this.mHandlerCallback, true);
    }

    private final IBinder $$robo$$android_service_autofill_AutofillService$onBind(Intent intent) {
        if ("android.service.autofill.AutofillService".equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        Log.w("AutofillService", "Tried to bind to wrong intent: " + intent);
        return null;
    }

    private final void $$robo$$android_service_autofill_AutofillService$onConnected() {
    }

    public abstract void onFillRequest(FillRequest var1, CancellationSignal var2, FillCallback var3);

    public abstract void onSaveRequest(SaveRequest var1, SaveCallback var2);

    private final void $$robo$$android_service_autofill_AutofillService$onDisconnected() {
    }

    private final FillEventHistory $$robo$$android_service_autofill_AutofillService$getFillEventHistory() {
        AutofillManager afm = this.getSystemService(AutofillManager.class);
        if (afm == null) {
            return null;
        }
        return afm.getFillEventHistory();
    }

    private void __constructor__() {
        this.$$robo$$android_service_autofill_AutofillService$__constructor__();
    }

    public AutofillService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_autofill_AutofillService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_autofill_AutofillService$onCreate(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_autofill_AutofillService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void onConnected() {
        InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_service_autofill_AutofillService$onConnected(), 0, this);
    }

    public void onDisconnected() {
        InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_service_autofill_AutofillService$onDisconnected(), 0, this);
    }

    public FillEventHistory getFillEventHistory() {
        return InvokeDynamicSupport.bootstrap("getFillEventHistory", $$robo$$android_service_autofill_AutofillService$getFillEventHistory(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

