/*
 * Decompiled with CFR 0.152.
 */
package android.service.media;

import android.annotation.IntDef;
import android.app.Service;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.media.browse.MediaBrowser;
import android.media.browse.MediaBrowserUtils;
import android.media.session.MediaSession;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.service.media.IMediaBrowserService;
import android.service.media.IMediaBrowserServiceCallbacks;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Pair;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class MediaBrowserService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MediaBrowserService";
    private static boolean DBG = false;
    public static String SERVICE_INTERFACE = "android.media.browse.MediaBrowserService";
    public static String KEY_MEDIA_ITEM = "media_item";
    private static int RESULT_FLAG_OPTION_NOT_HANDLED = 1;
    private static int RESULT_FLAG_ON_LOAD_ITEM_NOT_IMPLEMENTED = 2;
    private static int RESULT_ERROR = -1;
    private static int RESULT_OK = 0;
    private ArrayMap<IBinder, ConnectionRecord> mConnections;
    private ConnectionRecord mCurConnection;
    private Handler mHandler;
    private ServiceBinder mBinder;
    MediaSession.Token mSession;

    private void $$robo$$android_service_media_MediaBrowserService$__constructor__() {
        this.mConnections = new ArrayMap();
        this.mHandler = new Handler();
    }

    private final void $$robo$$android_service_media_MediaBrowserService$onCreate() {
        super.onCreate();
        this.mBinder = new ServiceBinder(this);
    }

    private final IBinder $$robo$$android_service_media_MediaBrowserService$onBind(Intent intent) {
        if ("android.media.browse.MediaBrowserService".equals(intent.getAction())) {
            return this.mBinder;
        }
        return null;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
    }

    public abstract BrowserRoot onGetRoot(String var1, int var2, Bundle var3);

    public abstract void onLoadChildren(String var1, Result<List<MediaBrowser.MediaItem>> var2);

    private final void $$robo$$android_service_media_MediaBrowserService$onLoadChildren(String parentId, Result<List<MediaBrowser.MediaItem>> result, Bundle options) {
        result.setFlags(1);
        this.onLoadChildren(parentId, result);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$onLoadItem(String itemId, Result<MediaBrowser.MediaItem> result) {
        result.setFlags(2);
        result.sendResult(null);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$setSessionToken(MediaSession.Token token) {
        if (token == null) {
            throw new IllegalArgumentException("Session token may not be null.");
        }
        if (this.mSession != null) {
            throw new IllegalStateException("The session token has already been set.");
        }
        this.mSession = token;
        this.mHandler.post(new Runnable(this, token){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaSession.Token val$token;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_1$__constructor__(MediaBrowserService this$0, MediaSession.Token token) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_1$run() {
                Iterator iter = this.this$0.mConnections.values().iterator();
                while (iter.hasNext()) {
                    ConnectionRecord connection = (ConnectionRecord)iter.next();
                    try {
                        connection.callbacks.onConnect(connection.root.getRootId(), this.val$token, connection.root.getExtras());
                    }
                    catch (RemoteException e) {
                        Log.w("MediaBrowserService", "Connection for " + connection.pkg + " is no longer valid.");
                        iter.remove();
                    }
                }
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, MediaSession.Token token) {
                this.$$robo$$android_service_media_MediaBrowserService_1$__constructor__(mediaBrowserService, token);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$token = token;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_1$__constructor__(android.service.media.MediaBrowserService android.media.session.MediaSession$Token ), 0, this, mediaBrowserService, token);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final MediaSession.Token $$robo$$android_service_media_MediaBrowserService$getSessionToken() {
        return this.mSession;
    }

    private final Bundle $$robo$$android_service_media_MediaBrowserService$getBrowserRootHints() {
        if (this.mCurConnection == null) {
            throw new IllegalStateException("This should be called inside of onLoadChildren or onLoadItem methods");
        }
        return this.mCurConnection.rootHints == null ? null : new Bundle(this.mCurConnection.rootHints);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(String parentId) {
        this.notifyChildrenChangedInternal(parentId, null);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(String parentId, Bundle options) {
        if (options == null) {
            throw new IllegalArgumentException("options cannot be null in notifyChildrenChanged");
        }
        this.notifyChildrenChangedInternal(parentId, options);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$notifyChildrenChangedInternal(String parentId, Bundle options) {
        if (parentId == null) {
            throw new IllegalArgumentException("parentId cannot be null in notifyChildrenChanged");
        }
        this.mHandler.post(new Runnable(this, parentId, options){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$parentId;
            /* synthetic */ Bundle val$options;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_2$__constructor__(MediaBrowserService this$0, String string2, Bundle bundle) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_2$run() {
                for (IBinder binder : this.this$0.mConnections.keySet()) {
                    ConnectionRecord connection = (ConnectionRecord)this.this$0.mConnections.get(binder);
                    List<Pair<IBinder, Bundle>> callbackList = connection.subscriptions.get(this.val$parentId);
                    if (callbackList == null) continue;
                    for (Pair<IBinder, Bundle> callback : callbackList) {
                        if (!MediaBrowserUtils.hasDuplicatedItems(this.val$options, (Bundle)callback.second)) continue;
                        this.this$0.performLoadChildren(this.val$parentId, connection, (Bundle)callback.second);
                    }
                }
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, String string2, Bundle bundle) {
                this.$$robo$$android_service_media_MediaBrowserService_2$__constructor__(mediaBrowserService, string2, bundle);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$parentId = string2;
                this.val$options = bundle;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_2$__constructor__(android.service.media.MediaBrowserService java.lang.String android.os.Bundle ), 0, this, mediaBrowserService, string2, bundle);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$android_service_media_MediaBrowserService$isValidPackage(String pkg, int uid) {
        if (pkg == null) {
            return false;
        }
        PackageManager pm = this.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        int N = packages.length;
        for (int i = 0; i < N; ++i) {
            if (!packages[i].equals(pkg)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$addSubscription(String id2, ConnectionRecord connection, IBinder token, Bundle options) {
        List<Pair<IBinder, Bundle>> callbackList = connection.subscriptions.get(id2);
        if (callbackList == null) {
            callbackList = new ArrayList<Pair<IBinder, Bundle>>();
        }
        for (Pair<IBinder, Bundle> callback : callbackList) {
            if (token != callback.first || !MediaBrowserUtils.areSameOptions(options, (Bundle)callback.second)) continue;
            return;
        }
        callbackList.add(new Pair<IBinder, Bundle>(token, options));
        connection.subscriptions.put(id2, callbackList);
        this.performLoadChildren(id2, connection, options);
    }

    private final boolean $$robo$$android_service_media_MediaBrowserService$removeSubscription(String id2, ConnectionRecord connection, IBinder token) {
        if (token == null) {
            return connection.subscriptions.remove(id2) != null;
        }
        boolean removed = false;
        List<Pair<IBinder, Bundle>> callbackList = connection.subscriptions.get(id2);
        if (callbackList != null) {
            Iterator<Pair<IBinder, Bundle>> iter = callbackList.iterator();
            while (iter.hasNext()) {
                if (token != iter.next().first) continue;
                removed = true;
                iter.remove();
            }
            if (callbackList.size() == 0) {
                connection.subscriptions.remove(id2);
            }
        }
        return removed;
    }

    private final void $$robo$$android_service_media_MediaBrowserService$performLoadChildren(String parentId, ConnectionRecord connection, Bundle options) {
        Result<List<MediaBrowser.MediaItem>> result = new Result<List<MediaBrowser.MediaItem>>(this, (Object)parentId, connection, parentId, options){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConnectionRecord val$connection;
            /* synthetic */ String val$parentId;
            /* synthetic */ Bundle val$options;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_3$__constructor__(MediaBrowserService this$0, Object debug, ConnectionRecord connectionRecord, String string2, Bundle bundle) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_3$onResultSent(List<MediaBrowser.MediaItem> list, int flag) {
                if (this.this$0.mConnections.get(this.val$connection.callbacks.asBinder()) != this.val$connection) {
                    return;
                }
                List filteredList = (flag & 1) != 0 ? this.this$0.applyOptions(list, this.val$options) : list;
                ParceledListSlice pls = filteredList == null ? null : new ParceledListSlice(filteredList);
                try {
                    this.val$connection.callbacks.onLoadChildrenWithOptions(this.val$parentId, pls, this.val$options);
                }
                catch (RemoteException ex) {
                    Log.w("MediaBrowserService", "Calling onLoadChildren() failed for id=" + this.val$parentId + " package=" + this.val$connection.pkg);
                }
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, Object object, ConnectionRecord connectionRecord, String string2, Bundle bundle) {
                this.$$robo$$android_service_media_MediaBrowserService_3$__constructor__(mediaBrowserService, object, connectionRecord, string2, bundle);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$connection = connectionRecord;
                this.val$parentId = string2;
                this.val$options = bundle;
                super(mediaBrowserService, object);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_3$__constructor__(android.service.media.MediaBrowserService java.lang.Object android.service.media.MediaBrowserService$ConnectionRecord java.lang.String android.os.Bundle ), 0, this, mediaBrowserService, object, connectionRecord, string2, bundle);
            }

            @Override
            void onResultSent(List<MediaBrowser.MediaItem> list, int n) {
                InvokeDynamicSupport.bootstrap("onResultSent", $$robo$$android_service_media_MediaBrowserService_3$onResultSent(java.util.List<android.media.browse.MediaBrowser$MediaItem> int ), 0, this, list, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCurConnection = connection;
        if (options == null) {
            this.onLoadChildren(parentId, result);
        } else {
            this.onLoadChildren(parentId, result, options);
        }
        this.mCurConnection = null;
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadChildren must call detach() or sendResult() before returning for package=" + connection.pkg + " id=" + parentId);
        }
    }

    private final List<MediaBrowser.MediaItem> $$robo$$android_service_media_MediaBrowserService$applyOptions(List<MediaBrowser.MediaItem> list, Bundle options) {
        if (list == null) {
            return null;
        }
        int page = options.getInt("android.media.browse.extra.PAGE", -1);
        int pageSize = options.getInt("android.media.browse.extra.PAGE_SIZE", -1);
        if (page == -1 && pageSize == -1) {
            return list;
        }
        int fromIndex = pageSize * page;
        int toIndex = fromIndex + pageSize;
        if (page < 0 || pageSize < 1 || fromIndex >= list.size()) {
            return Collections.EMPTY_LIST;
        }
        if (toIndex > list.size()) {
            toIndex = list.size();
        }
        return list.subList(fromIndex, toIndex);
    }

    private final void $$robo$$android_service_media_MediaBrowserService$performLoadItem(String itemId, ConnectionRecord connection, ResultReceiver receiver) {
        Result<MediaBrowser.MediaItem> result = new Result<MediaBrowser.MediaItem>(this, (Object)itemId, receiver){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ResultReceiver val$receiver;
            /* synthetic */ MediaBrowserService this$0;

            private void $$robo$$android_service_media_MediaBrowserService_4$__constructor__(MediaBrowserService this$0, Object debug, ResultReceiver resultReceiver) {
            }

            private final void $$robo$$android_service_media_MediaBrowserService_4$onResultSent(MediaBrowser.MediaItem item, int flag) {
                if ((flag & 2) != 0) {
                    this.val$receiver.send(-1, null);
                    return;
                }
                Bundle bundle = new Bundle();
                bundle.putParcelable("media_item", item);
                this.val$receiver.send(0, bundle);
            }

            private void __constructor__(MediaBrowserService mediaBrowserService, Object object, ResultReceiver resultReceiver) {
                this.$$robo$$android_service_media_MediaBrowserService_4$__constructor__(mediaBrowserService, object, resultReceiver);
            }
            {
                this.this$0 = mediaBrowserService;
                this.val$receiver = resultReceiver;
                super(mediaBrowserService, object);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_4$__constructor__(android.service.media.MediaBrowserService java.lang.Object android.os.ResultReceiver ), 0, this, mediaBrowserService, object, resultReceiver);
            }

            @Override
            void onResultSent(MediaBrowser.MediaItem mediaItem, int n) {
                InvokeDynamicSupport.bootstrap("onResultSent", $$robo$$android_service_media_MediaBrowserService_4$onResultSent(android.media.browse.MediaBrowser$MediaItem int ), 0, this, mediaItem, n);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCurConnection = connection;
        this.onLoadItem(itemId, result);
        this.mCurConnection = null;
        if (!result.isDone()) {
            throw new IllegalStateException("onLoadItem must call detach() or sendResult() before returning for id=" + itemId);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_service_media_MediaBrowserService$__constructor__();
    }

    public MediaBrowserService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$android_service_media_MediaBrowserService$onCreate(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_service_media_MediaBrowserService$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_service_media_MediaBrowserService$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public void onLoadChildren(String string2, Result<List<MediaBrowser.MediaItem>> result, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onLoadChildren", $$robo$$android_service_media_MediaBrowserService$onLoadChildren(java.lang.String android.service.media.MediaBrowserService$Result<java.util.List<android.media.browse.MediaBrowser$MediaItem>> android.os.Bundle ), 0, this, string2, result, bundle);
    }

    public void onLoadItem(String string2, Result<MediaBrowser.MediaItem> result) {
        InvokeDynamicSupport.bootstrap("onLoadItem", $$robo$$android_service_media_MediaBrowserService$onLoadItem(java.lang.String android.service.media.MediaBrowserService$Result<android.media.browse.MediaBrowser$MediaItem> ), 0, this, string2, result);
    }

    public void setSessionToken(MediaSession.Token token) {
        InvokeDynamicSupport.bootstrap("setSessionToken", $$robo$$android_service_media_MediaBrowserService$setSessionToken(android.media.session.MediaSession$Token ), 0, this, token);
    }

    public MediaSession.Token getSessionToken() {
        return InvokeDynamicSupport.bootstrap("getSessionToken", $$robo$$android_service_media_MediaBrowserService$getSessionToken(), 0, this);
    }

    public Bundle getBrowserRootHints() {
        return InvokeDynamicSupport.bootstrap("getBrowserRootHints", $$robo$$android_service_media_MediaBrowserService$getBrowserRootHints(), 0, this);
    }

    public void notifyChildrenChanged(String string2) {
        InvokeDynamicSupport.bootstrap("notifyChildrenChanged", $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(java.lang.String ), 0, this, string2);
    }

    public void notifyChildrenChanged(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("notifyChildrenChanged", $$robo$$android_service_media_MediaBrowserService$notifyChildrenChanged(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void notifyChildrenChangedInternal(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("notifyChildrenChangedInternal", $$robo$$android_service_media_MediaBrowserService$notifyChildrenChangedInternal(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private boolean isValidPackage(String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidPackage", $$robo$$android_service_media_MediaBrowserService$isValidPackage(java.lang.String int ), 0, this, string2, n);
    }

    private void addSubscription(String string2, ConnectionRecord connectionRecord, IBinder iBinder, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("addSubscription", $$robo$$android_service_media_MediaBrowserService$addSubscription(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord android.os.IBinder android.os.Bundle ), 0, this, string2, connectionRecord, iBinder, bundle);
    }

    private boolean removeSubscription(String string2, ConnectionRecord connectionRecord, IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeSubscription", $$robo$$android_service_media_MediaBrowserService$removeSubscription(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord android.os.IBinder ), 0, this, string2, connectionRecord, iBinder);
    }

    private void performLoadChildren(String string2, ConnectionRecord connectionRecord, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("performLoadChildren", $$robo$$android_service_media_MediaBrowserService$performLoadChildren(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord android.os.Bundle ), 0, this, string2, connectionRecord, bundle);
    }

    private List<MediaBrowser.MediaItem> applyOptions(List<MediaBrowser.MediaItem> list, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("applyOptions", $$robo$$android_service_media_MediaBrowserService$applyOptions(java.util.List<android.media.browse.MediaBrowser$MediaItem> android.os.Bundle ), 0, this, list, bundle);
    }

    private void performLoadItem(String string2, ConnectionRecord connectionRecord, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("performLoadItem", $$robo$$android_service_media_MediaBrowserService$performLoadItem(java.lang.String android.service.media.MediaBrowserService$ConnectionRecord android.os.ResultReceiver ), 0, this, string2, connectionRecord, resultReceiver);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaBrowserService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class BrowserRoot
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String EXTRA_RECENT = "android.service.media.extra.RECENT";
        public static String EXTRA_OFFLINE = "android.service.media.extra.OFFLINE";
        public static String EXTRA_SUGGESTED = "android.service.media.extra.SUGGESTED";
        private String mRootId;
        private Bundle mExtras;

        private void $$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(String rootId, Bundle extras) {
            if (rootId == null) {
                throw new IllegalArgumentException("The root id in BrowserRoot cannot be null. Use null for BrowserRoot instead.");
            }
            this.mRootId = rootId;
            this.mExtras = extras;
        }

        private final String $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getRootId() {
            return this.mRootId;
        }

        private final Bundle $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getExtras() {
            return this.mExtras;
        }

        private void __constructor__(String string2, Bundle bundle) {
            this.$$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(string2, bundle);
        }

        public BrowserRoot(String string2, Bundle bundle) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$__constructor__(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
        }

        public String getRootId() {
            return InvokeDynamicSupport.bootstrap("getRootId", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getRootId(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_service_media_MediaBrowserService_BrowserRoot$getExtras(), 0, this);
        }

        public /* synthetic */ BrowserRoot() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BrowserRoot)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ServiceBinder
    extends IMediaBrowserService.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(MediaBrowserService mediaBrowserService) {
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$connect(String pkg, Bundle rootHints, IMediaBrowserServiceCallbacks callbacks) {
            int uid = Binder.getCallingUid();
            if (!this.this$0.isValidPackage(pkg, uid)) {
                throw new IllegalArgumentException("Package/uid mismatch: uid=" + uid + " package=" + pkg);
            }
            this.this$0.mHandler.post(new Runnable(this, callbacks, pkg, rootHints, uid){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$pkg;
                /* synthetic */ Bundle val$rootHints;
                /* synthetic */ int val$uid;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(ServiceBinder this$1, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, int n) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    this.this$1.this$0.mConnections.remove(b);
                    ConnectionRecord connection = new ConnectionRecord(this.this$1.this$0);
                    connection.pkg = this.val$pkg;
                    connection.rootHints = this.val$rootHints;
                    connection.callbacks = this.val$callbacks;
                    connection.root = this.this$1.this$0.onGetRoot(this.val$pkg, this.val$uid, this.val$rootHints);
                    if (connection.root == null) {
                        Log.i("MediaBrowserService", "No root for client " + this.val$pkg + " from service " + this.getClass().getName());
                        try {
                            this.val$callbacks.onConnectFailed();
                        }
                        catch (RemoteException ex) {
                            Log.w("MediaBrowserService", "Calling onConnectFailed() failed. Ignoring. pkg=" + this.val$pkg);
                        }
                    } else {
                        try {
                            this.this$1.this$0.mConnections.put(b, connection);
                            if (this.this$1.this$0.mSession != null) {
                                this.val$callbacks.onConnect(connection.root.getRootId(), this.this$1.this$0.mSession, connection.root.getExtras());
                            }
                        }
                        catch (RemoteException ex) {
                            Log.w("MediaBrowserService", "Calling onConnect() failed. Dropping client. pkg=" + this.val$pkg);
                            this.this$1.this$0.mConnections.remove(b);
                        }
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, Bundle bundle, int n) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2, bundle, n);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$pkg = string2;
                    this.val$rootHints = bundle;
                    this.val$uid = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.Bundle int ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2, bundle, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$disconnect(IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(ServiceBinder this$1, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord old = (ConnectionRecord)this.this$1.this$0.mConnections.remove(b);
                    if (old != null) {
                        // empty if block
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscriptionDeprecated(String id2, IMediaBrowserServiceCallbacks callbacks) {
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscription(String id2, IBinder token, Bundle options, IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks, id2, token, options){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$id;
                /* synthetic */ IBinder val$token;
                /* synthetic */ Bundle val$options;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(ServiceBinder this$1, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, IBinder iBinder, Bundle bundle) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)this.this$1.this$0.mConnections.get(b);
                    if (connection == null) {
                        Log.w("MediaBrowserService", "addSubscription for callback that isn't registered id=" + this.val$id);
                        return;
                    }
                    this.this$1.this$0.addSubscription(this.val$id, connection, this.val$token, this.val$options);
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, IBinder iBinder, Bundle bundle) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2, iBinder, bundle);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$id = string2;
                    this.val$token = iBinder;
                    this.val$options = bundle;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.IBinder android.os.Bundle ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2, iBinder, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscriptionDeprecated(String id2, IMediaBrowserServiceCallbacks callbacks) {
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscription(String id2, IBinder token, IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks, id2, token){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$id;
                /* synthetic */ IBinder val$token;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(ServiceBinder this$1, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, IBinder iBinder) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)this.this$1.this$0.mConnections.get(b);
                    if (connection == null) {
                        Log.w("MediaBrowserService", "removeSubscription for callback that isn't registered id=" + this.val$id);
                        return;
                    }
                    if (!this.this$1.this$0.removeSubscription(this.val$id, connection, this.val$token)) {
                        Log.w("MediaBrowserService", "removeSubscription called for " + this.val$id + " which is not subscribed");
                    }
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, IBinder iBinder) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2, iBinder);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$id = string2;
                    this.val$token = iBinder;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.IBinder ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2, iBinder);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$getMediaItem(String mediaId, ResultReceiver receiver, IMediaBrowserServiceCallbacks callbacks) {
            this.this$0.mHandler.post(new Runnable(this, callbacks, mediaId, receiver){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ IMediaBrowserServiceCallbacks val$callbacks;
                /* synthetic */ String val$mediaId;
                /* synthetic */ ResultReceiver val$receiver;
                /* synthetic */ ServiceBinder this$1;

                private void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_5$__constructor__(ServiceBinder this$1, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, ResultReceiver resultReceiver) {
                }

                private final void $$robo$$android_service_media_MediaBrowserService_ServiceBinder_5$run() {
                    IBinder b = this.val$callbacks.asBinder();
                    ConnectionRecord connection = (ConnectionRecord)this.this$1.this$0.mConnections.get(b);
                    if (connection == null) {
                        Log.w("MediaBrowserService", "getMediaItem for callback that isn't registered id=" + this.val$mediaId);
                        return;
                    }
                    this.this$1.this$0.performLoadItem(this.val$mediaId, connection, this.val$receiver);
                }

                private void __constructor__(ServiceBinder serviceBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks, String string2, ResultReceiver resultReceiver) {
                    this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder_5$__constructor__(serviceBinder, iMediaBrowserServiceCallbacks, string2, resultReceiver);
                }
                {
                    this.this$1 = serviceBinder;
                    this.val$callbacks = iMediaBrowserServiceCallbacks;
                    this.val$mediaId = string2;
                    this.val$receiver = resultReceiver;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_5$__constructor__(android.service.media.MediaBrowserService$ServiceBinder android.service.media.IMediaBrowserServiceCallbacks java.lang.String android.os.ResultReceiver ), 0, this, serviceBinder, iMediaBrowserServiceCallbacks, string2, resultReceiver);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_service_media_MediaBrowserService_ServiceBinder_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private /* synthetic */ void $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(MediaBrowserService x0, 1 x1) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService) {
            this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(mediaBrowserService);
        }

        private ServiceBinder(MediaBrowserService mediaBrowserService) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(android.service.media.MediaBrowserService ), 0, this, mediaBrowserService);
        }

        @Override
        public void connect(String string2, Bundle bundle, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("connect", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$connect(java.lang.String android.os.Bundle android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, bundle, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void disconnect(IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$disconnect(android.service.media.IMediaBrowserServiceCallbacks ), 0, this, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void addSubscriptionDeprecated(String string2, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("addSubscriptionDeprecated", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscriptionDeprecated(java.lang.String android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void addSubscription(String string2, IBinder iBinder, Bundle bundle, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("addSubscription", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$addSubscription(java.lang.String android.os.IBinder android.os.Bundle android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iBinder, bundle, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void removeSubscriptionDeprecated(String string2, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("removeSubscriptionDeprecated", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscriptionDeprecated(java.lang.String android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void removeSubscription(String string2, IBinder iBinder, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("removeSubscription", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$removeSubscription(java.lang.String android.os.IBinder android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, iBinder, iMediaBrowserServiceCallbacks);
        }

        @Override
        public void getMediaItem(String string2, ResultReceiver resultReceiver, IMediaBrowserServiceCallbacks iMediaBrowserServiceCallbacks) {
            InvokeDynamicSupport.bootstrap("getMediaItem", $$robo$$android_service_media_MediaBrowserService_ServiceBinder$getMediaItem(java.lang.String android.os.ResultReceiver android.service.media.IMediaBrowserServiceCallbacks ), 0, this, string2, resultReceiver, iMediaBrowserServiceCallbacks);
        }

        private /* synthetic */ void __constructor__(MediaBrowserService mediaBrowserService, 1 var2_2) {
            this.$$robo$$android_service_media_MediaBrowserService_ServiceBinder$__constructor__(mediaBrowserService, var2_2);
        }

        public /* synthetic */ ServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Result<T> {
        public transient /* synthetic */ Object __robo_data__;
        private Object mDebug;
        private boolean mDetachCalled;
        private boolean mSendResultCalled;
        private int mFlags;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_Result$__constructor__(MediaBrowserService this$0, Object debug) {
            this.mDebug = debug;
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$sendResult(T result) {
            if (this.mSendResultCalled) {
                throw new IllegalStateException("sendResult() called twice for: " + this.mDebug);
            }
            this.mSendResultCalled = true;
            this.onResultSent(result, this.mFlags);
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$detach() {
            if (this.mDetachCalled) {
                throw new IllegalStateException("detach() called when detach() had already been called for: " + this.mDebug);
            }
            if (this.mSendResultCalled) {
                throw new IllegalStateException("detach() called when sendResult() had already been called for: " + this.mDebug);
            }
            this.mDetachCalled = true;
        }

        private final boolean $$robo$$android_service_media_MediaBrowserService_Result$isDone() {
            return this.mDetachCalled || this.mSendResultCalled;
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$setFlags(int flags) {
            this.mFlags = flags;
        }

        private final void $$robo$$android_service_media_MediaBrowserService_Result$onResultSent(T result, int flags) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService, Object object) {
            this.$$robo$$android_service_media_MediaBrowserService_Result$__constructor__(mediaBrowserService, object);
        }

        Result(MediaBrowserService mediaBrowserService, Object object) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_Result$__constructor__(android.service.media.MediaBrowserService java.lang.Object ), 0, this, mediaBrowserService, object);
        }

        public void sendResult(T t) {
            InvokeDynamicSupport.bootstrap("sendResult", $$robo$$android_service_media_MediaBrowserService_Result$sendResult(T ), 0, this, t);
        }

        public void detach() {
            InvokeDynamicSupport.bootstrap("detach", $$robo$$android_service_media_MediaBrowserService_Result$detach(), 0, this);
        }

        boolean isDone() {
            return (boolean)InvokeDynamicSupport.bootstrap("isDone", $$robo$$android_service_media_MediaBrowserService_Result$isDone(), 0, this);
        }

        void setFlags(int n) {
            InvokeDynamicSupport.bootstrap("setFlags", $$robo$$android_service_media_MediaBrowserService_Result$setFlags(int ), 0, this, n);
        }

        void onResultSent(T t, int n) {
            InvokeDynamicSupport.bootstrap("onResultSent", $$robo$$android_service_media_MediaBrowserService_Result$onResultSent(T int ), 0, this, t, n);
        }

        public /* synthetic */ Result() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Result)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ConnectionRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String pkg;
        Bundle rootHints;
        IMediaBrowserServiceCallbacks callbacks;
        BrowserRoot root;
        HashMap<String, List<Pair<IBinder, Bundle>>> subscriptions;
        /* synthetic */ MediaBrowserService this$0;

        private void $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(MediaBrowserService mediaBrowserService) {
            this.subscriptions = new HashMap();
        }

        private /* synthetic */ void $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(MediaBrowserService x0, 1 x1) {
        }

        private void __constructor__(MediaBrowserService mediaBrowserService) {
            this.$$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(mediaBrowserService);
        }

        private ConnectionRecord(MediaBrowserService mediaBrowserService) {
            this.this$0 = mediaBrowserService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(android.service.media.MediaBrowserService ), 0, this, mediaBrowserService);
        }

        private /* synthetic */ void __constructor__(MediaBrowserService mediaBrowserService, 1 var2_2) {
            this.$$robo$$android_service_media_MediaBrowserService_ConnectionRecord$__constructor__(mediaBrowserService, var2_2);
        }

        public /* synthetic */ ConnectionRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ConnectionRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    private static @interface ResultFlags {
    }
}

