/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Process;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DefaultDialerManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DefaultDialerManager";

    private void $$robo$$android_telecom_DefaultDialerManager$__constructor__() {
    }

    private static final boolean $$robo$$android_telecom_DefaultDialerManager$setDefaultDialerApplication(Context context, String packageName) {
        return DefaultDialerManager.setDefaultDialerApplication(context, packageName, ActivityManager.getCurrentUser());
    }

    private static final boolean $$robo$$android_telecom_DefaultDialerManager$setDefaultDialerApplication(Context context, String packageName, int user) {
        String oldPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "dialer_default_application", user);
        if (packageName != null && oldPackageName != null && packageName.equals(oldPackageName)) {
            return false;
        }
        List<String> packageNames = DefaultDialerManager.getInstalledDialerApplications(context);
        if (packageNames.contains(packageName)) {
            Settings.Secure.putStringForUser(context.getContentResolver(), "dialer_default_application", packageName, user);
            return true;
        }
        return false;
    }

    private static final String $$robo$$android_telecom_DefaultDialerManager$getDefaultDialerApplication(Context context) {
        return DefaultDialerManager.getDefaultDialerApplication(context, context.getUserId());
    }

    private static final String $$robo$$android_telecom_DefaultDialerManager$getDefaultDialerApplication(Context context, int user) {
        String defaultPackageName = Settings.Secure.getStringForUser(context.getContentResolver(), "dialer_default_application", user);
        List<String> packageNames = DefaultDialerManager.getInstalledDialerApplications(context, user);
        if (packageNames.contains(defaultPackageName)) {
            return defaultPackageName;
        }
        String systemDialerPackageName = DefaultDialerManager.getTelecomManager(context).getSystemDialerPackage();
        if (TextUtils.isEmpty(systemDialerPackageName)) {
            return null;
        }
        if (packageNames.contains(systemDialerPackageName)) {
            return systemDialerPackageName;
        }
        return null;
    }

    private static final List<String> $$robo$$android_telecom_DefaultDialerManager$getInstalledDialerApplications(Context context, int userId) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.DIAL");
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 0, userId);
        ArrayList<String> packageNames = new ArrayList<String>();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || packageNames.contains(activityInfo.packageName)) continue;
            packageNames.add(activityInfo.packageName);
        }
        Intent dialIntentWithTelScheme = new Intent("android.intent.action.DIAL");
        dialIntentWithTelScheme.setData(Uri.fromParts("tel", "", null));
        return DefaultDialerManager.filterByIntent(context, packageNames, dialIntentWithTelScheme);
    }

    private static final List<String> $$robo$$android_telecom_DefaultDialerManager$getInstalledDialerApplications(Context context) {
        return DefaultDialerManager.getInstalledDialerApplications(context, Process.myUserHandle().getIdentifier());
    }

    private static final boolean $$robo$$android_telecom_DefaultDialerManager$isDefaultOrSystemDialer(Context context, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        TelecomManager tm = DefaultDialerManager.getTelecomManager(context);
        return packageName.equals(tm.getDefaultDialerPackage()) || packageName.equals(tm.getSystemDialerPackage());
    }

    private static final List<String> $$robo$$android_telecom_DefaultDialerManager$filterByIntent(Context context, List<String> packageNames, Intent intent) {
        if (packageNames == null || packageNames.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<ResolveInfo> resolveInfoList = context.getPackageManager().queryIntentActivities(intent, 0);
        int length = resolveInfoList.size();
        for (int i = 0; i < length; ++i) {
            ActivityInfo info = resolveInfoList.get((int)i).activityInfo;
            if (info == null || !packageNames.contains(info.packageName) || result.contains(info.packageName)) continue;
            result.add(info.packageName);
        }
        return result;
    }

    private static final TelecomManager $$robo$$android_telecom_DefaultDialerManager$getTelecomManager(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }

    private void __constructor__() {
        this.$$robo$$android_telecom_DefaultDialerManager$__constructor__();
    }

    public DefaultDialerManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_DefaultDialerManager$__constructor__(), 0, this);
    }

    public static boolean setDefaultDialerApplication(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setDefaultDialerApplication", $$robo$$android_telecom_DefaultDialerManager$setDefaultDialerApplication(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static boolean setDefaultDialerApplication(Context context, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("setDefaultDialerApplication", $$robo$$android_telecom_DefaultDialerManager$setDefaultDialerApplication(android.content.Context java.lang.String int ), 0, (Context)context, (String)string2, (int)n);
    }

    public static String getDefaultDialerApplication(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultDialerApplication", $$robo$$android_telecom_DefaultDialerManager$getDefaultDialerApplication(android.content.Context ), 0, (Context)context);
    }

    public static String getDefaultDialerApplication(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultDialerApplication", $$robo$$android_telecom_DefaultDialerManager$getDefaultDialerApplication(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static List<String> getInstalledDialerApplications(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInstalledDialerApplications", $$robo$$android_telecom_DefaultDialerManager$getInstalledDialerApplications(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static List<String> getInstalledDialerApplications(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstalledDialerApplications", $$robo$$android_telecom_DefaultDialerManager$getInstalledDialerApplications(android.content.Context ), 0, (Context)context);
    }

    public static boolean isDefaultOrSystemDialer(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDefaultOrSystemDialer", $$robo$$android_telecom_DefaultDialerManager$isDefaultOrSystemDialer(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private static List<String> filterByIntent(Context context, List<String> list, Intent intent) {
        return InvokeDynamicSupport.bootstrapStatic("filterByIntent", $$robo$$android_telecom_DefaultDialerManager$filterByIntent(android.content.Context java.util.List<java.lang.String> android.content.Intent ), 0, (Context)context, list, (Intent)intent);
    }

    private static TelecomManager getTelecomManager(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getTelecomManager", $$robo$$android_telecom_DefaultDialerManager$getTelecomManager(android.content.Context ), 0, (Context)context);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultDialerManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

