/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Selection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static Object SELECTION_START;
    public static Object SELECTION_END;

    private void $$robo$$android_text_Selection$__constructor__() {
    }

    private static final int $$robo$$android_text_Selection$getSelectionStart(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    private static final int $$robo$$android_text_Selection$getSelectionEnd(CharSequence text) {
        if (text instanceof Spanned) {
            return ((Spanned)text).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    private static final void $$robo$$android_text_Selection$setSelection(Spannable text, int start, int stop) {
        int ostart = Selection.getSelectionStart(text);
        int oend = Selection.getSelectionEnd(text);
        if (ostart != start || oend != stop) {
            text.setSpan(SELECTION_START, start, start, 546);
            text.setSpan(SELECTION_END, stop, stop, 34);
        }
    }

    private static final void $$robo$$android_text_Selection$setSelection(Spannable text, int index) {
        Selection.setSelection(text, index, index);
    }

    private static final void $$robo$$android_text_Selection$selectAll(Spannable text) {
        Selection.setSelection(text, 0, text.length());
    }

    private static final void $$robo$$android_text_Selection$extendSelection(Spannable text, int index) {
        if (text.getSpanStart(SELECTION_END) != index) {
            text.setSpan(SELECTION_END, index, index, 34);
        }
    }

    private static final void $$robo$$android_text_Selection$removeSelection(Spannable text) {
        text.removeSpan(SELECTION_START);
        text.removeSpan(SELECTION_END);
    }

    private static final boolean $$robo$$android_text_Selection$moveUp(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, min);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line - 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line - 1, h);
            } else {
                move = layout2.getLineStart(line - 1);
            }
            Selection.setSelection(text, move);
            return true;
        }
        if (end != 0) {
            Selection.setSelection(text, 0);
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_text_Selection$moveDown(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            int min = Math.min(start, end);
            int max = Math.max(start, end);
            Selection.setSelection(text, max);
            return min != 0 || max != text.length();
        }
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line + 1, h);
            } else {
                move = layout2.getLineStart(line + 1);
            }
            Selection.setSelection(text, move);
            return true;
        }
        if (end != text.length()) {
            Selection.setSelection(text, text.length());
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_text_Selection$moveLeft(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, -1, start, end));
            return true;
        }
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_text_Selection$moveRight(Spannable text, Layout layout2) {
        int end;
        int start = Selection.getSelectionStart(text);
        if (start != (end = Selection.getSelectionEnd(text))) {
            Selection.setSelection(text, Selection.chooseHorizontal(layout2, 1, start, end));
            return true;
        }
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.setSelection(text, to);
            return true;
        }
        return false;
    }

    private static final boolean $$robo$$android_text_Selection$extendUp(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line > 0) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line - 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line - 1, h);
            } else {
                move = layout2.getLineStart(line - 1);
            }
            Selection.extendSelection(text, move);
            return true;
        }
        if (end != 0) {
            Selection.extendSelection(text, 0);
            return true;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$extendDown(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(end);
        if (line < layout2.getLineCount() - 1) {
            int move;
            if (layout2.getParagraphDirection(line) == layout2.getParagraphDirection(line + 1)) {
                float h = layout2.getPrimaryHorizontal(end);
                move = layout2.getOffsetForHorizontal(line + 1, h);
            } else {
                move = layout2.getLineStart(line + 1);
            }
            Selection.extendSelection(text, move);
            return true;
        }
        if (end != text.length()) {
            Selection.extendSelection(text, text.length());
            return true;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$extendLeft(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToLeftOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$extendRight(Spannable text, Layout layout2) {
        int end = Selection.getSelectionEnd(text);
        int to = layout2.getOffsetToRightOf(end);
        if (to != end) {
            Selection.extendSelection(text, to);
            return true;
        }
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$extendToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.extendSelection(text, where);
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$extendToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.extendSelection(text, where);
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$moveToLeftEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, -1);
        Selection.setSelection(text, where);
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$moveToRightEdge(Spannable text, Layout layout2) {
        int where = Selection.findEdge(text, layout2, 1);
        Selection.setSelection(text, where);
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$moveToPreceding(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.preceding(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    private static final boolean $$robo$$android_text_Selection$moveToFollowing(Spannable text, PositionIterator iter, boolean extendSelection) {
        int offset = iter.following(Selection.getSelectionEnd(text));
        if (offset != -1) {
            if (extendSelection) {
                Selection.extendSelection(text, offset);
            } else {
                Selection.setSelection(text, offset);
            }
        }
        return true;
    }

    private static final int $$robo$$android_text_Selection$findEdge(Spannable text, Layout layout2, int dir) {
        int pt = Selection.getSelectionEnd(text);
        int line = layout2.getLineForOffset(pt);
        int pdir = layout2.getParagraphDirection(line);
        if (dir * pdir < 0) {
            return layout2.getLineStart(line);
        }
        int end = layout2.getLineEnd(line);
        if (line == layout2.getLineCount() - 1) {
            return end;
        }
        return end - 1;
    }

    private static final int $$robo$$android_text_Selection$chooseHorizontal(Layout layout2, int direction, int off1, int off2) {
        int line2;
        int line1 = layout2.getLineForOffset(off1);
        if (line1 == (line2 = layout2.getLineForOffset(off2))) {
            float h1 = layout2.getPrimaryHorizontal(off1);
            float h2 = layout2.getPrimaryHorizontal(off2);
            if (direction < 0) {
                if (h1 < h2) {
                    return off1;
                }
                return off2;
            }
            if (h1 > h2) {
                return off1;
            }
            return off2;
        }
        int line = layout2.getLineForOffset(off1);
        int textdir = layout2.getParagraphDirection(line);
        if (textdir == direction) {
            return Math.max(off1, off2);
        }
        return Math.min(off1, off2);
    }

    static void __staticInitializer__() {
        SELECTION_START = new START();
        SELECTION_END = new END();
    }

    private void __constructor__() {
        this.$$robo$$android_text_Selection$__constructor__();
    }

    private Selection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Selection$__constructor__(), 0, this);
    }

    public static int getSelectionStart(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSelectionStart", $$robo$$android_text_Selection$getSelectionStart(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static int getSelectionEnd(CharSequence charSequence) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSelectionEnd", $$robo$$android_text_Selection$getSelectionEnd(java.lang.CharSequence ), 0, (CharSequence)charSequence);
    }

    public static void setSelection(Spannable spannable, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("setSelection", $$robo$$android_text_Selection$setSelection(android.text.Spannable int int ), 0, (Spannable)spannable, (int)n, (int)n2);
    }

    public static void setSelection(Spannable spannable, int n) {
        InvokeDynamicSupport.bootstrapStatic("setSelection", $$robo$$android_text_Selection$setSelection(android.text.Spannable int ), 0, (Spannable)spannable, (int)n);
    }

    public static void selectAll(Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("selectAll", $$robo$$android_text_Selection$selectAll(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public static void extendSelection(Spannable spannable, int n) {
        InvokeDynamicSupport.bootstrapStatic("extendSelection", $$robo$$android_text_Selection$extendSelection(android.text.Spannable int ), 0, (Spannable)spannable, (int)n);
    }

    public static void removeSelection(Spannable spannable) {
        InvokeDynamicSupport.bootstrapStatic("removeSelection", $$robo$$android_text_Selection$removeSelection(android.text.Spannable ), 0, (Spannable)spannable);
    }

    public static boolean moveUp(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveUp", $$robo$$android_text_Selection$moveUp(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveDown(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveDown", $$robo$$android_text_Selection$moveDown(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveLeft(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveLeft", $$robo$$android_text_Selection$moveLeft(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveRight(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveRight", $$robo$$android_text_Selection$moveRight(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendUp(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendUp", $$robo$$android_text_Selection$extendUp(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendDown(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendDown", $$robo$$android_text_Selection$extendDown(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendLeft(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendLeft", $$robo$$android_text_Selection$extendLeft(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendRight(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendRight", $$robo$$android_text_Selection$extendRight(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendToLeftEdge(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendToLeftEdge", $$robo$$android_text_Selection$extendToLeftEdge(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean extendToRightEdge(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("extendToRightEdge", $$robo$$android_text_Selection$extendToRightEdge(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveToLeftEdge(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveToLeftEdge", $$robo$$android_text_Selection$moveToLeftEdge(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveToRightEdge(Spannable spannable, Layout layout2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveToRightEdge", $$robo$$android_text_Selection$moveToRightEdge(android.text.Spannable android.text.Layout ), 0, (Spannable)spannable, (Layout)layout2);
    }

    public static boolean moveToPreceding(Spannable spannable, PositionIterator positionIterator, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveToPreceding", $$robo$$android_text_Selection$moveToPreceding(android.text.Spannable android.text.Selection$PositionIterator boolean ), 0, (Spannable)spannable, (PositionIterator)positionIterator, (boolean)bl);
    }

    public static boolean moveToFollowing(Spannable spannable, PositionIterator positionIterator, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("moveToFollowing", $$robo$$android_text_Selection$moveToFollowing(android.text.Spannable android.text.Selection$PositionIterator boolean ), 0, (Spannable)spannable, (PositionIterator)positionIterator, (boolean)bl);
    }

    private static int findEdge(Spannable spannable, Layout layout2, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findEdge", $$robo$$android_text_Selection$findEdge(android.text.Spannable android.text.Layout int ), 0, (Spannable)spannable, (Layout)layout2, (int)n);
    }

    private static int chooseHorizontal(Layout layout2, int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("chooseHorizontal", $$robo$$android_text_Selection$chooseHorizontal(android.text.Layout int int int ), 0, (Layout)layout2, (int)n, (int)n2, (int)n3);
    }

    static {
        RobolectricInternals.classInitializing(Selection.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Selection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class END
    implements NoCopySpan,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_Selection_END$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_Selection_END$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_Selection_END$__constructor__();
        }

        private END() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Selection_END$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_Selection_END$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (END)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class START
    implements NoCopySpan,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_Selection_START$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_Selection_START$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_Selection_START$__constructor__();
        }

        private START() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_Selection_START$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_Selection_START$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (START)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface PositionIterator
    extends InstrumentedInterface {
        public static final int DONE = -1;

        public int preceding(int var1);

        public int following(int var1);
    }
}

