/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.text.CharSequenceCharacterIterator;
import android.text.Selection;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WordIterator
implements Selection.PositionIterator,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int WINDOW_WIDTH = 50;
    private int mStart;
    private int mEnd;
    private CharSequence mCharSeq;
    private BreakIterator mIterator;

    private void $$robo$$android_text_method_WordIterator$__constructor__() {
    }

    private void $$robo$$android_text_method_WordIterator$__constructor__(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    private final void $$robo$$android_text_method_WordIterator$setCharSequence(CharSequence charSequence, int start, int end) {
        if (0 > start || end > charSequence.length()) {
            throw new IndexOutOfBoundsException("input indexes are outside the CharSequence");
        }
        this.mCharSeq = charSequence;
        this.mStart = Math.max(0, start - 50);
        this.mEnd = Math.min(charSequence.length(), end + 50);
        this.mIterator.setText(new CharSequenceCharacterIterator(charSequence, this.mStart, this.mEnd));
    }

    private final int $$robo$$android_text_method_WordIterator$preceding(int offset) {
        this.checkOffsetIsValid(offset);
        while ((offset = this.mIterator.preceding(offset)) != -1 && !this.isOnLetterOrDigit(offset)) {
        }
        return offset;
    }

    private final int $$robo$$android_text_method_WordIterator$following(int offset) {
        this.checkOffsetIsValid(offset);
        while ((offset = this.mIterator.following(offset)) != -1 && !this.isAfterLetterOrDigit(offset)) {
        }
        return offset;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.isBoundary(offset);
    }

    private final int $$robo$$android_text_method_WordIterator$nextBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.following(offset);
    }

    private final int $$robo$$android_text_method_WordIterator$prevBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.preceding(offset);
    }

    private final int $$robo$$android_text_method_WordIterator$getBeginning(int offset) {
        return this.getBeginning(offset, false);
    }

    private final int $$robo$$android_text_method_WordIterator$getEnd(int offset) {
        return this.getEnd(offset, false);
    }

    private final int $$robo$$android_text_method_WordIterator$getPrevWordBeginningOnTwoWordsBoundary(int offset) {
        return this.getBeginning(offset, true);
    }

    private final int $$robo$$android_text_method_WordIterator$getNextWordEndOnTwoWordBoundary(int offset) {
        return this.getEnd(offset, true);
    }

    private final int $$robo$$android_text_method_WordIterator$getBeginning(int offset, boolean getPrevWordBeginningOnTwoWordsBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isOnLetterOrDigit(offset)) {
            if (!(!this.mIterator.isBoundary(offset) || this.isAfterLetterOrDigit(offset) && getPrevWordBeginningOnTwoWordsBoundary)) {
                return offset;
            }
            return this.mIterator.preceding(offset);
        }
        if (this.isAfterLetterOrDigit(offset)) {
            return this.mIterator.preceding(offset);
        }
        return -1;
    }

    private final int $$robo$$android_text_method_WordIterator$getEnd(int offset, boolean getNextWordEndOnTwoWordBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isAfterLetterOrDigit(offset)) {
            if (!(!this.mIterator.isBoundary(offset) || this.isOnLetterOrDigit(offset) && getNextWordEndOnTwoWordBoundary)) {
                return offset;
            }
            return this.mIterator.following(offset);
        }
        if (this.isOnLetterOrDigit(offset)) {
            return this.mIterator.following(offset);
        }
        return -1;
    }

    private final int $$robo$$android_text_method_WordIterator$getPunctuationBeginning(int offset) {
        this.checkOffsetIsValid(offset);
        while (offset != -1 && !this.isPunctuationStartBoundary(offset)) {
            offset = this.prevBoundary(offset);
        }
        return offset;
    }

    private final int $$robo$$android_text_method_WordIterator$getPunctuationEnd(int offset) {
        this.checkOffsetIsValid(offset);
        while (offset != -1 && !this.isPunctuationEndBoundary(offset)) {
            offset = this.nextBoundary(offset);
        }
        return offset;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isAfterPunctuation(int offset) {
        if (this.mStart < offset && offset <= this.mEnd) {
            int codePoint = Character.codePointBefore(this.mCharSeq, offset);
            return WordIterator.isPunctuation(codePoint);
        }
        return false;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isOnPunctuation(int offset) {
        if (this.mStart <= offset && offset < this.mEnd) {
            int codePoint = Character.codePointAt(this.mCharSeq, offset);
            return WordIterator.isPunctuation(codePoint);
        }
        return false;
    }

    private static final boolean $$robo$$android_text_method_WordIterator$isMidWordPunctuation(Locale locale, int codePoint) {
        int wb = UCharacter.getIntPropertyValue(codePoint, 4116);
        return wb == 4 || wb == 11 || wb == 15;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isPunctuationStartBoundary(int offset) {
        return this.isOnPunctuation(offset) && !this.isAfterPunctuation(offset);
    }

    private final boolean $$robo$$android_text_method_WordIterator$isPunctuationEndBoundary(int offset) {
        return !this.isOnPunctuation(offset) && this.isAfterPunctuation(offset);
    }

    private static final boolean $$robo$$android_text_method_WordIterator$isPunctuation(int cp) {
        int type = Character.getType(cp);
        return type == 23 || type == 20 || type == 22 || type == 30 || type == 29 || type == 24 || type == 21;
    }

    private final boolean $$robo$$android_text_method_WordIterator$isAfterLetterOrDigit(int offset) {
        int codePoint;
        return this.mStart < offset && offset <= this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointBefore(this.mCharSeq, offset));
    }

    private final boolean $$robo$$android_text_method_WordIterator$isOnLetterOrDigit(int offset) {
        int codePoint;
        return this.mStart <= offset && offset < this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointAt(this.mCharSeq, offset));
    }

    private final void $$robo$$android_text_method_WordIterator$checkOffsetIsValid(int offset) {
        if (this.mStart > offset || offset > this.mEnd) {
            throw new IllegalArgumentException("Invalid offset: " + offset + ". Valid range is [" + this.mStart + ", " + this.mEnd + "]");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_text_method_WordIterator$__constructor__();
    }

    public WordIterator() {
        this(Locale.getDefault());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_WordIterator$__constructor__(), 0, this);
    }

    private void __constructor__(Locale locale) {
        this.$$robo$$android_text_method_WordIterator$__constructor__(locale);
    }

    public WordIterator(Locale locale) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_WordIterator$__constructor__(java.util.Locale ), 0, this, locale);
    }

    public void setCharSequence(CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setCharSequence", $$robo$$android_text_method_WordIterator$setCharSequence(java.lang.CharSequence int int ), 0, this, charSequence, n, n2);
    }

    @Override
    public int preceding(int n) {
        return (int)InvokeDynamicSupport.bootstrap("preceding", $$robo$$android_text_method_WordIterator$preceding(int ), 0, this, n);
    }

    @Override
    public int following(int n) {
        return (int)InvokeDynamicSupport.bootstrap("following", $$robo$$android_text_method_WordIterator$following(int ), 0, this, n);
    }

    public boolean isBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBoundary", $$robo$$android_text_method_WordIterator$isBoundary(int ), 0, this, n);
    }

    public int nextBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("nextBoundary", $$robo$$android_text_method_WordIterator$nextBoundary(int ), 0, this, n);
    }

    public int prevBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("prevBoundary", $$robo$$android_text_method_WordIterator$prevBoundary(int ), 0, this, n);
    }

    public int getBeginning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getBeginning", $$robo$$android_text_method_WordIterator$getBeginning(int ), 0, this, n);
    }

    public int getEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_text_method_WordIterator$getEnd(int ), 0, this, n);
    }

    public int getPrevWordBeginningOnTwoWordsBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPrevWordBeginningOnTwoWordsBoundary", $$robo$$android_text_method_WordIterator$getPrevWordBeginningOnTwoWordsBoundary(int ), 0, this, n);
    }

    public int getNextWordEndOnTwoWordBoundary(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNextWordEndOnTwoWordBoundary", $$robo$$android_text_method_WordIterator$getNextWordEndOnTwoWordBoundary(int ), 0, this, n);
    }

    private int getBeginning(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getBeginning", $$robo$$android_text_method_WordIterator$getBeginning(int boolean ), 0, this, n, bl);
    }

    private int getEnd(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getEnd", $$robo$$android_text_method_WordIterator$getEnd(int boolean ), 0, this, n, bl);
    }

    public int getPunctuationBeginning(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPunctuationBeginning", $$robo$$android_text_method_WordIterator$getPunctuationBeginning(int ), 0, this, n);
    }

    public int getPunctuationEnd(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPunctuationEnd", $$robo$$android_text_method_WordIterator$getPunctuationEnd(int ), 0, this, n);
    }

    public boolean isAfterPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfterPunctuation", $$robo$$android_text_method_WordIterator$isAfterPunctuation(int ), 0, this, n);
    }

    public boolean isOnPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnPunctuation", $$robo$$android_text_method_WordIterator$isOnPunctuation(int ), 0, this, n);
    }

    public static boolean isMidWordPunctuation(Locale locale, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isMidWordPunctuation", $$robo$$android_text_method_WordIterator$isMidWordPunctuation(java.util.Locale int ), 0, (Locale)locale, (int)n);
    }

    private boolean isPunctuationStartBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPunctuationStartBoundary", $$robo$$android_text_method_WordIterator$isPunctuationStartBoundary(int ), 0, this, n);
    }

    private boolean isPunctuationEndBoundary(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPunctuationEndBoundary", $$robo$$android_text_method_WordIterator$isPunctuationEndBoundary(int ), 0, this, n);
    }

    private static boolean isPunctuation(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPunctuation", $$robo$$android_text_method_WordIterator$isPunctuation(int ), 0, (int)n);
    }

    private boolean isAfterLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isAfterLetterOrDigit", $$robo$$android_text_method_WordIterator$isAfterLetterOrDigit(int ), 0, this, n);
    }

    private boolean isOnLetterOrDigit(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnLetterOrDigit", $$robo$$android_text_method_WordIterator$isOnLetterOrDigit(int ), 0, this, n);
    }

    private void checkOffsetIsValid(int n) {
        InvokeDynamicSupport.bootstrap("checkOffsetIsValid", $$robo$$android_text_method_WordIterator$checkOffsetIsValid(int ), 0, this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WordIterator)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

