/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChangeImageTransform
extends Transition
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ChangeImageTransform";
    private static String PROPNAME_MATRIX = "android:changeImageTransform:matrix";
    private static String PROPNAME_BOUNDS = "android:changeImageTransform:bounds";
    private static String[] sTransitionProperties;
    private static TypeEvaluator<Matrix> NULL_MATRIX_EVALUATOR;
    private static Property<ImageView, Matrix> ANIMATED_TRANSFORM_PROPERTY;

    private void $$robo$$android_transition_ChangeImageTransform$__constructor__() {
    }

    private void $$robo$$android_transition_ChangeImageTransform$__constructor__(Context context, AttributeSet attrs) {
    }

    private final void $$robo$$android_transition_ChangeImageTransform$captureValues(TransitionValues transitionValues) {
        Matrix matrix;
        View view = transitionValues.view;
        if (!(view instanceof ImageView) || view.getVisibility() != 0) {
            return;
        }
        ImageView imageView = (ImageView)view;
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Map<String, Object> values = transitionValues.values;
        int left = view.getLeft();
        int top = view.getTop();
        int right = view.getRight();
        int bottom = view.getBottom();
        Rect bounds = new Rect(left, top, right, bottom);
        values.put("android:changeImageTransform:bounds", bounds);
        ImageView.ScaleType scaleType = imageView.getScaleType();
        if (scaleType == ImageView.ScaleType.FIT_XY) {
            matrix = imageView.getImageMatrix();
            if (!matrix.isIdentity()) {
                matrix = new Matrix(matrix);
            } else {
                int drawableWidth = drawable2.getIntrinsicWidth();
                int drawableHeight = drawable2.getIntrinsicHeight();
                if (drawableWidth > 0 && drawableHeight > 0) {
                    float scaleX = (float)bounds.width() / (float)drawableWidth;
                    float scaleY = (float)bounds.height() / (float)drawableHeight;
                    matrix = new Matrix();
                    matrix.setScale(scaleX, scaleY);
                } else {
                    matrix = null;
                }
            }
        } else {
            matrix = new Matrix(imageView.getImageMatrix());
        }
        values.put("android:changeImageTransform:matrix", matrix);
    }

    private final void $$robo$$android_transition_ChangeImageTransform$captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final void $$robo$$android_transition_ChangeImageTransform$captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final String[] $$robo$$android_transition_ChangeImageTransform$getTransitionProperties() {
        return sTransitionProperties;
    }

    private final Animator $$robo$$android_transition_ChangeImageTransform$createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        ObjectAnimator animator2;
        boolean matricesEqual;
        if (startValues == null || endValues == null) {
            return null;
        }
        Rect startBounds = (Rect)startValues.values.get("android:changeImageTransform:bounds");
        Rect endBounds = (Rect)endValues.values.get("android:changeImageTransform:bounds");
        if (startBounds == null || endBounds == null) {
            return null;
        }
        Matrix startMatrix = (Matrix)startValues.values.get("android:changeImageTransform:matrix");
        Matrix endMatrix = (Matrix)endValues.values.get("android:changeImageTransform:matrix");
        boolean bl = matricesEqual = startMatrix == null && endMatrix == null || startMatrix != null && startMatrix.equals(endMatrix);
        if (startBounds.equals(endBounds) && matricesEqual) {
            return null;
        }
        ImageView imageView = (ImageView)endValues.view;
        Drawable drawable2 = imageView.getDrawable();
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        if (drawableWidth == 0 || drawableHeight == 0) {
            animator2 = this.createNullAnimator(imageView);
        } else {
            if (startMatrix == null) {
                startMatrix = Matrix.IDENTITY_MATRIX;
            }
            if (endMatrix == null) {
                endMatrix = Matrix.IDENTITY_MATRIX;
            }
            ANIMATED_TRANSFORM_PROPERTY.set(imageView, startMatrix);
            animator2 = this.createMatrixAnimator(imageView, startMatrix, endMatrix);
        }
        return animator2;
    }

    private final ObjectAnimator $$robo$$android_transition_ChangeImageTransform$createNullAnimator(ImageView imageView) {
        return ObjectAnimator.ofObject(imageView, ANIMATED_TRANSFORM_PROPERTY, NULL_MATRIX_EVALUATOR, null, null);
    }

    private final ObjectAnimator $$robo$$android_transition_ChangeImageTransform$createMatrixAnimator(ImageView imageView, Matrix startMatrix, Matrix endMatrix) {
        return ObjectAnimator.ofObject(imageView, ANIMATED_TRANSFORM_PROPERTY, new TransitionUtils.MatrixEvaluator(), startMatrix, endMatrix);
    }

    static void __staticInitializer__() {
        sTransitionProperties = new String[]{"android:changeImageTransform:matrix", "android:changeImageTransform:bounds"};
        NULL_MATRIX_EVALUATOR = new TypeEvaluator<Matrix>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_transition_ChangeImageTransform_1$__constructor__() {
            }

            private final Matrix $$robo$$android_transition_ChangeImageTransform_1$evaluate(float fraction2, Matrix startValue, Matrix endValue) {
                return null;
            }

            private void __constructor__() {
                this.$$robo$$android_transition_ChangeImageTransform_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeImageTransform_1$__constructor__(), 0, this);
            }

            @Override
            public Matrix evaluate(float f, Matrix matrix, Matrix matrix2) {
                return InvokeDynamicSupport.bootstrap("evaluate", $$robo$$android_transition_ChangeImageTransform_1$evaluate(float android.graphics.Matrix android.graphics.Matrix ), 0, this, f, matrix, matrix2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        ANIMATED_TRANSFORM_PROPERTY = new Property<ImageView, Matrix>(Matrix.class, "animatedTransform"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_transition_ChangeImageTransform_2$__constructor__(Class type, String name) {
            }

            private final void $$robo$$android_transition_ChangeImageTransform_2$set(ImageView object, Matrix value) {
                object.animateTransform(value);
            }

            private final Matrix $$robo$$android_transition_ChangeImageTransform_2$get(ImageView object) {
                return null;
            }

            private void __constructor__(Class clazz, String string2) {
                this.$$robo$$android_transition_ChangeImageTransform_2$__constructor__(clazz, string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeImageTransform_2$__constructor__(java.lang.Class java.lang.String ), 0, this, clazz, string2);
            }

            @Override
            public void set(ImageView imageView, Matrix matrix) {
                InvokeDynamicSupport.bootstrap("set", $$robo$$android_transition_ChangeImageTransform_2$set(android.widget.ImageView android.graphics.Matrix ), 0, this, imageView, matrix);
            }

            @Override
            public Matrix get(ImageView imageView) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_transition_ChangeImageTransform_2$get(android.widget.ImageView ), 0, this, imageView);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_transition_ChangeImageTransform$__constructor__();
    }

    public ChangeImageTransform() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeImageTransform$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_ChangeImageTransform$__constructor__(context, attributeSet);
    }

    public ChangeImageTransform(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_ChangeImageTransform$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void captureValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_ChangeImageTransform$captureValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_ChangeImageTransform$captureStartValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_ChangeImageTransform$captureEndValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public String[] getTransitionProperties() {
        return InvokeDynamicSupport.bootstrap("getTransitionProperties", $$robo$$android_transition_ChangeImageTransform$getTransitionProperties(), 0, this);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_transition_ChangeImageTransform$createAnimator(android.view.ViewGroup android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transitionValues, transitionValues2);
    }

    private ObjectAnimator createNullAnimator(ImageView imageView) {
        return InvokeDynamicSupport.bootstrap("createNullAnimator", $$robo$$android_transition_ChangeImageTransform$createNullAnimator(android.widget.ImageView ), 0, this, imageView);
    }

    private ObjectAnimator createMatrixAnimator(ImageView imageView, Matrix matrix, Matrix matrix2) {
        return InvokeDynamicSupport.bootstrap("createMatrixAnimator", $$robo$$android_transition_ChangeImageTransform$createMatrixAnimator(android.widget.ImageView android.graphics.Matrix android.graphics.Matrix ), 0, this, imageView, matrix, matrix2);
    }

    static {
        RobolectricInternals.classInitializing(ChangeImageTransform.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChangeImageTransform)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

