/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.transition.VisibilityPropagation;
import android.view.View;
import android.view.ViewGroup;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SidePropagation
extends VisibilityPropagation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SlidePropagation";
    private float mPropagationSpeed;
    private int mSide;

    private void $$robo$$android_transition_SidePropagation$__constructor__() {
        this.mPropagationSpeed = 3.0f;
        this.mSide = 80;
    }

    private final void $$robo$$android_transition_SidePropagation$setSide(int side) {
        this.mSide = side;
    }

    private final void $$robo$$android_transition_SidePropagation$setPropagationSpeed(float propagationSpeed) {
        if (propagationSpeed == 0.0f) {
            throw new IllegalArgumentException("propagationSpeed may not be 0");
        }
        this.mPropagationSpeed = propagationSpeed;
    }

    private final long $$robo$$android_transition_SidePropagation$getStartDelay(ViewGroup sceneRoot, Transition transition2, TransitionValues startValues, TransitionValues endValues) {
        int epicenterY;
        int epicenterX;
        TransitionValues positionValues;
        if (startValues == null && endValues == null) {
            return 0L;
        }
        int directionMultiplier = 1;
        Rect epicenter = transition2.getEpicenter();
        if (endValues == null || this.getViewVisibility(startValues) == 0) {
            positionValues = startValues;
            directionMultiplier = -1;
        } else {
            positionValues = endValues;
        }
        int viewCenterX = this.getViewX(positionValues);
        int viewCenterY = this.getViewY(positionValues);
        int[] loc = new int[2];
        sceneRoot.getLocationOnScreen(loc);
        int left = loc[0] + Math.round(sceneRoot.getTranslationX());
        int top = loc[1] + Math.round(sceneRoot.getTranslationY());
        int right = left + sceneRoot.getWidth();
        int bottom = top + sceneRoot.getHeight();
        if (epicenter != null) {
            epicenterX = epicenter.centerX();
            epicenterY = epicenter.centerY();
        } else {
            epicenterX = (left + right) / 2;
            epicenterY = (top + bottom) / 2;
        }
        float distance = this.distance(sceneRoot, viewCenterX, viewCenterY, epicenterX, epicenterY, left, top, right, bottom);
        float maxDistance = this.getMaxDistance(sceneRoot);
        float distanceFraction = distance / maxDistance;
        long duration = transition2.getDuration();
        if (duration < 0L) {
            duration = 300L;
        }
        return Math.round((float)(duration * (long)directionMultiplier) / this.mPropagationSpeed * distanceFraction);
    }

    private final int $$robo$$android_transition_SidePropagation$distance(View sceneRoot, int viewX, int viewY, int epicenterX, int epicenterY, int left, int top, int right, int bottom) {
        int side;
        boolean isRtl;
        if (this.mSide == 0x800003) {
            isRtl = sceneRoot.getLayoutDirection() == 1;
            side = isRtl ? 5 : 3;
        } else if (this.mSide == 0x800005) {
            isRtl = sceneRoot.getLayoutDirection() == 1;
            side = isRtl ? 3 : 5;
        } else {
            side = this.mSide;
        }
        int distance = 0;
        switch (side) {
            case 3: {
                distance = right - viewX + Math.abs(epicenterY - viewY);
                break;
            }
            case 48: {
                distance = bottom - viewY + Math.abs(epicenterX - viewX);
                break;
            }
            case 5: {
                distance = viewX - left + Math.abs(epicenterY - viewY);
                break;
            }
            case 80: {
                distance = viewY - top + Math.abs(epicenterX - viewX);
            }
        }
        return distance;
    }

    private final int $$robo$$android_transition_SidePropagation$getMaxDistance(ViewGroup sceneRoot) {
        switch (this.mSide) {
            case 3: 
            case 5: 
            case 0x800003: 
            case 0x800005: {
                return sceneRoot.getWidth();
            }
        }
        return sceneRoot.getHeight();
    }

    private void __constructor__() {
        this.$$robo$$android_transition_SidePropagation$__constructor__();
    }

    public SidePropagation() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_SidePropagation$__constructor__(), 0, this);
    }

    public void setSide(int n) {
        InvokeDynamicSupport.bootstrap("setSide", $$robo$$android_transition_SidePropagation$setSide(int ), 0, this, n);
    }

    public void setPropagationSpeed(float f) {
        InvokeDynamicSupport.bootstrap("setPropagationSpeed", $$robo$$android_transition_SidePropagation$setPropagationSpeed(float ), 0, this, f);
    }

    @Override
    public long getStartDelay(ViewGroup viewGroup, Transition transition2, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return (long)InvokeDynamicSupport.bootstrap("getStartDelay", $$robo$$android_transition_SidePropagation$getStartDelay(android.view.ViewGroup android.transition.Transition android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transition2, transitionValues, transitionValues2);
    }

    private int distance(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (int)InvokeDynamicSupport.bootstrap("distance", $$robo$$android_transition_SidePropagation$distance(android.view.View int int int int int int int int ), 0, this, view, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private int getMaxDistance(ViewGroup viewGroup) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxDistance", $$robo$$android_transition_SidePropagation$getMaxDistance(android.view.ViewGroup ), 0, this, viewGroup);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SidePropagation)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

