/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.JsonScope;
import android.util.JsonToken;
import android.util.MalformedJsonException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import libcore.internal.StringPool;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class JsonReader
implements Closeable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TRUE = "true";
    private static String FALSE = "false";
    private StringPool stringPool;
    private Reader in;
    private boolean lenient;
    private char[] buffer;
    private int pos;
    private int limit;
    private int bufferStartLine;
    private int bufferStartColumn;
    private List<JsonScope> stack;
    private JsonToken token;
    private String name;
    private String value;
    private int valuePos;
    private int valueLength;
    private boolean skipping;

    private void $$robo$$android_util_JsonReader$__constructor__(Reader in) {
        this.stringPool = new StringPool();
        this.lenient = false;
        this.buffer = new char[1024];
        this.pos = 0;
        this.limit = 0;
        this.bufferStartLine = 1;
        this.bufferStartColumn = 1;
        this.stack = new ArrayList<JsonScope>();
        this.push(JsonScope.EMPTY_DOCUMENT);
        this.skipping = false;
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        this.in = in;
    }

    private final void $$robo$$android_util_JsonReader$setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    private final boolean $$robo$$android_util_JsonReader$isLenient() {
        return this.lenient;
    }

    private final void $$robo$$android_util_JsonReader$beginArray() throws IOException {
        this.expect(JsonToken.BEGIN_ARRAY);
    }

    private final void $$robo$$android_util_JsonReader$endArray() throws IOException {
        this.expect(JsonToken.END_ARRAY);
    }

    private final void $$robo$$android_util_JsonReader$beginObject() throws IOException {
        this.expect(JsonToken.BEGIN_OBJECT);
    }

    private final void $$robo$$android_util_JsonReader$endObject() throws IOException {
        this.expect(JsonToken.END_OBJECT);
    }

    private final void $$robo$$android_util_JsonReader$expect(JsonToken expected) throws IOException {
        this.peek();
        if (this.token != expected) {
            throw new IllegalStateException("Expected " + (Object)((Object)expected) + " but was " + (Object)((Object)this.peek()));
        }
        this.advance();
    }

    private final boolean $$robo$$android_util_JsonReader$hasNext() throws IOException {
        this.peek();
        return this.token != JsonToken.END_OBJECT && this.token != JsonToken.END_ARRAY;
    }

    private final JsonToken $$robo$$android_util_JsonReader$peek() throws IOException {
        if (this.token != null) {
            return this.token;
        }
        switch (1.$SwitchMap$android$util$JsonScope[this.peekStack().ordinal()]) {
            case 1: {
                this.replaceTop(JsonScope.NONEMPTY_DOCUMENT);
                JsonToken firstToken = this.nextValue();
                if (!this.lenient && this.token != JsonToken.BEGIN_ARRAY && this.token != JsonToken.BEGIN_OBJECT) {
                    throw new IOException("Expected JSON document to start with '[' or '{' but was " + (Object)((Object)this.token));
                }
                return firstToken;
            }
            case 2: {
                return this.nextInArray(true);
            }
            case 3: {
                return this.nextInArray(false);
            }
            case 4: {
                return this.nextInObject(true);
            }
            case 5: {
                return this.objectValue();
            }
            case 6: {
                return this.nextInObject(false);
            }
            case 7: {
                try {
                    JsonToken token = this.nextValue();
                    if (this.lenient) {
                        return token;
                    }
                    throw this.syntaxError("Expected EOF");
                }
                catch (EOFException e) {
                    this.token = JsonToken.END_DOCUMENT;
                    return this.token;
                }
            }
            case 8: {
                throw new IllegalStateException("JsonReader is closed");
            }
        }
        throw new AssertionError();
    }

    private final JsonToken $$robo$$android_util_JsonReader$advance() throws IOException {
        this.peek();
        JsonToken result = this.token;
        this.token = null;
        this.value = null;
        this.name = null;
        return result;
    }

    private final String $$robo$$android_util_JsonReader$nextName() throws IOException {
        this.peek();
        if (this.token != JsonToken.NAME) {
            throw new IllegalStateException("Expected a name but was " + (Object)((Object)this.peek()));
        }
        String result = this.name;
        this.advance();
        return result;
    }

    private final String $$robo$$android_util_JsonReader$nextString() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a string but was " + (Object)((Object)this.peek()));
        }
        String result = this.value;
        this.advance();
        return result;
    }

    private final boolean $$robo$$android_util_JsonReader$nextBoolean() throws IOException {
        this.peek();
        if (this.token != JsonToken.BOOLEAN) {
            throw new IllegalStateException("Expected a boolean but was " + (Object)((Object)this.token));
        }
        boolean result = this.value == "true";
        this.advance();
        return result;
    }

    private final void $$robo$$android_util_JsonReader$nextNull() throws IOException {
        this.peek();
        if (this.token != JsonToken.NULL) {
            throw new IllegalStateException("Expected null but was " + (Object)((Object)this.token));
        }
        this.advance();
    }

    private final double $$robo$$android_util_JsonReader$nextDouble() throws IOException {
        this.peek();
        if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
            throw new IllegalStateException("Expected a double but was " + (Object)((Object)this.token));
        }
        double result = Double.parseDouble(this.value);
        this.advance();
        return result;
    }

    private final long $$robo$$android_util_JsonReader$nextLong() throws IOException {
        long result;
        block3: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected a long but was " + (Object)((Object)this.token));
            }
            try {
                result = Long.parseLong(this.value);
            }
            catch (NumberFormatException ignored) {
                double asDouble = Double.parseDouble(this.value);
                result = (long)asDouble;
                if ((double)result == asDouble) break block3;
                throw new NumberFormatException(this.value);
            }
        }
        this.advance();
        return result;
    }

    private final int $$robo$$android_util_JsonReader$nextInt() throws IOException {
        int result;
        block3: {
            this.peek();
            if (this.token != JsonToken.STRING && this.token != JsonToken.NUMBER) {
                throw new IllegalStateException("Expected an int but was " + (Object)((Object)this.token));
            }
            try {
                result = Integer.parseInt(this.value);
            }
            catch (NumberFormatException ignored) {
                double asDouble = Double.parseDouble(this.value);
                result = (int)asDouble;
                if ((double)result == asDouble) break block3;
                throw new NumberFormatException(this.value);
            }
        }
        this.advance();
        return result;
    }

    private final void $$robo$$android_util_JsonReader$close() throws IOException {
        this.value = null;
        this.token = null;
        this.stack.clear();
        this.stack.add(JsonScope.CLOSED);
        this.in.close();
    }

    private final void $$robo$$android_util_JsonReader$skipValue() throws IOException {
        this.skipping = true;
        try {
            if (!this.hasNext() || this.peek() == JsonToken.END_DOCUMENT) {
                throw new IllegalStateException("No element left to skip");
            }
            int count = 0;
            do {
                JsonToken token;
                if ((token = this.advance()) == JsonToken.BEGIN_ARRAY || token == JsonToken.BEGIN_OBJECT) {
                    ++count;
                    continue;
                }
                if (token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT) continue;
                --count;
            } while (count != 0);
        }
        finally {
            this.skipping = false;
        }
    }

    private final JsonScope $$robo$$android_util_JsonReader$peekStack() {
        return this.stack.get(this.stack.size() - 1);
    }

    private final JsonScope $$robo$$android_util_JsonReader$pop() {
        return this.stack.remove(this.stack.size() - 1);
    }

    private final void $$robo$$android_util_JsonReader$push(JsonScope newTop) {
        this.stack.add(newTop);
    }

    private final void $$robo$$android_util_JsonReader$replaceTop(JsonScope newTop) {
        this.stack.set(this.stack.size() - 1, newTop);
    }

    private final JsonToken $$robo$$android_util_JsonReader$nextInArray(boolean firstElement) throws IOException {
        if (firstElement) {
            this.replaceTop(JsonScope.NONEMPTY_ARRAY);
        } else {
            switch (this.nextNonWhitespace()) {
                case 93: {
                    this.pop();
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
                case 59: {
                    this.checkLenient();
                }
                case 44: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated array");
                }
            }
        }
        switch (this.nextNonWhitespace()) {
            case 93: {
                if (firstElement) {
                    this.pop();
                    this.token = JsonToken.END_ARRAY;
                    return this.token;
                }
            }
            case 44: 
            case 59: {
                this.checkLenient();
                --this.pos;
                this.value = "null";
                this.token = JsonToken.NULL;
                return this.token;
            }
        }
        --this.pos;
        return this.nextValue();
    }

    private final JsonToken $$robo$$android_util_JsonReader$nextInObject(boolean firstElement) throws IOException {
        if (firstElement) {
            switch (this.nextNonWhitespace()) {
                case 125: {
                    this.pop();
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
            }
            --this.pos;
        } else {
            switch (this.nextNonWhitespace()) {
                case 125: {
                    this.pop();
                    this.token = JsonToken.END_OBJECT;
                    return this.token;
                }
                case 44: 
                case 59: {
                    break;
                }
                default: {
                    throw this.syntaxError("Unterminated object");
                }
            }
        }
        int quote = this.nextNonWhitespace();
        switch (quote) {
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.name = this.nextString((char)quote);
                break;
            }
            default: {
                this.checkLenient();
                --this.pos;
                this.name = this.nextLiteral(false);
                if (!this.name.isEmpty()) break;
                throw this.syntaxError("Expected name");
            }
        }
        this.replaceTop(JsonScope.DANGLING_NAME);
        this.token = JsonToken.NAME;
        return this.token;
    }

    private final JsonToken $$robo$$android_util_JsonReader$objectValue() throws IOException {
        switch (this.nextNonWhitespace()) {
            case 58: {
                break;
            }
            case 61: {
                this.checkLenient();
                if (this.pos >= this.limit && !this.fillBuffer(1) || this.buffer[this.pos] != '>') break;
                ++this.pos;
                break;
            }
            default: {
                throw this.syntaxError("Expected ':'");
            }
        }
        this.replaceTop(JsonScope.NONEMPTY_OBJECT);
        return this.nextValue();
    }

    private final JsonToken $$robo$$android_util_JsonReader$nextValue() throws IOException {
        int c = this.nextNonWhitespace();
        switch (c) {
            case 123: {
                this.push(JsonScope.EMPTY_OBJECT);
                this.token = JsonToken.BEGIN_OBJECT;
                return this.token;
            }
            case 91: {
                this.push(JsonScope.EMPTY_ARRAY);
                this.token = JsonToken.BEGIN_ARRAY;
                return this.token;
            }
            case 39: {
                this.checkLenient();
            }
            case 34: {
                this.value = this.nextString((char)c);
                this.token = JsonToken.STRING;
                return this.token;
            }
        }
        --this.pos;
        return this.readLiteral();
    }

    private final boolean $$robo$$android_util_JsonReader$fillBuffer(int minimum) throws IOException {
        int total;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                ++this.bufferStartLine;
                this.bufferStartColumn = 1;
                continue;
            }
            ++this.bufferStartColumn;
        }
        if (this.limit != this.pos) {
            this.limit -= this.pos;
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (char[])this.buffer, (int)this.pos, (char[])this.buffer, (int)0, (int)this.limit);
        } else {
            this.limit = 0;
        }
        this.pos = 0;
        while ((total = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) != -1) {
            this.limit += total;
            if (this.bufferStartLine == 1 && this.bufferStartColumn == 1 && this.limit > 0 && this.buffer[0] == '\ufeff') {
                ++this.pos;
                --this.bufferStartColumn;
            }
            if (this.limit < minimum) continue;
            return true;
        }
        return false;
    }

    private final int $$robo$$android_util_JsonReader$getLineNumber() {
        int result = this.bufferStartLine;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] != '\n') continue;
            ++result;
        }
        return result;
    }

    private final int $$robo$$android_util_JsonReader$getColumnNumber() {
        int result = this.bufferStartColumn;
        for (int i = 0; i < this.pos; ++i) {
            if (this.buffer[i] == '\n') {
                result = 1;
                continue;
            }
            ++result;
        }
        return result;
    }

    private final int $$robo$$android_util_JsonReader$nextNonWhitespace() throws IOException {
        block9: while (this.pos < this.limit || this.fillBuffer(1)) {
            char c = this.buffer[this.pos++];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                case '/': {
                    if (this.pos == this.limit && !this.fillBuffer(1)) {
                        return c;
                    }
                    this.checkLenient();
                    char peek = this.buffer[this.pos];
                    switch (peek) {
                        case '*': {
                            ++this.pos;
                            if (!this.skipTo("*/")) {
                                throw this.syntaxError("Unterminated comment");
                            }
                            this.pos += 2;
                            continue block9;
                        }
                        case '/': {
                            ++this.pos;
                            this.skipToEndOfLine();
                            continue block9;
                        }
                    }
                    return c;
                }
                case '#': {
                    this.checkLenient();
                    this.skipToEndOfLine();
                    continue block9;
                }
            }
            return c;
        }
        throw new EOFException("End of input");
    }

    private final void $$robo$$android_util_JsonReader$checkLenient() throws IOException {
        if (!this.lenient) {
            throw this.syntaxError("Use JsonReader.setLenient(true) to accept malformed JSON");
        }
    }

    private final void $$robo$$android_util_JsonReader$skipToEndOfLine() throws IOException {
        char c;
        while ((this.pos < this.limit || this.fillBuffer(1)) && (c = this.buffer[this.pos++]) != '\r' && c != '\n') {
        }
    }

    private final boolean $$robo$$android_util_JsonReader$skipTo(String toFind) throws IOException {
        while (this.pos + toFind.length() <= this.limit || this.fillBuffer(toFind.length())) {
            block3: {
                for (int c = 0; c < toFind.length(); ++c) {
                    if (this.buffer[this.pos + c] == toFind.charAt(c)) {
                        continue;
                    }
                    break block3;
                }
                return true;
            }
            ++this.pos;
        }
        return false;
    }

    private final String $$robo$$android_util_JsonReader$nextString(char quote) throws IOException {
        StringBuilder builder = null;
        do {
            int start = this.pos;
            while (this.pos < this.limit) {
                char c;
                if ((c = this.buffer[this.pos++]) == quote) {
                    if (this.skipping) {
                        return "skipped!";
                    }
                    if (builder == null) {
                        return this.stringPool.get(this.buffer, start, this.pos - start - 1);
                    }
                    builder.append(this.buffer, start, this.pos - start - 1);
                    return builder.toString();
                }
                if (c != '\\') continue;
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(this.buffer, start, this.pos - start - 1);
                builder.append(this.readEscapeCharacter());
                start = this.pos;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer, start, this.pos - start);
        } while (this.fillBuffer(1));
        throw this.syntaxError("Unterminated string");
    }

    private final String $$robo$$android_util_JsonReader$nextLiteral(boolean assignOffsetsOnly) throws IOException {
        String result;
        StringBuilder builder = null;
        this.valuePos = -1;
        this.valueLength = 0;
        int i = 0;
        block4: while (true) {
            if (this.pos + i < this.limit) {
                switch (this.buffer[this.pos + i]) {
                    case '#': 
                    case '/': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        this.checkLenient();
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case ',': 
                    case ':': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        break block4;
                    }
                    default: {
                        ++i;
                        break;
                    }
                }
                continue;
            }
            if (i < this.buffer.length) {
                if (this.fillBuffer(i + 1)) continue;
                this.buffer[this.limit] = '\u0000';
                break;
            }
            if (builder == null) {
                builder = new StringBuilder();
            }
            builder.append(this.buffer, this.pos, i);
            this.valueLength += i;
            this.pos += i;
            i = 0;
            if (!this.fillBuffer(1)) break;
        }
        if (assignOffsetsOnly && builder == null) {
            this.valuePos = this.pos;
            result = null;
        } else if (this.skipping) {
            result = "skipped!";
        } else if (builder == null) {
            result = this.stringPool.get(this.buffer, this.pos, i);
        } else {
            builder.append(this.buffer, this.pos, i);
            result = builder.toString();
        }
        this.valueLength += i;
        this.pos += i;
        return result;
    }

    private final String $$robo$$android_util_JsonReader$toString() {
        return this.getClass().getSimpleName() + " near " + this.getSnippet();
    }

    private final char $$robo$$android_util_JsonReader$readEscapeCharacter() throws IOException {
        if (this.pos == this.limit && !this.fillBuffer(1)) {
            throw this.syntaxError("Unterminated escape sequence");
        }
        char escaped = this.buffer[this.pos++];
        switch (escaped) {
            case 'u': {
                if (this.pos + 4 > this.limit && !this.fillBuffer(4)) {
                    throw this.syntaxError("Unterminated escape sequence");
                }
                String hex = this.stringPool.get(this.buffer, this.pos, 4);
                this.pos += 4;
                return (char)Integer.parseInt(hex, 16);
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
        }
        return escaped;
    }

    private final JsonToken $$robo$$android_util_JsonReader$readLiteral() throws IOException {
        this.value = this.nextLiteral(true);
        if (this.valueLength == 0) {
            throw this.syntaxError("Expected literal value");
        }
        this.token = this.decodeLiteral();
        if (this.token == JsonToken.STRING) {
            this.checkLenient();
        }
        return this.token;
    }

    private final JsonToken $$robo$$android_util_JsonReader$decodeLiteral() throws IOException {
        if (this.valuePos == -1) {
            return JsonToken.STRING;
        }
        if (!(this.valueLength != 4 || 'n' != this.buffer[this.valuePos] && 'N' != this.buffer[this.valuePos] || 'u' != this.buffer[this.valuePos + 1] && 'U' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 'l' != this.buffer[this.valuePos + 3] && 'L' != this.buffer[this.valuePos + 3])) {
            this.value = "null";
            return JsonToken.NULL;
        }
        if (!(this.valueLength != 4 || 't' != this.buffer[this.valuePos] && 'T' != this.buffer[this.valuePos] || 'r' != this.buffer[this.valuePos + 1] && 'R' != this.buffer[this.valuePos + 1] || 'u' != this.buffer[this.valuePos + 2] && 'U' != this.buffer[this.valuePos + 2] || 'e' != this.buffer[this.valuePos + 3] && 'E' != this.buffer[this.valuePos + 3])) {
            this.value = "true";
            return JsonToken.BOOLEAN;
        }
        if (!(this.valueLength != 5 || 'f' != this.buffer[this.valuePos] && 'F' != this.buffer[this.valuePos] || 'a' != this.buffer[this.valuePos + 1] && 'A' != this.buffer[this.valuePos + 1] || 'l' != this.buffer[this.valuePos + 2] && 'L' != this.buffer[this.valuePos + 2] || 's' != this.buffer[this.valuePos + 3] && 'S' != this.buffer[this.valuePos + 3] || 'e' != this.buffer[this.valuePos + 4] && 'E' != this.buffer[this.valuePos + 4])) {
            this.value = "false";
            return JsonToken.BOOLEAN;
        }
        this.value = this.stringPool.get(this.buffer, this.valuePos, this.valueLength);
        return this.decodeNumber(this.buffer, this.valuePos, this.valueLength);
    }

    private final JsonToken $$robo$$android_util_JsonReader$decodeNumber(char[] chars, int offset, int length) {
        int i = offset;
        char c = chars[i];
        if (c == '-') {
            c = chars[++i];
        }
        if (c == '0') {
            c = chars[++i];
        } else if (c >= '1' && c <= '9') {
            c = chars[++i];
            while (c >= '0' && c <= '9') {
                c = chars[++i];
            }
        } else {
            return JsonToken.STRING;
        }
        if (c == '.') {
            c = chars[++i];
            while (c >= '0' && c <= '9') {
                c = chars[++i];
            }
        }
        if (c == 'e' || c == 'E') {
            if ((c = chars[++i]) == '+' || c == '-') {
                c = chars[++i];
            }
            if (c >= '0' && c <= '9') {
                c = chars[++i];
                while (c >= '0' && c <= '9') {
                    c = chars[++i];
                }
            } else {
                return JsonToken.STRING;
            }
        }
        if (i == offset + length) {
            return JsonToken.NUMBER;
        }
        return JsonToken.STRING;
    }

    private final IOException $$robo$$android_util_JsonReader$syntaxError(String message) throws IOException {
        throw new MalformedJsonException(message + " at line " + this.getLineNumber() + " column " + this.getColumnNumber());
    }

    private final CharSequence $$robo$$android_util_JsonReader$getSnippet() {
        StringBuilder snippet = new StringBuilder();
        int beforePos = Math.min(this.pos, 20);
        snippet.append(this.buffer, this.pos - beforePos, beforePos);
        int afterPos = Math.min(this.limit - this.pos, 20);
        snippet.append(this.buffer, this.pos, afterPos);
        return snippet;
    }

    private void __constructor__(Reader reader) {
        this.$$robo$$android_util_JsonReader$__constructor__(reader);
    }

    public JsonReader(Reader reader) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_JsonReader$__constructor__(java.io.Reader ), 0, this, reader);
    }

    public void setLenient(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLenient", $$robo$$android_util_JsonReader$setLenient(boolean ), 0, this, bl);
    }

    public boolean isLenient() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLenient", $$robo$$android_util_JsonReader$isLenient(), 0, this);
    }

    public void beginArray() throws IOException {
        InvokeDynamicSupport.bootstrap("beginArray", $$robo$$android_util_JsonReader$beginArray(), 0, this);
    }

    public void endArray() throws IOException {
        InvokeDynamicSupport.bootstrap("endArray", $$robo$$android_util_JsonReader$endArray(), 0, this);
    }

    public void beginObject() throws IOException {
        InvokeDynamicSupport.bootstrap("beginObject", $$robo$$android_util_JsonReader$beginObject(), 0, this);
    }

    public void endObject() throws IOException {
        InvokeDynamicSupport.bootstrap("endObject", $$robo$$android_util_JsonReader$endObject(), 0, this);
    }

    private void expect(JsonToken jsonToken) throws IOException {
        InvokeDynamicSupport.bootstrap("expect", $$robo$$android_util_JsonReader$expect(android.util.JsonToken ), 0, this, jsonToken);
    }

    public boolean hasNext() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("hasNext", $$robo$$android_util_JsonReader$hasNext(), 0, this);
    }

    public JsonToken peek() throws IOException {
        return InvokeDynamicSupport.bootstrap("peek", $$robo$$android_util_JsonReader$peek(), 0, this);
    }

    private JsonToken advance() throws IOException {
        return InvokeDynamicSupport.bootstrap("advance", $$robo$$android_util_JsonReader$advance(), 0, this);
    }

    public String nextName() throws IOException {
        return InvokeDynamicSupport.bootstrap("nextName", $$robo$$android_util_JsonReader$nextName(), 0, this);
    }

    public String nextString() throws IOException {
        return InvokeDynamicSupport.bootstrap("nextString", $$robo$$android_util_JsonReader$nextString(), 0, this);
    }

    public boolean nextBoolean() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("nextBoolean", $$robo$$android_util_JsonReader$nextBoolean(), 0, this);
    }

    public void nextNull() throws IOException {
        InvokeDynamicSupport.bootstrap("nextNull", $$robo$$android_util_JsonReader$nextNull(), 0, this);
    }

    public double nextDouble() throws IOException {
        return (double)InvokeDynamicSupport.bootstrap("nextDouble", $$robo$$android_util_JsonReader$nextDouble(), 0, this);
    }

    public long nextLong() throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("nextLong", $$robo$$android_util_JsonReader$nextLong(), 0, this);
    }

    public int nextInt() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextInt", $$robo$$android_util_JsonReader$nextInt(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_util_JsonReader$close(), 0, this);
    }

    public void skipValue() throws IOException {
        InvokeDynamicSupport.bootstrap("skipValue", $$robo$$android_util_JsonReader$skipValue(), 0, this);
    }

    private JsonScope peekStack() {
        return InvokeDynamicSupport.bootstrap("peekStack", $$robo$$android_util_JsonReader$peekStack(), 0, this);
    }

    private JsonScope pop() {
        return InvokeDynamicSupport.bootstrap("pop", $$robo$$android_util_JsonReader$pop(), 0, this);
    }

    private void push(JsonScope jsonScope) {
        InvokeDynamicSupport.bootstrap("push", $$robo$$android_util_JsonReader$push(android.util.JsonScope ), 0, this, jsonScope);
    }

    private void replaceTop(JsonScope jsonScope) {
        InvokeDynamicSupport.bootstrap("replaceTop", $$robo$$android_util_JsonReader$replaceTop(android.util.JsonScope ), 0, this, jsonScope);
    }

    private JsonToken nextInArray(boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("nextInArray", $$robo$$android_util_JsonReader$nextInArray(boolean ), 0, this, bl);
    }

    private JsonToken nextInObject(boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("nextInObject", $$robo$$android_util_JsonReader$nextInObject(boolean ), 0, this, bl);
    }

    private JsonToken objectValue() throws IOException {
        return InvokeDynamicSupport.bootstrap("objectValue", $$robo$$android_util_JsonReader$objectValue(), 0, this);
    }

    private JsonToken nextValue() throws IOException {
        return InvokeDynamicSupport.bootstrap("nextValue", $$robo$$android_util_JsonReader$nextValue(), 0, this);
    }

    private boolean fillBuffer(int n) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("fillBuffer", $$robo$$android_util_JsonReader$fillBuffer(int ), 0, this, n);
    }

    private int getLineNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getLineNumber", $$robo$$android_util_JsonReader$getLineNumber(), 0, this);
    }

    private int getColumnNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getColumnNumber", $$robo$$android_util_JsonReader$getColumnNumber(), 0, this);
    }

    private int nextNonWhitespace() throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("nextNonWhitespace", $$robo$$android_util_JsonReader$nextNonWhitespace(), 0, this);
    }

    private void checkLenient() throws IOException {
        InvokeDynamicSupport.bootstrap("checkLenient", $$robo$$android_util_JsonReader$checkLenient(), 0, this);
    }

    private void skipToEndOfLine() throws IOException {
        InvokeDynamicSupport.bootstrap("skipToEndOfLine", $$robo$$android_util_JsonReader$skipToEndOfLine(), 0, this);
    }

    private boolean skipTo(String string2) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("skipTo", $$robo$$android_util_JsonReader$skipTo(java.lang.String ), 0, this, string2);
    }

    private String nextString(char c) throws IOException {
        return InvokeDynamicSupport.bootstrap("nextString", $$robo$$android_util_JsonReader$nextString(char ), 0, this, c);
    }

    private String nextLiteral(boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("nextLiteral", $$robo$$android_util_JsonReader$nextLiteral(boolean ), 0, this, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_JsonReader$toString(), 0, this);
    }

    private char readEscapeCharacter() throws IOException {
        return (char)InvokeDynamicSupport.bootstrap("readEscapeCharacter", $$robo$$android_util_JsonReader$readEscapeCharacter(), 0, this);
    }

    private JsonToken readLiteral() throws IOException {
        return InvokeDynamicSupport.bootstrap("readLiteral", $$robo$$android_util_JsonReader$readLiteral(), 0, this);
    }

    private JsonToken decodeLiteral() throws IOException {
        return InvokeDynamicSupport.bootstrap("decodeLiteral", $$robo$$android_util_JsonReader$decodeLiteral(), 0, this);
    }

    private JsonToken decodeNumber(char[] cArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("decodeNumber", $$robo$$android_util_JsonReader$decodeNumber(char[] int int ), 0, this, cArray, n, n2);
    }

    private IOException syntaxError(String string2) throws IOException {
        return InvokeDynamicSupport.bootstrap("syntaxError", $$robo$$android_util_JsonReader$syntaxError(java.lang.String ), 0, this, string2);
    }

    private CharSequence getSnippet() {
        return InvokeDynamicSupport.bootstrap("getSnippet", $$robo$$android_util_JsonReader$getSnippet(), 0, this);
    }

    public /* synthetic */ JsonReader() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JsonReader)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

