/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.text.TextUtils;
import android.util.ArrayMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyValueListParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private ArrayMap<String, String> mValues;
    private TextUtils.StringSplitter mSplitter;

    private void $$robo$$android_util_KeyValueListParser$__constructor__(char delim) {
        this.mValues = new ArrayMap();
        this.mSplitter = new TextUtils.SimpleStringSplitter(delim);
    }

    private final void $$robo$$android_util_KeyValueListParser$setString(String str) throws IllegalArgumentException {
        this.mValues.clear();
        if (str != null) {
            this.mSplitter.setString(str);
            for (String pair : this.mSplitter) {
                int sep = pair.indexOf(61);
                if (sep < 0) {
                    this.mValues.clear();
                    throw new IllegalArgumentException("'" + pair + "' in '" + str + "' is not a valid key-value pair");
                }
                this.mValues.put(pair.substring(0, sep).trim(), pair.substring(sep + 1).trim());
            }
        }
    }

    private final int $$robo$$android_util_KeyValueListParser$getInt(String key, int def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private final long $$robo$$android_util_KeyValueListParser$getLong(String key, long def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private final float $$robo$$android_util_KeyValueListParser$getFloat(String key, float def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private final String $$robo$$android_util_KeyValueListParser$getString(String key, String def) {
        String value = this.mValues.get(key);
        if (value != null) {
            return value;
        }
        return def;
    }

    private final boolean $$robo$$android_util_KeyValueListParser$getBoolean(String key, boolean def) {
        String value = this.mValues.get(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    private void __constructor__(char c) {
        this.$$robo$$android_util_KeyValueListParser$__constructor__(c);
    }

    public KeyValueListParser(char c) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_KeyValueListParser$__constructor__(char ), 0, this, c);
    }

    public void setString(String string2) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$android_util_KeyValueListParser$setString(java.lang.String ), 0, this, string2);
    }

    public int getInt(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getInt", $$robo$$android_util_KeyValueListParser$getInt(java.lang.String int ), 0, this, string2, n);
    }

    public long getLong(String string2, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$android_util_KeyValueListParser$getLong(java.lang.String long ), 0, this, string2, l);
    }

    public float getFloat(String string2, float f) {
        return (float)InvokeDynamicSupport.bootstrap("getFloat", $$robo$$android_util_KeyValueListParser$getFloat(java.lang.String float ), 0, this, string2, f);
    }

    public String getString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getString", $$robo$$android_util_KeyValueListParser$getString(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean getBoolean(String string2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBoolean", $$robo$$android_util_KeyValueListParser$getBoolean(java.lang.String boolean ), 0, this, string2, bl);
    }

    public /* synthetic */ KeyValueListParser() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyValueListParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

