/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.lang.invoke.CallSite;
import java.util.LinkedHashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public class LruCache<K, V> {
    public transient /* synthetic */ Object __robo_data__;
    private LinkedHashMap<K, V> map;
    private int size;
    private int maxSize;
    private int putCount;
    private int createCount;
    private int evictionCount;
    private int hitCount;
    private int missCount;

    private void $$robo$$android_util_LruCache$__constructor__(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_util_LruCache$resize(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            this.maxSize = maxSize;
        }
        this.trimToSize(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V $$robo$$android_util_LruCache$get(K key) {
        V mapValue;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            mapValue = this.map.get(key);
            if (mapValue != null) {
                ++this.hitCount;
                return mapValue;
            }
            ++this.missCount;
        }
        V createdValue = this.create(key);
        if (createdValue == null) {
            return null;
        }
        LruCache lruCache2 = this;
        synchronized (lruCache2) {
            ++this.createCount;
            mapValue = this.map.put(key, createdValue);
            if (mapValue != null) {
                this.map.put(key, mapValue);
            } else {
                this.size += this.safeSizeOf(key, createdValue);
            }
        }
        if (mapValue != null) {
            this.entryRemoved(false, key, createdValue, mapValue);
            return mapValue;
        }
        this.trimToSize(this.maxSize);
        return createdValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V $$robo$$android_util_LruCache$put(K key, V value) {
        V previous;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            ++this.putCount;
            this.size += this.safeSizeOf(key, value);
            previous = this.map.put(key, value);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, value);
        }
        this.trimToSize(this.maxSize);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_util_LruCache$trimToSize(int maxSize) {
        while (true) {
            Object value;
            Object key;
            LruCache lruCache = this;
            synchronized (lruCache) {
                if (this.size < 0 || this.map.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize) {
                    break;
                }
                CallSite toEvict = InvokeDynamicSupport.bootstrapIntrinsic("eldest", "java.util.LinkedHashMap", this.map);
                if (toEvict == null) {
                    break;
                }
                key = toEvict.getKey();
                value = toEvict.getValue();
                this.map.remove(key);
                this.size -= this.safeSizeOf(key, value);
                ++this.evictionCount;
            }
            this.entryRemoved(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V $$robo$$android_util_LruCache$remove(K key) {
        Object previous;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCache lruCache = this;
        synchronized (lruCache) {
            previous = this.map.remove(key);
            if (previous != null) {
                this.size -= this.safeSizeOf(key, previous);
            }
        }
        if (previous != null) {
            this.entryRemoved(false, key, previous, null);
        }
        return previous;
    }

    private final void $$robo$$android_util_LruCache$entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    private final V $$robo$$android_util_LruCache$create(K key) {
        return null;
    }

    private final int $$robo$$android_util_LruCache$safeSizeOf(K key, V value) {
        int result = this.sizeOf(key, value);
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + key + "=" + value);
        }
        return result;
    }

    private final int $$robo$$android_util_LruCache$sizeOf(K key, V value) {
        return 1;
    }

    private final void $$robo$$android_util_LruCache$evictAll() {
        this.trimToSize(-1);
    }

    private final synchronized int $$robo$$android_util_LruCache$size() {
        return this.size;
    }

    private final synchronized int $$robo$$android_util_LruCache$maxSize() {
        return this.maxSize;
    }

    private final synchronized int $$robo$$android_util_LruCache$hitCount() {
        return this.hitCount;
    }

    private final synchronized int $$robo$$android_util_LruCache$missCount() {
        return this.missCount;
    }

    private final synchronized int $$robo$$android_util_LruCache$createCount() {
        return this.createCount;
    }

    private final synchronized int $$robo$$android_util_LruCache$putCount() {
        return this.putCount;
    }

    private final synchronized int $$robo$$android_util_LruCache$evictionCount() {
        return this.evictionCount;
    }

    private final synchronized Map<K, V> $$robo$$android_util_LruCache$snapshot() {
        return new LinkedHashMap<K, V>(this.map);
    }

    private final synchronized String $$robo$$android_util_LruCache$toString() {
        int accesses = this.hitCount + this.missCount;
        int hitPercent = accesses != 0 ? 100 * this.hitCount / accesses : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.maxSize, this.hitCount, this.missCount, hitPercent);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_LruCache$__constructor__(n);
    }

    public LruCache(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LruCache$__constructor__(int ), 0, this, n);
    }

    public void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_util_LruCache$resize(int ), 0, this, n);
    }

    public V get(K k) {
        return (V)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_LruCache$get(K ), 0, this, k);
    }

    public V put(K k, V v) {
        return (V)InvokeDynamicSupport.bootstrap("put", $$robo$$android_util_LruCache$put(K V ), 0, this, k, v);
    }

    public void trimToSize(int n) {
        InvokeDynamicSupport.bootstrap("trimToSize", $$robo$$android_util_LruCache$trimToSize(int ), 0, this, n);
    }

    public V remove(K k) {
        return (V)InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_LruCache$remove(K ), 0, this, k);
    }

    protected void entryRemoved(boolean bl, K k, V v, V v2) {
        InvokeDynamicSupport.bootstrap("entryRemoved", $$robo$$android_util_LruCache$entryRemoved(boolean K V V ), 0, this, bl, k, v, v2);
    }

    protected V create(K k) {
        return (V)InvokeDynamicSupport.bootstrap("create", $$robo$$android_util_LruCache$create(K ), 0, this, k);
    }

    private int safeSizeOf(K k, V v) {
        return (int)InvokeDynamicSupport.bootstrap("safeSizeOf", $$robo$$android_util_LruCache$safeSizeOf(K V ), 0, this, k, v);
    }

    protected int sizeOf(K k, V v) {
        return (int)InvokeDynamicSupport.bootstrap("sizeOf", $$robo$$android_util_LruCache$sizeOf(K V ), 0, this, k, v);
    }

    public void evictAll() {
        InvokeDynamicSupport.bootstrap("evictAll", $$robo$$android_util_LruCache$evictAll(), 0, this);
    }

    public synchronized int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_LruCache$size(), 0, this);
    }

    public synchronized int maxSize() {
        return (int)InvokeDynamicSupport.bootstrap("maxSize", $$robo$$android_util_LruCache$maxSize(), 0, this);
    }

    public synchronized int hitCount() {
        return (int)InvokeDynamicSupport.bootstrap("hitCount", $$robo$$android_util_LruCache$hitCount(), 0, this);
    }

    public synchronized int missCount() {
        return (int)InvokeDynamicSupport.bootstrap("missCount", $$robo$$android_util_LruCache$missCount(), 0, this);
    }

    public synchronized int createCount() {
        return (int)InvokeDynamicSupport.bootstrap("createCount", $$robo$$android_util_LruCache$createCount(), 0, this);
    }

    public synchronized int putCount() {
        return (int)InvokeDynamicSupport.bootstrap("putCount", $$robo$$android_util_LruCache$putCount(), 0, this);
    }

    public synchronized int evictionCount() {
        return (int)InvokeDynamicSupport.bootstrap("evictionCount", $$robo$$android_util_LruCache$evictionCount(), 0, this);
    }

    public synchronized Map<K, V> snapshot() {
        return InvokeDynamicSupport.bootstrap("snapshot", $$robo$$android_util_LruCache$snapshot(), 0, this);
    }

    public synchronized String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_LruCache$toString(), 0, this);
    }

    public /* synthetic */ LruCache() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LruCache)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

