/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.IntDef;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManagerGlobal;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.DisplayAdjustments;
import android.view.DisplayInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Display
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Display";
    private static boolean DEBUG = false;
    private DisplayManagerGlobal mGlobal;
    private int mDisplayId;
    private int mLayerStack;
    private int mFlags;
    private int mType;
    private String mAddress;
    private int mOwnerUid;
    private String mOwnerPackageName;
    private Resources mResources;
    private DisplayAdjustments mDisplayAdjustments;
    private DisplayInfo mDisplayInfo;
    private boolean mIsValid;
    private DisplayMetrics mTempMetrics;
    private static int CACHED_APP_SIZE_DURATION_MILLIS = 20;
    private long mLastCachedAppSizeUpdate;
    private int mCachedAppWidthCompat;
    private int mCachedAppHeightCompat;
    public static int DEFAULT_DISPLAY = 0;
    public static int INVALID_DISPLAY = -1;
    public static int FLAG_SUPPORTS_PROTECTED_BUFFERS = 1;
    public static int FLAG_SECURE = 2;
    public static int FLAG_PRIVATE = 4;
    public static int FLAG_PRESENTATION = 8;
    public static int FLAG_ROUND = 16;
    public static int FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD = 32;
    public static int FLAG_SCALING_DISABLED = 0x40000000;
    public static int TYPE_UNKNOWN = 0;
    public static int TYPE_BUILT_IN = 1;
    public static int TYPE_HDMI = 2;
    public static int TYPE_WIFI = 3;
    public static int TYPE_OVERLAY = 4;
    public static int TYPE_VIRTUAL = 5;
    public static int STATE_UNKNOWN = 0;
    public static int STATE_OFF = 1;
    public static int STATE_ON = 2;
    public static int STATE_DOZE = 3;
    public static int STATE_DOZE_SUSPEND = 4;
    public static int STATE_VR = 5;
    public static int COLOR_MODE_INVALID = -1;
    public static int COLOR_MODE_DEFAULT = 0;
    public static int COLOR_MODE_BT601_625 = 1;
    public static int COLOR_MODE_BT601_625_UNADJUSTED = 2;
    public static int COLOR_MODE_BT601_525 = 3;
    public static int COLOR_MODE_BT601_525_UNADJUSTED = 4;
    public static int COLOR_MODE_BT709 = 5;
    public static int COLOR_MODE_DCI_P3 = 6;
    public static int COLOR_MODE_SRGB = 7;
    public static int COLOR_MODE_ADOBE_RGB = 8;
    public static int COLOR_MODE_DISPLAY_P3 = 9;
    public static int REMOVE_MODE_MOVE_CONTENT_TO_PRIMARY = 0;
    public static int REMOVE_MODE_DESTROY_CONTENT = 1;

    private void $$robo$$android_view_Display$__constructor__(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj) {
    }

    private void $$robo$$android_view_Display$__constructor__(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, Resources res) {
    }

    private void $$robo$$android_view_Display$__constructor__(DisplayManagerGlobal global, int displayId, DisplayInfo displayInfo, DisplayAdjustments daj, Resources res) {
        this.mTempMetrics = new DisplayMetrics();
        this.mGlobal = global;
        this.mDisplayId = displayId;
        this.mDisplayInfo = displayInfo;
        this.mResources = res;
        this.mDisplayAdjustments = this.mResources != null ? new DisplayAdjustments(this.mResources.getConfiguration()) : (daj != null ? new DisplayAdjustments(daj) : null);
        this.mIsValid = true;
        this.mLayerStack = displayInfo.layerStack;
        this.mFlags = displayInfo.flags;
        this.mType = displayInfo.type;
        this.mAddress = displayInfo.address;
        this.mOwnerUid = displayInfo.ownerUid;
        this.mOwnerPackageName = displayInfo.ownerPackageName;
    }

    private final int $$robo$$android_view_Display$getDisplayId() {
        return this.mDisplayId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$isValid() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$getDisplayInfo(DisplayInfo outDisplayInfo) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outDisplayInfo.copyFrom(this.mDisplayInfo);
            return this.mIsValid;
        }
    }

    private final int $$robo$$android_view_Display$getLayerStack() {
        return this.mLayerStack;
    }

    private final int $$robo$$android_view_Display$getFlags() {
        return this.mFlags;
    }

    private final int $$robo$$android_view_Display$getType() {
        return this.mType;
    }

    private final String $$robo$$android_view_Display$getAddress() {
        return this.mAddress;
    }

    private final int $$robo$$android_view_Display$getOwnerUid() {
        return this.mOwnerUid;
    }

    private final String $$robo$$android_view_Display$getOwnerPackageName() {
        return this.mOwnerPackageName;
    }

    private final DisplayAdjustments $$robo$$android_view_Display$getDisplayAdjustments() {
        DisplayAdjustments currentAdjustements;
        if (this.mResources != null && !this.mDisplayAdjustments.equals(currentAdjustements = this.mResources.getDisplayAdjustments())) {
            this.mDisplayAdjustments = new DisplayAdjustments(currentAdjustements);
        }
        return this.mDisplayAdjustments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_view_Display$getName() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.x = this.mTempMetrics.widthPixels;
            outSize.y = this.mTempMetrics.heightPixels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRectSize(Rect outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            outSize.set(0, 0, this.mTempMetrics.widthPixels, this.mTempMetrics.heightPixels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSmallestSize.x = this.mDisplayInfo.smallestNominalAppWidth;
            outSmallestSize.y = this.mDisplayInfo.smallestNominalAppHeight;
            outLargestSize.x = this.mDisplayInfo.largestNominalAppWidth;
            outLargestSize.y = this.mDisplayInfo.largestNominalAppHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getMaximumSizeDimension() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return Math.max(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_view_Display$getWidth() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppWidthCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_view_Display$getHeight() {
        Display display = this;
        synchronized (display) {
            this.updateCachedAppSizeIfNeededLocked();
            return this.mCachedAppHeightCompat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getOverscanInsets(Rect outRect) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outRect.set(this.mDisplayInfo.overscanLeft, this.mDisplayInfo.overscanTop, this.mDisplayInfo.overscanRight, this.mDisplayInfo.overscanBottom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getRotation() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.rotation;
        }
    }

    @Deprecated
    private final int $$robo$$android_view_Display$getOrientation() {
        return this.getRotation();
    }

    @Deprecated
    private final int $$robo$$android_view_Display$getPixelFormat() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final float $$robo$$android_view_Display$getRefreshRate() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode().getRefreshRate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final float[] $$robo$$android_view_Display$getSupportedRefreshRates() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getDefaultRefreshRates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Mode $$robo$$android_view_Display$getMode() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.getMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Mode[] $$robo$$android_view_Display$getSupportedModes() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            Mode[] modes = this.mDisplayInfo.supportedModes;
            return Arrays.copyOf(modes, modes.length);
        }
    }

    private final void $$robo$$android_view_Display$requestColorMode(int colorMode) {
        this.mGlobal.requestColorMode(this.mDisplayId, colorMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getColorMode() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.colorMode;
        }
    }

    private final int $$robo$$android_view_Display$getRemoveMode() {
        return this.mDisplayInfo.removeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HdrCapabilities $$robo$$android_view_Display$getHdrCapabilities() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.hdrCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$isHdr() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.isHdr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_Display$isWideColorGamut() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.isWideColorGamut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int[] $$robo$$android_view_Display$getSupportedColorModes() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            int[] colorModes = this.mDisplayInfo.supportedColorModes;
            return Arrays.copyOf(colorModes, colorModes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_view_Display$getAppVsyncOffsetNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.appVsyncOffsetNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long $$robo$$android_view_Display$getPresentationDeadlineNanos() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mDisplayInfo.presentationDeadlineNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(outMetrics, this.getDisplayAdjustments());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRealSize(Point outSize) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            outSize.x = this.mDisplayInfo.logicalWidth;
            outSize.y = this.mDisplayInfo.logicalHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_Display$getRealMetrics(DisplayMetrics outMetrics) {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getLogicalMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_view_Display$getState() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            return this.mIsValid ? this.mDisplayInfo.state : 0;
        }
    }

    private final boolean $$robo$$android_view_Display$hasAccess(int uid) {
        return Display.hasAccess(uid, this.mFlags, this.mOwnerUid);
    }

    private static final boolean $$robo$$android_view_Display$hasAccess(int uid, int flags, int ownerUid) {
        return (flags & 4) == 0 || uid == ownerUid || uid == 1000 || uid == 0;
    }

    private final boolean $$robo$$android_view_Display$isPublicPresentation() {
        return (this.mFlags & 0xC) == 8;
    }

    private final void $$robo$$android_view_Display$updateDisplayInfoLocked() {
        DisplayInfo newInfo = this.mGlobal.getDisplayInfo(this.mDisplayId);
        if (newInfo == null) {
            if (this.mIsValid) {
                this.mIsValid = false;
            }
        } else {
            this.mDisplayInfo = newInfo;
            if (!this.mIsValid) {
                this.mIsValid = true;
            }
        }
    }

    private final void $$robo$$android_view_Display$updateCachedAppSizeIfNeededLocked() {
        long now = SystemClock.uptimeMillis();
        if (now > this.mLastCachedAppSizeUpdate + 20L) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            this.mCachedAppWidthCompat = this.mTempMetrics.widthPixels;
            this.mCachedAppHeightCompat = this.mTempMetrics.heightPixels;
            this.mLastCachedAppSizeUpdate = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_view_Display$toString() {
        Display display = this;
        synchronized (display) {
            this.updateDisplayInfoLocked();
            this.mDisplayInfo.getAppMetrics(this.mTempMetrics, this.getDisplayAdjustments());
            return "Display id " + this.mDisplayId + ": " + this.mDisplayInfo + ", " + this.mTempMetrics + ", isValid=" + this.mIsValid;
        }
    }

    private static final String $$robo$$android_view_Display$typeToString(int type) {
        switch (type) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "BUILT_IN";
            }
            case 2: {
                return "HDMI";
            }
            case 3: {
                return "WIFI";
            }
            case 4: {
                return "OVERLAY";
            }
            case 5: {
                return "VIRTUAL";
            }
        }
        return Integer.toString(type);
    }

    private static final String $$robo$$android_view_Display$stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "OFF";
            }
            case 2: {
                return "ON";
            }
            case 3: {
                return "DOZE";
            }
            case 4: {
                return "DOZE_SUSPEND";
            }
            case 5: {
                return "VR";
            }
        }
        return Integer.toString(state);
    }

    private static final boolean $$robo$$android_view_Display$isSuspendedState(int state) {
        return state == 1 || state == 4;
    }

    private void __constructor__(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments) {
        this.$$robo$$android_view_Display$__constructor__(displayManagerGlobal, n, displayInfo, displayAdjustments);
    }

    public Display(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments) {
        this(displayManagerGlobal, n, displayInfo, displayAdjustments, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display$__constructor__(android.hardware.display.DisplayManagerGlobal int android.view.DisplayInfo android.view.DisplayAdjustments ), 0, this, displayManagerGlobal, n, displayInfo, displayAdjustments);
    }

    private void __constructor__(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, Resources resources) {
        this.$$robo$$android_view_Display$__constructor__(displayManagerGlobal, n, displayInfo, resources);
    }

    public Display(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, Resources resources) {
        this(displayManagerGlobal, n, displayInfo, null, resources);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display$__constructor__(android.hardware.display.DisplayManagerGlobal int android.view.DisplayInfo android.content.res.Resources ), 0, this, displayManagerGlobal, n, displayInfo, resources);
    }

    private void __constructor__(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments, Resources resources) {
        this.$$robo$$android_view_Display$__constructor__(displayManagerGlobal, n, displayInfo, displayAdjustments, resources);
    }

    private Display(DisplayManagerGlobal displayManagerGlobal, int n, DisplayInfo displayInfo, DisplayAdjustments displayAdjustments, Resources resources) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display$__constructor__(android.hardware.display.DisplayManagerGlobal int android.view.DisplayInfo android.view.DisplayAdjustments android.content.res.Resources ), 0, this, displayManagerGlobal, n, displayInfo, displayAdjustments, resources);
    }

    public int getDisplayId() {
        return (int)InvokeDynamicSupport.bootstrap("getDisplayId", $$robo$$android_view_Display$getDisplayId(), 0, this);
    }

    public boolean isValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isValid", $$robo$$android_view_Display$isValid(), 0, this);
    }

    public boolean getDisplayInfo(DisplayInfo displayInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("getDisplayInfo", $$robo$$android_view_Display$getDisplayInfo(android.view.DisplayInfo ), 0, this, displayInfo);
    }

    public int getLayerStack() {
        return (int)InvokeDynamicSupport.bootstrap("getLayerStack", $$robo$$android_view_Display$getLayerStack(), 0, this);
    }

    public int getFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_view_Display$getFlags(), 0, this);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_view_Display$getType(), 0, this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$android_view_Display$getAddress(), 0, this);
    }

    public int getOwnerUid() {
        return (int)InvokeDynamicSupport.bootstrap("getOwnerUid", $$robo$$android_view_Display$getOwnerUid(), 0, this);
    }

    public String getOwnerPackageName() {
        return InvokeDynamicSupport.bootstrap("getOwnerPackageName", $$robo$$android_view_Display$getOwnerPackageName(), 0, this);
    }

    public DisplayAdjustments getDisplayAdjustments() {
        return InvokeDynamicSupport.bootstrap("getDisplayAdjustments", $$robo$$android_view_Display$getDisplayAdjustments(), 0, this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_view_Display$getName(), 0, this);
    }

    public void getSize(Point point) {
        InvokeDynamicSupport.bootstrap("getSize", $$robo$$android_view_Display$getSize(android.graphics.Point ), 0, this, point);
    }

    public void getRectSize(Rect rect) {
        InvokeDynamicSupport.bootstrap("getRectSize", $$robo$$android_view_Display$getRectSize(android.graphics.Rect ), 0, this, rect);
    }

    public void getCurrentSizeRange(Point point, Point point2) {
        InvokeDynamicSupport.bootstrap("getCurrentSizeRange", $$robo$$android_view_Display$getCurrentSizeRange(android.graphics.Point android.graphics.Point ), 0, this, point, point2);
    }

    public int getMaximumSizeDimension() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumSizeDimension", $$robo$$android_view_Display$getMaximumSizeDimension(), 0, this);
    }

    @Deprecated
    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_view_Display$getWidth(), 0, this);
    }

    @Deprecated
    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_view_Display$getHeight(), 0, this);
    }

    public void getOverscanInsets(Rect rect) {
        InvokeDynamicSupport.bootstrap("getOverscanInsets", $$robo$$android_view_Display$getOverscanInsets(android.graphics.Rect ), 0, this, rect);
    }

    public int getRotation() {
        return (int)InvokeDynamicSupport.bootstrap("getRotation", $$robo$$android_view_Display$getRotation(), 0, this);
    }

    @Deprecated
    public int getOrientation() {
        return (int)InvokeDynamicSupport.bootstrap("getOrientation", $$robo$$android_view_Display$getOrientation(), 0, this);
    }

    @Deprecated
    public int getPixelFormat() {
        return (int)InvokeDynamicSupport.bootstrap("getPixelFormat", $$robo$$android_view_Display$getPixelFormat(), 0, this);
    }

    public float getRefreshRate() {
        return (float)InvokeDynamicSupport.bootstrap("getRefreshRate", $$robo$$android_view_Display$getRefreshRate(), 0, this);
    }

    @Deprecated
    public float[] getSupportedRefreshRates() {
        return InvokeDynamicSupport.bootstrap("getSupportedRefreshRates", $$robo$$android_view_Display$getSupportedRefreshRates(), 0, this);
    }

    public Mode getMode() {
        return InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_view_Display$getMode(), 0, this);
    }

    public Mode[] getSupportedModes() {
        return InvokeDynamicSupport.bootstrap("getSupportedModes", $$robo$$android_view_Display$getSupportedModes(), 0, this);
    }

    public void requestColorMode(int n) {
        InvokeDynamicSupport.bootstrap("requestColorMode", $$robo$$android_view_Display$requestColorMode(int ), 0, this, n);
    }

    public int getColorMode() {
        return (int)InvokeDynamicSupport.bootstrap("getColorMode", $$robo$$android_view_Display$getColorMode(), 0, this);
    }

    public int getRemoveMode() {
        return (int)InvokeDynamicSupport.bootstrap("getRemoveMode", $$robo$$android_view_Display$getRemoveMode(), 0, this);
    }

    public HdrCapabilities getHdrCapabilities() {
        return InvokeDynamicSupport.bootstrap("getHdrCapabilities", $$robo$$android_view_Display$getHdrCapabilities(), 0, this);
    }

    public boolean isHdr() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHdr", $$robo$$android_view_Display$isHdr(), 0, this);
    }

    public boolean isWideColorGamut() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWideColorGamut", $$robo$$android_view_Display$isWideColorGamut(), 0, this);
    }

    public int[] getSupportedColorModes() {
        return InvokeDynamicSupport.bootstrap("getSupportedColorModes", $$robo$$android_view_Display$getSupportedColorModes(), 0, this);
    }

    public long getAppVsyncOffsetNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getAppVsyncOffsetNanos", $$robo$$android_view_Display$getAppVsyncOffsetNanos(), 0, this);
    }

    public long getPresentationDeadlineNanos() {
        return (long)InvokeDynamicSupport.bootstrap("getPresentationDeadlineNanos", $$robo$$android_view_Display$getPresentationDeadlineNanos(), 0, this);
    }

    public void getMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("getMetrics", $$robo$$android_view_Display$getMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public void getRealSize(Point point) {
        InvokeDynamicSupport.bootstrap("getRealSize", $$robo$$android_view_Display$getRealSize(android.graphics.Point ), 0, this, point);
    }

    public void getRealMetrics(DisplayMetrics displayMetrics) {
        InvokeDynamicSupport.bootstrap("getRealMetrics", $$robo$$android_view_Display$getRealMetrics(android.util.DisplayMetrics ), 0, this, displayMetrics);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_view_Display$getState(), 0, this);
    }

    public boolean hasAccess(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasAccess", $$robo$$android_view_Display$hasAccess(int ), 0, this, n);
    }

    public static boolean hasAccess(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasAccess", $$robo$$android_view_Display$hasAccess(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    public boolean isPublicPresentation() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPublicPresentation", $$robo$$android_view_Display$isPublicPresentation(), 0, this);
    }

    private void updateDisplayInfoLocked() {
        InvokeDynamicSupport.bootstrap("updateDisplayInfoLocked", $$robo$$android_view_Display$updateDisplayInfoLocked(), 0, this);
    }

    private void updateCachedAppSizeIfNeededLocked() {
        InvokeDynamicSupport.bootstrap("updateCachedAppSizeIfNeededLocked", $$robo$$android_view_Display$updateCachedAppSizeIfNeededLocked(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_Display$toString(), 0, this);
    }

    public static String typeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_view_Display$typeToString(int ), 0, (int)n);
    }

    public static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_view_Display$stateToString(int ), 0, (int)n);
    }

    public static boolean isSuspendedState(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSuspendedState", $$robo$$android_view_Display$isSuspendedState(int ), 0, (int)n);
    }

    public /* synthetic */ Display() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Display)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class HdrCapabilities
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static float INVALID_LUMINANCE = -1.0f;
        public static int HDR_TYPE_DOLBY_VISION = 1;
        public static int HDR_TYPE_HDR10 = 2;
        public static int HDR_TYPE_HLG = 3;
        private int[] mSupportedHdrTypes;
        private float mMaxLuminance;
        private float mMaxAverageLuminance;
        private float mMinLuminance;
        public static Parcelable.Creator<HdrCapabilities> CREATOR;

        private void $$robo$$android_view_Display_HdrCapabilities$__constructor__() {
            this.mSupportedHdrTypes = new int[0];
            this.mMaxLuminance = -1.0f;
            this.mMaxAverageLuminance = -1.0f;
            this.mMinLuminance = -1.0f;
        }

        private void $$robo$$android_view_Display_HdrCapabilities$__constructor__(int[] supportedHdrTypes, float maxLuminance, float maxAverageLuminance, float minLuminance) {
            this.mSupportedHdrTypes = new int[0];
            this.mMaxLuminance = -1.0f;
            this.mMaxAverageLuminance = -1.0f;
            this.mMinLuminance = -1.0f;
            this.mSupportedHdrTypes = supportedHdrTypes;
            this.mMaxLuminance = maxLuminance;
            this.mMaxAverageLuminance = maxAverageLuminance;
            this.mMinLuminance = minLuminance;
        }

        private final int[] $$robo$$android_view_Display_HdrCapabilities$getSupportedHdrTypes() {
            return this.mSupportedHdrTypes;
        }

        private final float $$robo$$android_view_Display_HdrCapabilities$getDesiredMaxLuminance() {
            return this.mMaxLuminance;
        }

        private final float $$robo$$android_view_Display_HdrCapabilities$getDesiredMaxAverageLuminance() {
            return this.mMaxAverageLuminance;
        }

        private final float $$robo$$android_view_Display_HdrCapabilities$getDesiredMinLuminance() {
            return this.mMinLuminance;
        }

        private final boolean $$robo$$android_view_Display_HdrCapabilities$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HdrCapabilities)) {
                return false;
            }
            HdrCapabilities that = (HdrCapabilities)other;
            return Arrays.equals(this.mSupportedHdrTypes, that.mSupportedHdrTypes) && this.mMaxLuminance == that.mMaxLuminance && this.mMaxAverageLuminance == that.mMaxAverageLuminance && this.mMinLuminance == that.mMinLuminance;
        }

        private final int $$robo$$android_view_Display_HdrCapabilities$hashCode() {
            int hash = 23;
            hash = hash * 17 + Arrays.hashCode(this.mSupportedHdrTypes);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMaxAverageLuminance);
            hash = hash * 17 + Float.floatToIntBits(this.mMinLuminance);
            return hash;
        }

        private void $$robo$$android_view_Display_HdrCapabilities$__constructor__(Parcel source) {
            this.mSupportedHdrTypes = new int[0];
            this.mMaxLuminance = -1.0f;
            this.mMaxAverageLuminance = -1.0f;
            this.mMinLuminance = -1.0f;
            this.readFromParcel(source);
        }

        private final void $$robo$$android_view_Display_HdrCapabilities$readFromParcel(Parcel source) {
            int types = source.readInt();
            this.mSupportedHdrTypes = new int[types];
            for (int i = 0; i < types; ++i) {
                this.mSupportedHdrTypes[i] = source.readInt();
            }
            this.mMaxLuminance = source.readFloat();
            this.mMaxAverageLuminance = source.readFloat();
            this.mMinLuminance = source.readFloat();
        }

        private final void $$robo$$android_view_Display_HdrCapabilities$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mSupportedHdrTypes.length);
            for (int i = 0; i < this.mSupportedHdrTypes.length; ++i) {
                dest.writeInt(this.mSupportedHdrTypes[i]);
            }
            dest.writeFloat(this.mMaxLuminance);
            dest.writeFloat(this.mMaxAverageLuminance);
            dest.writeFloat(this.mMinLuminance);
        }

        private final int $$robo$$android_view_Display_HdrCapabilities$describeContents() {
            return 0;
        }

        private /* synthetic */ void $$robo$$android_view_Display_HdrCapabilities$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<HdrCapabilities>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_Display_HdrCapabilities_1$__constructor__() {
                }

                private final HdrCapabilities $$robo$$android_view_Display_HdrCapabilities_1$createFromParcel(Parcel source) {
                    return new HdrCapabilities(source);
                }

                private final HdrCapabilities[] $$robo$$android_view_Display_HdrCapabilities_1$newArray(int size) {
                    return new HdrCapabilities[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_Display_HdrCapabilities_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_HdrCapabilities_1$__constructor__(), 0, this);
                }

                @Override
                public HdrCapabilities createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_Display_HdrCapabilities_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public HdrCapabilities[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_Display_HdrCapabilities_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$android_view_Display_HdrCapabilities$__constructor__();
        }

        public HdrCapabilities() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_HdrCapabilities$__constructor__(), 0, this);
        }

        private void __constructor__(int[] nArray, float f, float f2, float f3) {
            this.$$robo$$android_view_Display_HdrCapabilities$__constructor__(nArray, f, f2, f3);
        }

        public HdrCapabilities(int[] nArray, float f, float f2, float f3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_HdrCapabilities$__constructor__(int[] float float float ), 0, this, nArray, f, f2, f3);
        }

        public int[] getSupportedHdrTypes() {
            return InvokeDynamicSupport.bootstrap("getSupportedHdrTypes", $$robo$$android_view_Display_HdrCapabilities$getSupportedHdrTypes(), 0, this);
        }

        public float getDesiredMaxLuminance() {
            return (float)InvokeDynamicSupport.bootstrap("getDesiredMaxLuminance", $$robo$$android_view_Display_HdrCapabilities$getDesiredMaxLuminance(), 0, this);
        }

        public float getDesiredMaxAverageLuminance() {
            return (float)InvokeDynamicSupport.bootstrap("getDesiredMaxAverageLuminance", $$robo$$android_view_Display_HdrCapabilities$getDesiredMaxAverageLuminance(), 0, this);
        }

        public float getDesiredMinLuminance() {
            return (float)InvokeDynamicSupport.bootstrap("getDesiredMinLuminance", $$robo$$android_view_Display_HdrCapabilities$getDesiredMinLuminance(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_Display_HdrCapabilities$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_Display_HdrCapabilities$hashCode(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_Display_HdrCapabilities$__constructor__(parcel);
        }

        private HdrCapabilities(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_HdrCapabilities$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public void readFromParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_view_Display_HdrCapabilities$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_Display_HdrCapabilities$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_Display_HdrCapabilities$describeContents(), 0, this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_Display_HdrCapabilities$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(HdrCapabilities.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HdrCapabilities)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={1L, 2L, 3L})
        public static @interface HdrType {
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Mode
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static Mode[] EMPTY_ARRAY;
        private int mModeId;
        private int mWidth;
        private int mHeight;
        private float mRefreshRate;
        public static Parcelable.Creator<Mode> CREATOR;

        private void $$robo$$android_view_Display_Mode$__constructor__(int modeId, int width, int height, float refreshRate) {
            this.mModeId = modeId;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
        }

        private final int $$robo$$android_view_Display_Mode$getModeId() {
            return this.mModeId;
        }

        private final int $$robo$$android_view_Display_Mode$getPhysicalWidth() {
            return this.mWidth;
        }

        private final int $$robo$$android_view_Display_Mode$getPhysicalHeight() {
            return this.mHeight;
        }

        private final float $$robo$$android_view_Display_Mode$getRefreshRate() {
            return this.mRefreshRate;
        }

        private final boolean $$robo$$android_view_Display_Mode$matches(int width, int height, float refreshRate) {
            return this.mWidth == width && this.mHeight == height && Float.floatToIntBits(this.mRefreshRate) == Float.floatToIntBits(refreshRate);
        }

        private final boolean $$robo$$android_view_Display_Mode$equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Mode)) {
                return false;
            }
            Mode that = (Mode)other;
            return this.mModeId == that.mModeId && this.matches(that.mWidth, that.mHeight, that.mRefreshRate);
        }

        private final int $$robo$$android_view_Display_Mode$hashCode() {
            int hash = 1;
            hash = hash * 17 + this.mModeId;
            hash = hash * 17 + this.mWidth;
            hash = hash * 17 + this.mHeight;
            hash = hash * 17 + Float.floatToIntBits(this.mRefreshRate);
            return hash;
        }

        private final String $$robo$$android_view_Display_Mode$toString() {
            return "{" + "id=" + this.mModeId + ", width=" + this.mWidth + ", height=" + this.mHeight + ", fps=" + this.mRefreshRate + "}";
        }

        private final int $$robo$$android_view_Display_Mode$describeContents() {
            return 0;
        }

        private void $$robo$$android_view_Display_Mode$__constructor__(Parcel in) {
        }

        private final void $$robo$$android_view_Display_Mode$writeToParcel(Parcel out, int parcelableFlags) {
            out.writeInt(this.mModeId);
            out.writeInt(this.mWidth);
            out.writeInt(this.mHeight);
            out.writeFloat(this.mRefreshRate);
        }

        private /* synthetic */ void $$robo$$android_view_Display_Mode$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            EMPTY_ARRAY = new Mode[0];
            CREATOR = new Parcelable.Creator<Mode>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_view_Display_Mode_1$__constructor__() {
                }

                private final Mode $$robo$$android_view_Display_Mode_1$createFromParcel(Parcel in) {
                    return new Mode(in);
                }

                private final Mode[] $$robo$$android_view_Display_Mode_1$newArray(int size) {
                    return new Mode[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_view_Display_Mode_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_Mode_1$__constructor__(), 0, this);
                }

                @Override
                public Mode createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_Display_Mode_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Mode[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_Display_Mode_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(int n, int n2, int n3, float f) {
            this.$$robo$$android_view_Display_Mode$__constructor__(n, n2, n3, f);
        }

        public Mode(int n, int n2, int n3, float f) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_Mode$__constructor__(int int int float ), 0, this, n, n2, n3, f);
        }

        public int getModeId() {
            return (int)InvokeDynamicSupport.bootstrap("getModeId", $$robo$$android_view_Display_Mode$getModeId(), 0, this);
        }

        public int getPhysicalWidth() {
            return (int)InvokeDynamicSupport.bootstrap("getPhysicalWidth", $$robo$$android_view_Display_Mode$getPhysicalWidth(), 0, this);
        }

        public int getPhysicalHeight() {
            return (int)InvokeDynamicSupport.bootstrap("getPhysicalHeight", $$robo$$android_view_Display_Mode$getPhysicalHeight(), 0, this);
        }

        public float getRefreshRate() {
            return (float)InvokeDynamicSupport.bootstrap("getRefreshRate", $$robo$$android_view_Display_Mode$getRefreshRate(), 0, this);
        }

        public boolean matches(int n, int n2, float f) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_view_Display_Mode$matches(int int float ), 0, this, n, n2, f);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_Display_Mode$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_Display_Mode$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_Display_Mode$toString(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_Display_Mode$describeContents(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_view_Display_Mode$__constructor__(parcel);
        }

        private Mode(Parcel parcel) {
            this(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readFloat());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_Display_Mode$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_Display_Mode$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_view_Display_Mode$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(Mode.class);
        }

        public /* synthetic */ Mode() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Mode)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

