/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.LongArray;
import android.util.Pools;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityWindowInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    public static int TYPE_APPLICATION = 1;
    public static int TYPE_INPUT_METHOD = 2;
    public static int TYPE_SYSTEM = 3;
    public static int TYPE_ACCESSIBILITY_OVERLAY = 4;
    public static int TYPE_SPLIT_SCREEN_DIVIDER = 5;
    public static int ACTIVE_WINDOW_ID = Integer.MAX_VALUE;
    public static int UNDEFINED_WINDOW_ID = -1;
    public static int ANY_WINDOW_ID = -2;
    public static int PICTURE_IN_PICTURE_ACTION_REPLACER_WINDOW_ID = -3;
    private static int BOOLEAN_PROPERTY_ACTIVE = 1;
    private static int BOOLEAN_PROPERTY_FOCUSED = 2;
    private static int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 4;
    private static int MAX_POOL_SIZE = 10;
    private static Pools.SynchronizedPool<AccessibilityWindowInfo> sPool;
    private static AtomicInteger sNumInstancesInUse;
    private int mType;
    private int mLayer;
    private int mBooleanProperties;
    private int mId;
    private int mParentId;
    private Rect mBoundsInScreen;
    private LongArray mChildIds;
    private CharSequence mTitle;
    private int mAnchorId;
    private boolean mInPictureInPicture;
    private int mConnectionId;
    public static Parcelable.Creator<AccessibilityWindowInfo> CREATOR;

    private void $$robo$$android_view_accessibility_AccessibilityWindowInfo$__constructor__() {
        this.mType = -1;
        this.mLayer = -1;
        this.mId = -1;
        this.mParentId = -1;
        this.mBoundsInScreen = new Rect();
        this.mAnchorId = -1;
        this.mConnectionId = -1;
    }

    private final CharSequence $$robo$$android_view_accessibility_AccessibilityWindowInfo$getTitle() {
        return this.mTitle;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setTitle(CharSequence title) {
        this.mTitle = title;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$getType() {
        return this.mType;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setType(int type) {
        this.mType = type;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$getLayer() {
        return this.mLayer;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setLayer(int layer) {
        this.mLayer = layer;
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$getRoot() {
        if (this.mConnectionId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mId, AccessibilityNodeInfo.ROOT_NODE_ID, true, 4, null);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setAnchorId(int anchorId) {
        this.mAnchorId = anchorId;
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$getAnchor() {
        if (this.mConnectionId == -1 || this.mAnchorId == -1 || this.mParentId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mParentId, this.mAnchorId, true, 0, null);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setPictureInPicture(boolean pictureInPicture) {
        this.mInPictureInPicture = pictureInPicture;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$inPictureInPicture() {
        return this.isInPictureInPictureMode();
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$isInPictureInPictureMode() {
        return this.mInPictureInPicture;
    }

    private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$getParent() {
        if (this.mConnectionId == -1 || this.mParentId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mParentId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setParentId(int parentId) {
        this.mParentId = parentId;
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$getId() {
        return this.mId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setId(int id2) {
        this.mId = id2;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setConnectionId(int connectionId) {
        this.mConnectionId = connectionId;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setBoundsInScreen(Rect bounds) {
        this.mBoundsInScreen.set(bounds);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$isActive() {
        return this.getBooleanProperty(1);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setActive(boolean active) {
        this.setBooleanProperty(1, active);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$isFocused() {
        return this.getBooleanProperty(2);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setFocused(boolean focused) {
        this.setBooleanProperty(2, focused);
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$isAccessibilityFocused() {
        return this.getBooleanProperty(4);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(4, focused);
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$getChildCount() {
        return this.mChildIds != null ? this.mChildIds.size() : 0;
    }

    private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$getChild(int index) {
        if (this.mChildIds == null) {
            throw new IndexOutOfBoundsException();
        }
        if (this.mConnectionId == -1) {
            return null;
        }
        int childId = (int)this.mChildIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, childId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$addChild(int childId) {
        if (this.mChildIds == null) {
            this.mChildIds = new LongArray();
        }
        this.mChildIds.add(childId);
    }

    private static final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$obtain() {
        AccessibilityWindowInfo info = sPool.acquire();
        if (info == null) {
            info = new AccessibilityWindowInfo();
        }
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.incrementAndGet();
        }
        return info;
    }

    private static final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo$obtain(AccessibilityWindowInfo info) {
        AccessibilityWindowInfo infoClone = AccessibilityWindowInfo.obtain();
        infoClone.mType = info.mType;
        infoClone.mLayer = info.mLayer;
        infoClone.mBooleanProperties = info.mBooleanProperties;
        infoClone.mId = info.mId;
        infoClone.mParentId = info.mParentId;
        infoClone.mBoundsInScreen.set(info.mBoundsInScreen);
        infoClone.mTitle = info.mTitle;
        infoClone.mAnchorId = info.mAnchorId;
        infoClone.mInPictureInPicture = info.mInPictureInPicture;
        if (info.mChildIds != null && info.mChildIds.size() > 0) {
            if (infoClone.mChildIds == null) {
                infoClone.mChildIds = info.mChildIds.clone();
            } else {
                infoClone.mChildIds.addAll(info.mChildIds);
            }
        }
        infoClone.mConnectionId = info.mConnectionId;
        return infoClone;
    }

    private static final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setNumInstancesInUseCounter(AtomicInteger counter) {
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse = counter;
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$recycle() {
        this.clear();
        sPool.release(this);
        if (sNumInstancesInUse != null) {
            sNumInstancesInUse.decrementAndGet();
        }
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mLayer);
        parcel.writeInt(this.mBooleanProperties);
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mParentId);
        this.mBoundsInScreen.writeToParcel(parcel, flags);
        parcel.writeCharSequence(this.mTitle);
        parcel.writeInt(this.mAnchorId);
        parcel.writeInt(this.mInPictureInPicture ? 1 : 0);
        LongArray childIds = this.mChildIds;
        if (childIds == null) {
            parcel.writeInt(0);
        } else {
            int childCount = childIds.size();
            parcel.writeInt(childCount);
            for (int i = 0; i < childCount; ++i) {
                parcel.writeInt((int)childIds.get(i));
            }
        }
        parcel.writeInt(this.mConnectionId);
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$initFromParcel(Parcel parcel) {
        this.mType = parcel.readInt();
        this.mLayer = parcel.readInt();
        this.mBooleanProperties = parcel.readInt();
        this.mId = parcel.readInt();
        this.mParentId = parcel.readInt();
        this.mBoundsInScreen.readFromParcel(parcel);
        this.mTitle = parcel.readCharSequence();
        this.mAnchorId = parcel.readInt();
        this.mInPictureInPicture = parcel.readInt() == 1;
        int childCount = parcel.readInt();
        if (childCount > 0) {
            if (this.mChildIds == null) {
                this.mChildIds = new LongArray(childCount);
            }
            for (int i = 0; i < childCount; ++i) {
                int childId = parcel.readInt();
                this.mChildIds.add(childId);
            }
        }
        this.mConnectionId = parcel.readInt();
    }

    private final int $$robo$$android_view_accessibility_AccessibilityWindowInfo$hashCode() {
        return this.mId;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityWindowInfo other = (AccessibilityWindowInfo)obj;
        return this.mId == other.mId;
    }

    private final String $$robo$$android_view_accessibility_AccessibilityWindowInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccessibilityWindowInfo[");
        builder.append("title=").append(this.mTitle);
        builder.append("id=").append(this.mId);
        builder.append(", type=").append(AccessibilityWindowInfo.typeToString(this.mType));
        builder.append(", layer=").append(this.mLayer);
        builder.append(", bounds=").append(this.mBoundsInScreen);
        builder.append(", focused=").append(this.isFocused());
        builder.append(", active=").append(this.isActive());
        builder.append(", pictureInPicture=").append(this.inPictureInPicture());
        builder.append(", hasParent=").append(this.mParentId != -1);
        builder.append(", isAnchored=").append(this.mAnchorId != -1);
        builder.append(", hasChildren=").append(this.mChildIds != null && this.mChildIds.size() > 0);
        builder.append(']');
        return builder.toString();
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$clear() {
        this.mType = -1;
        this.mLayer = -1;
        this.mBooleanProperties = 0;
        this.mId = -1;
        this.mParentId = -1;
        this.mBoundsInScreen.setEmpty();
        if (this.mChildIds != null) {
            this.mChildIds.clear();
        }
        this.mConnectionId = -1;
        this.mAnchorId = -1;
        this.mInPictureInPicture = false;
        this.mTitle = null;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityWindowInfo$setBooleanProperty(int property, boolean value) {
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    private static final String $$robo$$android_view_accessibility_AccessibilityWindowInfo$typeToString(int type) {
        switch (type) {
            case 1: {
                return "TYPE_APPLICATION";
            }
            case 2: {
                return "TYPE_INPUT_METHOD";
            }
            case 3: {
                return "TYPE_SYSTEM";
            }
            case 4: {
                return "TYPE_ACCESSIBILITY_OVERLAY";
            }
            case 5: {
                return "TYPE_SPLIT_SCREEN_DIVIDER";
            }
        }
        return "<UNKNOWN>";
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityWindowInfo$changed(AccessibilityWindowInfo other) {
        if (other.mId != this.mId) {
            throw new IllegalArgumentException("Not same window.");
        }
        if (other.mType != this.mType) {
            throw new IllegalArgumentException("Not same type.");
        }
        if (!this.mBoundsInScreen.equals(other.mBoundsInScreen)) {
            return true;
        }
        if (this.mLayer != other.mLayer) {
            return true;
        }
        if (this.mBooleanProperties != other.mBooleanProperties) {
            return true;
        }
        if (this.mParentId != other.mParentId) {
            return true;
        }
        return this.mChildIds == null ? other.mChildIds != null : !this.mChildIds.equals(other.mChildIds);
    }

    static void __staticInitializer__() {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<AccessibilityWindowInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$__constructor__() {
            }

            private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$createFromParcel(Parcel parcel) {
                AccessibilityWindowInfo info = AccessibilityWindowInfo.obtain();
                info.initFromParcel(parcel);
                return info;
            }

            private final AccessibilityWindowInfo[] $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$newArray(int size) {
                return new AccessibilityWindowInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_accessibility_AccessibilityWindowInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$__constructor__(), 0, this);
            }

            @Override
            public AccessibilityWindowInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public AccessibilityWindowInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_accessibility_AccessibilityWindowInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityWindowInfo$__constructor__();
    }

    private AccessibilityWindowInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityWindowInfo$__constructor__(), 0, this);
    }

    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getTitle(), 0, this);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public int getType() {
        return (int)InvokeDynamicSupport.bootstrap("getType", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getType(), 0, this);
    }

    public void setType(int n) {
        InvokeDynamicSupport.bootstrap("setType", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setType(int ), 0, this, n);
    }

    public int getLayer() {
        return (int)InvokeDynamicSupport.bootstrap("getLayer", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getLayer(), 0, this);
    }

    public void setLayer(int n) {
        InvokeDynamicSupport.bootstrap("setLayer", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setLayer(int ), 0, this, n);
    }

    public AccessibilityNodeInfo getRoot() {
        return InvokeDynamicSupport.bootstrap("getRoot", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getRoot(), 0, this);
    }

    public void setAnchorId(int n) {
        InvokeDynamicSupport.bootstrap("setAnchorId", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setAnchorId(int ), 0, this, n);
    }

    public AccessibilityNodeInfo getAnchor() {
        return InvokeDynamicSupport.bootstrap("getAnchor", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getAnchor(), 0, this);
    }

    public void setPictureInPicture(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPictureInPicture", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setPictureInPicture(boolean ), 0, this, bl);
    }

    public boolean inPictureInPicture() {
        return (boolean)InvokeDynamicSupport.bootstrap("inPictureInPicture", $$robo$$android_view_accessibility_AccessibilityWindowInfo$inPictureInPicture(), 0, this);
    }

    public boolean isInPictureInPictureMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInPictureInPictureMode", $$robo$$android_view_accessibility_AccessibilityWindowInfo$isInPictureInPictureMode(), 0, this);
    }

    public AccessibilityWindowInfo getParent() {
        return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getParent(), 0, this);
    }

    public void setParentId(int n) {
        InvokeDynamicSupport.bootstrap("setParentId", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setParentId(int ), 0, this, n);
    }

    public int getId() {
        return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getId(), 0, this);
    }

    public void setId(int n) {
        InvokeDynamicSupport.bootstrap("setId", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setId(int ), 0, this, n);
    }

    public void setConnectionId(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionId", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setConnectionId(int ), 0, this, n);
    }

    public void getBoundsInScreen(Rect rect) {
        InvokeDynamicSupport.bootstrap("getBoundsInScreen", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getBoundsInScreen(android.graphics.Rect ), 0, this, rect);
    }

    public void setBoundsInScreen(Rect rect) {
        InvokeDynamicSupport.bootstrap("setBoundsInScreen", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setBoundsInScreen(android.graphics.Rect ), 0, this, rect);
    }

    public boolean isActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActive", $$robo$$android_view_accessibility_AccessibilityWindowInfo$isActive(), 0, this);
    }

    public void setActive(boolean bl) {
        InvokeDynamicSupport.bootstrap("setActive", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setActive(boolean ), 0, this, bl);
    }

    public boolean isFocused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocused", $$robo$$android_view_accessibility_AccessibilityWindowInfo$isFocused(), 0, this);
    }

    public void setFocused(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocused", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setFocused(boolean ), 0, this, bl);
    }

    public boolean isAccessibilityFocused() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAccessibilityFocused", $$robo$$android_view_accessibility_AccessibilityWindowInfo$isAccessibilityFocused(), 0, this);
    }

    public void setAccessibilityFocused(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAccessibilityFocused", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setAccessibilityFocused(boolean ), 0, this, bl);
    }

    public int getChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getChildCount(), 0, this);
    }

    public AccessibilityWindowInfo getChild(int n) {
        return InvokeDynamicSupport.bootstrap("getChild", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getChild(int ), 0, this, n);
    }

    public void addChild(int n) {
        InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_view_accessibility_AccessibilityWindowInfo$addChild(int ), 0, this, n);
    }

    public static AccessibilityWindowInfo obtain() {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityWindowInfo$obtain(), 0);
    }

    public static AccessibilityWindowInfo obtain(AccessibilityWindowInfo accessibilityWindowInfo) {
        return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_accessibility_AccessibilityWindowInfo$obtain(android.view.accessibility.AccessibilityWindowInfo ), 0, (AccessibilityWindowInfo)accessibilityWindowInfo);
    }

    public static void setNumInstancesInUseCounter(AtomicInteger atomicInteger) {
        InvokeDynamicSupport.bootstrapStatic("setNumInstancesInUseCounter", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setNumInstancesInUseCounter(java.util.concurrent.atomic.AtomicInteger ), 0, (AtomicInteger)atomicInteger);
    }

    public void recycle() {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_accessibility_AccessibilityWindowInfo$recycle(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_accessibility_AccessibilityWindowInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_accessibility_AccessibilityWindowInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private void initFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("initFromParcel", $$robo$$android_view_accessibility_AccessibilityWindowInfo$initFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_accessibility_AccessibilityWindowInfo$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_accessibility_AccessibilityWindowInfo$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_accessibility_AccessibilityWindowInfo$toString(), 0, this);
    }

    private void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_view_accessibility_AccessibilityWindowInfo$clear(), 0, this);
    }

    private boolean getBooleanProperty(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getBooleanProperty", $$robo$$android_view_accessibility_AccessibilityWindowInfo$getBooleanProperty(int ), 0, this, n);
    }

    private void setBooleanProperty(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBooleanProperty", $$robo$$android_view_accessibility_AccessibilityWindowInfo$setBooleanProperty(int boolean ), 0, this, n, bl);
    }

    private static String typeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("typeToString", $$robo$$android_view_accessibility_AccessibilityWindowInfo$typeToString(int ), 0, (int)n);
    }

    public boolean changed(AccessibilityWindowInfo accessibilityWindowInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("changed", $$robo$$android_view_accessibility_AccessibilityWindowInfo$changed(android.view.accessibility.AccessibilityWindowInfo ), 0, this, accessibilityWindowInfo);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityWindowInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityWindowInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

