/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class EntityConfidence<T> {
    public transient /* synthetic */ Object __robo_data__;
    private Map<T, Float> mEntityConfidence;
    private Comparator<T> mEntityComparator;

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__() {
        this.mEntityConfidence = new HashMap<T, Float>();
        this.mEntityComparator = (e1, e2) -> {
            float score2;
            float score1 = this.mEntityConfidence.get(e1).floatValue();
            if (score1 > (score2 = this.mEntityConfidence.get(e2).floatValue())) {
                return -1;
            }
            if (score1 < score2) {
                return 1;
            }
            return 0;
        };
    }

    private void $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(EntityConfidence<T> source) {
        this.mEntityConfidence = new HashMap<T, Float>();
        this.mEntityComparator = (e1, e2) -> {
            float score2;
            float score1 = this.mEntityConfidence.get(e1).floatValue();
            if (score1 > (score2 = this.mEntityConfidence.get(e2).floatValue())) {
                return -1;
            }
            if (score1 < score2) {
                return 1;
            }
            return 0;
        };
        Preconditions.checkNotNull(source);
        this.mEntityConfidence.putAll(source.mEntityConfidence);
    }

    private final void $$robo$$android_view_textclassifier_EntityConfidence$setEntityType(T type, float confidenceScore) {
        Preconditions.checkNotNull(type);
        if (confidenceScore > 0.0f) {
            this.mEntityConfidence.put(type, Float.valueOf(Math.min(1.0f, confidenceScore)));
        } else {
            this.mEntityConfidence.remove(type);
        }
    }

    private final List<T> $$robo$$android_view_textclassifier_EntityConfidence$getEntities() {
        ArrayList<T> entities = new ArrayList<T>(this.mEntityConfidence.size());
        entities.addAll(this.mEntityConfidence.keySet());
        entities.sort(this.mEntityComparator);
        return Collections.unmodifiableList(entities);
    }

    private final float $$robo$$android_view_textclassifier_EntityConfidence$getConfidenceScore(T entity) {
        if (this.mEntityConfidence.containsKey(entity)) {
            return this.mEntityConfidence.get(entity).floatValue();
        }
        return 0.0f;
    }

    private final String $$robo$$android_view_textclassifier_EntityConfidence$toString() {
        return this.mEntityConfidence.toString();
    }

    private void __constructor__() {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__();
    }

    EntityConfidence() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(), 0, this);
    }

    private void __constructor__(EntityConfidence<T> entityConfidence) {
        this.$$robo$$android_view_textclassifier_EntityConfidence$__constructor__(entityConfidence);
    }

    EntityConfidence(EntityConfidence<T> entityConfidence) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_EntityConfidence$__constructor__(android.view.textclassifier.EntityConfidence<T> ), 0, this, entityConfidence);
    }

    public void setEntityType(T t, float f) {
        InvokeDynamicSupport.bootstrap("setEntityType", $$robo$$android_view_textclassifier_EntityConfidence$setEntityType(T float ), 0, this, t, f);
    }

    public List<T> getEntities() {
        return InvokeDynamicSupport.bootstrap("getEntities", $$robo$$android_view_textclassifier_EntityConfidence$getEntities(), 0, this);
    }

    public float getConfidenceScore(T t) {
        return (float)InvokeDynamicSupport.bootstrap("getConfidenceScore", $$robo$$android_view_textclassifier_EntityConfidence$getConfidenceScore(T ), 0, this, t);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_textclassifier_EntityConfidence$toString(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EntityConfidence)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

