/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityManager;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.android.internal.policy.PhoneWindow;
import java.util.Formatter;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MediaController
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private MediaPlayerControl mPlayer;
    private Context mContext;
    private View mAnchor;
    private View mRoot;
    private WindowManager mWindowManager;
    private Window mWindow;
    private View mDecor;
    private WindowManager.LayoutParams mDecorLayoutParams;
    private ProgressBar mProgress;
    private TextView mEndTime;
    private TextView mCurrentTime;
    private boolean mShowing;
    private boolean mDragging;
    private static int sDefaultTimeout = 3000;
    private boolean mUseFastForward;
    private boolean mFromXml;
    private boolean mListenersSet;
    private View.OnClickListener mNextListener;
    private View.OnClickListener mPrevListener;
    StringBuilder mFormatBuilder;
    Formatter mFormatter;
    private ImageButton mPauseButton;
    private ImageButton mFfwdButton;
    private ImageButton mRewButton;
    private ImageButton mNextButton;
    private ImageButton mPrevButton;
    private CharSequence mPlayDescription;
    private CharSequence mPauseDescription;
    private AccessibilityManager mAccessibilityManager;
    private View.OnLayoutChangeListener mLayoutChangeListener;
    private View.OnTouchListener mTouchListener;
    private Runnable mFadeOut;
    private Runnable mShowProgress;
    private View.OnClickListener mPauseListener;
    private SeekBar.OnSeekBarChangeListener mSeekListener;
    private View.OnClickListener mRewListener;
    private View.OnClickListener mFfwdListener;

    private void $$robo$$android_widget_MediaController$__constructor__(Context context, AttributeSet attrs) {
        this.mLayoutChangeListener = new View.OnLayoutChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_1$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_1$onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                this.this$0.updateFloatingWindowLayout();
                if (this.this$0.mShowing) {
                    this.this$0.mWindowManager.updateViewLayout(this.this$0.mDecor, this.this$0.mDecorLayoutParams);
                }
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_1$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_1$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                InvokeDynamicSupport.bootstrap("onLayoutChange", $$robo$$android_widget_MediaController_1$onLayoutChange(android.view.View int int int int int int int int ), 0, this, view, n, n2, n3, n4, n5, n6, n7, n8);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTouchListener = new View.OnTouchListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_2$__constructor__(MediaController this$0) {
            }

            private final boolean $$robo$$android_widget_MediaController_2$onTouch(View v, MotionEvent event) {
                if (event.getAction() == 0 && this.this$0.mShowing) {
                    this.this$0.hide();
                }
                return false;
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_2$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_2$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public boolean onTouch(View view, MotionEvent motionEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_MediaController_2$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFadeOut = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_3$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_3$run() {
                this.this$0.hide();
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_3$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_3$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_MediaController_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mShowProgress = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_4$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_4$run() {
                int pos = this.this$0.setProgress();
                if (!this.this$0.mDragging && this.this$0.mShowing && this.this$0.mPlayer.isPlaying()) {
                    this.this$0.postDelayed(this.this$0.mShowProgress, 1000 - pos % 1000);
                }
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_4$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_4$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_MediaController_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPauseListener = new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_5$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_5$onClick(View v) {
                this.this$0.doPauseResume();
                this.this$0.show(3000);
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_5$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_5$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_MediaController_5$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSeekListener = new SeekBar.OnSeekBarChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_6$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_6$onStartTrackingTouch(SeekBar bar) {
                this.this$0.show(3600000);
                this.this$0.mDragging = true;
                this.this$0.removeCallbacks(this.this$0.mShowProgress);
            }

            private final void $$robo$$android_widget_MediaController_6$onProgressChanged(SeekBar bar, int progress, boolean fromuser) {
                if (!fromuser) {
                    return;
                }
                long duration = this.this$0.mPlayer.getDuration();
                long newposition = duration * (long)progress / 1000L;
                this.this$0.mPlayer.seekTo((int)newposition);
                if (this.this$0.mCurrentTime != null) {
                    this.this$0.mCurrentTime.setText(this.this$0.stringForTime((int)newposition));
                }
            }

            private final void $$robo$$android_widget_MediaController_6$onStopTrackingTouch(SeekBar bar) {
                this.this$0.mDragging = false;
                this.this$0.setProgress();
                this.this$0.updatePausePlay();
                this.this$0.show(3000);
                this.this$0.post(this.this$0.mShowProgress);
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_6$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_6$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$android_widget_MediaController_6$onStartTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
            }

            @Override
            public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onProgressChanged", $$robo$$android_widget_MediaController_6$onProgressChanged(android.widget.SeekBar int boolean ), 0, this, seekBar, n, bl);
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$android_widget_MediaController_6$onStopTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRewListener = new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_7$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_7$onClick(View v) {
                int pos = this.this$0.mPlayer.getCurrentPosition();
                this.this$0.mPlayer.seekTo(pos -= 5000);
                this.this$0.setProgress();
                this.this$0.show(3000);
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_7$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_7$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_MediaController_7$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFfwdListener = new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MediaController this$0;

            private void $$robo$$android_widget_MediaController_8$__constructor__(MediaController this$0) {
            }

            private final void $$robo$$android_widget_MediaController_8$onClick(View v) {
                int pos = this.this$0.mPlayer.getCurrentPosition();
                this.this$0.mPlayer.seekTo(pos += 15000);
                this.this$0.setProgress();
                this.this$0.show(3000);
            }

            private void __constructor__(MediaController mediaController) {
                this.$$robo$$android_widget_MediaController_8$__constructor__(mediaController);
            }
            {
                this.this$0 = mediaController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController_8$__constructor__(android.widget.MediaController ), 0, this, mediaController);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_MediaController_8$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRoot = this;
        this.mContext = context;
        this.mUseFastForward = true;
        this.mFromXml = true;
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
    }

    private final void $$robo$$android_widget_MediaController$onFinishInflate() {
        if (this.mRoot != null) {
            this.initControllerView(this.mRoot);
        }
    }

    private void $$robo$$android_widget_MediaController$__constructor__(Context context, boolean useFastForward) {
        this.mLayoutChangeListener = new /* invalid duplicate definition of identical inner class */;
        this.mTouchListener = new /* invalid duplicate definition of identical inner class */;
        this.mFadeOut = new /* invalid duplicate definition of identical inner class */;
        this.mShowProgress = new /* invalid duplicate definition of identical inner class */;
        this.mPauseListener = new /* invalid duplicate definition of identical inner class */;
        this.mSeekListener = new /* invalid duplicate definition of identical inner class */;
        this.mRewListener = new /* invalid duplicate definition of identical inner class */;
        this.mFfwdListener = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mUseFastForward = useFastForward;
        this.initFloatingWindowLayout();
        this.initFloatingWindow();
        this.mAccessibilityManager = AccessibilityManager.getInstance(context);
    }

    private void $$robo$$android_widget_MediaController$__constructor__(Context context) {
    }

    private final void $$robo$$android_widget_MediaController$initFloatingWindow() {
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.mWindow = new PhoneWindow(this.mContext);
        this.mWindow.setWindowManager(this.mWindowManager, null, null);
        this.mWindow.requestFeature(1);
        this.mDecor = this.mWindow.getDecorView();
        this.mDecor.setOnTouchListener(this.mTouchListener);
        this.mWindow.setContentView(this);
        this.mWindow.setBackgroundDrawableResource(17170445);
        this.mWindow.setVolumeControlStream(3);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.requestFocus();
    }

    private final void $$robo$$android_widget_MediaController$initFloatingWindowLayout() {
        WindowManager.LayoutParams p = this.mDecorLayoutParams = new WindowManager.LayoutParams();
        p.gravity = 51;
        p.height = -2;
        p.x = 0;
        p.format = -3;
        p.type = 1000;
        p.flags |= 0x820020;
        p.token = null;
        p.windowAnimations = 0;
    }

    private final void $$robo$$android_widget_MediaController$updateFloatingWindowLayout() {
        int[] anchorPos = new int[2];
        this.mAnchor.getLocationOnScreen(anchorPos);
        this.mDecor.measure(View.MeasureSpec.makeMeasureSpec(this.mAnchor.getWidth(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(this.mAnchor.getHeight(), Integer.MIN_VALUE));
        WindowManager.LayoutParams p = this.mDecorLayoutParams;
        p.width = this.mAnchor.getWidth();
        p.x = anchorPos[0] + (this.mAnchor.getWidth() - p.width) / 2;
        p.y = anchorPos[1] + this.mAnchor.getHeight() - this.mDecor.getMeasuredHeight();
    }

    private final void $$robo$$android_widget_MediaController$setMediaPlayer(MediaPlayerControl player) {
        this.mPlayer = player;
        this.updatePausePlay();
    }

    private final void $$robo$$android_widget_MediaController$setAnchorView(View view) {
        if (this.mAnchor != null) {
            this.mAnchor.removeOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        this.mAnchor = view;
        if (this.mAnchor != null) {
            this.mAnchor.addOnLayoutChangeListener(this.mLayoutChangeListener);
        }
        FrameLayout.LayoutParams frameParams = new FrameLayout.LayoutParams(-1, -1);
        this.removeAllViews();
        View v = this.makeControllerView();
        this.addView(v, frameParams);
    }

    private final View $$robo$$android_widget_MediaController$makeControllerView() {
        LayoutInflater inflate = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mRoot = inflate.inflate(17367167, null);
        this.initControllerView(this.mRoot);
        return this.mRoot;
    }

    private final void $$robo$$android_widget_MediaController$initControllerView(View v) {
        Resources res = this.mContext.getResources();
        this.mPlayDescription = res.getText(17040143);
        this.mPauseDescription = res.getText(17040142);
        this.mPauseButton = (ImageButton)v.findViewById(16909136);
        if (this.mPauseButton != null) {
            this.mPauseButton.requestFocus();
            this.mPauseButton.setOnClickListener(this.mPauseListener);
        }
        this.mFfwdButton = (ImageButton)v.findViewById(16908863);
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setOnClickListener(this.mFfwdListener);
            if (!this.mFromXml) {
                this.mFfwdButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mRewButton = (ImageButton)v.findViewById(16909200);
        if (this.mRewButton != null) {
            this.mRewButton.setOnClickListener(this.mRewListener);
            if (!this.mFromXml) {
                this.mRewButton.setVisibility(this.mUseFastForward ? 0 : 8);
            }
        }
        this.mNextButton = (ImageButton)v.findViewById(16909074);
        if (this.mNextButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mNextButton.setVisibility(8);
        }
        this.mPrevButton = (ImageButton)v.findViewById(16909170);
        if (this.mPrevButton != null && !this.mFromXml && !this.mListenersSet) {
            this.mPrevButton.setVisibility(8);
        }
        this.mProgress = (ProgressBar)v.findViewById(16909040);
        if (this.mProgress != null) {
            if (this.mProgress instanceof SeekBar) {
                SeekBar seeker = (SeekBar)this.mProgress;
                seeker.setOnSeekBarChangeListener(this.mSeekListener);
            }
            this.mProgress.setMax(1000);
        }
        this.mEndTime = (TextView)v.findViewById(16909359);
        this.mCurrentTime = (TextView)v.findViewById(16909362);
        this.mFormatBuilder = new StringBuilder();
        this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        this.installPrevNextListeners();
    }

    private final void $$robo$$android_widget_MediaController$show() {
        this.show(3000);
    }

    private final void $$robo$$android_widget_MediaController$disableUnsupportedButtons() {
        try {
            if (this.mPauseButton != null && !this.mPlayer.canPause()) {
                this.mPauseButton.setEnabled(false);
            }
            if (this.mRewButton != null && !this.mPlayer.canSeekBackward()) {
                this.mRewButton.setEnabled(false);
            }
            if (this.mFfwdButton != null && !this.mPlayer.canSeekForward()) {
                this.mFfwdButton.setEnabled(false);
            }
            if (this.mProgress != null && !this.mPlayer.canSeekBackward() && !this.mPlayer.canSeekForward()) {
                this.mProgress.setEnabled(false);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    private final void $$robo$$android_widget_MediaController$show(int timeout) {
        if (!this.mShowing && this.mAnchor != null) {
            this.setProgress();
            if (this.mPauseButton != null) {
                this.mPauseButton.requestFocus();
            }
            this.disableUnsupportedButtons();
            this.updateFloatingWindowLayout();
            this.mWindowManager.addView(this.mDecor, this.mDecorLayoutParams);
            this.mShowing = true;
        }
        this.updatePausePlay();
        this.post(this.mShowProgress);
        if (timeout != 0 && !this.mAccessibilityManager.isTouchExplorationEnabled()) {
            this.removeCallbacks(this.mFadeOut);
            this.postDelayed(this.mFadeOut, timeout);
        }
    }

    private final boolean $$robo$$android_widget_MediaController$isShowing() {
        return this.mShowing;
    }

    private final void $$robo$$android_widget_MediaController$hide() {
        if (this.mAnchor == null) {
            return;
        }
        if (this.mShowing) {
            try {
                this.removeCallbacks(this.mShowProgress);
                this.mWindowManager.removeView(this.mDecor);
            }
            catch (IllegalArgumentException ex) {
                Log.w("MediaController", "already removed");
            }
            this.mShowing = false;
        }
    }

    private final String $$robo$$android_widget_MediaController$stringForTime(int timeMs) {
        int totalSeconds = timeMs / 1000;
        int seconds = totalSeconds % 60;
        int minutes = totalSeconds / 60 % 60;
        int hours = totalSeconds / 3600;
        this.mFormatBuilder.setLength(0);
        if (hours > 0) {
            return this.mFormatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
        }
        return this.mFormatter.format("%02d:%02d", minutes, seconds).toString();
    }

    private final int $$robo$$android_widget_MediaController$setProgress() {
        if (this.mPlayer == null || this.mDragging) {
            return 0;
        }
        int position = this.mPlayer.getCurrentPosition();
        int duration = this.mPlayer.getDuration();
        if (this.mProgress != null) {
            if (duration > 0) {
                long pos = 1000L * (long)position / (long)duration;
                this.mProgress.setProgress((int)pos);
            }
            int percent = this.mPlayer.getBufferPercentage();
            this.mProgress.setSecondaryProgress(percent * 10);
        }
        if (this.mEndTime != null) {
            this.mEndTime.setText(this.stringForTime(duration));
        }
        if (this.mCurrentTime != null) {
            this.mCurrentTime.setText(this.stringForTime(position));
        }
        return position;
    }

    private final boolean $$robo$$android_widget_MediaController$onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.show(0);
                break;
            }
            case 1: {
                this.show(3000);
                break;
            }
            case 3: {
                this.hide();
                break;
            }
        }
        return true;
    }

    private final boolean $$robo$$android_widget_MediaController$onTrackballEvent(MotionEvent ev) {
        this.show(3000);
        return false;
    }

    private final boolean $$robo$$android_widget_MediaController$dispatchKeyEvent(KeyEvent event) {
        boolean uniqueDown;
        int keyCode = event.getKeyCode();
        boolean bl = uniqueDown = event.getRepeatCount() == 0 && event.getAction() == 0;
        if (keyCode == 79 || keyCode == 85 || keyCode == 62) {
            if (uniqueDown) {
                this.doPauseResume();
                this.show(3000);
                if (this.mPauseButton != null) {
                    this.mPauseButton.requestFocus();
                }
            }
            return true;
        }
        if (keyCode == 126) {
            if (uniqueDown && !this.mPlayer.isPlaying()) {
                this.mPlayer.start();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 86 || keyCode == 127) {
            if (uniqueDown && this.mPlayer.isPlaying()) {
                this.mPlayer.pause();
                this.updatePausePlay();
                this.show(3000);
            }
            return true;
        }
        if (keyCode == 25 || keyCode == 24 || keyCode == 164 || keyCode == 27) {
            return super.dispatchKeyEvent(event);
        }
        if (keyCode == 4 || keyCode == 82) {
            if (uniqueDown) {
                this.hide();
            }
            return true;
        }
        this.show(3000);
        return super.dispatchKeyEvent(event);
    }

    private final void $$robo$$android_widget_MediaController$updatePausePlay() {
        if (this.mRoot == null || this.mPauseButton == null) {
            return;
        }
        if (this.mPlayer.isPlaying()) {
            this.mPauseButton.setImageResource(17301539);
            this.mPauseButton.setContentDescription(this.mPauseDescription);
        } else {
            this.mPauseButton.setImageResource(17301540);
            this.mPauseButton.setContentDescription(this.mPlayDescription);
        }
    }

    private final void $$robo$$android_widget_MediaController$doPauseResume() {
        if (this.mPlayer.isPlaying()) {
            this.mPlayer.pause();
        } else {
            this.mPlayer.start();
        }
        this.updatePausePlay();
    }

    private final void $$robo$$android_widget_MediaController$setEnabled(boolean enabled) {
        if (this.mPauseButton != null) {
            this.mPauseButton.setEnabled(enabled);
        }
        if (this.mFfwdButton != null) {
            this.mFfwdButton.setEnabled(enabled);
        }
        if (this.mRewButton != null) {
            this.mRewButton.setEnabled(enabled);
        }
        if (this.mNextButton != null) {
            this.mNextButton.setEnabled(enabled && this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setEnabled(enabled && this.mPrevListener != null);
        }
        if (this.mProgress != null) {
            this.mProgress.setEnabled(enabled);
        }
        this.disableUnsupportedButtons();
        super.setEnabled(enabled);
    }

    private final CharSequence $$robo$$android_widget_MediaController$getAccessibilityClassName() {
        return MediaController.class.getName();
    }

    private final void $$robo$$android_widget_MediaController$installPrevNextListeners() {
        if (this.mNextButton != null) {
            this.mNextButton.setOnClickListener(this.mNextListener);
            this.mNextButton.setEnabled(this.mNextListener != null);
        }
        if (this.mPrevButton != null) {
            this.mPrevButton.setOnClickListener(this.mPrevListener);
            this.mPrevButton.setEnabled(this.mPrevListener != null);
        }
    }

    private final void $$robo$$android_widget_MediaController$setPrevNextListeners(View.OnClickListener next, View.OnClickListener prev) {
        this.mNextListener = next;
        this.mPrevListener = prev;
        this.mListenersSet = true;
        if (this.mRoot != null) {
            this.installPrevNextListeners();
            if (this.mNextButton != null && !this.mFromXml) {
                this.mNextButton.setVisibility(0);
            }
            if (this.mPrevButton != null && !this.mFromXml) {
                this.mPrevButton.setVisibility(0);
            }
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_MediaController$__constructor__(context, attributeSet);
    }

    public MediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    public void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$android_widget_MediaController$onFinishInflate(), 0, this);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_widget_MediaController$__constructor__(context, bl);
    }

    public MediaController(Context context, boolean bl) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_MediaController$__constructor__(context);
    }

    public MediaController(Context context) {
        this(context, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_MediaController$__constructor__(android.content.Context ), 0, this, context);
    }

    private void initFloatingWindow() {
        InvokeDynamicSupport.bootstrap("initFloatingWindow", $$robo$$android_widget_MediaController$initFloatingWindow(), 0, this);
    }

    private void initFloatingWindowLayout() {
        InvokeDynamicSupport.bootstrap("initFloatingWindowLayout", $$robo$$android_widget_MediaController$initFloatingWindowLayout(), 0, this);
    }

    private void updateFloatingWindowLayout() {
        InvokeDynamicSupport.bootstrap("updateFloatingWindowLayout", $$robo$$android_widget_MediaController$updateFloatingWindowLayout(), 0, this);
    }

    public void setMediaPlayer(MediaPlayerControl mediaPlayerControl) {
        InvokeDynamicSupport.bootstrap("setMediaPlayer", $$robo$$android_widget_MediaController$setMediaPlayer(android.widget.MediaController$MediaPlayerControl ), 0, this, mediaPlayerControl);
    }

    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$android_widget_MediaController$setAnchorView(android.view.View ), 0, this, view);
    }

    protected View makeControllerView() {
        return InvokeDynamicSupport.bootstrap("makeControllerView", $$robo$$android_widget_MediaController$makeControllerView(), 0, this);
    }

    private void initControllerView(View view) {
        InvokeDynamicSupport.bootstrap("initControllerView", $$robo$$android_widget_MediaController$initControllerView(android.view.View ), 0, this, view);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_MediaController$show(), 0, this);
    }

    private void disableUnsupportedButtons() {
        InvokeDynamicSupport.bootstrap("disableUnsupportedButtons", $$robo$$android_widget_MediaController$disableUnsupportedButtons(), 0, this);
    }

    public void show(int n) {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_MediaController$show(int ), 0, this, n);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_MediaController$isShowing(), 0, this);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$android_widget_MediaController$hide(), 0, this);
    }

    private String stringForTime(int n) {
        return InvokeDynamicSupport.bootstrap("stringForTime", $$robo$$android_widget_MediaController$stringForTime(int ), 0, this, n);
    }

    private int setProgress() {
        return (int)InvokeDynamicSupport.bootstrap("setProgress", $$robo$$android_widget_MediaController$setProgress(), 0, this);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_MediaController$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTrackballEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTrackballEvent", $$robo$$android_widget_MediaController$onTrackballEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_MediaController$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    private void updatePausePlay() {
        InvokeDynamicSupport.bootstrap("updatePausePlay", $$robo$$android_widget_MediaController$updatePausePlay(), 0, this);
    }

    private void doPauseResume() {
        InvokeDynamicSupport.bootstrap("doPauseResume", $$robo$$android_widget_MediaController$doPauseResume(), 0, this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_MediaController$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_MediaController$getAccessibilityClassName(), 0, this);
    }

    private void installPrevNextListeners() {
        InvokeDynamicSupport.bootstrap("installPrevNextListeners", $$robo$$android_widget_MediaController$installPrevNextListeners(), 0, this);
    }

    public void setPrevNextListeners(View.OnClickListener onClickListener, View.OnClickListener onClickListener2) {
        InvokeDynamicSupport.bootstrap("setPrevNextListeners", $$robo$$android_widget_MediaController$setPrevNextListeners(android.view.View$OnClickListener android.view.View$OnClickListener ), 0, this, onClickListener, onClickListener2);
    }

    public /* synthetic */ MediaController() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MediaController)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface MediaPlayerControl
    extends InstrumentedInterface {
        public void start();

        public void pause();

        public int getDuration();

        public int getCurrentPosition();

        public void seekTo(int var1);

        public boolean isPlaying();

        public int getBufferPercentage();

        public boolean canPause();

        public boolean canSeekBackward();

        public boolean canSeekForward();

        public int getAudioSessionId();
    }
}

