/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.LinearLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Rect mBounds;
    private OnTabSelectionChanged mSelectionChangedListener;
    private int mSelectedTab;
    private Drawable mLeftStrip;
    private Drawable mRightStrip;
    private boolean mDrawBottomStrips;
    private boolean mStripMoved;
    private int mImposedTabsHeight;
    private int[] mImposedTabWidths;

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mBounds = new Rect();
        this.mSelectedTab = -1;
        this.mDrawBottomStrips = true;
        this.mImposedTabsHeight = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyleAttr, defStyleRes);
        this.mDrawBottomStrips = a.getBoolean(3, this.mDrawBottomStrips);
        boolean isTargetSdkDonutOrLower = context.getApplicationInfo().targetSdkVersion <= 4;
        boolean hasExplicitLeft = a.hasValueOrEmpty(1);
        this.mLeftStrip = hasExplicitLeft ? a.getDrawable(1) : (isTargetSdkDonutOrLower ? context.getDrawable(17303438) : context.getDrawable(17303437));
        boolean hasExplicitRight = a.hasValueOrEmpty(2);
        this.mRightStrip = hasExplicitRight ? a.getDrawable(2) : (isTargetSdkDonutOrLower ? context.getDrawable(17303440) : context.getDrawable(17303439));
        a.recycle();
        this.setChildrenDrawingOrderEnabled(true);
    }

    private final void $$robo$$android_widget_TabWidget$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStripMoved = true;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private final int $$robo$$android_widget_TabWidget$getChildDrawingOrder(int childCount, int i) {
        if (this.mSelectedTab == -1) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mSelectedTab;
        }
        if (i >= this.mSelectedTab) {
            return i + 1;
        }
        return i;
    }

    private final void $$robo$$android_widget_TabWidget$measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (!this.isMeasureWithLargestChildEnabled() && this.mImposedTabsHeight >= 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(totalWidth + this.mImposedTabWidths[childIndex], 0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mImposedTabsHeight, 0x40000000);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private final void $$robo$$android_widget_TabWidget$measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode(widthMeasureSpec) == 0) {
            super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int width = View.MeasureSpec.getSize(widthMeasureSpec);
        int unspecifiedWidth = View.MeasureSpec.makeSafeMeasureSpec(width, 0);
        this.mImposedTabsHeight = -1;
        super.measureHorizontal(unspecifiedWidth, heightMeasureSpec);
        int extraWidth = this.getMeasuredWidth() - width;
        if (extraWidth > 0) {
            View child;
            int i;
            int count = this.getChildCount();
            int childCount = 0;
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ++childCount;
            }
            if (childCount > 0) {
                if (this.mImposedTabWidths == null || this.mImposedTabWidths.length != count) {
                    this.mImposedTabWidths = new int[count];
                }
                for (i = 0; i < count; ++i) {
                    int newWidth;
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    int childWidth = child.getMeasuredWidth();
                    int delta = extraWidth / childCount;
                    this.mImposedTabWidths[i] = newWidth = Math.max(0, childWidth - delta);
                    extraWidth -= childWidth - newWidth;
                    --childCount;
                    this.mImposedTabsHeight = Math.max(this.mImposedTabsHeight, child.getMeasuredHeight());
                }
            }
        }
        super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    private final View $$robo$$android_widget_TabWidget$getChildTabViewAt(int index) {
        return this.getChildAt(index);
    }

    private final int $$robo$$android_widget_TabWidget$getTabCount() {
        return this.getChildCount();
    }

    private final void $$robo$$android_widget_TabWidget$setDividerDrawable(Drawable drawable2) {
        super.setDividerDrawable(drawable2);
    }

    private final void $$robo$$android_widget_TabWidget$setDividerDrawable(int resId) {
        this.setDividerDrawable(this.mContext.getDrawable(resId));
    }

    private final void $$robo$$android_widget_TabWidget$setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_TabWidget$setLeftStripDrawable(int resId) {
        this.setLeftStripDrawable(this.mContext.getDrawable(resId));
    }

    private final Drawable $$robo$$android_widget_TabWidget$getLeftStripDrawable() {
        return this.mLeftStrip;
    }

    private final void $$robo$$android_widget_TabWidget$setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_TabWidget$setRightStripDrawable(int resId) {
        this.setRightStripDrawable(this.mContext.getDrawable(resId));
    }

    private final Drawable $$robo$$android_widget_TabWidget$getRightStripDrawable() {
        return this.mRightStrip;
    }

    private final void $$robo$$android_widget_TabWidget$setStripEnabled(boolean stripEnabled) {
        this.mDrawBottomStrips = stripEnabled;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_TabWidget$isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    private final void $$robo$$android_widget_TabWidget$childDrawableStateChanged(View child) {
        if (this.getTabCount() > 0 && child == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(child);
    }

    private final void $$robo$$android_widget_TabWidget$dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0) {
            return;
        }
        if (!this.mDrawBottomStrips) {
            return;
        }
        View selectedChild = this.getChildTabViewAt(this.mSelectedTab);
        Drawable leftStrip = this.mLeftStrip;
        Drawable rightStrip = this.mRightStrip;
        leftStrip.setState(selectedChild.getDrawableState());
        rightStrip.setState(selectedChild.getDrawableState());
        if (this.mStripMoved) {
            Rect bounds = this.mBounds;
            bounds.left = selectedChild.getLeft();
            bounds.right = selectedChild.getRight();
            int myHeight = this.getHeight();
            leftStrip.setBounds(Math.min(0, bounds.left - leftStrip.getIntrinsicWidth()), myHeight - leftStrip.getIntrinsicHeight(), bounds.left, myHeight);
            rightStrip.setBounds(bounds.right, myHeight - rightStrip.getIntrinsicHeight(), Math.max(this.getWidth(), bounds.right + rightStrip.getIntrinsicWidth()), myHeight);
            this.mStripMoved = false;
        }
        leftStrip.draw(canvas);
        rightStrip.draw(canvas);
    }

    private final void $$robo$$android_widget_TabWidget$setCurrentTab(int index) {
        if (index < 0 || index >= this.getTabCount() || index == this.mSelectedTab) {
            return;
        }
        if (this.mSelectedTab != -1) {
            this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
        }
        this.mSelectedTab = index;
        this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
        this.mStripMoved = true;
    }

    private final CharSequence $$robo$$android_widget_TabWidget$getAccessibilityClassName() {
        return TabWidget.class.getName();
    }

    private final void $$robo$$android_widget_TabWidget$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setItemCount(this.getTabCount());
        event.setCurrentItemIndex(this.mSelectedTab);
    }

    private final void $$robo$$android_widget_TabWidget$focusCurrentTab(int index) {
        int oldTab = this.mSelectedTab;
        this.setCurrentTab(index);
        if (oldTab != index) {
            this.getChildTabViewAt(index).requestFocus();
        }
    }

    private final void $$robo$$android_widget_TabWidget$setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildTabViewAt(i);
            child.setEnabled(enabled);
        }
    }

    private final void $$robo$$android_widget_TabWidget$addView(View child) {
        if (child.getLayoutParams() == null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            lp.setMargins(0, 0, 0, 0);
            child.setLayoutParams(lp);
        }
        child.setFocusable(true);
        child.setClickable(true);
        if (child.getPointerIcon() == null) {
            child.setPointerIcon(PointerIcon.getSystemIcon(this.getContext(), 1002));
        }
        super.addView(child);
        child.setOnClickListener(new TabClickListener(this, this.getTabCount() - 1));
    }

    private final void $$robo$$android_widget_TabWidget$removeAllViews() {
        super.removeAllViews();
        this.mSelectedTab = -1;
    }

    private final PointerIcon $$robo$$android_widget_TabWidget$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (!this.isEnabled()) {
            return null;
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    private final void $$robo$$android_widget_TabWidget$setTabSelectionListener(OnTabSelectionChanged listener) {
        this.mSelectionChangedListener = listener;
    }

    private final void $$robo$$android_widget_TabWidget$onFocusChange(View v, boolean hasFocus) {
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context);
    }

    public TabWidget(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet);
    }

    public TabWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet, n);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet, n, n2);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_TabWidget$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getChildDrawingOrder", $$robo$$android_widget_TabWidget$getChildDrawingOrder(int int ), 0, this, n, n2);
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("measureChildBeforeLayout", $$robo$$android_widget_TabWidget$measureChildBeforeLayout(android.view.View int int int int int ), 0, this, view, n, n2, n3, n4, n5);
    }

    @Override
    void measureHorizontal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureHorizontal", $$robo$$android_widget_TabWidget$measureHorizontal(int int ), 0, this, n, n2);
    }

    public View getChildTabViewAt(int n) {
        return InvokeDynamicSupport.bootstrap("getChildTabViewAt", $$robo$$android_widget_TabWidget$getChildTabViewAt(int ), 0, this, n);
    }

    public int getTabCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTabCount", $$robo$$android_widget_TabWidget$getTabCount(), 0, this);
    }

    @Override
    public void setDividerDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDividerDrawable", $$robo$$android_widget_TabWidget$setDividerDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setDividerDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setDividerDrawable", $$robo$$android_widget_TabWidget$setDividerDrawable(int ), 0, this, n);
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setLeftStripDrawable", $$robo$$android_widget_TabWidget$setLeftStripDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setLeftStripDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setLeftStripDrawable", $$robo$$android_widget_TabWidget$setLeftStripDrawable(int ), 0, this, n);
    }

    public Drawable getLeftStripDrawable() {
        return InvokeDynamicSupport.bootstrap("getLeftStripDrawable", $$robo$$android_widget_TabWidget$getLeftStripDrawable(), 0, this);
    }

    public void setRightStripDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setRightStripDrawable", $$robo$$android_widget_TabWidget$setRightStripDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setRightStripDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setRightStripDrawable", $$robo$$android_widget_TabWidget$setRightStripDrawable(int ), 0, this, n);
    }

    public Drawable getRightStripDrawable() {
        return InvokeDynamicSupport.bootstrap("getRightStripDrawable", $$robo$$android_widget_TabWidget$getRightStripDrawable(), 0, this);
    }

    public void setStripEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStripEnabled", $$robo$$android_widget_TabWidget$setStripEnabled(boolean ), 0, this, bl);
    }

    public boolean isStripEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStripEnabled", $$robo$$android_widget_TabWidget$isStripEnabled(), 0, this);
    }

    @Override
    public void childDrawableStateChanged(View view) {
        InvokeDynamicSupport.bootstrap("childDrawableStateChanged", $$robo$$android_widget_TabWidget$childDrawableStateChanged(android.view.View ), 0, this, view);
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_TabWidget$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setCurrentTab(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentTab", $$robo$$android_widget_TabWidget$setCurrentTab(int ), 0, this, n);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_TabWidget$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_TabWidget$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    public void focusCurrentTab(int n) {
        InvokeDynamicSupport.bootstrap("focusCurrentTab", $$robo$$android_widget_TabWidget$focusCurrentTab(int ), 0, this, n);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TabWidget$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TabWidget$addView(android.view.View ), 0, this, view);
    }

    @Override
    public void removeAllViews() {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_TabWidget$removeAllViews(), 0, this);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_TabWidget$onResolvePointerIcon(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    void setTabSelectionListener(OnTabSelectionChanged onTabSelectionChanged) {
        InvokeDynamicSupport.bootstrap("setTabSelectionListener", $$robo$$android_widget_TabWidget$setTabSelectionListener(android.widget.TabWidget$OnTabSelectionChanged ), 0, this, onTabSelectionChanged);
    }

    @Override
    public void onFocusChange(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("onFocusChange", $$robo$$android_widget_TabWidget$onFocusChange(android.view.View boolean ), 0, this, view, bl);
    }

    public /* synthetic */ TabWidget() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabWidget)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface OnTabSelectionChanged
    extends InstrumentedInterface {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    private class TabClickListener
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTabIndex;
        /* synthetic */ TabWidget this$0;

        private void $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(TabWidget tabWidget, int tabIndex) {
            this.mTabIndex = tabIndex;
        }

        private final void $$robo$$android_widget_TabWidget_TabClickListener$onClick(View v) {
            this.this$0.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }

        private /* synthetic */ void $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(TabWidget x0, int x1, 1 x2) {
        }

        private void __constructor__(TabWidget tabWidget, int n) {
            this.$$robo$$android_widget_TabWidget_TabClickListener$__constructor__(tabWidget, n);
        }

        private TabClickListener(TabWidget tabWidget, int n) {
            this.this$0 = tabWidget;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(android.widget.TabWidget int ), 0, this, tabWidget, n);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TabWidget_TabClickListener$onClick(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(TabWidget tabWidget, int n, 1 var3_3) {
            this.$$robo$$android_widget_TabWidget_TabClickListener$__constructor__(tabWidget, n, var3_3);
        }

        public /* synthetic */ TabClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

