/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.TimePickerClockDelegate;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextInputTimePickerView
extends RelativeLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int HOURS = 0;
    public static int MINUTES = 1;
    public static int AMPM = 2;
    private static int AM = 0;
    private static int PM = 1;
    private EditText mHourEditText;
    private EditText mMinuteEditText;
    private TextView mInputSeparatorView;
    private Spinner mAmPmSpinner;
    private TextView mErrorLabel;
    private TextView mHourLabel;
    private TextView mMinuteLabel;
    private boolean mIs24Hour;
    private boolean mHourFormatStartsAtZero;
    private OnValueTypedListener mListener;
    private boolean mErrorShowing;

    private void $$robo$$android_widget_TextInputTimePickerView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_TextInputTimePickerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TextInputTimePickerView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
    }

    private void $$robo$$android_widget_TextInputTimePickerView$__constructor__(Context context, AttributeSet attrs, int defStyle, int defStyleRes) {
        TextInputTimePickerView.inflate(context, 0x1090101, this);
        this.mHourEditText = (EditText)this.findViewById(16908966);
        this.mMinuteEditText = (EditText)this.findViewById(16908967);
        this.mInputSeparatorView = (TextView)this.findViewById(16908969);
        this.mErrorLabel = (TextView)this.findViewById(16908994);
        this.mHourLabel = (TextView)this.findViewById(16908995);
        this.mMinuteLabel = (TextView)this.findViewById(16908996);
        this.mHourEditText.addTextChangedListener(new TextWatcher(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextInputTimePickerView this$0;

            private void $$robo$$android_widget_TextInputTimePickerView_1$__constructor__(TextInputTimePickerView this$0) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_1$beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_1$onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_1$afterTextChanged(Editable editable) {
                this.this$0.parseAndSetHourInternal(editable.toString());
            }

            private void __constructor__(TextInputTimePickerView textInputTimePickerView) {
                this.$$robo$$android_widget_TextInputTimePickerView_1$__constructor__(textInputTimePickerView);
            }
            {
                this.this$0 = textInputTimePickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView_1$__constructor__(android.widget.TextInputTimePickerView ), 0, this, textInputTimePickerView);
            }

            @Override
            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_widget_TextInputTimePickerView_1$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_TextInputTimePickerView_1$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
            }

            @Override
            public void afterTextChanged(Editable editable) {
                InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_widget_TextInputTimePickerView_1$afterTextChanged(android.text.Editable ), 0, this, editable);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mMinuteEditText.addTextChangedListener(new TextWatcher(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextInputTimePickerView this$0;

            private void $$robo$$android_widget_TextInputTimePickerView_2$__constructor__(TextInputTimePickerView this$0) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_2$beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_2$onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_2$afterTextChanged(Editable editable) {
                this.this$0.parseAndSetMinuteInternal(editable.toString());
            }

            private void __constructor__(TextInputTimePickerView textInputTimePickerView) {
                this.$$robo$$android_widget_TextInputTimePickerView_2$__constructor__(textInputTimePickerView);
            }
            {
                this.this$0 = textInputTimePickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView_2$__constructor__(android.widget.TextInputTimePickerView ), 0, this, textInputTimePickerView);
            }

            @Override
            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$android_widget_TextInputTimePickerView_2$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$android_widget_TextInputTimePickerView_2$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
            }

            @Override
            public void afterTextChanged(Editable editable) {
                InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$android_widget_TextInputTimePickerView_2$afterTextChanged(android.text.Editable ), 0, this, editable);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mAmPmSpinner = (Spinner)this.findViewById(16908709);
        String[] amPmStrings = TimePicker.getAmPmStrings(context);
        ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(context, 0x1090009);
        adapter.add(TimePickerClockDelegate.obtainVerbatim(amPmStrings[0]));
        adapter.add(TimePickerClockDelegate.obtainVerbatim(amPmStrings[1]));
        this.mAmPmSpinner.setAdapter(adapter);
        this.mAmPmSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextInputTimePickerView this$0;

            private void $$robo$$android_widget_TextInputTimePickerView_3$__constructor__(TextInputTimePickerView this$0) {
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_3$onItemSelected(AdapterView<?> adapterView, View view, int position, long id2) {
                if (position == 0) {
                    this.this$0.mListener.onValueChanged(2, 0);
                } else {
                    this.this$0.mListener.onValueChanged(2, 1);
                }
            }

            private final void $$robo$$android_widget_TextInputTimePickerView_3$onNothingSelected(AdapterView<?> adapterView) {
            }

            private void __constructor__(TextInputTimePickerView textInputTimePickerView) {
                this.$$robo$$android_widget_TextInputTimePickerView_3$__constructor__(textInputTimePickerView);
            }
            {
                this.this$0 = textInputTimePickerView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView_3$__constructor__(android.widget.TextInputTimePickerView ), 0, this, textInputTimePickerView);
            }

            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                InvokeDynamicSupport.bootstrap("onItemSelected", $$robo$$android_widget_TextInputTimePickerView_3$onItemSelected(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {
                InvokeDynamicSupport.bootstrap("onNothingSelected", $$robo$$android_widget_TextInputTimePickerView_3$onNothingSelected(android.widget.AdapterView<?> ), 0, this, adapterView);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_widget_TextInputTimePickerView$setListener(OnValueTypedListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_widget_TextInputTimePickerView$setHourFormat(int maxCharLength) {
        this.mHourEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
        this.mMinuteEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxCharLength)});
    }

    private final boolean $$robo$$android_widget_TextInputTimePickerView$validateInput() {
        boolean inputValid = this.parseAndSetHourInternal(((Object)this.mHourEditText.getText()).toString()) && this.parseAndSetMinuteInternal(((Object)this.mMinuteEditText.getText()).toString());
        this.setError(!inputValid);
        return inputValid;
    }

    private final void $$robo$$android_widget_TextInputTimePickerView$updateSeparator(String separatorText) {
        this.mInputSeparatorView.setText(separatorText);
    }

    private final void $$robo$$android_widget_TextInputTimePickerView$setError(boolean enabled) {
        this.mErrorShowing = enabled;
        this.mErrorLabel.setVisibility(enabled ? 0 : 4);
        this.mHourLabel.setVisibility(enabled ? 4 : 0);
        this.mMinuteLabel.setVisibility(enabled ? 4 : 0);
    }

    private final void $$robo$$android_widget_TextInputTimePickerView$updateTextInputValues(int localizedHour, int minute, int amOrPm, boolean is24Hour, boolean hourFormatStartsAtZero) {
        String format = "%d";
        this.mIs24Hour = is24Hour;
        this.mHourFormatStartsAtZero = hourFormatStartsAtZero;
        this.mAmPmSpinner.setVisibility(is24Hour ? 4 : 0);
        if (amOrPm == 0) {
            this.mAmPmSpinner.setSelection(0);
        } else {
            this.mAmPmSpinner.setSelection(1);
        }
        this.mHourEditText.setText(String.format("%d", localizedHour));
        this.mMinuteEditText.setText(String.format("%d", minute));
        if (this.mErrorShowing) {
            this.validateInput();
        }
    }

    private final boolean $$robo$$android_widget_TextInputTimePickerView$parseAndSetHourInternal(String input) {
        try {
            int hour = Integer.parseInt(input);
            if (!this.isValidLocalizedHour(hour)) {
                int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
                int maxHour = this.mIs24Hour ? 23 : 11 + minHour;
                this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(MathUtils.constrain(hour, minHour, maxHour)));
                return false;
            }
            this.mListener.onValueChanged(0, this.getHourOfDayFromLocalizedHour(hour));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_widget_TextInputTimePickerView$parseAndSetMinuteInternal(String input) {
        try {
            int minutes = Integer.parseInt(input);
            if (minutes < 0 || minutes > 59) {
                this.mListener.onValueChanged(1, MathUtils.constrain(minutes, 0, 59));
                return false;
            }
            this.mListener.onValueChanged(1, minutes);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private final boolean $$robo$$android_widget_TextInputTimePickerView$isValidLocalizedHour(int localizedHour) {
        int minHour = this.mHourFormatStartsAtZero ? 0 : 1;
        int maxHour = (this.mIs24Hour ? 23 : 11) + minHour;
        return localizedHour >= minHour && localizedHour <= maxHour;
    }

    private final int $$robo$$android_widget_TextInputTimePickerView$getHourOfDayFromLocalizedHour(int localizedHour) {
        int hourOfDay = localizedHour;
        if (this.mIs24Hour) {
            if (!this.mHourFormatStartsAtZero && localizedHour == 24) {
                hourOfDay = 0;
            }
        } else {
            if (!this.mHourFormatStartsAtZero && localizedHour == 12) {
                hourOfDay = 0;
            }
            if (this.mAmPmSpinner.getSelectedItemPosition() == 1) {
                hourOfDay += 12;
            }
        }
        return hourOfDay;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TextInputTimePickerView$__constructor__(context);
    }

    public TextInputTimePickerView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TextInputTimePickerView$__constructor__(context, attributeSet);
    }

    public TextInputTimePickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TextInputTimePickerView$__constructor__(context, attributeSet, n);
    }

    public TextInputTimePickerView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TextInputTimePickerView$__constructor__(context, attributeSet, n, n2);
    }

    public TextInputTimePickerView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextInputTimePickerView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    void setListener(OnValueTypedListener onValueTypedListener) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$android_widget_TextInputTimePickerView$setListener(android.widget.TextInputTimePickerView$OnValueTypedListener ), 0, this, onValueTypedListener);
    }

    void setHourFormat(int n) {
        InvokeDynamicSupport.bootstrap("setHourFormat", $$robo$$android_widget_TextInputTimePickerView$setHourFormat(int ), 0, this, n);
    }

    boolean validateInput() {
        return (boolean)InvokeDynamicSupport.bootstrap("validateInput", $$robo$$android_widget_TextInputTimePickerView$validateInput(), 0, this);
    }

    void updateSeparator(String string2) {
        InvokeDynamicSupport.bootstrap("updateSeparator", $$robo$$android_widget_TextInputTimePickerView$updateSeparator(java.lang.String ), 0, this, string2);
    }

    private void setError(boolean bl) {
        InvokeDynamicSupport.bootstrap("setError", $$robo$$android_widget_TextInputTimePickerView$setError(boolean ), 0, this, bl);
    }

    void updateTextInputValues(int n, int n2, int n3, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("updateTextInputValues", $$robo$$android_widget_TextInputTimePickerView$updateTextInputValues(int int int boolean boolean ), 0, this, n, n2, n3, bl, bl2);
    }

    private boolean parseAndSetHourInternal(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAndSetHourInternal", $$robo$$android_widget_TextInputTimePickerView$parseAndSetHourInternal(java.lang.String ), 0, this, string2);
    }

    private boolean parseAndSetMinuteInternal(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseAndSetMinuteInternal", $$robo$$android_widget_TextInputTimePickerView$parseAndSetMinuteInternal(java.lang.String ), 0, this, string2);
    }

    private boolean isValidLocalizedHour(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidLocalizedHour", $$robo$$android_widget_TextInputTimePickerView$isValidLocalizedHour(int ), 0, this, n);
    }

    private int getHourOfDayFromLocalizedHour(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHourOfDayFromLocalizedHour", $$robo$$android_widget_TextInputTimePickerView$getHourOfDayFromLocalizedHour(int ), 0, this, n);
    }

    public /* synthetic */ TextInputTimePickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextInputTimePickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface OnValueTypedListener
    extends InstrumentedInterface {
        public void onValueChanged(int var1, int var2);
    }
}

