/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NightDisplayController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NightDisplayController";
    private static boolean DEBUG = false;
    public static int AUTO_MODE_DISABLED = 0;
    public static int AUTO_MODE_CUSTOM = 1;
    public static int AUTO_MODE_TWILIGHT = 2;
    private Context mContext;
    private int mUserId;
    private ContentObserver mContentObserver;
    private Callback mCallback;

    private void $$robo$$com_android_internal_app_NightDisplayController$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_app_NightDisplayController$__constructor__(Context context, int userId) {
        this.mContext = context.getApplicationContext();
        this.mUserId = userId;
        this.mContentObserver = new ShadowedObject(this, new Handler(Looper.getMainLooper())){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ NightDisplayController this$0;

            private void $$robo$$com_android_internal_app_NightDisplayController_1$__constructor__(NightDisplayController this$0, Handler handler) {
            }

            private final void $$robo$$com_android_internal_app_NightDisplayController_1$onChange(boolean selfChange, Uri uri) {
                String setting;
                super.onChange(selfChange, uri);
                String string2 = setting = uri == null ? null : uri.getLastPathSegment();
                if (setting != null) {
                    this.this$0.onSettingChanged(setting);
                }
            }

            private void __constructor__(NightDisplayController nightDisplayController, Handler handler) {
                this.$$robo$$com_android_internal_app_NightDisplayController_1$__constructor__(nightDisplayController, handler);
            }
            {
                this.this$0 = nightDisplayController;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_NightDisplayController_1$__constructor__(com.android.internal.app.NightDisplayController android.os.Handler ), 0, this, nightDisplayController, handler);
            }

            @Override
            public void onChange(boolean bl, Uri uri) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_app_NightDisplayController_1$onChange(boolean android.net.Uri ), 0, this, bl, uri);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$isActivated() {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_activated", 0, this.mUserId) == 1;
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$setActivated(boolean activated) {
        if (this.isActivated() != activated) {
            Settings.Secure.putLongForUser(this.mContext.getContentResolver(), "night_display_last_activated_time", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), this.mUserId);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_activated", activated ? 1 : 0, this.mUserId);
    }

    private final Calendar $$robo$$com_android_internal_app_NightDisplayController$getLastActivatedTime() {
        ContentResolver cr = this.mContext.getContentResolver();
        long lastActivatedTimeMillis = Settings.Secure.getLongForUser(cr, "night_display_last_activated_time", -1L, this.mUserId);
        if (lastActivatedTimeMillis < 0L) {
            return null;
        }
        Calendar lastActivatedTime = Calendar.getInstance();
        lastActivatedTime.setTimeInMillis(lastActivatedTimeMillis);
        return lastActivatedTime;
    }

    private final int $$robo$$com_android_internal_app_NightDisplayController$getAutoMode() {
        int autoMode = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", -1, this.mUserId);
        if (autoMode == -1) {
            autoMode = this.mContext.getResources().getInteger(17694762);
        }
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            Slog.e("NightDisplayController", "Invalid autoMode: " + autoMode);
            autoMode = 0;
        }
        return autoMode;
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$setAutoMode(int autoMode) {
        if (autoMode != 0 && autoMode != 1 && autoMode != 2) {
            throw new IllegalArgumentException("Invalid autoMode: " + autoMode);
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_auto_mode", autoMode, this.mUserId);
    }

    private final LocalTime $$robo$$com_android_internal_app_NightDisplayController$getCustomStartTime() {
        int startTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", -1, this.mUserId);
        if (startTimeValue == -1) {
            startTimeValue = this.mContext.getResources().getInteger(17694764);
        }
        return LocalTime.valueOf(startTimeValue);
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$setCustomStartTime(LocalTime startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_start_time", startTime.toMillis(), this.mUserId);
    }

    private final LocalTime $$robo$$com_android_internal_app_NightDisplayController$getCustomEndTime() {
        int endTimeValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", -1, this.mUserId);
        if (endTimeValue == -1) {
            endTimeValue = this.mContext.getResources().getInteger(17694763);
        }
        return LocalTime.valueOf(endTimeValue);
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$setCustomEndTime(LocalTime endTime) {
        if (endTime == null) {
            throw new IllegalArgumentException("endTime cannot be null");
        }
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_custom_end_time", endTime.toMillis(), this.mUserId);
    }

    private final int $$robo$$com_android_internal_app_NightDisplayController$getColorTemperature() {
        int colorTemperature = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", -1, this.mUserId);
        if (colorTemperature == -1) {
            colorTemperature = this.getDefaultColorTemperature();
        }
        int minimumTemperature = this.getMinimumColorTemperature();
        int maximumTemperature = this.getMaximumColorTemperature();
        if (colorTemperature < minimumTemperature) {
            colorTemperature = minimumTemperature;
        } else if (colorTemperature > maximumTemperature) {
            colorTemperature = maximumTemperature;
        }
        return colorTemperature;
    }

    private final boolean $$robo$$com_android_internal_app_NightDisplayController$setColorTemperature(int colorTemperature) {
        return Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "night_display_color_temperature", colorTemperature, this.mUserId);
    }

    private final int $$robo$$com_android_internal_app_NightDisplayController$getMinimumColorTemperature() {
        return this.mContext.getResources().getInteger(17694821);
    }

    private final int $$robo$$com_android_internal_app_NightDisplayController$getMaximumColorTemperature() {
        return this.mContext.getResources().getInteger(17694820);
    }

    private final int $$robo$$com_android_internal_app_NightDisplayController$getDefaultColorTemperature() {
        return this.mContext.getResources().getInteger(17694819);
    }

    private final void $$robo$$com_android_internal_app_NightDisplayController$onSettingChanged(String setting) {
        if (this.mCallback != null) {
            switch (setting) {
                case "night_display_activated": {
                    this.mCallback.onActivated(this.isActivated());
                    break;
                }
                case "night_display_auto_mode": {
                    this.mCallback.onAutoModeChanged(this.getAutoMode());
                    break;
                }
                case "night_display_custom_start_time": {
                    this.mCallback.onCustomStartTimeChanged(this.getCustomStartTime());
                    break;
                }
                case "night_display_custom_end_time": {
                    this.mCallback.onCustomEndTimeChanged(this.getCustomEndTime());
                    break;
                }
                case "night_display_color_temperature": {
                    this.mCallback.onColorTemperatureChanged(this.getColorTemperature());
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_app_NightDisplayController$setListener(Callback callback) {
        Callback oldCallback = this.mCallback;
        if (oldCallback != callback) {
            this.mCallback = callback;
            if (callback == null) {
                this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
            } else if (oldCallback == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_activated"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_auto_mode"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_start_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_custom_end_time"), false, this.mContentObserver, this.mUserId);
                cr.registerContentObserver(Settings.Secure.getUriFor("night_display_color_temperature"), false, this.mContentObserver, this.mUserId);
            }
        }
    }

    private static final boolean $$robo$$com_android_internal_app_NightDisplayController$isAvailable(Context context) {
        return context.getResources().getBoolean(17956976);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_app_NightDisplayController$__constructor__(context);
    }

    public NightDisplayController(Context context) {
        this(context, ActivityManager.getCurrentUser());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_NightDisplayController$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$com_android_internal_app_NightDisplayController$__constructor__(context, n);
    }

    public NightDisplayController(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_NightDisplayController$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    public boolean isActivated() {
        return (boolean)InvokeDynamicSupport.bootstrap("isActivated", $$robo$$com_android_internal_app_NightDisplayController$isActivated(), 0, this);
    }

    public boolean setActivated(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setActivated", $$robo$$com_android_internal_app_NightDisplayController$setActivated(boolean ), 0, this, bl);
    }

    public Calendar getLastActivatedTime() {
        return InvokeDynamicSupport.bootstrap("getLastActivatedTime", $$robo$$com_android_internal_app_NightDisplayController$getLastActivatedTime(), 0, this);
    }

    public int getAutoMode() {
        return (int)InvokeDynamicSupport.bootstrap("getAutoMode", $$robo$$com_android_internal_app_NightDisplayController$getAutoMode(), 0, this);
    }

    public boolean setAutoMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAutoMode", $$robo$$com_android_internal_app_NightDisplayController$setAutoMode(int ), 0, this, n);
    }

    public LocalTime getCustomStartTime() {
        return InvokeDynamicSupport.bootstrap("getCustomStartTime", $$robo$$com_android_internal_app_NightDisplayController$getCustomStartTime(), 0, this);
    }

    public boolean setCustomStartTime(LocalTime localTime) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCustomStartTime", $$robo$$com_android_internal_app_NightDisplayController$setCustomStartTime(com.android.internal.app.NightDisplayController$LocalTime ), 0, this, localTime);
    }

    public LocalTime getCustomEndTime() {
        return InvokeDynamicSupport.bootstrap("getCustomEndTime", $$robo$$com_android_internal_app_NightDisplayController$getCustomEndTime(), 0, this);
    }

    public boolean setCustomEndTime(LocalTime localTime) {
        return (boolean)InvokeDynamicSupport.bootstrap("setCustomEndTime", $$robo$$com_android_internal_app_NightDisplayController$setCustomEndTime(com.android.internal.app.NightDisplayController$LocalTime ), 0, this, localTime);
    }

    public int getColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getColorTemperature", $$robo$$com_android_internal_app_NightDisplayController$getColorTemperature(), 0, this);
    }

    public boolean setColorTemperature(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setColorTemperature", $$robo$$com_android_internal_app_NightDisplayController$setColorTemperature(int ), 0, this, n);
    }

    public int getMinimumColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getMinimumColorTemperature", $$robo$$com_android_internal_app_NightDisplayController$getMinimumColorTemperature(), 0, this);
    }

    public int getMaximumColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getMaximumColorTemperature", $$robo$$com_android_internal_app_NightDisplayController$getMaximumColorTemperature(), 0, this);
    }

    public int getDefaultColorTemperature() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultColorTemperature", $$robo$$com_android_internal_app_NightDisplayController$getDefaultColorTemperature(), 0, this);
    }

    private void onSettingChanged(String string2) {
        InvokeDynamicSupport.bootstrap("onSettingChanged", $$robo$$com_android_internal_app_NightDisplayController$onSettingChanged(java.lang.String ), 0, this, string2);
    }

    public void setListener(Callback callback) {
        InvokeDynamicSupport.bootstrap("setListener", $$robo$$com_android_internal_app_NightDisplayController$setListener(com.android.internal.app.NightDisplayController$Callback ), 0, this, callback);
    }

    public static boolean isAvailable(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$com_android_internal_app_NightDisplayController$isAvailable(android.content.Context ), 0, (Context)context);
    }

    public /* synthetic */ NightDisplayController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NightDisplayController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface Callback
    extends InstrumentedInterface {
        default public void onActivated(boolean activated) {
        }

        default public void onAutoModeChanged(int autoMode) {
        }

        default public void onCustomStartTimeChanged(LocalTime startTime) {
        }

        default public void onCustomEndTimeChanged(LocalTime endTime) {
        }

        default public void onColorTemperatureChanged(int colorTemperature) {
        }
    }

    public static class LocalTime
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int hourOfDay;
        public int minute;

        private void $$robo$$com_android_internal_app_NightDisplayController_LocalTime$__constructor__(int hourOfDay, int minute) {
            if (hourOfDay < 0 || hourOfDay > 23) {
                throw new IllegalArgumentException("Invalid hourOfDay: " + hourOfDay);
            }
            if (minute < 0 || minute > 59) {
                throw new IllegalArgumentException("Invalid minute: " + minute);
            }
            this.hourOfDay = hourOfDay;
            this.minute = minute;
        }

        private final Calendar $$robo$$com_android_internal_app_NightDisplayController_LocalTime$getDateTimeBefore(Calendar time) {
            Calendar c = Calendar.getInstance();
            c.set(1, time.get(1));
            c.set(6, time.get(6));
            c.set(11, this.hourOfDay);
            c.set(12, this.minute);
            c.set(13, 0);
            c.set(14, 0);
            if (c.after(time)) {
                c.add(5, -1);
            }
            return c;
        }

        private final Calendar $$robo$$com_android_internal_app_NightDisplayController_LocalTime$getDateTimeAfter(Calendar time) {
            Calendar c = Calendar.getInstance();
            c.set(1, time.get(1));
            c.set(6, time.get(6));
            c.set(11, this.hourOfDay);
            c.set(12, this.minute);
            c.set(13, 0);
            c.set(14, 0);
            if (c.before(time)) {
                c.add(5, 1);
            }
            return c;
        }

        private static final LocalTime $$robo$$com_android_internal_app_NightDisplayController_LocalTime$valueOf(int millis) {
            int hourOfDay = millis / 3600000 % 24;
            int minutes = millis / 60000 % 60;
            return new LocalTime(hourOfDay, minutes);
        }

        private final int $$robo$$com_android_internal_app_NightDisplayController_LocalTime$toMillis() {
            return this.hourOfDay * 3600000 + this.minute * 60000;
        }

        private final String $$robo$$com_android_internal_app_NightDisplayController_LocalTime$toString() {
            return String.format(Locale.US, "%02d:%02d", this.hourOfDay, this.minute);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_app_NightDisplayController_LocalTime$__constructor__(n, n2);
        }

        public LocalTime(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$__constructor__(int int ), 0, this, n, n2);
        }

        public Calendar getDateTimeBefore(Calendar calendar) {
            return InvokeDynamicSupport.bootstrap("getDateTimeBefore", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$getDateTimeBefore(java.util.Calendar ), 0, this, calendar);
        }

        public Calendar getDateTimeAfter(Calendar calendar) {
            return InvokeDynamicSupport.bootstrap("getDateTimeAfter", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$getDateTimeAfter(java.util.Calendar ), 0, this, calendar);
        }

        private static LocalTime valueOf(int n) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$valueOf(int ), 0, (int)n);
        }

        private int toMillis() {
            return (int)InvokeDynamicSupport.bootstrap("toMillis", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$toMillis(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_NightDisplayController_LocalTime$toString(), 0, this);
        }

        public /* synthetic */ LocalTime() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalTime)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface AutoMode {
    }
}

