/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.UserHandle;
import android.util.TimeUtils;
import com.android.internal.app.procstats.ProcessState;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DumpUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String[] STATE_NAMES;
    public static String[] ADJ_SCREEN_NAMES_CSV;
    public static String[] ADJ_MEM_NAMES_CSV;
    public static String[] STATE_NAMES_CSV;
    static String[] ADJ_SCREEN_TAGS;
    static String[] ADJ_MEM_TAGS;
    static String[] STATE_TAGS;
    static String CSV_SEP = "\t";

    private void $$robo$$com_android_internal_app_procstats_DumpUtils$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printScreenLabel(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                pw.print("     ");
                break;
            }
            case 0: {
                pw.print("SOff/");
                break;
            }
            case 4: {
                pw.print("SOn /");
                break;
            }
            default: {
                pw.print("????/");
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printScreenLabelCsv(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                break;
            }
            case 0: {
                pw.print(ADJ_SCREEN_NAMES_CSV[0]);
                break;
            }
            case 4: {
                pw.print(ADJ_SCREEN_NAMES_CSV[1]);
                break;
            }
            default: {
                pw.print("???");
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printMemLabel(PrintWriter pw, int offset, char sep) {
        switch (offset) {
            case -1: {
                pw.print("    ");
                if (sep == '\u0000') break;
                pw.print(' ');
                break;
            }
            case 0: {
                pw.print("Norm");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 1: {
                pw.print("Mod ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 2: {
                pw.print("Low ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 3: {
                pw.print("Crit");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            default: {
                pw.print("????");
                if (sep == '\u0000') break;
                pw.print(sep);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printMemLabelCsv(PrintWriter pw, int offset) {
        if (offset >= 0) {
            if (offset <= 3) {
                pw.print(ADJ_MEM_NAMES_CSV[offset]);
            } else {
                pw.print("???");
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printPercent(PrintWriter pw, double fraction2) {
        if ((fraction2 *= 100.0) < 1.0) {
            pw.print(String.format("%.2f", fraction2));
        } else if (fraction2 < 10.0) {
            pw.print(String.format("%.1f", fraction2));
        } else {
            pw.print(String.format("%.0f", fraction2));
        }
        pw.print("%");
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printProcStateTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 56);
        state = DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 14);
        DumpUtils.printArrayEntry(pw, STATE_TAGS, state, 1);
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printAdjTag(PrintWriter pw, int state) {
        state = DumpUtils.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 4);
        DumpUtils.printArrayEntry(pw, ADJ_MEM_TAGS, state, 1);
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printProcStateTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printProcStateTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$printAdjTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        DumpUtils.printAdjTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    private static final long $$robo$$com_android_internal_app_procstats_DumpUtils$dumpSingleTime(PrintWriter pw, String prefix, long[] durations, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                String running = "";
                if (curState == state) {
                    time += now - curStartTime;
                    if (pw != null) {
                        running = " (running)";
                    }
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$dumpAdjTimesCheckin(PrintWriter pw, String sep, long[] durations, int curState, long curStartTime, long now) {
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                if (curState == state) {
                    time += now - curStartTime;
                }
                if (time == 0L) continue;
                DumpUtils.printAdjTagAndValue(pw, state, time);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$dumpStateHeadersCsv(PrintWriter pw, String sep, int[] screenStates, int[] memStates, int[] procStates) {
        int NS = screenStates != null ? screenStates.length : 1;
        int NM = memStates != null ? memStates.length : 1;
        int NP = procStates != null ? procStates.length : 1;
        for (int is = 0; is < NS; ++is) {
            for (int im = 0; im < NM; ++im) {
                for (int ip = 0; ip < NP; ++ip) {
                    pw.print(sep);
                    boolean printed = false;
                    if (screenStates != null && screenStates.length > 1) {
                        DumpUtils.printScreenLabelCsv(pw, screenStates[is]);
                        printed = true;
                    }
                    if (memStates != null && memStates.length > 1) {
                        if (printed) {
                            pw.print("-");
                        }
                        DumpUtils.printMemLabelCsv(pw, memStates[im]);
                        printed = true;
                    }
                    if (procStates == null || procStates.length <= 1) continue;
                    if (printed) {
                        pw.print("-");
                    }
                    pw.print(STATE_NAMES_CSV[procStates[ip]]);
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$dumpProcessSummaryLocked(PrintWriter pw, String prefix, ArrayList<ProcessState> procs, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime) {
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            proc.dumpSummary(pw, prefix, screenStates, memStates, procStates, now, totalTime);
        }
    }

    private static final void $$robo$$com_android_internal_app_procstats_DumpUtils$dumpProcessListCsv(PrintWriter pw, ArrayList<ProcessState> procs, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        pw.print("process");
        pw.print("\t");
        pw.print("uid");
        pw.print("\t");
        pw.print("vers");
        DumpUtils.dumpStateHeadersCsv(pw, "\t", (int[])(sepScreenStates ? screenStates : null), (int[])(sepMemStates ? memStates : null), (int[])(sepProcStates ? procStates : null));
        pw.println();
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(proc.getName());
            pw.print("\t");
            UserHandle.formatUid(pw, proc.getUid());
            pw.print("\t");
            pw.print(proc.getVersion());
            proc.dumpCsv(pw, sepScreenStates, screenStates, sepMemStates, memStates, sepProcStates, procStates, now);
            pw.println();
        }
    }

    private static final int $$robo$$com_android_internal_app_procstats_DumpUtils$printArrayEntry(PrintWriter pw, String[] array2, int value, int mod) {
        int index = value / mod;
        if (index >= 0 && index < array2.length) {
            pw.print(array2[index]);
        } else {
            pw.print('?');
        }
        return value - index * mod;
    }

    private static final String $$robo$$com_android_internal_app_procstats_DumpUtils$collapseString(String pkgName, String itemName) {
        if (itemName.startsWith(pkgName)) {
            int PKGLEN;
            int ITEMLEN = itemName.length();
            if (ITEMLEN == (PKGLEN = pkgName.length())) {
                return "";
            }
            if (ITEMLEN >= PKGLEN && itemName.charAt(PKGLEN) == '.') {
                return itemName.substring(PKGLEN);
            }
        }
        return itemName;
    }

    static void __staticInitializer__() {
        STATE_NAMES = new String[]{"Persist", "Top    ", "ImpFg  ", "ImpBg  ", "Backup ", "HeavyWt", "Service", "ServRst", "Receivr", "Home   ", "LastAct", "CchAct ", "CchCAct", "CchEmty"};
        ADJ_SCREEN_NAMES_CSV = new String[]{"off", "on"};
        ADJ_MEM_NAMES_CSV = new String[]{"norm", "mod", "low", "crit"};
        STATE_NAMES_CSV = new String[]{"pers", "top", "impfg", "impbg", "backup", "heavy", "service", "service-rs", "receiver", "home", "lastact", "cch-activity", "cch-aclient", "cch-empty"};
        ADJ_SCREEN_TAGS = new String[]{"0", "1"};
        ADJ_MEM_TAGS = new String[]{"n", "m", "l", "c"};
        STATE_TAGS = new String[]{"p", "t", "f", "b", "u", "w", "s", "x", "r", "h", "l", "a", "c", "e"};
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_procstats_DumpUtils$__constructor__();
    }

    private DumpUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_DumpUtils$__constructor__(), 0, this);
    }

    public static void printScreenLabel(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printScreenLabel", $$robo$$com_android_internal_app_procstats_DumpUtils$printScreenLabel(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printScreenLabelCsv(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printScreenLabelCsv", $$robo$$com_android_internal_app_procstats_DumpUtils$printScreenLabelCsv(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printMemLabel(PrintWriter printWriter, int n, char c) {
        InvokeDynamicSupport.bootstrapStatic("printMemLabel", $$robo$$com_android_internal_app_procstats_DumpUtils$printMemLabel(java.io.PrintWriter int char ), 0, (PrintWriter)printWriter, (int)n, (char)c);
    }

    public static void printMemLabelCsv(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printMemLabelCsv", $$robo$$com_android_internal_app_procstats_DumpUtils$printMemLabelCsv(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printPercent(PrintWriter printWriter, double d) {
        InvokeDynamicSupport.bootstrapStatic("printPercent", $$robo$$com_android_internal_app_procstats_DumpUtils$printPercent(java.io.PrintWriter double ), 0, (PrintWriter)printWriter, (double)d);
    }

    public static void printProcStateTag(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printProcStateTag", $$robo$$com_android_internal_app_procstats_DumpUtils$printProcStateTag(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printAdjTag(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printAdjTag", $$robo$$com_android_internal_app_procstats_DumpUtils$printAdjTag(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printProcStateTagAndValue(PrintWriter printWriter, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("printProcStateTagAndValue", $$robo$$com_android_internal_app_procstats_DumpUtils$printProcStateTagAndValue(java.io.PrintWriter int long ), 0, (PrintWriter)printWriter, (int)n, (long)l);
    }

    public static void printAdjTagAndValue(PrintWriter printWriter, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("printAdjTagAndValue", $$robo$$com_android_internal_app_procstats_DumpUtils$printAdjTagAndValue(java.io.PrintWriter int long ), 0, (PrintWriter)printWriter, (int)n, (long)l);
    }

    public static long dumpSingleTime(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("dumpSingleTime", $$robo$$com_android_internal_app_procstats_DumpUtils$dumpSingleTime(java.io.PrintWriter java.lang.String long[] int long long ), 0, (PrintWriter)printWriter, (String)string2, (long[])lArray, (int)n, (long)l, (long)l2);
    }

    public static void dumpAdjTimesCheckin(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("dumpAdjTimesCheckin", $$robo$$com_android_internal_app_procstats_DumpUtils$dumpAdjTimesCheckin(java.io.PrintWriter java.lang.String long[] int long long ), 0, (PrintWriter)printWriter, (String)string2, (long[])lArray, (int)n, (long)l, (long)l2);
    }

    private static void dumpStateHeadersCsv(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3) {
        InvokeDynamicSupport.bootstrapStatic("dumpStateHeadersCsv", $$robo$$com_android_internal_app_procstats_DumpUtils$dumpStateHeadersCsv(java.io.PrintWriter java.lang.String int[] int[] int[] ), 0, (PrintWriter)printWriter, (String)string2, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    public static void dumpProcessSummaryLocked(PrintWriter printWriter, String string2, ArrayList<ProcessState> arrayList, int[] nArray, int[] nArray2, int[] nArray3, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessSummaryLocked", $$robo$$com_android_internal_app_procstats_DumpUtils$dumpProcessSummaryLocked(java.io.PrintWriter java.lang.String java.util.ArrayList<com.android.internal.app.procstats.ProcessState> int[] int[] int[] long long ), 0, (PrintWriter)printWriter, (String)string2, arrayList, (int[])nArray, (int[])nArray2, (int[])nArray3, (long)l, (long)l2);
    }

    public static void dumpProcessListCsv(PrintWriter printWriter, ArrayList<ProcessState> arrayList, boolean bl, int[] nArray, boolean bl2, int[] nArray2, boolean bl3, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessListCsv", $$robo$$com_android_internal_app_procstats_DumpUtils$dumpProcessListCsv(java.io.PrintWriter java.util.ArrayList<com.android.internal.app.procstats.ProcessState> boolean int[] boolean int[] boolean int[] long ), 0, (PrintWriter)printWriter, arrayList, (boolean)bl, (int[])nArray, (boolean)bl2, (int[])nArray2, (boolean)bl3, (int[])nArray3, (long)l);
    }

    public static int printArrayEntry(PrintWriter printWriter, String[] stringArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("printArrayEntry", $$robo$$com_android_internal_app_procstats_DumpUtils$printArrayEntry(java.io.PrintWriter java.lang.String[] int int ), 0, (PrintWriter)printWriter, (String[])stringArray, (int)n, (int)n2);
    }

    public static String collapseString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("collapseString", $$robo$$com_android_internal_app_procstats_DumpUtils$collapseString(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    static {
        RobolectricInternals.classInitializing(DumpUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DumpUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

