/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.os.Debug;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.ProcessMap;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ServiceState;
import com.android.internal.app.procstats.SparseMappingTable;
import com.android.internal.app.procstats.SysMemUsageTable;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ProcessStats
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG = "ProcessStats";
    static boolean DEBUG = false;
    static boolean DEBUG_PARCEL = false;
    public static String SERVICE_NAME = "procstats";
    public static long COMMIT_PERIOD;
    public static long COMMIT_UPTIME_PERIOD;
    public static int STATE_NOTHING = -1;
    public static int STATE_PERSISTENT = 0;
    public static int STATE_TOP = 1;
    public static int STATE_IMPORTANT_FOREGROUND = 2;
    public static int STATE_IMPORTANT_BACKGROUND = 3;
    public static int STATE_BACKUP = 4;
    public static int STATE_HEAVY_WEIGHT = 5;
    public static int STATE_SERVICE = 6;
    public static int STATE_SERVICE_RESTARTING = 7;
    public static int STATE_RECEIVER = 8;
    public static int STATE_HOME = 9;
    public static int STATE_LAST_ACTIVITY = 10;
    public static int STATE_CACHED_ACTIVITY = 11;
    public static int STATE_CACHED_ACTIVITY_CLIENT = 12;
    public static int STATE_CACHED_EMPTY = 13;
    public static int STATE_COUNT = 14;
    public static int PSS_SAMPLE_COUNT = 0;
    public static int PSS_MINIMUM = 1;
    public static int PSS_AVERAGE = 2;
    public static int PSS_MAXIMUM = 3;
    public static int PSS_USS_MINIMUM = 4;
    public static int PSS_USS_AVERAGE = 5;
    public static int PSS_USS_MAXIMUM = 6;
    public static int PSS_COUNT = 7;
    public static int SYS_MEM_USAGE_SAMPLE_COUNT = 0;
    public static int SYS_MEM_USAGE_CACHED_MINIMUM = 1;
    public static int SYS_MEM_USAGE_CACHED_AVERAGE = 2;
    public static int SYS_MEM_USAGE_CACHED_MAXIMUM = 3;
    public static int SYS_MEM_USAGE_FREE_MINIMUM = 4;
    public static int SYS_MEM_USAGE_FREE_AVERAGE = 5;
    public static int SYS_MEM_USAGE_FREE_MAXIMUM = 6;
    public static int SYS_MEM_USAGE_ZRAM_MINIMUM = 7;
    public static int SYS_MEM_USAGE_ZRAM_AVERAGE = 8;
    public static int SYS_MEM_USAGE_ZRAM_MAXIMUM = 9;
    public static int SYS_MEM_USAGE_KERNEL_MINIMUM = 10;
    public static int SYS_MEM_USAGE_KERNEL_AVERAGE = 11;
    public static int SYS_MEM_USAGE_KERNEL_MAXIMUM = 12;
    public static int SYS_MEM_USAGE_NATIVE_MINIMUM = 13;
    public static int SYS_MEM_USAGE_NATIVE_AVERAGE = 14;
    public static int SYS_MEM_USAGE_NATIVE_MAXIMUM = 15;
    public static int SYS_MEM_USAGE_COUNT = 16;
    public static int ADJ_NOTHING = -1;
    public static int ADJ_MEM_FACTOR_NORMAL = 0;
    public static int ADJ_MEM_FACTOR_MODERATE = 1;
    public static int ADJ_MEM_FACTOR_LOW = 2;
    public static int ADJ_MEM_FACTOR_CRITICAL = 3;
    public static int ADJ_MEM_FACTOR_COUNT = 4;
    public static int ADJ_SCREEN_MOD = 4;
    public static int ADJ_SCREEN_OFF = 0;
    public static int ADJ_SCREEN_ON = 4;
    public static int ADJ_COUNT = 8;
    public static int FLAG_COMPLETE = 1;
    public static int FLAG_SHUTDOWN = 2;
    public static int FLAG_SYSPROPS = 4;
    public static int[] ALL_MEM_ADJ;
    public static int[] ALL_SCREEN_ADJ;
    public static int[] NON_CACHED_PROC_STATES;
    public static int[] BACKGROUND_PROC_STATES;
    public static int[] ALL_PROC_STATES;
    private static int PARCEL_VERSION = 21;
    private static int MAGIC = 1347638356;
    public String mReadError;
    public String mTimePeriodStartClockStr;
    public int mFlags;
    public ProcessMap<SparseArray<PackageState>> mPackages;
    public ProcessMap<ProcessState> mProcesses;
    public long[] mMemFactorDurations;
    public int mMemFactor;
    public long mStartTime;
    public long mTimePeriodStartClock;
    public long mTimePeriodStartRealtime;
    public long mTimePeriodEndRealtime;
    public long mTimePeriodStartUptime;
    public long mTimePeriodEndUptime;
    String mRuntime;
    boolean mRunning;
    boolean mHasSwappedOutPss;
    public SparseMappingTable mTableData;
    public long[] mSysMemUsageArgs;
    public SysMemUsageTable mSysMemUsage;
    ArrayMap<String, Integer> mCommonStringToIndex;
    ArrayList<String> mIndexToCommonString;
    private static Pattern sPageTypeRegex;
    private ArrayList<Integer> mPageTypeZones;
    private ArrayList<String> mPageTypeLabels;
    private ArrayList<int[]> mPageTypeSizes;
    public static Parcelable.Creator<ProcessStats> CREATOR;
    static int[] BAD_TABLE;

    private void $$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(boolean running) {
        this.mPackages = new ProcessMap();
        this.mProcesses = new ProcessMap();
        this.mMemFactorDurations = new long[8];
        this.mMemFactor = -1;
        this.mTableData = new SparseMappingTable();
        this.mSysMemUsageArgs = new long[16];
        this.mSysMemUsage = new SysMemUsageTable(this.mTableData);
        this.mPageTypeZones = new ArrayList();
        this.mPageTypeLabels = new ArrayList();
        this.mPageTypeSizes = new ArrayList();
        this.mRunning = running;
        this.reset();
        if (running) {
            Debug.MemoryInfo info = new Debug.MemoryInfo();
            Debug.getMemoryInfo(Process.myPid(), info);
            this.mHasSwappedOutPss = info.hasSwappedOutPss();
        }
    }

    private void $$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(Parcel in) {
        this.mPackages = new ProcessMap();
        this.mProcesses = new ProcessMap();
        this.mMemFactorDurations = new long[8];
        this.mMemFactor = -1;
        this.mTableData = new SparseMappingTable();
        this.mSysMemUsageArgs = new long[16];
        this.mSysMemUsage = new SysMemUsageTable(this.mTableData);
        this.mPageTypeZones = new ArrayList();
        this.mPageTypeLabels = new ArrayList();
        this.mPageTypeSizes = new ArrayList();
        this.reset();
        this.readFromParcel(in);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$add(ProcessStats other) {
        int uid;
        int iu;
        SparseArray<Object> uids;
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = other.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            uids = pkgMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                SparseArray versions = (SparseArray)uids.valueAt(iu);
                for (int iv = 0; iv < versions.size(); ++iv) {
                    int vers = versions.keyAt(iv);
                    PackageState otherState = (PackageState)versions.valueAt(iv);
                    int NPROCS = otherState.mProcesses.size();
                    int NSRVS = otherState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState otherProc = otherState.mProcesses.valueAt(iproc);
                        if (otherProc.getCommonProcess() == otherProc) continue;
                        ProcessState thisProc = this.getProcessStateLocked(pkgName, uid, vers, otherProc.getName());
                        if (thisProc.getCommonProcess() == thisProc) {
                            thisProc.setMultiPackage(true);
                            long now = SystemClock.uptimeMillis();
                            PackageState pkgState = this.getPackageStateLocked(pkgName, uid, vers);
                            thisProc = thisProc.clone(now);
                            pkgState.mProcesses.put(thisProc.getName(), thisProc);
                        }
                        thisProc.add(otherProc);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState otherSvc = otherState.mServices.valueAt(isvc);
                        ServiceState thisSvc = this.getServiceStateLocked(pkgName, uid, vers, otherSvc.getProcessName(), otherSvc.getName());
                        thisSvc.add(otherSvc);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = other.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            uids = procMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                ProcessState otherProc = (ProcessState)uids.valueAt(iu);
                String name = otherProc.getName();
                String pkg = otherProc.getPackage();
                int vers = otherProc.getVersion();
                ProcessState thisProc = this.mProcesses.get(name, uid);
                if (thisProc == null) {
                    thisProc = new ProcessState(this, pkg, uid, vers, name);
                    this.mProcesses.put(name, uid, thisProc);
                    PackageState thisState = this.getPackageStateLocked(pkg, uid, vers);
                    if (!thisState.mProcesses.containsKey(name)) {
                        thisState.mProcesses.put(name, thisProc);
                    }
                }
                thisProc.add(otherProc);
            }
        }
        for (int i = 0; i < 8; ++i) {
            int n = i;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + other.mMemFactorDurations[i];
        }
        this.mSysMemUsage.mergeStats(other.mSysMemUsage);
        if (other.mTimePeriodStartClock < this.mTimePeriodStartClock) {
            this.mTimePeriodStartClock = other.mTimePeriodStartClock;
            this.mTimePeriodStartClockStr = other.mTimePeriodStartClockStr;
        }
        this.mTimePeriodEndRealtime += other.mTimePeriodEndRealtime - other.mTimePeriodStartRealtime;
        this.mTimePeriodEndUptime += other.mTimePeriodEndUptime - other.mTimePeriodStartUptime;
        this.mHasSwappedOutPss |= other.mHasSwappedOutPss;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$addSysMemUsage(long cachedMem, long freeMem, long zramMem, long kernelMem, long nativeMem) {
        if (this.mMemFactor != -1) {
            int state = this.mMemFactor * 14;
            this.mSysMemUsageArgs[0] = 1L;
            for (int i = 0; i < 3; ++i) {
                this.mSysMemUsageArgs[1 + i] = cachedMem;
                this.mSysMemUsageArgs[4 + i] = freeMem;
                this.mSysMemUsageArgs[7 + i] = zramMem;
                this.mSysMemUsageArgs[10 + i] = kernelMem;
                this.mSysMemUsageArgs[13 + i] = nativeMem;
            }
            this.mSysMemUsage.mergeStats(state, this.mSysMemUsageArgs, 0);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$computeTotalMemoryUse(TotalMemoryUseCollection data, long now) {
        int i;
        data.totalTime = 0L;
        for (i = 0; i < 14; ++i) {
            data.processStateWeight[i] = 0.0;
            data.processStatePss[i] = 0L;
            data.processStateTime[i] = 0L;
            data.processStateSamples[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            data.sysMemUsage[i] = 0L;
        }
        data.sysMemCachedWeight = 0.0;
        data.sysMemFreeWeight = 0.0;
        data.sysMemZRamWeight = 0.0;
        data.sysMemKernelWeight = 0.0;
        data.sysMemNativeWeight = 0.0;
        data.sysMemSamples = 0;
        long[] totalMemUsage = this.mSysMemUsage.getTotalMemUsage();
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                int tmpIndex;
                long[] tmpLongs;
                int memBucket = data.screenStates[is] + data.memStates[im];
                int stateBucket = memBucket * 14;
                long memTime = this.mMemFactorDurations[memBucket];
                if (this.mMemFactor == memBucket) {
                    memTime += now - this.mStartTime;
                }
                data.totalTime += memTime;
                int sysKey = this.mSysMemUsage.getKey((byte)stateBucket);
                long[] longs = totalMemUsage;
                int idx = 0;
                if (sysKey != -1 && (tmpLongs = this.mSysMemUsage.getArrayForKey(sysKey))[(tmpIndex = SparseMappingTable.getIndexFromKey(sysKey)) + 0] >= 3L) {
                    SysMemUsageTable.mergeSysMemUsage(data.sysMemUsage, 0, longs, idx);
                    longs = tmpLongs;
                    idx = tmpIndex;
                }
                data.sysMemCachedWeight += (double)longs[idx + 2] * (double)memTime;
                data.sysMemFreeWeight += (double)longs[idx + 5] * (double)memTime;
                data.sysMemZRamWeight += (double)longs[idx + 8] * (double)memTime;
                data.sysMemKernelWeight += (double)longs[idx + 11] * (double)memTime;
                data.sysMemNativeWeight += (double)longs[idx + 14] * (double)memTime;
                data.sysMemSamples = (int)((long)data.sysMemSamples + longs[idx + 0]);
            }
        }
        data.hasSwappedOutPss = this.mHasSwappedOutPss;
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int iproc = 0; iproc < procMap.size(); ++iproc) {
            SparseArray<ProcessState> uids = procMap.valueAt(iproc);
            for (int iu = 0; iu < uids.size(); ++iu) {
                ProcessState proc = uids.valueAt(iu);
                proc.aggregatePss(data, now);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$reset() {
        this.resetCommon();
        this.mPackages.getMap().clear();
        this.mProcesses.getMap().clear();
        this.mMemFactor = -1;
        this.mStartTime = 0L;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$resetSafely() {
        int iu;
        int ip;
        this.resetCommon();
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip2 = procMap.size() - 1; ip2 >= 0; --ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            for (int iu2 = uids.size() - 1; iu2 >= 0; --iu2) {
                uids.valueAt((int)iu2).tmpNumInUse = 0;
            }
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (ip = pkgMap.size() - 1; ip >= 0; --ip) {
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = vpkgs.size() - 1; iv >= 0; --iv) {
                    PackageState pkgState = vpkgs.valueAt(iv);
                    for (int iproc = pkgState.mProcesses.size() - 1; iproc >= 0; --iproc) {
                        ProcessState ps = pkgState.mProcesses.valueAt(iproc);
                        if (ps.isInUse()) {
                            ps.resetSafely(now);
                            ++ps.getCommonProcess().tmpNumInUse;
                            ps.getCommonProcess().tmpFoundSubProc = ps;
                            continue;
                        }
                        pkgState.mProcesses.valueAt(iproc).makeDead();
                        pkgState.mProcesses.removeAt(iproc);
                    }
                    for (int isvc = pkgState.mServices.size() - 1; isvc >= 0; --isvc) {
                        ServiceState ss = pkgState.mServices.valueAt(isvc);
                        if (ss.isInUse()) {
                            ss.resetSafely(now);
                            continue;
                        }
                        pkgState.mServices.removeAt(isvc);
                    }
                    if (pkgState.mProcesses.size() > 0 || pkgState.mServices.size() > 0) continue;
                    vpkgs.removeAt(iv);
                }
                if (vpkgs.size() > 0) continue;
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            pkgMap.removeAt(ip);
        }
        for (ip = procMap.size() - 1; ip >= 0; --ip) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                ProcessState ps = uids.valueAt(iu);
                if (ps.isInUse() || ps.tmpNumInUse > 0) {
                    if (!ps.isActive() && ps.isMultiPackage() && ps.tmpNumInUse == 1) {
                        ps = ps.tmpFoundSubProc;
                        ps.makeStandalone();
                        uids.setValueAt(iu, ps);
                        continue;
                    }
                    ps.resetSafely(now);
                    continue;
                }
                ps.makeDead();
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            procMap.removeAt(ip);
        }
        this.mStartTime = now;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$resetCommon() {
        this.mTimePeriodStartClock = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = this.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
        this.mTimePeriodStartUptime = this.mTimePeriodEndUptime = SystemClock.uptimeMillis();
        this.mTableData.reset();
        Arrays.fill(this.mMemFactorDurations, 0L);
        this.mSysMemUsage.resetTable();
        this.mStartTime = 0L;
        this.mReadError = null;
        this.mFlags = 0;
        this.evaluateSystemProperties(true);
        this.updateFragmentation();
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessStats$evaluateSystemProperties(boolean update) {
        boolean changed = false;
        String runtime = SystemProperties.get("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
        if (!Objects.equals(runtime, this.mRuntime)) {
            changed = true;
            if (update) {
                this.mRuntime = runtime;
            }
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$buildTimePeriodStartClockStr() {
        this.mTimePeriodStartClockStr = DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.mTimePeriodStartClock).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$updateFragmentation() {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader("/proc/pagetypeinfo"));
            Matcher matcher = sPageTypeRegex.matcher("");
            this.mPageTypeZones.clear();
            this.mPageTypeLabels.clear();
            this.mPageTypeSizes.clear();
            while ((line = reader.readLine()) != null) {
                Integer zone;
                matcher.reset(line);
                if (!matcher.matches() || (zone = Integer.valueOf(matcher.group(1), 10)) == null) continue;
                this.mPageTypeZones.add(zone);
                this.mPageTypeLabels.add(matcher.group(2));
                this.mPageTypeSizes.add(ProcessStats.splitAndParseNumbers(matcher.group(3)));
            }
        }
        catch (IOException ex) {
            this.mPageTypeZones.clear();
            this.mPageTypeLabels.clear();
            this.mPageTypeSizes.clear();
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final int[] $$robo$$com_android_internal_app_procstats_ProcessStats$splitAndParseNumbers(String s) {
        boolean digit = false;
        int count = 0;
        int N = s.length();
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (digit) continue;
                digit = true;
                ++count;
                continue;
            }
            digit = false;
        }
        int[] result = new int[count];
        int p = 0;
        int val = 0;
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (!digit) {
                    digit = true;
                    val = c - 48;
                    continue;
                }
                val *= 10;
                val += c - 48;
                continue;
            }
            if (!digit) continue;
            digit = false;
            result[p++] = val;
        }
        if (count > 0) {
            result[count - 1] = val;
        }
        return result;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$writeCompactedLongArray(Parcel out, long[] array2, int num) {
        for (int i = 0; i < num; ++i) {
            long val = array2[i];
            if (val < 0L) {
                Slog.w("ProcessStats", "Time val negative: " + val);
                val = 0L;
            }
            if (val <= Integer.MAX_VALUE) {
                out.writeInt((int)val);
                continue;
            }
            int top = ~((int)(val >> 32 & Integer.MAX_VALUE));
            int bottom = (int)(val & 0xFFFFFFFFL);
            out.writeInt(top);
            out.writeInt(bottom);
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$readCompactedLongArray(Parcel in, int version, long[] array2, int num) {
        int i;
        if (version <= 10) {
            in.readLongArray(array2);
            return;
        }
        int alen = array2.length;
        if (num > alen) {
            throw new RuntimeException("bad array lengths: got " + num + " array is " + alen);
        }
        for (i = 0; i < num; ++i) {
            int val = in.readInt();
            if (val >= 0) {
                array2[i] = val;
                continue;
            }
            int bottom = in.readInt();
            array2[i] = (long)(~val) << 32 | (long)bottom;
        }
        while (i < alen) {
            array2[i] = 0L;
            ++i;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$writeCommonString(Parcel out, String name) {
        Integer index = this.mCommonStringToIndex.get(name);
        if (index != null) {
            out.writeInt(index);
            return;
        }
        index = this.mCommonStringToIndex.size();
        this.mCommonStringToIndex.put(name, index);
        out.writeInt(~index.intValue());
        out.writeString(name);
    }

    private final String $$robo$$com_android_internal_app_procstats_ProcessStats$readCommonString(Parcel in, int version) {
        if (version <= 9) {
            return in.readString();
        }
        int index = in.readInt();
        if (index >= 0) {
            return this.mIndexToCommonString.get(index);
        }
        index ^= 0xFFFFFFFF;
        String name = in.readString();
        while (this.mIndexToCommonString.size() <= index) {
            this.mIndexToCommonString.add(null);
        }
        this.mIndexToCommonString.set(index, name);
        return name;
    }

    private final int $$robo$$com_android_internal_app_procstats_ProcessStats$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$writeToParcel(Parcel out, int flags) {
        this.writeToParcel(out, SystemClock.uptimeMillis(), flags);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$writeToParcel(Parcel out, long now, int flags) {
        int isvc;
        int NSRVS;
        int iproc;
        int NPROCS;
        PackageState pkgState;
        int iv;
        int NVERS;
        SparseArray<PackageState> vpkgs;
        int iu;
        int NUID;
        int ip;
        out.writeInt(1347638356);
        out.writeInt(21);
        out.writeInt(14);
        out.writeInt(8);
        out.writeInt(7);
        out.writeInt(16);
        out.writeInt(4096);
        this.mCommonStringToIndex = new ArrayMap(this.mProcesses.size());
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        int NPROC = procMap.size();
        for (int ip2 = 0; ip2 < NPROC; ++ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            int NUID2 = uids.size();
            for (int iu2 = 0; iu2 < NUID2; ++iu2) {
                uids.valueAt(iu2).commitStateTime(now);
            }
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        int NPKG = pkgMap.size();
        for (ip = 0; ip < NPKG; ++ip) {
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            NUID = uids.size();
            for (iu = 0; iu < NUID; ++iu) {
                vpkgs = uids.valueAt(iu);
                NVERS = vpkgs.size();
                for (iv = 0; iv < NVERS; ++iv) {
                    pkgState = vpkgs.valueAt(iv);
                    NPROCS = pkgState.mProcesses.size();
                    for (iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.getCommonProcess() == proc) continue;
                        proc.commitStateTime(now);
                    }
                    NSRVS = pkgState.mServices.size();
                    for (isvc = 0; isvc < NSRVS; ++isvc) {
                        pkgState.mServices.valueAt(isvc).commitStateTime(now);
                    }
                }
            }
        }
        out.writeLong(this.mTimePeriodStartClock);
        out.writeLong(this.mTimePeriodStartRealtime);
        out.writeLong(this.mTimePeriodEndRealtime);
        out.writeLong(this.mTimePeriodStartUptime);
        out.writeLong(this.mTimePeriodEndUptime);
        out.writeString(this.mRuntime);
        out.writeInt(this.mHasSwappedOutPss ? 1 : 0);
        out.writeInt(this.mFlags);
        this.mTableData.writeToParcel(out);
        if (this.mMemFactor != -1) {
            int n = this.mMemFactor;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + (now - this.mStartTime);
            this.mStartTime = now;
        }
        this.writeCompactedLongArray(out, this.mMemFactorDurations, this.mMemFactorDurations.length);
        this.mSysMemUsage.writeToParcel(out);
        out.writeInt(NPROC);
        for (ip = 0; ip < NPROC; ++ip) {
            this.writeCommonString(out, procMap.keyAt(ip));
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                ProcessState proc = uids.valueAt(iu);
                this.writeCommonString(out, proc.getPackage());
                out.writeInt(proc.getVersion());
                proc.writeToParcel(out, now);
            }
        }
        out.writeInt(NPKG);
        for (ip = 0; ip < NPKG; ++ip) {
            this.writeCommonString(out, pkgMap.keyAt(ip));
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                vpkgs = uids.valueAt(iu);
                NVERS = vpkgs.size();
                out.writeInt(NVERS);
                for (iv = 0; iv < NVERS; ++iv) {
                    out.writeInt(vpkgs.keyAt(iv));
                    pkgState = vpkgs.valueAt(iv);
                    NPROCS = pkgState.mProcesses.size();
                    out.writeInt(NPROCS);
                    for (iproc = 0; iproc < NPROCS; ++iproc) {
                        this.writeCommonString(out, pkgState.mProcesses.keyAt(iproc));
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.getCommonProcess() == proc) {
                            out.writeInt(0);
                            continue;
                        }
                        out.writeInt(1);
                        proc.writeToParcel(out, now);
                    }
                    NSRVS = pkgState.mServices.size();
                    out.writeInt(NSRVS);
                    for (isvc = 0; isvc < NSRVS; ++isvc) {
                        out.writeString(pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        this.writeCommonString(out, svc.getProcessName());
                        svc.writeToParcel(out, now);
                    }
                }
            }
        }
        int NPAGETYPES = this.mPageTypeLabels.size();
        out.writeInt(NPAGETYPES);
        for (int i = 0; i < NPAGETYPES; ++i) {
            out.writeInt(this.mPageTypeZones.get(i));
            out.writeString(this.mPageTypeLabels.get(i));
            out.writeIntArray(this.mPageTypeSizes.get(i));
        }
        this.mCommonStringToIndex = null;
    }

    private final boolean $$robo$$com_android_internal_app_procstats_ProcessStats$readCheckedInt(Parcel in, int val, String what) {
        int got = in.readInt();
        if (got != val) {
            this.mReadError = "bad " + what + ": " + got;
            return false;
        }
        return true;
    }

    private static final byte[] $$robo$$com_android_internal_app_procstats_ProcessStats$readFully(InputStream stream, int[] outLen) throws IOException {
        int pos = 0;
        int initialAvail = stream.available();
        byte[] data = new byte[initialAvail > 0 ? initialAvail + 1 : 16384];
        while (true) {
            int amt;
            if ((amt = stream.read(data, pos, data.length - pos)) < 0) {
                outLen[0] = pos;
                return data;
            }
            if ((pos += amt) < data.length) continue;
            byte[] newData = new byte[pos + 16384];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$read(InputStream stream) {
        try {
            int[] len = new int[1];
            byte[] raw2 = ProcessStats.readFully(stream, len);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, len[0]);
            in.setDataPosition(0);
            stream.close();
            this.readFromParcel(in);
        }
        catch (IOException e) {
            this.mReadError = "caught exception: " + e;
        }
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$readFromParcel(Parcel in) {
        boolean hadData;
        boolean bl = hadData = this.mPackages.getMap().size() > 0 || this.mProcesses.getMap().size() > 0;
        if (hadData) {
            this.resetSafely();
        }
        if (!this.readCheckedInt(in, 1347638356, "magic number")) {
            return;
        }
        int version = in.readInt();
        if (version != 21) {
            this.mReadError = "bad version: " + version;
            return;
        }
        if (!this.readCheckedInt(in, 14, "state count")) {
            return;
        }
        if (!this.readCheckedInt(in, 8, "adj count")) {
            return;
        }
        if (!this.readCheckedInt(in, 7, "pss count")) {
            return;
        }
        if (!this.readCheckedInt(in, 16, "sys mem usage count")) {
            return;
        }
        if (!this.readCheckedInt(in, 4096, "longs size")) {
            return;
        }
        this.mIndexToCommonString = new ArrayList();
        this.mTimePeriodStartClock = in.readLong();
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = in.readLong();
        this.mTimePeriodEndRealtime = in.readLong();
        this.mTimePeriodStartUptime = in.readLong();
        this.mTimePeriodEndUptime = in.readLong();
        this.mRuntime = in.readString();
        this.mHasSwappedOutPss = in.readInt() != 0;
        this.mFlags = in.readInt();
        this.mTableData.readFromParcel(in);
        this.readCompactedLongArray(in, version, this.mMemFactorDurations, this.mMemFactorDurations.length);
        if (!this.mSysMemUsage.readFromParcel(in)) {
            return;
        }
        int NPROC = in.readInt();
        if (NPROC < 0) {
            this.mReadError = "bad process count: " + NPROC;
            return;
        }
        while (NPROC > 0) {
            --NPROC;
            String procName = this.readCommonString(in, version);
            if (procName == null) {
                this.mReadError = "bad process name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                ProcessState proc;
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                String pkgName = this.readCommonString(in, version);
                if (pkgName == null) {
                    this.mReadError = "bad process package name";
                    return;
                }
                int vers = in.readInt();
                ProcessState processState = proc = hadData ? this.mProcesses.get(procName, uid) : null;
                if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(this, pkgName, uid, vers, procName)).readFromParcel(in, true)) {
                    return;
                }
                this.mProcesses.put(procName, uid, proc);
            }
        }
        int NPKG = in.readInt();
        if (NPKG < 0) {
            this.mReadError = "bad package count: " + NPKG;
            return;
        }
        while (NPKG > 0) {
            --NPKG;
            String pkgName = this.readCommonString(in, version);
            if (pkgName == null) {
                this.mReadError = "bad package name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                int NVERS = in.readInt();
                if (NVERS < 0) {
                    this.mReadError = "bad versions count: " + NVERS;
                    return;
                }
                while (NVERS > 0) {
                    int NPROCS;
                    --NVERS;
                    int vers = in.readInt();
                    PackageState pkgState = new PackageState(pkgName, uid);
                    SparseArray<PackageState> vpkg = this.mPackages.get(pkgName, uid);
                    if (vpkg == null) {
                        vpkg = new SparseArray();
                        this.mPackages.put(pkgName, uid, vpkg);
                    }
                    vpkg.put(vers, pkgState);
                    if (NPROCS < 0) {
                        this.mReadError = "bad package process count: " + NPROCS;
                        return;
                    }
                    for (NPROCS = in.readInt(); NPROCS > 0; --NPROCS) {
                        String procName = this.readCommonString(in, version);
                        if (procName == null) {
                            this.mReadError = "bad package process name";
                            return;
                        }
                        int hasProc = in.readInt();
                        ProcessState commonProc = this.mProcesses.get(procName, uid);
                        if (commonProc == null) {
                            this.mReadError = "no common proc: " + procName;
                            return;
                        }
                        if (hasProc != 0) {
                            ProcessState proc;
                            ProcessState processState = proc = hadData ? pkgState.mProcesses.get(procName) : null;
                            if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(commonProc, pkgName, uid, vers, procName, 0L)).readFromParcel(in, true)) {
                                return;
                            }
                            pkgState.mProcesses.put(procName, proc);
                            continue;
                        }
                        pkgState.mProcesses.put(procName, commonProc);
                    }
                    int NSRVS = in.readInt();
                    if (NSRVS < 0) {
                        this.mReadError = "bad package service count: " + NSRVS;
                        return;
                    }
                    while (NSRVS > 0) {
                        ServiceState serv;
                        --NSRVS;
                        String serviceName = in.readString();
                        if (serviceName == null) {
                            this.mReadError = "bad package service name";
                            return;
                        }
                        String processName = version > 9 ? this.readCommonString(in, version) : null;
                        ServiceState serviceState = serv = hadData ? pkgState.mServices.get(serviceName) : null;
                        if (serv == null) {
                            serv = new ServiceState(this, pkgName, serviceName, processName, null);
                        }
                        if (!serv.readFromParcel(in)) {
                            return;
                        }
                        pkgState.mServices.put(serviceName, serv);
                    }
                }
            }
        }
        int NPAGETYPES = in.readInt();
        this.mPageTypeZones.clear();
        this.mPageTypeZones.ensureCapacity(NPAGETYPES);
        this.mPageTypeLabels.clear();
        this.mPageTypeLabels.ensureCapacity(NPAGETYPES);
        this.mPageTypeSizes.clear();
        this.mPageTypeSizes.ensureCapacity(NPAGETYPES);
        for (int i = 0; i < NPAGETYPES; ++i) {
            this.mPageTypeZones.add(in.readInt());
            this.mPageTypeLabels.add(in.readString());
            this.mPageTypeSizes.add(in.createIntArray());
        }
        this.mIndexToCommonString = null;
    }

    private final PackageState $$robo$$com_android_internal_app_procstats_ProcessStats$getPackageStateLocked(String packageName, int uid, int vers) {
        PackageState as;
        SparseArray<PackageState> vpkg = this.mPackages.get(packageName, uid);
        if (vpkg == null) {
            vpkg = new SparseArray();
            this.mPackages.put(packageName, uid, vpkg);
        }
        if ((as = vpkg.get(vers)) != null) {
            return as;
        }
        as = new PackageState(packageName, uid);
        vpkg.put(vers, as);
        return as;
    }

    private final ProcessState $$robo$$com_android_internal_app_procstats_ProcessStats$getProcessStateLocked(String packageName, int uid, int vers, String processName) {
        PackageState pkgState = this.getPackageStateLocked(packageName, uid, vers);
        ProcessState ps = pkgState.mProcesses.get(processName);
        if (ps != null) {
            return ps;
        }
        ProcessState commonProc = this.mProcesses.get(processName, uid);
        if (commonProc == null) {
            commonProc = new ProcessState(this, packageName, uid, vers, processName);
            this.mProcesses.put(processName, uid, commonProc);
        }
        if (!commonProc.isMultiPackage()) {
            if (packageName.equals(commonProc.getPackage()) && vers == commonProc.getVersion()) {
                ps = commonProc;
            } else {
                commonProc.setMultiPackage(true);
                long now = SystemClock.uptimeMillis();
                PackageState commonPkgState = this.getPackageStateLocked(commonProc.getPackage(), uid, commonProc.getVersion());
                if (commonPkgState != null) {
                    ProcessState cloned = commonProc.clone(now);
                    commonPkgState.mProcesses.put(commonProc.getName(), cloned);
                    for (int i = commonPkgState.mServices.size() - 1; i >= 0; --i) {
                        ServiceState ss = commonPkgState.mServices.valueAt(i);
                        if (ss.getProcess() != commonProc) continue;
                        ss.setProcess(cloned);
                    }
                } else {
                    Slog.w("ProcessStats", "Cloning proc state: no package state " + commonProc.getPackage() + "/" + uid + " for proc " + commonProc.getName());
                }
                ps = new ProcessState(commonProc, packageName, uid, vers, processName, now);
            }
        } else {
            ps = new ProcessState(commonProc, packageName, uid, vers, processName, SystemClock.uptimeMillis());
        }
        pkgState.mProcesses.put(processName, ps);
        return ps;
    }

    private final ServiceState $$robo$$com_android_internal_app_procstats_ProcessStats$getServiceStateLocked(String packageName, int uid, int vers, String processName, String className) {
        PackageState as = this.getPackageStateLocked(packageName, uid, vers);
        ServiceState ss = as.mServices.get(className);
        if (ss != null) {
            return ss;
        }
        ProcessState ps = processName != null ? this.getProcessStateLocked(packageName, uid, vers, processName) : null;
        ss = new ServiceState(this, packageName, className, processName, ps);
        as.mServices.put(className, ss);
        return ss;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpLocked(PrintWriter pw, String reqPackage, long now, boolean dumpSummary, boolean dumpAll, boolean activeOnly) {
        long totalTime = DumpUtils.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        boolean sepNeeded = false;
        if (this.mSysMemUsage.getKeyCount() > 0) {
            pw.println("System memory usage:");
            this.mSysMemUsage.dump(pw, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ);
            sepNeeded = true;
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        boolean printedHeader = false;
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    ProcessState proc;
                    int iproc;
                    boolean pkgMatch;
                    int vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    boolean bl = pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    if (!pkgMatch) {
                        boolean procMatch = false;
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!reqPackage.equals(proc.getName())) continue;
                            procMatch = true;
                            break;
                        }
                        if (!procMatch) continue;
                    }
                    if (NPROCS > 0 || NSRVS > 0) {
                        if (!printedHeader) {
                            if (sepNeeded) {
                                pw.println();
                            }
                            pw.println("Per-Package Stats:");
                            printedHeader = true;
                            sepNeeded = true;
                        }
                        pw.print("  * ");
                        pw.print(pkgName);
                        pw.print(" / ");
                        UserHandle.formatUid(pw, uid);
                        pw.print(" / v");
                        pw.print(vers);
                        pw.println(":");
                    }
                    if (!dumpSummary || dumpAll) {
                        for (int iproc2 = 0; iproc2 < NPROCS; ++iproc2) {
                            ProcessState proc2 = pkgState.mProcesses.valueAt(iproc2);
                            if (!pkgMatch && !reqPackage.equals(proc2.getName())) continue;
                            if (activeOnly && !proc2.isInUse()) {
                                pw.print("      (Not active: ");
                                pw.print(pkgState.mProcesses.keyAt(iproc2));
                                pw.println(")");
                                continue;
                            }
                            pw.print("      Process ");
                            pw.print(pkgState.mProcesses.keyAt(iproc2));
                            if (proc2.getCommonProcess().isMultiPackage()) {
                                pw.print(" (multi, ");
                            } else {
                                pw.print(" (unique, ");
                            }
                            pw.print(proc2.getDurationsBucketCount());
                            pw.print(" entries)");
                            pw.println(":");
                            proc2.dumpProcessState(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                            proc2.dumpPss(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                            proc2.dumpInternalLocked(pw, "        ", dumpAll);
                        }
                    } else {
                        ArrayList<ProcessState> procs = new ArrayList<ProcessState>();
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!pkgMatch && !reqPackage.equals(proc.getName()) || activeOnly && !proc.isInUse()) continue;
                            procs.add(proc);
                        }
                        DumpUtils.dumpProcessSummaryLocked(pw, "      ", procs, ALL_SCREEN_ADJ, ALL_MEM_ADJ, NON_CACHED_PROC_STATES, now, totalTime);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        if (!pkgMatch && !reqPackage.equals(svc.getProcessName())) continue;
                        if (activeOnly && !svc.isInUse()) {
                            pw.print("      (Not active: ");
                            pw.print(pkgState.mServices.keyAt(isvc));
                            pw.println(")");
                            continue;
                        }
                        if (dumpAll) {
                            pw.print("      Service ");
                        } else {
                            pw.print("      * ");
                        }
                        pw.print(pkgState.mServices.keyAt(isvc));
                        pw.println(":");
                        pw.print("        Process: ");
                        pw.println(svc.getProcessName());
                        svc.dumpStats(pw, "        ", "          ", "    ", now, totalTime, dumpSummary, dumpAll);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        printedHeader = false;
        int numShownProcs = 0;
        int numTotalProcs = 0;
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ++numTotalProcs;
                ProcessState proc = uids.valueAt(iu);
                if (proc.hasAnyData() || !proc.isMultiPackage() || reqPackage != null && !reqPackage.equals(procName) && !reqPackage.equals(proc.getPackage())) continue;
                ++numShownProcs;
                if (sepNeeded) {
                    pw.println();
                }
                sepNeeded = true;
                if (!printedHeader) {
                    pw.println("Multi-Package Common Processes:");
                    printedHeader = true;
                }
                if (activeOnly && !proc.isInUse()) {
                    pw.print("      (Not active: ");
                    pw.print(procName);
                    pw.println(")");
                    continue;
                }
                pw.print("  * ");
                pw.print(procName);
                pw.print(" / ");
                UserHandle.formatUid(pw, uid);
                pw.print(" (");
                pw.print(proc.getDurationsBucketCount());
                pw.print(" entries)");
                pw.println(":");
                proc.dumpProcessState(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                proc.dumpPss(pw, "        ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                proc.dumpInternalLocked(pw, "        ", dumpAll);
            }
        }
        if (dumpAll) {
            pw.println();
            pw.print("  Total procs: ");
            pw.print(numShownProcs);
            pw.print(" shown of ");
            pw.print(numTotalProcs);
            pw.println(" total");
        }
        if (sepNeeded) {
            pw.println();
        }
        if (dumpSummary) {
            pw.println("Summary:");
            this.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
        } else {
            this.dumpTotalsLocked(pw, now);
        }
        if (dumpAll) {
            pw.println();
            pw.println("Internal state:");
            pw.print("  mRunning=");
            pw.println(this.mRunning);
        }
        this.dumpFragmentationLocked(pw);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpSummaryLocked(PrintWriter pw, String reqPackage, long now, boolean activeOnly) {
        long totalTime = DumpUtils.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        this.dumpFilteredSummaryLocked(pw, null, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, NON_CACHED_PROC_STATES, now, totalTime, reqPackage, activeOnly);
        pw.println();
        this.dumpTotalsLocked(pw, now);
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpFragmentationLocked(PrintWriter pw) {
        pw.println();
        pw.println("Available pages by page size:");
        int NPAGETYPES = this.mPageTypeLabels.size();
        for (int i = 0; i < NPAGETYPES; ++i) {
            pw.format("Zone %3d  %14s ", this.mPageTypeZones.get(i), this.mPageTypeLabels.get(i));
            int[] sizes = this.mPageTypeSizes.get(i);
            int N = sizes == null ? 0 : sizes.length;
            for (int j = 0; j < N; ++j) {
                pw.format("%6d", sizes[j]);
            }
            pw.println();
        }
    }

    private final long $$robo$$com_android_internal_app_procstats_ProcessStats$printMemoryCategory(PrintWriter pw, String prefix, String label, double memWeight, long totalTime, long curTotalMem, int samples) {
        if (memWeight != 0.0) {
            long mem = (long)(memWeight * 1024.0 / (double)totalTime);
            pw.print(prefix);
            pw.print(label);
            pw.print(": ");
            DebugUtils.printSizeValue(pw, mem);
            pw.print(" (");
            pw.print(samples);
            pw.print(" samples)");
            pw.println();
            return curTotalMem + mem;
        }
        return curTotalMem;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpTotalsLocked(PrintWriter pw, long now) {
        pw.println("Run time Stats:");
        DumpUtils.dumpSingleTime(pw, "  ", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        pw.println();
        pw.println("Memory usage:");
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        long totalPss = 0L;
        totalPss = this.printMemoryCategory(pw, "  ", "Kernel ", totalMem.sysMemKernelWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Native ", totalMem.sysMemNativeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            if (i == 7) continue;
            totalPss = this.printMemoryCategory(pw, "  ", DumpUtils.STATE_NAMES[i], totalMem.processStateWeight[i], totalMem.totalTime, totalPss, totalMem.processStateSamples[i]);
        }
        totalPss = this.printMemoryCategory(pw, "  ", "Cached ", totalMem.sysMemCachedWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Free   ", totalMem.sysMemFreeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Z-Ram  ", totalMem.sysMemZRamWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        pw.print("  TOTAL  : ");
        DebugUtils.printSizeValue(pw, totalPss);
        pw.println();
        this.printMemoryCategory(pw, "  ", DumpUtils.STATE_NAMES[7], totalMem.processStateWeight[7], totalMem.totalTime, totalPss, totalMem.processStateSamples[7]);
        pw.println();
        pw.print("          Start time: ");
        pw.print(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mTimePeriodStartClock));
        pw.println();
        pw.print("  Total elapsed time: ");
        TimeUtils.formatDuration((this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime) - this.mTimePeriodStartRealtime, pw);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(" (shutdown)");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(" (sysprops)");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(" (complete)");
            partial = false;
        }
        if (partial) {
            pw.print(" (partial)");
        }
        if (this.mHasSwappedOutPss) {
            pw.print(" (swapped-out-pss)");
        }
        pw.print(' ');
        pw.print(this.mRuntime);
        pw.println();
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpFilteredSummaryLocked(PrintWriter pw, String header, String prefix, int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, long totalTime, String reqPackage, boolean activeOnly) {
        ArrayList<ProcessState> procs = this.collectProcessesLocked(screenStates, memStates, procStates, sortProcStates, now, reqPackage, activeOnly);
        if (procs.size() > 0) {
            if (header != null) {
                pw.println();
                pw.println(header);
            }
            DumpUtils.dumpProcessSummaryLocked(pw, prefix, procs, screenStates, memStates, sortProcStates, now, totalTime);
        }
    }

    private final ArrayList<ProcessState> $$robo$$com_android_internal_app_procstats_ProcessStats$collectProcessesLocked(int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, String reqPackage, boolean activeOnly) {
        ArraySet<ProcessState> foundProcs = new ArraySet<ProcessState>();
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<SparseArray<PackageState>> procs = pkgMap.valueAt(ip);
            for (int iu = 0; iu < procs.size(); ++iu) {
                SparseArray<PackageState> vpkgs = procs.valueAt(iu);
                int NVERS = vpkgs.size();
                for (int iv = 0; iv < NVERS; ++iv) {
                    PackageState state = vpkgs.valueAt(iv);
                    int NPROCS = state.mProcesses.size();
                    boolean pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = state.mProcesses.valueAt(iproc);
                        if (!pkgMatch && !reqPackage.equals(proc.getName()) || activeOnly && !proc.isInUse()) continue;
                        foundProcs.add(proc.getCommonProcess());
                    }
                }
            }
        }
        ArrayList<ProcessState> outProcs = new ArrayList<ProcessState>(foundProcs.size());
        for (int i = 0; i < foundProcs.size(); ++i) {
            ProcessState proc = (ProcessState)foundProcs.valueAt(i);
            if (proc.computeProcessTimeLocked(screenStates, memStates, procStates, now) <= 0L) continue;
            outProcs.add(proc);
            if (procStates == sortProcStates) continue;
            proc.computeProcessTimeLocked(screenStates, memStates, sortProcStates, now);
        }
        Collections.sort(outProcs, ProcessState.COMPARATOR);
        return outProcs;
    }

    private final void $$robo$$com_android_internal_app_procstats_ProcessStats$dumpCheckinLocked(PrintWriter pw, String reqPackage) {
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        pw.println("vers,5");
        pw.print("period,");
        pw.print(this.mTimePeriodStartClockStr);
        pw.print(",");
        pw.print(this.mTimePeriodStartRealtime);
        pw.print(",");
        pw.print(this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(",shutdown");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(",sysprops");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(",complete");
            partial = false;
        }
        if (partial) {
            pw.print(",partial");
        }
        if (this.mHasSwappedOutPss) {
            pw.print(",swapped-out-pss");
        }
        pw.println();
        pw.print("config,");
        pw.println(this.mRuntime);
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            if (reqPackage != null && !reqPackage.equals(pkgName)) continue;
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    int vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        proc.dumpPackageProcCheckin(pw, pkgName, uid, vers, pkgState.mProcesses.keyAt(iproc), now);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        String serviceName = DumpUtils.collapseString(pkgName, pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        svc.dumpTimesCheckin(pw, pkgName, uid, vers, serviceName, now);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ProcessState procState = uids.valueAt(iu);
                procState.dumpProcCheckin(pw, procName, uid, now);
            }
        }
        pw.print("total");
        DumpUtils.dumpAdjTimesCheckin(pw, ",", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        pw.println();
        int sysMemUsageCount = this.mSysMemUsage.getKeyCount();
        if (sysMemUsageCount > 0) {
            pw.print("sysmemusage");
            for (int i = 0; i < sysMemUsageCount; ++i) {
                int key = this.mSysMemUsage.getKeyAt(i);
                byte type = SparseMappingTable.getIdFromKey(key);
                pw.print(",");
                DumpUtils.printProcStateTag(pw, type);
                for (int j = 0; j < 16; ++j) {
                    if (j > 1) {
                        pw.print(":");
                    }
                    pw.print(this.mSysMemUsage.getValue(key, j));
                }
            }
        }
        pw.println();
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        pw.print("weights,");
        pw.print(totalMem.totalTime);
        pw.print(",");
        pw.print(totalMem.sysMemCachedWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemFreeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemZRamWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemKernelWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemNativeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            pw.print(",");
            pw.print(totalMem.processStateWeight[i]);
            pw.print(":");
            pw.print(totalMem.processStateSamples[i]);
        }
        pw.println();
        int NPAGETYPES = this.mPageTypeLabels.size();
        for (int i = 0; i < NPAGETYPES; ++i) {
            pw.print("availablepages,");
            pw.print(this.mPageTypeLabels.get(i));
            pw.print(",");
            pw.print(this.mPageTypeZones.get(i));
            pw.print(",");
            int[] sizes = this.mPageTypeSizes.get(i);
            int N = sizes == null ? 0 : sizes.length;
            for (int j = 0; j < N; ++j) {
                if (j != 0) {
                    pw.print(",");
                }
                pw.print(sizes[j]);
            }
            pw.println();
        }
    }

    static void __staticInitializer__() {
        COMMIT_PERIOD = 10800000L;
        COMMIT_UPTIME_PERIOD = 3600000L;
        ALL_MEM_ADJ = new int[]{0, 1, 2, 3};
        ALL_SCREEN_ADJ = new int[]{0, 4};
        NON_CACHED_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        BACKGROUND_PROC_STATES = new int[]{2, 3, 4, 5, 6, 7, 8};
        ALL_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        sPageTypeRegex = Pattern.compile("^Node\\s+(\\d+),.*. type\\s+(\\w+)\\s+([\\s\\d]+?)\\s*$");
        CREATOR = new Parcelable.Creator<ProcessStats>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_app_procstats_ProcessStats_1$__constructor__() {
            }

            private final ProcessStats $$robo$$com_android_internal_app_procstats_ProcessStats_1$createFromParcel(Parcel in) {
                return new ProcessStats(in);
            }

            private final ProcessStats[] $$robo$$com_android_internal_app_procstats_ProcessStats_1$newArray(int size) {
                return new ProcessStats[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_app_procstats_ProcessStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats_1$__constructor__(), 0, this);
            }

            @Override
            public ProcessStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_app_procstats_ProcessStats_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ProcessStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_app_procstats_ProcessStats_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        BAD_TABLE = new int[0];
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(bl);
    }

    public ProcessStats(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(boolean ), 0, this, bl);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(parcel);
    }

    public ProcessStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public void add(ProcessStats processStats) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_procstats_ProcessStats$add(com.android.internal.app.procstats.ProcessStats ), 0, this, processStats);
    }

    public void addSysMemUsage(long l, long l2, long l3, long l4, long l5) {
        InvokeDynamicSupport.bootstrap("addSysMemUsage", $$robo$$com_android_internal_app_procstats_ProcessStats$addSysMemUsage(long long long long long ), 0, this, l, l2, l3, l4, l5);
    }

    public void computeTotalMemoryUse(TotalMemoryUseCollection totalMemoryUseCollection, long l) {
        InvokeDynamicSupport.bootstrap("computeTotalMemoryUse", $$robo$$com_android_internal_app_procstats_ProcessStats$computeTotalMemoryUse(com.android.internal.app.procstats.ProcessStats$TotalMemoryUseCollection long ), 0, this, totalMemoryUseCollection, l);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_app_procstats_ProcessStats$reset(), 0, this);
    }

    public void resetSafely() {
        InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_procstats_ProcessStats$resetSafely(), 0, this);
    }

    private void resetCommon() {
        InvokeDynamicSupport.bootstrap("resetCommon", $$robo$$com_android_internal_app_procstats_ProcessStats$resetCommon(), 0, this);
    }

    public boolean evaluateSystemProperties(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("evaluateSystemProperties", $$robo$$com_android_internal_app_procstats_ProcessStats$evaluateSystemProperties(boolean ), 0, this, bl);
    }

    private void buildTimePeriodStartClockStr() {
        InvokeDynamicSupport.bootstrap("buildTimePeriodStartClockStr", $$robo$$com_android_internal_app_procstats_ProcessStats$buildTimePeriodStartClockStr(), 0, this);
    }

    public void updateFragmentation() {
        InvokeDynamicSupport.bootstrap("updateFragmentation", $$robo$$com_android_internal_app_procstats_ProcessStats$updateFragmentation(), 0, this);
    }

    private static int[] splitAndParseNumbers(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("splitAndParseNumbers", $$robo$$com_android_internal_app_procstats_ProcessStats$splitAndParseNumbers(java.lang.String ), 0, (String)string2);
    }

    private void writeCompactedLongArray(Parcel parcel, long[] lArray, int n) {
        InvokeDynamicSupport.bootstrap("writeCompactedLongArray", $$robo$$com_android_internal_app_procstats_ProcessStats$writeCompactedLongArray(android.os.Parcel long[] int ), 0, this, parcel, lArray, n);
    }

    private void readCompactedLongArray(Parcel parcel, int n, long[] lArray, int n2) {
        InvokeDynamicSupport.bootstrap("readCompactedLongArray", $$robo$$com_android_internal_app_procstats_ProcessStats$readCompactedLongArray(android.os.Parcel int long[] int ), 0, this, parcel, n, lArray, n2);
    }

    private void writeCommonString(Parcel parcel, String string2) {
        InvokeDynamicSupport.bootstrap("writeCommonString", $$robo$$com_android_internal_app_procstats_ProcessStats$writeCommonString(android.os.Parcel java.lang.String ), 0, this, parcel, string2);
    }

    private String readCommonString(Parcel parcel, int n) {
        return InvokeDynamicSupport.bootstrap("readCommonString", $$robo$$com_android_internal_app_procstats_ProcessStats$readCommonString(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_app_procstats_ProcessStats$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_ProcessStats$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void writeToParcel(Parcel parcel, long l, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_procstats_ProcessStats$writeToParcel(android.os.Parcel long int ), 0, this, parcel, l, n);
    }

    private boolean readCheckedInt(Parcel parcel, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("readCheckedInt", $$robo$$com_android_internal_app_procstats_ProcessStats$readCheckedInt(android.os.Parcel int java.lang.String ), 0, this, parcel, n, string2);
    }

    static byte[] readFully(InputStream inputStream, int[] nArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_app_procstats_ProcessStats$readFully(java.io.InputStream int[] ), 0, (InputStream)inputStream, (int[])nArray);
    }

    public void read(InputStream inputStream) {
        InvokeDynamicSupport.bootstrap("read", $$robo$$com_android_internal_app_procstats_ProcessStats$read(java.io.InputStream ), 0, this, inputStream);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_procstats_ProcessStats$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    public PackageState getPackageStateLocked(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPackageStateLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$getPackageStateLocked(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public ProcessState getProcessStateLocked(String string2, int n, int n2, String string3) {
        return InvokeDynamicSupport.bootstrap("getProcessStateLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$getProcessStateLocked(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    public ServiceState getServiceStateLocked(String string2, int n, int n2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("getServiceStateLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$getServiceStateLocked(java.lang.String int int java.lang.String java.lang.String ), 0, this, string2, n, n2, string3, string4);
    }

    public void dumpLocked(PrintWriter printWriter, String string2, long l, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("dumpLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpLocked(java.io.PrintWriter java.lang.String long boolean boolean boolean ), 0, this, printWriter, string2, l, bl, bl2, bl3);
    }

    public void dumpSummaryLocked(PrintWriter printWriter, String string2, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpSummaryLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpSummaryLocked(java.io.PrintWriter java.lang.String long boolean ), 0, this, printWriter, string2, l, bl);
    }

    private void dumpFragmentationLocked(PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dumpFragmentationLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpFragmentationLocked(java.io.PrintWriter ), 0, this, printWriter);
    }

    long printMemoryCategory(PrintWriter printWriter, String string2, String string3, double d, long l, long l2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("printMemoryCategory", $$robo$$com_android_internal_app_procstats_ProcessStats$printMemoryCategory(java.io.PrintWriter java.lang.String java.lang.String double long long int ), 0, this, printWriter, string2, string3, d, l, l2, n);
    }

    void dumpTotalsLocked(PrintWriter printWriter, long l) {
        InvokeDynamicSupport.bootstrap("dumpTotalsLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpTotalsLocked(java.io.PrintWriter long ), 0, this, printWriter, l);
    }

    void dumpFilteredSummaryLocked(PrintWriter printWriter, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, long l2, String string4, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpFilteredSummaryLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpFilteredSummaryLocked(java.io.PrintWriter java.lang.String java.lang.String int[] int[] int[] int[] long long java.lang.String boolean ), 0, this, printWriter, string2, string3, nArray, nArray2, nArray3, nArray4, l, l2, string4, bl);
    }

    public ArrayList<ProcessState> collectProcessesLocked(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("collectProcessesLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$collectProcessesLocked(int[] int[] int[] int[] long java.lang.String boolean ), 0, this, nArray, nArray2, nArray3, nArray4, l, string2, bl);
    }

    public void dumpCheckinLocked(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dumpCheckinLocked", $$robo$$com_android_internal_app_procstats_ProcessStats$dumpCheckinLocked(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    static {
        RobolectricInternals.classInitializing(ProcessStats.class);
    }

    public /* synthetic */ ProcessStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TotalMemoryUseCollection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] screenStates;
        int[] memStates;
        public long totalTime;
        public long[] processStatePss;
        public double[] processStateWeight;
        public long[] processStateTime;
        public int[] processStateSamples;
        public long[] sysMemUsage;
        public double sysMemCachedWeight;
        public double sysMemFreeWeight;
        public double sysMemZRamWeight;
        public double sysMemKernelWeight;
        public double sysMemNativeWeight;
        public int sysMemSamples;
        public boolean hasSwappedOutPss;

        private void $$robo$$com_android_internal_app_procstats_ProcessStats_TotalMemoryUseCollection$__constructor__(int[] _screenStates, int[] _memStates) {
            this.processStatePss = new long[14];
            this.processStateWeight = new double[14];
            this.processStateTime = new long[14];
            this.processStateSamples = new int[14];
            this.sysMemUsage = new long[16];
            this.screenStates = _screenStates;
            this.memStates = _memStates;
        }

        private void __constructor__(int[] nArray, int[] nArray2) {
            this.$$robo$$com_android_internal_app_procstats_ProcessStats_TotalMemoryUseCollection$__constructor__(nArray, nArray2);
        }

        public TotalMemoryUseCollection(int[] nArray, int[] nArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats_TotalMemoryUseCollection$__constructor__(int[] int[] ), 0, this, nArray, nArray2);
        }

        public /* synthetic */ TotalMemoryUseCollection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TotalMemoryUseCollection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessDataCollection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] screenStates;
        int[] memStates;
        int[] procStates;
        public long totalTime;
        public long numPss;
        public long minPss;
        public long avgPss;
        public long maxPss;
        public long minUss;
        public long avgUss;
        public long maxUss;

        private void $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessDataCollection$__constructor__(int[] _screenStates, int[] _memStates, int[] _procStates) {
            this.screenStates = _screenStates;
            this.memStates = _memStates;
            this.procStates = _procStates;
        }

        private final void $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessDataCollection$print(PrintWriter pw, long overallTime, boolean full) {
            if (this.totalTime > overallTime) {
                pw.print("*");
            }
            DumpUtils.printPercent(pw, (double)this.totalTime / (double)overallTime);
            if (this.numPss > 0L) {
                pw.print(" (");
                DebugUtils.printSizeValue(pw, this.minPss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.avgPss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.maxPss * 1024L);
                pw.print("/");
                DebugUtils.printSizeValue(pw, this.minUss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.avgUss * 1024L);
                pw.print("-");
                DebugUtils.printSizeValue(pw, this.maxUss * 1024L);
                if (full) {
                    pw.print(" over ");
                    pw.print(this.numPss);
                }
                pw.print(")");
            }
        }

        private void __constructor__(int[] nArray, int[] nArray2, int[] nArray3) {
            this.$$robo$$com_android_internal_app_procstats_ProcessStats_ProcessDataCollection$__constructor__(nArray, nArray2, nArray3);
        }

        public ProcessDataCollection(int[] nArray, int[] nArray2, int[] nArray3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessDataCollection$__constructor__(int[] int[] int[] ), 0, this, nArray, nArray2, nArray3);
        }

        void print(PrintWriter printWriter, long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessDataCollection$print(java.io.PrintWriter long boolean ), 0, this, printWriter, l, bl);
        }

        public /* synthetic */ ProcessDataCollection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessDataCollection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PackageState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ArrayMap<String, ProcessState> mProcesses;
        public ArrayMap<String, ServiceState> mServices;
        public String mPackageName;
        public int mUid;

        private void $$robo$$com_android_internal_app_procstats_ProcessStats_PackageState$__constructor__(String packageName, int uid) {
            this.mProcesses = new ArrayMap();
            this.mServices = new ArrayMap();
            this.mUid = uid;
            this.mPackageName = packageName;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_app_procstats_ProcessStats_PackageState$__constructor__(string2, n);
        }

        public PackageState(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats_PackageState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ PackageState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessStateHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int appVersion;
        public ProcessState state;

        private void $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessStateHolder$__constructor__(int _appVersion) {
            this.appVersion = _appVersion;
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_app_procstats_ProcessStats_ProcessStateHolder$__constructor__(n);
        }

        public ProcessStateHolder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_procstats_ProcessStats_ProcessStateHolder$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ ProcessStateHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessStateHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

