/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.backup;

import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupTransport;
import android.app.backup.RestoreDescription;
import android.app.backup.RestoreSet;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.android.org.bouncycastle.util.encoders.Base64;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocalTransport
extends BackupTransport
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "LocalTransport";
    private static boolean DEBUG = false;
    private static String TRANSPORT_DIR_NAME = "com.android.internal.backup.LocalTransport";
    private static String TRANSPORT_DESTINATION_STRING = "Backing up to debug-only private cache";
    private static String TRANSPORT_DATA_MANAGEMENT_LABEL = "";
    private static String INCREMENTAL_DIR = "_delta";
    private static String FULL_DATA_DIR = "_full";
    private static long CURRENT_SET_TOKEN = 1L;
    private static long FULL_BACKUP_SIZE_QUOTA = 0x1900000L;
    private static long KEY_VALUE_BACKUP_SIZE_QUOTA = 0x500000L;
    private Context mContext;
    private File mDataDir;
    private File mCurrentSetDir;
    private File mCurrentSetIncrementalDir;
    private File mCurrentSetFullDir;
    private PackageInfo[] mRestorePackages;
    private int mRestorePackage;
    private int mRestoreType;
    private File mRestoreSetDir;
    private File mRestoreSetIncrementalDir;
    private File mRestoreSetFullDir;
    private String mFullTargetPackage;
    private ParcelFileDescriptor mSocket;
    private FileInputStream mSocketInputStream;
    private BufferedOutputStream mFullBackupOutputStream;
    private byte[] mFullBackupBuffer;
    private long mFullBackupSize;
    private FileInputStream mCurFullRestoreStream;
    private FileOutputStream mFullRestoreSocketStream;
    private byte[] mFullRestoreBuffer;
    static long[] POSSIBLE_SETS;

    private final void $$robo$$com_android_internal_backup_LocalTransport$makeDataDirs() {
        this.mCurrentSetDir.mkdirs();
        this.mCurrentSetFullDir.mkdir();
        this.mCurrentSetIncrementalDir.mkdir();
    }

    private void $$robo$$com_android_internal_backup_LocalTransport$__constructor__(Context context) {
        this.mDataDir = new File(Environment.getDownloadCacheDirectory(), "backup");
        this.mCurrentSetDir = new File(this.mDataDir, Long.toString(1L));
        this.mCurrentSetIncrementalDir = new File(this.mCurrentSetDir, "_delta");
        this.mCurrentSetFullDir = new File(this.mCurrentSetDir, "_full");
        this.mRestorePackages = null;
        this.mRestorePackage = -1;
        this.mContext = context;
        this.makeDataDirs();
    }

    private final String $$robo$$com_android_internal_backup_LocalTransport$name() {
        return new ComponentName(this.mContext, this.getClass()).flattenToShortString();
    }

    private final Intent $$robo$$com_android_internal_backup_LocalTransport$configurationIntent() {
        return null;
    }

    private final String $$robo$$com_android_internal_backup_LocalTransport$currentDestinationString() {
        return "Backing up to debug-only private cache";
    }

    private final Intent $$robo$$com_android_internal_backup_LocalTransport$dataManagementIntent() {
        return null;
    }

    private final String $$robo$$com_android_internal_backup_LocalTransport$dataManagementLabel() {
        return "";
    }

    private final String $$robo$$com_android_internal_backup_LocalTransport$transportDirName() {
        return "com.android.internal.backup.LocalTransport";
    }

    private final long $$robo$$com_android_internal_backup_LocalTransport$requestBackupTime() {
        return 0L;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$initializeDevice() {
        this.deleteContents(this.mCurrentSetDir);
        this.makeDataDirs();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int $$robo$$com_android_internal_backup_LocalTransport$performBackup(PackageInfo packageInfo, ParcelFileDescriptor data) {
        File packageDir = new File(this.mCurrentSetIncrementalDir, packageInfo.packageName);
        packageDir.mkdirs();
        BackupDataInput changeSet = new BackupDataInput(data.getFileDescriptor());
        try {
            int bufSize = 512;
            byte[] buf = new byte[bufSize];
            while (changeSet.readNextHeader()) {
                String key = changeSet.getKey();
                String base64Key = new String(Base64.encode((byte[])key.getBytes()));
                File entityFile = new File(packageDir, base64Key);
                int dataSize = changeSet.getDataSize();
                if (dataSize >= 0) {
                    if (entityFile.exists()) {
                        entityFile.delete();
                    }
                    FileOutputStream entity = new FileOutputStream(entityFile);
                    if (dataSize > bufSize) {
                        bufSize = dataSize;
                        buf = new byte[bufSize];
                    }
                    changeSet.readEntityData(buf, 0, dataSize);
                    try {
                        entity.write(buf, 0, dataSize);
                        continue;
                    }
                    catch (IOException e) {
                        Log.e("LocalTransport", "Unable to update key file " + entityFile.getAbsolutePath());
                        int n = -1000;
                        return n;
                    }
                    finally {
                        entity.close();
                        continue;
                    }
                }
                entityFile.delete();
            }
            return 0;
        }
        catch (IOException e) {
            Log.v("LocalTransport", "Exception reading backup input:", e);
            return -1000;
        }
    }

    private final void $$robo$$com_android_internal_backup_LocalTransport$deleteContents(File dirname) {
        File[] contents = dirname.listFiles();
        if (contents != null) {
            for (File f : contents) {
                if (f.isDirectory()) {
                    this.deleteContents(f);
                }
                f.delete();
            }
        }
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$clearBackupData(PackageInfo packageInfo) {
        File[] tarballs;
        File packageDir = new File(this.mCurrentSetIncrementalDir, packageInfo.packageName);
        File[] fileset = packageDir.listFiles();
        if (fileset != null) {
            for (File f : fileset) {
                f.delete();
            }
            packageDir.delete();
        }
        if ((tarballs = (packageDir = new File(this.mCurrentSetFullDir, packageInfo.packageName)).listFiles()) != null) {
            for (File f : tarballs) {
                f.delete();
            }
            packageDir.delete();
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$finishBackup() {
        return this.tearDownFullBackup();
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$tearDownFullBackup() {
        if (this.mSocket != null) {
            try {
                if (this.mFullBackupOutputStream != null) {
                    this.mFullBackupOutputStream.flush();
                    this.mFullBackupOutputStream.close();
                }
                this.mSocketInputStream = null;
                this.mFullTargetPackage = null;
                this.mSocket.close();
            }
            catch (IOException e) {
                int n = -1000;
                return n;
            }
            finally {
                this.mSocket = null;
                this.mFullBackupOutputStream = null;
            }
        }
        return 0;
    }

    private final File $$robo$$com_android_internal_backup_LocalTransport$tarballFile(String pkgName) {
        return new File(this.mCurrentSetFullDir, pkgName);
    }

    private final long $$robo$$com_android_internal_backup_LocalTransport$requestFullBackupTime() {
        return 0L;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$checkFullBackupSize(long size) {
        int result = 0;
        if (size <= 0L) {
            result = -1002;
        } else if (size > 0x1900000L) {
            result = -1005;
        }
        if (result != 0) {
            // empty if block
        }
        return result;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$performFullBackup(PackageInfo targetPackage, ParcelFileDescriptor socket) {
        if (this.mSocket != null) {
            Log.e("LocalTransport", "Attempt to initiate full backup while one is in progress");
            return -1000;
        }
        try {
            this.mFullBackupSize = 0L;
            this.mSocket = ParcelFileDescriptor.dup(socket.getFileDescriptor());
            this.mSocketInputStream = new FileInputStream(this.mSocket.getFileDescriptor());
        }
        catch (IOException e) {
            Log.e("LocalTransport", "Unable to process socket for full backup");
            return -1000;
        }
        this.mFullTargetPackage = targetPackage.packageName;
        this.mFullBackupBuffer = new byte[4096];
        return 0;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$sendBackupData(int numBytes) {
        int nRead;
        if (this.mSocket == null) {
            Log.w("LocalTransport", "Attempted sendBackupData before performFullBackup");
            return -1000;
        }
        this.mFullBackupSize += (long)numBytes;
        if (this.mFullBackupSize > 0x1900000L) {
            return -1005;
        }
        if (numBytes > this.mFullBackupBuffer.length) {
            this.mFullBackupBuffer = new byte[numBytes];
        }
        if (this.mFullBackupOutputStream == null) {
            FileOutputStream tarstream;
            try {
                File tarball = this.tarballFile(this.mFullTargetPackage);
                tarstream = new FileOutputStream(tarball);
            }
            catch (FileNotFoundException e) {
                return -1000;
            }
            this.mFullBackupOutputStream = new BufferedOutputStream(tarstream);
        }
        for (int bytesLeft = numBytes; bytesLeft > 0; bytesLeft -= nRead) {
            try {
                nRead = this.mSocketInputStream.read(this.mFullBackupBuffer, 0, bytesLeft);
                if (nRead < 0) {
                    Log.w("LocalTransport", "Unexpected EOD; failing backup");
                    return -1000;
                }
                this.mFullBackupOutputStream.write(this.mFullBackupBuffer, 0, nRead);
                continue;
            }
            catch (IOException e) {
                Log.e("LocalTransport", "Error handling backup data for " + this.mFullTargetPackage);
                return -1000;
            }
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_backup_LocalTransport$cancelFullBackup() {
        File archive = this.tarballFile(this.mFullTargetPackage);
        this.tearDownFullBackup();
        if (archive.exists()) {
            archive.delete();
        }
    }

    private final RestoreSet[] $$robo$$com_android_internal_backup_LocalTransport$getAvailableRestoreSets() {
        long[] existing = new long[POSSIBLE_SETS.length + 1];
        int num = 0;
        for (long token : POSSIBLE_SETS) {
            if (!new File(this.mDataDir, Long.toString(token)).exists()) continue;
            existing[num++] = token;
        }
        existing[num++] = 1L;
        RestoreSet[] available = new RestoreSet[num];
        for (int i = 0; i < available.length; ++i) {
            available[i] = new RestoreSet("Local disk image", "flash", existing[i]);
        }
        return available;
    }

    private final long $$robo$$com_android_internal_backup_LocalTransport$getCurrentRestoreSet() {
        return 1L;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$startRestore(long token, PackageInfo[] packages) {
        this.mRestorePackages = packages;
        this.mRestorePackage = -1;
        this.mRestoreSetDir = new File(this.mDataDir, Long.toString(token));
        this.mRestoreSetIncrementalDir = new File(this.mRestoreSetDir, "_delta");
        this.mRestoreSetFullDir = new File(this.mRestoreSetDir, "_full");
        return 0;
    }

    private final RestoreDescription $$robo$$com_android_internal_backup_LocalTransport$nextRestorePackage() {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        boolean found = false;
        while (++this.mRestorePackage < this.mRestorePackages.length) {
            File maybeFullData;
            String name = this.mRestorePackages[this.mRestorePackage].packageName;
            String[] contents = new File(this.mRestoreSetIncrementalDir, name).list();
            if (contents != null && contents.length > 0) {
                this.mRestoreType = 1;
                found = true;
            }
            if (!found && (maybeFullData = new File(this.mRestoreSetFullDir, name)).length() > 0L) {
                this.mRestoreType = 2;
                this.mCurFullRestoreStream = null;
                found = true;
            }
            if (!found) continue;
            return new RestoreDescription(name, this.mRestoreType);
        }
        return RestoreDescription.NO_MORE_PACKAGES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_backup_LocalTransport$getRestoreData(ParcelFileDescriptor outFd) {
        if (this.mRestorePackages == null) {
            throw new IllegalStateException("startRestore not called");
        }
        if (this.mRestorePackage < 0) {
            throw new IllegalStateException("nextRestorePackage not called");
        }
        if (this.mRestoreType != 1) {
            throw new IllegalStateException("getRestoreData(fd) for non-key/value dataset");
        }
        File packageDir = new File(this.mRestoreSetIncrementalDir, this.mRestorePackages[this.mRestorePackage].packageName);
        ArrayList<DecodedFilename> blobs = this.contentsByKey(packageDir);
        if (blobs == null) {
            Log.e("LocalTransport", "No keys for package: " + packageDir);
            return -1000;
        }
        BackupDataOutput out = new BackupDataOutput(outFd.getFileDescriptor());
        try {
            for (DecodedFilename keyEntry : blobs) {
                File f = keyEntry.file;
                try (FileInputStream in = new FileInputStream(f);){
                    int size = (int)f.length();
                    byte[] buf = new byte[size];
                    in.read(buf);
                    out.writeEntityHeader(keyEntry.key, size);
                    out.writeEntityData(buf, size);
                }
            }
            return 0;
        }
        catch (IOException e) {
            Log.e("LocalTransport", "Unable to read backup records", e);
            return -1000;
        }
    }

    private final ArrayList<DecodedFilename> $$robo$$com_android_internal_backup_LocalTransport$contentsByKey(File dir) {
        File[] allFiles = dir.listFiles();
        if (allFiles == null || allFiles.length == 0) {
            return null;
        }
        ArrayList<DecodedFilename> contents = new ArrayList<DecodedFilename>();
        for (File f : allFiles) {
            contents.add(new DecodedFilename(f));
        }
        Collections.sort(contents);
        return contents;
    }

    private final void $$robo$$com_android_internal_backup_LocalTransport$finishRestore() {
        if (this.mRestoreType == 2) {
            this.resetFullRestoreState();
        }
        this.mRestoreType = 0;
    }

    private final void $$robo$$com_android_internal_backup_LocalTransport$resetFullRestoreState() {
        IoUtils.closeQuietly(this.mCurFullRestoreStream);
        this.mCurFullRestoreStream = null;
        this.mFullRestoreSocketStream = null;
        this.mFullRestoreBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_backup_LocalTransport$getNextFullRestoreDataChunk(ParcelFileDescriptor socket) {
        int nRead;
        if (this.mRestoreType != 2) {
            throw new IllegalStateException("Asked for full restore data for non-stream package");
        }
        if (this.mCurFullRestoreStream == null) {
            String name = this.mRestorePackages[this.mRestorePackage].packageName;
            File dataset = new File(this.mRestoreSetFullDir, name);
            try {
                this.mCurFullRestoreStream = new FileInputStream(dataset);
            }
            catch (IOException e) {
                Log.e("LocalTransport", "Unable to read archive for " + name);
                return -1002;
            }
            this.mFullRestoreSocketStream = new FileOutputStream(socket.getFileDescriptor());
            this.mFullRestoreBuffer = new byte[2048];
        }
        try {
            nRead = this.mCurFullRestoreStream.read(this.mFullRestoreBuffer);
            if (nRead < 0) {
                nRead = -1;
            } else if (nRead == 0) {
                Log.w("LocalTransport", "read() of archive file returned 0; treating as EOF");
                nRead = -1;
            } else {
                this.mFullRestoreSocketStream.write(this.mFullRestoreBuffer, 0, nRead);
            }
        }
        catch (IOException e) {
            int n = -1000;
            return n;
        }
        return nRead;
    }

    private final int $$robo$$com_android_internal_backup_LocalTransport$abortFullRestore() {
        if (this.mRestoreType != 2) {
            throw new IllegalStateException("abortFullRestore() but not currently restoring");
        }
        this.resetFullRestoreState();
        this.mRestoreType = 0;
        return 0;
    }

    private final long $$robo$$com_android_internal_backup_LocalTransport$getBackupQuota(String packageName, boolean isFullBackup) {
        return isFullBackup ? 0x1900000L : 0x500000L;
    }

    static void __staticInitializer__() {
        POSSIBLE_SETS = new long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};
    }

    private void makeDataDirs() {
        InvokeDynamicSupport.bootstrap("makeDataDirs", $$robo$$com_android_internal_backup_LocalTransport$makeDataDirs(), 0, this);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_backup_LocalTransport$__constructor__(context);
    }

    public LocalTransport(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_backup_LocalTransport$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public String name() {
        return InvokeDynamicSupport.bootstrap("name", $$robo$$com_android_internal_backup_LocalTransport$name(), 0, this);
    }

    @Override
    public Intent configurationIntent() {
        return InvokeDynamicSupport.bootstrap("configurationIntent", $$robo$$com_android_internal_backup_LocalTransport$configurationIntent(), 0, this);
    }

    @Override
    public String currentDestinationString() {
        return InvokeDynamicSupport.bootstrap("currentDestinationString", $$robo$$com_android_internal_backup_LocalTransport$currentDestinationString(), 0, this);
    }

    @Override
    public Intent dataManagementIntent() {
        return InvokeDynamicSupport.bootstrap("dataManagementIntent", $$robo$$com_android_internal_backup_LocalTransport$dataManagementIntent(), 0, this);
    }

    @Override
    public String dataManagementLabel() {
        return InvokeDynamicSupport.bootstrap("dataManagementLabel", $$robo$$com_android_internal_backup_LocalTransport$dataManagementLabel(), 0, this);
    }

    @Override
    public String transportDirName() {
        return InvokeDynamicSupport.bootstrap("transportDirName", $$robo$$com_android_internal_backup_LocalTransport$transportDirName(), 0, this);
    }

    @Override
    public long requestBackupTime() {
        return (long)InvokeDynamicSupport.bootstrap("requestBackupTime", $$robo$$com_android_internal_backup_LocalTransport$requestBackupTime(), 0, this);
    }

    @Override
    public int initializeDevice() {
        return (int)InvokeDynamicSupport.bootstrap("initializeDevice", $$robo$$com_android_internal_backup_LocalTransport$initializeDevice(), 0, this);
    }

    @Override
    public int performBackup(PackageInfo packageInfo, ParcelFileDescriptor parcelFileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrap("performBackup", $$robo$$com_android_internal_backup_LocalTransport$performBackup(android.content.pm.PackageInfo android.os.ParcelFileDescriptor ), 0, this, packageInfo, parcelFileDescriptor);
    }

    private void deleteContents(File file) {
        InvokeDynamicSupport.bootstrap("deleteContents", $$robo$$com_android_internal_backup_LocalTransport$deleteContents(java.io.File ), 0, this, file);
    }

    @Override
    public int clearBackupData(PackageInfo packageInfo) {
        return (int)InvokeDynamicSupport.bootstrap("clearBackupData", $$robo$$com_android_internal_backup_LocalTransport$clearBackupData(android.content.pm.PackageInfo ), 0, this, packageInfo);
    }

    @Override
    public int finishBackup() {
        return (int)InvokeDynamicSupport.bootstrap("finishBackup", $$robo$$com_android_internal_backup_LocalTransport$finishBackup(), 0, this);
    }

    private int tearDownFullBackup() {
        return (int)InvokeDynamicSupport.bootstrap("tearDownFullBackup", $$robo$$com_android_internal_backup_LocalTransport$tearDownFullBackup(), 0, this);
    }

    private File tarballFile(String string2) {
        return InvokeDynamicSupport.bootstrap("tarballFile", $$robo$$com_android_internal_backup_LocalTransport$tarballFile(java.lang.String ), 0, this, string2);
    }

    @Override
    public long requestFullBackupTime() {
        return (long)InvokeDynamicSupport.bootstrap("requestFullBackupTime", $$robo$$com_android_internal_backup_LocalTransport$requestFullBackupTime(), 0, this);
    }

    @Override
    public int checkFullBackupSize(long l) {
        return (int)InvokeDynamicSupport.bootstrap("checkFullBackupSize", $$robo$$com_android_internal_backup_LocalTransport$checkFullBackupSize(long ), 0, this, l);
    }

    @Override
    public int performFullBackup(PackageInfo packageInfo, ParcelFileDescriptor parcelFileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrap("performFullBackup", $$robo$$com_android_internal_backup_LocalTransport$performFullBackup(android.content.pm.PackageInfo android.os.ParcelFileDescriptor ), 0, this, packageInfo, parcelFileDescriptor);
    }

    @Override
    public int sendBackupData(int n) {
        return (int)InvokeDynamicSupport.bootstrap("sendBackupData", $$robo$$com_android_internal_backup_LocalTransport$sendBackupData(int ), 0, this, n);
    }

    @Override
    public void cancelFullBackup() {
        InvokeDynamicSupport.bootstrap("cancelFullBackup", $$robo$$com_android_internal_backup_LocalTransport$cancelFullBackup(), 0, this);
    }

    @Override
    public RestoreSet[] getAvailableRestoreSets() {
        return InvokeDynamicSupport.bootstrap("getAvailableRestoreSets", $$robo$$com_android_internal_backup_LocalTransport$getAvailableRestoreSets(), 0, this);
    }

    @Override
    public long getCurrentRestoreSet() {
        return (long)InvokeDynamicSupport.bootstrap("getCurrentRestoreSet", $$robo$$com_android_internal_backup_LocalTransport$getCurrentRestoreSet(), 0, this);
    }

    @Override
    public int startRestore(long l, PackageInfo[] packageInfoArray) {
        return (int)InvokeDynamicSupport.bootstrap("startRestore", $$robo$$com_android_internal_backup_LocalTransport$startRestore(long android.content.pm.PackageInfo[] ), 0, this, l, packageInfoArray);
    }

    @Override
    public RestoreDescription nextRestorePackage() {
        return InvokeDynamicSupport.bootstrap("nextRestorePackage", $$robo$$com_android_internal_backup_LocalTransport$nextRestorePackage(), 0, this);
    }

    @Override
    public int getRestoreData(ParcelFileDescriptor parcelFileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrap("getRestoreData", $$robo$$com_android_internal_backup_LocalTransport$getRestoreData(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    private ArrayList<DecodedFilename> contentsByKey(File file) {
        return InvokeDynamicSupport.bootstrap("contentsByKey", $$robo$$com_android_internal_backup_LocalTransport$contentsByKey(java.io.File ), 0, this, file);
    }

    @Override
    public void finishRestore() {
        InvokeDynamicSupport.bootstrap("finishRestore", $$robo$$com_android_internal_backup_LocalTransport$finishRestore(), 0, this);
    }

    private void resetFullRestoreState() {
        InvokeDynamicSupport.bootstrap("resetFullRestoreState", $$robo$$com_android_internal_backup_LocalTransport$resetFullRestoreState(), 0, this);
    }

    @Override
    public int getNextFullRestoreDataChunk(ParcelFileDescriptor parcelFileDescriptor) {
        return (int)InvokeDynamicSupport.bootstrap("getNextFullRestoreDataChunk", $$robo$$com_android_internal_backup_LocalTransport$getNextFullRestoreDataChunk(android.os.ParcelFileDescriptor ), 0, this, parcelFileDescriptor);
    }

    @Override
    public int abortFullRestore() {
        return (int)InvokeDynamicSupport.bootstrap("abortFullRestore", $$robo$$com_android_internal_backup_LocalTransport$abortFullRestore(), 0, this);
    }

    @Override
    public long getBackupQuota(String string2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrap("getBackupQuota", $$robo$$com_android_internal_backup_LocalTransport$getBackupQuota(java.lang.String boolean ), 0, this, string2, bl);
    }

    static {
        RobolectricInternals.classInitializing(LocalTransport.class);
    }

    public /* synthetic */ LocalTransport() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalTransport)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class DecodedFilename
    implements Comparable<DecodedFilename> {
        public transient /* synthetic */ Object __robo_data__;
        public File file;
        public String key;

        private void $$robo$$com_android_internal_backup_LocalTransport_DecodedFilename$__constructor__(File f) {
            this.file = f;
            this.key = new String(Base64.decode((String)f.getName()));
        }

        private final int $$robo$$com_android_internal_backup_LocalTransport_DecodedFilename$compareTo(DecodedFilename other) {
            return this.key.compareTo(other.key);
        }

        private void __constructor__(File file) {
            this.$$robo$$com_android_internal_backup_LocalTransport_DecodedFilename$__constructor__(file);
        }

        public DecodedFilename(File file) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_backup_LocalTransport_DecodedFilename$__constructor__(java.io.File ), 0, this, file);
        }

        @Override
        public int compareTo(DecodedFilename decodedFilename) {
            return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$com_android_internal_backup_LocalTransport_DecodedFilename$compareTo(com.android.internal.backup.LocalTransport$DecodedFilename ), 0, this, decodedFilename);
        }

        public /* synthetic */ DecodedFilename() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DecodedFilename)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

