/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.location;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.INetInitiatedListener;
import android.location.LocationManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.telephony.PhoneNumberUtils;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.android.internal.app.NetInitiatedActivity;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GpsNetInitiatedHandler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GpsNetInitiatedHandler";
    private static boolean DEBUG = true;
    private static boolean VERBOSE = false;
    public static String ACTION_NI_VERIFY = "android.intent.action.NETWORK_INITIATED_VERIFY";
    public static String NI_INTENT_KEY_NOTIF_ID = "notif_id";
    public static String NI_INTENT_KEY_TITLE = "title";
    public static String NI_INTENT_KEY_MESSAGE = "message";
    public static String NI_INTENT_KEY_TIMEOUT = "timeout";
    public static String NI_INTENT_KEY_DEFAULT_RESPONSE = "default_resp";
    public static String NI_RESPONSE_EXTRA_CMD = "send_ni_response";
    public static String NI_EXTRA_CMD_NOTIF_ID = "notif_id";
    public static String NI_EXTRA_CMD_RESPONSE = "response";
    public static int GPS_NI_TYPE_VOICE = 1;
    public static int GPS_NI_TYPE_UMTS_SUPL = 2;
    public static int GPS_NI_TYPE_UMTS_CTRL_PLANE = 3;
    public static int GPS_NI_TYPE_EMERGENCY_SUPL = 4;
    public static int GPS_NI_RESPONSE_ACCEPT = 1;
    public static int GPS_NI_RESPONSE_DENY = 2;
    public static int GPS_NI_RESPONSE_NORESP = 3;
    public static int GPS_NI_RESPONSE_IGNORE = 4;
    public static int GPS_NI_NEED_NOTIFY = 1;
    public static int GPS_NI_NEED_VERIFY = 2;
    public static int GPS_NI_PRIVACY_OVERRIDE = 4;
    public static int GPS_ENC_NONE = 0;
    public static int GPS_ENC_SUPL_GSM_DEFAULT = 1;
    public static int GPS_ENC_SUPL_UTF8 = 2;
    public static int GPS_ENC_SUPL_UCS2 = 3;
    public static int GPS_ENC_UNKNOWN = -1;
    private Context mContext;
    private TelephonyManager mTelephonyManager;
    private PhoneStateListener mPhoneStateListener;
    private LocationManager mLocationManager;
    private boolean mPlaySounds;
    private boolean mPopupImmediately;
    private volatile boolean mIsSuplEsEnabled;
    private volatile boolean mIsInEmergency;
    private volatile boolean mIsLocationEnabled;
    private INetInitiatedListener mNetInitiatedListener;
    private static boolean mIsHexInput;
    private BroadcastReceiver mBroadcastReciever;
    private Notification.Builder mNiNotificationBuilder;

    private void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$__constructor__(Context context, INetInitiatedListener netInitiatedListener, boolean isSuplEsEnabled) {
        this.mPlaySounds = false;
        this.mPopupImmediately = true;
        this.mIsLocationEnabled = false;
        this.mBroadcastReciever = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GpsNetInitiatedHandler this$0;

            private void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_1$__constructor__(GpsNetInitiatedHandler this$0) {
            }

            private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_1$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action.equals("android.intent.action.NEW_OUTGOING_CALL")) {
                    String phoneNumber = intent.getStringExtra("android.intent.extra.PHONE_NUMBER");
                    this.this$0.setInEmergency(PhoneNumberUtils.isEmergencyNumber(phoneNumber));
                    Log.v("GpsNetInitiatedHandler", "ACTION_NEW_OUTGOING_CALL - " + this.this$0.getInEmergency());
                } else if (action.equals("android.location.MODE_CHANGED")) {
                    this.this$0.updateLocationMode();
                    Log.d("GpsNetInitiatedHandler", "location enabled :" + this.this$0.getLocationEnabled());
                }
            }

            private void __constructor__(GpsNetInitiatedHandler gpsNetInitiatedHandler) {
                this.$$robo$$com_android_internal_location_GpsNetInitiatedHandler_1$__constructor__(gpsNetInitiatedHandler);
            }
            {
                this.this$0 = gpsNetInitiatedHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_1$__constructor__(com.android.internal.location.GpsNetInitiatedHandler ), 0, this, gpsNetInitiatedHandler);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        if (netInitiatedListener == null) {
            throw new IllegalArgumentException("netInitiatedListener is null");
        }
        this.mNetInitiatedListener = netInitiatedListener;
        this.setSuplEsEnabled(isSuplEsEnabled);
        this.mLocationManager = (LocationManager)context.getSystemService("location");
        this.updateLocationMode();
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mPhoneStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GpsNetInitiatedHandler this$0;

            private void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_2$__constructor__(GpsNetInitiatedHandler this$0) {
            }

            private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_2$onCallStateChanged(int state, String incomingNumber) {
                Log.d("GpsNetInitiatedHandler", "onCallStateChanged(): state is " + state);
                if (state == 0) {
                    this.this$0.setInEmergency(false);
                }
            }

            private void __constructor__(GpsNetInitiatedHandler gpsNetInitiatedHandler) {
                this.$$robo$$com_android_internal_location_GpsNetInitiatedHandler_2$__constructor__(gpsNetInitiatedHandler);
            }
            {
                this.this$0 = gpsNetInitiatedHandler;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_2$__constructor__(com.android.internal.location.GpsNetInitiatedHandler ), 0, this, gpsNetInitiatedHandler);
            }

            @Override
            public void onCallStateChanged(int n, String string2) {
                InvokeDynamicSupport.bootstrap("onCallStateChanged", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_2$onCallStateChanged(int java.lang.String ), 0, this, n, string2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTelephonyManager.listen(this.mPhoneStateListener, 32);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        intentFilter.addAction("android.location.MODE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReciever, intentFilter);
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setSuplEsEnabled(boolean isEnabled) {
        this.mIsSuplEsEnabled = isEnabled;
    }

    private final boolean $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getSuplEsEnabled() {
        return this.mIsSuplEsEnabled;
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$updateLocationMode() {
        this.mIsLocationEnabled = this.mLocationManager.isProviderEnabled("gps");
    }

    private final boolean $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getLocationEnabled() {
        return this.mIsLocationEnabled;
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setInEmergency(boolean isInEmergency) {
        this.mIsInEmergency = isInEmergency;
    }

    private final boolean $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getInEmergency() {
        boolean isInEmergencyCallback = this.mTelephonyManager.getEmergencyCallbackMode();
        return this.mIsInEmergency || isInEmergencyCallback;
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNiNotification(GpsNiNotification notif) {
        Log.d("GpsNetInitiatedHandler", "in handleNiNotification () : notificationId: " + notif.notificationId + " requestorId: " + notif.requestorId + " text: " + notif.text + " mIsSuplEsEnabled" + this.getSuplEsEnabled() + " mIsLocationEnabled" + this.getLocationEnabled());
        if (this.getSuplEsEnabled()) {
            this.handleNiInEs(notif);
        } else {
            this.handleNi(notif);
        }
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNi(GpsNiNotification notif) {
        Log.d("GpsNetInitiatedHandler", "in handleNi () : needNotify: " + notif.needNotify + " needVerify: " + notif.needVerify + " privacyOverride: " + notif.privacyOverride + " mPopupImmediately: " + this.mPopupImmediately + " mInEmergency: " + this.getInEmergency());
        if (!this.getLocationEnabled() && !this.getInEmergency()) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 4);
            }
            catch (RemoteException e) {
                Log.e("GpsNetInitiatedHandler", "RemoteException in sendNiResponse");
            }
        }
        if (notif.needNotify) {
            if (notif.needVerify && this.mPopupImmediately) {
                this.openNiDialog(notif);
            } else {
                this.setNiNotification(notif);
            }
        }
        if (!notif.needVerify || notif.privacyOverride) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 1);
            }
            catch (RemoteException e) {
                Log.e("GpsNetInitiatedHandler", "RemoteException in sendNiResponse");
            }
        }
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNiInEs(GpsNiNotification notif) {
        boolean isNiTypeES;
        Log.d("GpsNetInitiatedHandler", "in handleNiInEs () : niType: " + notif.niType + " notificationId: " + notif.notificationId);
        boolean bl = isNiTypeES = notif.niType == 4;
        if (isNiTypeES != this.getInEmergency()) {
            try {
                this.mNetInitiatedListener.sendNiResponse(notif.notificationId, 4);
            }
            catch (RemoteException e) {
                Log.e("GpsNetInitiatedHandler", "RemoteException in sendNiResponse");
            }
        } else {
            this.handleNi(notif);
        }
    }

    private final synchronized void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setNiNotification(GpsNiNotification notif) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            return;
        }
        String title = GpsNetInitiatedHandler.getNotifTitle(notif, this.mContext);
        String message = GpsNetInitiatedHandler.getNotifMessage(notif, this.mContext);
        Log.d("GpsNetInitiatedHandler", "setNiNotification, notifyId: " + notif.notificationId + ", title: " + title + ", message: " + message);
        if (this.mNiNotificationBuilder == null) {
            this.mNiNotificationBuilder = new Notification.Builder(this.mContext, SystemNotificationChannels.NETWORK_ALERTS).setSmallIcon(17303341).setWhen(0L).setOngoing(true).setAutoCancel(true).setColor(this.mContext.getColor(17170761));
        }
        if (this.mPlaySounds) {
            this.mNiNotificationBuilder.setDefaults(1);
        } else {
            this.mNiNotificationBuilder.setDefaults(0);
        }
        Intent intent = !this.mPopupImmediately ? this.getDlgIntent(notif) : new Intent();
        PendingIntent pi = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        this.mNiNotificationBuilder.setTicker(GpsNetInitiatedHandler.getNotifTicker(notif, this.mContext)).setContentTitle(title).setContentText(message).setContentIntent(pi);
        notificationManager.notifyAsUser(null, notif.notificationId, this.mNiNotificationBuilder.build(), UserHandle.ALL);
    }

    private final void $$robo$$com_android_internal_location_GpsNetInitiatedHandler$openNiDialog(GpsNiNotification notif) {
        Intent intent = this.getDlgIntent(notif);
        Log.d("GpsNetInitiatedHandler", "openNiDialog, notifyId: " + notif.notificationId + ", requestorId: " + notif.requestorId + ", text: " + notif.text);
        this.mContext.startActivity(intent);
    }

    private final Intent $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDlgIntent(GpsNiNotification notif) {
        Intent intent = new Intent();
        String title = GpsNetInitiatedHandler.getDialogTitle(notif, this.mContext);
        String message = GpsNetInitiatedHandler.getDialogMessage(notif, this.mContext);
        intent.setFlags(0x10008000);
        intent.setClass(this.mContext, NetInitiatedActivity.class);
        intent.putExtra("notif_id", notif.notificationId);
        intent.putExtra("title", title);
        intent.putExtra("message", message);
        intent.putExtra("timeout", notif.timeout);
        intent.putExtra("default_resp", notif.defaultResponse);
        Log.d("GpsNetInitiatedHandler", "generateIntent, title: " + title + ", message: " + message + ", timeout: " + notif.timeout);
        return intent;
    }

    private static final byte[] $$robo$$com_android_internal_location_GpsNetInitiatedHandler$stringToByteArray(String original, boolean isHex) {
        int length = isHex ? original.length() / 2 : original.length();
        byte[] output = new byte[length];
        if (isHex) {
            for (int i = 0; i < length; ++i) {
                output[i] = (byte)Integer.parseInt(original.substring(i * 2, i * 2 + 2), 16);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                output[i] = (byte)original.charAt(i);
            }
        }
        return output;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeGSMPackedString(byte[] input) {
        String decoded;
        boolean PADDING_CHAR = false;
        int lengthBytes = input.length;
        int lengthSeptets = lengthBytes * 8 / 7;
        if (lengthBytes % 7 == 0 && lengthBytes > 0 && input[lengthBytes - 1] >> 1 == 0) {
            --lengthSeptets;
        }
        if (null == (decoded = GsmAlphabet.gsm7BitPackedToString(input, 0, lengthSeptets))) {
            Log.e("GpsNetInitiatedHandler", "Decoding of GSM packed string failed");
            decoded = "";
        }
        return decoded;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeUTF8String(byte[] input) {
        String decoded = "";
        try {
            decoded = new String(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        return decoded;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeUCS2String(byte[] input) {
        String decoded = "";
        try {
            decoded = new String(input, "UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError();
        }
        return decoded;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeString(String original, boolean isHex, int coding) {
        String decoded = original;
        byte[] input = GpsNetInitiatedHandler.stringToByteArray(original, isHex);
        switch (coding) {
            case 0: {
                decoded = original;
                break;
            }
            case 1: {
                decoded = GpsNetInitiatedHandler.decodeGSMPackedString(input);
                break;
            }
            case 2: {
                decoded = GpsNetInitiatedHandler.decodeUTF8String(input);
                break;
            }
            case 3: {
                decoded = GpsNetInitiatedHandler.decodeUCS2String(input);
                break;
            }
            case -1: {
                decoded = original;
                break;
            }
            default: {
                Log.e("GpsNetInitiatedHandler", "Unknown encoding " + coding + " for NI text " + original);
            }
        }
        return decoded;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifTicker(GpsNiNotification notif, Context context) {
        String ticker = String.format(context.getString(17039925), GpsNetInitiatedHandler.decodeString(notif.requestorId, mIsHexInput, notif.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(notif.text, mIsHexInput, notif.textEncoding));
        return ticker;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifTitle(GpsNiNotification notif, Context context) {
        String title = String.format(context.getString(17039926), new Object[0]);
        return title;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifMessage(GpsNiNotification notif, Context context) {
        String message = String.format(context.getString(17039924), GpsNetInitiatedHandler.decodeString(notif.requestorId, mIsHexInput, notif.requestorIdEncoding), GpsNetInitiatedHandler.decodeString(notif.text, mIsHexInput, notif.textEncoding));
        return message;
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDialogTitle(GpsNiNotification notif, Context context) {
        return GpsNetInitiatedHandler.getNotifTitle(notif, context);
    }

    private static final String $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDialogMessage(GpsNiNotification notif, Context context) {
        return GpsNetInitiatedHandler.getNotifMessage(notif, context);
    }

    static void __staticInitializer__() {
        mIsHexInput = true;
    }

    private void __constructor__(Context context, INetInitiatedListener iNetInitiatedListener, boolean bl) {
        this.$$robo$$com_android_internal_location_GpsNetInitiatedHandler$__constructor__(context, iNetInitiatedListener, bl);
    }

    public GpsNetInitiatedHandler(Context context, INetInitiatedListener iNetInitiatedListener, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$__constructor__(android.content.Context android.location.INetInitiatedListener boolean ), 0, this, context, iNetInitiatedListener, bl);
    }

    public void setSuplEsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSuplEsEnabled", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setSuplEsEnabled(boolean ), 0, this, bl);
    }

    public boolean getSuplEsEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSuplEsEnabled", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getSuplEsEnabled(), 0, this);
    }

    public void updateLocationMode() {
        InvokeDynamicSupport.bootstrap("updateLocationMode", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$updateLocationMode(), 0, this);
    }

    public boolean getLocationEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getLocationEnabled", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getLocationEnabled(), 0, this);
    }

    public void setInEmergency(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInEmergency", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setInEmergency(boolean ), 0, this, bl);
    }

    public boolean getInEmergency() {
        return (boolean)InvokeDynamicSupport.bootstrap("getInEmergency", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getInEmergency(), 0, this);
    }

    public void handleNiNotification(GpsNiNotification gpsNiNotification) {
        InvokeDynamicSupport.bootstrap("handleNiNotification", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNiNotification(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    private void handleNi(GpsNiNotification gpsNiNotification) {
        InvokeDynamicSupport.bootstrap("handleNi", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNi(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    private void handleNiInEs(GpsNiNotification gpsNiNotification) {
        InvokeDynamicSupport.bootstrap("handleNiInEs", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$handleNiInEs(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    private synchronized void setNiNotification(GpsNiNotification gpsNiNotification) {
        InvokeDynamicSupport.bootstrap("setNiNotification", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$setNiNotification(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    private void openNiDialog(GpsNiNotification gpsNiNotification) {
        InvokeDynamicSupport.bootstrap("openNiDialog", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$openNiDialog(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    private Intent getDlgIntent(GpsNiNotification gpsNiNotification) {
        return InvokeDynamicSupport.bootstrap("getDlgIntent", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDlgIntent(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification ), 0, this, gpsNiNotification);
    }

    static byte[] stringToByteArray(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("stringToByteArray", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$stringToByteArray(java.lang.String boolean ), 0, (String)string2, (boolean)bl);
    }

    static String decodeGSMPackedString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("decodeGSMPackedString", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeGSMPackedString(byte[] ), 0, (byte[])byArray);
    }

    static String decodeUTF8String(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("decodeUTF8String", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeUTF8String(byte[] ), 0, (byte[])byArray);
    }

    static String decodeUCS2String(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("decodeUCS2String", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeUCS2String(byte[] ), 0, (byte[])byArray);
    }

    private static String decodeString(String string2, boolean bl, int n) {
        return InvokeDynamicSupport.bootstrapStatic("decodeString", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$decodeString(java.lang.String boolean int ), 0, (String)string2, (boolean)bl, (int)n);
    }

    private static String getNotifTicker(GpsNiNotification gpsNiNotification, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNotifTicker", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifTicker(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification android.content.Context ), 0, (GpsNiNotification)gpsNiNotification, (Context)context);
    }

    private static String getNotifTitle(GpsNiNotification gpsNiNotification, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNotifTitle", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifTitle(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification android.content.Context ), 0, (GpsNiNotification)gpsNiNotification, (Context)context);
    }

    private static String getNotifMessage(GpsNiNotification gpsNiNotification, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getNotifMessage", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getNotifMessage(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification android.content.Context ), 0, (GpsNiNotification)gpsNiNotification, (Context)context);
    }

    public static String getDialogTitle(GpsNiNotification gpsNiNotification, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDialogTitle", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDialogTitle(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification android.content.Context ), 0, (GpsNiNotification)gpsNiNotification, (Context)context);
    }

    private static String getDialogMessage(GpsNiNotification gpsNiNotification, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getDialogMessage", $$robo$$com_android_internal_location_GpsNetInitiatedHandler$getDialogMessage(com.android.internal.location.GpsNetInitiatedHandler$GpsNiNotification android.content.Context ), 0, (GpsNiNotification)gpsNiNotification, (Context)context);
    }

    static {
        RobolectricInternals.classInitializing(GpsNetInitiatedHandler.class);
    }

    public /* synthetic */ GpsNetInitiatedHandler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GpsNetInitiatedHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class GpsNiResponse
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int userResponse;

        private void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiResponse$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiResponse$__constructor__();
        }

        public GpsNiResponse() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiResponse$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GpsNiResponse)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class GpsNiNotification
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int notificationId;
        public int niType;
        public boolean needNotify;
        public boolean needVerify;
        public boolean privacyOverride;
        public int timeout;
        public int defaultResponse;
        public String requestorId;
        public String text;
        public int requestorIdEncoding;
        public int textEncoding;

        private void $$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiNotification$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiNotification$__constructor__();
        }

        public GpsNiNotification() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_location_GpsNetInitiatedHandler_GpsNiNotification$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GpsNiNotification)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

