/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.StrictMode;
import android.text.TextUtils;
import android.util.LongSparseLongArray;
import android.util.Slog;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KernelMemoryBandwidthStats
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "KernelMemoryBandwidthStats";
    private static String mSysfsFile = "/sys/kernel/memory_state_time/show_stat";
    private static boolean DEBUG = false;
    protected LongSparseLongArray mBandwidthEntries;
    private boolean mStatsDoNotExist;

    private void $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$__constructor__() {
        this.mBandwidthEntries = new LongSparseLongArray();
        this.mStatsDoNotExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$updateStats() {
        if (this.mStatsDoNotExist) {
            return;
        }
        StrictMode.ThreadPolicy policy = StrictMode.allowThreadDiskReads();
        try (BufferedReader reader = new BufferedReader(new FileReader("/sys/kernel/memory_state_time/show_stat"));){
            this.parseStats(reader);
        }
        catch (FileNotFoundException e) {
            Slog.w("KernelMemoryBandwidthStats", "No kernel memory bandwidth stats available");
            this.mBandwidthEntries.clear();
            this.mStatsDoNotExist = true;
        }
        catch (IOException e) {
            Slog.e("KernelMemoryBandwidthStats", "Failed to read memory bandwidth: " + e.getMessage());
            this.mBandwidthEntries.clear();
        }
        finally {
            StrictMode.setThreadPolicy(policy);
        }
    }

    private final void $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$parseStats(BufferedReader reader) throws IOException {
        String line;
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(' ');
        this.mBandwidthEntries.clear();
        while ((line = reader.readLine()) != null) {
            splitter.setString(line);
            splitter.next();
            int bandwidth = 0;
            do {
                int index;
                if ((index = this.mBandwidthEntries.indexOfKey(bandwidth)) >= 0) {
                    this.mBandwidthEntries.put(bandwidth, this.mBandwidthEntries.valueAt(index) + Long.parseLong((String)splitter.next()) / 1000000L);
                } else {
                    this.mBandwidthEntries.put(bandwidth, Long.parseLong((String)splitter.next()) / 1000000L);
                }
                ++bandwidth;
            } while (splitter.hasNext());
        }
    }

    private final LongSparseLongArray $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$getBandwidthEntries() {
        return this.mBandwidthEntries;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_KernelMemoryBandwidthStats$__constructor__();
    }

    public KernelMemoryBandwidthStats() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$__constructor__(), 0, this);
    }

    public void updateStats() {
        InvokeDynamicSupport.bootstrap("updateStats", $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$updateStats(), 0, this);
    }

    public void parseStats(BufferedReader bufferedReader) throws IOException {
        InvokeDynamicSupport.bootstrap("parseStats", $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$parseStats(java.io.BufferedReader ), 0, this, bufferedReader);
    }

    public LongSparseLongArray getBandwidthEntries() {
        return InvokeDynamicSupport.bootstrap("getBandwidthEntries", $$robo$$com_android_internal_os_KernelMemoryBandwidthStats$getBandwidthEntries(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KernelMemoryBandwidthStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

