/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.icu.impl.CacheValue;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.ULocale;
import android.opengl.EGL14;
import android.os.Build;
import android.os.Environment;
import android.os.IInstalld;
import android.os.Process;
import android.os.RemoteException;
import android.os.Seccomp;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.ZygoteProcess;
import android.os.storage.StorageManager;
import android.security.keystore.AndroidKeyStoreProvider;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.text.Hyphenator;
import android.util.BootTimingsTraceLog;
import android.util.EventLog;
import android.util.Log;
import android.webkit.WebViewFactory;
import android.widget.TextView;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.PathClassLoaderFactory;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import com.android.internal.os.ZygoteServer;
import com.android.internal.util.Preconditions;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import dalvik.system.VMRuntime;
import dalvik.system.ZygoteHooks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Provider;
import java.security.Security;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteInit
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Zygote";
    private static String PROPERTY_DISABLE_OPENGL_PRELOADING = "ro.zygote.disable_gl_preload";
    private static String PROPERTY_GFX_DRIVER = "ro.gfx.driver.0";
    private static String PROPERTY_RUNNING_IN_CONTAINER = "ro.boot.container";
    private static int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static int PRELOAD_GC_THRESHOLD = 50000;
    private static String ABI_LIST_ARG = "--abi-list=";
    private static String SOCKET_NAME_ARG = "--socket-name=";
    private static Resources mResources;
    private static String PRELOADED_CLASSES = "/system/etc/preloaded-classes";
    public static boolean PRELOAD_RESOURCES = true;
    private static int UNPRIVILEGED_UID = 9999;
    private static int UNPRIVILEGED_GID = 9999;
    private static int ROOT_UID = 0;
    private static int ROOT_GID = 0;
    private static boolean sPreloadComplete;

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preload(BootTimingsTraceLog bootTimingsTraceLog) {
        Log.d("Zygote", "begin preload");
        bootTimingsTraceLog.traceBegin("BeginIcuCachePinning");
        ZygoteInit.beginIcuCachePinning();
        bootTimingsTraceLog.traceEnd();
        bootTimingsTraceLog.traceBegin("PreloadClasses");
        ZygoteInit.preloadClasses();
        bootTimingsTraceLog.traceEnd();
        bootTimingsTraceLog.traceBegin("PreloadResources");
        ZygoteInit.preloadResources();
        bootTimingsTraceLog.traceEnd();
        Trace.traceBegin(16384L, "PreloadOpenGL");
        ZygoteInit.preloadOpenGL();
        Trace.traceEnd(16384L);
        ZygoteInit.preloadSharedLibraries();
        ZygoteInit.preloadTextResources();
        WebViewFactory.prepareWebViewInZygote();
        ZygoteInit.endIcuCachePinning();
        ZygoteInit.warmUpJcaProviders();
        Log.d("Zygote", "end preload");
        sPreloadComplete = true;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$lazyPreload() {
        Preconditions.checkState(!sPreloadComplete);
        Log.i("Zygote", "Lazily preloading resources.");
        ZygoteInit.preload(new BootTimingsTraceLog("ZygoteInitTiming_lazy", 16384L));
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$beginIcuCachePinning() {
        ULocale[] localesToPin;
        Log.i("Zygote", "Installing ICU cache reference pinning...");
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        Log.i("Zygote", "Preloading ICU data...");
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$endIcuCachePinning() {
        CacheValue.setStrength(CacheValue.Strength.SOFT);
        Log.i("Zygote", "Uninstalled ICU cache reference pinning...");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries() {
        Log.i("Zygote", "Preloading shared libraries...");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"android");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"compiler_rt");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"jnigraphics");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL() {
        String driverPackageName = SystemProperties.get("ro.gfx.driver.0");
        if (!SystemProperties.getBoolean("ro.zygote.disable_gl_preload", false) && (driverPackageName == null || driverPackageName.isEmpty())) {
            EGL14.eglGetDisplay(0);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadTextResources() {
        Hyphenator.init();
        TextView.preloadFontCache();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$warmUpJcaProviders() {
        long startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting installation of AndroidKeyStoreProvider");
        AndroidKeyStoreProvider.install();
        Log.i("Zygote", "Installed AndroidKeyStoreProvider in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
        startTime = SystemClock.uptimeMillis();
        Trace.traceBegin(16384L, "Starting warm up of JCA providers");
        for (Provider p : Security.getProviders()) {
            p.warmUpServiceProvision();
        }
        Log.i("Zygote", "Warmed up JCA providers in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        Trace.traceEnd(16384L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadClasses() {
        FileInputStream is;
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            is = new FileInputStream("/system/etc/preloaded-classes");
        }
        catch (FileNotFoundException e) {
            Log.e("Zygote", "Couldn't find /system/etc/preloaded-classes.");
            return;
        }
        Log.i("Zygote", "Preloading classes...");
        long startTime = SystemClock.uptimeMillis();
        int reuid = Os.getuid();
        int regid = Os.getgid();
        boolean droppedPriviliges = false;
        if (reuid == 0 && regid == 0) {
            try {
                Os.setregid(0, 9999);
                Os.setreuid(0, 9999);
            }
            catch (ErrnoException ex) {
                throw new RuntimeException("Failed to drop root", ex);
            }
            droppedPriviliges = true;
        }
        float defaultUtilization = runtime.getTargetHeapUtilization();
        runtime.setTargetHeapUtilization(0.8f);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is), 256);
            int count = 0;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                Trace.traceBegin(16384L, line);
                try {
                    Class.forName(line, true, null);
                    ++count;
                }
                catch (ClassNotFoundException e) {
                    Log.w("Zygote", "Class not found for preloading: " + line);
                }
                catch (UnsatisfiedLinkError e) {
                    Log.w("Zygote", "Problem preloading " + line + ": " + e);
                }
                catch (Throwable t) {
                    Log.e("Zygote", "Error preloading " + line + ".", t);
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException(t);
                }
                Trace.traceEnd(16384L);
            }
            Log.i("Zygote", "...preloaded " + count + " classes in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
        }
        catch (IOException e) {
            Log.e("Zygote", "Error reading /system/etc/preloaded-classes.", e);
        }
        finally {
            IoUtils.closeQuietly(is);
            runtime.setTargetHeapUtilization(defaultUtilization);
            Trace.traceBegin(16384L, "PreloadDexCaches");
            runtime.preloadDexCaches();
            Trace.traceEnd(16384L);
            if (droppedPriviliges) {
                try {
                    Os.setreuid(0, 0);
                    Os.setregid(0, 0);
                }
                catch (ErrnoException ex) {
                    throw new RuntimeException("Failed to restore root", ex);
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadResources() {
        VMRuntime runtime = VMRuntime.getRuntime();
        try {
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i("Zygote", "Preloading resources...");
            long startTime = SystemClock.uptimeMillis();
            TypedArray ar = mResources.obtainTypedArray(17236055);
            int N = ZygoteInit.preloadDrawables(ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            startTime = SystemClock.uptimeMillis();
            ar = mResources.obtainTypedArray(17236054);
            N = ZygoteInit.preloadColorStateLists(ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            if (mResources.getBoolean(17956960)) {
                startTime = SystemClock.uptimeMillis();
                ar = mResources.obtainTypedArray(17236056);
                N = ZygoteInit.preloadDrawables(ar);
                ar.recycle();
                Log.i("Zygote", "...preloaded " + N + " resource in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            }
            mResources.finishPreloading();
        }
        catch (RuntimeException e) {
            Log.w("Zygote", "Failure preloading resources", e);
        }
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getColorStateList(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded color resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2 = ar.getResourceId(i, 0);
            if (id2 == 0 || mResources.getDrawable(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded drawable resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(ZygoteConnection.Arguments parsedArgs) throws Zygote.MethodAndArgsCaller {
        String systemServerClasspath;
        Os.umask(OsConstants.S_IRWXG | OsConstants.S_IRWXO);
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if ((systemServerClasspath = Os.getenv("SYSTEMSERVERCLASSPATH")) != null) {
            ZygoteInit.performSystemServerDexOpt(systemServerClasspath);
            boolean profileSystemServer = SystemProperties.getBoolean("dalvik.vm.profilesystemserver", false);
            if (profileSystemServer && (Build.IS_USERDEBUG || Build.IS_ENG)) {
                try {
                    File profileDir = Environment.getDataProfilesDePackageDirectory(1000, "system_server");
                    File profile = new File(profileDir, "primary.prof");
                    profile.getParentFile().mkdirs();
                    profile.createNewFile();
                    String[] codePaths = systemServerClasspath.split(":");
                    VMRuntime.registerAppInfo(profile.getPath(), codePaths);
                }
                catch (Exception e) {
                    Log.wtf("Zygote", "Failed to set up system server profile", e);
                }
            }
        }
        if (parsedArgs.invokeWith != null) {
            String[] args = parsedArgs.remainingArgs;
            if (systemServerClasspath != null) {
                String[] amendedArgs = new String[args.length + 2];
                amendedArgs[0] = "-cp";
                amendedArgs[1] = systemServerClasspath;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)args, (int)0, (Object)amendedArgs, (int)2, (int)args.length);
                args = amendedArgs;
            }
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, VMRuntime.getCurrentInstructionSet(), null, args);
        } else {
            PathClassLoader cl = null;
            if (systemServerClasspath != null) {
                cl = ZygoteInit.createPathClassLoader(systemServerClasspath, parsedArgs.targetSdkVersion);
                Thread.currentThread().setContextClassLoader(cl);
            }
            ZygoteInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, cl);
        }
    }

    private static final PathClassLoader $$robo$$com_android_internal_os_ZygoteInit$createPathClassLoader(String classPath, int targetSdkVersion) {
        String libraryPath = System.getProperty("java.library.path");
        return PathClassLoaderFactory.createClassLoader(classPath, libraryPath, libraryPath, ClassLoader.getSystemClassLoader(), targetSdkVersion, true);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(String classPath) {
        String[] classPathElements = classPath.split(":");
        IInstalld installd = IInstalld.Stub.asInterface(ServiceManager.getService("installd"));
        String instructionSet = VMRuntime.getRuntime().vmInstructionSet();
        String sharedLibraries = "";
        for (String classPathElement : classPathElements) {
            int dexoptNeeded;
            try {
                dexoptNeeded = DexFile.getDexOptNeeded(classPathElement, instructionSet, "speed", false);
            }
            catch (FileNotFoundException ignored) {
                Log.w("Zygote", "Missing classpath element for system server: " + classPathElement);
                continue;
            }
            catch (IOException e) {
                Log.w("Zygote", "Error checking classpath element for system server: " + classPathElement, e);
                dexoptNeeded = 0;
            }
            if (dexoptNeeded != 0) {
                String packageName = "*";
                String outputPath = null;
                boolean dexFlags = false;
                String compilerFilter = "speed";
                String uuid = StorageManager.UUID_PRIVATE_INTERNAL;
                String seInfo = null;
                try {
                    installd.dexopt(classPathElement, 1000, "*", instructionSet, dexoptNeeded, outputPath, 0, "speed", uuid, sharedLibraries, seInfo);
                }
                catch (RemoteException | ServiceSpecificException e) {
                    Log.w("Zygote", "Failed compiling classpath element for system server: " + classPathElement, e);
                }
            }
            if (!sharedLibraries.isEmpty()) {
                sharedLibraries = sharedLibraries + ":";
            }
            sharedLibraries = sharedLibraries + classPathElement;
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(String abiList, String socketName, ZygoteServer zygoteServer) throws Zygote.MethodAndArgsCaller, RuntimeException {
        int pid;
        long capabilities = ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_IPC_LOCK, OsConstants.CAP_KILL, OsConstants.CAP_NET_ADMIN, OsConstants.CAP_NET_BIND_SERVICE, OsConstants.CAP_NET_BROADCAST, OsConstants.CAP_NET_RAW, OsConstants.CAP_SYS_MODULE, OsConstants.CAP_SYS_NICE, OsConstants.CAP_SYS_PTRACE, OsConstants.CAP_SYS_TIME, OsConstants.CAP_SYS_TTY_CONFIG, OsConstants.CAP_WAKE_ALARM);
        if (!SystemProperties.getBoolean("ro.boot.container", false)) {
            capabilities |= ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_BLOCK_SUSPEND);
        }
        String[] args = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1018,1021,1023,1032,3001,3002,3003,3006,3007,3009,3010", "--capabilities=" + capabilities + "," + capabilities, "--nice-name=system_server", "--runtime-args", "com.android.server.SystemServer"};
        ZygoteConnection.Arguments parsedArgs = null;
        try {
            parsedArgs = new ZygoteConnection.Arguments(args);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            pid = Zygote.forkSystemServer(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.debugFlags, null, parsedArgs.permittedCapabilities, parsedArgs.effectiveCapabilities);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        if (pid == 0) {
            if (ZygoteInit.hasSecondZygote(abiList)) {
                ZygoteInit.waitForSecondaryZygote(socketName);
            }
            zygoteServer.closeServerSocket();
            ZygoteInit.handleSystemServerProcess(parsedArgs);
        }
        return true;
    }

    private static final long $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int ... capabilities) {
        long result = 0L;
        for (int capability : capabilities) {
            if (capability < 0 || capability > OsConstants.CAP_LAST_CAP) {
                throw new IllegalArgumentException(String.valueOf(capability));
            }
            result |= 1L << capability;
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$main(String[] argv) {
        ZygoteServer zygoteServer = new ZygoteServer();
        ZygoteHooks.startZygoteNoThreadCreation();
        try {
            Os.setpgid(0, 0);
        }
        catch (ErrnoException ex) {
            throw new RuntimeException("Failed to setpgid(0,0)", ex);
        }
        try {
            if (!"1".equals(SystemProperties.get("sys.boot_completed"))) {
                MetricsLogger.histogram(null, "boot_zygote_init", (int)SystemClock.elapsedRealtime());
            }
            String bootTimeTag = Process.is64Bit() ? "Zygote64Timing" : "Zygote32Timing";
            BootTimingsTraceLog bootTimingsTraceLog = new BootTimingsTraceLog(bootTimeTag, 16384L);
            bootTimingsTraceLog.traceBegin("ZygoteInit");
            RuntimeInit.enableDdms();
            SamplingProfilerIntegration.start();
            boolean startSystemServer = false;
            String socketName = "zygote";
            String abiList = null;
            boolean enableLazyPreload = false;
            for (int i = 1; i < argv.length; ++i) {
                if ("start-system-server".equals(argv[i])) {
                    startSystemServer = true;
                    continue;
                }
                if ("--enable-lazy-preload".equals(argv[i])) {
                    enableLazyPreload = true;
                    continue;
                }
                if (argv[i].startsWith("--abi-list=")) {
                    abiList = argv[i].substring("--abi-list=".length());
                    continue;
                }
                if (argv[i].startsWith("--socket-name=")) {
                    socketName = argv[i].substring("--socket-name=".length());
                    continue;
                }
                throw new RuntimeException("Unknown command line argument: " + argv[i]);
            }
            if (abiList == null) {
                throw new RuntimeException("No ABI list supplied.");
            }
            zygoteServer.registerServerSocket(socketName);
            if (!enableLazyPreload) {
                bootTimingsTraceLog.traceBegin("ZygotePreload");
                EventLog.writeEvent(3020, SystemClock.uptimeMillis());
                ZygoteInit.preload(bootTimingsTraceLog);
                EventLog.writeEvent(3030, SystemClock.uptimeMillis());
                bootTimingsTraceLog.traceEnd();
            } else {
                Zygote.resetNicePriority();
            }
            SamplingProfilerIntegration.writeZygoteSnapshot();
            bootTimingsTraceLog.traceBegin("PostZygoteInitGC");
            ZygoteInit.gcAndFinalize();
            bootTimingsTraceLog.traceEnd();
            bootTimingsTraceLog.traceEnd();
            Trace.setTracingEnabled(false);
            Zygote.nativeUnmountStorageOnInit();
            Seccomp.setPolicy();
            ZygoteHooks.stopZygoteNoThreadCreation();
            if (startSystemServer) {
                ZygoteInit.startSystemServer(abiList, socketName, zygoteServer);
            }
            Log.i("Zygote", "Accepting command socket connections");
            zygoteServer.runSelectLoop(abiList);
            zygoteServer.closeServerSocket();
        }
        catch (Zygote.MethodAndArgsCaller caller) {
            caller.run();
        }
        catch (Throwable ex) {
            Log.e("Zygote", "System zygote died with exception", ex);
            zygoteServer.closeServerSocket();
            throw ex;
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(String abiList) {
        return !SystemProperties.get("ro.product.cpu.abilist").equals(abiList);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(String socketName) {
        String otherZygoteName = "zygote".equals(socketName) ? "zygote_secondary" : "zygote";
        while (true) {
            try {
                ZygoteProcess.ZygoteState zs = ZygoteProcess.ZygoteState.connect(otherZygoteName);
                zs.close();
            }
            catch (IOException ioe) {
                Log.w("Zygote", "Got error connecting to zygote, retrying. msg= " + ioe.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$isPreloadComplete() {
        return sPreloadComplete;
    }

    private void $$robo$$com_android_internal_os_ZygoteInit$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$zygoteInit(int targetSdkVersion, String[] argv, ClassLoader classLoader) throws Zygote.MethodAndArgsCaller {
        Trace.traceBegin(64L, "ZygoteInit");
        RuntimeInit.redirectLogStreams();
        RuntimeInit.commonInit();
        ZygoteInit.nativeZygoteInit();
        RuntimeInit.applicationInit(targetSdkVersion, argv, classLoader);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$nativeZygoteInit() {
    }

    static void preload(BootTimingsTraceLog bootTimingsTraceLog) {
        InvokeDynamicSupport.bootstrapStatic("preload", $$robo$$com_android_internal_os_ZygoteInit$preload(android.util.BootTimingsTraceLog ), 0, (BootTimingsTraceLog)bootTimingsTraceLog);
    }

    public static void lazyPreload() {
        InvokeDynamicSupport.bootstrapStatic("lazyPreload", $$robo$$com_android_internal_os_ZygoteInit$lazyPreload(), 0);
    }

    private static void beginIcuCachePinning() {
        InvokeDynamicSupport.bootstrapStatic("beginIcuCachePinning", $$robo$$com_android_internal_os_ZygoteInit$beginIcuCachePinning(), 0);
    }

    private static void endIcuCachePinning() {
        InvokeDynamicSupport.bootstrapStatic("endIcuCachePinning", $$robo$$com_android_internal_os_ZygoteInit$endIcuCachePinning(), 0);
    }

    private static void preloadSharedLibraries() {
        InvokeDynamicSupport.bootstrapStatic("preloadSharedLibraries", $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries(), 0);
    }

    private static void preloadOpenGL() {
        InvokeDynamicSupport.bootstrapStatic("preloadOpenGL", $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL(), 0);
    }

    private static void preloadTextResources() {
        InvokeDynamicSupport.bootstrapStatic("preloadTextResources", $$robo$$com_android_internal_os_ZygoteInit$preloadTextResources(), 0);
    }

    private static void warmUpJcaProviders() {
        InvokeDynamicSupport.bootstrapStatic("warmUpJcaProviders", $$robo$$com_android_internal_os_ZygoteInit$warmUpJcaProviders(), 0);
    }

    private static void preloadClasses() {
        InvokeDynamicSupport.bootstrapStatic("preloadClasses", $$robo$$com_android_internal_os_ZygoteInit$preloadClasses(), 0);
    }

    private static void preloadResources() {
        InvokeDynamicSupport.bootstrapStatic("preloadResources", $$robo$$com_android_internal_os_ZygoteInit$preloadResources(), 0);
    }

    private static int preloadColorStateLists(TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadColorStateLists", $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(android.content.res.TypedArray ), 0, (TypedArray)typedArray);
    }

    private static int preloadDrawables(TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadDrawables", $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(android.content.res.TypedArray ), 0, (TypedArray)typedArray);
    }

    static void gcAndFinalize() {
        InvokeDynamicSupport.bootstrapStatic("gcAndFinalize", $$robo$$com_android_internal_os_ZygoteInit$gcAndFinalize(), 0);
    }

    private static void handleSystemServerProcess(ZygoteConnection.Arguments arguments) throws Zygote.MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("handleSystemServerProcess", $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(com.android.internal.os.ZygoteConnection$Arguments ), 0, (ZygoteConnection.Arguments)arguments);
    }

    static PathClassLoader createPathClassLoader(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createPathClassLoader", $$robo$$com_android_internal_os_ZygoteInit$createPathClassLoader(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private static void performSystemServerDexOpt(String string2) {
        InvokeDynamicSupport.bootstrapStatic("performSystemServerDexOpt", $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(java.lang.String ), 0, (String)string2);
    }

    private static boolean startSystemServer(String string2, String string3, ZygoteServer zygoteServer) throws Zygote.MethodAndArgsCaller, RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("startSystemServer", $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(java.lang.String java.lang.String com.android.internal.os.ZygoteServer ), 0, (String)string2, (String)string3, (ZygoteServer)zygoteServer);
    }

    private static long posixCapabilitiesAsBits(int ... nArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("posixCapabilitiesAsBits", $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int[] ), 0, (int[])nArray);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$com_android_internal_os_ZygoteInit$main(java.lang.String[] ), 0, (String[])stringArray);
    }

    private static boolean hasSecondZygote(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSecondZygote", $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(java.lang.String ), 0, (String)string2);
    }

    private static void waitForSecondaryZygote(String string2) {
        InvokeDynamicSupport.bootstrapStatic("waitForSecondaryZygote", $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(java.lang.String ), 0, (String)string2);
    }

    static boolean isPreloadComplete() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPreloadComplete", $$robo$$com_android_internal_os_ZygoteInit$isPreloadComplete(), 0);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_ZygoteInit$__constructor__();
    }

    private ZygoteInit() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteInit$__constructor__(), 0, this);
    }

    public static void zygoteInit(int n, String[] stringArray, ClassLoader classLoader) throws Zygote.MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("zygoteInit", $$robo$$com_android_internal_os_ZygoteInit$zygoteInit(int java.lang.String[] java.lang.ClassLoader ), 0, (int)n, (String[])stringArray, (ClassLoader)classLoader);
    }

    private static final native /* synthetic */ void $$robo$$nativeZygoteInit$nativeBinding();

    private static void nativeZygoteInit() {
        InvokeDynamicSupport.bootstrapStatic("nativeZygoteInit", $$robo$$com_android_internal_os_ZygoteInit$nativeZygoteInit(), 1);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteInit)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

