/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.hardware.radio.V1_0.ActivityStatsInfo;
import android.hardware.radio.V1_0.AppStatus;
import android.hardware.radio.V1_0.Call;
import android.hardware.radio.V1_0.CardStatus;
import android.hardware.radio.V1_0.CarrierRestrictions;
import android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.CellInfo;
import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo;
import android.hardware.radio.V1_0.IRadioResponse;
import android.hardware.radio.V1_0.LastCallFailCauseInfo;
import android.hardware.radio.V1_0.LceDataInfo;
import android.hardware.radio.V1_0.LceStatusInfo;
import android.hardware.radio.V1_0.NeighboringCell;
import android.hardware.radio.V1_0.RadioResponseInfo;
import android.hardware.radio.V1_0.SendSmsResult;
import android.hardware.radio.V1_0.SetupDataCallResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemClock;
import android.service.carrier.CarrierIdentifier;
import android.telephony.ModemActivityInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneNumberUtils;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Base64;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.HardwareConfig;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RILRequest;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadioResponse
extends IRadioResponse.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int CDMA_BSI_NO_OF_INTS_STRUCT = 3;
    private static int CDMA_BROADCAST_SMS_NO_OF_SERVICE_CATEGORIES = 31;
    RIL mRil;

    private void $$robo$$com_android_internal_telephony_RadioResponse$__constructor__(RIL ril) {
        this.mRil = ril;
    }

    private static final void $$robo$$com_android_internal_telephony_RadioResponse$sendMessageResponse(Message msg, Object ret) {
        if (msg != null) {
            AsyncResult.forMessage(msg, ret, null);
            msg.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeRequest(int serial) {
        this.mRil.processRequestAck(serial);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getIccCardStatusResponse(RadioResponseInfo responseInfo, CardStatus cardStatus) {
        this.responseIccCardStatus(responseInfo, cardStatus);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPinForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPukForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPin2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPuk2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$changeIccPinForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$changeIccPin2ForAppResponse(RadioResponseInfo responseInfo, int remainingAttempts) {
        this.responseInts(responseInfo, remainingAttempts);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$supplyNetworkDepersonalizationResponse(RadioResponseInfo responseInfo, int retriesRemaining) {
        this.responseInts(responseInfo, retriesRemaining);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCurrentCallsResponse(RadioResponseInfo responseInfo, ArrayList<Call> calls) {
        this.responseCurrentCalls(responseInfo, calls);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$dialResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getIMSIForAppResponse(RadioResponseInfo responseInfo, String imsi) {
        this.responseString(responseInfo, imsi);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$hangupConnectionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$hangupWaitingOrBackgroundResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$hangupForegroundResumeBackgroundResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$switchWaitingOrHoldingAndActiveResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$conferenceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$rejectCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getLastCallFailCauseResponse(RadioResponseInfo responseInfo, LastCallFailCauseInfo fcInfo) {
        this.responseLastCallFailCauseInfo(responseInfo, fcInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getSignalStrengthResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.SignalStrength sigStrength) {
        this.responseSignalStrength(responseInfo, sigStrength);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getVoiceRegistrationStateResponse(RadioResponseInfo responseInfo, VoiceRegStateResult voiceRegResponse) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, voiceRegResponse);
            }
            this.mRil.processResponseDone(rr, responseInfo, voiceRegResponse);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getDataRegistrationStateResponse(RadioResponseInfo responseInfo, DataRegStateResult dataRegResponse) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dataRegResponse);
            }
            this.mRil.processResponseDone(rr, responseInfo, dataRegResponse);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getOperatorResponse(RadioResponseInfo responseInfo, String longName, String shortName, String numeric) {
        this.responseStrings(responseInfo, longName, shortName, numeric);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setRadioPowerResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendSMSExpectMoreResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setupDataCallResponse(RadioResponseInfo responseInfo, SetupDataCallResult setupDataCallResult) {
        this.responseSetupDataCall(responseInfo, setupDataCallResult);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$iccIOForAppResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult iccIo) {
        this.responseIccIo(responseInfo, iccIo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendUssdResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$cancelPendingUssdResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getClirResponse(RadioResponseInfo responseInfo, int n, int m) {
        this.responseInts(responseInfo, n, m);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setClirResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCallForwardStatusResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> callForwardInfos) {
        this.responseCallForwardInfo(responseInfo, callForwardInfos);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCallForwardResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCallWaitingResponse(RadioResponseInfo responseInfo, boolean enable, int serviceClass) {
        this.responseInts(responseInfo, enable ? 1 : 0, serviceClass);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCallWaitingResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeLastIncomingGsmSmsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$acceptCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$deactivateDataCallResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getFacilityLockForAppResponse(RadioResponseInfo responseInfo, int response) {
        this.responseInts(responseInfo, response);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setFacilityLockForAppResponse(RadioResponseInfo responseInfo, int retry) {
        this.responseInts(responseInfo, retry);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setBarringPasswordResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getNetworkSelectionModeResponse(RadioResponseInfo responseInfo, boolean selection) {
        this.responseInts(responseInfo, selection ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setNetworkSelectionModeAutomaticResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setNetworkSelectionModeManualResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getAvailableNetworksResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> networkInfos) {
        this.responseOperatorInfos(responseInfo, networkInfos);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$startDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$stopDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getBasebandVersionResponse(RadioResponseInfo responseInfo, String version) {
        this.responseString(responseInfo, version);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$separateConnectionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setMuteResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getMuteResponse(RadioResponseInfo responseInfo, boolean enable) {
        this.responseInts(responseInfo, enable ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getClipResponse(RadioResponseInfo responseInfo, int status) {
        this.responseInts(responseInfo, status);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getDataCallListResponse(RadioResponseInfo responseInfo, ArrayList<SetupDataCallResult> dataCallResultList) {
        this.responseDataCallList(responseInfo, dataCallResultList);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendOemRilRequestRawResponse(RadioResponseInfo responseInfo, ArrayList<Byte> var2) {
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setSuppServiceNotificationsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$writeSmsToSimResponse(RadioResponseInfo responseInfo, int index) {
        this.responseInts(responseInfo, index);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$deleteSmsOnSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setBandModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getAvailableBandModesResponse(RadioResponseInfo responseInfo, ArrayList<Integer> bandModes) {
        this.responseIntArrayList(responseInfo, bandModes);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendEnvelopeResponse(RadioResponseInfo responseInfo, String commandResponse) {
        this.responseString(responseInfo, commandResponse);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendTerminalResponseToSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$handleStkCallSetupRequestFromSimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$explicitCallTransferResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setPreferredNetworkTypeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getPreferredNetworkTypeResponse(RadioResponseInfo responseInfo, int nwType) {
        this.mRil.mPreferredNetworkType = nwType;
        this.responseInts(responseInfo, nwType);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getNeighboringCidsResponse(RadioResponseInfo responseInfo, ArrayList<NeighboringCell> cells) {
        this.responseCellList(responseInfo, cells);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setLocationUpdatesResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCdmaSubscriptionSourceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCdmaRoamingPreferenceResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCdmaRoamingPreferenceResponse(RadioResponseInfo responseInfo, int type) {
        this.responseInts(responseInfo, type);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setTTYModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getTTYModeResponse(RadioResponseInfo responseInfo, int mode) {
        this.responseInts(responseInfo, mode);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setPreferredVoicePrivacyResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getPreferredVoicePrivacyResponse(RadioResponseInfo responseInfo, boolean enable) {
        this.responseInts(responseInfo, enable ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendCDMAFeatureCodeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendBurstDtmfResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendCdmaSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeLastIncomingCdmaSmsResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getGsmBroadcastConfigResponse(RadioResponseInfo responseInfo, ArrayList<GsmBroadcastSmsConfigInfo> configs) {
        this.responseGmsBroadcastConfig(responseInfo, configs);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setGsmBroadcastConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setGsmBroadcastActivationResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCdmaBroadcastConfigResponse(RadioResponseInfo responseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> configs) {
        this.responseCdmaBroadcastConfig(responseInfo, configs);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCdmaBroadcastConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCdmaBroadcastActivationResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCDMASubscriptionResponse(RadioResponseInfo responseInfo, String mdn, String hSid, String hNid, String min, String prl) {
        this.responseStrings(responseInfo, mdn, hSid, hNid, min, prl);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$writeSmsToRuimResponse(RadioResponseInfo responseInfo, int index) {
        this.responseInts(responseInfo, index);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$deleteSmsOnRuimResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getDeviceIdentityResponse(RadioResponseInfo responseInfo, String imei, String imeisv, String esn, String meid) {
        this.responseStrings(responseInfo, imei, imeisv, esn, meid);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$exitEmergencyCallbackModeResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getSmscAddressResponse(RadioResponseInfo responseInfo, String smsc) {
        this.responseString(responseInfo, smsc);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setSmscAddressResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$reportSmsMemoryStatusResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$reportStkServiceIsRunningResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCdmaSubscriptionSourceResponse(RadioResponseInfo responseInfo, int source) {
        this.responseInts(responseInfo, source);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$requestIsimAuthenticationResponse(RadioResponseInfo responseInfo, String response) {
        this.responseString(responseInfo, response);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeIncomingGsmSmsWithPduResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendEnvelopeWithStatusResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult iccIo) {
        this.responseIccIo(responseInfo, iccIo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getVoiceRadioTechnologyResponse(RadioResponseInfo responseInfo, int rat) {
        this.responseInts(responseInfo, rat);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getCellInfoListResponse(RadioResponseInfo responseInfo, ArrayList<CellInfo> cellInfo) {
        this.responseCellInfoList(responseInfo, cellInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setCellInfoListRateResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setInitialAttachApnResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getImsRegistrationStateResponse(RadioResponseInfo responseInfo, boolean isRegistered, int ratFamily) {
        this.responseInts(responseInfo, isRegistered ? 1 : 0, ratFamily);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendImsSmsResponse(RadioResponseInfo responseInfo, SendSmsResult sms) {
        this.responseSms(responseInfo, sms);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$iccTransmitApduBasicChannelResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseIccIo(responseInfo, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$iccOpenLogicalChannelResponse(RadioResponseInfo responseInfo, int channelId, ArrayList<Byte> selectResponse) {
        ArrayList<Integer> arr = new ArrayList<Integer>();
        arr.add(channelId);
        for (int i = 0; i < selectResponse.size(); ++i) {
            arr.add((int)selectResponse.get(i));
        }
        this.responseIntArrayList(responseInfo, arr);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$iccCloseLogicalChannelResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$iccTransmitApduLogicalChannelResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseIccIo(responseInfo, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$nvReadItemResponse(RadioResponseInfo responseInfo, String result) {
        this.responseString(responseInfo, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$nvWriteItemResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$nvWriteCdmaPrlResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$nvResetConfigResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setUiccSubscriptionResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setDataAllowedResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getHardwareConfigResponse(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> config) {
        this.responseHardwareConfig(responseInfo, config);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$requestIccSimAuthenticationResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        this.responseICC_IOBase64(responseInfo, result);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setDataProfileResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$requestShutdownResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getRadioCapabilityResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            RadioCapability ret = RIL.convertHalRadioCapability(rc, this.mRil);
            if (responseInfo.error == 6 || responseInfo.error == 2) {
                ret = this.mRil.makeStaticRadioCapability();
                responseInfo.error = 0;
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setRadioCapabilityResponse(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        this.responseRadioCapability(responseInfo, rc);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$startLceServiceResponse(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        this.responseLceStatus(responseInfo, statusInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$stopLceServiceResponse(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        this.responseLceStatus(responseInfo, statusInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$pullLceDataResponse(RadioResponseInfo responseInfo, LceDataInfo lceInfo) {
        this.responseLceData(responseInfo, lceInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getModemActivityInfoResponse(RadioResponseInfo responseInfo, ActivityStatsInfo activityInfo) {
        this.responseActivityData(responseInfo, activityInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setAllowedCarriersResponse(RadioResponseInfo responseInfo, int numAllowed) {
        this.responseInts(responseInfo, numAllowed);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$getAllowedCarriersResponse(RadioResponseInfo responseInfo, boolean allAllowed, CarrierRestrictions carriers) {
        this.responseCarrierIdentifiers(responseInfo, allAllowed, carriers);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$sendDeviceStateResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setIndicationFilterResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$setSimCardPowerResponse(RadioResponseInfo responseInfo) {
        this.responseVoid(responseInfo);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseIccCardStatus(RadioResponseInfo responseInfo, CardStatus cardStatus) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccCardStatus iccCardStatus = new IccCardStatus();
            iccCardStatus.setCardState(cardStatus.cardState);
            iccCardStatus.setUniversalPinState(cardStatus.universalPinState);
            iccCardStatus.mGsmUmtsSubscriptionAppIndex = cardStatus.gsmUmtsSubscriptionAppIndex;
            iccCardStatus.mCdmaSubscriptionAppIndex = cardStatus.cdmaSubscriptionAppIndex;
            iccCardStatus.mImsSubscriptionAppIndex = cardStatus.imsSubscriptionAppIndex;
            int numApplications = cardStatus.applications.size();
            if (numApplications > 8) {
                numApplications = 8;
            }
            iccCardStatus.mApplications = new IccCardApplicationStatus[numApplications];
            for (int i = 0; i < numApplications; ++i) {
                AppStatus rilAppStatus = cardStatus.applications.get(i);
                IccCardApplicationStatus appStatus = new IccCardApplicationStatus();
                appStatus.app_type = appStatus.AppTypeFromRILInt(rilAppStatus.appType);
                appStatus.app_state = appStatus.AppStateFromRILInt(rilAppStatus.appState);
                appStatus.perso_substate = appStatus.PersoSubstateFromRILInt(rilAppStatus.persoSubstate);
                appStatus.aid = rilAppStatus.aidPtr;
                appStatus.app_label = rilAppStatus.appLabelPtr;
                appStatus.pin1_replaced = rilAppStatus.pin1Replaced;
                appStatus.pin1 = appStatus.PinStateFromRILInt(rilAppStatus.pin1);
                appStatus.pin2 = appStatus.PinStateFromRILInt(rilAppStatus.pin2);
                iccCardStatus.mApplications[i] = appStatus;
            }
            this.mRil.riljLog("responseIccCardStatus: from HIDL: " + iccCardStatus);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, iccCardStatus);
            }
            this.mRil.processResponseDone(rr, responseInfo, iccCardStatus);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseInts(RadioResponseInfo responseInfo, int ... var) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i = 0; i < var.length; ++i) {
            ints.add(var[i]);
        }
        this.responseIntArrayList(responseInfo, ints);
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseIntArrayList(RadioResponseInfo responseInfo, ArrayList<Integer> var) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int[] ret = new int[var.size()];
            for (int i = 0; i < var.size(); ++i) {
                ret[i] = var.get(i);
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCurrentCalls(RadioResponseInfo responseInfo, ArrayList<Call> calls) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int num = calls.size();
            ArrayList<DriverCall> dcCalls = new ArrayList<DriverCall>(num);
            for (int i = 0; i < num; ++i) {
                DriverCall dc = new DriverCall();
                dc.state = DriverCall.stateFromCLCC(calls.get((int)i).state);
                dc.index = calls.get((int)i).index;
                dc.TOA = calls.get((int)i).toa;
                dc.isMpty = calls.get((int)i).isMpty;
                dc.isMT = calls.get((int)i).isMT;
                dc.als = calls.get((int)i).als;
                dc.isVoice = calls.get((int)i).isVoice;
                dc.isVoicePrivacy = calls.get((int)i).isVoicePrivacy;
                dc.number = calls.get((int)i).number;
                dc.numberPresentation = DriverCall.presentationFromCLIP(calls.get((int)i).numberPresentation);
                dc.name = calls.get((int)i).name;
                dc.namePresentation = DriverCall.presentationFromCLIP(calls.get((int)i).namePresentation);
                if (calls.get((int)i).uusInfo.size() == 1) {
                    dc.uusInfo = new UUSInfo();
                    dc.uusInfo.setType(calls.get((int)i).uusInfo.get((int)0).uusType);
                    dc.uusInfo.setDcs(calls.get((int)i).uusInfo.get((int)0).uusDcs);
                    if (calls.get((int)i).uusInfo.get((int)0).uusData != null) {
                        byte[] userData = calls.get((int)i).uusInfo.get((int)0).uusData.getBytes();
                        dc.uusInfo.setUserData(userData);
                    } else {
                        this.mRil.riljLog("responseCurrentCalls: uusInfo data is null");
                    }
                    this.mRil.riljLogv(String.format("Incoming UUS : type=%d, dcs=%d, length=%d", dc.uusInfo.getType(), dc.uusInfo.getDcs(), dc.uusInfo.getUserData().length));
                    this.mRil.riljLogv("Incoming UUS : data (hex): " + IccUtils.bytesToHexString(dc.uusInfo.getUserData()));
                } else {
                    this.mRil.riljLogv("Incoming UUS : NOT present!");
                }
                dc.number = PhoneNumberUtils.stringFromStringAndTOA(dc.number, dc.TOA);
                dcCalls.add(dc);
                if (dc.isVoicePrivacy) {
                    this.mRil.mVoicePrivacyOnRegistrants.notifyRegistrants();
                    this.mRil.riljLog("InCall VoicePrivacy is enabled");
                    continue;
                }
                this.mRil.mVoicePrivacyOffRegistrants.notifyRegistrants();
                this.mRil.riljLog("InCall VoicePrivacy is disabled");
            }
            Collections.sort(dcCalls);
            if (num == 0 && this.mRil.mTestingEmergencyCall.getAndSet(false) && this.mRil.mEmergencyCallbackModeRegistrant != null) {
                this.mRil.riljLog("responseCurrentCalls: call ended, testing emergency call, notify ECM Registrants");
                this.mRil.mEmergencyCallbackModeRegistrant.notifyRegistrant();
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dcCalls);
            }
            this.mRil.processResponseDone(rr, responseInfo, dcCalls);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseVoid(RadioResponseInfo responseInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            Object ret = null;
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseString(RadioResponseInfo responseInfo, String str) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, str);
            }
            this.mRil.processResponseDone(rr, responseInfo, str);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseStrings(RadioResponseInfo responseInfo, String ... str) {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < str.length; ++i) {
            strings.add(str[i]);
        }
        RadioResponse.responseStringArrayList(this.mRil, responseInfo, strings);
    }

    private static final void $$robo$$com_android_internal_telephony_RadioResponse$responseStringArrayList(RIL ril, RadioResponseInfo responseInfo, ArrayList<String> strings) {
        RILRequest rr = ril.processResponse(responseInfo);
        if (rr != null) {
            String[] ret = new String[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                ret[i] = strings.get(i);
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            ril.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseLastCallFailCauseInfo(RadioResponseInfo responseInfo, LastCallFailCauseInfo fcInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            LastCallFailCause ret = new LastCallFailCause();
            ret.causeCode = fcInfo.causeCode;
            ret.vendorCause = fcInfo.vendorCause;
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseSignalStrength(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.SignalStrength sigStrength) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            SignalStrength ret = RIL.convertHalSignalStrength(sigStrength);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseSms(RadioResponseInfo responseInfo, SendSmsResult sms) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            SmsResponse ret = new SmsResponse(sms.messageRef, sms.ackPDU, sms.errorCode);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseSetupDataCall(RadioResponseInfo responseInfo, SetupDataCallResult setupDataCallResult) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            DataCallResponse ret = RIL.convertDataCallResult(setupDataCallResult);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseIccIo(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccIoResult ret = new IccIoResult(result.sw1, result.sw2, result.simResponse);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCallForwardInfo(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> callForwardInfos) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            CallForwardInfo[] ret = new CallForwardInfo[callForwardInfos.size()];
            for (int i = 0; i < callForwardInfos.size(); ++i) {
                ret[i] = new CallForwardInfo();
                ret[i].status = callForwardInfos.get((int)i).status;
                ret[i].reason = callForwardInfos.get((int)i).reason;
                ret[i].serviceClass = callForwardInfos.get((int)i).serviceClass;
                ret[i].toa = callForwardInfos.get((int)i).toa;
                ret[i].number = callForwardInfos.get((int)i).number;
                ret[i].timeSeconds = callForwardInfos.get((int)i).timeSeconds;
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private static final String $$robo$$com_android_internal_telephony_RadioResponse$convertOpertatorInfoToString(int status) {
        if (status == 0) {
            return "unknown";
        }
        if (status == 1) {
            return "available";
        }
        if (status == 2) {
            return "current";
        }
        if (status == 3) {
            return "forbidden";
        }
        return "";
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseOperatorInfos(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> networkInfos) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<OperatorInfo> ret = new ArrayList<OperatorInfo>();
            for (int i = 0; i < networkInfos.size(); ++i) {
                ret.add(new OperatorInfo(networkInfos.get((int)i).alphaLong, networkInfos.get((int)i).alphaShort, networkInfos.get((int)i).operatorNumeric, RadioResponse.convertOpertatorInfoToString(networkInfos.get((int)i).status)));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseDataCallList(RadioResponseInfo responseInfo, ArrayList<SetupDataCallResult> dataCallResultList) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<DataCallResponse> dcResponseList = new ArrayList<DataCallResponse>();
            for (SetupDataCallResult dcResult : dataCallResultList) {
                dcResponseList.add(RIL.convertDataCallResult(dcResult));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, dcResponseList);
            }
            this.mRil.processResponseDone(rr, responseInfo, dcResponseList);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCellList(RadioResponseInfo responseInfo, ArrayList<NeighboringCell> cells) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<NeighboringCellInfo> ret = new ArrayList<NeighboringCellInfo>();
            int[] subId = SubscriptionManager.getSubId(this.mRil.mPhoneId);
            int radioType = ((TelephonyManager)this.mRil.mContext.getSystemService("phone")).getDataNetworkType(subId[0]);
            if (radioType != 0) {
                for (int i = 0; i < cells.size(); ++i) {
                    int rssi = cells.get((int)i).rssi;
                    String location = cells.get((int)i).cid;
                    NeighboringCellInfo cell = new NeighboringCellInfo(rssi, location, radioType);
                    ret.add(cell);
                }
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseGmsBroadcastConfig(RadioResponseInfo responseInfo, ArrayList<GsmBroadcastSmsConfigInfo> configs) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<SmsBroadcastConfigInfo> ret = new ArrayList<SmsBroadcastConfigInfo>();
            for (int i = 0; i < configs.size(); ++i) {
                ret.add(new SmsBroadcastConfigInfo(configs.get((int)i).fromServiceId, configs.get((int)i).toServiceId, configs.get((int)i).fromCodeScheme, configs.get((int)i).toCodeScheme, configs.get((int)i).selected));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCdmaBroadcastConfig(RadioResponseInfo responseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> configs) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            int[] ret = null;
            int numServiceCategories = configs.size();
            if (numServiceCategories == 0) {
                int numInts = 94;
                ret = new int[numInts];
                ret[0] = 31;
                for (int i = 1; i < numInts; i += 3) {
                    ret[i + 0] = i / 3;
                    ret[i + 1] = 1;
                    ret[i + 2] = 0;
                }
            } else {
                int numInts = numServiceCategories * 3 + 1;
                ret = new int[numInts];
                ret[0] = numServiceCategories;
                int i = 1;
                int j = 0;
                while (j < configs.size()) {
                    ret[i] = configs.get((int)j).serviceCategory;
                    ret[i + 1] = configs.get((int)j).language;
                    ret[i + 2] = configs.get((int)j).selected ? 1 : 0;
                    ++j;
                    i += 3;
                }
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCellInfoList(RadioResponseInfo responseInfo, ArrayList<CellInfo> cellInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<android.telephony.CellInfo> ret = RIL.convertHalCellInfoList(cellInfo);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseActivityData(RadioResponseInfo responseInfo, ActivityStatsInfo activityInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ModemActivityInfo ret = null;
            if (responseInfo.error == 0) {
                int sleepModeTimeMs = activityInfo.sleepModeTimeMs;
                int idleModeTimeMs = activityInfo.idleModeTimeMs;
                int[] txModeTimeMs = new int[5];
                for (int i = 0; i < 5; ++i) {
                    txModeTimeMs[i] = activityInfo.txmModetimeMs[i];
                }
                int rxModeTimeMs = activityInfo.rxModeTimeMs;
                ret = new ModemActivityInfo(SystemClock.elapsedRealtime(), sleepModeTimeMs, idleModeTimeMs, txModeTimeMs, rxModeTimeMs, 0);
            } else {
                ret = new ModemActivityInfo(0L, 0, 0, new int[5], 0, 0);
                responseInfo.error = 0;
            }
            RadioResponse.sendMessageResponse(rr.mResult, ret);
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseHardwareConfig(RadioResponseInfo responseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> config) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<HardwareConfig> ret = RIL.convertHalHwConfigList(config, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseICC_IOBase64(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.IccIoResult result) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            IccIoResult ret = new IccIoResult(result.sw1, result.sw2, !result.simResponse.equals("") ? Base64.decode(result.simResponse, 0) : (byte[])null);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseRadioCapability(RadioResponseInfo responseInfo, android.hardware.radio.V1_0.RadioCapability rc) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            RadioCapability ret = RIL.convertHalRadioCapability(rc, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseLceStatus(RadioResponseInfo responseInfo, LceStatusInfo statusInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            ret.add(statusInfo.lceStatus);
            ret.add(Byte.toUnsignedInt(statusInfo.actualIntervalMs));
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseLceData(RadioResponseInfo responseInfo, LceDataInfo lceInfo) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<Integer> ret = RIL.convertHalLceData(lceInfo, this.mRil);
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private final void $$robo$$com_android_internal_telephony_RadioResponse$responseCarrierIdentifiers(RadioResponseInfo responseInfo, boolean allAllowed, CarrierRestrictions carriers) {
        RILRequest rr = this.mRil.processResponse(responseInfo);
        if (rr != null) {
            ArrayList<CarrierIdentifier> ret = new ArrayList<CarrierIdentifier>();
            for (int i = 0; i < carriers.allowedCarriers.size(); ++i) {
                String mcc = carriers.allowedCarriers.get((int)i).mcc;
                String mnc = carriers.allowedCarriers.get((int)i).mnc;
                String spn = null;
                String imsi = null;
                String gid1 = null;
                String gid2 = null;
                int matchType = carriers.allowedCarriers.get((int)i).matchType;
                String matchData = carriers.allowedCarriers.get((int)i).matchData;
                if (matchType == 1) {
                    spn = matchData;
                } else if (matchType == 2) {
                    imsi = matchData;
                } else if (matchType == 3) {
                    gid1 = matchData;
                } else if (matchType == 4) {
                    gid2 = matchData;
                }
                ret.add(new CarrierIdentifier(mcc, mnc, spn, imsi, gid1, gid2));
            }
            if (responseInfo.error == 0) {
                RadioResponse.sendMessageResponse(rr.mResult, ret);
            }
            this.mRil.processResponseDone(rr, responseInfo, ret);
        }
    }

    private void __constructor__(RIL rIL) {
        this.$$robo$$com_android_internal_telephony_RadioResponse$__constructor__(rIL);
    }

    public RadioResponse(RIL rIL) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_RadioResponse$__constructor__(com.android.internal.telephony.RIL ), 0, this, rIL);
    }

    static void sendMessageResponse(Message message, Object object) {
        InvokeDynamicSupport.bootstrapStatic("sendMessageResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendMessageResponse(android.os.Message java.lang.Object ), 0, (Message)message, (Object)object);
    }

    @Override
    public void acknowledgeRequest(int n) {
        InvokeDynamicSupport.bootstrap("acknowledgeRequest", $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeRequest(int ), 0, this, n);
    }

    @Override
    public void getIccCardStatusResponse(RadioResponseInfo radioResponseInfo, CardStatus cardStatus) {
        InvokeDynamicSupport.bootstrap("getIccCardStatusResponse", $$robo$$com_android_internal_telephony_RadioResponse$getIccCardStatusResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.CardStatus ), 0, this, radioResponseInfo, cardStatus);
    }

    @Override
    public void supplyIccPinForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("supplyIccPinForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPinForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void supplyIccPukForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("supplyIccPukForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPukForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void supplyIccPin2ForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2ForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPin2ForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void supplyIccPuk2ForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2ForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$supplyIccPuk2ForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void changeIccPinForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("changeIccPinForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$changeIccPinForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void changeIccPin2ForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("changeIccPin2ForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$changeIccPin2ForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void supplyNetworkDepersonalizationResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalizationResponse", $$robo$$com_android_internal_telephony_RadioResponse$supplyNetworkDepersonalizationResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void getCurrentCallsResponse(RadioResponseInfo radioResponseInfo, ArrayList<Call> arrayList) {
        InvokeDynamicSupport.bootstrap("getCurrentCallsResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCurrentCallsResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.Call> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void dialResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("dialResponse", $$robo$$com_android_internal_telephony_RadioResponse$dialResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getIMSIForAppResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("getIMSIForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$getIMSIForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void hangupConnectionResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("hangupConnectionResponse", $$robo$$com_android_internal_telephony_RadioResponse$hangupConnectionResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void hangupWaitingOrBackgroundResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackgroundResponse", $$robo$$com_android_internal_telephony_RadioResponse$hangupWaitingOrBackgroundResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void hangupForegroundResumeBackgroundResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackgroundResponse", $$robo$$com_android_internal_telephony_RadioResponse$hangupForegroundResumeBackgroundResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void switchWaitingOrHoldingAndActiveResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActiveResponse", $$robo$$com_android_internal_telephony_RadioResponse$switchWaitingOrHoldingAndActiveResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void conferenceResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("conferenceResponse", $$robo$$com_android_internal_telephony_RadioResponse$conferenceResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void rejectCallResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("rejectCallResponse", $$robo$$com_android_internal_telephony_RadioResponse$rejectCallResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getLastCallFailCauseResponse(RadioResponseInfo radioResponseInfo, LastCallFailCauseInfo lastCallFailCauseInfo) {
        InvokeDynamicSupport.bootstrap("getLastCallFailCauseResponse", $$robo$$com_android_internal_telephony_RadioResponse$getLastCallFailCauseResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LastCallFailCauseInfo ), 0, this, radioResponseInfo, lastCallFailCauseInfo);
    }

    @Override
    public void getSignalStrengthResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("getSignalStrengthResponse", $$robo$$com_android_internal_telephony_RadioResponse$getSignalStrengthResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SignalStrength ), 0, this, radioResponseInfo, signalStrength);
    }

    @Override
    public void getVoiceRegistrationStateResponse(RadioResponseInfo radioResponseInfo, VoiceRegStateResult voiceRegStateResult) {
        InvokeDynamicSupport.bootstrap("getVoiceRegistrationStateResponse", $$robo$$com_android_internal_telephony_RadioResponse$getVoiceRegistrationStateResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.VoiceRegStateResult ), 0, this, radioResponseInfo, voiceRegStateResult);
    }

    @Override
    public void getDataRegistrationStateResponse(RadioResponseInfo radioResponseInfo, DataRegStateResult dataRegStateResult) {
        InvokeDynamicSupport.bootstrap("getDataRegistrationStateResponse", $$robo$$com_android_internal_telephony_RadioResponse$getDataRegistrationStateResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.DataRegStateResult ), 0, this, radioResponseInfo, dataRegStateResult);
    }

    @Override
    public void getOperatorResponse(RadioResponseInfo radioResponseInfo, String string2, String string3, String string4) {
        InvokeDynamicSupport.bootstrap("getOperatorResponse", $$robo$$com_android_internal_telephony_RadioResponse$getOperatorResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String java.lang.String java.lang.String ), 0, this, radioResponseInfo, string2, string3, string4);
    }

    @Override
    public void setRadioPowerResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setRadioPowerResponse", $$robo$$com_android_internal_telephony_RadioResponse$setRadioPowerResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void sendDtmfResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendDtmfResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendDtmfResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void sendSmsResponse(RadioResponseInfo radioResponseInfo, SendSmsResult sendSmsResult) {
        InvokeDynamicSupport.bootstrap("sendSmsResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendSmsResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SendSmsResult ), 0, this, radioResponseInfo, sendSmsResult);
    }

    @Override
    public void sendSMSExpectMoreResponse(RadioResponseInfo radioResponseInfo, SendSmsResult sendSmsResult) {
        InvokeDynamicSupport.bootstrap("sendSMSExpectMoreResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendSMSExpectMoreResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SendSmsResult ), 0, this, radioResponseInfo, sendSmsResult);
    }

    @Override
    public void setupDataCallResponse(RadioResponseInfo radioResponseInfo, SetupDataCallResult setupDataCallResult) {
        InvokeDynamicSupport.bootstrap("setupDataCallResponse", $$robo$$com_android_internal_telephony_RadioResponse$setupDataCallResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SetupDataCallResult ), 0, this, radioResponseInfo, setupDataCallResult);
    }

    @Override
    public void iccIOForAppResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("iccIOForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$iccIOForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    @Override
    public void sendUssdResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendUssdResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void cancelPendingUssdResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("cancelPendingUssdResponse", $$robo$$com_android_internal_telephony_RadioResponse$cancelPendingUssdResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getClirResponse(RadioResponseInfo radioResponseInfo, int n, int n2) {
        InvokeDynamicSupport.bootstrap("getClirResponse", $$robo$$com_android_internal_telephony_RadioResponse$getClirResponse(android.hardware.radio.V1_0.RadioResponseInfo int int ), 0, this, radioResponseInfo, n, n2);
    }

    @Override
    public void setClirResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setClirResponse", $$robo$$com_android_internal_telephony_RadioResponse$setClirResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCallForwardStatusResponse(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("getCallForwardStatusResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCallForwardStatusResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CallForwardInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setCallForwardResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCallForwardResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCallForwardResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCallWaitingResponse(RadioResponseInfo radioResponseInfo, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("getCallWaitingResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCallWaitingResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean int ), 0, this, radioResponseInfo, bl, n);
    }

    @Override
    public void setCallWaitingResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCallWaitingResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCallWaitingResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void acknowledgeLastIncomingGsmSmsResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingGsmSmsResponse", $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeLastIncomingGsmSmsResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void acceptCallResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("acceptCallResponse", $$robo$$com_android_internal_telephony_RadioResponse$acceptCallResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void deactivateDataCallResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("deactivateDataCallResponse", $$robo$$com_android_internal_telephony_RadioResponse$deactivateDataCallResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getFacilityLockForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getFacilityLockForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$getFacilityLockForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void setFacilityLockForAppResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("setFacilityLockForAppResponse", $$robo$$com_android_internal_telephony_RadioResponse$setFacilityLockForAppResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void setBarringPasswordResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setBarringPasswordResponse", $$robo$$com_android_internal_telephony_RadioResponse$setBarringPasswordResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getNetworkSelectionModeResponse(RadioResponseInfo radioResponseInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("getNetworkSelectionModeResponse", $$robo$$com_android_internal_telephony_RadioResponse$getNetworkSelectionModeResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean ), 0, this, radioResponseInfo, bl);
    }

    @Override
    public void setNetworkSelectionModeAutomaticResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomaticResponse", $$robo$$com_android_internal_telephony_RadioResponse$setNetworkSelectionModeAutomaticResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setNetworkSelectionModeManualResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeManualResponse", $$robo$$com_android_internal_telephony_RadioResponse$setNetworkSelectionModeManualResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getAvailableNetworksResponse(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworksResponse", $$robo$$com_android_internal_telephony_RadioResponse$getAvailableNetworksResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.OperatorInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void startDtmfResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("startDtmfResponse", $$robo$$com_android_internal_telephony_RadioResponse$startDtmfResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void stopDtmfResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("stopDtmfResponse", $$robo$$com_android_internal_telephony_RadioResponse$stopDtmfResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getBasebandVersionResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("getBasebandVersionResponse", $$robo$$com_android_internal_telephony_RadioResponse$getBasebandVersionResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void separateConnectionResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("separateConnectionResponse", $$robo$$com_android_internal_telephony_RadioResponse$separateConnectionResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setMuteResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setMuteResponse", $$robo$$com_android_internal_telephony_RadioResponse$setMuteResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getMuteResponse(RadioResponseInfo radioResponseInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("getMuteResponse", $$robo$$com_android_internal_telephony_RadioResponse$getMuteResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean ), 0, this, radioResponseInfo, bl);
    }

    @Override
    public void getClipResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getClipResponse", $$robo$$com_android_internal_telephony_RadioResponse$getClipResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void getDataCallListResponse(RadioResponseInfo radioResponseInfo, ArrayList<SetupDataCallResult> arrayList) {
        InvokeDynamicSupport.bootstrap("getDataCallListResponse", $$robo$$com_android_internal_telephony_RadioResponse$getDataCallListResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.SetupDataCallResult> ), 0, this, radioResponseInfo, arrayList);
    }

    public void sendOemRilRequestRawResponse(RadioResponseInfo radioResponseInfo, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrap("sendOemRilRequestRawResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendOemRilRequestRawResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<java.lang.Byte> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setSuppServiceNotificationsResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setSuppServiceNotificationsResponse", $$robo$$com_android_internal_telephony_RadioResponse$setSuppServiceNotificationsResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void writeSmsToSimResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("writeSmsToSimResponse", $$robo$$com_android_internal_telephony_RadioResponse$writeSmsToSimResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void deleteSmsOnSimResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnSimResponse", $$robo$$com_android_internal_telephony_RadioResponse$deleteSmsOnSimResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setBandModeResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setBandModeResponse", $$robo$$com_android_internal_telephony_RadioResponse$setBandModeResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getAvailableBandModesResponse(RadioResponseInfo radioResponseInfo, ArrayList<Integer> arrayList) {
        InvokeDynamicSupport.bootstrap("getAvailableBandModesResponse", $$robo$$com_android_internal_telephony_RadioResponse$getAvailableBandModesResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<java.lang.Integer> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void sendEnvelopeResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendEnvelopeResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void sendTerminalResponseToSimResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendTerminalResponseToSimResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendTerminalResponseToSimResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void handleStkCallSetupRequestFromSimResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("handleStkCallSetupRequestFromSimResponse", $$robo$$com_android_internal_telephony_RadioResponse$handleStkCallSetupRequestFromSimResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void explicitCallTransferResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("explicitCallTransferResponse", $$robo$$com_android_internal_telephony_RadioResponse$explicitCallTransferResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setPreferredNetworkTypeResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkTypeResponse", $$robo$$com_android_internal_telephony_RadioResponse$setPreferredNetworkTypeResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getPreferredNetworkTypeResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkTypeResponse", $$robo$$com_android_internal_telephony_RadioResponse$getPreferredNetworkTypeResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void getNeighboringCidsResponse(RadioResponseInfo radioResponseInfo, ArrayList<NeighboringCell> arrayList) {
        InvokeDynamicSupport.bootstrap("getNeighboringCidsResponse", $$robo$$com_android_internal_telephony_RadioResponse$getNeighboringCidsResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.NeighboringCell> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setLocationUpdatesResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setLocationUpdatesResponse", $$robo$$com_android_internal_telephony_RadioResponse$setLocationUpdatesResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setCdmaSubscriptionSourceResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscriptionSourceResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCdmaSubscriptionSourceResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setCdmaRoamingPreferenceResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreferenceResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCdmaRoamingPreferenceResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCdmaRoamingPreferenceResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getCdmaRoamingPreferenceResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCdmaRoamingPreferenceResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void setTTYModeResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setTTYModeResponse", $$robo$$com_android_internal_telephony_RadioResponse$setTTYModeResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getTTYModeResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getTTYModeResponse", $$robo$$com_android_internal_telephony_RadioResponse$getTTYModeResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void setPreferredVoicePrivacyResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setPreferredVoicePrivacyResponse", $$robo$$com_android_internal_telephony_RadioResponse$setPreferredVoicePrivacyResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getPreferredVoicePrivacyResponse(RadioResponseInfo radioResponseInfo, boolean bl) {
        InvokeDynamicSupport.bootstrap("getPreferredVoicePrivacyResponse", $$robo$$com_android_internal_telephony_RadioResponse$getPreferredVoicePrivacyResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean ), 0, this, radioResponseInfo, bl);
    }

    @Override
    public void sendCDMAFeatureCodeResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendCDMAFeatureCodeResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendCDMAFeatureCodeResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void sendBurstDtmfResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmfResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendBurstDtmfResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void sendCdmaSmsResponse(RadioResponseInfo radioResponseInfo, SendSmsResult sendSmsResult) {
        InvokeDynamicSupport.bootstrap("sendCdmaSmsResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendCdmaSmsResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SendSmsResult ), 0, this, radioResponseInfo, sendSmsResult);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSmsResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingCdmaSmsResponse", $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeLastIncomingCdmaSmsResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getGsmBroadcastConfigResponse(RadioResponseInfo radioResponseInfo, ArrayList<GsmBroadcastSmsConfigInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("getGsmBroadcastConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$getGsmBroadcastConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setGsmBroadcastConfigResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$setGsmBroadcastConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setGsmBroadcastActivationResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastActivationResponse", $$robo$$com_android_internal_telephony_RadioResponse$setGsmBroadcastActivationResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCdmaBroadcastConfigResponse(RadioResponseInfo radioResponseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("getCdmaBroadcastConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCdmaBroadcastConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setCdmaBroadcastConfigResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCdmaBroadcastConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setCdmaBroadcastActivationResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastActivationResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCdmaBroadcastActivationResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCDMASubscriptionResponse(RadioResponseInfo radioResponseInfo, String string2, String string3, String string4, String string5, String string6) {
        InvokeDynamicSupport.bootstrap("getCDMASubscriptionResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCDMASubscriptionResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, radioResponseInfo, string2, string3, string4, string5, string6);
    }

    @Override
    public void writeSmsToRuimResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("writeSmsToRuimResponse", $$robo$$com_android_internal_telephony_RadioResponse$writeSmsToRuimResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void deleteSmsOnRuimResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnRuimResponse", $$robo$$com_android_internal_telephony_RadioResponse$deleteSmsOnRuimResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getDeviceIdentityResponse(RadioResponseInfo radioResponseInfo, String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("getDeviceIdentityResponse", $$robo$$com_android_internal_telephony_RadioResponse$getDeviceIdentityResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, radioResponseInfo, string2, string3, string4, string5);
    }

    @Override
    public void exitEmergencyCallbackModeResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackModeResponse", $$robo$$com_android_internal_telephony_RadioResponse$exitEmergencyCallbackModeResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getSmscAddressResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("getSmscAddressResponse", $$robo$$com_android_internal_telephony_RadioResponse$getSmscAddressResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void setSmscAddressResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setSmscAddressResponse", $$robo$$com_android_internal_telephony_RadioResponse$setSmscAddressResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void reportSmsMemoryStatusResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("reportSmsMemoryStatusResponse", $$robo$$com_android_internal_telephony_RadioResponse$reportSmsMemoryStatusResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void reportStkServiceIsRunningResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("reportStkServiceIsRunningResponse", $$robo$$com_android_internal_telephony_RadioResponse$reportStkServiceIsRunningResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getCdmaSubscriptionSourceResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getCdmaSubscriptionSourceResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCdmaSubscriptionSourceResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void requestIsimAuthenticationResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("requestIsimAuthenticationResponse", $$robo$$com_android_internal_telephony_RadioResponse$requestIsimAuthenticationResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPduResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("acknowledgeIncomingGsmSmsWithPduResponse", $$robo$$com_android_internal_telephony_RadioResponse$acknowledgeIncomingGsmSmsWithPduResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void sendEnvelopeWithStatusResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatusResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendEnvelopeWithStatusResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    @Override
    public void getVoiceRadioTechnologyResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("getVoiceRadioTechnologyResponse", $$robo$$com_android_internal_telephony_RadioResponse$getVoiceRadioTechnologyResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void getCellInfoListResponse(RadioResponseInfo radioResponseInfo, ArrayList<CellInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("getCellInfoListResponse", $$robo$$com_android_internal_telephony_RadioResponse$getCellInfoListResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CellInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void setCellInfoListRateResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRateResponse", $$robo$$com_android_internal_telephony_RadioResponse$setCellInfoListRateResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setInitialAttachApnResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setInitialAttachApnResponse", $$robo$$com_android_internal_telephony_RadioResponse$setInitialAttachApnResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getImsRegistrationStateResponse(RadioResponseInfo radioResponseInfo, boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("getImsRegistrationStateResponse", $$robo$$com_android_internal_telephony_RadioResponse$getImsRegistrationStateResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean int ), 0, this, radioResponseInfo, bl, n);
    }

    @Override
    public void sendImsSmsResponse(RadioResponseInfo radioResponseInfo, SendSmsResult sendSmsResult) {
        InvokeDynamicSupport.bootstrap("sendImsSmsResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendImsSmsResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SendSmsResult ), 0, this, radioResponseInfo, sendSmsResult);
    }

    @Override
    public void iccTransmitApduBasicChannelResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannelResponse", $$robo$$com_android_internal_telephony_RadioResponse$iccTransmitApduBasicChannelResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    @Override
    public void iccOpenLogicalChannelResponse(RadioResponseInfo radioResponseInfo, int n, ArrayList<Byte> arrayList) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannelResponse", $$robo$$com_android_internal_telephony_RadioResponse$iccOpenLogicalChannelResponse(android.hardware.radio.V1_0.RadioResponseInfo int java.util.ArrayList<java.lang.Byte> ), 0, this, radioResponseInfo, n, arrayList);
    }

    @Override
    public void iccCloseLogicalChannelResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannelResponse", $$robo$$com_android_internal_telephony_RadioResponse$iccCloseLogicalChannelResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void iccTransmitApduLogicalChannelResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannelResponse", $$robo$$com_android_internal_telephony_RadioResponse$iccTransmitApduLogicalChannelResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    @Override
    public void nvReadItemResponse(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("nvReadItemResponse", $$robo$$com_android_internal_telephony_RadioResponse$nvReadItemResponse(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    @Override
    public void nvWriteItemResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("nvWriteItemResponse", $$robo$$com_android_internal_telephony_RadioResponse$nvWriteItemResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void nvWriteCdmaPrlResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrlResponse", $$robo$$com_android_internal_telephony_RadioResponse$nvWriteCdmaPrlResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void nvResetConfigResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("nvResetConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$nvResetConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setUiccSubscriptionResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setUiccSubscriptionResponse", $$robo$$com_android_internal_telephony_RadioResponse$setUiccSubscriptionResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setDataAllowedResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setDataAllowedResponse", $$robo$$com_android_internal_telephony_RadioResponse$setDataAllowedResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getHardwareConfigResponse(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> arrayList) {
        InvokeDynamicSupport.bootstrap("getHardwareConfigResponse", $$robo$$com_android_internal_telephony_RadioResponse$getHardwareConfigResponse(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.HardwareConfig> ), 0, this, radioResponseInfo, arrayList);
    }

    @Override
    public void requestIccSimAuthenticationResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("requestIccSimAuthenticationResponse", $$robo$$com_android_internal_telephony_RadioResponse$requestIccSimAuthenticationResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    @Override
    public void setDataProfileResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setDataProfileResponse", $$robo$$com_android_internal_telephony_RadioResponse$setDataProfileResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void requestShutdownResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("requestShutdownResponse", $$robo$$com_android_internal_telephony_RadioResponse$requestShutdownResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void getRadioCapabilityResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.RadioCapability radioCapability) {
        InvokeDynamicSupport.bootstrap("getRadioCapabilityResponse", $$robo$$com_android_internal_telephony_RadioResponse$getRadioCapabilityResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.RadioCapability ), 0, this, radioResponseInfo, radioCapability);
    }

    @Override
    public void setRadioCapabilityResponse(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.RadioCapability radioCapability) {
        InvokeDynamicSupport.bootstrap("setRadioCapabilityResponse", $$robo$$com_android_internal_telephony_RadioResponse$setRadioCapabilityResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.RadioCapability ), 0, this, radioResponseInfo, radioCapability);
    }

    @Override
    public void startLceServiceResponse(RadioResponseInfo radioResponseInfo, LceStatusInfo lceStatusInfo) {
        InvokeDynamicSupport.bootstrap("startLceServiceResponse", $$robo$$com_android_internal_telephony_RadioResponse$startLceServiceResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LceStatusInfo ), 0, this, radioResponseInfo, lceStatusInfo);
    }

    @Override
    public void stopLceServiceResponse(RadioResponseInfo radioResponseInfo, LceStatusInfo lceStatusInfo) {
        InvokeDynamicSupport.bootstrap("stopLceServiceResponse", $$robo$$com_android_internal_telephony_RadioResponse$stopLceServiceResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LceStatusInfo ), 0, this, radioResponseInfo, lceStatusInfo);
    }

    @Override
    public void pullLceDataResponse(RadioResponseInfo radioResponseInfo, LceDataInfo lceDataInfo) {
        InvokeDynamicSupport.bootstrap("pullLceDataResponse", $$robo$$com_android_internal_telephony_RadioResponse$pullLceDataResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LceDataInfo ), 0, this, radioResponseInfo, lceDataInfo);
    }

    @Override
    public void getModemActivityInfoResponse(RadioResponseInfo radioResponseInfo, ActivityStatsInfo activityStatsInfo) {
        InvokeDynamicSupport.bootstrap("getModemActivityInfoResponse", $$robo$$com_android_internal_telephony_RadioResponse$getModemActivityInfoResponse(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.ActivityStatsInfo ), 0, this, radioResponseInfo, activityStatsInfo);
    }

    @Override
    public void setAllowedCarriersResponse(RadioResponseInfo radioResponseInfo, int n) {
        InvokeDynamicSupport.bootstrap("setAllowedCarriersResponse", $$robo$$com_android_internal_telephony_RadioResponse$setAllowedCarriersResponse(android.hardware.radio.V1_0.RadioResponseInfo int ), 0, this, radioResponseInfo, n);
    }

    @Override
    public void getAllowedCarriersResponse(RadioResponseInfo radioResponseInfo, boolean bl, CarrierRestrictions carrierRestrictions) {
        InvokeDynamicSupport.bootstrap("getAllowedCarriersResponse", $$robo$$com_android_internal_telephony_RadioResponse$getAllowedCarriersResponse(android.hardware.radio.V1_0.RadioResponseInfo boolean android.hardware.radio.V1_0.CarrierRestrictions ), 0, this, radioResponseInfo, bl, carrierRestrictions);
    }

    @Override
    public void sendDeviceStateResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("sendDeviceStateResponse", $$robo$$com_android_internal_telephony_RadioResponse$sendDeviceStateResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setIndicationFilterResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setIndicationFilterResponse", $$robo$$com_android_internal_telephony_RadioResponse$setIndicationFilterResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    @Override
    public void setSimCardPowerResponse(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("setSimCardPowerResponse", $$robo$$com_android_internal_telephony_RadioResponse$setSimCardPowerResponse(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    private void responseIccCardStatus(RadioResponseInfo radioResponseInfo, CardStatus cardStatus) {
        InvokeDynamicSupport.bootstrap("responseIccCardStatus", $$robo$$com_android_internal_telephony_RadioResponse$responseIccCardStatus(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.CardStatus ), 0, this, radioResponseInfo, cardStatus);
    }

    private void responseInts(RadioResponseInfo radioResponseInfo, int ... nArray) {
        InvokeDynamicSupport.bootstrap("responseInts", $$robo$$com_android_internal_telephony_RadioResponse$responseInts(android.hardware.radio.V1_0.RadioResponseInfo int[] ), 0, this, radioResponseInfo, nArray);
    }

    private void responseIntArrayList(RadioResponseInfo radioResponseInfo, ArrayList<Integer> arrayList) {
        InvokeDynamicSupport.bootstrap("responseIntArrayList", $$robo$$com_android_internal_telephony_RadioResponse$responseIntArrayList(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<java.lang.Integer> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseCurrentCalls(RadioResponseInfo radioResponseInfo, ArrayList<Call> arrayList) {
        InvokeDynamicSupport.bootstrap("responseCurrentCalls", $$robo$$com_android_internal_telephony_RadioResponse$responseCurrentCalls(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.Call> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseVoid(RadioResponseInfo radioResponseInfo) {
        InvokeDynamicSupport.bootstrap("responseVoid", $$robo$$com_android_internal_telephony_RadioResponse$responseVoid(android.hardware.radio.V1_0.RadioResponseInfo ), 0, this, radioResponseInfo);
    }

    private void responseString(RadioResponseInfo radioResponseInfo, String string2) {
        InvokeDynamicSupport.bootstrap("responseString", $$robo$$com_android_internal_telephony_RadioResponse$responseString(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String ), 0, this, radioResponseInfo, string2);
    }

    private void responseStrings(RadioResponseInfo radioResponseInfo, String ... stringArray) {
        InvokeDynamicSupport.bootstrap("responseStrings", $$robo$$com_android_internal_telephony_RadioResponse$responseStrings(android.hardware.radio.V1_0.RadioResponseInfo java.lang.String[] ), 0, this, radioResponseInfo, stringArray);
    }

    static void responseStringArrayList(RIL rIL, RadioResponseInfo radioResponseInfo, ArrayList<String> arrayList) {
        InvokeDynamicSupport.bootstrapStatic("responseStringArrayList", $$robo$$com_android_internal_telephony_RadioResponse$responseStringArrayList(com.android.internal.telephony.RIL android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<java.lang.String> ), 0, (RIL)rIL, (RadioResponseInfo)radioResponseInfo, arrayList);
    }

    private void responseLastCallFailCauseInfo(RadioResponseInfo radioResponseInfo, LastCallFailCauseInfo lastCallFailCauseInfo) {
        InvokeDynamicSupport.bootstrap("responseLastCallFailCauseInfo", $$robo$$com_android_internal_telephony_RadioResponse$responseLastCallFailCauseInfo(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LastCallFailCauseInfo ), 0, this, radioResponseInfo, lastCallFailCauseInfo);
    }

    private void responseSignalStrength(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("responseSignalStrength", $$robo$$com_android_internal_telephony_RadioResponse$responseSignalStrength(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SignalStrength ), 0, this, radioResponseInfo, signalStrength);
    }

    private void responseSms(RadioResponseInfo radioResponseInfo, SendSmsResult sendSmsResult) {
        InvokeDynamicSupport.bootstrap("responseSms", $$robo$$com_android_internal_telephony_RadioResponse$responseSms(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SendSmsResult ), 0, this, radioResponseInfo, sendSmsResult);
    }

    private void responseSetupDataCall(RadioResponseInfo radioResponseInfo, SetupDataCallResult setupDataCallResult) {
        InvokeDynamicSupport.bootstrap("responseSetupDataCall", $$robo$$com_android_internal_telephony_RadioResponse$responseSetupDataCall(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.SetupDataCallResult ), 0, this, radioResponseInfo, setupDataCallResult);
    }

    private void responseIccIo(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("responseIccIo", $$robo$$com_android_internal_telephony_RadioResponse$responseIccIo(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    private void responseCallForwardInfo(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.CallForwardInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("responseCallForwardInfo", $$robo$$com_android_internal_telephony_RadioResponse$responseCallForwardInfo(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CallForwardInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    private static String convertOpertatorInfoToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("convertOpertatorInfoToString", $$robo$$com_android_internal_telephony_RadioResponse$convertOpertatorInfoToString(int ), 0, (int)n);
    }

    private void responseOperatorInfos(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.OperatorInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("responseOperatorInfos", $$robo$$com_android_internal_telephony_RadioResponse$responseOperatorInfos(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.OperatorInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseDataCallList(RadioResponseInfo radioResponseInfo, ArrayList<SetupDataCallResult> arrayList) {
        InvokeDynamicSupport.bootstrap("responseDataCallList", $$robo$$com_android_internal_telephony_RadioResponse$responseDataCallList(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.SetupDataCallResult> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseCellList(RadioResponseInfo radioResponseInfo, ArrayList<NeighboringCell> arrayList) {
        InvokeDynamicSupport.bootstrap("responseCellList", $$robo$$com_android_internal_telephony_RadioResponse$responseCellList(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.NeighboringCell> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseGmsBroadcastConfig(RadioResponseInfo radioResponseInfo, ArrayList<GsmBroadcastSmsConfigInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("responseGmsBroadcastConfig", $$robo$$com_android_internal_telephony_RadioResponse$responseGmsBroadcastConfig(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.GsmBroadcastSmsConfigInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseCdmaBroadcastConfig(RadioResponseInfo radioResponseInfo, ArrayList<CdmaBroadcastSmsConfigInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("responseCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_RadioResponse$responseCdmaBroadcastConfig(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CdmaBroadcastSmsConfigInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseCellInfoList(RadioResponseInfo radioResponseInfo, ArrayList<CellInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("responseCellInfoList", $$robo$$com_android_internal_telephony_RadioResponse$responseCellInfoList(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.CellInfo> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseActivityData(RadioResponseInfo radioResponseInfo, ActivityStatsInfo activityStatsInfo) {
        InvokeDynamicSupport.bootstrap("responseActivityData", $$robo$$com_android_internal_telephony_RadioResponse$responseActivityData(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.ActivityStatsInfo ), 0, this, radioResponseInfo, activityStatsInfo);
    }

    private void responseHardwareConfig(RadioResponseInfo radioResponseInfo, ArrayList<android.hardware.radio.V1_0.HardwareConfig> arrayList) {
        InvokeDynamicSupport.bootstrap("responseHardwareConfig", $$robo$$com_android_internal_telephony_RadioResponse$responseHardwareConfig(android.hardware.radio.V1_0.RadioResponseInfo java.util.ArrayList<android.hardware.radio.V1_0.HardwareConfig> ), 0, this, radioResponseInfo, arrayList);
    }

    private void responseICC_IOBase64(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("responseICC_IOBase64", $$robo$$com_android_internal_telephony_RadioResponse$responseICC_IOBase64(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.IccIoResult ), 0, this, radioResponseInfo, iccIoResult);
    }

    private void responseRadioCapability(RadioResponseInfo radioResponseInfo, android.hardware.radio.V1_0.RadioCapability radioCapability) {
        InvokeDynamicSupport.bootstrap("responseRadioCapability", $$robo$$com_android_internal_telephony_RadioResponse$responseRadioCapability(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.RadioCapability ), 0, this, radioResponseInfo, radioCapability);
    }

    private void responseLceStatus(RadioResponseInfo radioResponseInfo, LceStatusInfo lceStatusInfo) {
        InvokeDynamicSupport.bootstrap("responseLceStatus", $$robo$$com_android_internal_telephony_RadioResponse$responseLceStatus(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LceStatusInfo ), 0, this, radioResponseInfo, lceStatusInfo);
    }

    private void responseLceData(RadioResponseInfo radioResponseInfo, LceDataInfo lceDataInfo) {
        InvokeDynamicSupport.bootstrap("responseLceData", $$robo$$com_android_internal_telephony_RadioResponse$responseLceData(android.hardware.radio.V1_0.RadioResponseInfo android.hardware.radio.V1_0.LceDataInfo ), 0, this, radioResponseInfo, lceDataInfo);
    }

    private void responseCarrierIdentifiers(RadioResponseInfo radioResponseInfo, boolean bl, CarrierRestrictions carrierRestrictions) {
        InvokeDynamicSupport.bootstrap("responseCarrierIdentifiers", $$robo$$com_android_internal_telephony_RadioResponse$responseCarrierIdentifiers(android.hardware.radio.V1_0.RadioResponseInfo boolean android.hardware.radio.V1_0.CarrierRestrictions ), 0, this, radioResponseInfo, bl, carrierRestrictions);
    }

    public /* synthetic */ RadioResponse() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadioResponse)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

