/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.content.res.Resources;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.cat.CatLog;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.ComprehensionTlv;
import com.android.internal.telephony.cat.DeviceIdentities;
import com.android.internal.telephony.cat.Duration;
import com.android.internal.telephony.cat.FontSize;
import com.android.internal.telephony.cat.IconId;
import com.android.internal.telephony.cat.Item;
import com.android.internal.telephony.cat.ItemsIconId;
import com.android.internal.telephony.cat.ResultCode;
import com.android.internal.telephony.cat.ResultException;
import com.android.internal.telephony.cat.TextAlignment;
import com.android.internal.telephony.cat.TextAttribute;
import com.android.internal.telephony.cat.TextColor;
import com.android.internal.telephony.uicc.IccUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class ValueParser
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_telephony_cat_ValueParser$__constructor__() {
    }

    private static final CommandDetails $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveCommandDetails(ComprehensionTlv ctlv) throws ResultException {
        CommandDetails cmdDet = new CommandDetails();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            cmdDet.compRequired = ctlv.isComprehensionRequired();
            cmdDet.commandNumber = rawValue[valueIndex] & 0xFF;
            cmdDet.typeOfCommand = rawValue[valueIndex + 1] & 0xFF;
            cmdDet.commandQualifier = rawValue[valueIndex + 2] & 0xFF;
            return cmdDet;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    private static final DeviceIdentities $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveDeviceIdentities(ComprehensionTlv ctlv) throws ResultException {
        DeviceIdentities devIds = new DeviceIdentities();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            devIds.sourceId = rawValue[valueIndex] & 0xFF;
            devIds.destinationId = rawValue[valueIndex + 1] & 0xFF;
            return devIds;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.REQUIRED_VALUES_MISSING);
        }
    }

    private static final Duration $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveDuration(ComprehensionTlv ctlv) throws ResultException {
        int timeInterval = 0;
        Duration.TimeUnit timeUnit = Duration.TimeUnit.SECOND;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            timeUnit = Duration.TimeUnit.values()[rawValue[valueIndex] & 0xFF];
            timeInterval = rawValue[valueIndex + 1] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return new Duration(timeInterval, timeUnit);
    }

    private static final Item $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItem(ComprehensionTlv ctlv) throws ResultException {
        Item item = null;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int length = ctlv.getLength();
        if (length != 0) {
            int textLen = length - 1;
            try {
                int id2 = rawValue[valueIndex] & 0xFF;
                String text = IccUtils.adnStringFieldToString(rawValue, valueIndex + 1, textLen);
                item = new Item(id2, text);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return item;
    }

    private static final int $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItemId(ComprehensionTlv ctlv) throws ResultException {
        int id2 = 0;
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            id2 = rawValue[valueIndex] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    private static final IconId $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveIconId(ComprehensionTlv ctlv) throws ResultException {
        IconId id2 = new IconId();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        try {
            id2.selfExplanatory = (rawValue[valueIndex++] & 0xFF) == 0;
            id2.recordNumber = rawValue[valueIndex] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    private static final ItemsIconId $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItemsIconId(ComprehensionTlv ctlv) throws ResultException {
        CatLog.d("ValueParser", "retrieveItemsIconId:");
        ItemsIconId id2 = new ItemsIconId();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int numOfItems = ctlv.getLength() - 1;
        id2.recordNumbers = new int[numOfItems];
        try {
            id2.selfExplanatory = (rawValue[valueIndex++] & 0xFF) == 0;
            int index = 0;
            while (index < numOfItems) {
                id2.recordNumbers[index++] = rawValue[valueIndex++];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        return id2;
    }

    private static final List<TextAttribute> $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveTextAttribute(ComprehensionTlv ctlv) throws ResultException {
        ArrayList<TextAttribute> lst = new ArrayList<TextAttribute>();
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        int length = ctlv.getLength();
        if (length != 0) {
            int itemCount = length / 4;
            try {
                int i = 0;
                while (i < itemCount) {
                    int start = rawValue[valueIndex] & 0xFF;
                    int textLength = rawValue[valueIndex + 1] & 0xFF;
                    int format = rawValue[valueIndex + 2] & 0xFF;
                    int colorValue = rawValue[valueIndex + 3] & 0xFF;
                    int alignValue = format & 3;
                    TextAlignment align = TextAlignment.fromInt(alignValue);
                    int sizeValue = format >> 2 & 3;
                    FontSize size = FontSize.fromInt(sizeValue);
                    if (size == null) {
                        size = FontSize.NORMAL;
                    }
                    boolean bold = (format & 0x10) != 0;
                    boolean italic = (format & 0x20) != 0;
                    boolean underlined = (format & 0x40) != 0;
                    boolean strikeThrough = (format & 0x80) != 0;
                    TextColor color2 = TextColor.fromInt(colorValue);
                    TextAttribute attr2 = new TextAttribute(start, textLength, align, size, bold, italic, underlined, strikeThrough, color2);
                    lst.add(attr2);
                    ++i;
                    valueIndex += 4;
                }
                return lst;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
        }
        return null;
    }

    private static final String $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveAlphaId(ComprehensionTlv ctlv) throws ResultException {
        if (ctlv != null) {
            byte[] rawValue = ctlv.getRawValue();
            int valueIndex = ctlv.getValueIndex();
            int length = ctlv.getLength();
            if (length != 0) {
                try {
                    return IccUtils.adnStringFieldToString(rawValue, valueIndex, length);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
                }
            }
            CatLog.d("ValueParser", "Alpha Id length=" + length);
            return null;
        }
        boolean noAlphaUsrCnf = false;
        Resources resource = Resources.getSystem();
        try {
            noAlphaUsrCnf = resource.getBoolean(17957007);
        }
        catch (Resources.NotFoundException e) {
            noAlphaUsrCnf = false;
        }
        return noAlphaUsrCnf ? null : "Default Message";
    }

    private static final String $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveTextString(ComprehensionTlv ctlv) throws ResultException {
        byte[] rawValue = ctlv.getRawValue();
        int valueIndex = ctlv.getValueIndex();
        byte codingScheme = 0;
        String text = null;
        int textLen = ctlv.getLength();
        if (textLen == 0) {
            return text;
        }
        --textLen;
        try {
            codingScheme = (byte)(rawValue[valueIndex] & 0xC);
            if (codingScheme == 0) {
                text = GsmAlphabet.gsm7BitPackedToString(rawValue, valueIndex + 1, textLen * 8 / 7);
            } else if (codingScheme == 4) {
                text = GsmAlphabet.gsm8BitUnpackedToString(rawValue, valueIndex + 1, textLen);
            } else if (codingScheme == 8) {
                text = new String(rawValue, valueIndex + 1, textLen, "UTF-16");
            } else {
                throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
            }
            return text;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
        catch (UnsupportedEncodingException e) {
            throw new ResultException(ResultCode.CMD_DATA_NOT_UNDERSTOOD);
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_cat_ValueParser$__constructor__();
    }

    ValueParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cat_ValueParser$__constructor__(), 0, this);
    }

    static CommandDetails retrieveCommandDetails(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveCommandDetails", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveCommandDetails(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static DeviceIdentities retrieveDeviceIdentities(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveDeviceIdentities", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveDeviceIdentities(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static Duration retrieveDuration(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveDuration", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveDuration(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static Item retrieveItem(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveItem", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItem(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static int retrieveItemId(ComprehensionTlv comprehensionTlv) throws ResultException {
        return (int)InvokeDynamicSupport.bootstrapStatic("retrieveItemId", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItemId(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static IconId retrieveIconId(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveIconId", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveIconId(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static ItemsIconId retrieveItemsIconId(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveItemsIconId", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveItemsIconId(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static List<TextAttribute> retrieveTextAttribute(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveTextAttribute", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveTextAttribute(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static String retrieveAlphaId(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveAlphaId", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveAlphaId(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    static String retrieveTextString(ComprehensionTlv comprehensionTlv) throws ResultException {
        return InvokeDynamicSupport.bootstrapStatic("retrieveTextString", $$robo$$com_android_internal_telephony_cat_ValueParser$retrieveTextString(com.android.internal.telephony.cat.ComprehensionTlv ), 0, (ComprehensionTlv)comprehensionTlv);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ValueParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

