/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.UUID;
import libcore.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BitUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$com_android_internal_util_BitUtils$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(long a, long b, long mask) {
        return (a & mask) == (b & mask);
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte a, byte b, byte mask) {
        return (a & mask) == (b & mask);
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte[] a, byte[] b, byte[] mask) {
        if (a == null || b == null) {
            return a == b;
        }
        Preconditions.checkArgument(a.length == b.length, "Inputs must be of same size");
        if (mask == null) {
            return Arrays.equals(a, b);
        }
        Preconditions.checkArgument(a.length == mask.length, "Mask must be of same size as inputs");
        for (int i = 0; i < mask.length; ++i) {
            if (BitUtils.maskedEquals(a[i], b[i], mask[i])) continue;
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$com_android_internal_util_BitUtils$maskedEquals(UUID a, UUID b, UUID mask) {
        if (mask == null) {
            return Objects.equal(a, b);
        }
        return BitUtils.maskedEquals(a.getLeastSignificantBits(), b.getLeastSignificantBits(), mask.getLeastSignificantBits()) && BitUtils.maskedEquals(a.getMostSignificantBits(), b.getMostSignificantBits(), mask.getMostSignificantBits());
    }

    private static final int[] $$robo$$com_android_internal_util_BitUtils$unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val > 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>= 1;
            ++bitPos;
        }
        return result;
    }

    private static final long $$robo$$com_android_internal_util_BitUtils$packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= (long)(1 << b);
        }
        return packed;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_util_BitUtils$__constructor__();
    }

    private BitUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_util_BitUtils$__constructor__(), 0, this);
    }

    public static boolean maskedEquals(long l, long l2, long l3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(long long long ), 0, (long)l, (long)l2, (long)l3);
    }

    public static boolean maskedEquals(byte by, byte by2, byte by3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte byte byte ), 0, (byte)by, (byte)by2, (byte)by3);
    }

    public static boolean maskedEquals(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(byte[] byte[] byte[] ), 0, (byte[])byArray, (byte[])byArray2, (byte[])byArray3);
    }

    public static boolean maskedEquals(UUID uUID, UUID uUID2, UUID uUID3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("maskedEquals", $$robo$$com_android_internal_util_BitUtils$maskedEquals(java.util.UUID java.util.UUID java.util.UUID ), 0, (UUID)uUID, (UUID)uUID2, (UUID)uUID3);
    }

    public static int[] unpackBits(long l) {
        return InvokeDynamicSupport.bootstrapStatic("unpackBits", $$robo$$com_android_internal_util_BitUtils$unpackBits(long ), 0, (long)l);
    }

    public static long packBits(int[] nArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("packBits", $$robo$$com_android_internal_util_BitUtils$packBits(int[] ), 0, (int[])nArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

