/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.content.Context;
import android.graphics.Rect;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.widget.TextView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TooltipPopup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TooltipPopup";
    private Context mContext;
    private View mContentView;
    private TextView mMessageView;
    private WindowManager.LayoutParams mLayoutParams;
    private Rect mTmpDisplayFrame;
    private int[] mTmpAnchorPos;
    private int[] mTmpAppPos;

    private void $$robo$$com_android_internal_view_TooltipPopup$__constructor__(Context context) {
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mTmpDisplayFrame = new Rect();
        this.mTmpAnchorPos = new int[2];
        this.mTmpAppPos = new int[2];
        this.mContext = context;
        this.mContentView = LayoutInflater.from(this.mContext).inflate(17367298, null);
        this.mMessageView = (TextView)this.mContentView.findViewById(16908299);
        this.mLayoutParams.setTitle(this.mContext.getString(17040892));
        this.mLayoutParams.packageName = this.mContext.getOpPackageName();
        this.mLayoutParams.type = 1005;
        this.mLayoutParams.width = -2;
        this.mLayoutParams.height = -2;
        this.mLayoutParams.format = -3;
        this.mLayoutParams.windowAnimations = 0x1030300;
        this.mLayoutParams.flags = 24;
    }

    private final void $$robo$$com_android_internal_view_TooltipPopup$show(View anchorView, int anchorX, int anchorY, boolean fromTouch, CharSequence tooltipText) {
        if (this.isShowing()) {
            this.hide();
        }
        this.mMessageView.setText(tooltipText);
        this.computePosition(anchorView, anchorX, anchorY, fromTouch, this.mLayoutParams);
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        wm.addView(this.mContentView, this.mLayoutParams);
    }

    private final void $$robo$$com_android_internal_view_TooltipPopup$hide() {
        if (!this.isShowing()) {
            return;
        }
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        wm.removeView(this.mContentView);
    }

    private final View $$robo$$com_android_internal_view_TooltipPopup$getContentView() {
        return this.mContentView;
    }

    private final boolean $$robo$$com_android_internal_view_TooltipPopup$isShowing() {
        return this.mContentView.getParent() != null;
    }

    private final void $$robo$$com_android_internal_view_TooltipPopup$computePosition(View anchorView, int anchorX, int anchorY, boolean fromTouch, WindowManager.LayoutParams outParams) {
        int offsetAbove;
        int offsetBelow;
        outParams.token = anchorView.getWindowToken();
        int tooltipPreciseAnchorThreshold = this.mContext.getResources().getDimensionPixelOffset(17105282);
        int offsetX = anchorView.getWidth() >= tooltipPreciseAnchorThreshold ? anchorX : anchorView.getWidth() / 2;
        if (anchorView.getHeight() >= tooltipPreciseAnchorThreshold) {
            int offsetExtra = this.mContext.getResources().getDimensionPixelOffset(17105281);
            offsetBelow = anchorY + offsetExtra;
            offsetAbove = anchorY - offsetExtra;
        } else {
            offsetBelow = anchorView.getHeight();
            offsetAbove = 0;
        }
        outParams.gravity = 49;
        int tooltipOffset = this.mContext.getResources().getDimensionPixelOffset(fromTouch ? 17105285 : 17105284);
        View appView = WindowManagerGlobal.getInstance().getWindowView(anchorView.getApplicationWindowToken());
        if (appView == null) {
            Slog.e("TooltipPopup", "Cannot find app view");
            return;
        }
        appView.getWindowVisibleDisplayFrame(this.mTmpDisplayFrame);
        appView.getLocationOnScreen(this.mTmpAppPos);
        anchorView.getLocationOnScreen(this.mTmpAnchorPos);
        this.mTmpAnchorPos[0] = this.mTmpAnchorPos[0] - this.mTmpAppPos[0];
        this.mTmpAnchorPos[1] = this.mTmpAnchorPos[1] - this.mTmpAppPos[1];
        outParams.x = this.mTmpAnchorPos[0] + offsetX - this.mTmpDisplayFrame.width() / 2;
        int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.mContentView.measure(spec, spec);
        int tooltipHeight = this.mContentView.getMeasuredHeight();
        int yAbove = this.mTmpAnchorPos[1] + offsetAbove - tooltipOffset - tooltipHeight;
        int yBelow = this.mTmpAnchorPos[1] + offsetBelow + tooltipOffset;
        outParams.y = fromTouch ? (yAbove >= 0 ? yAbove : yBelow) : (yBelow + tooltipHeight <= this.mTmpDisplayFrame.height() ? yBelow : yAbove);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_view_TooltipPopup$__constructor__(context);
    }

    public TooltipPopup(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_TooltipPopup$__constructor__(android.content.Context ), 0, this, context);
    }

    public void show(View view, int n, int n2, boolean bl, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_TooltipPopup$show(android.view.View int int boolean java.lang.CharSequence ), 0, this, view, n, n2, bl, charSequence);
    }

    public void hide() {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_view_TooltipPopup$hide(), 0, this);
    }

    public View getContentView() {
        return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$com_android_internal_view_TooltipPopup$getContentView(), 0, this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_view_TooltipPopup$isShowing(), 0, this);
    }

    private void computePosition(View view, int n, int n2, boolean bl, WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("computePosition", $$robo$$com_android_internal_view_TooltipPopup$computePosition(android.view.View int int boolean android.view.WindowManager$LayoutParams ), 0, this, view, n, n2, bl, layoutParams);
    }

    public /* synthetic */ TooltipPopup() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TooltipPopup)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

