/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ActionMenuView;
import android.widget.ForwardingListener;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.ShowableListMenu;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionMenuItemView
extends TextView
implements MenuView.ItemView,
View.OnClickListener,
ActionMenuView.ActionMenuChildView,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActionMenuItemView";
    private MenuItemImpl mItemData;
    private CharSequence mTitle;
    private Drawable mIcon;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private ForwardingListener mForwardingListener;
    private PopupCallback mPopupCallback;
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private int mMinWidth;
    private int mSavedPaddingLeft;
    private static int MAX_ICON_SIZE = 32;
    private int mMaxIconSize;

    private void $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Resources res = context.getResources();
        this.mAllowTextWithIcon = this.shouldAllowTextWithIcon();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ActionMenuItemView, defStyleAttr, defStyleRes);
        this.mMinWidth = a.getDimensionPixelSize(0, 0);
        a.recycle();
        float density = res.getDisplayMetrics().density;
        this.mMaxIconSize = (int)(32.0f * density + 0.5f);
        this.setOnClickListener(this);
        this.mSavedPaddingLeft = -1;
        this.setSaveEnabled(false);
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mAllowTextWithIcon = this.shouldAllowTextWithIcon();
        this.updateTextButtonVisibility();
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$shouldAllowTextWithIcon() {
        Configuration configuration = this.getContext().getResources().getConfiguration();
        int width = configuration.screenWidthDp;
        int height = configuration.screenHeightDp;
        return width >= 480 || width >= 640 && height >= 480 || configuration.orientation == 2;
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setPadding(int l, int t, int r, int b) {
        this.mSavedPaddingLeft = l;
        super.setPadding(l, t, r, b);
    }

    private final MenuItemImpl $$robo$$com_android_internal_view_menu_ActionMenuItemView$getItemData() {
        return this.mItemData;
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$initialize(MenuItemImpl itemData, int menuType) {
        this.mItemData = itemData;
        this.setIcon(itemData.getIcon());
        this.setTitle(itemData.getTitleForItemView(this));
        this.setId(itemData.getItemId());
        this.setVisibility(itemData.isVisible() ? 0 : 8);
        this.setEnabled(itemData.isEnabled());
        if (itemData.hasSubMenu() && this.mForwardingListener == null) {
            this.mForwardingListener = new ActionMenuItemForwardingListener(this);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$onTouchEvent(MotionEvent e) {
        if (this.mItemData.hasSubMenu() && this.mForwardingListener != null && this.mForwardingListener.onTouch(this, e)) {
            return true;
        }
        return super.onTouchEvent(e);
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$onClick(View v) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setItemInvoker(MenuBuilder.ItemInvoker invoker) {
        this.mItemInvoker = invoker;
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setPopupCallback(PopupCallback popupCallback) {
        this.mPopupCallback = popupCallback;
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$prefersCondensedTitle() {
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setCheckable(boolean checkable) {
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setChecked(boolean checked) {
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setExpandedFormat(boolean expandedFormat) {
        if (this.mExpandedFormat != expandedFormat) {
            this.mExpandedFormat = expandedFormat;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$updateTextButtonVisibility() {
        boolean visible = !TextUtils.isEmpty(this.mTitle);
        this.setText((visible &= this.mIcon == null || this.mItemData.showsTextAsAction() && (this.mAllowTextWithIcon || this.mExpandedFormat)) ? this.mTitle : null);
        CharSequence contentDescription = this.mItemData.getContentDescription();
        if (TextUtils.isEmpty(contentDescription)) {
            this.setContentDescription(visible ? null : this.mItemData.getTitle());
        } else {
            this.setContentDescription(contentDescription);
        }
        CharSequence tooltipText = this.mItemData.getTooltipText();
        if (TextUtils.isEmpty(tooltipText)) {
            this.setTooltipText(visible ? null : this.mItemData.getTitle());
        } else {
            this.setTooltipText(tooltipText);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setIcon(Drawable icon) {
        this.mIcon = icon;
        if (icon != null) {
            float scale;
            int width = icon.getIntrinsicWidth();
            int height = icon.getIntrinsicHeight();
            if (width > this.mMaxIconSize) {
                scale = (float)this.mMaxIconSize / (float)width;
                width = this.mMaxIconSize;
                height = (int)((float)height * scale);
            }
            if (height > this.mMaxIconSize) {
                scale = (float)this.mMaxIconSize / (float)height;
                height = this.mMaxIconSize;
                width = (int)((float)width * scale);
            }
            icon.setBounds(0, 0, width, height);
        }
        this.setCompoundDrawables(icon, null, null, null);
        this.updateTextButtonVisibility();
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$hasText() {
        return !TextUtils.isEmpty(this.getText());
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setShortcut(boolean showShortcut, char shortcutKey) {
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$setTitle(CharSequence title) {
        this.mTitle = title;
        this.updateTextButtonVisibility();
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        super.onPopulateAccessibilityEventInternal(event);
        CharSequence cdesc = this.getContentDescription();
        if (!TextUtils.isEmpty(cdesc)) {
            event.getText().add(cdesc);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$dispatchHoverEvent(MotionEvent event) {
        return this.onHoverEvent(event);
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$showsIcon() {
        return true;
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$needsDividerBefore() {
        return this.hasText() && this.mItemData.getIcon() == null;
    }

    private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView$needsDividerAfter() {
        return this.hasText();
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int targetWidth;
        boolean textVisible = this.hasText();
        if (textVisible && this.mSavedPaddingLeft >= 0) {
            super.setPadding(this.mSavedPaddingLeft, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int oldMeasuredWidth = this.getMeasuredWidth();
        int n = targetWidth = widthMode == Integer.MIN_VALUE ? Math.min(widthSize, this.mMinWidth) : this.mMinWidth;
        if (widthMode != 0x40000000 && this.mMinWidth > 0 && oldMeasuredWidth < targetWidth) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(targetWidth, 0x40000000), heightMeasureSpec);
        }
        if (!textVisible && this.mIcon != null) {
            int w = this.getMeasuredWidth();
            int dw = this.mIcon.getBounds().width();
            super.setPadding((w - dw) / 2, this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
    }

    private final void $$robo$$com_android_internal_view_menu_ActionMenuItemView$onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(null);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(context);
    }

    public ActionMenuItemView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(context, attributeSet);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(context, attributeSet, n);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(context, attributeSet, n, n2);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    private boolean shouldAllowTextWithIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAllowTextWithIcon", $$robo$$com_android_internal_view_menu_ActionMenuItemView$shouldAllowTextWithIcon(), 0, this);
    }

    @Override
    public void setPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setPadding", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setPadding(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public MenuItemImpl getItemData() {
        return InvokeDynamicSupport.bootstrap("getItemData", $$robo$$com_android_internal_view_menu_ActionMenuItemView$getItemData(), 0, this);
    }

    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_view_menu_ActionMenuItemView$initialize(com.android.internal.view.menu.MenuItemImpl int ), 0, this, menuItemImpl, n);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onClick(android.view.View ), 0, this, view);
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        InvokeDynamicSupport.bootstrap("setItemInvoker", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setItemInvoker(com.android.internal.view.menu.MenuBuilder$ItemInvoker ), 0, this, itemInvoker);
    }

    public void setPopupCallback(PopupCallback popupCallback) {
        InvokeDynamicSupport.bootstrap("setPopupCallback", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setPopupCallback(com.android.internal.view.menu.ActionMenuItemView$PopupCallback ), 0, this, popupCallback);
    }

    @Override
    public boolean prefersCondensedTitle() {
        return (boolean)InvokeDynamicSupport.bootstrap("prefersCondensedTitle", $$robo$$com_android_internal_view_menu_ActionMenuItemView$prefersCondensedTitle(), 0, this);
    }

    @Override
    public void setCheckable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCheckable", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setCheckable(boolean ), 0, this, bl);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setChecked(boolean ), 0, this, bl);
    }

    public void setExpandedFormat(boolean bl) {
        InvokeDynamicSupport.bootstrap("setExpandedFormat", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setExpandedFormat(boolean ), 0, this, bl);
    }

    private void updateTextButtonVisibility() {
        InvokeDynamicSupport.bootstrap("updateTextButtonVisibility", $$robo$$com_android_internal_view_menu_ActionMenuItemView$updateTextButtonVisibility(), 0, this);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public boolean hasText() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasText", $$robo$$com_android_internal_view_menu_ActionMenuItemView$hasText(), 0, this);
    }

    @Override
    public void setShortcut(boolean bl, char c) {
        InvokeDynamicSupport.bootstrap("setShortcut", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setShortcut(boolean char ), 0, this, bl, c);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_view_menu_ActionMenuItemView$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$com_android_internal_view_menu_ActionMenuItemView$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEventInternal", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$com_android_internal_view_menu_ActionMenuItemView$dispatchHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean showsIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("showsIcon", $$robo$$com_android_internal_view_menu_ActionMenuItemView$showsIcon(), 0, this);
    }

    @Override
    public boolean needsDividerBefore() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsDividerBefore", $$robo$$com_android_internal_view_menu_ActionMenuItemView$needsDividerBefore(), 0, this);
    }

    @Override
    public boolean needsDividerAfter() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsDividerAfter", $$robo$$com_android_internal_view_menu_ActionMenuItemView$needsDividerAfter(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_view_menu_ActionMenuItemView$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    public /* synthetic */ ActionMenuItemView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuItemView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class PopupCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_view_menu_ActionMenuItemView_PopupCallback$__constructor__() {
        }

        public abstract ShowableListMenu getPopup();

        private void __constructor__() {
            this.$$robo$$com_android_internal_view_menu_ActionMenuItemView_PopupCallback$__constructor__();
        }

        public PopupCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView_PopupCallback$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ActionMenuItemForwardingListener
    extends ForwardingListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ActionMenuItemView this$0;

        private void $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$__constructor__(ActionMenuItemView actionMenuItemView) {
        }

        private final ShowableListMenu $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$getPopup() {
            if (this.this$0.mPopupCallback != null) {
                return this.this$0.mPopupCallback.getPopup();
            }
            return null;
        }

        private final boolean $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$onForwardingStarted() {
            if (this.this$0.mItemInvoker != null && this.this$0.mItemInvoker.invokeItem(this.this$0.mItemData)) {
                ShowableListMenu popup = this.getPopup();
                return popup != null && popup.isShowing();
            }
            return false;
        }

        private void __constructor__(ActionMenuItemView actionMenuItemView) {
            this.$$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$__constructor__(actionMenuItemView);
        }

        public ActionMenuItemForwardingListener(ActionMenuItemView actionMenuItemView) {
            this.this$0 = actionMenuItemView;
            super(actionMenuItemView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$__constructor__(com.android.internal.view.menu.ActionMenuItemView ), 0, this, actionMenuItemView);
        }

        @Override
        public ShowableListMenu getPopup() {
            return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$getPopup(), 0, this);
        }

        @Override
        protected boolean onForwardingStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$com_android_internal_view_menu_ActionMenuItemView_ActionMenuItemForwardingListener$onForwardingStarted(), 0, this);
        }

        public /* synthetic */ ActionMenuItemForwardingListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionMenuItemForwardingListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

