/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Log;
import android.util.Property;
import android.util.SparseArray;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.OverScroller;
import android.widget.Toolbar;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.widget.ActionBarContainer;
import com.android.internal.widget.ActionBarContextView;
import com.android.internal.widget.DecorContentParent;
import com.android.internal.widget.DecorToolbar;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ActionBarOverlayLayout
extends ViewGroup
implements DecorContentParent,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ActionBarOverlayLayout";
    private int mActionBarHeight;
    private int mWindowVisibility;
    private View mContent;
    private ActionBarContainer mActionBarBottom;
    private ActionBarContainer mActionBarTop;
    private DecorToolbar mDecorToolbar;
    private Drawable mWindowContentOverlay;
    private boolean mIgnoreWindowContentOverlay;
    private boolean mOverlayMode;
    private boolean mHasNonEmbeddedTabs;
    private boolean mHideOnContentScroll;
    private boolean mAnimatingForFling;
    private int mHideOnContentScrollReference;
    private int mLastSystemUiVisibility;
    private Rect mBaseContentInsets;
    private Rect mLastBaseContentInsets;
    private Rect mContentInsets;
    private Rect mBaseInnerInsets;
    private Rect mLastBaseInnerInsets;
    private Rect mInnerInsets;
    private Rect mLastInnerInsets;
    private ActionBarVisibilityCallback mActionBarVisibilityCallback;
    private int ACTION_BAR_ANIMATE_DELAY = 600;
    private OverScroller mFlingEstimator;
    private ViewPropertyAnimator mCurrentActionBarTopAnimator;
    private ViewPropertyAnimator mCurrentActionBarBottomAnimator;
    private Animator.AnimatorListener mTopAnimatorListener;
    private Animator.AnimatorListener mBottomAnimatorListener;
    private Runnable mRemoveActionBarHideOffset;
    private Runnable mAddActionBarHideOffset;
    public static Property<ActionBarOverlayLayout, Integer> ACTION_BAR_HIDE_OFFSET;
    static int[] ATTRS;

    private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(Context context) {
        this.mWindowVisibility = 0;
        this.mBaseContentInsets = new Rect();
        this.mLastBaseContentInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mBaseInnerInsets = new Rect();
        this.mLastBaseInnerInsets = new Rect();
        this.mInnerInsets = new Rect();
        this.mLastInnerInsets = new Rect();
        this.ACTION_BAR_ANIMATE_DELAY = 600;
        this.mTopAnimatorListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionBarOverlayLayout this$0;

            private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$__constructor__(ActionBarOverlayLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$onAnimationEnd(Animator animation) {
                this.this$0.mCurrentActionBarTopAnimator = null;
                this.this$0.mAnimatingForFling = false;
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$onAnimationCancel(Animator animation) {
                this.this$0.mCurrentActionBarTopAnimator = null;
                this.this$0.mAnimatingForFling = false;
            }

            private void __constructor__(ActionBarOverlayLayout actionBarOverlayLayout) {
                this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$__constructor__(actionBarOverlayLayout);
            }
            {
                this.this$0 = actionBarOverlayLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$__constructor__(com.android.internal.widget.ActionBarOverlayLayout ), 0, this, actionBarOverlayLayout);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_1$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mBottomAnimatorListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionBarOverlayLayout this$0;

            private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$__constructor__(ActionBarOverlayLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$onAnimationEnd(Animator animation) {
                this.this$0.mCurrentActionBarBottomAnimator = null;
                this.this$0.mAnimatingForFling = false;
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$onAnimationCancel(Animator animation) {
                this.this$0.mCurrentActionBarBottomAnimator = null;
                this.this$0.mAnimatingForFling = false;
            }

            private void __constructor__(ActionBarOverlayLayout actionBarOverlayLayout) {
                this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$__constructor__(actionBarOverlayLayout);
            }
            {
                this.this$0 = actionBarOverlayLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$__constructor__(com.android.internal.widget.ActionBarOverlayLayout ), 0, this, actionBarOverlayLayout);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }

            @Override
            public void onAnimationCancel(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_2$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRemoveActionBarHideOffset = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionBarOverlayLayout this$0;

            private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_3$__constructor__(ActionBarOverlayLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_3$run() {
                this.this$0.haltActionBarHideOffsetAnimations();
                this.this$0.mCurrentActionBarTopAnimator = this.this$0.mActionBarTop.animate().translationY(0.0f).setListener(this.this$0.mTopAnimatorListener);
                if (this.this$0.mActionBarBottom != null && this.this$0.mActionBarBottom.getVisibility() != 8) {
                    this.this$0.mCurrentActionBarBottomAnimator = this.this$0.mActionBarBottom.animate().translationY(0.0f).setListener(this.this$0.mBottomAnimatorListener);
                }
            }

            private void __constructor__(ActionBarOverlayLayout actionBarOverlayLayout) {
                this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_3$__constructor__(actionBarOverlayLayout);
            }
            {
                this.this$0 = actionBarOverlayLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_3$__constructor__(com.android.internal.widget.ActionBarOverlayLayout ), 0, this, actionBarOverlayLayout);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAddActionBarHideOffset = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ActionBarOverlayLayout this$0;

            private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_4$__constructor__(ActionBarOverlayLayout this$0) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_4$run() {
                this.this$0.haltActionBarHideOffsetAnimations();
                this.this$0.mCurrentActionBarTopAnimator = this.this$0.mActionBarTop.animate().translationY(-this.this$0.mActionBarTop.getHeight()).setListener(this.this$0.mTopAnimatorListener);
                if (this.this$0.mActionBarBottom != null && this.this$0.mActionBarBottom.getVisibility() != 8) {
                    this.this$0.mCurrentActionBarBottomAnimator = this.this$0.mActionBarBottom.animate().translationY(this.this$0.mActionBarBottom.getHeight()).setListener(this.this$0.mBottomAnimatorListener);
                }
            }

            private void __constructor__(ActionBarOverlayLayout actionBarOverlayLayout) {
                this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_4$__constructor__(actionBarOverlayLayout);
            }
            {
                this.this$0 = actionBarOverlayLayout;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_4$__constructor__(com.android.internal.widget.ActionBarOverlayLayout ), 0, this, actionBarOverlayLayout);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(Context context, AttributeSet attrs) {
        this.mWindowVisibility = 0;
        this.mBaseContentInsets = new Rect();
        this.mLastBaseContentInsets = new Rect();
        this.mContentInsets = new Rect();
        this.mBaseInnerInsets = new Rect();
        this.mLastBaseInnerInsets = new Rect();
        this.mInnerInsets = new Rect();
        this.mLastInnerInsets = new Rect();
        this.ACTION_BAR_ANIMATE_DELAY = 600;
        this.mTopAnimatorListener = new /* invalid duplicate definition of identical inner class */;
        this.mBottomAnimatorListener = new /* invalid duplicate definition of identical inner class */;
        this.mRemoveActionBarHideOffset = new /* invalid duplicate definition of identical inner class */;
        this.mAddActionBarHideOffset = new /* invalid duplicate definition of identical inner class */;
        this.init(context);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$init(Context context) {
        TypedArray ta = this.getContext().getTheme().obtainStyledAttributes(ATTRS);
        this.mActionBarHeight = ta.getDimensionPixelSize(0, 0);
        this.mWindowContentOverlay = ta.getDrawable(1);
        this.setWillNotDraw(this.mWindowContentOverlay == null);
        ta.recycle();
        this.mIgnoreWindowContentOverlay = context.getApplicationInfo().targetSdkVersion < 19;
        this.mFlingEstimator = new OverScroller(context);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.haltActionBarHideOffsetAnimations();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setActionBarVisibilityCallback(ActionBarVisibilityCallback cb) {
        this.mActionBarVisibilityCallback = cb;
        if (this.getWindowToken() != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(this.mWindowVisibility);
            if (this.mLastSystemUiVisibility != 0) {
                int newVis = this.mLastSystemUiVisibility;
                this.onWindowSystemUiVisibilityChanged(newVis);
                this.requestApplyInsets();
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setOverlayMode(boolean overlayMode) {
        this.mOverlayMode = overlayMode;
        this.mIgnoreWindowContentOverlay = overlayMode && this.getContext().getApplicationInfo().targetSdkVersion < 19;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isInOverlayMode() {
        return this.mOverlayMode;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setHasNonEmbeddedTabs(boolean hasNonEmbeddedTabs) {
        this.mHasNonEmbeddedTabs = hasNonEmbeddedTabs;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setShowingForActionMode(boolean showing) {
        if (showing) {
            if ((this.getWindowSystemUiVisibility() & 0x500) == 1280) {
                this.setDisabledSystemUiVisibility(4);
            }
        } else {
            this.setDisabledSystemUiVisibility(0);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.init(this.getContext());
        this.requestApplyInsets();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onWindowSystemUiVisibilityChanged(int visible) {
        boolean stable;
        super.onWindowSystemUiVisibilityChanged(visible);
        this.pullChildren();
        int diff = this.mLastSystemUiVisibility ^ visible;
        this.mLastSystemUiVisibility = visible;
        boolean barVisible = (visible & 4) == 0;
        boolean bl = stable = (visible & 0x100) != 0;
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.enableContentAnimations(!stable);
            if (barVisible || !stable) {
                this.mActionBarVisibilityCallback.showForSystem();
            } else {
                this.mActionBarVisibilityCallback.hideForSystem();
            }
        }
        if ((diff & 0x100) != 0 && this.mActionBarVisibilityCallback != null) {
            this.requestApplyInsets();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility;
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onWindowVisibilityChanged(visibility);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$applyInsets(View view, Rect insets, boolean left, boolean top, boolean bottom, boolean right) {
        boolean changed = false;
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        if (left && lp.leftMargin != insets.left) {
            changed = true;
            lp.leftMargin = insets.left;
        }
        if (top && lp.topMargin != insets.top) {
            changed = true;
            lp.topMargin = insets.top;
        }
        if (right && lp.rightMargin != insets.right) {
            changed = true;
            lp.rightMargin = insets.right;
        }
        if (bottom && lp.bottomMargin != insets.bottom) {
            changed = true;
            lp.bottomMargin = insets.bottom;
        }
        return changed;
    }

    private final WindowInsets $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onApplyWindowInsets(WindowInsets insets) {
        this.pullChildren();
        int vis = this.getWindowSystemUiVisibility();
        boolean stable = (vis & 0x100) != 0;
        Rect systemInsets = insets.getSystemWindowInsets();
        boolean changed = this.applyInsets(this.mActionBarTop, systemInsets, true, true, false, true);
        if (this.mActionBarBottom != null) {
            changed |= this.applyInsets(this.mActionBarBottom, systemInsets, true, false, true, true);
        }
        this.mBaseInnerInsets.set(systemInsets);
        this.computeFitSystemWindows(this.mBaseInnerInsets, this.mBaseContentInsets);
        if (!this.mLastBaseInnerInsets.equals(this.mBaseInnerInsets)) {
            changed = true;
            this.mLastBaseContentInsets.set(this.mBaseContentInsets);
        }
        if (!this.mLastBaseContentInsets.equals(this.mBaseContentInsets)) {
            changed = true;
            this.mLastBaseContentInsets.set(this.mBaseContentInsets);
        }
        if (changed) {
            this.requestLayout();
        }
        return WindowInsets.CONSUMED;
    }

    private final LayoutParams $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final ViewGroup.LayoutParams $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int vis;
        boolean stable;
        this.pullChildren();
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        int topInset = 0;
        int bottomInset = 0;
        this.measureChildWithMargins(this.mActionBarTop, widthMeasureSpec, 0, heightMeasureSpec, 0);
        LayoutParams lp = (LayoutParams)this.mActionBarTop.getLayoutParams();
        maxWidth = Math.max(maxWidth, this.mActionBarTop.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        maxHeight = Math.max(maxHeight, this.mActionBarTop.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mActionBarTop.getMeasuredState());
        if (this.mActionBarBottom != null) {
            this.measureChildWithMargins(this.mActionBarBottom, widthMeasureSpec, 0, heightMeasureSpec, 0);
            lp = (LayoutParams)this.mActionBarBottom.getLayoutParams();
            maxWidth = Math.max(maxWidth, this.mActionBarBottom.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            maxHeight = Math.max(maxHeight, this.mActionBarBottom.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mActionBarBottom.getMeasuredState());
        }
        boolean bl = stable = ((vis = this.getWindowSystemUiVisibility()) & 0x100) != 0;
        if (stable) {
            View tabs;
            topInset = this.mActionBarHeight;
            if (this.mHasNonEmbeddedTabs && (tabs = this.mActionBarTop.getTabContainer()) != null) {
                topInset += this.mActionBarHeight;
            }
        } else if (this.mActionBarTop.getVisibility() != 8) {
            topInset = this.mActionBarTop.getMeasuredHeight();
        }
        if (this.mDecorToolbar.isSplit() && this.mActionBarBottom != null) {
            bottomInset = stable ? this.mActionBarHeight : this.mActionBarBottom.getMeasuredHeight();
        }
        this.mContentInsets.set(this.mBaseContentInsets);
        this.mInnerInsets.set(this.mBaseInnerInsets);
        if (!this.mOverlayMode && !stable) {
            this.mContentInsets.top += topInset;
            this.mContentInsets.bottom += bottomInset;
        } else {
            this.mInnerInsets.top += topInset;
            this.mInnerInsets.bottom += bottomInset;
        }
        this.applyInsets(this.mContent, this.mContentInsets, true, true, true, true);
        if (!this.mLastInnerInsets.equals(this.mInnerInsets)) {
            this.mLastInnerInsets.set(this.mInnerInsets);
            this.mContent.dispatchApplyWindowInsets(new WindowInsets(this.mInnerInsets));
        }
        this.measureChildWithMargins(this.mContent, widthMeasureSpec, 0, heightMeasureSpec, 0);
        lp = (LayoutParams)this.mContent.getLayoutParams();
        maxWidth = Math.max(maxWidth, this.mContent.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
        maxHeight = Math.max(maxHeight, this.mContent.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
        childState = ActionBarOverlayLayout.combineMeasuredStates(childState, this.mContent.getMeasuredState());
        maxWidth += this.getPaddingLeft() + this.getPaddingRight();
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(ActionBarOverlayLayout.resolveSizeAndState(maxWidth, widthMeasureSpec, childState), ActionBarOverlayLayout.resolveSizeAndState(maxHeight, heightMeasureSpec, childState << 16));
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int parentLeft = this.getPaddingLeft();
        int parentRight = right - left - this.getPaddingRight();
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int childLeft = parentLeft + lp.leftMargin;
            int childTop = child == this.mActionBarBottom ? parentBottom - height - lp.bottomMargin : parentTop + lp.topMargin;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$draw(Canvas c) {
        super.draw(c);
        if (this.mWindowContentOverlay != null && !this.mIgnoreWindowContentOverlay) {
            int top = this.mActionBarTop.getVisibility() == 0 ? (int)((float)this.mActionBarTop.getBottom() + this.mActionBarTop.getTranslationY() + 0.5f) : 0;
            this.mWindowContentOverlay.setBounds(0, top, this.getWidth(), top + this.mWindowContentOverlay.getIntrinsicHeight());
            this.mWindowContentOverlay.draw(c);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$shouldDelayChildPressedState() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onStartNestedScroll(View child, View target, int axes) {
        if ((axes & 2) == 0 || this.mActionBarTop.getVisibility() != 0) {
            return false;
        }
        return this.mHideOnContentScroll;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedScrollAccepted(View child, View target, int axes) {
        super.onNestedScrollAccepted(child, target, axes);
        this.mHideOnContentScrollReference = this.getActionBarHideOffset();
        this.haltActionBarHideOffsetAnimations();
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStarted();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.mHideOnContentScrollReference += dyConsumed;
        this.setActionBarHideOffset(this.mHideOnContentScrollReference);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onStopNestedScroll(View target) {
        super.onStopNestedScroll(target);
        if (this.mHideOnContentScroll && !this.mAnimatingForFling) {
            if (this.mHideOnContentScrollReference <= this.mActionBarTop.getHeight()) {
                this.postRemoveActionBarHideOffset();
            } else {
                this.postAddActionBarHideOffset();
            }
        }
        if (this.mActionBarVisibilityCallback != null) {
            this.mActionBarVisibilityCallback.onContentScrollStopped();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        if (!this.mHideOnContentScroll || !consumed) {
            return false;
        }
        if (this.shouldHideActionBarOnFling(velocityX, velocityY)) {
            this.addActionBarHideOffset();
        } else {
            this.removeActionBarHideOffset();
        }
        this.mAnimatingForFling = true;
        return true;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$pullChildren() {
        if (this.mContent == null) {
            this.mContent = this.findViewById(0x1020002);
            this.mActionBarTop = (ActionBarContainer)this.findViewById(16908669);
            this.mDecorToolbar = this.getDecorToolbar((View)this.findViewById(16908668));
            this.mActionBarBottom = (ActionBarContainer)this.findViewById(16909297);
        }
    }

    private final DecorToolbar $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getDecorToolbar(View view) {
        if (view instanceof DecorToolbar) {
            return (DecorToolbar)((Object)view);
        }
        if (view instanceof Toolbar) {
            return ((Toolbar)view).getWrapper();
        }
        throw new IllegalStateException("Can't make a decor toolbar out of " + view.getClass().getSimpleName());
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setHideOnContentScrollEnabled(boolean hideOnContentScroll) {
        if (hideOnContentScroll != this.mHideOnContentScroll) {
            this.mHideOnContentScroll = hideOnContentScroll;
            if (!hideOnContentScroll) {
                this.stopNestedScroll();
                this.haltActionBarHideOffsetAnimations();
                this.setActionBarHideOffset(0);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isHideOnContentScrollEnabled() {
        return this.mHideOnContentScroll;
    }

    private final int $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getActionBarHideOffset() {
        return this.mActionBarTop != null ? -((int)this.mActionBarTop.getTranslationY()) : 0;
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setActionBarHideOffset(int offset) {
        this.haltActionBarHideOffsetAnimations();
        int topHeight = this.mActionBarTop.getHeight();
        offset = Math.max(0, Math.min(offset, topHeight));
        this.mActionBarTop.setTranslationY(-offset);
        if (this.mActionBarBottom != null && this.mActionBarBottom.getVisibility() != 8) {
            float fOffset = (float)offset / (float)topHeight;
            int bOffset = (int)((float)this.mActionBarBottom.getHeight() * fOffset);
            this.mActionBarBottom.setTranslationY(bOffset);
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$haltActionBarHideOffsetAnimations() {
        this.removeCallbacks(this.mRemoveActionBarHideOffset);
        this.removeCallbacks(this.mAddActionBarHideOffset);
        if (this.mCurrentActionBarTopAnimator != null) {
            this.mCurrentActionBarTopAnimator.cancel();
        }
        if (this.mCurrentActionBarBottomAnimator != null) {
            this.mCurrentActionBarBottomAnimator.cancel();
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$postRemoveActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mRemoveActionBarHideOffset, 600L);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$postAddActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.postDelayed(this.mAddActionBarHideOffset, 600L);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$removeActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mRemoveActionBarHideOffset.run();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$addActionBarHideOffset() {
        this.haltActionBarHideOffsetAnimations();
        this.mAddActionBarHideOffset.run();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$shouldHideActionBarOnFling(float velocityX, float velocityY) {
        this.mFlingEstimator.fling(0, 0, 0, (int)velocityY, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        int finalY = this.mFlingEstimator.getFinalY();
        return finalY > this.mActionBarTop.getHeight();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setWindowCallback(Window.Callback cb) {
        this.pullChildren();
        this.mDecorToolbar.setWindowCallback(cb);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setWindowTitle(CharSequence title) {
        this.pullChildren();
        this.mDecorToolbar.setWindowTitle(title);
    }

    private final CharSequence $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getTitle() {
        this.pullChildren();
        return this.mDecorToolbar.getTitle();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$initFeature(int windowFeature) {
        this.pullChildren();
        switch (windowFeature) {
            case 2: {
                this.mDecorToolbar.initProgress();
                break;
            }
            case 5: {
                this.mDecorToolbar.initIndeterminateProgress();
                break;
            }
            case 9: {
                this.setOverlayMode(true);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setUiOptions(int uiOptions) {
        boolean splitWhenNarrow;
        boolean splitActionBar = false;
        boolean bl = splitWhenNarrow = (uiOptions & 1) != 0;
        if (splitWhenNarrow) {
            splitActionBar = this.getContext().getResources().getBoolean(17957075);
        }
        if (splitActionBar) {
            this.pullChildren();
            if (this.mActionBarBottom != null && this.mDecorToolbar.canSplit()) {
                this.mDecorToolbar.setSplitView(this.mActionBarBottom);
                this.mDecorToolbar.setSplitToolbar(splitActionBar);
                this.mDecorToolbar.setSplitWhenNarrow(splitWhenNarrow);
                ActionBarContextView cab = (ActionBarContextView)this.findViewById(16908673);
                cab.setSplitView(this.mActionBarBottom);
                cab.setSplitToolbar(splitActionBar);
                cab.setSplitWhenNarrow(splitWhenNarrow);
            } else if (splitActionBar) {
                Log.e("ActionBarOverlayLayout", "Requested split action bar with incompatible window decor! Ignoring request.");
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hasIcon() {
        this.pullChildren();
        return this.mDecorToolbar.hasIcon();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hasLogo() {
        this.pullChildren();
        return this.mDecorToolbar.hasLogo();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setIcon(int resId) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(resId);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setIcon(Drawable d) {
        this.pullChildren();
        this.mDecorToolbar.setIcon(d);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setLogo(int resId) {
        this.pullChildren();
        this.mDecorToolbar.setLogo(resId);
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$canShowOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.canShowOverflowMenu();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isOverflowMenuShowing() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowing();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isOverflowMenuShowPending() {
        this.pullChildren();
        return this.mDecorToolbar.isOverflowMenuShowPending();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$showOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.showOverflowMenu();
    }

    private final boolean $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hideOverflowMenu() {
        this.pullChildren();
        return this.mDecorToolbar.hideOverflowMenu();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setMenuPrepared() {
        this.pullChildren();
        this.mDecorToolbar.setMenuPrepared();
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setMenu(Menu menu2, MenuPresenter.Callback cb) {
        this.pullChildren();
        this.mDecorToolbar.setMenu(menu2, cb);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$saveToolbarHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.pullChildren();
        this.mDecorToolbar.saveHierarchyState(toolbarStates);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$restoreToolbarHierarchyState(SparseArray<Parcelable> toolbarStates) {
        this.pullChildren();
        this.mDecorToolbar.restoreHierarchyState(toolbarStates);
    }

    private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout$dismissPopups() {
        this.pullChildren();
        this.mDecorToolbar.dismissPopupMenus();
    }

    static void __staticInitializer__() {
        ACTION_BAR_HIDE_OFFSET = new IntProperty<ActionBarOverlayLayout>("actionBarHideOffset"){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$__constructor__(String name) {
            }

            private final void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$setValue(ActionBarOverlayLayout object, int value) {
                object.setActionBarHideOffset(value);
            }

            private final Integer $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$get(ActionBarOverlayLayout object) {
                return object.getActionBarHideOffset();
            }

            private void __constructor__(String string2) {
                this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$__constructor__(string2);
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$__constructor__(java.lang.String ), 0, this, string2);
            }

            @Override
            public void setValue(ActionBarOverlayLayout actionBarOverlayLayout, int n) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$setValue(com.android.internal.widget.ActionBarOverlayLayout int ), 0, this, actionBarOverlayLayout, n);
            }

            @Override
            public Integer get(ActionBarOverlayLayout actionBarOverlayLayout) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_5$get(com.android.internal.widget.ActionBarOverlayLayout ), 0, this, actionBarOverlayLayout);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        ATTRS = new int[]{16843499, 16842841};
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(context);
    }

    public ActionBarOverlayLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(context, attributeSet);
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$init(android.content.Context ), 0, this, context);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onDetachedFromWindow(), 0, this);
    }

    public void setActionBarVisibilityCallback(ActionBarVisibilityCallback actionBarVisibilityCallback) {
        InvokeDynamicSupport.bootstrap("setActionBarVisibilityCallback", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setActionBarVisibilityCallback(com.android.internal.widget.ActionBarOverlayLayout$ActionBarVisibilityCallback ), 0, this, actionBarVisibilityCallback);
    }

    public void setOverlayMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOverlayMode", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setOverlayMode(boolean ), 0, this, bl);
    }

    public boolean isInOverlayMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInOverlayMode", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isInOverlayMode(), 0, this);
    }

    public void setHasNonEmbeddedTabs(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHasNonEmbeddedTabs", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setHasNonEmbeddedTabs(boolean ), 0, this, bl);
    }

    public void setShowingForActionMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShowingForActionMode", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setShowingForActionMode(boolean ), 0, this, bl);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public void onWindowSystemUiVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowSystemUiVisibilityChanged", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onWindowSystemUiVisibilityChanged(int ), 0, this, n);
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowVisibilityChanged", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onWindowVisibilityChanged(int ), 0, this, n);
    }

    private boolean applyInsets(View view, Rect rect, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (boolean)InvokeDynamicSupport.bootstrap("applyInsets", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$applyInsets(android.view.View android.graphics.Rect boolean boolean boolean boolean ), 0, this, view, rect, bl, bl2, bl3, bl4);
    }

    @Override
    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        return InvokeDynamicSupport.bootstrap("onApplyWindowInsets", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onApplyWindowInsets(android.view.WindowInsets ), 0, this, windowInsets);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$shouldDelayChildPressedState(), 0, this);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("onStartNestedScroll", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onStartNestedScroll(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        InvokeDynamicSupport.bootstrap("onNestedScrollAccepted", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedScrollAccepted(android.view.View android.view.View int ), 0, this, view, view2, n);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onNestedScroll", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedScroll(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    @Override
    public void onStopNestedScroll(View view) {
        InvokeDynamicSupport.bootstrap("onStopNestedScroll", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onStopNestedScroll(android.view.View ), 0, this, view);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onNestedFling", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$onNestedFling(android.view.View float float boolean ), 0, this, view, f, f2, bl);
    }

    void pullChildren() {
        InvokeDynamicSupport.bootstrap("pullChildren", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$pullChildren(), 0, this);
    }

    private DecorToolbar getDecorToolbar(View view) {
        return InvokeDynamicSupport.bootstrap("getDecorToolbar", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getDecorToolbar(android.view.View ), 0, this, view);
    }

    public void setHideOnContentScrollEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHideOnContentScrollEnabled", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setHideOnContentScrollEnabled(boolean ), 0, this, bl);
    }

    public boolean isHideOnContentScrollEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHideOnContentScrollEnabled", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isHideOnContentScrollEnabled(), 0, this);
    }

    public int getActionBarHideOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getActionBarHideOffset(), 0, this);
    }

    public void setActionBarHideOffset(int n) {
        InvokeDynamicSupport.bootstrap("setActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setActionBarHideOffset(int ), 0, this, n);
    }

    private void haltActionBarHideOffsetAnimations() {
        InvokeDynamicSupport.bootstrap("haltActionBarHideOffsetAnimations", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$haltActionBarHideOffsetAnimations(), 0, this);
    }

    private void postRemoveActionBarHideOffset() {
        InvokeDynamicSupport.bootstrap("postRemoveActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$postRemoveActionBarHideOffset(), 0, this);
    }

    private void postAddActionBarHideOffset() {
        InvokeDynamicSupport.bootstrap("postAddActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$postAddActionBarHideOffset(), 0, this);
    }

    private void removeActionBarHideOffset() {
        InvokeDynamicSupport.bootstrap("removeActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$removeActionBarHideOffset(), 0, this);
    }

    private void addActionBarHideOffset() {
        InvokeDynamicSupport.bootstrap("addActionBarHideOffset", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$addActionBarHideOffset(), 0, this);
    }

    private boolean shouldHideActionBarOnFling(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldHideActionBarOnFling", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$shouldHideActionBarOnFling(float float ), 0, this, f, f2);
    }

    @Override
    public void setWindowCallback(Window.Callback callback) {
        InvokeDynamicSupport.bootstrap("setWindowCallback", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setWindowCallback(android.view.Window$Callback ), 0, this, callback);
    }

    @Override
    public void setWindowTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setWindowTitle", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setWindowTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public CharSequence getTitle() {
        return InvokeDynamicSupport.bootstrap("getTitle", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$getTitle(), 0, this);
    }

    @Override
    public void initFeature(int n) {
        InvokeDynamicSupport.bootstrap("initFeature", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$initFeature(int ), 0, this, n);
    }

    @Override
    public void setUiOptions(int n) {
        InvokeDynamicSupport.bootstrap("setUiOptions", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setUiOptions(int ), 0, this, n);
    }

    @Override
    public boolean hasIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIcon", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hasIcon(), 0, this);
    }

    @Override
    public boolean hasLogo() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLogo", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hasLogo(), 0, this);
    }

    @Override
    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setIcon(int ), 0, this, n);
    }

    @Override
    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setLogo(int n) {
        InvokeDynamicSupport.bootstrap("setLogo", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setLogo(int ), 0, this, n);
    }

    @Override
    public boolean canShowOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("canShowOverflowMenu", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$canShowOverflowMenu(), 0, this);
    }

    @Override
    public boolean isOverflowMenuShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowing", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isOverflowMenuShowing(), 0, this);
    }

    @Override
    public boolean isOverflowMenuShowPending() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOverflowMenuShowPending", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$isOverflowMenuShowPending(), 0, this);
    }

    @Override
    public boolean showOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("showOverflowMenu", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$showOverflowMenu(), 0, this);
    }

    @Override
    public boolean hideOverflowMenu() {
        return (boolean)InvokeDynamicSupport.bootstrap("hideOverflowMenu", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$hideOverflowMenu(), 0, this);
    }

    @Override
    public void setMenuPrepared() {
        InvokeDynamicSupport.bootstrap("setMenuPrepared", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setMenuPrepared(), 0, this);
    }

    @Override
    public void setMenu(Menu menu2, MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setMenu", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$setMenu(android.view.Menu com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, menu2, callback);
    }

    @Override
    public void saveToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("saveToolbarHierarchyState", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$saveToolbarHierarchyState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    public void restoreToolbarHierarchyState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("restoreToolbarHierarchyState", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$restoreToolbarHierarchyState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    public void dismissPopups() {
        InvokeDynamicSupport.bootstrap("dismissPopups", $$robo$$com_android_internal_widget_ActionBarOverlayLayout$dismissPopups(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ActionBarOverlayLayout.class);
    }

    public /* synthetic */ ActionBarOverlayLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionBarOverlayLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ActionBarVisibilityCallback
    extends InstrumentedInterface {
        public void onWindowVisibilityChanged(int var1);

        public void showForSystem();

        public void hideForSystem();

        public void enableContentAnimations(boolean var1);

        public void onContentScrollStarted();

        public void onContentScrollStopped();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
        }

        private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(int width, int height) {
        }

        private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams source) {
        }

        private void $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ActionBarOverlayLayout_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        public /* synthetic */ LayoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

