/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.res.Resources;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AutoScrollHelper
implements View.OnTouchListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static float RELATIVE_UNSPECIFIED = 0.0f;
    public static float NO_MAX = Float.MAX_VALUE;
    public static float NO_MIN = 0.0f;
    public static int EDGE_TYPE_INSIDE = 0;
    public static int EDGE_TYPE_INSIDE_EXTEND = 1;
    public static int EDGE_TYPE_OUTSIDE = 2;
    private static int HORIZONTAL = 0;
    private static int VERTICAL = 1;
    private ClampedScroller mScroller;
    private Interpolator mEdgeInterpolator;
    private View mTarget;
    private Runnable mRunnable;
    private float[] mRelativeEdges;
    private float[] mMaximumEdges;
    private int mEdgeType;
    private int mActivationDelay;
    private float[] mRelativeVelocity;
    private float[] mMinimumVelocity;
    private float[] mMaximumVelocity;
    private boolean mAlreadyDelayed;
    private boolean mNeedsReset;
    private boolean mNeedsCancel;
    private boolean mAnimating;
    private boolean mEnabled;
    private boolean mExclusive;
    private static int DEFAULT_EDGE_TYPE = 1;
    private static int DEFAULT_MINIMUM_VELOCITY_DIPS = 315;
    private static int DEFAULT_MAXIMUM_VELOCITY_DIPS = 1575;
    private static float DEFAULT_MAXIMUM_EDGE = Float.MAX_VALUE;
    private static float DEFAULT_RELATIVE_EDGE = 0.2f;
    private static float DEFAULT_RELATIVE_VELOCITY = 1.0f;
    private static int DEFAULT_ACTIVATION_DELAY;
    private static int DEFAULT_RAMP_UP_DURATION = 500;
    private static int DEFAULT_RAMP_DOWN_DURATION = 500;

    private void $$robo$$com_android_internal_widget_AutoScrollHelper$__constructor__(View target) {
        this.mScroller = new ClampedScroller();
        this.mEdgeInterpolator = new AccelerateInterpolator();
        this.mRelativeEdges = new float[]{0.0f, 0.0f};
        this.mMaximumEdges = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        this.mRelativeVelocity = new float[]{0.0f, 0.0f};
        this.mMinimumVelocity = new float[]{0.0f, 0.0f};
        this.mMaximumVelocity = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        this.mTarget = target;
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        int maxVelocity = (int)(1575.0f * metrics.density + 0.5f);
        int minVelocity = (int)(315.0f * metrics.density + 0.5f);
        this.setMaximumVelocity(maxVelocity, maxVelocity);
        this.setMinimumVelocity(minVelocity, minVelocity);
        this.setEdgeType(1);
        this.setMaximumEdges(Float.MAX_VALUE, Float.MAX_VALUE);
        this.setRelativeEdges(0.2f, 0.2f);
        this.setRelativeVelocity(1.0f, 1.0f);
        this.setActivationDelay(DEFAULT_ACTIVATION_DELAY);
        this.setRampUpDuration(500);
        this.setRampDownDuration(500);
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setEnabled(boolean enabled) {
        if (this.mEnabled && !enabled) {
            this.requestStop();
        }
        this.mEnabled = enabled;
        return this;
    }

    private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper$isEnabled() {
        return this.mEnabled;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setExclusive(boolean exclusive) {
        this.mExclusive = exclusive;
        return this;
    }

    private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper$isExclusive() {
        return this.mExclusive;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setMaximumVelocity(float horizontalMax, float verticalMax) {
        this.mMaximumVelocity[0] = horizontalMax / 1000.0f;
        this.mMaximumVelocity[1] = verticalMax / 1000.0f;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setMinimumVelocity(float horizontalMin, float verticalMin) {
        this.mMinimumVelocity[0] = horizontalMin / 1000.0f;
        this.mMinimumVelocity[1] = verticalMin / 1000.0f;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setRelativeVelocity(float horizontal, float vertical) {
        this.mRelativeVelocity[0] = horizontal / 1000.0f;
        this.mRelativeVelocity[1] = vertical / 1000.0f;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setEdgeType(int type) {
        this.mEdgeType = type;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setRelativeEdges(float horizontal, float vertical) {
        this.mRelativeEdges[0] = horizontal;
        this.mRelativeEdges[1] = vertical;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setMaximumEdges(float horizontalMax, float verticalMax) {
        this.mMaximumEdges[0] = horizontalMax;
        this.mMaximumEdges[1] = verticalMax;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setActivationDelay(int delayMillis) {
        this.mActivationDelay = delayMillis;
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setRampUpDuration(int durationMillis) {
        this.mScroller.setRampUpDuration(durationMillis);
        return this;
    }

    private final AutoScrollHelper $$robo$$com_android_internal_widget_AutoScrollHelper$setRampDownDuration(int durationMillis) {
        this.mScroller.setRampDownDuration(durationMillis);
        return this;
    }

    private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper$onTouch(View v, MotionEvent event) {
        if (!this.mEnabled) {
            return false;
        }
        int action = event.getActionMasked();
        switch (action) {
            case 0: {
                this.mNeedsCancel = true;
                this.mAlreadyDelayed = false;
            }
            case 2: {
                float xTargetVelocity = this.computeTargetVelocity(0, event.getX(), v.getWidth(), this.mTarget.getWidth());
                float yTargetVelocity = this.computeTargetVelocity(1, event.getY(), v.getHeight(), this.mTarget.getHeight());
                this.mScroller.setTargetVelocity(xTargetVelocity, yTargetVelocity);
                if (this.mAnimating || !this.shouldAnimate()) break;
                this.startAnimating();
                break;
            }
            case 1: 
            case 3: {
                this.requestStop();
            }
        }
        return this.mExclusive && this.mAnimating;
    }

    private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper$shouldAnimate() {
        ClampedScroller scroller = this.mScroller;
        int verticalDirection = scroller.getVerticalDirection();
        int horizontalDirection = scroller.getHorizontalDirection();
        return verticalDirection != 0 && this.canTargetScrollVertically(verticalDirection) || horizontalDirection != 0 && this.canTargetScrollHorizontally(horizontalDirection);
    }

    private final void $$robo$$com_android_internal_widget_AutoScrollHelper$startAnimating() {
        if (this.mRunnable == null) {
            this.mRunnable = new ScrollAnimationRunnable(this);
        }
        this.mAnimating = true;
        this.mNeedsReset = true;
        if (!this.mAlreadyDelayed && this.mActivationDelay > 0) {
            this.mTarget.postOnAnimationDelayed(this.mRunnable, this.mActivationDelay);
        } else {
            this.mRunnable.run();
        }
        this.mAlreadyDelayed = true;
    }

    private final void $$robo$$com_android_internal_widget_AutoScrollHelper$requestStop() {
        if (this.mNeedsReset) {
            this.mAnimating = false;
        } else {
            this.mScroller.requestStop();
        }
    }

    private final float $$robo$$com_android_internal_widget_AutoScrollHelper$computeTargetVelocity(int direction, float coordinate, float srcSize, float dstSize) {
        float relativeEdge = this.mRelativeEdges[direction];
        float maximumEdge = this.mMaximumEdges[direction];
        float value = this.getEdgeValue(relativeEdge, srcSize, maximumEdge, coordinate);
        if (value == 0.0f) {
            return 0.0f;
        }
        float relativeVelocity = this.mRelativeVelocity[direction];
        float minimumVelocity = this.mMinimumVelocity[direction];
        float maximumVelocity = this.mMaximumVelocity[direction];
        float targetVelocity = relativeVelocity * dstSize;
        if (value > 0.0f) {
            return AutoScrollHelper.constrain(value * targetVelocity, minimumVelocity, maximumVelocity);
        }
        return -AutoScrollHelper.constrain(-value * targetVelocity, minimumVelocity, maximumVelocity);
    }

    public abstract void scrollTargetBy(int var1, int var2);

    public abstract boolean canTargetScrollHorizontally(int var1);

    public abstract boolean canTargetScrollVertically(int var1);

    private final float $$robo$$com_android_internal_widget_AutoScrollHelper$getEdgeValue(float relativeValue, float size, float maxValue, float current) {
        float interpolated;
        float edgeSize = AutoScrollHelper.constrain(relativeValue * size, 0.0f, maxValue);
        float valueLeading = this.constrainEdgeValue(current, edgeSize);
        float valueTrailing = this.constrainEdgeValue(size - current, edgeSize);
        float value = valueTrailing - valueLeading;
        if (value < 0.0f) {
            interpolated = -this.mEdgeInterpolator.getInterpolation(-value);
        } else if (value > 0.0f) {
            interpolated = this.mEdgeInterpolator.getInterpolation(value);
        } else {
            return 0.0f;
        }
        return AutoScrollHelper.constrain(interpolated, -1.0f, 1.0f);
    }

    private final float $$robo$$com_android_internal_widget_AutoScrollHelper$constrainEdgeValue(float current, float leading) {
        if (leading == 0.0f) {
            return 0.0f;
        }
        switch (this.mEdgeType) {
            case 0: 
            case 1: {
                if (!(current < leading)) break;
                if (current >= 0.0f) {
                    return 1.0f - current / leading;
                }
                if (!this.mAnimating || this.mEdgeType != 1) break;
                return 1.0f;
            }
            case 2: {
                if (!(current < 0.0f)) break;
                return current / -leading;
            }
        }
        return 0.0f;
    }

    private static final int $$robo$$com_android_internal_widget_AutoScrollHelper$constrain(int value, int min, int max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    private static final float $$robo$$com_android_internal_widget_AutoScrollHelper$constrain(float value, float min, float max) {
        if (value > max) {
            return max;
        }
        if (value < min) {
            return min;
        }
        return value;
    }

    private final void $$robo$$com_android_internal_widget_AutoScrollHelper$cancelTargetTouch() {
        long eventTime = SystemClock.uptimeMillis();
        MotionEvent cancel = MotionEvent.obtain(eventTime, eventTime, 3, 0.0f, 0.0f, 0);
        this.mTarget.onTouchEvent(cancel);
        cancel.recycle();
    }

    static void __staticInitializer__() {
        DEFAULT_ACTIVATION_DELAY = ViewConfiguration.getTapTimeout();
    }

    private void __constructor__(View view) {
        this.$$robo$$com_android_internal_widget_AutoScrollHelper$__constructor__(view);
    }

    public AutoScrollHelper(View view) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AutoScrollHelper$__constructor__(android.view.View ), 0, this, view);
    }

    public AutoScrollHelper setEnabled(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$com_android_internal_widget_AutoScrollHelper$setEnabled(boolean ), 0, this, bl);
    }

    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_widget_AutoScrollHelper$isEnabled(), 0, this);
    }

    public AutoScrollHelper setExclusive(boolean bl) {
        return InvokeDynamicSupport.bootstrap("setExclusive", $$robo$$com_android_internal_widget_AutoScrollHelper$setExclusive(boolean ), 0, this, bl);
    }

    public boolean isExclusive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isExclusive", $$robo$$com_android_internal_widget_AutoScrollHelper$isExclusive(), 0, this);
    }

    public AutoScrollHelper setMaximumVelocity(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("setMaximumVelocity", $$robo$$com_android_internal_widget_AutoScrollHelper$setMaximumVelocity(float float ), 0, this, f, f2);
    }

    public AutoScrollHelper setMinimumVelocity(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("setMinimumVelocity", $$robo$$com_android_internal_widget_AutoScrollHelper$setMinimumVelocity(float float ), 0, this, f, f2);
    }

    public AutoScrollHelper setRelativeVelocity(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("setRelativeVelocity", $$robo$$com_android_internal_widget_AutoScrollHelper$setRelativeVelocity(float float ), 0, this, f, f2);
    }

    public AutoScrollHelper setEdgeType(int n) {
        return InvokeDynamicSupport.bootstrap("setEdgeType", $$robo$$com_android_internal_widget_AutoScrollHelper$setEdgeType(int ), 0, this, n);
    }

    public AutoScrollHelper setRelativeEdges(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("setRelativeEdges", $$robo$$com_android_internal_widget_AutoScrollHelper$setRelativeEdges(float float ), 0, this, f, f2);
    }

    public AutoScrollHelper setMaximumEdges(float f, float f2) {
        return InvokeDynamicSupport.bootstrap("setMaximumEdges", $$robo$$com_android_internal_widget_AutoScrollHelper$setMaximumEdges(float float ), 0, this, f, f2);
    }

    public AutoScrollHelper setActivationDelay(int n) {
        return InvokeDynamicSupport.bootstrap("setActivationDelay", $$robo$$com_android_internal_widget_AutoScrollHelper$setActivationDelay(int ), 0, this, n);
    }

    public AutoScrollHelper setRampUpDuration(int n) {
        return InvokeDynamicSupport.bootstrap("setRampUpDuration", $$robo$$com_android_internal_widget_AutoScrollHelper$setRampUpDuration(int ), 0, this, n);
    }

    public AutoScrollHelper setRampDownDuration(int n) {
        return InvokeDynamicSupport.bootstrap("setRampDownDuration", $$robo$$com_android_internal_widget_AutoScrollHelper$setRampDownDuration(int ), 0, this, n);
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$com_android_internal_widget_AutoScrollHelper$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
    }

    private boolean shouldAnimate() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAnimate", $$robo$$com_android_internal_widget_AutoScrollHelper$shouldAnimate(), 0, this);
    }

    private void startAnimating() {
        InvokeDynamicSupport.bootstrap("startAnimating", $$robo$$com_android_internal_widget_AutoScrollHelper$startAnimating(), 0, this);
    }

    private void requestStop() {
        InvokeDynamicSupport.bootstrap("requestStop", $$robo$$com_android_internal_widget_AutoScrollHelper$requestStop(), 0, this);
    }

    private float computeTargetVelocity(int n, float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrap("computeTargetVelocity", $$robo$$com_android_internal_widget_AutoScrollHelper$computeTargetVelocity(int float float float ), 0, this, n, f, f2, f3);
    }

    private float getEdgeValue(float f, float f2, float f3, float f4) {
        return (float)InvokeDynamicSupport.bootstrap("getEdgeValue", $$robo$$com_android_internal_widget_AutoScrollHelper$getEdgeValue(float float float float ), 0, this, f, f2, f3, f4);
    }

    private float constrainEdgeValue(float f, float f2) {
        return (float)InvokeDynamicSupport.bootstrap("constrainEdgeValue", $$robo$$com_android_internal_widget_AutoScrollHelper$constrainEdgeValue(float float ), 0, this, f, f2);
    }

    private static int constrain(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("constrain", $$robo$$com_android_internal_widget_AutoScrollHelper$constrain(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    private static float constrain(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("constrain", $$robo$$com_android_internal_widget_AutoScrollHelper$constrain(float float float ), 0, (float)f, (float)f2, (float)f3);
    }

    private void cancelTargetTouch() {
        InvokeDynamicSupport.bootstrap("cancelTargetTouch", $$robo$$com_android_internal_widget_AutoScrollHelper$cancelTargetTouch(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AutoScrollHelper.class);
    }

    public /* synthetic */ AutoScrollHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutoScrollHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class AbsListViewAutoScroller
    extends AutoScrollHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AbsListView mTarget;

        private void $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$__constructor__(AbsListView target) {
            this.mTarget = target;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$scrollTargetBy(int deltaX, int deltaY) {
            this.mTarget.scrollListBy(deltaY);
        }

        private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$canTargetScrollHorizontally(int direction) {
            return false;
        }

        private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$canTargetScrollVertically(int direction) {
            AbsListView target = this.mTarget;
            int itemCount = target.getCount();
            if (itemCount == 0) {
                return false;
            }
            int childCount = target.getChildCount();
            int firstPosition = target.getFirstVisiblePosition();
            int lastPosition = firstPosition + childCount;
            if (direction > 0) {
                View lastView;
                if (lastPosition >= itemCount && (lastView = target.getChildAt(childCount - 1)).getBottom() <= target.getHeight()) {
                    return false;
                }
            } else if (direction < 0) {
                View firstView;
                if (firstPosition <= 0 && (firstView = target.getChildAt(0)).getTop() >= 0) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private void __constructor__(AbsListView absListView) {
            this.$$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$__constructor__(absListView);
        }

        public AbsListViewAutoScroller(AbsListView absListView) {
            super(absListView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$__constructor__(android.widget.AbsListView ), 0, this, absListView);
        }

        @Override
        public void scrollTargetBy(int n, int n2) {
            InvokeDynamicSupport.bootstrap("scrollTargetBy", $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$scrollTargetBy(int int ), 0, this, n, n2);
        }

        @Override
        public boolean canTargetScrollHorizontally(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("canTargetScrollHorizontally", $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$canTargetScrollHorizontally(int ), 0, this, n);
        }

        @Override
        public boolean canTargetScrollVertically(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("canTargetScrollVertically", $$robo$$com_android_internal_widget_AutoScrollHelper_AbsListViewAutoScroller$canTargetScrollVertically(int ), 0, this, n);
        }

        public /* synthetic */ AbsListViewAutoScroller() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsListViewAutoScroller)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class ClampedScroller
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mRampUpDuration;
        private int mRampDownDuration;
        private float mTargetVelocityX;
        private float mTargetVelocityY;
        private long mStartTime;
        private long mDeltaTime;
        private int mDeltaX;
        private int mDeltaY;
        private long mStopTime;
        private float mStopValue;
        private int mEffectiveRampDown;

        private void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$__constructor__() {
            this.mStartTime = Long.MIN_VALUE;
            this.mStopTime = -1L;
            this.mDeltaTime = 0L;
            this.mDeltaX = 0;
            this.mDeltaY = 0;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setRampUpDuration(int durationMillis) {
            this.mRampUpDuration = durationMillis;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setRampDownDuration(int durationMillis) {
            this.mRampDownDuration = durationMillis;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$start() {
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStopTime = -1L;
            this.mDeltaTime = this.mStartTime;
            this.mStopValue = 0.5f;
            this.mDeltaX = 0;
            this.mDeltaY = 0;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$requestStop() {
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            this.mEffectiveRampDown = AutoScrollHelper.constrain((int)(currentTime - this.mStartTime), 0, this.mRampDownDuration);
            this.mStopValue = this.getValueAt(currentTime);
            this.mStopTime = currentTime;
        }

        private final boolean $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$isFinished() {
            return this.mStopTime > 0L && AnimationUtils.currentAnimationTimeMillis() > this.mStopTime + (long)this.mEffectiveRampDown;
        }

        private final float $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getValueAt(long currentTime) {
            if (currentTime < this.mStartTime) {
                return 0.0f;
            }
            if (this.mStopTime < 0L || currentTime < this.mStopTime) {
                long elapsedSinceStart = currentTime - this.mStartTime;
                return 0.5f * AutoScrollHelper.constrain((float)elapsedSinceStart / (float)this.mRampUpDuration, 0.0f, 1.0f);
            }
            long elapsedSinceEnd = currentTime - this.mStopTime;
            return 1.0f - this.mStopValue + this.mStopValue * AutoScrollHelper.constrain((float)elapsedSinceEnd / (float)this.mEffectiveRampDown, 0.0f, 1.0f);
        }

        private final float $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$interpolateValue(float value) {
            return -4.0f * value * value + 4.0f * value;
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$computeScrollDelta() {
            if (this.mDeltaTime == 0L) {
                throw new RuntimeException("Cannot compute scroll delta before calling start()");
            }
            long currentTime = AnimationUtils.currentAnimationTimeMillis();
            float value = this.getValueAt(currentTime);
            float scale = this.interpolateValue(value);
            long elapsedSinceDelta = currentTime - this.mDeltaTime;
            this.mDeltaTime = currentTime;
            this.mDeltaX = (int)((float)elapsedSinceDelta * scale * this.mTargetVelocityX);
            this.mDeltaY = (int)((float)elapsedSinceDelta * scale * this.mTargetVelocityY);
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setTargetVelocity(float x, float y) {
            this.mTargetVelocityX = x;
            this.mTargetVelocityY = y;
        }

        private final int $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getHorizontalDirection() {
            return (int)(this.mTargetVelocityX / Math.abs(this.mTargetVelocityX));
        }

        private final int $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getVerticalDirection() {
            return (int)(this.mTargetVelocityY / Math.abs(this.mTargetVelocityY));
        }

        private final int $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getDeltaX() {
            return this.mDeltaX;
        }

        private final int $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getDeltaY() {
            return this.mDeltaY;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$__constructor__();
        }

        public ClampedScroller() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$__constructor__(), 0, this);
        }

        public void setRampUpDuration(int n) {
            InvokeDynamicSupport.bootstrap("setRampUpDuration", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setRampUpDuration(int ), 0, this, n);
        }

        public void setRampDownDuration(int n) {
            InvokeDynamicSupport.bootstrap("setRampDownDuration", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setRampDownDuration(int ), 0, this, n);
        }

        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$start(), 0, this);
        }

        public void requestStop() {
            InvokeDynamicSupport.bootstrap("requestStop", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$requestStop(), 0, this);
        }

        public boolean isFinished() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$isFinished(), 0, this);
        }

        private float getValueAt(long l) {
            return (float)InvokeDynamicSupport.bootstrap("getValueAt", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getValueAt(long ), 0, this, l);
        }

        private float interpolateValue(float f) {
            return (float)InvokeDynamicSupport.bootstrap("interpolateValue", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$interpolateValue(float ), 0, this, f);
        }

        public void computeScrollDelta() {
            InvokeDynamicSupport.bootstrap("computeScrollDelta", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$computeScrollDelta(), 0, this);
        }

        public void setTargetVelocity(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setTargetVelocity", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$setTargetVelocity(float float ), 0, this, f, f2);
        }

        public int getHorizontalDirection() {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalDirection", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getHorizontalDirection(), 0, this);
        }

        public int getVerticalDirection() {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalDirection", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getVerticalDirection(), 0, this);
        }

        public int getDeltaX() {
            return (int)InvokeDynamicSupport.bootstrap("getDeltaX", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getDeltaX(), 0, this);
        }

        public int getDeltaY() {
            return (int)InvokeDynamicSupport.bootstrap("getDeltaY", $$robo$$com_android_internal_widget_AutoScrollHelper_ClampedScroller$getDeltaY(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClampedScroller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ScrollAnimationRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AutoScrollHelper this$0;

        private void $$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$__constructor__(AutoScrollHelper autoScrollHelper) {
        }

        private final void $$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$run() {
            ClampedScroller scroller;
            if (!this.this$0.mAnimating) {
                return;
            }
            if (this.this$0.mNeedsReset) {
                this.this$0.mNeedsReset = false;
                this.this$0.mScroller.start();
            }
            if ((scroller = this.this$0.mScroller).isFinished() || !this.this$0.shouldAnimate()) {
                this.this$0.mAnimating = false;
                return;
            }
            if (this.this$0.mNeedsCancel) {
                this.this$0.mNeedsCancel = false;
                this.this$0.cancelTargetTouch();
            }
            scroller.computeScrollDelta();
            int deltaX = scroller.getDeltaX();
            int deltaY = scroller.getDeltaY();
            this.this$0.scrollTargetBy(deltaX, deltaY);
            this.this$0.mTarget.postOnAnimation(this);
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$__constructor__(AutoScrollHelper x0, 1 x1) {
        }

        private void __constructor__(AutoScrollHelper autoScrollHelper) {
            this.$$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$__constructor__(autoScrollHelper);
        }

        private ScrollAnimationRunnable(AutoScrollHelper autoScrollHelper) {
            this.this$0 = autoScrollHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$__constructor__(com.android.internal.widget.AutoScrollHelper ), 0, this, autoScrollHelper);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AutoScrollHelper autoScrollHelper, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_AutoScrollHelper_ScrollAnimationRunnable$__constructor__(autoScrollHelper, var2_2);
        }

        public /* synthetic */ ScrollAnimationRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ScrollAnimationRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

