/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Bundle;
import android.text.Editable;
import android.text.Spanned;
import android.text.method.KeyListener;
import android.text.style.SuggestionSpan;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.widget.TextView;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EditableInputConnection
extends BaseInputConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "EditableInputConnection";
    private TextView mTextView;
    private int mBatchEditNesting;

    private void $$robo$$com_android_internal_widget_EditableInputConnection$__constructor__(TextView textview) {
        this.mTextView = textview;
    }

    private final Editable $$robo$$com_android_internal_widget_EditableInputConnection$getEditable() {
        TextView tv = this.mTextView;
        if (tv != null) {
            return tv.getEditableText();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$beginBatchEdit() {
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            if (this.mBatchEditNesting >= 0) {
                this.mTextView.beginBatchEdit();
                ++this.mBatchEditNesting;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$endBatchEdit() {
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            if (this.mBatchEditNesting > 0) {
                this.mTextView.endBatchEdit();
                --this.mBatchEditNesting;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_widget_EditableInputConnection$closeConnection() {
        super.closeConnection();
        EditableInputConnection editableInputConnection = this;
        synchronized (editableInputConnection) {
            while (this.mBatchEditNesting > 0) {
                this.endBatchEdit();
            }
            this.mBatchEditNesting = -1;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$clearMetaKeyStates(int states) {
        Editable content = this.getEditable();
        if (content == null) {
            return false;
        }
        KeyListener kl = this.mTextView.getKeyListener();
        if (kl != null) {
            try {
                kl.clearMetaKeyState(this.mTextView, content, states);
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$commitCompletion(CompletionInfo text) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCompletion(text);
        this.mTextView.endBatchEdit();
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$commitCorrection(CorrectionInfo correctionInfo) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onCommitCorrection(correctionInfo);
        this.mTextView.endBatchEdit();
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$performEditorAction(int actionCode) {
        this.mTextView.onEditorAction(actionCode);
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$performContextMenuAction(int id2) {
        this.mTextView.beginBatchEdit();
        this.mTextView.onTextContextMenuItem(id2);
        this.mTextView.endBatchEdit();
        return true;
    }

    private final ExtractedText $$robo$$com_android_internal_widget_EditableInputConnection$getExtractedText(ExtractedTextRequest request, int flags) {
        ExtractedText et;
        if (this.mTextView != null && this.mTextView.extractText(request, et = new ExtractedText())) {
            if ((flags & 1) != 0) {
                this.mTextView.setExtracting(request);
            }
            return et;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$performPrivateCommand(String action, Bundle data) {
        this.mTextView.onPrivateIMECommand(action, data);
        return true;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$commitText(CharSequence text, int newCursorPosition) {
        if (this.mTextView == null) {
            return super.commitText(text, newCursorPosition);
        }
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            SuggestionSpan[] spans = spanned.getSpans(0, text.length(), SuggestionSpan.class);
            this.mIMM.registerSuggestionSpansForNotification(spans);
        }
        this.mTextView.resetErrorChangedFlag();
        boolean success = super.commitText(text, newCursorPosition);
        this.mTextView.hideErrorIfUnchanged();
        return success;
    }

    private final boolean $$robo$$com_android_internal_widget_EditableInputConnection$requestCursorUpdates(int cursorUpdateMode) {
        int KNOWN_FLAGS_MASK = 3;
        int unknownFlags = cursorUpdateMode & 0xFFFFFFFC;
        if (unknownFlags != 0) {
            return false;
        }
        if (this.mIMM == null) {
            return false;
        }
        this.mIMM.setUpdateCursorAnchorInfoMode(cursorUpdateMode);
        if ((cursorUpdateMode & 1) != 0 && this.mTextView != null && !this.mTextView.isInLayout()) {
            this.mTextView.requestLayout();
        }
        return true;
    }

    private void __constructor__(TextView textView) {
        this.$$robo$$com_android_internal_widget_EditableInputConnection$__constructor__(textView);
    }

    public EditableInputConnection(TextView textView) {
        super(textView, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_EditableInputConnection$__constructor__(android.widget.TextView ), 0, this, textView);
    }

    @Override
    public Editable getEditable() {
        return InvokeDynamicSupport.bootstrap("getEditable", $$robo$$com_android_internal_widget_EditableInputConnection$getEditable(), 0, this);
    }

    @Override
    public boolean beginBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("beginBatchEdit", $$robo$$com_android_internal_widget_EditableInputConnection$beginBatchEdit(), 0, this);
    }

    @Override
    public boolean endBatchEdit() {
        return (boolean)InvokeDynamicSupport.bootstrap("endBatchEdit", $$robo$$com_android_internal_widget_EditableInputConnection$endBatchEdit(), 0, this);
    }

    @Override
    public void closeConnection() {
        InvokeDynamicSupport.bootstrap("closeConnection", $$robo$$com_android_internal_widget_EditableInputConnection$closeConnection(), 0, this);
    }

    @Override
    public boolean clearMetaKeyStates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("clearMetaKeyStates", $$robo$$com_android_internal_widget_EditableInputConnection$clearMetaKeyStates(int ), 0, this, n);
    }

    @Override
    public boolean commitCompletion(CompletionInfo completionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCompletion", $$robo$$com_android_internal_widget_EditableInputConnection$commitCompletion(android.view.inputmethod.CompletionInfo ), 0, this, completionInfo);
    }

    @Override
    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitCorrection", $$robo$$com_android_internal_widget_EditableInputConnection$commitCorrection(android.view.inputmethod.CorrectionInfo ), 0, this, correctionInfo);
    }

    @Override
    public boolean performEditorAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performEditorAction", $$robo$$com_android_internal_widget_EditableInputConnection$performEditorAction(int ), 0, this, n);
    }

    @Override
    public boolean performContextMenuAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performContextMenuAction", $$robo$$com_android_internal_widget_EditableInputConnection$performContextMenuAction(int ), 0, this, n);
    }

    @Override
    public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
        return InvokeDynamicSupport.bootstrap("getExtractedText", $$robo$$com_android_internal_widget_EditableInputConnection$getExtractedText(android.view.inputmethod.ExtractedTextRequest int ), 0, this, extractedTextRequest, n);
    }

    @Override
    public boolean performPrivateCommand(String string2, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performPrivateCommand", $$robo$$com_android_internal_widget_EditableInputConnection$performPrivateCommand(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    @Override
    public boolean commitText(CharSequence charSequence, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("commitText", $$robo$$com_android_internal_widget_EditableInputConnection$commitText(java.lang.CharSequence int ), 0, this, charSequence, n);
    }

    @Override
    public boolean requestCursorUpdates(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestCursorUpdates", $$robo$$com_android_internal_widget_EditableInputConnection$requestCursorUpdates(int ), 0, this, n);
    }

    public /* synthetic */ EditableInputConnection() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EditableInputConnection)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

