/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.app.ResolverActivity;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public final class PinnerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "PinnerService";
    private final Context mContext;
    private final ArrayList<PinnedFile> mPinnedFiles = new ArrayList();
    private final ArrayList<PinnedFile> mPinnedCameraFiles = new ArrayList();
    private final boolean mShouldPinCamera;
    private BinderService mBinderService;
    private final long MAX_CAMERA_PIN_SIZE = 0x5000000L;
    private PinnerHandler mPinnerHandler = null;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction() == "android.intent.action.PACKAGE_REPLACED") {
                Uri packageUri = intent.getData();
                String packageName = packageUri.getSchemeSpecificPart();
                ArraySet<String> updatedPackages = new ArraySet<String>();
                updatedPackages.add(packageName);
                PinnerService.this.update(updatedPackages);
            }
        }
    };

    public PinnerService(Context context) {
        super(context);
        this.mContext = context;
        this.mShouldPinCamera = context.getResources().getBoolean(17956981);
        this.mPinnerHandler = new PinnerHandler(BackgroundThread.get().getLooper());
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REPLACED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
    }

    @Override
    public void onStart() {
        this.mBinderService = new BinderService();
        this.publishBinderService("pinner", this.mBinderService);
        this.publishLocalService(PinnerService.class, this);
        this.mPinnerHandler.obtainMessage(4001).sendToTarget();
        this.mPinnerHandler.obtainMessage(4000, 0, 0).sendToTarget();
    }

    @Override
    public void onSwitchUser(int userHandle) {
        this.mPinnerHandler.obtainMessage(4000, userHandle, 0).sendToTarget();
    }

    public void update(ArraySet<String> updatedPackages) {
        ApplicationInfo cameraInfo = this.getCameraInfo(0);
        if (cameraInfo != null && updatedPackages.contains(cameraInfo.packageName)) {
            Slog.i(TAG, "Updating pinned files.");
            this.mPinnerHandler.obtainMessage(4000, 0, 0).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePinOnStart() {
        String[] filesToPin = this.mContext.getResources().getStringArray(17235997);
        PinnerService pinnerService = this;
        synchronized (pinnerService) {
            for (int i = 0; i < filesToPin.length; ++i) {
                PinnedFile pf = PinnerService.pinFile(filesToPin[i], 0L, 0L, 0L);
                if (pf != null) {
                    this.mPinnedFiles.add(pf);
                    continue;
                }
                Slog.e(TAG, "Failed to pin file = " + filesToPin[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePinCamera(int userHandle) {
        if (this.mShouldPinCamera) {
            PinnerService pinnerService = this;
            synchronized (pinnerService) {
                boolean success = this.pinCamera(userHandle);
                if (!success) {
                    // empty if block
                }
            }
        }
    }

    private boolean alreadyPinned(int userHandle) {
        ApplicationInfo cameraInfo = this.getCameraInfo(userHandle);
        if (cameraInfo == null) {
            return false;
        }
        for (int i = 0; i < this.mPinnedCameraFiles.size(); ++i) {
            if (!this.mPinnedCameraFiles.get((int)i).mFilename.equals(cameraInfo.sourceDir)) continue;
            return true;
        }
        return false;
    }

    private void unpinCameraApp() {
        for (int i = 0; i < this.mPinnedCameraFiles.size(); ++i) {
            PinnerService.unpinFile(this.mPinnedCameraFiles.get(i));
        }
        this.mPinnedCameraFiles.clear();
    }

    private boolean isResolverActivity(ActivityInfo info) {
        return ResolverActivity.class.getName().equals(info.name);
    }

    private ApplicationInfo getCameraInfo(int userHandle) {
        Intent cameraIntent = new Intent("android.media.action.STILL_IMAGE_CAMERA");
        PackageManager pm = this.mContext.getPackageManager();
        ResolveInfo cameraResolveInfo = pm.resolveActivityAsUser(cameraIntent, 851968, userHandle);
        if (cameraResolveInfo == null) {
            return null;
        }
        if (this.isResolverActivity(cameraResolveInfo.activityInfo)) {
            return null;
        }
        return cameraResolveInfo.activityInfo.applicationInfo;
    }

    private boolean pinCamera(int userHandle) {
        ApplicationInfo cameraInfo = this.getCameraInfo(userHandle);
        if (cameraInfo == null) {
            return false;
        }
        this.unpinCameraApp();
        String camAPK = cameraInfo.sourceDir;
        PinnedFile pf = PinnerService.pinFile(camAPK, 0L, 0L, 0x5000000L);
        if (pf == null) {
            Slog.e(TAG, "Failed to pin " + camAPK);
            return false;
        }
        this.mPinnedCameraFiles.add(pf);
        String arch = "arm";
        if (cameraInfo.primaryCpuAbi != null && VMRuntime.is64BitAbi(cameraInfo.primaryCpuAbi)) {
            arch = arch + "64";
        } else if (VMRuntime.is64BitAbi(Build.SUPPORTED_ABIS[0])) {
            arch = arch + "64";
        }
        String baseCodePath = cameraInfo.getBaseCodePath();
        String[] files = null;
        try {
            files = DexFile.getDexFileOutputPaths(baseCodePath, arch);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (files == null) {
            return true;
        }
        for (String file : files) {
            pf = PinnerService.pinFile(file, 0L, 0L, 0x5000000L);
            if (pf == null) continue;
            this.mPinnedCameraFiles.add(pf);
        }
        return true;
    }

    private static PinnedFile pinFile(String fileToPin, long offset, long length, long maxSize) {
        FileDescriptor fd = new FileDescriptor();
        try {
            fd = Os.open(fileToPin, OsConstants.O_RDONLY | OsConstants.O_CLOEXEC | OsConstants.O_NOFOLLOW, OsConstants.O_RDONLY);
            StructStat sb = Os.fstat(fd);
            if (offset + length > sb.st_size) {
                Os.close(fd);
                Slog.e(TAG, "Failed to pin file " + fileToPin + ", request extends beyond end of file.  offset + length =  " + (offset + length) + ", file length = " + sb.st_size);
                return null;
            }
            if (length == 0L) {
                length = sb.st_size - offset;
            }
            if (maxSize > 0L && length > maxSize) {
                Slog.e(TAG, "Could not pin file " + fileToPin + ", size = " + length + ", maxSize = " + maxSize);
                Os.close(fd);
                return null;
            }
            long address = Os.mmap(0L, length, OsConstants.PROT_READ, OsConstants.MAP_PRIVATE, fd, offset);
            Os.close(fd);
            Os.mlock(address, length);
            return new PinnedFile(address, length, fileToPin);
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Could not pin file " + fileToPin + " with error " + e.getMessage());
            if (fd.valid()) {
                try {
                    Os.close(fd);
                }
                catch (ErrnoException eClose) {
                    Slog.e(TAG, "Failed to close fd, error = " + eClose.getMessage());
                }
            }
            return null;
        }
    }

    private static boolean unpinFile(PinnedFile pf) {
        try {
            Os.munlock(pf.mAddress, pf.mLength);
        }
        catch (ErrnoException e) {
            Slog.e(TAG, "Failed to unpin file " + pf.mFilename + " with error " + e.getMessage());
            return false;
        }
        return true;
    }

    final class PinnerHandler
    extends Handler {
        static final int PIN_CAMERA_MSG = 4000;
        static final int PIN_ONSTART_MSG = 4001;

        public PinnerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4000: {
                    PinnerService.this.handlePinCamera(msg.arg1);
                    break;
                }
                case 4001: {
                    PinnerService.this.handlePinOnStart();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private static class PinnedFile {
        long mAddress;
        long mLength;
        String mFilename;

        PinnedFile(long address, long length, String filename) {
            this.mAddress = address;
            this.mLength = length;
            this.mFilename = filename;
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(PinnerService.this.mContext, PinnerService.TAG, pw)) {
                return;
            }
            pw.println("Pinned Files:");
            BinderService binderService = this;
            synchronized (binderService) {
                int i;
                for (i = 0; i < PinnerService.this.mPinnedFiles.size(); ++i) {
                    pw.println(((PinnedFile)((PinnerService)PinnerService.this).mPinnedFiles.get((int)i)).mFilename);
                }
                for (i = 0; i < PinnerService.this.mPinnedCameraFiles.size(); ++i) {
                    pw.println(((PinnedFile)((PinnerService)PinnerService.this).mPinnedCameraFiles.get((int)i)).mFilename);
                }
            }
        }
    }
}

