/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.input.InputManager;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorService;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Slog;
import android.view.InputDevice;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;

public class VibratorService
extends IVibratorService.Stub
implements InputManager.InputDeviceListener {
    private static final String TAG = "VibratorService";
    private static final boolean DEBUG = false;
    private static final String SYSTEM_UI_PACKAGE = "com.android.systemui";
    private final LinkedList<VibrationInfo> mPreviousVibrations;
    private final int mPreviousVibrationsLimit;
    private final boolean mAllowPriorityVibrationsInLowPowerMode;
    private final boolean mSupportsAmplitudeControl;
    private final int mDefaultVibrationAmplitude;
    private final VibrationEffect[] mFallbackEffects;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private final Handler mH = new Handler();
    private final Object mLock = new Object();
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final IAppOpsService mAppOpsService;
    private final IBatteryStats mBatteryStatsService;
    private PowerManagerInternal mPowerManagerInternal;
    private InputManager mIm;
    private volatile VibrateThread mThread;
    private final ArrayList<Vibrator> mInputDeviceVibrators = new ArrayList();
    private boolean mVibrateInputDevicesSetting;
    private boolean mInputDeviceListenerRegistered;
    private Vibration mCurrentVibration;
    private int mCurVibUid = -1;
    private boolean mLowPowerMode;
    private SettingsObserver mSettingObserver;
    private final Runnable mVibrationEndRunnable = new Runnable(){

        @Override
        public void run() {
            VibratorService.this.onVibrationFinished();
        }
    };
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                Object object = VibratorService.this.mLock;
                synchronized (object) {
                    if (VibratorService.this.mCurrentVibration != null && !VibratorService.this.mCurrentVibration.isSystemHapticFeedback()) {
                        VibratorService.this.doCancelVibrateLocked();
                    }
                }
            }
        }
    };

    static native boolean vibratorExists();

    static native void vibratorInit();

    static native void vibratorOn(long var0);

    static native void vibratorOff();

    static native boolean vibratorSupportsAmplitudeControl();

    static native void vibratorSetAmplitude(int var0);

    static native long vibratorPerformEffect(long var0, long var2);

    VibratorService(Context context) {
        VibratorService.vibratorInit();
        VibratorService.vibratorOff();
        this.mSupportsAmplitudeControl = VibratorService.vibratorSupportsAmplitudeControl();
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*vibrator*");
        this.mWakeLock.setReferenceCounted(true);
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.mBatteryStatsService = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPreviousVibrationsLimit = this.mContext.getResources().getInteger(17694835);
        this.mDefaultVibrationAmplitude = this.mContext.getResources().getInteger(17694770);
        this.mAllowPriorityVibrationsInLowPowerMode = this.mContext.getResources().getBoolean(17956875);
        this.mPreviousVibrations = new LinkedList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, filter);
        long[] clickEffectTimings = VibratorService.getLongIntArray(context.getResources(), 17236042);
        VibrationEffect clickEffect = clickEffectTimings.length == 0 ? null : (clickEffectTimings.length == 1 ? VibrationEffect.createOneShot(clickEffectTimings[0], -1) : VibrationEffect.createWaveform(clickEffectTimings, -1));
        VibrationEffect doubleClickEffect = VibrationEffect.createWaveform(new long[]{0L, 30L, 100L, 30L}, -1);
        this.mFallbackEffects = new VibrationEffect[]{clickEffect, doubleClickEffect};
    }

    public void systemReady() {
        this.mIm = this.mContext.getSystemService(InputManager.class);
        this.mSettingObserver = new SettingsObserver(this.mH);
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

            @Override
            public int getServiceType() {
                return 2;
            }

            @Override
            public void onLowPowerModeChanged(PowerSaveState result) {
                VibratorService.this.updateVibrators();
            }
        });
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("vibrate_input_devices"), true, this.mSettingObserver, -1);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                VibratorService.this.updateVibrators();
            }
        }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mH);
        this.updateVibrators();
    }

    @Override
    public boolean hasVibrator() {
        return this.doVibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAmplitudeControl() {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            return this.mSupportsAmplitudeControl && this.mInputDeviceVibrators.isEmpty();
        }
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static boolean verifyVibrationEffect(VibrationEffect effect) {
        if (effect == null) {
            Slog.wtf(TAG, "effect must not be null");
            return false;
        }
        try {
            effect.validate();
        }
        catch (Exception e) {
            Slog.wtf(TAG, "Encountered issue when verifying VibrationEffect.", e);
            return false;
        }
        return true;
    }

    private static long[] getLongIntArray(Resources r, int resid) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return null;
        }
        long[] out = new long[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vibrate(int uid, String opPkg, VibrationEffect effect, int usageHint, IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
            throw new SecurityException("Requires VIBRATE permission");
        }
        if (token == null) {
            Slog.e(TAG, "token must not be null");
            return;
        }
        this.verifyIncomingUid(uid);
        if (!VibratorService.verifyVibrationEffect(effect)) {
            return;
        }
        if (effect instanceof VibrationEffect.OneShot && this.mCurrentVibration != null && this.mCurrentVibration.mEffect instanceof VibrationEffect.OneShot) {
            VibrationEffect.OneShot newOneShot = (VibrationEffect.OneShot)effect;
            VibrationEffect.OneShot currentOneShot = (VibrationEffect.OneShot)this.mCurrentVibration.mEffect;
            if (this.mCurrentVibration.hasLongerTimeout(newOneShot.getTiming()) && newOneShot.getAmplitude() == currentOneShot.getAmplitude()) {
                return;
            }
        }
        Vibration vib = new Vibration(token, effect, usageHint, uid, opPkg);
        if (effect instanceof VibrationEffect.Waveform) {
            try {
                token.linkToDeath(vib, 0);
            }
            catch (RemoteException e) {
                return;
            }
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mLock;
            synchronized (object) {
                this.doCancelVibrateLocked();
                this.startVibrationLocked(vib);
                this.addToPreviousVibrationsLocked(vib);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void addToPreviousVibrationsLocked(Vibration vib) {
        if (this.mPreviousVibrations.size() > this.mPreviousVibrationsLimit) {
            this.mPreviousVibrations.removeFirst();
        }
        this.mPreviousVibrations.addLast(new VibrationInfo(vib.mStartTime, vib.mEffect, vib.mUsageHint, vib.mUid, vib.mOpPkg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVibrate(IBinder token) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.VIBRATE", "cancelVibrate");
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentVibration != null && this.mCurrentVibration.mToken == token) {
                long ident = Binder.clearCallingIdentity();
                try {
                    this.doCancelVibrateLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    private void doCancelVibrateLocked() {
        this.mH.removeCallbacks(this.mVibrationEndRunnable);
        if (this.mThread != null) {
            this.mThread.cancel();
            this.mThread = null;
        }
        this.doVibratorOff();
        this.reportFinishVibrationLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onVibrationFinished() {
        Object object = this.mLock;
        synchronized (object) {
            this.doCancelVibrateLocked();
        }
    }

    private void startVibrationLocked(Vibration vib) {
        if (!this.isAllowedToVibrate(vib)) {
            return;
        }
        if (vib.mUsageHint == 6 && !this.shouldVibrateForRingtone()) {
            return;
        }
        int mode = this.getAppOpMode(vib);
        if (mode != 0) {
            if (mode == 2) {
                Slog.w(TAG, "Would be an error: vibrate from uid " + vib.mUid);
            }
            return;
        }
        this.startVibrationInnerLocked(vib);
    }

    private void startVibrationInnerLocked(Vibration vib) {
        this.mCurrentVibration = vib;
        if (vib.mEffect instanceof VibrationEffect.OneShot) {
            VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)vib.mEffect;
            this.doVibratorOn(oneShot.getTiming(), oneShot.getAmplitude(), vib.mUid, vib.mUsageHint);
            this.mH.postDelayed(this.mVibrationEndRunnable, oneShot.getTiming());
        } else if (vib.mEffect instanceof VibrationEffect.Waveform) {
            VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)vib.mEffect;
            this.mThread = new VibrateThread(waveform, vib.mUid, vib.mUsageHint);
            this.mThread.start();
        } else if (vib.mEffect instanceof VibrationEffect.Prebaked) {
            long timeout = this.doVibratorPrebakedEffectLocked(vib);
            if (timeout > 0L) {
                this.mH.postDelayed(this.mVibrationEndRunnable, timeout);
            }
        } else {
            Slog.e(TAG, "Unknown vibration type, ignoring");
        }
    }

    private boolean isAllowedToVibrate(Vibration vib) {
        if (!this.mLowPowerMode) {
            return true;
        }
        if (vib.mUsageHint == 6) {
            return true;
        }
        if (!this.mAllowPriorityVibrationsInLowPowerMode) {
            return false;
        }
        return vib.mUsageHint == 4 || vib.mUsageHint == 11 || vib.mUsageHint == 7;
    }

    private boolean shouldVibrateForRingtone() {
        AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
        int ringerMode = audioManager.getRingerModeInternal();
        if (Settings.System.getInt(this.mContext.getContentResolver(), "vibrate_when_ringing", 0) != 0) {
            return ringerMode != 0;
        }
        return ringerMode == 1;
    }

    private int getAppOpMode(Vibration vib) {
        int mode;
        try {
            mode = this.mAppOpsService.checkAudioOperation(3, vib.mUsageHint, vib.mUid, vib.mOpPkg);
            if (mode == 0) {
                mode = this.mAppOpsService.startOperation(AppOpsManager.getToken(this.mAppOpsService), 3, vib.mUid, vib.mOpPkg);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to get appop mode for vibration!", e);
            mode = 1;
        }
        return mode;
    }

    private void reportFinishVibrationLocked() {
        if (this.mCurrentVibration != null) {
            try {
                this.mAppOpsService.finishOperation(AppOpsManager.getToken(this.mAppOpsService), 3, this.mCurrentVibration.mUid, this.mCurrentVibration.mOpPkg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurrentVibration = null;
        }
    }

    private void unlinkVibration(Vibration vib) {
        if (vib.mEffect instanceof VibrationEffect.Waveform) {
            vib.mToken.unlinkToDeath(vib, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVibrators() {
        Object object = this.mLock;
        synchronized (object) {
            boolean devicesUpdated = this.updateInputDeviceVibratorsLocked();
            boolean lowPowerModeUpdated = this.updateLowPowerModeLocked();
            if (devicesUpdated || lowPowerModeUpdated) {
                this.doCancelVibrateLocked();
            }
        }
    }

    private boolean updateInputDeviceVibratorsLocked() {
        boolean changed = false;
        boolean vibrateInputDevices = false;
        try {
            vibrateInputDevices = Settings.System.getIntForUser(this.mContext.getContentResolver(), "vibrate_input_devices", -2) > 0;
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            // empty catch block
        }
        if (vibrateInputDevices != this.mVibrateInputDevicesSetting) {
            changed = true;
            this.mVibrateInputDevicesSetting = vibrateInputDevices;
        }
        if (this.mVibrateInputDevicesSetting) {
            if (!this.mInputDeviceListenerRegistered) {
                this.mInputDeviceListenerRegistered = true;
                this.mIm.registerInputDeviceListener(this, this.mH);
            }
        } else if (this.mInputDeviceListenerRegistered) {
            this.mInputDeviceListenerRegistered = false;
            this.mIm.unregisterInputDeviceListener(this);
        }
        this.mInputDeviceVibrators.clear();
        if (this.mVibrateInputDevicesSetting) {
            int[] ids = this.mIm.getInputDeviceIds();
            for (int i = 0; i < ids.length; ++i) {
                InputDevice device = this.mIm.getInputDevice(ids[i]);
                Vibrator vibrator = device.getVibrator();
                if (!vibrator.hasVibrator()) continue;
                this.mInputDeviceVibrators.add(vibrator);
            }
            return true;
        }
        return changed;
    }

    private boolean updateLowPowerModeLocked() {
        boolean lowPowerMode = this.mPowerManagerInternal.getLowPowerState((int)2).batterySaverEnabled;
        if (lowPowerMode != this.mLowPowerMode) {
            this.mLowPowerMode = lowPowerMode;
            return true;
        }
        return false;
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.updateVibrators();
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.updateVibrators();
    }

    private boolean doVibratorExists() {
        return VibratorService.vibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOn(long millis, int amplitude, int uid, int usageHint) {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            if (amplitude == -1) {
                amplitude = this.mDefaultVibrationAmplitude;
            }
            this.noteVibratorOnLocked(uid, millis);
            int vibratorCount = this.mInputDeviceVibrators.size();
            if (vibratorCount != 0) {
                AudioAttributes attributes = new AudioAttributes.Builder().setUsage(usageHint).build();
                for (int i = 0; i < vibratorCount; ++i) {
                    this.mInputDeviceVibrators.get(i).vibrate(millis, attributes);
                }
            } else {
                VibratorService.vibratorOn(millis);
                this.doVibratorSetAmplitude(amplitude);
            }
        }
    }

    private void doVibratorSetAmplitude(int amplitude) {
        if (this.mSupportsAmplitudeControl) {
            VibratorService.vibratorSetAmplitude(amplitude);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOff() {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            this.noteVibratorOffLocked();
            int vibratorCount = this.mInputDeviceVibrators.size();
            if (vibratorCount != 0) {
                for (int i = 0; i < vibratorCount; ++i) {
                    this.mInputDeviceVibrators.get(i).cancel();
                }
            } else {
                VibratorService.vibratorOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doVibratorPrebakedEffectLocked(Vibration vib) {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            long timeout;
            VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)vib.mEffect;
            int vibratorCount = this.mInputDeviceVibrators.size();
            if (vibratorCount == 0 && (timeout = VibratorService.vibratorPerformEffect(prebaked.getId(), 1L)) > 0L) {
                this.noteVibratorOnLocked(vib.mUid, timeout);
                return timeout;
            }
            int id2 = prebaked.getId();
            if (id2 < 0 || id2 >= this.mFallbackEffects.length || this.mFallbackEffects[id2] == null) {
                Slog.w(TAG, "Failed to play prebaked effect, no fallback");
                return 0L;
            }
            VibrationEffect effect = this.mFallbackEffects[id2];
            Vibration fallbackVib = new Vibration(vib.mToken, effect, vib.mUsageHint, vib.mUid, vib.mOpPkg);
            this.startVibrationInnerLocked(fallbackVib);
        }
        return 0L;
    }

    private void noteVibratorOnLocked(int uid, long millis) {
        try {
            this.mBatteryStatsService.noteVibratorOn(uid, millis);
            this.mCurVibUid = uid;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void noteVibratorOffLocked() {
        if (this.mCurVibUid >= 0) {
            try {
                this.mBatteryStatsService.noteVibratorOff(this.mCurVibUid);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurVibUid = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("Previous vibrations:");
        Object object = this.mLock;
        synchronized (object) {
            for (VibrationInfo info : this.mPreviousVibrations) {
                pw.print("  ");
                pw.println(info.toString());
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        new VibratorShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    private final class VibratorShellCommand
    extends ShellCommand {
        private static final long MAX_VIBRATION_MS = 200L;
        private final IBinder mToken;

        private VibratorShellCommand(IBinder token) {
            this.mToken = token;
        }

        @Override
        public int onCommand(String cmd) {
            if ("vibrate".equals(cmd)) {
                return this.runVibrate();
            }
            return this.handleDefaultCommands(cmd);
        }

        private int runVibrate() {
            long duration = Long.parseLong(this.getNextArgRequired());
            if (duration > 200L) {
                throw new IllegalArgumentException("maximum duration is 200");
            }
            String description = this.getNextArg();
            if (description == null) {
                description = "Shell command";
            }
            VibrationEffect effect = VibrationEffect.createOneShot(duration, -1);
            VibratorService.this.vibrate(Binder.getCallingUid(), description, effect, 0, this.mToken);
            return 0;
        }

        @Override
        public void onHelp() {
            try (PrintWriter pw = this.getOutPrintWriter();){
                pw.println("Vibrator commands:");
                pw.println("  help");
                pw.println("    Prints this help text.");
                pw.println("");
                pw.println("  vibrate duration [description]");
                pw.println("    Vibrates for duration milliseconds.");
                pw.println("");
            }
        }
    }

    private class VibrateThread
    extends Thread {
        private final VibrationEffect.Waveform mWaveform;
        private final int mUid;
        private final int mUsageHint;
        private boolean mForceStop;

        VibrateThread(VibrationEffect.Waveform waveform, int uid, int usageHint) {
            this.mWaveform = waveform;
            this.mUid = uid;
            this.mUsageHint = usageHint;
            VibratorService.this.mTmpWorkSource.set(uid);
            VibratorService.this.mWakeLock.setWorkSource(VibratorService.this.mTmpWorkSource);
        }

        private long delayLocked(long duration) {
            long durationRemaining = duration;
            if (duration > 0L) {
                long bedtime = duration + SystemClock.uptimeMillis();
                do {
                    try {
                        this.wait(durationRemaining);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.mForceStop && (durationRemaining = bedtime - SystemClock.uptimeMillis()) > 0L);
                return duration - durationRemaining;
            }
            return 0L;
        }

        @Override
        public void run() {
            Process.setThreadPriority(-8);
            VibratorService.this.mWakeLock.acquire();
            try {
                boolean finished = this.playWaveform();
                if (finished) {
                    VibratorService.this.onVibrationFinished();
                }
            }
            finally {
                VibratorService.this.mWakeLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playWaveform() {
            VibrateThread vibrateThread = this;
            synchronized (vibrateThread) {
                long[] timings = this.mWaveform.getTimings();
                int[] amplitudes = this.mWaveform.getAmplitudes();
                int len = timings.length;
                int repeat = this.mWaveform.getRepeatIndex();
                int index = 0;
                long onDuration = 0L;
                while (!this.mForceStop) {
                    if (index < len) {
                        long duration;
                        int amplitude = amplitudes[index];
                        if ((duration = timings[index++]) <= 0L) continue;
                        if (amplitude != 0) {
                            if (onDuration <= 0L) {
                                onDuration = this.getTotalOnDuration(timings, amplitudes, index - 1, repeat);
                                VibratorService.this.doVibratorOn(onDuration, amplitude, this.mUid, this.mUsageHint);
                            } else {
                                VibratorService.this.doVibratorSetAmplitude(amplitude);
                            }
                        }
                        long waitTime = this.delayLocked(duration);
                        if (amplitude == 0) continue;
                        onDuration -= waitTime;
                        continue;
                    }
                    if (repeat < 0) break;
                    index = repeat;
                }
                return !this.mForceStop;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            VibrateThread vibrateThread = this;
            synchronized (vibrateThread) {
                ((VibratorService)VibratorService.this).mThread.mForceStop = true;
                VibratorService.this.mThread.notify();
            }
        }

        private long getTotalOnDuration(long[] timings, int[] amplitudes, int startIndex, int repeatIndex) {
            int i = startIndex;
            long timing = 0L;
            while (amplitudes[i] != 0) {
                timing += timings[i++];
                if (i >= timings.length) {
                    if (repeatIndex < 0) break;
                    i = repeatIndex;
                }
                if (i != startIndex) continue;
                return 1000L;
            }
            return timing;
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean SelfChange) {
            VibratorService.this.updateVibrators();
        }
    }

    private static class VibrationInfo {
        private final long mStartTime;
        private final VibrationEffect mEffect;
        private final int mUsageHint;
        private final int mUid;
        private final String mOpPkg;

        public VibrationInfo(long startTime, VibrationEffect effect, int usageHint, int uid, String opPkg) {
            this.mStartTime = startTime;
            this.mEffect = effect;
            this.mUsageHint = usageHint;
            this.mUid = uid;
            this.mOpPkg = opPkg;
        }

        public String toString() {
            return ", startTime: " + this.mStartTime + ", effect: " + this.mEffect + ", usageHint: " + this.mUsageHint + ", uid: " + this.mUid + ", opPkg: " + this.mOpPkg;
        }
    }

    private class Vibration
    implements IBinder.DeathRecipient {
        private final IBinder mToken;
        private final VibrationEffect mEffect;
        private final long mStartTime;
        private final int mUsageHint;
        private final int mUid;
        private final String mOpPkg;

        private Vibration(IBinder token, VibrationEffect effect, int usageHint, int uid, String opPkg) {
            this.mToken = token;
            this.mEffect = effect;
            this.mStartTime = SystemClock.uptimeMillis();
            this.mUsageHint = usageHint;
            this.mUid = uid;
            this.mOpPkg = opPkg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = VibratorService.this.mLock;
            synchronized (object) {
                if (this == VibratorService.this.mCurrentVibration) {
                    VibratorService.this.doCancelVibrateLocked();
                }
            }
        }

        public boolean hasLongerTimeout(long millis) {
            if (this.mEffect instanceof VibrationEffect.OneShot) {
                VibrationEffect.OneShot oneShot = (VibrationEffect.OneShot)this.mEffect;
                return this.mStartTime + oneShot.getTiming() > SystemClock.uptimeMillis() + millis;
            }
            return false;
        }

        public boolean isSystemHapticFeedback() {
            boolean repeating = false;
            if (this.mEffect instanceof VibrationEffect.Waveform) {
                VibrationEffect.Waveform waveform = (VibrationEffect.Waveform)this.mEffect;
                repeating = waveform.getRepeatIndex() < 0;
            }
            return (this.mUid == 1000 || this.mUid == 0 || VibratorService.SYSTEM_UI_PACKAGE.equals(this.mOpPkg)) && !repeating;
        }
    }
}

