/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.IActivityContainer;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.os.IResultReceiver;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Objects;

final class PendingIntentRecord
extends IIntentSender.Stub {
    private static final String TAG = "ActivityManager";
    final ActivityManagerService owner;
    final Key key;
    final int uid;
    final WeakReference<PendingIntentRecord> ref;
    boolean sent = false;
    boolean canceled = false;
    private ArrayMap<IBinder, Long> whitelistDuration;
    private RemoteCallbackList<IResultReceiver> mCancelCallbacks;
    String stringName;
    String lastTagPrefix;
    String lastTag;

    PendingIntentRecord(ActivityManagerService _owner, Key _k, int _u) {
        this.owner = _owner;
        this.key = _k;
        this.uid = _u;
        this.ref = new WeakReference<PendingIntentRecord>(this);
    }

    void setWhitelistDurationLocked(IBinder whitelistToken, long duration) {
        if (duration > 0L) {
            if (this.whitelistDuration == null) {
                this.whitelistDuration = new ArrayMap();
            }
            this.whitelistDuration.put(whitelistToken, duration);
        } else if (this.whitelistDuration != null) {
            this.whitelistDuration.remove(whitelistToken);
            if (this.whitelistDuration.size() <= 0) {
                this.whitelistDuration = null;
            }
        }
        this.stringName = null;
    }

    public void registerCancelListenerLocked(IResultReceiver receiver) {
        if (this.mCancelCallbacks == null) {
            this.mCancelCallbacks = new RemoteCallbackList();
        }
        this.mCancelCallbacks.register(receiver);
    }

    public void unregisterCancelListenerLocked(IResultReceiver receiver) {
        this.mCancelCallbacks.unregister(receiver);
        if (this.mCancelCallbacks.getRegisteredCallbackCount() <= 0) {
            this.mCancelCallbacks = null;
        }
    }

    public RemoteCallbackList<IResultReceiver> detachCancelListenersLocked() {
        RemoteCallbackList<IResultReceiver> listeners = this.mCancelCallbacks;
        this.mCancelCallbacks = null;
        return listeners;
    }

    @Override
    public void send(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
        this.sendInner(code, intent, resolvedType, whitelistToken, finishedReceiver, requiredPermission, null, null, 0, 0, 0, options, null);
    }

    public int sendWithResult(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) {
        return this.sendInner(code, intent, resolvedType, whitelistToken, finishedReceiver, requiredPermission, null, null, 0, 0, 0, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendInner(int code, Intent intent, String resolvedType, IBinder whitelistToken, IIntentReceiver finishedReceiver, String requiredPermission, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues, Bundle options, IActivityContainer container) {
        if (intent != null) {
            intent.setDefusable(true);
        }
        if (options != null) {
            options.setDefusable(true);
        }
        ActivityManagerService activityManagerService = this.owner;
        synchronized (activityManagerService) {
            ActivityStackSupervisor.ActivityContainer activityContainer = (ActivityStackSupervisor.ActivityContainer)container;
            if (activityContainer != null && activityContainer.mParentActivity != null && activityContainer.mParentActivity.state != ActivityStack.ActivityState.RESUMED) {
                return -96;
            }
            if (!this.canceled) {
                Long duration;
                boolean immutable;
                this.sent = true;
                if ((this.key.flags & 0x40000000) != 0) {
                    this.owner.cancelIntentSenderLocked(this, true);
                }
                Intent finalIntent = this.key.requestIntent != null ? new Intent(this.key.requestIntent) : new Intent();
                boolean bl = immutable = (this.key.flags & 0x4000000) != 0;
                if (!immutable) {
                    if (intent != null) {
                        int changes = finalIntent.fillIn(intent, this.key.flags);
                        if ((changes & 2) == 0) {
                            resolvedType = this.key.requestResolvedType;
                        }
                    } else {
                        resolvedType = this.key.requestResolvedType;
                    }
                    finalIntent.setFlags(finalIntent.getFlags() & ~flagsMask | (flagsValues &= (flagsMask &= 0xFFFFFF3C)));
                } else {
                    resolvedType = this.key.requestResolvedType;
                }
                int callingUid = Binder.getCallingUid();
                int callingPid = Binder.getCallingPid();
                long origId = Binder.clearCallingIdentity();
                if (this.whitelistDuration != null && (duration = this.whitelistDuration.get(whitelistToken)) != null) {
                    int procState = this.owner.getUidState(callingUid);
                    if (!ActivityManager.isProcStateBackground(procState)) {
                        StringBuilder tag = new StringBuilder(64);
                        tag.append("pendingintent:");
                        UserHandle.formatUid(tag, callingUid);
                        tag.append(":");
                        if (finalIntent.getAction() != null) {
                            tag.append(finalIntent.getAction());
                        } else if (finalIntent.getComponent() != null) {
                            finalIntent.getComponent().appendShortString(tag);
                        } else if (finalIntent.getData() != null) {
                            tag.append(finalIntent.getData());
                        }
                        this.owner.tempWhitelistForPendingIntentLocked(callingPid, callingUid, this.uid, duration, tag.toString());
                    } else {
                        Slog.w(TAG, "Not doing whitelist " + this + ": caller state=" + procState);
                    }
                }
                boolean sendFinish = finishedReceiver != null;
                int userId = this.key.userId;
                if (userId == -2) {
                    userId = this.owner.mUserController.getCurrentOrTargetUserIdLocked();
                }
                int res = 0;
                switch (this.key.type) {
                    case 2: {
                        if (options == null) {
                            options = this.key.options;
                        } else if (this.key.options != null) {
                            Bundle opts = new Bundle(this.key.options);
                            opts.putAll(options);
                            options = opts;
                        }
                        try {
                            if (this.key.allIntents != null && this.key.allIntents.length > 1) {
                                Intent[] allIntents = new Intent[this.key.allIntents.length];
                                String[] allResolvedTypes = new String[this.key.allIntents.length];
                                System.arraycopy(this.key.allIntents, 0, allIntents, 0, this.key.allIntents.length);
                                if (this.key.allResolvedTypes != null) {
                                    System.arraycopy(this.key.allResolvedTypes, 0, allResolvedTypes, 0, this.key.allResolvedTypes.length);
                                }
                                allIntents[allIntents.length - 1] = finalIntent;
                                allResolvedTypes[allResolvedTypes.length - 1] = resolvedType;
                                this.owner.startActivitiesInPackage(this.uid, this.key.packageName, allIntents, allResolvedTypes, resultTo, options, userId);
                                break;
                            }
                            this.owner.startActivityInPackage(this.uid, this.key.packageName, finalIntent, resolvedType, resultTo, resultWho, requestCode, 0, options, userId, container, null, "PendingIntentRecord");
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startActivity intent", e);
                        }
                        break;
                    }
                    case 3: {
                        Object stack = this.key.activity.getStack();
                        if (stack == null) break;
                        ((ActivityStack)stack).sendActivityResultLocked(-1, this.key.activity, this.key.who, this.key.requestCode, code, finalIntent);
                        break;
                    }
                    case 1: {
                        try {
                            int sent = this.owner.broadcastIntentInPackage(this.key.packageName, this.uid, finalIntent, resolvedType, finishedReceiver, code, null, null, requiredPermission, options, finishedReceiver != null, false, userId);
                            if (sent != 0) break;
                            sendFinish = false;
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startActivity intent", e);
                        }
                        break;
                    }
                    case 4: 
                    case 5: {
                        try {
                            this.owner.startServiceInPackage(this.uid, finalIntent, resolvedType, this.key.type == 5, this.key.packageName, userId);
                            break;
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startService intent", e);
                            break;
                        }
                        catch (TransactionTooLargeException e) {
                            res = -96;
                        }
                    }
                }
                if (sendFinish && res != -96) {
                    try {
                        finishedReceiver.performReceive(new Intent(finalIntent), 0, null, null, false, false, this.key.userId);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                Binder.restoreCallingIdentity(origId);
                return res;
            }
        }
        return -96;
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (!this.canceled) {
                this.owner.mHandler.sendMessage(this.owner.mHandler.obtainMessage(23, this));
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFinalize() {
        ActivityManagerService activityManagerService = this.owner;
        synchronized (activityManagerService) {
            WeakReference<PendingIntentRecord> current = this.owner.mIntentSenderRecords.get(this.key);
            if (current == this.ref) {
                this.owner.mIntentSenderRecords.remove(this.key);
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        int i;
        pw.print(prefix);
        pw.print("uid=");
        pw.print(this.uid);
        pw.print(" packageName=");
        pw.print(this.key.packageName);
        pw.print(" type=");
        pw.print(this.key.typeName());
        pw.print(" flags=0x");
        pw.println(Integer.toHexString(this.key.flags));
        if (this.key.activity != null || this.key.who != null) {
            pw.print(prefix);
            pw.print("activity=");
            pw.print(this.key.activity);
            pw.print(" who=");
            pw.println(this.key.who);
        }
        if (this.key.requestCode != 0 || this.key.requestResolvedType != null) {
            pw.print(prefix);
            pw.print("requestCode=");
            pw.print(this.key.requestCode);
            pw.print(" requestResolvedType=");
            pw.println(this.key.requestResolvedType);
        }
        if (this.key.requestIntent != null) {
            pw.print(prefix);
            pw.print("requestIntent=");
            pw.println(this.key.requestIntent.toShortString(false, true, true, true));
        }
        if (this.sent || this.canceled) {
            pw.print(prefix);
            pw.print("sent=");
            pw.print(this.sent);
            pw.print(" canceled=");
            pw.println(this.canceled);
        }
        if (this.whitelistDuration != null) {
            pw.print(prefix);
            pw.print("whitelistDuration=");
            for (i = 0; i < this.whitelistDuration.size(); ++i) {
                if (i != 0) {
                    pw.print(", ");
                }
                pw.print(Integer.toHexString(System.identityHashCode(this.whitelistDuration.keyAt(i))));
                pw.print(":");
                TimeUtils.formatDuration((long)this.whitelistDuration.valueAt(i), pw);
            }
            pw.println();
        }
        if (this.mCancelCallbacks != null) {
            pw.print(prefix);
            pw.println("mCancelCallbacks:");
            for (i = 0; i < this.mCancelCallbacks.getRegisteredCallbackCount(); ++i) {
                pw.print(prefix);
                pw.print("  #");
                pw.print(i);
                pw.print(": ");
                pw.println(this.mCancelCallbacks.getRegisteredCallbackItem(i));
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("PendingIntentRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.key.packageName);
        sb.append(' ');
        sb.append(this.key.typeName());
        if (this.whitelistDuration != null) {
            sb.append(" (whitelist: ");
            for (int i = 0; i < this.whitelistDuration.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(Integer.toHexString(System.identityHashCode(this.whitelistDuration.keyAt(i))));
                sb.append(":");
                TimeUtils.formatDuration((long)this.whitelistDuration.valueAt(i), sb);
            }
            sb.append(")");
        }
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    static final class Key {
        final int type;
        final String packageName;
        final ActivityRecord activity;
        final String who;
        final int requestCode;
        final Intent requestIntent;
        final String requestResolvedType;
        final Bundle options;
        Intent[] allIntents;
        String[] allResolvedTypes;
        final int flags;
        final int hashCode;
        final int userId;
        private static final int ODD_PRIME_NUMBER = 37;

        Key(int _t, String _p, ActivityRecord _a, String _w, int _r, Intent[] _i, String[] _it, int _f, Bundle _o, int _userId) {
            this.type = _t;
            this.packageName = _p;
            this.activity = _a;
            this.who = _w;
            this.requestCode = _r;
            this.requestIntent = _i != null ? _i[_i.length - 1] : null;
            this.requestResolvedType = _it != null ? _it[_it.length - 1] : null;
            this.allIntents = _i;
            this.allResolvedTypes = _it;
            this.flags = _f;
            this.options = _o;
            this.userId = _userId;
            int hash = 23;
            hash = 37 * hash + _f;
            hash = 37 * hash + _r;
            hash = 37 * hash + _userId;
            if (_w != null) {
                hash = 37 * hash + _w.hashCode();
            }
            if (_a != null) {
                hash = 37 * hash + _a.hashCode();
            }
            if (this.requestIntent != null) {
                hash = 37 * hash + this.requestIntent.filterHashCode();
            }
            if (this.requestResolvedType != null) {
                hash = 37 * hash + this.requestResolvedType.hashCode();
            }
            hash = 37 * hash + (_p != null ? _p.hashCode() : 0);
            this.hashCode = hash = 37 * hash + _t;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == null) {
                return false;
            }
            try {
                Key other = (Key)otherObj;
                if (this.type != other.type) {
                    return false;
                }
                if (this.userId != other.userId) {
                    return false;
                }
                if (!Objects.equals(this.packageName, other.packageName)) {
                    return false;
                }
                if (this.activity != other.activity) {
                    return false;
                }
                if (!Objects.equals(this.who, other.who)) {
                    return false;
                }
                if (this.requestCode != other.requestCode) {
                    return false;
                }
                if (this.requestIntent != other.requestIntent && (this.requestIntent != null ? !this.requestIntent.filterEquals(other.requestIntent) : other.requestIntent != null)) {
                    return false;
                }
                if (!Objects.equals(this.requestResolvedType, other.requestResolvedType)) {
                    return false;
                }
                return this.flags == other.flags;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Key{" + this.typeName() + " pkg=" + this.packageName + " intent=" + (this.requestIntent != null ? this.requestIntent.toShortString(false, true, false, false) : "<null>") + " flags=0x" + Integer.toHexString(this.flags) + " u=" + this.userId + "}";
        }

        String typeName() {
            switch (this.type) {
                case 2: {
                    return "startActivity";
                }
                case 1: {
                    return "broadcastIntent";
                }
                case 4: {
                    return "startService";
                }
                case 5: {
                    return "startForegroundService";
                }
                case 3: {
                    return "activityResult";
                }
            }
            return Integer.toString(this.type);
        }
    }
}

