/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.accounts.AccountAndUser;
import android.accounts.AccountManager;
import android.accounts.AccountManagerInternal;
import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.PeriodicSync;
import android.content.ServiceConnection;
import android.content.SyncActivityTooManyDeletes;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncInfo;
import android.content.SyncResult;
import android.content.SyncStatusInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ProviderInfo;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.LocalServices;
import com.android.server.accounts.AccountManagerService;
import com.android.server.backup.AccountSyncSettingsBackupHelper;
import com.android.server.content.SyncJobService;
import com.android.server.content.SyncOperation;
import com.android.server.content.SyncStorageEngine;
import com.android.server.job.JobSchedulerInternal;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;

public class SyncManager {
    static final String TAG = "SyncManager";
    private static final boolean DEBUG_ACCOUNT_ACCESS = false;
    private static final long LOCAL_SYNC_DELAY = SystemProperties.getLong("sync.local_sync_delay", 30000L);
    private static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    private static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    private static final int DELAY_RETRY_SYNC_IN_PROGRESS_IN_SECONDS = 10;
    private static final long SYNC_MONITOR_WINDOW_LENGTH_MILLIS = 60000L;
    private static final int SYNC_MONITOR_PROGRESS_THRESHOLD_BYTES = 10;
    private static final long SYNC_DELAY_ON_LOW_STORAGE = 3600000L;
    private static final long SYNC_DELAY_ON_CONFLICT = 10000L;
    private static final int MIN_SYNC_JOB_ID = 100000;
    private static final int MAX_SYNC_JOB_ID = 110000;
    private static final String SYNC_WAKE_LOCK_PREFIX = "*sync*/";
    private static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarm";
    private static final String SYNC_LOOP_WAKE_LOCK = "SyncLoopWakeLock";
    private static final int SYNC_OP_STATE_VALID = 0;
    private static final int SYNC_OP_STATE_INVALID = 1;
    private static final int SYNC_OP_STATE_INVALID_NO_ACCOUNT_ACCESS = 2;
    private Context mContext;
    private static final AccountAndUser[] INITIAL_ACCOUNTS_ARRAY = new AccountAndUser[0];
    private volatile AccountAndUser[] mRunningAccounts = INITIAL_ACCOUNTS_ARRAY;
    private volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    private volatile PowerManager.WakeLock mSyncManagerWakeLock;
    private volatile boolean mDataConnectionIsConnected = false;
    private volatile boolean mStorageIsLow = false;
    private volatile boolean mDeviceIsIdle = false;
    private volatile boolean mReportedSyncActive = false;
    private final NotificationManager mNotificationMgr;
    private final IBatteryStats mBatteryStats;
    private JobScheduler mJobScheduler;
    private JobSchedulerInternal mJobSchedulerInternal;
    private SyncJobService mSyncJobService;
    private SyncStorageEngine mSyncStorageEngine;
    protected final ArrayList<ActiveSyncContext> mActiveSyncContexts = Lists.newArrayList();
    private ConnectivityManager mConnManagerDoNotUseDirectly;
    private volatile boolean mProvisioned;
    protected SyncAdaptersCache mSyncAdapters;
    private final Random mRand;
    private final BroadcastReceiver mStorageIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Slog.v(SyncManager.TAG, "Internal storage is low.");
                }
                SyncManager.this.mStorageIsLow = true;
                SyncManager.this.cancelActiveSync(SyncStorageEngine.EndPoint.USER_ALL_PROVIDER_ALL_ACCOUNTS_ALL, null);
            } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Slog.v(SyncManager.TAG, "Internal storage is ok.");
                }
                SyncManager.this.mStorageIsLow = false;
                SyncManager.this.rescheduleSyncs(SyncStorageEngine.EndPoint.USER_ALL_PROVIDER_ALL_ACCOUNTS_ALL);
            }
        }
    };
    private final BroadcastReceiver mBootCompletedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mBootCompleted = true;
            SyncManager.this.verifyJobScheduler();
            SyncManager.this.mSyncHandler.onBootCompleted();
        }
    };
    private final BroadcastReceiver mAccountsUpdatedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncStorageEngine.EndPoint target = new SyncStorageEngine.EndPoint(null, null, context.getUserId());
            SyncManager.this.updateRunningAccounts(target);
        }
    };
    private final PowerManager mPowerManager;
    private final UserManager mUserManager;
    private final AccountManager mAccountManager;
    private final AccountManagerInternal mAccountManagerInternal;
    private final PackageManagerInternal mPackageManagerInternal;
    private BroadcastReceiver mConnectivityIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            boolean wasConnected = SyncManager.this.mDataConnectionIsConnected;
            SyncManager.this.mDataConnectionIsConnected = SyncManager.this.readDataConnectionState();
            if (SyncManager.this.mDataConnectionIsConnected) {
                if (!wasConnected && Log.isLoggable(SyncManager.TAG, 2)) {
                    Slog.v(SyncManager.TAG, "Reconnection detected: clearing all backoffs");
                }
                SyncManager.this.clearAllBackoffs();
            }
        }
    };
    private BroadcastReceiver mShutdownIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.w(SyncManager.TAG, "Writing sync state before shutdown...");
            SyncManager.this.getSyncStorageEngine().writeAllState();
        }
    };
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                SyncManager.this.onUserRemoved(userId);
            } else if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                SyncManager.this.onUserUnlocked(userId);
            } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                SyncManager.this.onUserStopped(userId);
            }
        }
    };
    private final SyncHandler mSyncHandler;
    private volatile boolean mBootCompleted = false;
    private volatile boolean mJobServiceReady = false;

    private boolean isJobIdInUseLockedH(int jobId, List<JobInfo> pendingJobs) {
        for (JobInfo job : pendingJobs) {
            if (job.getId() != jobId) continue;
            return true;
        }
        for (ActiveSyncContext asc : this.mActiveSyncContexts) {
            if (asc.mSyncOperation.jobId != jobId) continue;
            return true;
        }
        return false;
    }

    private int getUnusedJobIdH() {
        int newJobId;
        while (this.isJobIdInUseLockedH(newJobId = 100000 + this.mRand.nextInt(10000), this.mJobSchedulerInternal.getSystemScheduledPendingJobs())) {
        }
        return newJobId;
    }

    private List<SyncOperation> getAllPendingSyncs() {
        this.verifyJobScheduler();
        List<JobInfo> pendingJobs = this.mJobSchedulerInternal.getSystemScheduledPendingJobs();
        ArrayList<SyncOperation> pendingSyncs = new ArrayList<SyncOperation>(pendingJobs.size());
        for (JobInfo job : pendingJobs) {
            SyncOperation op = SyncOperation.maybeCreateFromJobExtras(job.getExtras());
            if (op == null) continue;
            pendingSyncs.add(op);
        }
        return pendingSyncs;
    }

    private List<UserInfo> getAllUsers() {
        return this.mUserManager.getUsers();
    }

    private boolean containsAccountAndUser(AccountAndUser[] accounts, Account account, int userId) {
        boolean found = false;
        for (int i = 0; i < accounts.length; ++i) {
            if (accounts[i].userId != userId || !accounts[i].account.equals(account)) continue;
            found = true;
            break;
        }
        return found;
    }

    private void updateRunningAccounts(SyncStorageEngine.EndPoint target) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "sending MESSAGE_ACCOUNTS_UPDATED");
        }
        Message m = this.mSyncHandler.obtainMessage(9);
        m.obj = target;
        m.sendToTarget();
    }

    private void doDatabaseCleanup() {
        for (UserInfo user : this.mUserManager.getUsers(true)) {
            if (user.partial) continue;
            Account[] accountsForUser = AccountManagerService.getSingleton().getAccounts(user.id, this.mContext.getOpPackageName());
            this.mSyncStorageEngine.doDatabaseCleanup(accountsForUser, user.id);
        }
    }

    private void clearAllBackoffs() {
        this.mSyncStorageEngine.clearAllBackoffsLocked();
        this.rescheduleSyncs(SyncStorageEngine.EndPoint.USER_ALL_PROVIDER_ALL_ACCOUNTS_ALL);
    }

    private boolean readDataConnectionState() {
        NetworkInfo networkInfo = this.getConnectivityManager().getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectivityManager getConnectivityManager() {
        SyncManager syncManager = this;
        synchronized (syncManager) {
            if (this.mConnManagerDoNotUseDirectly == null) {
                this.mConnManagerDoNotUseDirectly = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            }
            return this.mConnManagerDoNotUseDirectly;
        }
    }

    private void cleanupJobs() {
        this.mSyncHandler.postAtFrontOfQueue(new Runnable(){

            @Override
            public void run() {
                List ops = SyncManager.this.getAllPendingSyncs();
                HashSet<String> cleanedKeys = new HashSet<String>();
                for (SyncOperation opx : ops) {
                    if (cleanedKeys.contains(opx.key)) continue;
                    cleanedKeys.add(opx.key);
                    for (SyncOperation opy : ops) {
                        if (opx == opy || !opx.key.equals(opy.key)) continue;
                        SyncManager.this.mJobScheduler.cancel(opy.jobId);
                    }
                }
            }
        });
    }

    private synchronized void verifyJobScheduler() {
        if (this.mJobScheduler != null) {
            return;
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.d(TAG, "initializing JobScheduler object.");
        }
        this.mJobScheduler = (JobScheduler)this.mContext.getSystemService("jobscheduler");
        this.mJobSchedulerInternal = LocalServices.getService(JobSchedulerInternal.class);
        List<JobInfo> pendingJobs = this.mJobScheduler.getAllPendingJobs();
        for (JobInfo job : pendingJobs) {
            SyncOperation op = SyncOperation.maybeCreateFromJobExtras(job.getExtras());
            if (op == null || op.isPeriodic) continue;
            this.mSyncStorageEngine.markPending(op.target, true);
        }
        this.cleanupJobs();
    }

    private JobScheduler getJobScheduler() {
        this.verifyJobScheduler();
        return this.mJobScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncManager(Context context, boolean factoryTest) {
        this.mContext = context;
        SyncStorageEngine.init(context);
        this.mSyncStorageEngine = SyncStorageEngine.getSingleton();
        this.mSyncStorageEngine.setOnSyncRequestListener(new SyncStorageEngine.OnSyncRequestListener(){

            @Override
            public void onSyncRequest(SyncStorageEngine.EndPoint info, int reason, Bundle extras) {
                SyncManager.this.scheduleSync(info.account, info.userId, reason, info.provider, extras, -2);
            }
        });
        this.mSyncStorageEngine.setPeriodicSyncAddedListener(new SyncStorageEngine.PeriodicSyncAddedListener(){

            @Override
            public void onPeriodicSyncAdded(SyncStorageEngine.EndPoint target, Bundle extras, long pollFrequency, long flex) {
                SyncManager.this.updateOrAddPeriodicSync(target, pollFrequency, flex, extras);
            }
        });
        this.mSyncStorageEngine.setOnAuthorityRemovedListener(new SyncStorageEngine.OnAuthorityRemovedListener(){

            @Override
            public void onAuthorityRemoved(SyncStorageEngine.EndPoint removedAuthority) {
                SyncManager.this.removeSyncsForAuthority(removedAuthority);
            }
        });
        this.mSyncAdapters = new SyncAdaptersCache(this.mContext);
        this.mSyncHandler = new SyncHandler(BackgroundThread.get().getLooper());
        this.mSyncAdapters.setListener(new RegisteredServicesCacheListener<SyncAdapterType>(){

            @Override
            public void onServiceChanged(SyncAdapterType type, int userId, boolean removed) {
                if (!removed) {
                    SyncManager.this.scheduleSync(null, -1, -3, type.authority, null, -2);
                }
            }
        }, this.mSyncHandler);
        this.mRand = new Random(System.currentTimeMillis());
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.mConnectivityIntentReceiver, intentFilter);
        if (!factoryTest) {
            intentFilter = new IntentFilter("android.intent.action.BOOT_COMPLETED");
            intentFilter.setPriority(1000);
            context.registerReceiver(this.mBootCompletedReceiver, intentFilter);
        }
        intentFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        context.registerReceiver(this.mStorageIntentReceiver, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.setPriority(100);
        context.registerReceiver(this.mShutdownIntentReceiver, intentFilter);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_UNLOCKED");
        intentFilter.addAction("android.intent.action.USER_STOPPED");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        this.mNotificationMgr = !factoryTest ? (NotificationManager)context.getSystemService("notification") : null;
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mAccountManager = (AccountManager)this.mContext.getSystemService("account");
        this.mAccountManagerInternal = LocalServices.getService(AccountManagerInternal.class);
        this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        this.mAccountManagerInternal.addOnAppPermissionChangeListener((account, uid) -> {
            if (this.mAccountManagerInternal.hasAccountAccess(account, uid)) {
                this.scheduleSync(account, UserHandle.getUserId(uid), -2, null, null, 3);
            }
        });
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mHandleAlarmWakeLock = this.mPowerManager.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        this.mSyncManagerWakeLock = this.mPowerManager.newWakeLock(1, SYNC_LOOP_WAKE_LOCK);
        this.mSyncManagerWakeLock.setReferenceCounted(false);
        this.mProvisioned = this.isDeviceProvisioned();
        if (!this.mProvisioned) {
            final ContentResolver resolver = context.getContentResolver();
            ContentObserver provisionedObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange) {
                    SyncManager.this.mProvisioned = SyncManager.this.mProvisioned | SyncManager.this.isDeviceProvisioned();
                    if (SyncManager.this.mProvisioned) {
                        SyncManager.this.mSyncHandler.onDeviceProvisioned();
                        resolver.unregisterContentObserver(this);
                    }
                }
            };
            SyncHandler syncHandler = this.mSyncHandler;
            synchronized (syncHandler) {
                resolver.registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, provisionedObserver);
                this.mProvisioned |= this.isDeviceProvisioned();
                if (this.mProvisioned) {
                    resolver.unregisterContentObserver(provisionedObserver);
                }
            }
        }
        if (!factoryTest) {
            this.mContext.registerReceiverAsUser(this.mAccountsUpdatedReceiver, UserHandle.ALL, new IntentFilter("android.accounts.LOGIN_ACCOUNTS_CHANGED"), null, null);
        }
        final Intent startServiceIntent = new Intent(this.mContext, SyncJobService.class);
        startServiceIntent.putExtra("messenger", new Messenger(this.mSyncHandler));
        new Handler(this.mContext.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                SyncManager.this.mContext.startService(startServiceIntent);
            }
        });
        this.whiteListExistingSyncAdaptersIfNeeded();
    }

    private void whiteListExistingSyncAdaptersIfNeeded() {
        if (!this.mSyncStorageEngine.shouldGrantSyncAdaptersAccountAccess()) {
            return;
        }
        List<UserInfo> users = this.mUserManager.getUsers(true);
        int userCount = users.size();
        for (int i = 0; i < userCount; ++i) {
            UserHandle userHandle = users.get(i).getUserHandle();
            int userId = userHandle.getIdentifier();
            for (RegisteredServicesCache.ServiceInfo service : this.mSyncAdapters.getAllServices(userId)) {
                String packageName = service.componentName.getPackageName();
                for (Account account : this.mAccountManager.getAccountsByTypeAsUser(((SyncAdapterType)service.type).accountType, userHandle)) {
                    if (this.canAccessAccount(account, packageName, userId)) continue;
                    this.mAccountManager.updateAppPermission(account, "com.android.AccountManager.ACCOUNT_ACCESS_TOKEN_TYPE", service.uid, true);
                }
            }
        }
    }

    private boolean isDeviceProvisioned() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
    }

    private long jitterize(long minValue, long maxValue) {
        Random random = new Random(SystemClock.elapsedRealtime());
        long spread = maxValue - minValue;
        if (spread > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        return minValue + (long)random.nextInt((int)spread);
    }

    public SyncStorageEngine getSyncStorageEngine() {
        return this.mSyncStorageEngine;
    }

    private int getIsSyncable(Account account, int userId, String providerName) {
        int isSyncable = this.mSyncStorageEngine.getIsSyncable(account, userId, providerName);
        UserInfo userInfo = UserManager.get(this.mContext).getUserInfo(userId);
        if (userInfo == null || !userInfo.isRestricted()) {
            return isSyncable;
        }
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(providerName, account.type), userId);
        if (syncAdapterInfo == null) {
            return 0;
        }
        PackageInfo pInfo = null;
        try {
            pInfo = AppGlobals.getPackageManager().getPackageInfo(syncAdapterInfo.componentName.getPackageName(), 0, userId);
            if (pInfo == null) {
                return 0;
            }
        }
        catch (RemoteException re) {
            return 0;
        }
        if (pInfo.restrictedAccountType != null && pInfo.restrictedAccountType.equals(account.type)) {
            return isSyncable;
        }
        return 0;
    }

    private void setAuthorityPendingState(SyncStorageEngine.EndPoint info) {
        List<SyncOperation> ops = this.getAllPendingSyncs();
        for (SyncOperation op : ops) {
            if (op.isPeriodic || !op.target.matchesSpec(info)) continue;
            this.getSyncStorageEngine().markPending(info, true);
            return;
        }
        this.getSyncStorageEngine().markPending(info, false);
    }

    public void scheduleSync(Account requestedAccount, int userId, int reason, String requestedAuthority, Bundle extras, int targetSyncState) {
        this.scheduleSync(requestedAccount, userId, reason, requestedAuthority, extras, targetSyncState, 0L);
    }

    private void scheduleSync(Account requestedAccount, int userId, int reason, String requestedAuthority, Bundle extras, int targetSyncState, long minDelayMillis) {
        boolean isLoggable = Log.isLoggable(TAG, 2);
        if (extras == null) {
            extras = new Bundle();
        }
        if (isLoggable) {
            Log.d(TAG, "one-time sync for: " + requestedAccount + " " + extras.toString() + " " + requestedAuthority);
        }
        AccountAndUser[] accounts = null;
        if (requestedAccount != null) {
            if (userId != -1) {
                accounts = new AccountAndUser[]{new AccountAndUser(requestedAccount, userId)};
            } else {
                for (AccountAndUser runningAccount : this.mRunningAccounts) {
                    if (!requestedAccount.equals(runningAccount.account)) continue;
                    accounts = ArrayUtils.appendElement(AccountAndUser.class, accounts, runningAccount);
                }
            }
        } else {
            accounts = this.mRunningAccounts;
        }
        if (ArrayUtils.isEmpty(accounts)) {
            if (isLoggable) {
                Slog.v(TAG, "scheduleSync: no accounts configured, dropping");
            }
            return;
        }
        boolean uploadOnly = extras.getBoolean("upload", false);
        boolean manualSync = extras.getBoolean("force", false);
        if (manualSync) {
            extras.putBoolean("ignore_backoff", true);
            extras.putBoolean("ignore_settings", true);
        }
        boolean ignoreSettings = extras.getBoolean("ignore_settings", false);
        int source = uploadOnly ? 1 : (manualSync ? 3 : (requestedAuthority == null ? 2 : 0));
        for (AccountAndUser account : accounts) {
            if (userId >= 0 && account.userId >= 0 && userId != account.userId) continue;
            HashSet<String> syncableAuthorities = new HashSet<String>();
            for (RegisteredServicesCache.ServiceInfo syncAdapter : this.mSyncAdapters.getAllServices(account.userId)) {
                syncableAuthorities.add(((SyncAdapterType)syncAdapter.type).authority);
            }
            if (requestedAuthority != null) {
                boolean hasSyncAdapter = syncableAuthorities.contains(requestedAuthority);
                syncableAuthorities.clear();
                if (hasSyncAdapter) {
                    syncableAuthorities.add(requestedAuthority);
                }
            }
            for (String authority : syncableAuthorities) {
                boolean syncAllowed;
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo;
                int isSyncable = this.computeSyncable(account.account, account.userId, authority);
                if (isSyncable == 0 || (syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(authority, account.account.type), account.userId)) == null) continue;
                int owningUid = syncAdapterInfo.uid;
                if (isSyncable == 3) {
                    if (isLoggable) {
                        Slog.v(TAG, "    Not scheduling sync operation: isSyncable == SYNCABLE_NO_ACCOUNT_ACCESS");
                    }
                    Bundle finalExtras = new Bundle(extras);
                    String packageName = syncAdapterInfo.componentName.getPackageName();
                    try {
                        if (!this.mPackageManagerInternal.wasPackageEverLaunched(packageName, userId)) {
                        }
                    }
                    catch (IllegalArgumentException e) {}
                    continue;
                    this.mAccountManagerInternal.requestAccountAccess(account.account, packageName, userId, new RemoteCallback(result -> {
                        if (result != null && result.getBoolean("booleanResult")) {
                            this.scheduleSync(account.account, userId, reason, authority, finalExtras, targetSyncState, minDelayMillis);
                        }
                    }));
                    continue;
                }
                boolean allowParallelSyncs = ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs();
                boolean isAlwaysSyncable = ((SyncAdapterType)syncAdapterInfo.type).isAlwaysSyncable();
                if (isSyncable < 0 && isAlwaysSyncable) {
                    this.mSyncStorageEngine.setIsSyncable(account.account, account.userId, authority, 1);
                    isSyncable = 1;
                }
                if (targetSyncState != -2 && targetSyncState != isSyncable || !((SyncAdapterType)syncAdapterInfo.type).supportsUploading() && uploadOnly) continue;
                boolean bl = syncAllowed = isSyncable < 0 || ignoreSettings || this.mSyncStorageEngine.getMasterSyncAutomatically(account.userId) && this.mSyncStorageEngine.getSyncAutomatically(account.account, account.userId, authority);
                if (!syncAllowed) {
                    if (!isLoggable) continue;
                    Log.d(TAG, "scheduleSync: sync of " + account + ", " + authority + " is not allowed, dropping request");
                    continue;
                }
                SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account.account, authority, account.userId);
                long delayUntil = this.mSyncStorageEngine.getDelayUntilTime(info);
                String owningPackage = syncAdapterInfo.componentName.getPackageName();
                if (isSyncable == -1) {
                    Bundle newExtras = new Bundle();
                    newExtras.putBoolean("initialize", true);
                    if (isLoggable) {
                        Slog.v(TAG, "schedule initialisation Sync:, delay until " + delayUntil + ", run by " + 0 + ", flexMillis " + 0 + ", source " + source + ", account " + account + ", authority " + authority + ", extras " + newExtras);
                    }
                    this.postScheduleSyncMessage(new SyncOperation(account.account, account.userId, owningUid, owningPackage, reason, source, authority, newExtras, allowParallelSyncs), minDelayMillis);
                    continue;
                }
                if (targetSyncState != -2 && targetSyncState != isSyncable) continue;
                if (isLoggable) {
                    Slog.v(TAG, "scheduleSync: delay until " + delayUntil + ", source " + source + ", account " + account + ", authority " + authority + ", extras " + extras);
                }
                this.postScheduleSyncMessage(new SyncOperation(account.account, account.userId, owningUid, owningPackage, reason, source, authority, extras, allowParallelSyncs), minDelayMillis);
            }
        }
    }

    private int computeSyncable(Account account, int userId, String authority) {
        return this.computeSyncable(account, userId, authority, true);
    }

    public int computeSyncable(Account account, int userId, String authority, boolean checkAccountAccess) {
        int status = this.getIsSyncable(account, userId, authority);
        if (status == 0) {
            return 0;
        }
        SyncAdapterType type = SyncAdapterType.newKey(authority, account.type);
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = this.mSyncAdapters.getServiceInfo(type, userId);
        if (syncAdapterInfo == null) {
            return 0;
        }
        int owningUid = syncAdapterInfo.uid;
        String owningPackage = syncAdapterInfo.componentName.getPackageName();
        try {
            if (ActivityManager.getService().isAppStartModeDisabled(owningUid, owningPackage)) {
                Slog.w(TAG, "Not scheduling job " + syncAdapterInfo.uid + ":" + syncAdapterInfo.componentName + " -- package not allowed to start");
                return 0;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (checkAccountAccess && !this.canAccessAccount(account, owningPackage, owningUid)) {
            Log.w(TAG, "Access to " + account + " denied for package " + owningPackage + " in UID " + syncAdapterInfo.uid);
            return 3;
        }
        return status;
    }

    private boolean canAccessAccount(Account account, String packageName, int uid) {
        if (this.mAccountManager.hasAccountAccess(account, packageName, UserHandle.getUserHandleForUid(uid))) {
            return true;
        }
        try {
            this.mContext.getPackageManager().getApplicationInfoAsUser(packageName, 0x100000, UserHandle.getUserId(uid));
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private void removeSyncsForAuthority(SyncStorageEngine.EndPoint info) {
        this.verifyJobScheduler();
        List<SyncOperation> ops = this.getAllPendingSyncs();
        for (SyncOperation op : ops) {
            if (!op.target.matchesSpec(info)) continue;
            this.getJobScheduler().cancel(op.jobId);
        }
    }

    public void removePeriodicSync(SyncStorageEngine.EndPoint target, Bundle extras) {
        Message m = this.mSyncHandler.obtainMessage(14, target);
        m.setData(extras);
        m.sendToTarget();
    }

    public void updateOrAddPeriodicSync(SyncStorageEngine.EndPoint target, long pollFrequency, long flex, Bundle extras) {
        UpdatePeriodicSyncMessagePayload payload = new UpdatePeriodicSyncMessagePayload(target, pollFrequency, flex, extras);
        this.mSyncHandler.obtainMessage(13, payload).sendToTarget();
    }

    public List<PeriodicSync> getPeriodicSyncs(SyncStorageEngine.EndPoint target) {
        List<SyncOperation> ops = this.getAllPendingSyncs();
        ArrayList<PeriodicSync> periodicSyncs = new ArrayList<PeriodicSync>();
        for (SyncOperation op : ops) {
            if (!op.isPeriodic || !op.target.matchesSpec(target)) continue;
            periodicSyncs.add(new PeriodicSync(op.target.account, op.target.provider, op.extras, op.periodMillis / 1000L, op.flexMillis / 1000L));
        }
        return periodicSyncs;
    }

    public void scheduleLocalSync(Account account, int userId, int reason, String authority) {
        Bundle extras = new Bundle();
        extras.putBoolean("upload", true);
        this.scheduleSync(account, userId, reason, authority, extras, -2, LOCAL_SYNC_DELAY);
    }

    public SyncAdapterType[] getSyncAdapterTypes(int userId) {
        Collection serviceInfos = this.mSyncAdapters.getAllServices(userId);
        SyncAdapterType[] types = new SyncAdapterType[serviceInfos.size()];
        int i = 0;
        for (RegisteredServicesCache.ServiceInfo serviceInfo : serviceInfos) {
            types[i] = (SyncAdapterType)serviceInfo.type;
            ++i;
        }
        return types;
    }

    public String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) {
        return this.mSyncAdapters.getSyncAdapterPackagesForAuthority(authority, userId);
    }

    private void sendSyncFinishedOrCanceledMessage(ActiveSyncContext syncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 1;
        msg.obj = new SyncFinishedOrCancelledMessagePayload(syncContext, syncResult);
        this.mSyncHandler.sendMessage(msg);
    }

    private void sendCancelSyncsMessage(SyncStorageEngine.EndPoint info, Bundle extras) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "sending MESSAGE_CANCEL");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 6;
        msg.setData(extras);
        msg.obj = info;
        this.mSyncHandler.sendMessage(msg);
    }

    private void postMonitorSyncProgressMessage(ActiveSyncContext activeSyncContext) {
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "posting MESSAGE_SYNC_MONITOR in 60s");
        }
        activeSyncContext.mBytesTransferredAtLastPoll = this.getTotalBytesTransferredByUid(activeSyncContext.mSyncAdapterUid);
        activeSyncContext.mLastPolledTimeElapsed = SystemClock.elapsedRealtime();
        Message monitorMessage = this.mSyncHandler.obtainMessage(8, activeSyncContext);
        this.mSyncHandler.sendMessageDelayed(monitorMessage, 60000L);
    }

    private void postScheduleSyncMessage(SyncOperation syncOperation, long minDelayMillis) {
        ScheduleSyncMessagePayload payload = new ScheduleSyncMessagePayload(syncOperation, minDelayMillis);
        this.mSyncHandler.obtainMessage(12, payload).sendToTarget();
    }

    private long getTotalBytesTransferredByUid(int uid) {
        return TrafficStats.getUidRxBytes(uid) + TrafficStats.getUidTxBytes(uid);
    }

    private void clearBackoffSetting(SyncStorageEngine.EndPoint target) {
        Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(target);
        if (backoff != null && (Long)backoff.first == -1L && (Long)backoff.second == -1L) {
            return;
        }
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "Clearing backoffs for " + target);
        }
        this.mSyncStorageEngine.setBackoff(target, -1L, -1L);
        this.rescheduleSyncs(target);
    }

    private void increaseBackoffSetting(SyncStorageEngine.EndPoint target) {
        long maxSyncRetryTimeInSeconds;
        long now = SystemClock.elapsedRealtime();
        Pair<Long, Long> previousSettings = this.mSyncStorageEngine.getBackoff(target);
        long newDelayInMs = -1L;
        if (previousSettings != null) {
            if (now < (Long)previousSettings.first) {
                if (Log.isLoggable(TAG, 2)) {
                    Slog.v(TAG, "Still in backoff, do not increase it. Remaining: " + ((Long)previousSettings.first - now) / 1000L + " seconds.");
                }
                return;
            }
            newDelayInMs = (Long)previousSettings.second * 2L;
        }
        if (newDelayInMs <= 0L) {
            newDelayInMs = this.jitterize(30000L, 33000L);
        }
        if (newDelayInMs > (maxSyncRetryTimeInSeconds = Settings.Global.getLong(this.mContext.getContentResolver(), "sync_max_retry_delay_in_seconds", 3600L)) * 1000L) {
            newDelayInMs = maxSyncRetryTimeInSeconds * 1000L;
        }
        long backoff = now + newDelayInMs;
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "Backoff until: " + backoff + ", delayTime: " + newDelayInMs);
        }
        this.mSyncStorageEngine.setBackoff(target, backoff, newDelayInMs);
        this.rescheduleSyncs(target);
    }

    private void rescheduleSyncs(SyncStorageEngine.EndPoint target) {
        List<SyncOperation> ops = this.getAllPendingSyncs();
        int count = 0;
        for (SyncOperation op : ops) {
            if (op.isPeriodic || !op.target.matchesSpec(target)) continue;
            ++count;
            this.getJobScheduler().cancel(op.jobId);
            this.postScheduleSyncMessage(op, 0L);
        }
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "Rescheduled " + count + " syncs for " + target);
        }
    }

    private void setDelayUntilTime(SyncStorageEngine.EndPoint target, long delayUntilSeconds) {
        long delayUntil = delayUntilSeconds * 1000L;
        long absoluteNow = System.currentTimeMillis();
        long newDelayUntilTime = delayUntil > absoluteNow ? SystemClock.elapsedRealtime() + (delayUntil - absoluteNow) : 0L;
        this.mSyncStorageEngine.setDelayUntilTime(target, newDelayUntilTime);
        if (Log.isLoggable(TAG, 2)) {
            Slog.v(TAG, "Delay Until time set to " + newDelayUntilTime + " for " + target);
        }
        this.rescheduleSyncs(target);
    }

    private boolean isAdapterDelayed(SyncStorageEngine.EndPoint target) {
        long now = SystemClock.elapsedRealtime();
        Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(target);
        if (backoff != null && (Long)backoff.first != -1L && (Long)backoff.first > now) {
            return true;
        }
        return this.mSyncStorageEngine.getDelayUntilTime(target) > now;
    }

    public void cancelActiveSync(SyncStorageEngine.EndPoint info, Bundle extras) {
        this.sendCancelSyncsMessage(info, extras);
    }

    private void scheduleSyncOperationH(SyncOperation syncOperation) {
        this.scheduleSyncOperationH(syncOperation, 0L);
    }

    private void scheduleSyncOperationH(SyncOperation syncOperation, long minDelay) {
        long now;
        boolean isLoggable = Log.isLoggable(TAG, 2);
        if (syncOperation == null) {
            Slog.e(TAG, "Can't schedule null sync operation.");
            return;
        }
        if (!syncOperation.ignoreBackoff()) {
            long delayUntilDelay;
            Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(syncOperation.target);
            if (backoff == null) {
                Slog.e(TAG, "Couldn't find backoff values for " + syncOperation.target);
                backoff = new Pair<Long, Long>(-1L, -1L);
            }
            now = SystemClock.elapsedRealtime();
            long backoffDelay = (Long)backoff.first == -1L ? 0L : (Long)backoff.first - now;
            long delayUntil = this.mSyncStorageEngine.getDelayUntilTime(syncOperation.target);
            long l = delayUntilDelay = delayUntil > now ? delayUntil - now : 0L;
            if (isLoggable) {
                Slog.v(TAG, "backoff delay:" + backoffDelay + " delayUntil delay:" + delayUntilDelay);
            }
            minDelay = Math.max(minDelay, Math.max(backoffDelay, delayUntilDelay));
        }
        if (minDelay < 0L) {
            minDelay = 0L;
        }
        if (!syncOperation.isPeriodic) {
            for (ActiveSyncContext asc : this.mActiveSyncContexts) {
                if (!asc.mSyncOperation.key.equals(syncOperation.key)) continue;
                if (isLoggable) {
                    Log.v(TAG, "Duplicate sync is already running. Not scheduling " + syncOperation);
                }
                return;
            }
            int duplicatesCount = 0;
            now = SystemClock.elapsedRealtime();
            syncOperation.expectedRuntime = now + minDelay;
            List<SyncOperation> pending = this.getAllPendingSyncs();
            SyncOperation opWithLeastExpectedRuntime = syncOperation;
            for (SyncOperation op : pending) {
                if (op.isPeriodic || !op.key.equals(syncOperation.key)) continue;
                if (opWithLeastExpectedRuntime.expectedRuntime > op.expectedRuntime) {
                    opWithLeastExpectedRuntime = op;
                }
                ++duplicatesCount;
            }
            if (duplicatesCount > 1) {
                Slog.e(TAG, "FATAL ERROR! File a bug if you see this.");
            }
            for (SyncOperation op : pending) {
                if (op.isPeriodic || !op.key.equals(syncOperation.key) || op == opWithLeastExpectedRuntime) continue;
                if (isLoggable) {
                    Slog.v(TAG, "Cancelling duplicate sync " + op);
                }
                this.getJobScheduler().cancel(op.jobId);
            }
            if (opWithLeastExpectedRuntime != syncOperation) {
                if (isLoggable) {
                    Slog.v(TAG, "Not scheduling because a duplicate exists.");
                }
                return;
            }
        }
        if (syncOperation.jobId == -1) {
            syncOperation.jobId = this.getUnusedJobIdH();
        }
        if (isLoggable) {
            Slog.v(TAG, "scheduling sync operation " + syncOperation.toString());
        }
        int priority = syncOperation.findPriority();
        int networkType = syncOperation.isNotAllowedOnMetered() ? 2 : 1;
        JobInfo.Builder b = new JobInfo.Builder(syncOperation.jobId, new ComponentName(this.mContext, SyncJobService.class)).setExtras(syncOperation.toJobInfoExtras()).setRequiredNetworkType(networkType).setPersisted(true).setPriority(priority);
        if (syncOperation.isPeriodic) {
            b.setPeriodic(syncOperation.periodMillis, syncOperation.flexMillis);
        } else {
            if (minDelay > 0L) {
                b.setMinimumLatency(minDelay);
            }
            this.getSyncStorageEngine().markPending(syncOperation.target, true);
        }
        if (syncOperation.extras.getBoolean("require_charging")) {
            b.setRequiresCharging(true);
        }
        this.getJobScheduler().scheduleAsPackage(b.build(), syncOperation.owningPackage, syncOperation.target.userId, syncOperation.wakeLockName());
    }

    public void clearScheduledSyncOperations(SyncStorageEngine.EndPoint info) {
        List<SyncOperation> ops = this.getAllPendingSyncs();
        for (SyncOperation op : ops) {
            if (op.isPeriodic || !op.target.matchesSpec(info)) continue;
            this.getJobScheduler().cancel(op.jobId);
            this.getSyncStorageEngine().markPending(op.target, false);
        }
        this.mSyncStorageEngine.setBackoff(info, -1L, -1L);
    }

    public void cancelScheduledSyncOperation(SyncStorageEngine.EndPoint info, Bundle extras) {
        List<SyncOperation> ops = this.getAllPendingSyncs();
        for (SyncOperation op : ops) {
            if (op.isPeriodic || !op.target.matchesSpec(info) || !SyncManager.syncExtrasEquals(extras, op.extras, false)) continue;
            this.getJobScheduler().cancel(op.jobId);
        }
        this.setAuthorityPendingState(info);
        if (!this.mSyncStorageEngine.isSyncPending(info)) {
            this.mSyncStorageEngine.setBackoff(info, -1L, -1L);
        }
    }

    private void maybeRescheduleSync(SyncResult syncResult, SyncOperation operation) {
        boolean isLoggable = Log.isLoggable(TAG, 3);
        if (isLoggable) {
            Log.d(TAG, "encountered error(s) during the sync: " + syncResult + ", " + operation);
        }
        if (operation.extras.getBoolean("ignore_backoff", false)) {
            operation.extras.remove("ignore_backoff");
        }
        if (operation.extras.getBoolean("do_not_retry", false) && !syncResult.syncAlreadyInProgress) {
            if (isLoggable) {
                Log.d(TAG, "not retrying sync operation because SYNC_EXTRAS_DO_NOT_RETRY was specified " + operation);
            }
        } else if (operation.extras.getBoolean("upload", false) && !syncResult.syncAlreadyInProgress) {
            operation.extras.remove("upload");
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + operation);
            }
            this.scheduleSyncOperationH(operation);
        } else if (syncResult.tooManyRetries) {
            if (isLoggable) {
                Log.d(TAG, "not retrying sync operation because it retried too many times: " + operation);
            }
        } else if (syncResult.madeSomeProgress()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because even though it had an error it achieved some success");
            }
            this.scheduleSyncOperationH(operation);
        } else if (syncResult.syncAlreadyInProgress) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation that failed because there was already a sync in progress: " + operation);
            }
            this.scheduleSyncOperationH(operation, 10000L);
        } else if (syncResult.hasSoftError()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because it encountered a soft error: " + operation);
            }
            this.scheduleSyncOperationH(operation);
        } else {
            Log.d(TAG, "not retrying sync operation because the error is a hard error: " + operation);
        }
    }

    private void onUserUnlocked(int userId) {
        Account[] accounts;
        AccountManagerService.getSingleton().validateAccounts(userId);
        this.mSyncAdapters.invalidateCache(userId);
        SyncStorageEngine.EndPoint target = new SyncStorageEngine.EndPoint(null, null, userId);
        this.updateRunningAccounts(target);
        for (Account account : accounts = AccountManagerService.getSingleton().getAccounts(userId, this.mContext.getOpPackageName())) {
            this.scheduleSync(account, userId, -8, null, null, -1);
        }
    }

    private void onUserStopped(int userId) {
        this.updateRunningAccounts(null);
        this.cancelActiveSync(new SyncStorageEngine.EndPoint(null, null, userId), null);
    }

    private void onUserRemoved(int userId) {
        this.updateRunningAccounts(null);
        this.mSyncStorageEngine.doDatabaseCleanup(new Account[0], userId);
        List<SyncOperation> ops = this.getAllPendingSyncs();
        for (SyncOperation op : ops) {
            if (op.target.userId != userId) continue;
            this.getJobScheduler().cancel(op.jobId);
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter pw) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        this.dumpPendingSyncs(pw);
        this.dumpPeriodicSyncs(pw);
        this.dumpSyncState(ipw);
        this.dumpSyncHistory(ipw);
        this.dumpSyncAdapters(ipw);
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    protected void dumpPendingSyncs(PrintWriter pw) {
        pw.println("Pending Syncs:");
        List<SyncOperation> pendingSyncs = this.getAllPendingSyncs();
        int count = 0;
        for (SyncOperation op : pendingSyncs) {
            if (op.isPeriodic) continue;
            pw.println(op.dump(null, false));
            ++count;
        }
        pw.println("Total: " + count);
        pw.println();
    }

    protected void dumpPeriodicSyncs(PrintWriter pw) {
        pw.println("Periodic Syncs:");
        List<SyncOperation> pendingSyncs = this.getAllPendingSyncs();
        int count = 0;
        for (SyncOperation op : pendingSyncs) {
            if (!op.isPeriodic) continue;
            pw.println(op.dump(null, false));
            ++count;
        }
        pw.println("Total: " + count);
        pw.println();
    }

    protected void dumpSyncState(PrintWriter pw) {
        pw.print("data connected: ");
        pw.println(this.mDataConnectionIsConnected);
        pw.print("auto sync: ");
        List<UserInfo> users = this.getAllUsers();
        if (users != null) {
            for (UserInfo user : users) {
                pw.print("u" + user.id + "=" + this.mSyncStorageEngine.getMasterSyncAutomatically(user.id) + " ");
            }
            pw.println();
        }
        pw.print("memory low: ");
        pw.println(this.mStorageIsLow);
        pw.print("device idle: ");
        pw.println(this.mDeviceIsIdle);
        pw.print("reported active: ");
        pw.println(this.mReportedSyncActive);
        AccountAndUser[] accounts = AccountManagerService.getSingleton().getAllAccounts();
        pw.print("accounts: ");
        if (accounts != INITIAL_ACCOUNTS_ARRAY) {
            pw.println(accounts.length);
        } else {
            pw.println("not known yet");
        }
        long now = SystemClock.elapsedRealtime();
        pw.print("now: ");
        pw.print(now);
        pw.println(" (" + SyncManager.formatTime(System.currentTimeMillis()) + ")");
        pw.println(" (HH:MM:SS)");
        pw.print("uptime: ");
        pw.print(DateUtils.formatElapsedTime(now / 1000L));
        pw.println(" (HH:MM:SS)");
        pw.print("time spent syncing: ");
        pw.print(DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L));
        pw.print(" (HH:MM:SS), sync ");
        pw.print(this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ");
        pw.println("in progress");
        pw.println();
        pw.println("Active Syncs: " + this.mActiveSyncContexts.size());
        PackageManager pm = this.mContext.getPackageManager();
        for (ActiveSyncContext activeSyncContext : this.mActiveSyncContexts) {
            long durationInSeconds = (now - activeSyncContext.mStartTime) / 1000L;
            pw.print("  ");
            pw.print(DateUtils.formatElapsedTime(durationInSeconds));
            pw.print(" - ");
            pw.print(activeSyncContext.mSyncOperation.dump(pm, false));
            pw.println();
        }
        pw.println();
        pw.println("Sync Status");
        for (AccountAndUser account : accounts) {
            pw.printf("Account %s u%d %s\n", account.account.name, account.userId, account.account.type);
            pw.println("=======================================================================");
            PrintTable table = new PrintTable(13);
            table.set(0, 0, "Authority", "Syncable", "Enabled", "Delay", "Loc", "Poll", "Per", "Serv", "User", "Tot", "Time", "Last Sync", "Etc");
            ArrayList sorted = Lists.newArrayList();
            sorted.addAll(this.mSyncAdapters.getAllServices(account.userId));
            Collections.sort(sorted, new Comparator<RegisteredServicesCache.ServiceInfo<SyncAdapterType>>(){

                @Override
                public int compare(RegisteredServicesCache.ServiceInfo<SyncAdapterType> lhs, RegisteredServicesCache.ServiceInfo<SyncAdapterType> rhs) {
                    return ((SyncAdapterType)lhs.type).authority.compareTo(((SyncAdapterType)rhs.type).authority);
                }
            });
            for (RegisteredServicesCache.ServiceInfo serviceInfo : sorted) {
                if (!((SyncAdapterType)serviceInfo.type).accountType.equals(account.account.type)) continue;
                int row = table.getNumRows();
                Pair<SyncStorageEngine.AuthorityInfo, SyncStatusInfo> syncAuthoritySyncStatus = this.mSyncStorageEngine.getCopyOfAuthorityWithSyncStatus(new SyncStorageEngine.EndPoint(account.account, ((SyncAdapterType)serviceInfo.type).authority, account.userId));
                SyncStorageEngine.AuthorityInfo settings = (SyncStorageEngine.AuthorityInfo)syncAuthoritySyncStatus.first;
                SyncStatusInfo status = (SyncStatusInfo)syncAuthoritySyncStatus.second;
                String authority = settings.target.provider;
                if (authority.length() > 50) {
                    authority = authority.substring(authority.length() - 50);
                }
                table.set(row, 0, authority, settings.syncable, settings.enabled);
                table.set(row, 4, status.numSourceLocal, status.numSourcePoll, status.numSourcePeriodic, status.numSourceServer, status.numSourceUser, status.numSyncs, DateUtils.formatElapsedTime(status.totalElapsedTime / 1000L));
                int row1 = row;
                if (settings.delayUntil > now) {
                    table.set(row1++, 12, "D: " + (settings.delayUntil - now) / 1000L);
                    if (settings.backoffTime > now) {
                        table.set(row1++, 12, "B: " + (settings.backoffTime - now) / 1000L);
                        table.set(row1++, 12, settings.backoffDelay / 1000L);
                    }
                }
                row1 = row;
                if (status.lastSuccessTime != 0L) {
                    table.set(row1++, 11, SyncStorageEngine.SOURCES[status.lastSuccessSource] + " SUCCESS");
                    table.set(row1++, 11, SyncManager.formatTime(status.lastSuccessTime));
                }
                if (status.lastFailureTime == 0L) continue;
                table.set(row1++, 11, SyncStorageEngine.SOURCES[status.lastFailureSource] + " FAILURE");
                table.set(row1++, 11, SyncManager.formatTime(status.lastFailureTime));
                table.set(row1++, 11, status.lastFailureMesg);
            }
            table.writeTo(pw);
        }
    }

    private void dumpTimeSec(PrintWriter pw, long time) {
        pw.print(time / 1000L);
        pw.print('.');
        pw.print(time / 100L % 10L);
        pw.print('s');
    }

    private void dumpDayStatistic(PrintWriter pw, SyncStorageEngine.DayStats ds) {
        pw.print("Success (");
        pw.print(ds.successCount);
        if (ds.successCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.successTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.successTime / (long)ds.successCount);
        }
        pw.print(") Failure (");
        pw.print(ds.failureCount);
        if (ds.failureCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.failureTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.failureTime / (long)ds.failureCount);
        }
        pw.println(")");
    }

    protected void dumpSyncHistory(PrintWriter pw) {
        this.dumpRecentHistory(pw);
        this.dumpDayStatistics(pw);
    }

    private void dumpRecentHistory(PrintWriter pw) {
        ArrayList<SyncStorageEngine.SyncHistoryItem> items = this.mSyncStorageEngine.getSyncHistory();
        if (items != null && items.size() > 0) {
            SyncStorageEngine.SyncHistoryItem item;
            int i;
            HashMap<String, AuthoritySyncStats> authorityMap = Maps.newHashMap();
            long totalElapsedTime = 0L;
            long totalTimes = 0L;
            int N = items.size();
            int maxAuthority = 0;
            int maxAccount = 0;
            for (SyncStorageEngine.SyncHistoryItem item2 : items) {
                String accountKey;
                String authorityName;
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item2.authorityId);
                if (authorityInfo != null) {
                    authorityName = authorityInfo.target.provider;
                    accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                int length = authorityName.length();
                if (length > maxAuthority) {
                    maxAuthority = length;
                }
                if ((length = accountKey.length()) > maxAccount) {
                    maxAccount = length;
                }
                long elapsedTime = item2.elapsedTime;
                totalElapsedTime += elapsedTime;
                ++totalTimes;
                AuthoritySyncStats authoritySyncStats = (AuthoritySyncStats)authorityMap.get(authorityName);
                if (authoritySyncStats == null) {
                    authoritySyncStats = new AuthoritySyncStats(authorityName);
                    authorityMap.put(authorityName, authoritySyncStats);
                }
                authoritySyncStats.elapsedTime += elapsedTime;
                ++authoritySyncStats.times;
                Map<String, AccountSyncStats> accountMap = authoritySyncStats.accountMap;
                AccountSyncStats accountSyncStats = accountMap.get(accountKey);
                if (accountSyncStats == null) {
                    accountSyncStats = new AccountSyncStats(accountKey);
                    accountMap.put(accountKey, accountSyncStats);
                }
                accountSyncStats.elapsedTime += elapsedTime;
                ++accountSyncStats.times;
            }
            if (totalElapsedTime > 0L) {
                pw.println();
                pw.printf("Detailed Statistics (Recent history):  %d (# of times) %ds (sync time)\n", totalTimes, totalElapsedTime / 1000L);
                ArrayList sortedAuthorities = new ArrayList(authorityMap.values());
                Collections.sort(sortedAuthorities, new Comparator<AuthoritySyncStats>(){

                    @Override
                    public int compare(AuthoritySyncStats lhs, AuthoritySyncStats rhs) {
                        int compare = Integer.compare(rhs.times, lhs.times);
                        if (compare == 0) {
                            compare = Long.compare(rhs.elapsedTime, lhs.elapsedTime);
                        }
                        return compare;
                    }
                });
                int maxLength = Math.max(maxAuthority, maxAccount + 3);
                int padLength = 4 + maxLength + 2 + 10 + 11;
                char[] chars = new char[padLength];
                Arrays.fill(chars, '-');
                String separator = new String(chars);
                String authorityFormat = String.format("  %%-%ds: %%-9s  %%-11s\n", maxLength + 2);
                String accountFormat = String.format("    %%-%ds:   %%-9s  %%-11s\n", maxLength);
                pw.println(separator);
                for (AuthoritySyncStats authoritySyncStats : sortedAuthorities) {
                    String name = authoritySyncStats.name;
                    long elapsedTime = authoritySyncStats.elapsedTime;
                    int times = authoritySyncStats.times;
                    String timeStr = String.format("%ds/%d%%", elapsedTime / 1000L, elapsedTime * 100L / totalElapsedTime);
                    String timesStr = String.format("%d/%d%%", times, (long)(times * 100) / totalTimes);
                    pw.printf(authorityFormat, name, timesStr, timeStr);
                    ArrayList<AccountSyncStats> sortedAccounts = new ArrayList<AccountSyncStats>(authoritySyncStats.accountMap.values());
                    Collections.sort(sortedAccounts, new Comparator<AccountSyncStats>(){

                        @Override
                        public int compare(AccountSyncStats lhs, AccountSyncStats rhs) {
                            int compare = Integer.compare(rhs.times, lhs.times);
                            if (compare == 0) {
                                compare = Long.compare(rhs.elapsedTime, lhs.elapsedTime);
                            }
                            return compare;
                        }
                    });
                    for (AccountSyncStats stats : sortedAccounts) {
                        elapsedTime = stats.elapsedTime;
                        times = stats.times;
                        timeStr = String.format("%ds/%d%%", elapsedTime / 1000L, elapsedTime * 100L / totalElapsedTime);
                        timesStr = String.format("%d/%d%%", times, (long)(times * 100) / totalTimes);
                        pw.printf(accountFormat, stats.name, timesStr, timeStr);
                    }
                    pw.println(separator);
                }
            }
            pw.println();
            pw.println("Recent Sync History");
            String format = "  %-" + maxAccount + "s  %-" + maxAuthority + "s %s\n";
            HashMap<String, Long> lastTimeMap = Maps.newHashMap();
            PackageManager pm = this.mContext.getPackageManager();
            for (i = 0; i < N; ++i) {
                String diffString;
                String accountKey;
                String authorityName;
                item = items.get(i);
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item.authorityId);
                if (authorityInfo != null) {
                    authorityName = authorityInfo.target.provider;
                    accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                long elapsedTime = item.elapsedTime;
                Time time = new Time();
                long eventTime = item.eventTime;
                time.set(eventTime);
                String key = authorityName + "/" + accountKey;
                Long lastEventTime = (Long)lastTimeMap.get(key);
                if (lastEventTime == null) {
                    diffString = "";
                } else {
                    long diff = (lastEventTime - eventTime) / 1000L;
                    if (diff < 60L) {
                        diffString = String.valueOf(diff);
                    } else if (diff < 3600L) {
                        diffString = String.format("%02d:%02d", diff / 60L, diff % 60L);
                    } else {
                        long sec = diff % 3600L;
                        diffString = String.format("%02d:%02d:%02d", diff / 3600L, sec / 60L, sec % 60L);
                    }
                }
                lastTimeMap.put(key, eventTime);
                pw.printf("  #%-3d: %s %8s  %5.1fs  %8s", i + 1, SyncManager.formatTime(eventTime), SyncStorageEngine.SOURCES[item.source], Float.valueOf((float)elapsedTime / 1000.0f), diffString);
                pw.printf(format, accountKey, authorityName, SyncOperation.reasonToString(pm, item.reason));
                if (item.event != 1 || item.upstreamActivity != 0L || item.downstreamActivity != 0L) {
                    pw.printf("    event=%d upstreamActivity=%d downstreamActivity=%d\n", item.event, item.upstreamActivity, item.downstreamActivity);
                }
                if (item.mesg == null || "success".equals(item.mesg)) continue;
                pw.printf("    mesg=%s\n", item.mesg);
            }
            pw.println();
            pw.println("Recent Sync History Extras");
            for (i = 0; i < N; ++i) {
                String accountKey;
                String authorityName;
                item = items.get(i);
                Bundle extras = item.extras;
                if (extras == null || extras.size() == 0) continue;
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item.authorityId);
                if (authorityInfo != null) {
                    authorityName = authorityInfo.target.provider;
                    accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                Time time = new Time();
                long eventTime = item.eventTime;
                time.set(eventTime);
                pw.printf("  #%-3d: %s %8s ", i + 1, SyncManager.formatTime(eventTime), SyncStorageEngine.SOURCES[item.source]);
                pw.printf(format, accountKey, authorityName, extras);
            }
        }
    }

    private void dumpDayStatistics(PrintWriter pw) {
        SyncStorageEngine.DayStats[] dses = this.mSyncStorageEngine.getDayStatistics();
        if (dses != null && dses[0] != null) {
            int delta;
            SyncStorageEngine.DayStats ds;
            int i;
            pw.println();
            pw.println("Sync Statistics");
            pw.print("  Today:  ");
            this.dumpDayStatistic(pw, dses[0]);
            int today = dses[0].day;
            for (i = 1; i <= 6 && i < dses.length && (ds = dses[i]) != null && (delta = today - ds.day) <= 6; ++i) {
                pw.print("  Day-");
                pw.print(delta);
                pw.print(":  ");
                this.dumpDayStatistic(pw, ds);
            }
            int weekDay = today;
            while (i < dses.length) {
                SyncStorageEngine.DayStats aggr = null;
                weekDay -= 7;
                while (i < dses.length) {
                    ds = dses[i];
                    if (ds == null) {
                        i = dses.length;
                        break;
                    }
                    int delta2 = weekDay - ds.day;
                    if (delta2 > 6) break;
                    ++i;
                    if (aggr == null) {
                        aggr = new SyncStorageEngine.DayStats(weekDay);
                    }
                    aggr.successCount += ds.successCount;
                    aggr.successTime += ds.successTime;
                    aggr.failureCount += ds.failureCount;
                    aggr.failureTime += ds.failureTime;
                }
                if (aggr == null) continue;
                pw.print("  Week-");
                pw.print((today - weekDay) / 7);
                pw.print(": ");
                this.dumpDayStatistic(pw, aggr);
            }
        }
    }

    private void dumpSyncAdapters(IndentingPrintWriter pw) {
        pw.println();
        List<UserInfo> users = this.getAllUsers();
        if (users != null) {
            for (UserInfo user : users) {
                pw.println("Sync adapters for " + user + ":");
                pw.increaseIndent();
                for (RegisteredServicesCache.ServiceInfo info : this.mSyncAdapters.getAllServices(user.id)) {
                    pw.println(info);
                }
                pw.decreaseIndent();
                pw.println();
            }
        }
    }

    private boolean isSyncStillActiveH(ActiveSyncContext activeSyncContext) {
        for (ActiveSyncContext sync : this.mActiveSyncContexts) {
            if (sync != activeSyncContext) continue;
            return true;
        }
        return false;
    }

    public static boolean syncExtrasEquals(Bundle b1, Bundle b2, boolean includeSyncSettings) {
        if (b1 == b2) {
            return true;
        }
        if (includeSyncSettings && b1.size() != b2.size()) {
            return false;
        }
        Bundle bigger = b1.size() > b2.size() ? b1 : b2;
        Bundle smaller = b1.size() > b2.size() ? b2 : b1;
        for (String key : bigger.keySet()) {
            if (!includeSyncSettings && SyncManager.isSyncSetting(key)) continue;
            if (!smaller.containsKey(key)) {
                return false;
            }
            if (Objects.equals(bigger.get(key), smaller.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSyncSetting(String key) {
        if (key.equals("expedited")) {
            return true;
        }
        if (key.equals("ignore_settings")) {
            return true;
        }
        if (key.equals("ignore_backoff")) {
            return true;
        }
        if (key.equals("do_not_retry")) {
            return true;
        }
        if (key.equals("force")) {
            return true;
        }
        if (key.equals("upload")) {
            return true;
        }
        if (key.equals("deletions_override")) {
            return true;
        }
        if (key.equals("discard_deletions")) {
            return true;
        }
        if (key.equals("expected_upload")) {
            return true;
        }
        if (key.equals("expected_download")) {
            return true;
        }
        if (key.equals("sync_priority")) {
            return true;
        }
        if (key.equals("allow_metered")) {
            return true;
        }
        return key.equals("initialize");
    }

    private Context getContextForUser(UserHandle user) {
        try {
            return this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return this.mContext;
        }
    }

    static /* synthetic */ AccountAndUser[] access$3602(SyncManager x0, AccountAndUser[] x1) {
        x0.mRunningAccounts = x1;
        return x1;
    }

    static class PrintTable {
        private ArrayList<Object[]> mTable = Lists.newArrayList();
        private final int mCols;

        PrintTable(int cols) {
            this.mCols = cols;
        }

        void set(int row, int col, Object ... values) {
            if (col + values.length > this.mCols) {
                throw new IndexOutOfBoundsException("Table only has " + this.mCols + " columns. can't set " + values.length + " at column " + col);
            }
            for (int i = this.mTable.size(); i <= row; ++i) {
                Object[] list = new Object[this.mCols];
                this.mTable.add(list);
                for (int j = 0; j < this.mCols; ++j) {
                    list[j] = "";
                }
            }
            System.arraycopy(values, 0, this.mTable.get(row), col, values.length);
        }

        void writeTo(PrintWriter out) {
            int i;
            String[] formats = new String[this.mCols];
            int totalLength = 0;
            for (int col = 0; col < this.mCols; ++col) {
                int maxLength = 0;
                for (Object[] row : this.mTable) {
                    int length = row[col].toString().length();
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
                totalLength += maxLength;
                formats[col] = String.format("%%-%ds", maxLength);
            }
            formats[this.mCols - 1] = "%s";
            this.printRow(out, formats, this.mTable.get(0));
            totalLength += (this.mCols - 1) * 2;
            for (i = 0; i < totalLength; ++i) {
                out.print("-");
            }
            out.println();
            int mTableSize = this.mTable.size();
            for (i = 1; i < mTableSize; ++i) {
                Object[] row = this.mTable.get(i);
                this.printRow(out, formats, row);
            }
        }

        private void printRow(PrintWriter out, String[] formats, Object[] row) {
            int rowLength = row.length;
            for (int j = 0; j < rowLength; ++j) {
                out.printf(String.format(formats[j], row[j].toString()), new Object[0]);
                out.print("  ");
            }
            out.println();
        }

        public int getNumRows() {
            return this.mTable.size();
        }
    }

    class SyncHandler
    extends Handler {
        private static final int MESSAGE_SYNC_FINISHED = 1;
        private static final int MESSAGE_RELEASE_MESSAGES_FROM_QUEUE = 2;
        private static final int MESSAGE_SERVICE_CONNECTED = 4;
        private static final int MESSAGE_SERVICE_DISCONNECTED = 5;
        private static final int MESSAGE_CANCEL = 6;
        static final int MESSAGE_JOBSERVICE_OBJECT = 7;
        static final int MESSAGE_START_SYNC = 10;
        static final int MESSAGE_STOP_SYNC = 11;
        static final int MESSAGE_SCHEDULE_SYNC = 12;
        static final int MESSAGE_UPDATE_PERIODIC_SYNC = 13;
        static final int MESSAGE_REMOVE_PERIODIC_SYNC = 14;
        private static final int MESSAGE_MONITOR_SYNC = 8;
        private static final int MESSAGE_ACCOUNTS_UPDATED = 9;
        public final SyncTimeTracker mSyncTimeTracker;
        private final HashMap<String, PowerManager.WakeLock> mWakeLocks;
        private List<Message> mUnreadyQueue;

        void onBootCompleted() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "Boot completed.");
            }
            this.checkIfDeviceReady();
        }

        void onDeviceProvisioned() {
            if (Log.isLoggable(SyncManager.TAG, 3)) {
                Log.d(SyncManager.TAG, "mProvisioned=" + SyncManager.this.mProvisioned);
            }
            this.checkIfDeviceReady();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkIfDeviceReady() {
            if (SyncManager.this.mProvisioned && SyncManager.this.mBootCompleted && SyncManager.this.mJobServiceReady) {
                SyncHandler syncHandler = this;
                synchronized (syncHandler) {
                    SyncManager.this.mSyncStorageEngine.restoreAllPeriodicSyncs();
                    this.obtainMessage(2).sendToTarget();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryEnqueueMessageUntilReadyToRun(Message msg) {
            SyncHandler syncHandler = this;
            synchronized (syncHandler) {
                if (!(SyncManager.this.mBootCompleted && SyncManager.this.mProvisioned && SyncManager.this.mJobServiceReady)) {
                    Message m = Message.obtain(msg);
                    this.mUnreadyQueue.add(m);
                    return true;
                }
                return false;
            }
        }

        public SyncHandler(Looper looper) {
            super(looper);
            this.mSyncTimeTracker = new SyncTimeTracker();
            this.mWakeLocks = Maps.newHashMap();
            this.mUnreadyQueue = new ArrayList<Message>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            try {
                SyncManager.this.mSyncManagerWakeLock.acquire();
                if (msg.what == 7) {
                    Slog.i(SyncManager.TAG, "Got SyncJobService instance.");
                    SyncManager.this.mSyncJobService = (SyncJobService)msg.obj;
                    SyncManager.this.mJobServiceReady = true;
                    this.checkIfDeviceReady();
                } else if (msg.what == 9) {
                    if (Log.isLoggable(SyncManager.TAG, 2)) {
                        Slog.v(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_ACCOUNTS_UPDATED");
                    }
                    SyncStorageEngine.EndPoint targets = (SyncStorageEngine.EndPoint)msg.obj;
                    this.updateRunningAccountsH(targets);
                } else if (msg.what == 2) {
                    if (this.mUnreadyQueue != null) {
                        for (Message m : this.mUnreadyQueue) {
                            this.handleSyncMessage(m);
                        }
                        this.mUnreadyQueue = null;
                    }
                } else if (this.tryEnqueueMessageUntilReadyToRun(msg)) {
                } else {
                    this.handleSyncMessage(msg);
                }
            }
            finally {
                SyncManager.this.mSyncManagerWakeLock.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void handleSyncMessage(Message msg) {
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            try {
                SyncManager.this.mDataConnectionIsConnected = SyncManager.this.readDataConnectionState();
                switch (msg.what) {
                    case 12: {
                        ScheduleSyncMessagePayload syncPayload = (ScheduleSyncMessagePayload)msg.obj;
                        SyncOperation op = syncPayload.syncOperation;
                        SyncManager.this.scheduleSyncOperationH(op, syncPayload.minDelayMillis);
                        return;
                    }
                    case 10: {
                        SyncOperation op = (SyncOperation)msg.obj;
                        this.startSyncH(op);
                        return;
                    }
                    case 11: {
                        boolean applyBackoff;
                        ActiveSyncContext asc;
                        SyncOperation op = (SyncOperation)msg.obj;
                        if (isLoggable) {
                            Slog.v(SyncManager.TAG, "Stop sync received.");
                        }
                        if ((asc = this.findActiveSyncContextH(op.jobId)) == null) return;
                        this.runSyncFinishedOrCanceledH(null, asc);
                        boolean reschedule = msg.arg1 != 0;
                        boolean bl = applyBackoff = msg.arg2 != 0;
                        if (isLoggable) {
                            Slog.v(SyncManager.TAG, "Stopping sync. Reschedule: " + reschedule + "Backoff: " + applyBackoff);
                        }
                        if (applyBackoff) {
                            SyncManager.this.increaseBackoffSetting(op.target);
                        }
                        if (!reschedule) return;
                        this.deferStoppedSyncH(op, 0L);
                        return;
                    }
                    case 13: {
                        UpdatePeriodicSyncMessagePayload data = (UpdatePeriodicSyncMessagePayload)msg.obj;
                        this.updateOrAddPeriodicSyncH(data.target, data.pollFrequency, data.flex, data.extras);
                        return;
                    }
                    case 14: {
                        this.removePeriodicSyncH((SyncStorageEngine.EndPoint)msg.obj, msg.getData());
                        return;
                    }
                    case 6: {
                        SyncStorageEngine.EndPoint endpoint = (SyncStorageEngine.EndPoint)msg.obj;
                        Bundle extras = msg.peekData();
                        if (Log.isLoggable(SyncManager.TAG, 3)) {
                            Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_CANCEL: " + endpoint + " bundle: " + extras);
                        }
                        this.cancelActiveSyncH(endpoint, extras);
                        return;
                    }
                    case 1: {
                        SyncFinishedOrCancelledMessagePayload payload = (SyncFinishedOrCancelledMessagePayload)msg.obj;
                        if (!SyncManager.this.isSyncStillActiveH(payload.activeSyncContext)) {
                            Log.d(SyncManager.TAG, "handleSyncHandlerMessage: dropping since the sync is no longer active: " + payload.activeSyncContext);
                            return;
                        }
                        if (isLoggable) {
                            Slog.v(SyncManager.TAG, "syncFinished" + payload.activeSyncContext.mSyncOperation);
                        }
                        SyncManager.this.mSyncJobService.callJobFinished(payload.activeSyncContext.mSyncOperation.jobId, false);
                        this.runSyncFinishedOrCanceledH(payload.syncResult, payload.activeSyncContext);
                        return;
                    }
                    case 4: {
                        ServiceConnectionData msgData = (ServiceConnectionData)msg.obj;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SERVICE_CONNECTED: " + msgData.activeSyncContext);
                        }
                        if (!SyncManager.this.isSyncStillActiveH(msgData.activeSyncContext)) return;
                        this.runBoundToAdapterH(msgData.activeSyncContext, msgData.adapter);
                        return;
                    }
                    case 5: {
                        ActiveSyncContext currentSyncContext = ((ServiceConnectionData)msg.obj).activeSyncContext;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_SERVICE_DISCONNECTED: " + currentSyncContext);
                        }
                        if (!SyncManager.this.isSyncStillActiveH(currentSyncContext)) return;
                        try {
                            if (currentSyncContext.mSyncAdapter != null) {
                                currentSyncContext.mSyncAdapter.cancelSync(currentSyncContext);
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                        SyncResult syncResult = new SyncResult();
                        ++syncResult.stats.numIoExceptions;
                        SyncManager.this.mSyncJobService.callJobFinished(currentSyncContext.mSyncOperation.jobId, false);
                        this.runSyncFinishedOrCanceledH(syncResult, currentSyncContext);
                        return;
                    }
                    case 8: {
                        ActiveSyncContext monitoredSyncContext = (ActiveSyncContext)msg.obj;
                        if (Log.isLoggable(SyncManager.TAG, 3)) {
                            Log.d(SyncManager.TAG, "handleSyncHandlerMessage: MESSAGE_MONITOR_SYNC: " + monitoredSyncContext.mSyncOperation.target);
                        }
                        if (this.isSyncNotUsingNetworkH(monitoredSyncContext)) {
                            Log.w(SyncManager.TAG, String.format("Detected sync making no progress for %s. cancelling.", monitoredSyncContext));
                            SyncManager.this.mSyncJobService.callJobFinished(monitoredSyncContext.mSyncOperation.jobId, false);
                            this.runSyncFinishedOrCanceledH(null, monitoredSyncContext);
                            return;
                        }
                        SyncManager.this.postMonitorSyncProgressMessage(monitoredSyncContext);
                        return;
                    }
                }
                return;
            }
            finally {
                this.mSyncTimeTracker.update();
            }
        }

        private PowerManager.WakeLock getSyncWakeLock(SyncOperation operation) {
            String wakeLockKey = operation.wakeLockName();
            PowerManager.WakeLock wakeLock = this.mWakeLocks.get(wakeLockKey);
            if (wakeLock == null) {
                String name = SyncManager.SYNC_WAKE_LOCK_PREFIX + wakeLockKey;
                wakeLock = SyncManager.this.mPowerManager.newWakeLock(1, name);
                wakeLock.setReferenceCounted(false);
                this.mWakeLocks.put(wakeLockKey, wakeLock);
            }
            return wakeLock;
        }

        private void deferSyncH(SyncOperation op, long delay) {
            SyncManager.this.mSyncJobService.callJobFinished(op.jobId, false);
            if (op.isPeriodic) {
                SyncManager.this.scheduleSyncOperationH(op.createOneTimeSyncOperation(), delay);
            } else {
                SyncManager.this.getJobScheduler().cancel(op.jobId);
                SyncManager.this.scheduleSyncOperationH(op, delay);
            }
        }

        private void deferStoppedSyncH(SyncOperation op, long delay) {
            if (op.isPeriodic) {
                SyncManager.this.scheduleSyncOperationH(op.createOneTimeSyncOperation(), delay);
            } else {
                SyncManager.this.scheduleSyncOperationH(op, delay);
            }
        }

        private void deferActiveSyncH(ActiveSyncContext asc) {
            SyncOperation op = asc.mSyncOperation;
            this.runSyncFinishedOrCanceledH(null, asc);
            this.deferSyncH(op, 10000L);
        }

        private void startSyncH(SyncOperation op) {
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Slog.v(SyncManager.TAG, op.toString());
            }
            if (SyncManager.this.mStorageIsLow) {
                this.deferSyncH(op, 3600000L);
                return;
            }
            if (op.isPeriodic) {
                List ops = SyncManager.this.getAllPendingSyncs();
                Iterator<Object> iterator = ops.iterator();
                while (iterator.hasNext()) {
                    SyncOperation syncOperation = (SyncOperation)iterator.next();
                    if (syncOperation.sourcePeriodicId != op.jobId) continue;
                    SyncManager.this.mSyncJobService.callJobFinished(op.jobId, false);
                    return;
                }
                for (ActiveSyncContext asc : SyncManager.this.mActiveSyncContexts) {
                    if (asc.mSyncOperation.sourcePeriodicId != op.jobId) continue;
                    SyncManager.this.mSyncJobService.callJobFinished(op.jobId, false);
                    return;
                }
                if (SyncManager.this.isAdapterDelayed(op.target)) {
                    this.deferSyncH(op, 0L);
                    return;
                }
            }
            for (ActiveSyncContext asc : SyncManager.this.mActiveSyncContexts) {
                if (!asc.mSyncOperation.isConflict(op)) continue;
                if (asc.mSyncOperation.findPriority() >= op.findPriority()) {
                    if (isLoggable) {
                        Slog.v(SyncManager.TAG, "Rescheduling sync due to conflict " + op.toString());
                    }
                    this.deferSyncH(op, 10000L);
                    return;
                }
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "Pushing back running sync due to a higher priority sync");
                }
                this.deferActiveSyncH(asc);
                break;
            }
            int syncOpState = this.computeSyncOpState(op);
            switch (syncOpState) {
                case 1: 
                case 2: {
                    SyncManager.this.mSyncJobService.callJobFinished(op.jobId, false);
                    return;
                }
            }
            if (!this.dispatchSyncOperation(op)) {
                SyncManager.this.mSyncJobService.callJobFinished(op.jobId, false);
            }
            SyncManager.this.setAuthorityPendingState(op.target);
        }

        private ActiveSyncContext findActiveSyncContextH(int jobId) {
            for (ActiveSyncContext asc : SyncManager.this.mActiveSyncContexts) {
                SyncOperation op = asc.mSyncOperation;
                if (op == null || op.jobId != jobId) continue;
                return asc;
            }
            return null;
        }

        private void updateRunningAccountsH(SyncStorageEngine.EndPoint syncTargets) {
            AccountAndUser[] oldAccounts = SyncManager.this.mRunningAccounts;
            SyncManager.access$3602(SyncManager.this, AccountManagerService.getSingleton().getRunningAccounts());
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "Accounts list: ");
                for (AccountAndUser acc : SyncManager.this.mRunningAccounts) {
                    Slog.v(SyncManager.TAG, acc.toString());
                }
            }
            if (SyncManager.this.mBootCompleted) {
                SyncManager.this.doDatabaseCleanup();
            }
            AccountAndUser[] accounts = SyncManager.this.mRunningAccounts;
            for (ActiveSyncContext currentSyncContext : SyncManager.this.mActiveSyncContexts) {
                if (SyncManager.this.containsAccountAndUser(accounts, currentSyncContext.mSyncOperation.target.account, currentSyncContext.mSyncOperation.target.userId)) continue;
                Log.d(SyncManager.TAG, "canceling sync since the account is no longer running");
                SyncManager.this.sendSyncFinishedOrCanceledMessage(currentSyncContext, null);
            }
            for (AccountAndUser aau : SyncManager.this.mRunningAccounts) {
                if (SyncManager.this.containsAccountAndUser(oldAccounts, aau.account, aau.userId)) continue;
                if (Log.isLoggable(SyncManager.TAG, 3)) {
                    Log.d(SyncManager.TAG, "Account " + aau.account + " added, checking sync restore data");
                }
                AccountSyncSettingsBackupHelper.accountAdded(SyncManager.this.mContext);
                break;
            }
            AccountAndUser[] allAccounts = AccountManagerService.getSingleton().getAllAccounts();
            List ops = SyncManager.this.getAllPendingSyncs();
            for (SyncOperation op : ops) {
                if (SyncManager.this.containsAccountAndUser(allAccounts, op.target.account, op.target.userId)) continue;
                SyncManager.this.getJobScheduler().cancel(op.jobId);
            }
            if (syncTargets != null) {
                SyncManager.this.scheduleSync(syncTargets.account, syncTargets.userId, -2, syncTargets.provider, null, -1);
            }
        }

        private void maybeUpdateSyncPeriodH(SyncOperation syncOperation, long pollFrequencyMillis, long flexMillis) {
            if (pollFrequencyMillis != syncOperation.periodMillis || flexMillis != syncOperation.flexMillis) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Slog.v(SyncManager.TAG, "updating period " + syncOperation + " to " + pollFrequencyMillis + " and flex to " + flexMillis);
                }
                SyncOperation newOp = new SyncOperation(syncOperation, pollFrequencyMillis, flexMillis);
                newOp.jobId = syncOperation.jobId;
                SyncManager.this.scheduleSyncOperationH(newOp);
            }
        }

        private void updateOrAddPeriodicSyncH(SyncStorageEngine.EndPoint target, long pollFrequency, long flex, Bundle extras) {
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo;
            SyncOperation op2;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            SyncManager.this.verifyJobScheduler();
            long pollFrequencyMillis = pollFrequency * 1000L;
            long flexMillis = flex * 1000L;
            if (isLoggable) {
                Slog.v(SyncManager.TAG, "Addition to periodic syncs requested: " + target + " period: " + pollFrequency + " flexMillis: " + flex + " extras: " + extras.toString());
            }
            List ops = SyncManager.this.getAllPendingSyncs();
            for (SyncOperation op2 : ops) {
                if (!op2.isPeriodic || !op2.target.matchesSpec(target) || !SyncManager.syncExtrasEquals(op2.extras, extras, true)) continue;
                this.maybeUpdateSyncPeriodH(op2, pollFrequencyMillis, flexMillis);
                return;
            }
            if (isLoggable) {
                Slog.v(SyncManager.TAG, "Adding new periodic sync: " + target + " period: " + pollFrequency + " flexMillis: " + flex + " extras: " + extras.toString());
            }
            if ((syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(target.provider, target.account.type), target.userId)) == null) {
                return;
            }
            op2 = new SyncOperation(target, syncAdapterInfo.uid, syncAdapterInfo.componentName.getPackageName(), -4, 4, extras, ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs(), true, -1, pollFrequencyMillis, flexMillis);
            int syncOpState = this.computeSyncOpState(op2);
            switch (syncOpState) {
                case 2: {
                    String packageName = op2.owningPackage;
                    int userId = UserHandle.getUserId(op2.owningUid);
                    if (!SyncManager.this.mPackageManagerInternal.wasPackageEverLaunched(packageName, userId)) {
                        return;
                    }
                    SyncManager.this.mAccountManagerInternal.requestAccountAccess(op2.target.account, packageName, userId, new RemoteCallback(result -> {
                        if (result != null && result.getBoolean("booleanResult")) {
                            SyncManager.this.updateOrAddPeriodicSync(target, pollFrequency, flex, extras);
                        }
                    }));
                    return;
                }
                case 1: {
                    return;
                }
            }
            SyncManager.this.scheduleSyncOperationH(op2);
            SyncManager.this.mSyncStorageEngine.reportChange(1);
        }

        private void removePeriodicSyncInternalH(SyncOperation syncOperation) {
            List ops = SyncManager.this.getAllPendingSyncs();
            for (SyncOperation op : ops) {
                if (op.sourcePeriodicId != syncOperation.jobId && op.jobId != syncOperation.jobId) continue;
                ActiveSyncContext asc = this.findActiveSyncContextH(syncOperation.jobId);
                if (asc != null) {
                    SyncManager.this.mSyncJobService.callJobFinished(syncOperation.jobId, false);
                    this.runSyncFinishedOrCanceledH(null, asc);
                }
                SyncManager.this.getJobScheduler().cancel(op.jobId);
            }
        }

        private void removePeriodicSyncH(SyncStorageEngine.EndPoint target, Bundle extras) {
            SyncManager.this.verifyJobScheduler();
            List ops = SyncManager.this.getAllPendingSyncs();
            for (SyncOperation op : ops) {
                if (!op.isPeriodic || !op.target.matchesSpec(target) || !SyncManager.syncExtrasEquals(op.extras, extras, true)) continue;
                this.removePeriodicSyncInternalH(op);
            }
        }

        private boolean isSyncNotUsingNetworkH(ActiveSyncContext activeSyncContext) {
            long bytesTransferredCurrent = SyncManager.this.getTotalBytesTransferredByUid(activeSyncContext.mSyncAdapterUid);
            long deltaBytesTransferred = bytesTransferredCurrent - activeSyncContext.mBytesTransferredAtLastPoll;
            if (Log.isLoggable(SyncManager.TAG, 3)) {
                long remainder = deltaBytesTransferred;
                long mb = remainder / 0x100000L;
                long kb = (remainder %= 0x100000L) / 1024L;
                long b = remainder %= 1024L;
                Log.d(SyncManager.TAG, String.format("Time since last update: %ds. Delta transferred: %dMBs,%dKBs,%dBs", (SystemClock.elapsedRealtime() - activeSyncContext.mLastPolledTimeElapsed) / 1000L, mb, kb, b));
            }
            return deltaBytesTransferred <= 10L;
        }

        private int computeSyncOpState(SyncOperation op) {
            boolean ignoreSystemConfiguration;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            SyncStorageEngine.EndPoint target = op.target;
            AccountAndUser[] accounts = SyncManager.this.mRunningAccounts;
            if (!SyncManager.this.containsAccountAndUser(accounts, target.account, target.userId)) {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "    Dropping sync operation: account doesn't exist.");
                }
                return 1;
            }
            int state = SyncManager.this.computeSyncable(target.account, target.userId, target.provider);
            if (state == 3) {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "    Dropping sync operation: isSyncable == SYNCABLE_NO_ACCOUNT_ACCESS");
                }
                return 2;
            }
            if (state == 0) {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "    Dropping sync operation: isSyncable == NOT_SYNCABLE");
                }
                return 1;
            }
            boolean syncEnabled = SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically(target.userId) && SyncManager.this.mSyncStorageEngine.getSyncAutomatically(target.account, target.userId, target.provider);
            boolean bl = ignoreSystemConfiguration = op.isIgnoreSettings() || state < 0;
            if (!syncEnabled && !ignoreSystemConfiguration) {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "    Dropping sync operation: disallowed by settings/network.");
                }
                return 1;
            }
            return 0;
        }

        private boolean dispatchSyncOperation(SyncOperation op) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "dispatchSyncOperation: we are going to sync " + op);
                Slog.v(SyncManager.TAG, "num active syncs: " + SyncManager.this.mActiveSyncContexts.size());
                for (ActiveSyncContext syncContext : SyncManager.this.mActiveSyncContexts) {
                    Slog.v(SyncManager.TAG, syncContext.toString());
                }
            }
            SyncStorageEngine.EndPoint info = op.target;
            SyncAdapterType syncAdapterType = SyncAdapterType.newKey(info.provider, info.account.type);
            RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(syncAdapterType, info.userId);
            if (syncAdapterInfo == null) {
                Log.d(SyncManager.TAG, "can't find a sync adapter for " + syncAdapterType + ", removing settings for it");
                SyncManager.this.mSyncStorageEngine.removeAuthority(info);
                return false;
            }
            int targetUid = syncAdapterInfo.uid;
            ComponentName targetComponent = syncAdapterInfo.componentName;
            ActiveSyncContext activeSyncContext = new ActiveSyncContext(op, this.insertStartSyncEvent(op), targetUid);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "dispatchSyncOperation: starting " + activeSyncContext);
            }
            activeSyncContext.mSyncInfo = SyncManager.this.mSyncStorageEngine.addActiveSync(activeSyncContext);
            SyncManager.this.mActiveSyncContexts.add(activeSyncContext);
            SyncManager.this.postMonitorSyncProgressMessage(activeSyncContext);
            if (!activeSyncContext.bindToSyncAdapter(targetComponent, info.userId)) {
                Slog.e(SyncManager.TAG, "Bind attempt failed - target: " + targetComponent);
                this.closeActiveSyncContext(activeSyncContext);
                return false;
            }
            return true;
        }

        private void runBoundToAdapterH(ActiveSyncContext activeSyncContext, IBinder syncAdapter) {
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            try {
                activeSyncContext.mIsLinkedToDeath = true;
                syncAdapter.linkToDeath(activeSyncContext, 0);
                activeSyncContext.mSyncAdapter = ISyncAdapter.Stub.asInterface(syncAdapter);
                activeSyncContext.mSyncAdapter.startSync(activeSyncContext, syncOperation.target.provider, syncOperation.target.account, syncOperation.extras);
            }
            catch (RemoteException remoteExc) {
                Log.d(SyncManager.TAG, "maybeStartNextSync: caught a RemoteException, rescheduling", remoteExc);
                this.closeActiveSyncContext(activeSyncContext);
                SyncManager.this.increaseBackoffSetting(syncOperation.target);
                SyncManager.this.scheduleSyncOperationH(syncOperation);
            }
            catch (RuntimeException exc) {
                this.closeActiveSyncContext(activeSyncContext);
                Slog.e(SyncManager.TAG, "Caught RuntimeException while starting the sync " + syncOperation, exc);
            }
        }

        private void cancelActiveSyncH(SyncStorageEngine.EndPoint info, Bundle extras) {
            ArrayList<ActiveSyncContext> activeSyncs = new ArrayList<ActiveSyncContext>(SyncManager.this.mActiveSyncContexts);
            for (ActiveSyncContext activeSyncContext : activeSyncs) {
                SyncStorageEngine.EndPoint opInfo;
                if (activeSyncContext == null || !(opInfo = activeSyncContext.mSyncOperation.target).matchesSpec(info) || extras != null && !SyncManager.syncExtrasEquals(activeSyncContext.mSyncOperation.extras, extras, false)) continue;
                SyncManager.this.mSyncJobService.callJobFinished(activeSyncContext.mSyncOperation.jobId, false);
                this.runSyncFinishedOrCanceledH(null, activeSyncContext);
            }
        }

        private void reschedulePeriodicSyncH(SyncOperation syncOperation) {
            SyncOperation periodicSync = null;
            List ops = SyncManager.this.getAllPendingSyncs();
            for (SyncOperation op : ops) {
                if (!op.isPeriodic || !syncOperation.matchesPeriodicOperation(op)) continue;
                periodicSync = op;
                break;
            }
            if (periodicSync == null) {
                return;
            }
            SyncManager.this.scheduleSyncOperationH(periodicSync);
        }

        private void runSyncFinishedOrCanceledH(SyncResult syncResult, ActiveSyncContext activeSyncContext) {
            int upstreamActivity;
            int downstreamActivity;
            String historyMessage;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            SyncStorageEngine.EndPoint info = syncOperation.target;
            if (activeSyncContext.mIsLinkedToDeath) {
                activeSyncContext.mSyncAdapter.asBinder().unlinkToDeath(activeSyncContext, 0);
                activeSyncContext.mIsLinkedToDeath = false;
            }
            this.closeActiveSyncContext(activeSyncContext);
            long elapsedTime = SystemClock.elapsedRealtime() - activeSyncContext.mStartTime;
            if (!syncOperation.isPeriodic) {
                SyncManager.this.getJobScheduler().cancel(syncOperation.jobId);
            }
            if (syncResult != null) {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "runSyncFinishedOrCanceled [finished]: " + syncOperation + ", result " + syncResult);
                }
                if (!syncResult.hasError()) {
                    historyMessage = "success";
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                    SyncManager.this.clearBackoffSetting(syncOperation.target);
                    if (syncOperation.isDerivedFromFailedPeriodicSync()) {
                        this.reschedulePeriodicSyncH(syncOperation);
                    }
                } else {
                    Log.d(SyncManager.TAG, "failed sync operation " + syncOperation + ", " + syncResult);
                    SyncManager.this.increaseBackoffSetting(syncOperation.target);
                    if (!syncOperation.isPeriodic) {
                        SyncManager.this.maybeRescheduleSync(syncResult, syncOperation);
                    } else {
                        SyncManager.this.postScheduleSyncMessage(syncOperation.createOneTimeSyncOperation(), 0L);
                    }
                    historyMessage = ContentResolver.syncErrorToString(this.syncResultToErrorNumber(syncResult));
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                }
                SyncManager.this.setDelayUntilTime(syncOperation.target, syncResult.delayUntil);
            } else {
                if (isLoggable) {
                    Slog.v(SyncManager.TAG, "runSyncFinishedOrCanceled [canceled]: " + syncOperation);
                }
                if (activeSyncContext.mSyncAdapter != null) {
                    try {
                        activeSyncContext.mSyncAdapter.cancelSync(activeSyncContext);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                historyMessage = "canceled";
                downstreamActivity = 0;
                upstreamActivity = 0;
            }
            this.stopSyncEvent(activeSyncContext.mHistoryRowId, syncOperation, historyMessage, upstreamActivity, downstreamActivity, elapsedTime);
            if (syncResult != null && syncResult.tooManyDeletions) {
                this.installHandleTooManyDeletesNotification(info.account, info.provider, syncResult.stats.numDeletes, info.userId);
            } else {
                SyncManager.this.mNotificationMgr.cancelAsUser(Integer.toString(info.account.hashCode() ^ info.provider.hashCode()), 18, new UserHandle(info.userId));
            }
            if (syncResult != null && syncResult.fullSyncRequested) {
                SyncManager.this.scheduleSyncOperationH(new SyncOperation(info.account, info.userId, syncOperation.owningUid, syncOperation.owningPackage, syncOperation.reason, syncOperation.syncSource, info.provider, new Bundle(), syncOperation.allowParallelSyncs));
            }
        }

        private void closeActiveSyncContext(ActiveSyncContext activeSyncContext) {
            activeSyncContext.close();
            SyncManager.this.mActiveSyncContexts.remove(activeSyncContext);
            SyncManager.this.mSyncStorageEngine.removeActiveSync(activeSyncContext.mSyncInfo, activeSyncContext.mSyncOperation.target.userId);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "removing all MESSAGE_MONITOR_SYNC & MESSAGE_SYNC_EXPIRED for " + activeSyncContext.toString());
            }
            SyncManager.this.mSyncHandler.removeMessages(8, activeSyncContext);
        }

        private int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            throw new IllegalStateException("we are not in an error state, " + syncResult);
        }

        private void installHandleTooManyDeletesNotification(Account account, String authority, long numDeletes, int userId) {
            if (SyncManager.this.mNotificationMgr == null) {
                return;
            }
            ProviderInfo providerInfo = SyncManager.this.mContext.getPackageManager().resolveContentProvider(authority, 0);
            if (providerInfo == null) {
                return;
            }
            CharSequence authorityName = providerInfo.loadLabel(SyncManager.this.mContext.getPackageManager());
            Intent clickIntent = new Intent(SyncManager.this.mContext, SyncActivityTooManyDeletes.class);
            clickIntent.putExtra("account", account);
            clickIntent.putExtra("authority", authority);
            clickIntent.putExtra("provider", authorityName.toString());
            clickIntent.putExtra("numDeletes", numDeletes);
            if (!this.isActivityAvailable(clickIntent)) {
                Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            UserHandle user = new UserHandle(userId);
            PendingIntent pendingIntent = PendingIntent.getActivityAsUser(SyncManager.this.mContext, 0, clickIntent, 0x10000000, null, user);
            CharSequence tooManyDeletesDescFormat = SyncManager.this.mContext.getResources().getText(17039696);
            Context contextForUser = SyncManager.this.getContextForUser(user);
            Notification notification = new Notification.Builder(contextForUser, SystemNotificationChannels.ACCOUNT).setSmallIcon(17303298).setTicker(SyncManager.this.mContext.getString(17039694)).setWhen(System.currentTimeMillis()).setColor(contextForUser.getColor(17170761)).setContentTitle(contextForUser.getString(17039695)).setContentText(String.format(tooManyDeletesDescFormat.toString(), authorityName)).setContentIntent(pendingIntent).build();
            notification.flags |= 2;
            SyncManager.this.mNotificationMgr.notifyAsUser(Integer.toString(account.hashCode() ^ authority.hashCode()), 18, notification, user);
        }

        private boolean isActivityAvailable(Intent intent) {
            PackageManager pm = SyncManager.this.mContext.getPackageManager();
            List<ResolveInfo> list = pm.queryIntentActivities(intent, 0);
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ResolveInfo resolveInfo = list.get(i);
                if ((resolveInfo.activityInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            return false;
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            long now = System.currentTimeMillis();
            EventLog.writeEvent(2720, syncOperation.toEventLog(0));
            return SyncManager.this.mSyncStorageEngine.insertStartSyncEvent(syncOperation, now);
        }

        public void stopSyncEvent(long rowId, SyncOperation syncOperation, String resultMessage, int upstreamActivity, int downstreamActivity, long elapsedTime) {
            EventLog.writeEvent(2720, syncOperation.toEventLog(1));
            SyncManager.this.mSyncStorageEngine.stopSyncEvent(rowId, elapsedTime, resultMessage, downstreamActivity, upstreamActivity);
        }
    }

    class ServiceConnectionData {
        public final ActiveSyncContext activeSyncContext;
        public final IBinder adapter;

        ServiceConnectionData(ActiveSyncContext activeSyncContext, IBinder adapter) {
            this.activeSyncContext = activeSyncContext;
            this.adapter = adapter;
        }
    }

    private class SyncTimeTracker {
        boolean mLastWasSyncing = false;
        long mWhenSyncStarted = 0L;
        private long mTimeSpentSyncing;

        private SyncTimeTracker() {
        }

        public synchronized void update() {
            boolean isSyncInProgress;
            boolean bl = isSyncInProgress = !SyncManager.this.mActiveSyncContexts.isEmpty();
            if (isSyncInProgress == this.mLastWasSyncing) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            if (isSyncInProgress) {
                this.mWhenSyncStarted = now;
            } else {
                this.mTimeSpentSyncing += now - this.mWhenSyncStarted;
            }
            this.mLastWasSyncing = isSyncInProgress;
        }

        public synchronized long timeSpentSyncing() {
            if (!this.mLastWasSyncing) {
                return this.mTimeSpentSyncing;
            }
            long now = SystemClock.elapsedRealtime();
            return this.mTimeSpentSyncing + (now - this.mWhenSyncStarted);
        }
    }

    private static class AccountSyncStats {
        String name;
        long elapsedTime;
        int times;

        private AccountSyncStats(String name) {
            this.name = name;
        }
    }

    private static class AuthoritySyncStats {
        String name;
        long elapsedTime;
        int times;
        Map<String, AccountSyncStats> accountMap = Maps.newHashMap();

        private AuthoritySyncStats(String name) {
            this.name = name;
        }
    }

    class ActiveSyncContext
    extends ISyncContext.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final SyncOperation mSyncOperation;
        final long mHistoryRowId;
        ISyncAdapter mSyncAdapter;
        final long mStartTime;
        long mTimeoutStartTime;
        boolean mBound;
        final PowerManager.WakeLock mSyncWakeLock;
        final int mSyncAdapterUid;
        SyncInfo mSyncInfo;
        boolean mIsLinkedToDeath = false;
        String mEventName;
        long mBytesTransferredAtLastPoll;
        long mLastPolledTimeElapsed;

        public ActiveSyncContext(SyncOperation syncOperation, long historyRowId, int syncAdapterUid) {
            this.mSyncAdapterUid = syncAdapterUid;
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = historyRowId;
            this.mSyncAdapter = null;
            this.mTimeoutStartTime = this.mStartTime = SystemClock.elapsedRealtime();
            this.mSyncWakeLock = SyncManager.this.mSyncHandler.getSyncWakeLock(this.mSyncOperation);
            this.mSyncWakeLock.setWorkSource(new WorkSource(syncAdapterUid));
            this.mSyncWakeLock.acquire();
        }

        @Override
        public void sendHeartbeat() {
        }

        @Override
        public void onFinished(SyncResult result) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Slog.v(SyncManager.TAG, "onFinished: " + this);
            }
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, result);
        }

        public void toString(StringBuilder sb) {
            sb.append("startTime ").append(this.mStartTime).append(", mTimeoutStartTime ").append(this.mTimeoutStartTime).append(", mHistoryRowId ").append(this.mHistoryRowId).append(", syncOperation ").append(this.mSyncOperation);
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 4;
            msg.obj = new ServiceConnectionData(this, service);
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 5;
            msg.obj = new ServiceConnectionData(this, null);
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        boolean bindToSyncAdapter(ComponentName serviceComponent, int userId) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "bindToSyncAdapter: " + serviceComponent + ", connection " + this);
            }
            Intent intent = new Intent();
            intent.setAction("android.content.SyncAdapter");
            intent.setComponent(serviceComponent);
            intent.putExtra("android.intent.extra.client_label", 17040859);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivityAsUser(SyncManager.this.mContext, 0, new Intent("android.settings.SYNC_SETTINGS"), 0, null, new UserHandle(userId)));
            this.mBound = true;
            boolean bindResult = SyncManager.this.mContext.bindServiceAsUser(intent, this, 21, new UserHandle(this.mSyncOperation.target.userId));
            if (!bindResult) {
                this.mBound = false;
            } else {
                try {
                    this.mEventName = this.mSyncOperation.wakeLockName();
                    SyncManager.this.mBatteryStats.noteSyncStart(this.mEventName, this.mSyncAdapterUid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            return bindResult;
        }

        protected void close() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "unBindFromSyncAdapter: connection " + this);
            }
            if (this.mBound) {
                this.mBound = false;
                SyncManager.this.mContext.unbindService(this);
                try {
                    SyncManager.this.mBatteryStats.noteSyncFinish(this.mEventName, this.mSyncAdapterUid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSyncWakeLock.release();
            this.mSyncWakeLock.setWorkSource(null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        @Override
        public void binderDied() {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, null);
        }
    }

    private static class ScheduleSyncMessagePayload {
        final SyncOperation syncOperation;
        final long minDelayMillis;

        ScheduleSyncMessagePayload(SyncOperation syncOperation, long minDelayMillis) {
            this.syncOperation = syncOperation;
            this.minDelayMillis = minDelayMillis;
        }
    }

    private class UpdatePeriodicSyncMessagePayload {
        public final SyncStorageEngine.EndPoint target;
        public final long pollFrequency;
        public final long flex;
        public final Bundle extras;

        UpdatePeriodicSyncMessagePayload(SyncStorageEngine.EndPoint target, long pollFrequency, long flex, Bundle extras) {
            this.target = target;
            this.pollFrequency = pollFrequency;
            this.flex = flex;
            this.extras = extras;
        }
    }

    private class SyncFinishedOrCancelledMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        SyncFinishedOrCancelledMessagePayload(ActiveSyncContext syncContext, SyncResult syncResult) {
            this.activeSyncContext = syncContext;
            this.syncResult = syncResult;
        }
    }
}

