/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.hardware.display.WifiDisplay;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.display.DisplayDevice;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import libcore.io.IoUtils;
import libcore.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class PersistentDataStore {
    static final String TAG = "DisplayManager";
    private ArrayList<WifiDisplay> mRememberedWifiDisplays = new ArrayList();
    private final HashMap<String, DisplayState> mDisplayStates = new HashMap();
    private final AtomicFile mAtomicFile = new AtomicFile(new File("/data/system/display-manager-state.xml"));
    private boolean mLoaded;
    private boolean mDirty;

    public void saveIfNeeded() {
        if (this.mDirty) {
            this.save();
            this.mDirty = false;
        }
    }

    public WifiDisplay getRememberedWifiDisplay(String deviceAddress) {
        this.loadIfNeeded();
        int index = this.findRememberedWifiDisplay(deviceAddress);
        if (index >= 0) {
            return this.mRememberedWifiDisplays.get(index);
        }
        return null;
    }

    public WifiDisplay[] getRememberedWifiDisplays() {
        this.loadIfNeeded();
        return this.mRememberedWifiDisplays.toArray(new WifiDisplay[this.mRememberedWifiDisplays.size()]);
    }

    public WifiDisplay applyWifiDisplayAlias(WifiDisplay display) {
        if (display != null) {
            this.loadIfNeeded();
            String alias = null;
            int index = this.findRememberedWifiDisplay(display.getDeviceAddress());
            if (index >= 0) {
                alias = this.mRememberedWifiDisplays.get(index).getDeviceAlias();
            }
            if (!Objects.equal(display.getDeviceAlias(), alias)) {
                return new WifiDisplay(display.getDeviceAddress(), display.getDeviceName(), alias, display.isAvailable(), display.canConnect(), display.isRemembered());
            }
        }
        return display;
    }

    public WifiDisplay[] applyWifiDisplayAliases(WifiDisplay[] displays) {
        WifiDisplay[] results = displays;
        if (results != null) {
            int count = displays.length;
            for (int i = 0; i < count; ++i) {
                WifiDisplay result = this.applyWifiDisplayAlias(displays[i]);
                if (result == displays[i]) continue;
                if (results == displays) {
                    results = new WifiDisplay[count];
                    System.arraycopy(displays, 0, results, 0, count);
                }
                results[i] = result;
            }
        }
        return results;
    }

    public boolean rememberWifiDisplay(WifiDisplay display) {
        this.loadIfNeeded();
        int index = this.findRememberedWifiDisplay(display.getDeviceAddress());
        if (index >= 0) {
            WifiDisplay other = this.mRememberedWifiDisplays.get(index);
            if (other.equals(display)) {
                return false;
            }
            this.mRememberedWifiDisplays.set(index, display);
        } else {
            this.mRememberedWifiDisplays.add(display);
        }
        this.setDirty();
        return true;
    }

    public boolean forgetWifiDisplay(String deviceAddress) {
        int index = this.findRememberedWifiDisplay(deviceAddress);
        if (index >= 0) {
            this.mRememberedWifiDisplays.remove(index);
            this.setDirty();
            return true;
        }
        return false;
    }

    private int findRememberedWifiDisplay(String deviceAddress) {
        int count = this.mRememberedWifiDisplays.size();
        for (int i = 0; i < count; ++i) {
            if (!this.mRememberedWifiDisplays.get(i).getDeviceAddress().equals(deviceAddress)) continue;
            return i;
        }
        return -1;
    }

    public int getColorMode(DisplayDevice device) {
        if (!device.hasStableUniqueId()) {
            return -1;
        }
        DisplayState state = this.getDisplayState(device.getUniqueId(), false);
        if (state == null) {
            return -1;
        }
        return state.getColorMode();
    }

    public boolean setColorMode(DisplayDevice device, int colorMode) {
        if (!device.hasStableUniqueId()) {
            return false;
        }
        DisplayState state = this.getDisplayState(device.getUniqueId(), true);
        if (state.setColorMode(colorMode)) {
            this.setDirty();
            return true;
        }
        return false;
    }

    private DisplayState getDisplayState(String uniqueId, boolean createIfAbsent) {
        this.loadIfNeeded();
        DisplayState state = this.mDisplayStates.get(uniqueId);
        if (state == null && createIfAbsent) {
            state = new DisplayState();
            this.mDisplayStates.put(uniqueId, state);
            this.setDirty();
        }
        return state;
    }

    public void loadIfNeeded() {
        if (!this.mLoaded) {
            this.load();
            this.mLoaded = true;
        }
    }

    private void setDirty() {
        this.mDirty = true;
    }

    private void clearState() {
        this.mRememberedWifiDisplays.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        FileInputStream is;
        this.clearState();
        try {
            is = this.mAtomicFile.openRead();
        }
        catch (FileNotFoundException ex) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new BufferedInputStream(is), StandardCharsets.UTF_8.name());
            this.loadFromXml(parser);
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to load display manager persistent store data.", ex);
            this.clearState();
        }
        catch (XmlPullParserException ex) {
            Slog.w(TAG, "Failed to load display manager persistent store data.", ex);
            this.clearState();
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        try {
            FileOutputStream os = this.mAtomicFile.startWrite();
            boolean success = false;
            try {
                FastXmlSerializer serializer = new FastXmlSerializer();
                serializer.setOutput(new BufferedOutputStream(os), StandardCharsets.UTF_8.name());
                this.saveToXml(serializer);
                serializer.flush();
                success = true;
            }
            finally {
                if (success) {
                    this.mAtomicFile.finishWrite(os);
                } else {
                    this.mAtomicFile.failWrite(os);
                }
            }
        }
        catch (IOException ex) {
            Slog.w(TAG, "Failed to save display manager persistent store data.", ex);
        }
    }

    private void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        XmlUtils.beginDocument(parser, "display-manager-state");
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (parser.getName().equals("remembered-wifi-displays")) {
                this.loadRememberedWifiDisplaysFromXml(parser);
            }
            if (!parser.getName().equals("display-states")) continue;
            this.loadDisplaysFromXml(parser);
        }
    }

    private void loadRememberedWifiDisplaysFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals("wifi-display")) continue;
            String deviceAddress = parser.getAttributeValue(null, "deviceAddress");
            String deviceName = parser.getAttributeValue(null, "deviceName");
            String deviceAlias = parser.getAttributeValue(null, "deviceAlias");
            if (deviceAddress == null || deviceName == null) {
                throw new XmlPullParserException("Missing deviceAddress or deviceName attribute on wifi-display.");
            }
            if (this.findRememberedWifiDisplay(deviceAddress) >= 0) {
                throw new XmlPullParserException("Found duplicate wifi display device address.");
            }
            this.mRememberedWifiDisplays.add(new WifiDisplay(deviceAddress, deviceName, deviceAlias, false, false, false));
        }
    }

    private void loadDisplaysFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (!parser.getName().equals("display")) continue;
            String uniqueId = parser.getAttributeValue(null, "unique-id");
            if (uniqueId == null) {
                throw new XmlPullParserException("Missing unique-id attribute on display.");
            }
            if (this.mDisplayStates.containsKey(uniqueId)) {
                throw new XmlPullParserException("Found duplicate display.");
            }
            DisplayState state = new DisplayState();
            state.loadFromXml(parser);
            this.mDisplayStates.put(uniqueId, state);
        }
    }

    private void saveToXml(XmlSerializer serializer) throws IOException {
        serializer.startDocument(null, true);
        serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        serializer.startTag(null, "display-manager-state");
        serializer.startTag(null, "remembered-wifi-displays");
        for (WifiDisplay wifiDisplay : this.mRememberedWifiDisplays) {
            serializer.startTag(null, "wifi-display");
            serializer.attribute(null, "deviceAddress", wifiDisplay.getDeviceAddress());
            serializer.attribute(null, "deviceName", wifiDisplay.getDeviceName());
            if (wifiDisplay.getDeviceAlias() != null) {
                serializer.attribute(null, "deviceAlias", wifiDisplay.getDeviceAlias());
            }
            serializer.endTag(null, "wifi-display");
        }
        serializer.endTag(null, "remembered-wifi-displays");
        serializer.startTag(null, "display-states");
        for (Map.Entry entry : this.mDisplayStates.entrySet()) {
            String uniqueId = (String)entry.getKey();
            DisplayState state = (DisplayState)entry.getValue();
            serializer.startTag(null, "display");
            serializer.attribute(null, "unique-id", uniqueId);
            state.saveToXml(serializer);
            serializer.endTag(null, "display");
        }
        serializer.endTag(null, "display-states");
        serializer.endTag(null, "display-manager-state");
        serializer.endDocument();
    }

    public void dump(PrintWriter pw) {
        pw.println("PersistentDataStore");
        pw.println("  mLoaded=" + this.mLoaded);
        pw.println("  mDirty=" + this.mDirty);
        pw.println("  RememberedWifiDisplays:");
        int i = 0;
        for (WifiDisplay wifiDisplay : this.mRememberedWifiDisplays) {
            pw.println("    " + i++ + ": " + wifiDisplay);
        }
        pw.println("  DisplayStates:");
        i = 0;
        for (Map.Entry entry : this.mDisplayStates.entrySet()) {
            pw.println("    " + i++ + ": " + (String)entry.getKey());
            ((DisplayState)entry.getValue()).dump(pw, "      ");
        }
    }

    private static final class DisplayState {
        private int mColorMode;

        private DisplayState() {
        }

        public boolean setColorMode(int colorMode) {
            if (colorMode == this.mColorMode) {
                return false;
            }
            this.mColorMode = colorMode;
            return true;
        }

        public int getColorMode() {
            return this.mColorMode;
        }

        public void loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if (!parser.getName().equals("color-mode")) continue;
                String value = parser.nextText();
                this.mColorMode = Integer.parseInt(value);
            }
        }

        public void saveToXml(XmlSerializer serializer) throws IOException {
            serializer.startTag(null, "color-mode");
            serializer.text(Integer.toString(this.mColorMode));
            serializer.endTag(null, "color-mode");
        }

        private void dump(PrintWriter pw, String prefix) {
            pw.println(prefix + "ColorMode=" + this.mColorMode);
        }
    }
}

