/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.content.Context;
import android.hardware.biometrics.fingerprint.V2_1.IBiometricsFingerprint;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.fingerprint.ClientMonitor;
import com.android.server.fingerprint.FingerprintUtils;

public abstract class AuthenticationClient
extends ClientMonitor {
    private long mOpId;
    public static final int LOCKOUT_NONE = 0;
    public static final int LOCKOUT_TIMED = 1;
    public static final int LOCKOUT_PERMANENT = 2;

    public abstract int handleFailedAttempt();

    public abstract void resetFailedAttempts();

    public AuthenticationClient(Context context, long halDeviceId, IBinder token, IFingerprintServiceReceiver receiver, int targetUserId, int groupId, long opId, boolean restricted, String owner) {
        super(context, halDeviceId, token, receiver, targetUserId, groupId, restricted, owner);
        this.mOpId = opId;
    }

    @Override
    public boolean onAuthenticated(int fingerId, int groupId) {
        IFingerprintServiceReceiver receiver;
        boolean authenticated;
        boolean result;
        block12: {
            result = false;
            authenticated = fingerId != 0;
            receiver = this.getReceiver();
            if (receiver != null) {
                try {
                    MetricsLogger.action(this.getContext(), 252, authenticated);
                    if (!authenticated) {
                        receiver.onAuthenticationFailed(this.getHalDeviceId());
                        break block12;
                    }
                    Slog.v("FingerprintService", "onAuthenticated(owner=" + this.getOwnerString() + ", id=" + fingerId + ", gp=" + groupId + ")");
                    Fingerprint fp = !this.getIsRestricted() ? new Fingerprint("", groupId, fingerId, this.getHalDeviceId()) : null;
                    receiver.onAuthenticationSucceeded(this.getHalDeviceId(), fp, this.getTargetUserId());
                }
                catch (RemoteException e) {
                    Slog.w("FingerprintService", "Failed to notify Authenticated:", e);
                    result = true;
                }
            } else {
                result = true;
            }
        }
        if (!authenticated) {
            int lockoutMode;
            if (receiver != null) {
                FingerprintUtils.vibrateFingerprintError(this.getContext());
            }
            if ((lockoutMode = this.handleFailedAttempt()) != 0) {
                try {
                    Slog.w("FingerprintService", "Forcing lockout (fp driver code should do this!), mode(" + lockoutMode + ")");
                    this.stop(false);
                    int errorCode = lockoutMode == 1 ? 7 : 9;
                    receiver.onError(this.getHalDeviceId(), errorCode, 0);
                }
                catch (RemoteException e) {
                    Slog.w("FingerprintService", "Failed to notify lockout:", e);
                }
            }
            result |= lockoutMode != 0;
        } else {
            if (receiver != null) {
                FingerprintUtils.vibrateFingerprintSuccess(this.getContext());
            }
            result |= true;
            this.resetFailedAttempts();
        }
        return result;
    }

    @Override
    public int start() {
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "start authentication: no fingerprint HAL!");
            return 3;
        }
        try {
            int result = daemon.authenticate(this.mOpId, this.getGroupId());
            if (result != 0) {
                Slog.w("FingerprintService", "startAuthentication failed, result=" + result);
                MetricsLogger.histogram(this.getContext(), "fingeprintd_auth_start_error", result);
                this.onError(1, 0);
                return result;
            }
            Slog.w("FingerprintService", "client " + this.getOwnerString() + " is authenticating...");
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "startAuthentication failed", e);
            return 3;
        }
        return 0;
    }

    @Override
    public int stop(boolean initiatedByClient) {
        if (this.mAlreadyCancelled) {
            Slog.w("FingerprintService", "stopAuthentication: already cancelled!");
            return 0;
        }
        IBiometricsFingerprint daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w("FingerprintService", "stopAuthentication: no fingerprint HAL!");
            return 3;
        }
        try {
            int result = daemon.cancel();
            if (result != 0) {
                Slog.w("FingerprintService", "stopAuthentication failed, result=" + result);
                return result;
            }
            Slog.w("FingerprintService", "client " + this.getOwnerString() + " is no longer authenticating");
        }
        catch (RemoteException e) {
            Slog.e("FingerprintService", "stopAuthentication failed", e);
            return 3;
        }
        this.mAlreadyCancelled = true;
        return 0;
    }

    @Override
    public boolean onEnrollResult(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onEnrollResult() called for authenticate!");
        return true;
    }

    @Override
    public boolean onRemoved(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onRemoved() called for authenticate!");
        return true;
    }

    @Override
    public boolean onEnumerationResult(int fingerId, int groupId, int remaining) {
        Slog.w("FingerprintService", "onEnumerationResult() called for authenticate!");
        return true;
    }
}

