/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.job.JobInfo;
import android.app.job.JobWorkItem;
import android.content.ClipData;
import android.content.ComponentName;
import android.net.Uri;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.server.job.GrantedUriPermissions;
import com.android.server.job.controllers.ContentObserverController;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public final class JobStatus {
    static final String TAG = "JobSchedulerService";
    public static final long NO_LATEST_RUNTIME = Long.MAX_VALUE;
    public static final long NO_EARLIEST_RUNTIME = 0L;
    static final int CONSTRAINT_CHARGING = 1;
    static final int CONSTRAINT_IDLE = 4;
    static final int CONSTRAINT_BATTERY_NOT_LOW = 2;
    static final int CONSTRAINT_STORAGE_NOT_LOW = 8;
    static final int CONSTRAINT_TIMING_DELAY = Integer.MIN_VALUE;
    static final int CONSTRAINT_DEADLINE = 0x40000000;
    static final int CONSTRAINT_UNMETERED = 0x20000000;
    static final int CONSTRAINT_CONNECTIVITY = 0x10000000;
    static final int CONSTRAINT_APP_NOT_IDLE = 0x8000000;
    static final int CONSTRAINT_CONTENT_TRIGGER = 0x4000000;
    static final int CONSTRAINT_DEVICE_NOT_DOZING = 0x2000000;
    static final int CONSTRAINT_NOT_ROAMING = 0x1000000;
    static final int CONSTRAINT_METERED = 0x800000;
    static final int CONNECTIVITY_MASK = 830472192;
    public static final int OVERRIDE_SOFT = 1;
    public static final int OVERRIDE_FULL = 2;
    public static final long DEFAULT_TRIGGER_UPDATE_DELAY = 10000L;
    public static final long MIN_TRIGGER_UPDATE_DELAY = 500L;
    public static final long DEFAULT_TRIGGER_MAX_DELAY = 120000L;
    public static final long MIN_TRIGGER_MAX_DELAY = 1000L;
    final JobInfo job;
    final int callingUid;
    final String batteryName;
    final String sourcePackageName;
    final int sourceUserId;
    final int sourceUid;
    final String sourceTag;
    final String tag;
    private GrantedUriPermissions uriPerms;
    private boolean prepared;
    static final boolean DEBUG_PREPARE = true;
    private Throwable unpreparedPoint = null;
    private final long earliestRunTimeElapsedMillis;
    private final long latestRunTimeElapsedMillis;
    private final int numFailures;
    final int requiredConstraints;
    int satisfiedConstraints = 0;
    public boolean dozeWhitelisted;
    public static final int TRACKING_BATTERY = 1;
    public static final int TRACKING_CONNECTIVITY = 2;
    public static final int TRACKING_CONTENT = 4;
    public static final int TRACKING_IDLE = 8;
    public static final int TRACKING_STORAGE = 16;
    public static final int TRACKING_TIME = 32;
    private int trackingControllers;
    public ArraySet<Uri> changedUris;
    public ArraySet<String> changedAuthorities;
    public int lastEvaluatedPriority;
    public ArrayList<JobWorkItem> pendingWork;
    public ArrayList<JobWorkItem> executingWork;
    public int nextPendingWorkId = 1;
    public int overrideState = 0;
    public long enqueueTime;
    public long madePending;
    public long madeActive;
    ContentObserverController.JobInstance contentObserverJobInstance;
    static final int CONSTRAINTS_OF_INTEREST = -1249902577;
    static final int SOFT_OVERRIDE_CONSTRAINTS = -2147483633;

    public int getServiceToken() {
        return this.callingUid;
    }

    private JobStatus(JobInfo job, int callingUid, String sourcePackageName, int sourceUserId, String tag, int numFailures, long earliestRunTimeElapsedMillis, long latestRunTimeElapsedMillis) {
        this.job = job;
        this.callingUid = callingUid;
        int tempSourceUid = -1;
        if (sourceUserId != -1 && sourcePackageName != null) {
            try {
                tempSourceUid = AppGlobals.getPackageManager().getPackageUid(sourcePackageName, 0, sourceUserId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (tempSourceUid == -1) {
            this.sourceUid = callingUid;
            this.sourceUserId = UserHandle.getUserId(callingUid);
            this.sourcePackageName = job.getService().getPackageName();
            this.sourceTag = null;
        } else {
            this.sourceUid = tempSourceUid;
            this.sourceUserId = sourceUserId;
            this.sourcePackageName = sourcePackageName;
            this.sourceTag = tag;
        }
        this.batteryName = this.sourceTag != null ? this.sourceTag + ":" + job.getService().getPackageName() : job.getService().flattenToShortString();
        this.tag = "*job*/" + this.batteryName;
        this.earliestRunTimeElapsedMillis = earliestRunTimeElapsedMillis;
        this.latestRunTimeElapsedMillis = latestRunTimeElapsedMillis;
        this.numFailures = numFailures;
        int requiredConstraints = job.getConstraintFlags();
        switch (job.getNetworkType()) {
            case 0: {
                break;
            }
            case 1: {
                requiredConstraints |= 0x10000000;
                break;
            }
            case 2: {
                requiredConstraints |= 0x20000000;
                break;
            }
            case 3: {
                requiredConstraints |= 0x1000000;
                break;
            }
            case 4: {
                requiredConstraints |= 0x800000;
                break;
            }
            default: {
                Slog.w(TAG, "Unrecognized networking constraint " + job.getNetworkType());
            }
        }
        if (earliestRunTimeElapsedMillis != 0L) {
            requiredConstraints |= Integer.MIN_VALUE;
        }
        if (latestRunTimeElapsedMillis != Long.MAX_VALUE) {
            requiredConstraints |= 0x40000000;
        }
        if (job.getTriggerContentUris() != null) {
            requiredConstraints |= 0x4000000;
        }
        this.requiredConstraints = requiredConstraints;
    }

    public JobStatus(JobStatus jobStatus) {
        this(jobStatus.getJob(), jobStatus.getUid(), jobStatus.getSourcePackageName(), jobStatus.getSourceUserId(), jobStatus.getSourceTag(), jobStatus.getNumFailures(), jobStatus.getEarliestRunTime(), jobStatus.getLatestRunTimeElapsed());
    }

    public JobStatus(JobInfo job, int callingUid, String sourcePackageName, int sourceUserId, String sourceTag, long earliestRunTimeElapsedMillis, long latestRunTimeElapsedMillis) {
        this(job, callingUid, sourcePackageName, sourceUserId, sourceTag, 0, earliestRunTimeElapsedMillis, latestRunTimeElapsedMillis);
    }

    public JobStatus(JobStatus rescheduling, long newEarliestRuntimeElapsedMillis, long newLatestRuntimeElapsedMillis, int backoffAttempt) {
        this(rescheduling.job, rescheduling.getUid(), rescheduling.getSourcePackageName(), rescheduling.getSourceUserId(), rescheduling.getSourceTag(), backoffAttempt, newEarliestRuntimeElapsedMillis, newLatestRuntimeElapsedMillis);
    }

    public static JobStatus createFromJobInfo(JobInfo job, int callingUid, String sourcePackageName, int sourceUserId, String tag) {
        long earliestRunTimeElapsedMillis;
        long latestRunTimeElapsedMillis;
        long elapsedNow = SystemClock.elapsedRealtime();
        if (job.isPeriodic()) {
            latestRunTimeElapsedMillis = elapsedNow + job.getIntervalMillis();
            earliestRunTimeElapsedMillis = latestRunTimeElapsedMillis - job.getFlexMillis();
        } else {
            earliestRunTimeElapsedMillis = job.hasEarlyConstraint() ? elapsedNow + job.getMinLatencyMillis() : 0L;
            latestRunTimeElapsedMillis = job.hasLateConstraint() ? elapsedNow + job.getMaxExecutionDelayMillis() : Long.MAX_VALUE;
        }
        return new JobStatus(job, callingUid, sourcePackageName, sourceUserId, tag, 0, earliestRunTimeElapsedMillis, latestRunTimeElapsedMillis);
    }

    public void enqueueWorkLocked(IActivityManager am, JobWorkItem work) {
        if (this.pendingWork == null) {
            this.pendingWork = new ArrayList();
        }
        work.setWorkId(this.nextPendingWorkId);
        ++this.nextPendingWorkId;
        if (work.getIntent() != null && GrantedUriPermissions.checkGrantFlags(work.getIntent().getFlags())) {
            work.setGrants(GrantedUriPermissions.createFromIntent(am, work.getIntent(), this.sourceUid, this.sourcePackageName, this.sourceUserId, this.toShortString()));
        }
        this.pendingWork.add(work);
    }

    public JobWorkItem dequeueWorkLocked() {
        if (this.pendingWork != null && this.pendingWork.size() > 0) {
            JobWorkItem work = this.pendingWork.remove(0);
            if (work != null) {
                if (this.executingWork == null) {
                    this.executingWork = new ArrayList();
                }
                this.executingWork.add(work);
                work.bumpDeliveryCount();
            }
            return work;
        }
        return null;
    }

    public boolean hasWorkLocked() {
        return this.pendingWork != null && this.pendingWork.size() > 0 || this.hasExecutingWorkLocked();
    }

    public boolean hasExecutingWorkLocked() {
        return this.executingWork != null && this.executingWork.size() > 0;
    }

    private static void ungrantWorkItem(IActivityManager am, JobWorkItem work) {
        if (work.getGrants() != null) {
            ((GrantedUriPermissions)work.getGrants()).revoke(am);
        }
    }

    public boolean completeWorkLocked(IActivityManager am, int workId) {
        if (this.executingWork != null) {
            int N = this.executingWork.size();
            for (int i = 0; i < N; ++i) {
                JobWorkItem work = this.executingWork.get(i);
                if (work.getWorkId() != workId) continue;
                this.executingWork.remove(i);
                JobStatus.ungrantWorkItem(am, work);
                return true;
            }
        }
        return false;
    }

    private static void ungrantWorkList(IActivityManager am, ArrayList<JobWorkItem> list) {
        if (list != null) {
            int N = list.size();
            for (int i = 0; i < N; ++i) {
                JobStatus.ungrantWorkItem(am, list.get(i));
            }
        }
    }

    public void stopTrackingJobLocked(IActivityManager am, JobStatus incomingJob) {
        if (incomingJob != null) {
            if (this.executingWork != null && this.executingWork.size() > 0) {
                incomingJob.pendingWork = this.executingWork;
            }
            if (incomingJob.pendingWork == null) {
                incomingJob.pendingWork = this.pendingWork;
            } else if (this.pendingWork != null && this.pendingWork.size() > 0) {
                incomingJob.pendingWork.addAll(this.pendingWork);
            }
            this.pendingWork = null;
            this.executingWork = null;
            incomingJob.nextPendingWorkId = this.nextPendingWorkId;
        } else {
            JobStatus.ungrantWorkList(am, this.pendingWork);
            this.pendingWork = null;
            JobStatus.ungrantWorkList(am, this.executingWork);
            this.executingWork = null;
        }
    }

    public void prepareLocked(IActivityManager am) {
        if (this.prepared) {
            Slog.wtf(TAG, "Already prepared: " + this);
            return;
        }
        this.prepared = true;
        this.unpreparedPoint = null;
        ClipData clip = this.job.getClipData();
        if (clip != null) {
            this.uriPerms = GrantedUriPermissions.createFromClip(am, clip, this.sourceUid, this.sourcePackageName, this.sourceUserId, this.job.getClipGrantFlags(), this.toShortString());
        }
    }

    public void unprepareLocked(IActivityManager am) {
        if (!this.prepared) {
            Slog.wtf(TAG, "Hasn't been prepared: " + this);
            if (this.unpreparedPoint != null) {
                Slog.e(TAG, "Was already unprepared at ", this.unpreparedPoint);
            }
            return;
        }
        this.prepared = false;
        this.unpreparedPoint = new Throwable().fillInStackTrace();
        if (this.uriPerms != null) {
            this.uriPerms.revoke(am);
            this.uriPerms = null;
        }
    }

    public boolean isPreparedLocked() {
        return this.prepared;
    }

    public JobInfo getJob() {
        return this.job;
    }

    public int getJobId() {
        return this.job.getId();
    }

    public void printUniqueId(PrintWriter pw) {
        UserHandle.formatUid(pw, this.callingUid);
        pw.print("/");
        pw.print(this.job.getId());
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public ComponentName getServiceComponent() {
        return this.job.getService();
    }

    public String getSourcePackageName() {
        return this.sourcePackageName;
    }

    public int getSourceUid() {
        return this.sourceUid;
    }

    public int getSourceUserId() {
        return this.sourceUserId;
    }

    public int getUserId() {
        return UserHandle.getUserId(this.callingUid);
    }

    public String getSourceTag() {
        return this.sourceTag;
    }

    public int getUid() {
        return this.callingUid;
    }

    public String getBatteryName() {
        return this.batteryName;
    }

    public String getTag() {
        return this.tag;
    }

    public int getPriority() {
        return this.job.getPriority();
    }

    public int getFlags() {
        return this.job.getFlags();
    }

    public boolean hasConnectivityConstraint() {
        return (this.requiredConstraints & 0x31800000) != 0;
    }

    public boolean needsAnyConnectivity() {
        return (this.requiredConstraints & 0x10000000) != 0;
    }

    public boolean needsUnmeteredConnectivity() {
        return (this.requiredConstraints & 0x20000000) != 0;
    }

    public boolean needsMeteredConnectivity() {
        return (this.requiredConstraints & 0x800000) != 0;
    }

    public boolean needsNonRoamingConnectivity() {
        return (this.requiredConstraints & 0x1000000) != 0;
    }

    public boolean hasChargingConstraint() {
        return (this.requiredConstraints & 1) != 0;
    }

    public boolean hasBatteryNotLowConstraint() {
        return (this.requiredConstraints & 2) != 0;
    }

    public boolean hasPowerConstraint() {
        return (this.requiredConstraints & 3) != 0;
    }

    public boolean hasStorageNotLowConstraint() {
        return (this.requiredConstraints & 8) != 0;
    }

    public boolean hasTimingDelayConstraint() {
        return (this.requiredConstraints & Integer.MIN_VALUE) != 0;
    }

    public boolean hasDeadlineConstraint() {
        return (this.requiredConstraints & 0x40000000) != 0;
    }

    public boolean hasIdleConstraint() {
        return (this.requiredConstraints & 4) != 0;
    }

    public boolean hasContentTriggerConstraint() {
        return (this.requiredConstraints & 0x4000000) != 0;
    }

    public long getTriggerContentUpdateDelay() {
        long time = this.job.getTriggerContentUpdateDelay();
        if (time < 0L) {
            return 10000L;
        }
        return Math.max(time, 500L);
    }

    public long getTriggerContentMaxDelay() {
        long time = this.job.getTriggerContentMaxDelay();
        if (time < 0L) {
            return 120000L;
        }
        return Math.max(time, 1000L);
    }

    public boolean isPersisted() {
        return this.job.isPersisted();
    }

    public long getEarliestRunTime() {
        return this.earliestRunTimeElapsedMillis;
    }

    public long getLatestRunTimeElapsed() {
        return this.latestRunTimeElapsedMillis;
    }

    boolean setChargingConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(1, state);
    }

    boolean setBatteryNotLowConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(2, state);
    }

    boolean setStorageNotLowConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(8, state);
    }

    boolean setTimingDelayConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(Integer.MIN_VALUE, state);
    }

    boolean setDeadlineConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x40000000, state);
    }

    boolean setIdleConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(4, state);
    }

    boolean setConnectivityConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x10000000, state);
    }

    boolean setUnmeteredConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x20000000, state);
    }

    boolean setMeteredConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x800000, state);
    }

    boolean setNotRoamingConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x1000000, state);
    }

    boolean setAppNotIdleConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x8000000, state);
    }

    boolean setContentTriggerConstraintSatisfied(boolean state) {
        return this.setConstraintSatisfied(0x4000000, state);
    }

    boolean setDeviceNotDozingConstraintSatisfied(boolean state, boolean whitelisted) {
        this.dozeWhitelisted = whitelisted;
        return this.setConstraintSatisfied(0x2000000, state);
    }

    boolean setConstraintSatisfied(int constraint, boolean state) {
        boolean old;
        boolean bl = old = (this.satisfiedConstraints & constraint) != 0;
        if (old == state) {
            return false;
        }
        this.satisfiedConstraints = this.satisfiedConstraints & ~constraint | (state ? constraint : 0);
        return true;
    }

    boolean isConstraintSatisfied(int constraint) {
        return (this.satisfiedConstraints & constraint) != 0;
    }

    boolean clearTrackingController(int which) {
        if ((this.trackingControllers & which) != 0) {
            this.trackingControllers &= ~which;
            return true;
        }
        return false;
    }

    void setTrackingController(int which) {
        this.trackingControllers |= which;
    }

    public boolean shouldDump(int filterUid) {
        return filterUid == -1 || UserHandle.getAppId(this.getUid()) == filterUid || UserHandle.getAppId(this.getSourceUid()) == filterUid;
    }

    public boolean isReady() {
        boolean deadlineSatisfied = !this.job.isPeriodic() && this.hasDeadlineConstraint() && (this.satisfiedConstraints & 0x40000000) != 0;
        boolean notIdle = (this.satisfiedConstraints & 0x8000000) != 0;
        boolean notDozing = (this.satisfiedConstraints & 0x2000000) != 0 || (this.job.getFlags() & 1) != 0;
        return (this.isConstraintsSatisfied() || deadlineSatisfied) && notIdle && notDozing;
    }

    public boolean isConstraintsSatisfied() {
        if (this.overrideState == 2) {
            return true;
        }
        int req = this.requiredConstraints & 0xB580000F;
        int sat = this.satisfiedConstraints & 0xB580000F;
        if (this.overrideState == 1) {
            sat |= this.requiredConstraints & 0x8000000F;
        }
        return (sat & req) == req;
    }

    public boolean matches(int uid, int jobId) {
        return this.job.getId() == jobId && this.callingUid == uid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("JobStatus{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" #");
        UserHandle.formatUid(sb, this.callingUid);
        sb.append("/");
        sb.append(this.job.getId());
        sb.append(' ');
        sb.append(this.batteryName);
        sb.append(" u=");
        sb.append(this.getUserId());
        sb.append(" s=");
        sb.append(this.getSourceUid());
        if (this.earliestRunTimeElapsedMillis != 0L || this.latestRunTimeElapsedMillis != Long.MAX_VALUE) {
            long now = SystemClock.elapsedRealtime();
            sb.append(" TIME=");
            this.formatRunTime(sb, this.earliestRunTimeElapsedMillis, 0L, now);
            sb.append(":");
            this.formatRunTime(sb, this.latestRunTimeElapsedMillis, Long.MAX_VALUE, now);
        }
        if (this.job.getNetworkType() != 0) {
            sb.append(" NET=");
            sb.append(this.job.getNetworkType());
        }
        if (this.job.isRequireCharging()) {
            sb.append(" CHARGING");
        }
        if (this.job.isRequireBatteryNotLow()) {
            sb.append(" BATNOTLOW");
        }
        if (this.job.isRequireStorageNotLow()) {
            sb.append(" STORENOTLOW");
        }
        if (this.job.isRequireDeviceIdle()) {
            sb.append(" IDLE");
        }
        if (this.job.isPersisted()) {
            sb.append(" PERSISTED");
        }
        if ((this.satisfiedConstraints & 0x8000000) == 0) {
            sb.append(" WAIT:APP_NOT_IDLE");
        }
        if ((this.satisfiedConstraints & 0x2000000) == 0) {
            sb.append(" WAIT:DEV_NOT_DOZING");
        }
        if (this.job.getTriggerContentUris() != null) {
            sb.append(" URIS=");
            sb.append(Arrays.toString(this.job.getTriggerContentUris()));
        }
        if (this.numFailures != 0) {
            sb.append(" failures=");
            sb.append(this.numFailures);
        }
        if (this.isReady()) {
            sb.append(" READY");
        }
        sb.append("}");
        return sb.toString();
    }

    private void formatRunTime(PrintWriter pw, long runtime, long defaultValue, long now) {
        if (runtime == defaultValue) {
            pw.print("none");
        } else {
            TimeUtils.formatDuration(runtime - now, pw);
        }
    }

    private void formatRunTime(StringBuilder sb, long runtime, long defaultValue, long now) {
        if (runtime == defaultValue) {
            sb.append("none");
        } else {
            TimeUtils.formatDuration(runtime - now, sb);
        }
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" #");
        UserHandle.formatUid(sb, this.callingUid);
        sb.append("/");
        sb.append(this.job.getId());
        sb.append(' ');
        sb.append(this.batteryName);
        return sb.toString();
    }

    public String toShortStringExceptUniqueId() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.batteryName);
        return sb.toString();
    }

    void dumpConstraints(PrintWriter pw, int constraints) {
        if ((constraints & 1) != 0) {
            pw.print(" CHARGING");
        }
        if ((constraints & 2) != 0) {
            pw.print(" BATTERY_NOT_LOW");
        }
        if ((constraints & 8) != 0) {
            pw.print(" STORAGE_NOT_LOW");
        }
        if ((constraints & Integer.MIN_VALUE) != 0) {
            pw.print(" TIMING_DELAY");
        }
        if ((constraints & 0x40000000) != 0) {
            pw.print(" DEADLINE");
        }
        if ((constraints & 4) != 0) {
            pw.print(" IDLE");
        }
        if ((constraints & 0x10000000) != 0) {
            pw.print(" CONNECTIVITY");
        }
        if ((constraints & 0x20000000) != 0) {
            pw.print(" UNMETERED");
        }
        if ((constraints & 0x1000000) != 0) {
            pw.print(" NOT_ROAMING");
        }
        if ((constraints & 0x800000) != 0) {
            pw.print(" METERED");
        }
        if ((constraints & 0x8000000) != 0) {
            pw.print(" APP_NOT_IDLE");
        }
        if ((constraints & 0x4000000) != 0) {
            pw.print(" CONTENT_TRIGGER");
        }
        if ((constraints & 0x2000000) != 0) {
            pw.print(" DEVICE_NOT_DOZING");
        }
    }

    private void dumpJobWorkItem(PrintWriter pw, String prefix, JobWorkItem work, int index) {
        pw.print(prefix);
        pw.print("  #");
        pw.print(index);
        pw.print(": #");
        pw.print(work.getWorkId());
        pw.print(" ");
        pw.print(work.getDeliveryCount());
        pw.print("x ");
        pw.println(work.getIntent());
        if (work.getGrants() != null) {
            pw.print(prefix);
            pw.println("  URI grants:");
            ((GrantedUriPermissions)work.getGrants()).dump(pw, prefix + "    ");
        }
    }

    public void dump(PrintWriter pw, String prefix, boolean full, long elapsedRealtimeMillis) {
        int i;
        pw.print(prefix);
        UserHandle.formatUid(pw, this.callingUid);
        pw.print(" tag=");
        pw.println(this.tag);
        pw.print(prefix);
        pw.print("Source: uid=");
        UserHandle.formatUid(pw, this.getSourceUid());
        pw.print(" user=");
        pw.print(this.getSourceUserId());
        pw.print(" pkg=");
        pw.println(this.getSourcePackageName());
        if (full) {
            pw.print(prefix);
            pw.println("JobInfo:");
            pw.print(prefix);
            pw.print("  Service: ");
            pw.println(this.job.getService().flattenToShortString());
            if (this.job.isPeriodic()) {
                pw.print(prefix);
                pw.print("  PERIODIC: interval=");
                TimeUtils.formatDuration(this.job.getIntervalMillis(), pw);
                pw.print(" flex=");
                TimeUtils.formatDuration(this.job.getFlexMillis(), pw);
                pw.println();
            }
            if (this.job.isPersisted()) {
                pw.print(prefix);
                pw.println("  PERSISTED");
            }
            if (this.job.getPriority() != 0) {
                pw.print(prefix);
                pw.print("  Priority: ");
                pw.println(this.job.getPriority());
            }
            if (this.job.getFlags() != 0) {
                pw.print(prefix);
                pw.print("  Flags: ");
                pw.println(Integer.toHexString(this.job.getFlags()));
            }
            pw.print(prefix);
            pw.print("  Requires: charging=");
            pw.print(this.job.isRequireCharging());
            pw.print(" batteryNotLow=");
            pw.print(this.job.isRequireBatteryNotLow());
            pw.print(" deviceIdle=");
            pw.println(this.job.isRequireDeviceIdle());
            if (this.job.getTriggerContentUris() != null) {
                pw.print(prefix);
                pw.println("  Trigger content URIs:");
                for (i = 0; i < this.job.getTriggerContentUris().length; ++i) {
                    JobInfo.TriggerContentUri trig = this.job.getTriggerContentUris()[i];
                    pw.print(prefix);
                    pw.print("    ");
                    pw.print(Integer.toHexString(trig.getFlags()));
                    pw.print(' ');
                    pw.println(trig.getUri());
                }
                if (this.job.getTriggerContentUpdateDelay() >= 0L) {
                    pw.print(prefix);
                    pw.print("  Trigger update delay: ");
                    TimeUtils.formatDuration(this.job.getTriggerContentUpdateDelay(), pw);
                    pw.println();
                }
                if (this.job.getTriggerContentMaxDelay() >= 0L) {
                    pw.print(prefix);
                    pw.print("  Trigger max delay: ");
                    TimeUtils.formatDuration(this.job.getTriggerContentMaxDelay(), pw);
                    pw.println();
                }
            }
            if (this.job.getExtras() != null && !this.job.getExtras().maybeIsEmpty()) {
                pw.print(prefix);
                pw.print("  Extras: ");
                pw.println(this.job.getExtras().toShortString());
            }
            if (this.job.getTransientExtras() != null && !this.job.getTransientExtras().maybeIsEmpty()) {
                pw.print(prefix);
                pw.print("  Transient extras: ");
                pw.println(this.job.getTransientExtras().toShortString());
            }
            if (this.job.getClipData() != null) {
                pw.print(prefix);
                pw.print("  Clip data: ");
                StringBuilder b = new StringBuilder(128);
                this.job.getClipData().toShortString(b);
                pw.println(b);
            }
            if (this.uriPerms != null) {
                pw.print(prefix);
                pw.println("  Granted URI permissions:");
                this.uriPerms.dump(pw, prefix + "  ");
            }
            if (this.job.getNetworkType() != 0) {
                pw.print(prefix);
                pw.print("  Network type: ");
                pw.println(this.job.getNetworkType());
            }
            if (this.job.getMinLatencyMillis() != 0L) {
                pw.print(prefix);
                pw.print("  Minimum latency: ");
                TimeUtils.formatDuration(this.job.getMinLatencyMillis(), pw);
                pw.println();
            }
            if (this.job.getMaxExecutionDelayMillis() != 0L) {
                pw.print(prefix);
                pw.print("  Max execution delay: ");
                TimeUtils.formatDuration(this.job.getMaxExecutionDelayMillis(), pw);
                pw.println();
            }
            pw.print(prefix);
            pw.print("  Backoff: policy=");
            pw.print(this.job.getBackoffPolicy());
            pw.print(" initial=");
            TimeUtils.formatDuration(this.job.getInitialBackoffMillis(), pw);
            pw.println();
            if (this.job.hasEarlyConstraint()) {
                pw.print(prefix);
                pw.println("  Has early constraint");
            }
            if (this.job.hasLateConstraint()) {
                pw.print(prefix);
                pw.println("  Has late constraint");
            }
        }
        pw.print(prefix);
        pw.print("Required constraints:");
        this.dumpConstraints(pw, this.requiredConstraints);
        pw.println();
        if (full) {
            pw.print(prefix);
            pw.print("Satisfied constraints:");
            this.dumpConstraints(pw, this.satisfiedConstraints);
            pw.println();
            pw.print(prefix);
            pw.print("Unsatisfied constraints:");
            this.dumpConstraints(pw, this.requiredConstraints & ~this.satisfiedConstraints);
            pw.println();
            if (this.dozeWhitelisted) {
                pw.print(prefix);
                pw.println("Doze whitelisted: true");
            }
        }
        if (this.trackingControllers != 0) {
            pw.print(prefix);
            pw.print("Tracking:");
            if ((this.trackingControllers & 1) != 0) {
                pw.print(" BATTERY");
            }
            if ((this.trackingControllers & 2) != 0) {
                pw.print(" CONNECTIVITY");
            }
            if ((this.trackingControllers & 4) != 0) {
                pw.print(" CONTENT");
            }
            if ((this.trackingControllers & 8) != 0) {
                pw.print(" IDLE");
            }
            if ((this.trackingControllers & 0x10) != 0) {
                pw.print(" STORAGE");
            }
            if ((this.trackingControllers & 0x20) != 0) {
                pw.print(" TIME");
            }
            pw.println();
        }
        if (this.changedAuthorities != null) {
            pw.print(prefix);
            pw.println("Changed authorities:");
            for (i = 0; i < this.changedAuthorities.size(); ++i) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(this.changedAuthorities.valueAt(i));
            }
            if (this.changedUris != null) {
                pw.print(prefix);
                pw.println("Changed URIs:");
                for (i = 0; i < this.changedUris.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(this.changedUris.valueAt(i));
                }
            }
        }
        if (this.pendingWork != null && this.pendingWork.size() > 0) {
            pw.print(prefix);
            pw.println("Pending work:");
            for (i = 0; i < this.pendingWork.size(); ++i) {
                this.dumpJobWorkItem(pw, prefix, this.pendingWork.get(i), i);
            }
        }
        if (this.executingWork != null && this.executingWork.size() > 0) {
            pw.print(prefix);
            pw.println("Executing work:");
            for (i = 0; i < this.executingWork.size(); ++i) {
                this.dumpJobWorkItem(pw, prefix, this.executingWork.get(i), i);
            }
        }
        pw.print(prefix);
        pw.print("Enqueue time: ");
        TimeUtils.formatDuration(this.enqueueTime, elapsedRealtimeMillis, pw);
        pw.println();
        pw.print(prefix);
        pw.print("Run time: earliest=");
        this.formatRunTime(pw, this.earliestRunTimeElapsedMillis, 0L, elapsedRealtimeMillis);
        pw.print(", latest=");
        this.formatRunTime(pw, this.latestRunTimeElapsedMillis, Long.MAX_VALUE, elapsedRealtimeMillis);
        pw.println();
        if (this.numFailures != 0) {
            pw.print(prefix);
            pw.print("Num failures: ");
            pw.println(this.numFailures);
        }
    }
}

