/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.Context;
import android.media.AudioPlaybackConfiguration;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.IntArray;
import android.util.Log;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class AudioPlaybackMonitor
extends IPlaybackConfigDispatcher.Stub {
    private static boolean DEBUG = MediaSessionService.DEBUG;
    private static String TAG = "AudioPlaybackMonitor";
    private final Object mLock = new Object();
    private final Context mContext;
    private final OnAudioPlaybackStartedListener mListener;
    private Set<Integer> mActiveAudioPlaybackPlayerInterfaceIds = new HashSet<Integer>();
    private Set<Integer> mActiveAudioPlaybackClientUids = new HashSet<Integer>();
    private final IntArray mSortedAudioPlaybackClientUids = new IntArray();

    AudioPlaybackMonitor(Context context, IAudioService audioService, OnAudioPlaybackStartedListener listener) {
        this.mContext = context;
        this.mListener = listener;
        try {
            audioService.registerPlaybackCallback(this);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failed to register playback callback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs) {
        long token = Binder.clearCallingIdentity();
        try {
            HashSet<Integer> newActiveAudioPlaybackPlayerInterfaceIds = new HashSet<Integer>();
            ArrayList<Integer> newActiveAudioPlaybackClientUids = new ArrayList<Integer>();
            Iterator iterator = this.mLock;
            synchronized (iterator) {
                this.mActiveAudioPlaybackClientUids.clear();
                for (AudioPlaybackConfiguration config : configs) {
                    if (!config.isActive() || config.getPlayerType() == 3) continue;
                    this.mActiveAudioPlaybackClientUids.add(config.getClientUid());
                    newActiveAudioPlaybackPlayerInterfaceIds.add(config.getPlayerInterfaceId());
                    if (this.mActiveAudioPlaybackPlayerInterfaceIds.contains(config.getPlayerInterfaceId())) continue;
                    if (DEBUG) {
                        Log.d(TAG, "Found a new active media playback. " + AudioPlaybackConfiguration.toLogFriendlyString(config));
                    }
                    newActiveAudioPlaybackClientUids.add(config.getClientUid());
                    int index = this.mSortedAudioPlaybackClientUids.indexOf(config.getClientUid());
                    if (index == 0) continue;
                    if (index > 0) {
                        this.mSortedAudioPlaybackClientUids.remove(index);
                    }
                    this.mSortedAudioPlaybackClientUids.add(0, config.getClientUid());
                }
                this.mActiveAudioPlaybackPlayerInterfaceIds.clear();
                this.mActiveAudioPlaybackPlayerInterfaceIds = newActiveAudioPlaybackPlayerInterfaceIds;
            }
            iterator = newActiveAudioPlaybackClientUids.iterator();
            while (iterator.hasNext()) {
                int uid = (Integer)iterator.next();
                this.mListener.onAudioPlaybackStarted(uid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntArray getSortedAudioPlaybackClientUids() {
        IntArray sortedAudioPlaybackClientUids = new IntArray();
        Object object = this.mLock;
        synchronized (object) {
            sortedAudioPlaybackClientUids.addAll(this.mSortedAudioPlaybackClientUids);
        }
        return sortedAudioPlaybackClientUids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveAudioPlaybackClientUids.contains(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpAudioPlaybackUids(int mediaButtonSessionUid) {
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getUserId(mediaButtonSessionUid);
            for (int i = this.mSortedAudioPlaybackClientUids.size() - 1; i >= 0 && this.mSortedAudioPlaybackClientUids.get(i) != mediaButtonSessionUid; --i) {
                if (userId != UserHandle.getUserId(this.mSortedAudioPlaybackClientUids.get(i))) continue;
                this.mSortedAudioPlaybackClientUids.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + "Audio playback (lastly played comes first)");
            String indent = prefix + "  ";
            for (int i = 0; i < this.mSortedAudioPlaybackClientUids.size(); ++i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                pw.print(indent + "uid=" + uid + " packages=");
                String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
                if (packages != null && packages.length > 0) {
                    for (int j = 0; j < packages.length; ++j) {
                        pw.print(packages[j] + " ");
                    }
                }
                pw.println();
            }
        }
    }

    static interface OnAudioPlaybackStartedListener {
        public void onAudioPlaybackStarted(int var1);
    }
}

