/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

public class RateEstimator {
    private static final double RATE_ALPHA = 0.8;
    private static final double MINIMUM_DT = 5.0E-4;
    private Long mLastEventTime;
    private double mInterarrivalTime = 1000.0;

    public float update(long now) {
        float rate;
        if (this.mLastEventTime == null) {
            rate = 0.0f;
        } else {
            this.mInterarrivalTime = this.getInterarrivalEstimate(now);
            rate = (float)(1.0 / this.mInterarrivalTime);
        }
        this.mLastEventTime = now;
        return rate;
    }

    public float getRate(long now) {
        if (this.mLastEventTime == null) {
            return 0.0f;
        }
        return (float)(1.0 / this.getInterarrivalEstimate(now));
    }

    private double getInterarrivalEstimate(long now) {
        double dt = (double)(now - this.mLastEventTime) / 1000.0;
        dt = Math.max(dt, 5.0E-4);
        return 0.8 * this.mInterarrivalTime + 0.19999999999999996 * dt;
    }
}

