/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.app.AlertDialog;
import android.app.Dialog;
import android.app.IActivityManager;
import android.app.ProgressDialog;
import android.bluetooth.IBluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioAttributes;
import android.nfc.INfcAdapter;
import android.os.FileUtils;
import android.os.Handler;
import android.os.PowerManager;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemVibrator;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IStorageManager;
import android.os.storage.IStorageShutdownObserver;
import android.util.Log;
import com.android.internal.telephony.ITelephony;
import com.android.server.pm.PackageManagerService;
import com.android.server.power.PowerManagerService;
import java.io.File;
import java.io.IOException;

public final class ShutdownThread
extends Thread {
    private static final String TAG = "ShutdownThread";
    private static final int PHONE_STATE_POLL_SLEEP_MSEC = 500;
    private static final int MAX_BROADCAST_TIME = 10000;
    private static final int MAX_SHUTDOWN_WAIT_TIME = 20000;
    private static final int MAX_RADIO_WAIT_TIME = 12000;
    private static final int MAX_UNCRYPT_WAIT_TIME = 900000;
    private static final int BROADCAST_STOP_PERCENT = 2;
    private static final int ACTIVITY_MANAGER_STOP_PERCENT = 4;
    private static final int PACKAGE_MANAGER_STOP_PERCENT = 6;
    private static final int RADIO_STOP_PERCENT = 18;
    private static final int MOUNT_SERVICE_STOP_PERCENT = 20;
    private static final int SHUTDOWN_VIBRATE_MS = 500;
    private static final Object sIsStartedGuard = new Object();
    private static boolean sIsStarted = false;
    private static boolean mReboot;
    private static boolean mRebootSafeMode;
    private static boolean mRebootHasProgressBar;
    private static String mReason;
    public static final String SHUTDOWN_ACTION_PROPERTY = "sys.shutdown.requested";
    public static final String REBOOT_SAFEMODE_PROPERTY = "persist.sys.safemode";
    public static final String RO_SAFEMODE_PROPERTY = "ro.sys.safemode";
    private static final ShutdownThread sInstance;
    private static final AudioAttributes VIBRATION_ATTRIBUTES;
    private final Object mActionDoneSync = new Object();
    private boolean mActionDone;
    private Context mContext;
    private PowerManager mPowerManager;
    private PowerManager.WakeLock mCpuWakeLock;
    private PowerManager.WakeLock mScreenWakeLock;
    private Handler mHandler;
    private static AlertDialog sConfirmDialog;
    private ProgressDialog mProgressDialog;

    private ShutdownThread() {
    }

    public static void shutdown(Context context, String reason, boolean confirm) {
        mReboot = false;
        mRebootSafeMode = false;
        mReason = reason;
        ShutdownThread.shutdownInner(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdownInner(final Context context, boolean confirm) {
        context.assertRuntimeOverlayThemable();
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Request to shutdown already running, returning.");
                return;
            }
        }
        int longPressBehavior = context.getResources().getInteger(17694799);
        int resourceId = mRebootSafeMode ? 17040659 : (longPressBehavior == 2 ? 17040782 : 17040781);
        Log.d(TAG, "Notifying thread to start shutdown longPressBehavior=" + longPressBehavior);
        if (confirm) {
            CloseDialogReceiver closer = new CloseDialogReceiver(context);
            if (sConfirmDialog != null) {
                sConfirmDialog.dismiss();
            }
            sConfirmDialog = new AlertDialog.Builder(context).setTitle(mRebootSafeMode ? 17040660 : 17040644).setMessage(resourceId).setPositiveButton(17039379, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    ShutdownThread.beginShutdownSequence(context);
                }
            }).setNegativeButton(17039369, null).create();
            closer.dialog = sConfirmDialog;
            sConfirmDialog.setOnDismissListener(closer);
            sConfirmDialog.getWindow().setType(2009);
            sConfirmDialog.show();
        } else {
            ShutdownThread.beginShutdownSequence(context);
        }
    }

    public static void reboot(Context context, String reason, boolean confirm) {
        mReboot = true;
        mRebootSafeMode = false;
        mRebootHasProgressBar = false;
        mReason = reason;
        ShutdownThread.shutdownInner(context, confirm);
    }

    public static void rebootSafeMode(Context context, boolean confirm) {
        UserManager um = (UserManager)context.getSystemService("user");
        if (um.hasUserRestriction("no_safe_boot")) {
            return;
        }
        mReboot = true;
        mRebootSafeMode = true;
        mRebootHasProgressBar = false;
        mReason = null;
        ShutdownThread.shutdownInner(context, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void beginShutdownSequence(Context context) {
        Object object = sIsStartedGuard;
        synchronized (object) {
            if (sIsStarted) {
                Log.d(TAG, "Shutdown sequence already running, returning.");
                return;
            }
            sIsStarted = true;
        }
        ProgressDialog pd = new ProgressDialog(context);
        if (mReason != null && mReason.startsWith("recovery-update")) {
            mRebootHasProgressBar = RecoverySystem.UNCRYPT_PACKAGE_FILE.exists() && !RecoverySystem.BLOCK_MAP_FILE.exists();
            pd.setTitle(context.getText(17040666));
            if (mRebootHasProgressBar) {
                pd.setMax(100);
                pd.setProgress(0);
                pd.setIndeterminate(false);
                pd.setProgressNumberFormat(null);
                pd.setProgressStyle(1);
                pd.setMessage(context.getText(17040664));
            } else {
                pd.setIndeterminate(true);
                pd.setMessage(context.getText(17040665));
            }
        } else if (mReason != null && mReason.equals("recovery")) {
            pd.setTitle(context.getText(17040662));
            pd.setMessage(context.getText(17040661));
            pd.setIndeterminate(true);
        } else {
            pd.setTitle(context.getText(17040644));
            pd.setMessage(context.getText(17040783));
            pd.setIndeterminate(true);
        }
        pd.setCancelable(false);
        pd.getWindow().setType(2009);
        pd.show();
        ShutdownThread.sInstance.mProgressDialog = pd;
        ShutdownThread.sInstance.mContext = context;
        ShutdownThread.sInstance.mPowerManager = (PowerManager)context.getSystemService("power");
        ShutdownThread.sInstance.mCpuWakeLock = null;
        try {
            ShutdownThread.sInstance.mCpuWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(1, "ShutdownThread-cpu");
            ShutdownThread.sInstance.mCpuWakeLock.setReferenceCounted(false);
            ShutdownThread.sInstance.mCpuWakeLock.acquire();
        }
        catch (SecurityException e) {
            Log.w(TAG, "No permission to acquire wake lock", e);
            ShutdownThread.sInstance.mCpuWakeLock = null;
        }
        ShutdownThread.sInstance.mScreenWakeLock = null;
        if (ShutdownThread.sInstance.mPowerManager.isScreenOn()) {
            try {
                ShutdownThread.sInstance.mScreenWakeLock = ShutdownThread.sInstance.mPowerManager.newWakeLock(26, "ShutdownThread-screen");
                ShutdownThread.sInstance.mScreenWakeLock.setReferenceCounted(false);
                ShutdownThread.sInstance.mScreenWakeLock.acquire();
            }
            catch (SecurityException e) {
                Log.w(TAG, "No permission to acquire wake lock", e);
                ShutdownThread.sInstance.mScreenWakeLock = null;
            }
        }
        ShutdownThread.sInstance.mHandler = new Handler(){};
        sInstance.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void actionDone() {
        Object object = this.mActionDoneSync;
        synchronized (object) {
            this.mActionDone = true;
            this.mActionDoneSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BroadcastReceiver br = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                ShutdownThread.this.actionDone();
            }
        };
        String reason = (mReboot ? "1" : "0") + (mReason != null ? mReason : "");
        SystemProperties.set(SHUTDOWN_ACTION_PROPERTY, reason);
        if (mRebootSafeMode) {
            SystemProperties.set(REBOOT_SAFEMODE_PROPERTY, "1");
        }
        Log.i(TAG, "Sending shutdown broadcast...");
        this.mActionDone = false;
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x11000000);
        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, null, br, this.mHandler, 0, null, null);
        long endTime = SystemClock.elapsedRealtime() + 10000L;
        Object object = this.mActionDoneSync;
        // MONITORENTER : object
        while (!this.mActionDone) {
            long delay = endTime - SystemClock.elapsedRealtime();
            if (delay <= 0L) {
                Log.w(TAG, "Shutdown broadcast timed out");
                break;
            }
            if (mRebootHasProgressBar) {
                int status = (int)((double)(10000L - delay) * 1.0 * 2.0 / 10000.0);
                sInstance.setRebootProgress(status, null);
            }
            try {
                this.mActionDoneSync.wait(Math.min(delay, 500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        // MONITOREXIT : object
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(2, null);
        }
        Log.i(TAG, "Shutting down activity manager...");
        IActivityManager am = IActivityManager.Stub.asInterface(ServiceManager.checkService("activity"));
        if (am != null) {
            try {
                am.shutdown(10000);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(4, null);
        }
        Log.i(TAG, "Shutting down package manager...");
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm != null) {
            pm.shutdown();
        }
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(6, null);
        }
        this.shutdownRadios(12000);
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(18, null);
        }
        IStorageShutdownObserver.Stub observer = new IStorageShutdownObserver.Stub(){

            @Override
            public void onShutDownComplete(int statusCode) throws RemoteException {
                Log.w(ShutdownThread.TAG, "Result code " + statusCode + " from StorageManagerService.shutdown");
                ShutdownThread.this.actionDone();
            }
        };
        Log.i(TAG, "Shutting down StorageManagerService");
        this.mActionDone = false;
        long endShutTime = SystemClock.elapsedRealtime() + 20000L;
        Object object2 = this.mActionDoneSync;
        // MONITORENTER : object2
        try {
            IStorageManager storageManager = IStorageManager.Stub.asInterface(ServiceManager.checkService("mount"));
            if (storageManager != null) {
                storageManager.shutdown(observer);
            } else {
                Log.w(TAG, "StorageManagerService unavailable for shutdown");
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Exception during StorageManagerService shutdown", e);
        }
        while (!this.mActionDone) {
            long delay = endShutTime - SystemClock.elapsedRealtime();
            if (delay <= 0L) {
                Log.w(TAG, "Shutdown wait timed out");
                break;
            }
            if (mRebootHasProgressBar) {
                int status = (int)((double)(20000L - delay) * 1.0 * 2.0 / 20000.0);
                sInstance.setRebootProgress(status += 18, null);
            }
            try {
                this.mActionDoneSync.wait(Math.min(delay, 500L));
            }
            catch (InterruptedException interruptedException) {}
        }
        // MONITOREXIT : object2
        if (mRebootHasProgressBar) {
            sInstance.setRebootProgress(20, null);
            this.uncrypt();
        }
        ShutdownThread.rebootOrShutdown(this.mContext, mReboot, mReason);
    }

    private void setRebootProgress(final int progress, final CharSequence message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ShutdownThread.this.mProgressDialog != null) {
                    ShutdownThread.this.mProgressDialog.setProgress(progress);
                    if (message != null) {
                        ShutdownThread.this.mProgressDialog.setMessage(message);
                    }
                }
            }
        });
    }

    private void shutdownRadios(final int timeout) {
        final long endTime = SystemClock.elapsedRealtime() + (long)timeout;
        final boolean[] done = new boolean[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                boolean radioOff;
                boolean bluetoothOff;
                boolean nfcOff;
                INfcAdapter nfc = INfcAdapter.Stub.asInterface(ServiceManager.checkService("nfc"));
                ITelephony phone = ITelephony.Stub.asInterface(ServiceManager.checkService("phone"));
                IBluetoothManager bluetooth = IBluetoothManager.Stub.asInterface(ServiceManager.checkService("bluetooth_manager"));
                try {
                    boolean bl = nfcOff = nfc == null || nfc.getState() == 1;
                    if (!nfcOff) {
                        Log.w(ShutdownThread.TAG, "Turning off NFC...");
                        nfc.disable(false);
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during NFC shutdown", ex);
                    nfcOff = true;
                }
                try {
                    boolean bl = bluetoothOff = bluetooth == null || bluetooth.getState() == 10;
                    if (!bluetoothOff) {
                        Log.w(ShutdownThread.TAG, "Disabling Bluetooth...");
                        bluetooth.disable(ShutdownThread.this.mContext.getPackageName(), false);
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during bluetooth shutdown", ex);
                    bluetoothOff = true;
                }
                try {
                    boolean bl = radioOff = phone == null || !phone.needMobileRadioShutdown();
                    if (!radioOff) {
                        Log.w(ShutdownThread.TAG, "Turning off cellular radios...");
                        phone.shutdownMobileRadios();
                    }
                }
                catch (RemoteException ex) {
                    Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                    radioOff = true;
                }
                Log.i(ShutdownThread.TAG, "Waiting for NFC, Bluetooth and Radio...");
                long delay = endTime - SystemClock.elapsedRealtime();
                while (delay > 0L) {
                    if (mRebootHasProgressBar) {
                        int status = (int)((double)((long)timeout - delay) * 1.0 * 12.0 / (double)timeout);
                        sInstance.setRebootProgress(status += 6, null);
                    }
                    if (!bluetoothOff) {
                        try {
                            bluetoothOff = bluetooth.getState() == 10;
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during bluetooth shutdown", ex);
                            bluetoothOff = true;
                        }
                        if (bluetoothOff) {
                            Log.i(ShutdownThread.TAG, "Bluetooth turned off.");
                        }
                    }
                    if (!radioOff) {
                        try {
                            radioOff = !phone.needMobileRadioShutdown();
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during radio shutdown", ex);
                            radioOff = true;
                        }
                        if (radioOff) {
                            Log.i(ShutdownThread.TAG, "Radio turned off.");
                        }
                    }
                    if (!nfcOff) {
                        try {
                            nfcOff = nfc.getState() == 1;
                        }
                        catch (RemoteException ex) {
                            Log.e(ShutdownThread.TAG, "RemoteException during NFC shutdown", ex);
                            nfcOff = true;
                        }
                        if (nfcOff) {
                            Log.i(ShutdownThread.TAG, "NFC turned off.");
                        }
                    }
                    if (radioOff && bluetoothOff && nfcOff) {
                        Log.i(ShutdownThread.TAG, "NFC, Radio and Bluetooth shutdown complete.");
                        done[0] = true;
                        break;
                    }
                    SystemClock.sleep(500L);
                    delay = endTime - SystemClock.elapsedRealtime();
                }
            }
        };
        t.start();
        try {
            t.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!done[0]) {
            Log.w(TAG, "Timed out waiting for NFC, Radio and Bluetooth shutdown.");
        }
    }

    public static void rebootOrShutdown(Context context, boolean reboot, String reason) {
        if (reboot) {
            Log.i(TAG, "Rebooting, reason: " + reason);
            PowerManagerService.lowLevelReboot(reason);
            Log.e(TAG, "Reboot failed, will attempt shutdown instead");
            reason = null;
        } else if (context != null) {
            SystemVibrator vibrator = new SystemVibrator(context);
            try {
                vibrator.vibrate(500L, VIBRATION_ATTRIBUTES);
            }
            catch (Exception e) {
                Log.w(TAG, "Failed to vibrate during shutdown.", e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Log.i(TAG, "Performing low-level shutdown...");
        PowerManagerService.lowLevelShutdown(reason);
    }

    private void uncrypt() {
        Log.i(TAG, "Calling uncrypt and monitoring the progress...");
        final RecoverySystem.ProgressListener progressListener = new RecoverySystem.ProgressListener(){

            @Override
            public void onProgress(int status) {
                if (status >= 0 && status < 100) {
                    status = (int)((double)status * 80.0 / 100.0);
                    CharSequence msg = ShutdownThread.this.mContext.getText(17040663);
                    sInstance.setRebootProgress(status += 20, msg);
                } else if (status == 100) {
                    CharSequence msg = ShutdownThread.this.mContext.getText(17040665);
                    sInstance.setRebootProgress(status, msg);
                }
            }
        };
        final boolean[] done = new boolean[]{false};
        Thread t = new Thread(){

            @Override
            public void run() {
                RecoverySystem rs = (RecoverySystem)ShutdownThread.this.mContext.getSystemService("recovery");
                String filename = null;
                try {
                    filename = FileUtils.readTextFile(RecoverySystem.UNCRYPT_PACKAGE_FILE, 0, null);
                    RecoverySystem.processPackage(ShutdownThread.this.mContext, new File(filename), progressListener);
                }
                catch (IOException e) {
                    Log.e(ShutdownThread.TAG, "Error uncrypting file", e);
                }
                done[0] = true;
            }
        };
        t.start();
        try {
            t.join(900000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!done[0]) {
            Log.w(TAG, "Timed out waiting for uncrypt.");
            int uncryptTimeoutError = 100;
            String timeoutMessage = String.format("uncrypt_time: %d\nuncrypt_error: %d\n", 900, 100);
            try {
                FileUtils.stringToFile(RecoverySystem.UNCRYPT_STATUS_FILE, timeoutMessage);
            }
            catch (IOException e) {
                Log.e(TAG, "Failed to write timeout message to uncrypt status", e);
            }
        }
    }

    static {
        sInstance = new ShutdownThread();
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    }

    private static class CloseDialogReceiver
    extends BroadcastReceiver
    implements DialogInterface.OnDismissListener {
        private Context mContext;
        public Dialog dialog;

        CloseDialogReceiver(Context context) {
            this.mContext = context;
            IntentFilter filter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
            context.registerReceiver(this, filter);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.dialog.cancel();
        }

        @Override
        public void onDismiss(DialogInterface unused) {
            this.mContext.unregisterReceiver(this);
        }
    }
}

