/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.app.RemoteAction;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Size;
import android.util.Slog;
import android.util.TypedValue;
import android.view.DisplayInfo;
import android.view.Gravity;
import android.view.IPinnedStackController;
import android.view.IPinnedStackListener;
import com.android.internal.policy.PipSnapAlgorithm;
import com.android.server.UiThread;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowHashMap;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

class PinnedStackController {
    private static final String TAG = "WindowManager";
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final Handler mHandler = UiThread.getHandler();
    private IPinnedStackListener mPinnedStackListener;
    private final PinnedStackListenerDeathHandler mPinnedStackListenerDeathHandler = new PinnedStackListenerDeathHandler();
    private final PinnedStackControllerCallback mCallbacks = new PinnedStackControllerCallback();
    private final PipSnapAlgorithm mSnapAlgorithm;
    private boolean mIsMinimized;
    private boolean mIsImeShowing;
    private int mImeHeight;
    private ArrayList<RemoteAction> mActions = new ArrayList();
    private float mAspectRatio = -1.0f;
    private final DisplayInfo mDisplayInfo = new DisplayInfo();
    private final Rect mStableInsets = new Rect();
    private int mDefaultMinSize;
    private int mDefaultStackGravity;
    private float mDefaultAspectRatio;
    private Point mScreenEdgeInsets;
    private int mCurrentMinSize;
    private float mMinAspectRatio;
    private float mMaxAspectRatio;
    private final DisplayMetrics mTmpMetrics = new DisplayMetrics();
    private final Rect mTmpInsets = new Rect();
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpAnimatingBoundsRect = new Rect();
    private final Point mTmpDisplaySize = new Point();

    PinnedStackController(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
        this.mSnapAlgorithm = new PipSnapAlgorithm(service.mContext);
        this.mDisplayInfo.copyFrom(this.mDisplayContent.getDisplayInfo());
        this.reloadResources();
        this.mAspectRatio = this.mDefaultAspectRatio;
    }

    void onConfigurationChanged() {
        this.reloadResources();
    }

    private void reloadResources() {
        Resources res = this.mService.mContext.getResources();
        this.mCurrentMinSize = this.mDefaultMinSize = res.getDimensionPixelSize(17104997);
        this.mDefaultAspectRatio = res.getFloat(17104953);
        String screenEdgeInsetsDpString = res.getString(17039643);
        Size screenEdgeInsetsDp = !screenEdgeInsetsDpString.isEmpty() ? Size.parseSize(screenEdgeInsetsDpString) : null;
        this.mDefaultStackGravity = res.getInteger(17694768);
        this.mDisplayContent.getDisplay().getRealMetrics(this.mTmpMetrics);
        this.mScreenEdgeInsets = screenEdgeInsetsDp == null ? new Point() : new Point(this.dpToPx(screenEdgeInsetsDp.getWidth(), this.mTmpMetrics), this.dpToPx(screenEdgeInsetsDp.getHeight(), this.mTmpMetrics));
        this.mMinAspectRatio = res.getFloat(17104956);
        this.mMaxAspectRatio = res.getFloat(17104955);
    }

    void registerPinnedStackListener(IPinnedStackListener listener) {
        try {
            listener.asBinder().linkToDeath(this.mPinnedStackListenerDeathHandler, 0);
            listener.onListenerRegistered(this.mCallbacks);
            this.mPinnedStackListener = listener;
            this.notifyImeVisibilityChanged(this.mIsImeShowing, this.mImeHeight);
            this.notifyMovementBoundsChanged(false);
            this.notifyActionsChanged(this.mActions);
            this.notifyMinimizeChanged(this.mIsMinimized);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failed to register pinned stack listener", e);
        }
    }

    public boolean isValidPictureInPictureAspectRatio(float aspectRatio) {
        return Float.compare(this.mMinAspectRatio, aspectRatio) <= 0 && Float.compare(aspectRatio, this.mMaxAspectRatio) <= 0;
    }

    Rect transformBoundsToAspectRatio(Rect stackBounds, float aspectRatio, boolean useCurrentMinEdgeSize) {
        float snapFraction = this.mSnapAlgorithm.getSnapFraction(stackBounds, this.getMovementBounds(stackBounds));
        int minEdgeSize = useCurrentMinEdgeSize ? this.mCurrentMinSize : this.mDefaultMinSize;
        Size size = this.mSnapAlgorithm.getSizeForAspectRatio(aspectRatio, minEdgeSize, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
        int left = (int)((float)stackBounds.centerX() - (float)size.getWidth() / 2.0f);
        int top = (int)((float)stackBounds.centerY() - (float)size.getHeight() / 2.0f);
        stackBounds.set(left, top, left + size.getWidth(), top + size.getHeight());
        this.mSnapAlgorithm.applySnapFraction(stackBounds, this.getMovementBounds(stackBounds), snapFraction);
        if (this.mIsMinimized) {
            this.applyMinimizedOffset(stackBounds, this.getMovementBounds(stackBounds));
        }
        return stackBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Rect getDefaultBounds() {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            Rect insetBounds = new Rect();
            this.getInsetBounds(insetBounds);
            Rect defaultBounds = new Rect();
            Size size = this.mSnapAlgorithm.getSizeForAspectRatio(this.mDefaultAspectRatio, this.mDefaultMinSize, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
            Gravity.apply(this.mDefaultStackGravity, size.getWidth(), size.getHeight(), insetBounds, 0, this.mIsImeShowing ? this.mImeHeight : 0, defaultBounds);
            return defaultBounds;
        }
    }

    synchronized void onDisplayInfoChanged() {
        this.mDisplayInfo.copyFrom(this.mDisplayContent.getDisplayInfo());
        this.notifyMovementBoundsChanged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onTaskStackBoundsChanged(Rect targetBounds, Rect outBounds) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            DisplayInfo displayInfo = this.mDisplayContent.getDisplayInfo();
            if (this.mDisplayInfo.equals(displayInfo)) {
                outBounds.setEmpty();
                return false;
            }
            if (targetBounds.isEmpty()) {
                this.mDisplayInfo.copyFrom(displayInfo);
                outBounds.setEmpty();
                return false;
            }
            this.mTmpRect.set(targetBounds);
            Rect postChangeStackBounds = this.mTmpRect;
            Rect preChangeMovementBounds = this.getMovementBounds(postChangeStackBounds);
            float snapFraction = this.mSnapAlgorithm.getSnapFraction(postChangeStackBounds, preChangeMovementBounds);
            this.mDisplayInfo.copyFrom(displayInfo);
            Rect postChangeMovementBounds = this.getMovementBounds(postChangeStackBounds, false);
            this.mSnapAlgorithm.applySnapFraction(postChangeStackBounds, postChangeMovementBounds, snapFraction);
            if (this.mIsMinimized) {
                this.applyMinimizedOffset(postChangeStackBounds, postChangeMovementBounds);
            }
            this.notifyMovementBoundsChanged(false);
            outBounds.set(postChangeStackBounds);
            return true;
        }
    }

    void setAdjustedForIme(boolean adjustedForIme, int imeHeight) {
        if (this.mIsImeShowing == adjustedForIme && this.mImeHeight == imeHeight) {
            return;
        }
        this.mIsImeShowing = adjustedForIme;
        this.mImeHeight = imeHeight;
        this.notifyImeVisibilityChanged(adjustedForIme, imeHeight);
        this.notifyMovementBoundsChanged(true);
    }

    void setAspectRatio(float aspectRatio) {
        if (Float.compare(this.mAspectRatio, aspectRatio) != 0) {
            this.mAspectRatio = aspectRatio;
            this.notifyMovementBoundsChanged(false);
        }
    }

    float getAspectRatio() {
        return this.mAspectRatio;
    }

    void setActions(List<RemoteAction> actions) {
        this.mActions.clear();
        if (actions != null) {
            this.mActions.addAll(actions);
        }
        this.notifyActionsChanged(this.mActions);
    }

    private void notifyImeVisibilityChanged(boolean imeVisible, int imeHeight) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onImeVisibilityChanged(imeVisible, imeHeight);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering bounds changed event.", e);
            }
        }
    }

    private void notifyMinimizeChanged(boolean isMinimized) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onMinimizedStateChanged(isMinimized);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering minimize changed event.", e);
            }
        }
    }

    private void notifyActionsChanged(List<RemoteAction> actions) {
        if (this.mPinnedStackListener != null) {
            try {
                this.mPinnedStackListener.onActionsChanged(new ParceledListSlice<RemoteAction>(actions));
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error delivering actions changed event.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyMovementBoundsChanged(boolean fromImeAdjustement) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            if (this.mPinnedStackListener != null) {
                try {
                    Rect insetBounds = new Rect();
                    this.getInsetBounds(insetBounds);
                    Rect normalBounds = this.getDefaultBounds();
                    if (this.isValidPictureInPictureAspectRatio(this.mAspectRatio)) {
                        this.transformBoundsToAspectRatio(normalBounds, this.mAspectRatio, false);
                    }
                    Rect animatingBounds = this.mTmpAnimatingBoundsRect;
                    TaskStack pinnedStack = this.mDisplayContent.getStackById(4);
                    if (pinnedStack != null) {
                        pinnedStack.getAnimationOrCurrentBounds(animatingBounds);
                    } else {
                        animatingBounds.set(normalBounds);
                    }
                    this.mPinnedStackListener.onMovementBoundsChanged(insetBounds, normalBounds, animatingBounds, fromImeAdjustement, this.mDisplayInfo.rotation);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Error delivering actions changed event.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInsetBounds(Rect outRect) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            this.mService.mPolicy.getStableInsetsLw(this.mDisplayInfo.rotation, this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight, this.mTmpInsets);
            outRect.set(this.mTmpInsets.left + this.mScreenEdgeInsets.x, this.mTmpInsets.top + this.mScreenEdgeInsets.y, this.mDisplayInfo.logicalWidth - this.mTmpInsets.right - this.mScreenEdgeInsets.x, this.mDisplayInfo.logicalHeight - this.mTmpInsets.bottom - this.mScreenEdgeInsets.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rect getMovementBounds(Rect stackBounds) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            return this.getMovementBounds(stackBounds, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rect getMovementBounds(Rect stackBounds, boolean adjustForIme) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            Rect movementBounds = new Rect();
            this.getInsetBounds(movementBounds);
            this.mSnapAlgorithm.getMovementBounds(stackBounds, movementBounds, movementBounds, adjustForIme && this.mIsImeShowing ? this.mImeHeight : 0);
            return movementBounds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyMinimizedOffset(Rect stackBounds, Rect movementBounds) {
        WindowHashMap windowHashMap = this.mService.mWindowMap;
        synchronized (windowHashMap) {
            this.mTmpDisplaySize.set(this.mDisplayInfo.logicalWidth, this.mDisplayInfo.logicalHeight);
            this.mService.getStableInsetsLocked(this.mDisplayContent.getDisplayId(), this.mStableInsets);
            this.mSnapAlgorithm.applyMinimizedOffset(stackBounds, movementBounds, this.mTmpDisplaySize, this.mStableInsets);
        }
    }

    private int dpToPx(float dpValue, DisplayMetrics dm) {
        return (int)TypedValue.applyDimension(1, dpValue, dm);
    }

    void dump(String prefix, PrintWriter pw) {
        pw.println(prefix + "PinnedStackController");
        pw.print(prefix + "  defaultBounds=");
        this.getDefaultBounds().printShortString(pw);
        pw.println();
        this.mService.getStackBounds(4, this.mTmpRect);
        pw.print(prefix + "  movementBounds=");
        this.getMovementBounds(this.mTmpRect).printShortString(pw);
        pw.println();
        pw.println(prefix + "  mIsImeShowing=" + this.mIsImeShowing);
        pw.println(prefix + "  mIsMinimized=" + this.mIsMinimized);
        if (this.mActions.isEmpty()) {
            pw.println(prefix + "  mActions=[]");
        } else {
            pw.println(prefix + "  mActions=[");
            for (int i = 0; i < this.mActions.size(); ++i) {
                RemoteAction action = this.mActions.get(i);
                pw.print(prefix + "    Action[" + i + "]: ");
                action.dump("", pw);
            }
            pw.println(prefix + "  ]");
        }
    }

    private class PinnedStackListenerDeathHandler
    implements IBinder.DeathRecipient {
        private PinnedStackListenerDeathHandler() {
        }

        @Override
        public void binderDied() {
            PinnedStackController.this.mPinnedStackListener = null;
        }
    }

    private class PinnedStackControllerCallback
    extends IPinnedStackController.Stub {
        private PinnedStackControllerCallback() {
        }

        @Override
        public void setIsMinimized(boolean isMinimized) {
            PinnedStackController.this.mHandler.post(() -> {
                PinnedStackController.this.mIsMinimized = isMinimized;
                PinnedStackController.this.mSnapAlgorithm.setMinimized(isMinimized);
            });
        }

        @Override
        public void setMinEdgeSize(int minEdgeSize) {
            PinnedStackController.this.mHandler.post(() -> PinnedStackController.this.mCurrentMinSize = Math.max(PinnedStackController.this.mDefaultMinSize, minEdgeSize));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDisplayRotation() {
            WindowHashMap windowHashMap = ((PinnedStackController)PinnedStackController.this).mService.mWindowMap;
            synchronized (windowHashMap) {
                return ((PinnedStackController)PinnedStackController.this).mDisplayInfo.rotation;
            }
        }
    }
}

