/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.input.InputManager;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowManagerService;

public class TaskTapPointerEventListener
implements WindowManagerPolicy.PointerEventListener {
    private final Region mTouchExcludeRegion = new Region();
    private final WindowManagerService mService;
    private final DisplayContent mDisplayContent;
    private final Rect mTmpRect = new Rect();
    private int mPointerIconType = 1;

    public TaskTapPointerEventListener(WindowManagerService service, DisplayContent displayContent) {
        this.mService = service;
        this.mDisplayContent = displayContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        switch (action & 0xFF) {
            case 0: {
                int x = (int)motionEvent.getX();
                int y = (int)motionEvent.getY();
                TaskTapPointerEventListener taskTapPointerEventListener = this;
                synchronized (taskTapPointerEventListener) {
                    if (!this.mTouchExcludeRegion.contains(x, y)) {
                        this.mService.mH.obtainMessage(31, x, y, this.mDisplayContent).sendToTarget();
                    }
                    break;
                }
            }
            case 7: {
                int x = (int)motionEvent.getX();
                int y = (int)motionEvent.getY();
                Task task = this.mDisplayContent.findTaskForResizePoint(x, y);
                int iconType = 1;
                if (task != null) {
                    task.getDimBounds(this.mTmpRect);
                    if (!this.mTmpRect.isEmpty() && !this.mTmpRect.contains(x, y)) {
                        if (x < this.mTmpRect.left) {
                            iconType = y < this.mTmpRect.top ? 1017 : (y > this.mTmpRect.bottom ? 1016 : 1014);
                        } else if (x > this.mTmpRect.right) {
                            iconType = y < this.mTmpRect.top ? 1016 : (y > this.mTmpRect.bottom ? 1017 : 1014);
                        } else if (y < this.mTmpRect.top || y > this.mTmpRect.bottom) {
                            iconType = 1015;
                        }
                    }
                }
                if (this.mPointerIconType == iconType) break;
                this.mPointerIconType = iconType;
                if (this.mPointerIconType == 1) {
                    this.mService.mH.obtainMessage(55, x, y, this.mDisplayContent).sendToTarget();
                    break;
                }
                InputManager.getInstance().setPointerIconType(this.mPointerIconType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTouchExcludeRegion(Region newRegion) {
        TaskTapPointerEventListener taskTapPointerEventListener = this;
        synchronized (taskTapPointerEventListener) {
            this.mTouchExcludeRegion.set(newRegion);
        }
    }
}

