/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.profiler.BinaryHprof;
import dalvik.system.profiler.HprofData;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BinaryHprofWriter
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int nextStringId;
    private int nextClassId;
    private int nextStackFrameId;
    private Map<String, Integer> stringToId;
    private Map<String, Integer> classNameToId;
    private Map<StackTraceElement, Integer> stackFrameToId;
    private HprofData data;
    private DataOutputStream out;

    private static final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$write(HprofData data, OutputStream outputStream) throws IOException {
        new BinaryHprofWriter(data, outputStream).write();
    }

    private void $$robo$$dalvik_system_profiler_BinaryHprofWriter$__constructor__(HprofData data, OutputStream outputStream) {
        this.nextStringId = 1;
        this.nextClassId = 1;
        this.nextStackFrameId = 1;
        this.stringToId = new HashMap<String, Integer>();
        this.classNameToId = new HashMap<String, Integer>();
        this.stackFrameToId = new HashMap<StackTraceElement, Integer>();
        this.data = data;
        this.out = new DataOutputStream(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$write() throws IOException {
        try {
            this.writeHeader(this.data.getStartMillis());
            this.writeControlSettings(this.data.getFlags(), this.data.getDepth());
            for (HprofData.ThreadEvent event : this.data.getThreadHistory()) {
                this.writeThreadEvent(event);
            }
            Set<HprofData.Sample> samples = this.data.getSamples();
            int total = 0;
            for (HprofData.Sample sample : samples) {
                total += sample.count;
                this.writeStackTrace(sample.stackTrace);
            }
            this.writeCpuSamples(total, samples);
        }
        finally {
            this.out.flush();
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeHeader(long dumpTimeInMilliseconds) throws IOException {
        this.out.writeBytes(BinaryHprof.MAGIC + "1.0.2");
        this.out.writeByte(0);
        this.out.writeInt(4);
        this.out.writeLong(dumpTimeInMilliseconds);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeControlSettings(int flags, int depth) throws IOException {
        if (depth > Short.MAX_VALUE) {
            throw new IllegalArgumentException("depth too large for binary hprof: " + depth + " > " + Short.MAX_VALUE);
        }
        this.writeRecordHeader(BinaryHprof.Tag.CONTROL_SETTINGS, 0, BinaryHprof.Tag.CONTROL_SETTINGS.maximumSize);
        this.out.writeInt(flags);
        this.out.writeShort((short)depth);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeThreadEvent(HprofData.ThreadEvent e) throws IOException {
        switch (1.$SwitchMap$dalvik$system$profiler$HprofData$ThreadEventType[e.type.ordinal()]) {
            case 1: {
                this.writeStartThread(e);
                return;
            }
            case 2: {
                this.writeStopThread(e);
                return;
            }
        }
        throw new IllegalStateException(e.type.toString());
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStartThread(HprofData.ThreadEvent e) throws IOException {
        int threadNameId = this.writeString(e.threadName);
        int groupNameId = this.writeString(e.groupName);
        int parentGroupNameId = this.writeString(e.parentGroupName);
        this.writeRecordHeader(BinaryHprof.Tag.START_THREAD, 0, BinaryHprof.Tag.START_THREAD.maximumSize);
        this.out.writeInt(e.threadId);
        this.writeId(e.objectId);
        this.out.writeInt(0);
        this.writeId(threadNameId);
        this.writeId(groupNameId);
        this.writeId(parentGroupNameId);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStopThread(HprofData.ThreadEvent e) throws IOException {
        this.writeRecordHeader(BinaryHprof.Tag.END_THREAD, 0, BinaryHprof.Tag.END_THREAD.maximumSize);
        this.out.writeInt(e.threadId);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeRecordHeader(BinaryHprof.Tag hprofTag, int timeDeltaInMicroseconds, int recordLength) throws IOException {
        String error = hprofTag.checkSize(recordLength);
        if (error != null) {
            throw new AssertionError((Object)error);
        }
        this.out.writeByte(hprofTag.tag);
        this.out.writeInt(timeDeltaInMicroseconds);
        this.out.writeInt(recordLength);
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeId(int id2) throws IOException {
        this.out.writeInt(id2);
    }

    private final int $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeString(String string2) throws IOException {
        if (string2 == null) {
            return 0;
        }
        Integer identifier = this.stringToId.get(string2);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextStringId++;
        this.stringToId.put(string2, id2);
        byte[] bytes = string2.getBytes("UTF-8");
        this.writeRecordHeader(BinaryHprof.Tag.STRING_IN_UTF8, 0, 4 + bytes.length);
        this.out.writeInt(id2);
        this.out.write(bytes, 0, bytes.length);
        return id2;
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeCpuSamples(int totalSamples, Set<HprofData.Sample> samples) throws IOException {
        int samplesCount = samples.size();
        if (samplesCount == 0) {
            return;
        }
        this.writeRecordHeader(BinaryHprof.Tag.CPU_SAMPLES, 0, 8 + samplesCount * 8);
        this.out.writeInt(totalSamples);
        this.out.writeInt(samplesCount);
        for (HprofData.Sample sample : samples) {
            this.out.writeInt(sample.count);
            this.out.writeInt(sample.stackTrace.stackTraceId);
        }
    }

    private final void $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStackTrace(HprofData.StackTrace stackTrace) throws IOException {
        int frames = stackTrace.stackFrames.length;
        int[] stackFrameIds = new int[frames];
        for (int i = 0; i < frames; ++i) {
            stackFrameIds[i] = this.writeStackFrame(stackTrace.stackFrames[i]);
        }
        this.writeRecordHeader(BinaryHprof.Tag.STACK_TRACE, 0, 12 + frames * 4);
        this.out.writeInt(stackTrace.stackTraceId);
        this.out.writeInt(stackTrace.threadId);
        this.out.writeInt(frames);
        for (int stackFrameId : stackFrameIds) {
            this.writeId(stackFrameId);
        }
    }

    private final int $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeLoadClass(String className) throws IOException {
        Integer identifier = this.classNameToId.get(className);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextClassId++;
        this.classNameToId.put(className, id2);
        int classNameId = this.writeString(className);
        this.writeRecordHeader(BinaryHprof.Tag.LOAD_CLASS, 0, BinaryHprof.Tag.LOAD_CLASS.maximumSize);
        this.out.writeInt(id2);
        this.writeId(0);
        this.out.writeInt(0);
        this.writeId(classNameId);
        return id2;
    }

    private final int $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStackFrame(StackTraceElement stackFrame) throws IOException {
        Integer identifier = this.stackFrameToId.get(stackFrame);
        if (identifier != null) {
            return identifier;
        }
        int id2 = this.nextStackFrameId++;
        this.stackFrameToId.put(stackFrame, id2);
        int classId = this.writeLoadClass(stackFrame.getClassName());
        int methodNameId = this.writeString(stackFrame.getMethodName());
        int sourceId = this.writeString(stackFrame.getFileName());
        this.writeRecordHeader(BinaryHprof.Tag.STACK_FRAME, 0, BinaryHprof.Tag.STACK_FRAME.maximumSize);
        this.writeId(id2);
        this.writeId(methodNameId);
        this.writeId(0);
        this.writeId(sourceId);
        this.out.writeInt(classId);
        this.out.writeInt(stackFrame.getLineNumber());
        return id2;
    }

    public static void write(HprofData hprofData, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("write", $$robo$$dalvik_system_profiler_BinaryHprofWriter$write(dalvik.system.profiler.HprofData java.io.OutputStream ), 0, (HprofData)hprofData, (OutputStream)outputStream);
    }

    private void __constructor__(HprofData hprofData, OutputStream outputStream) {
        this.$$robo$$dalvik_system_profiler_BinaryHprofWriter$__constructor__(hprofData, outputStream);
    }

    private BinaryHprofWriter(HprofData hprofData, OutputStream outputStream) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$dalvik_system_profiler_BinaryHprofWriter$__constructor__(dalvik.system.profiler.HprofData java.io.OutputStream ), 0, this, hprofData, outputStream);
    }

    private void write() throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$dalvik_system_profiler_BinaryHprofWriter$write(), 0, this);
    }

    private void writeHeader(long l) throws IOException {
        InvokeDynamicSupport.bootstrap("writeHeader", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeHeader(long ), 0, this, l);
    }

    private void writeControlSettings(int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("writeControlSettings", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeControlSettings(int int ), 0, this, n, n2);
    }

    private void writeThreadEvent(HprofData.ThreadEvent threadEvent) throws IOException {
        InvokeDynamicSupport.bootstrap("writeThreadEvent", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeThreadEvent(dalvik.system.profiler.HprofData$ThreadEvent ), 0, this, threadEvent);
    }

    private void writeStartThread(HprofData.ThreadEvent threadEvent) throws IOException {
        InvokeDynamicSupport.bootstrap("writeStartThread", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStartThread(dalvik.system.profiler.HprofData$ThreadEvent ), 0, this, threadEvent);
    }

    private void writeStopThread(HprofData.ThreadEvent threadEvent) throws IOException {
        InvokeDynamicSupport.bootstrap("writeStopThread", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStopThread(dalvik.system.profiler.HprofData$ThreadEvent ), 0, this, threadEvent);
    }

    private void writeRecordHeader(BinaryHprof.Tag tag, int n, int n2) throws IOException {
        InvokeDynamicSupport.bootstrap("writeRecordHeader", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeRecordHeader(dalvik.system.profiler.BinaryHprof$Tag int int ), 0, this, tag, n, n2);
    }

    private void writeId(int n) throws IOException {
        InvokeDynamicSupport.bootstrap("writeId", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeId(int ), 0, this, n);
    }

    private int writeString(String string2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("writeString", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeString(java.lang.String ), 0, this, string2);
    }

    private void writeCpuSamples(int n, Set<HprofData.Sample> set) throws IOException {
        InvokeDynamicSupport.bootstrap("writeCpuSamples", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeCpuSamples(int java.util.Set<dalvik.system.profiler.HprofData$Sample> ), 0, this, n, set);
    }

    private void writeStackTrace(HprofData.StackTrace stackTrace) throws IOException {
        InvokeDynamicSupport.bootstrap("writeStackTrace", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStackTrace(dalvik.system.profiler.HprofData$StackTrace ), 0, this, stackTrace);
    }

    private int writeLoadClass(String string2) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("writeLoadClass", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeLoadClass(java.lang.String ), 0, this, string2);
    }

    private int writeStackFrame(StackTraceElement stackTraceElement) throws IOException {
        return (int)InvokeDynamicSupport.bootstrap("writeStackFrame", $$robo$$dalvik_system_profiler_BinaryHprofWriter$writeStackFrame(java.lang.StackTraceElement ), 0, this, stackTraceElement);
    }

    public /* synthetic */ BinaryHprofWriter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BinaryHprofWriter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

