/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import javax.sip.header.ReplyToHeader;

public final class ReplyTo
extends AddressParametersHeader
implements ReplyToHeader {
    private static final long serialVersionUID = -9103698729465531373L;

    public ReplyTo() {
        super("Reply-To");
    }

    public ReplyTo(AddressImpl address) {
        super("Reply-To");
        this.address = address;
    }

    @Override
    public String encode() {
        return this.headerName + ":" + " " + this.encodeBody() + "\r\n";
    }

    @Override
    public String encodeBody() {
        String retval = "";
        if (this.address.getAddressType() == 2) {
            retval = retval + "<";
        }
        retval = retval + this.address.encode();
        if (this.address.getAddressType() == 2) {
            retval = retval + ">";
        }
        if (!this.parameters.isEmpty()) {
            retval = retval + ";" + this.parameters.encode();
        }
        return retval;
    }

    public HostPort getHostPort() {
        return this.address.getHostPort();
    }

    @Override
    public String getDisplayName() {
        return this.address.getDisplayName();
    }
}

