/*
 * Decompiled with CFR 0.152.
 */
package libcore.icu;

import com.google.errorprone.annotations.DoNotMock;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Locale;
import libcore.icu.ICU;
import libcore.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LocaleData
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static HashMap<String, LocaleData> localeDataCache;
    public Integer firstDayOfWeek;
    public Integer minimalDaysInFirstWeek;
    public String[] amPm;
    public String[] eras;
    public String[] longMonthNames;
    public String[] shortMonthNames;
    public String[] tinyMonthNames;
    public String[] longStandAloneMonthNames;
    public String[] shortStandAloneMonthNames;
    public String[] tinyStandAloneMonthNames;
    public String[] longWeekdayNames;
    public String[] shortWeekdayNames;
    public String[] tinyWeekdayNames;
    public String[] longStandAloneWeekdayNames;
    public String[] shortStandAloneWeekdayNames;
    public String[] tinyStandAloneWeekdayNames;
    public String yesterday;
    public String today;
    public String tomorrow;
    public String fullTimeFormat;
    public String longTimeFormat;
    public String mediumTimeFormat;
    public String shortTimeFormat;
    public String fullDateFormat;
    public String longDateFormat;
    public String mediumDateFormat;
    public String shortDateFormat;
    public String narrowAm;
    public String narrowPm;
    public String timeFormat_hm;
    public String timeFormat_Hm;
    public String timeFormat_hms;
    public String timeFormat_Hms;
    public char zeroDigit;
    public char decimalSeparator;
    public char groupingSeparator;
    public char patternSeparator;
    public String percent;
    public char perMill;
    public char monetarySeparator;
    public String minusSign;
    public String exponentSeparator;
    public String infinity;
    public String NaN;
    public String currencySymbol;
    public String internationalCurrencySymbol;
    public String numberPattern;
    public String integerPattern;
    public String currencyPattern;
    public String percentPattern;

    private void $$robo$$libcore_icu_LocaleData$__constructor__() {
    }

    private static final Locale $$robo$$libcore_icu_LocaleData$mapInvalidAndNullLocales(Locale locale) {
        if (locale == null) {
            return Locale.getDefault();
        }
        if ("und".equals(locale.toLanguageTag())) {
            return Locale.ROOT;
        }
        return locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final LocaleData $$robo$$libcore_icu_LocaleData$get(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        String languageTag = locale.toLanguageTag();
        HashMap<String, LocaleData> hashMap = localeDataCache;
        synchronized (hashMap) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
        }
        LocaleData newLocaleData = LocaleData.initLocaleData(locale);
        HashMap<String, LocaleData> hashMap2 = localeDataCache;
        synchronized (hashMap2) {
            LocaleData localeData = localeDataCache.get(languageTag);
            if (localeData != null) {
                return localeData;
            }
            localeDataCache.put(languageTag, newLocaleData);
            return newLocaleData;
        }
    }

    private final String $$robo$$libcore_icu_LocaleData$toString() {
        return Objects.toString(this);
    }

    private final String $$robo$$libcore_icu_LocaleData$getDateFormat(int style2) {
        switch (style2) {
            case 3: {
                return this.shortDateFormat;
            }
            case 2: {
                return this.mediumDateFormat;
            }
            case 1: {
                return this.longDateFormat;
            }
            case 0: {
                return this.fullDateFormat;
            }
        }
        throw new AssertionError();
    }

    private final String $$robo$$libcore_icu_LocaleData$getTimeFormat(int style2) {
        switch (style2) {
            case 3: {
                if (DateFormat.is24Hour == null) {
                    return this.shortTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hm : this.timeFormat_hm;
            }
            case 2: {
                if (DateFormat.is24Hour == null) {
                    return this.mediumTimeFormat;
                }
                return DateFormat.is24Hour != false ? this.timeFormat_Hms : this.timeFormat_hms;
            }
            case 1: {
                return this.longTimeFormat;
            }
            case 0: {
                return this.fullTimeFormat;
            }
        }
        throw new AssertionError();
    }

    private static final LocaleData $$robo$$libcore_icu_LocaleData$initLocaleData(Locale locale) {
        LocaleData localeData = new LocaleData();
        if (!ICU.initLocaleDataNative(locale.toLanguageTag(), localeData)) {
            throw new AssertionError((Object)("couldn't initialize LocaleData for locale " + locale));
        }
        localeData.timeFormat_hm = ICU.getBestDateTimePattern("hm", locale);
        localeData.timeFormat_Hm = ICU.getBestDateTimePattern("Hm", locale);
        localeData.timeFormat_hms = ICU.getBestDateTimePattern("hms", locale);
        localeData.timeFormat_Hms = ICU.getBestDateTimePattern("Hms", locale);
        if (localeData.fullTimeFormat != null) {
            localeData.fullTimeFormat = localeData.fullTimeFormat.replace('v', 'z');
        }
        if (localeData.numberPattern != null) {
            localeData.integerPattern = localeData.numberPattern.replaceAll("\\.[#,]*", "");
        }
        return localeData;
    }

    static void __staticInitializer__() {
        localeDataCache = new HashMap();
        LocaleData.get(Locale.ROOT);
        LocaleData.get(Locale.US);
        LocaleData.get(Locale.getDefault());
    }

    private void __constructor__() {
        this.$$robo$$libcore_icu_LocaleData$__constructor__();
    }

    private LocaleData() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$libcore_icu_LocaleData$__constructor__(), 0, this);
    }

    public static Locale mapInvalidAndNullLocales(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("mapInvalidAndNullLocales", $$robo$$libcore_icu_LocaleData$mapInvalidAndNullLocales(java.util.Locale ), 0, (Locale)locale);
    }

    public static LocaleData get(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$libcore_icu_LocaleData$get(java.util.Locale ), 0, (Locale)locale);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$libcore_icu_LocaleData$toString(), 0, this);
    }

    public String getDateFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getDateFormat", $$robo$$libcore_icu_LocaleData$getDateFormat(int ), 0, this, n);
    }

    public String getTimeFormat(int n) {
        return InvokeDynamicSupport.bootstrap("getTimeFormat", $$robo$$libcore_icu_LocaleData$getTimeFormat(int ), 0, this, n);
    }

    private static LocaleData initLocaleData(Locale locale) {
        return InvokeDynamicSupport.bootstrapStatic("initLocaleData", $$robo$$libcore_icu_LocaleData$initLocaleData(java.util.Locale ), 0, (Locale)locale);
    }

    static {
        RobolectricInternals.classInitializing(LocaleData.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocaleData)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

